/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.wcomponents.test.selenium.driver;

import com.github.bordertech.wcomponents.test.selenium.driver.SeleniumWComponentsWebDriverFactory;
import com.github.bordertech.wcomponents.test.selenium.driver.WebDriverType;
import com.github.bordertech.wcomponents.util.ConfigurationProperties;
import com.github.bordertech.wcomponents.util.SystemException;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.DesiredCapabilities;

public class ParameterizedWebDriverType
extends WebDriverType<WebDriver> {
    private final String testClassName;

    public ParameterizedWebDriverType() {
        this.testClassName = null;
    }

    public ParameterizedWebDriverType(String testClassName) {
        this.testClassName = testClassName;
    }

    @Override
    public String getDriverTypeName() {
        return this.getDriverClassName();
    }

    @Override
    public WebDriver getDriverImplementation() {
        this.setSystemProperty();
        return SeleniumWComponentsWebDriverFactory.createBackingDriver(this.getDriverClassName());
    }

    protected void setSystemProperty() {
        Properties props = ConfigurationProperties.getTestSeleniumParameterisedDriverSysProperties();
        System.getProperties().putAll((Map<?, ?>)props);
    }

    @Override
    public DesiredCapabilities getDefaultDriverCapabilities() {
        throw new SystemException("Capabilities not supported by ParameterizedWebDriverType.");
    }

    private String getDriverClassName() {
        if (StringUtils.isNotBlank((CharSequence)this.testClassName)) {
            return ConfigurationProperties.getTestSeleniumParameterisedDriver((String)this.testClassName);
        }
        String classname = ConfigurationProperties.getTestSeleniumParameterisedDriver();
        if (StringUtils.isBlank((CharSequence)classname)) {
            throw new SystemException("No parameter defined for " + this.getClass().getName() + " expected parameter: " + "bordertech.wcomponents.test.selenium.webdriver");
        }
        return classname;
    }
}

