/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.wcomponents.test.selenium.driver;

import com.github.bordertech.wcomponents.test.selenium.SeleniumWComponentsUtil;
import com.github.bordertech.wcomponents.test.selenium.driver.SeleniumWComponentsWebDriver;
import com.github.bordertech.wcomponents.test.selenium.driver.WebDriverType;
import com.github.bordertech.wcomponents.util.SystemException;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.WebDriver;

public final class SeleniumWComponentsWebDriverFactory {
    private SeleniumWComponentsWebDriverFactory() {
    }

    public static <T extends WebDriver> SeleniumWComponentsWebDriver<T> createDriver(T backingDriver) {
        SeleniumWComponentsUtil.configureDriver(backingDriver);
        return new SeleniumWComponentsWebDriver<T>(backingDriver);
    }

    public static <T extends WebDriver> SeleniumWComponentsWebDriver<T> createDriver(WebDriverType<T> backingDriverType) {
        return SeleniumWComponentsWebDriverFactory.createDriver(backingDriverType.getDriverImplementation());
    }

    public static <T extends WebDriver> SeleniumWComponentsWebDriver<T> createDriver(String backingDriverClass) {
        WebDriver backingDriver = SeleniumWComponentsWebDriverFactory.createBackingDriver(backingDriverClass);
        return SeleniumWComponentsWebDriverFactory.createDriver(backingDriver);
    }

    public static WebDriver createBackingDriver(String backingDriverClass) {
        if (StringUtils.isBlank((CharSequence)backingDriverClass)) {
            throw new IllegalArgumentException("backingDriverClass must not be blank");
        }
        try {
            Class<?> clazz = Class.forName(backingDriverClass);
            if (!WebDriver.class.isAssignableFrom(clazz)) {
                throw new SystemException("backingDriverClass does not implement WebDriver inteface. backingDriverClass=[" + backingDriverClass + "]");
            }
            Class<?> driverClass = clazz;
            WebDriver backingDriver = (WebDriver)driverClass.newInstance();
            return backingDriver;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            throw new SystemException("Unable to create backingDriverClass by classname String. backingDriverClass=[" + backingDriverClass + "]", (Throwable)ex);
        }
    }
}

