/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.wcomponents.test.selenium.driver;

import com.github.bordertech.wcomponents.test.selenium.driver.SeleniumWComponentsWebDriver;
import com.github.bordertech.wcomponents.test.selenium.driver.SeleniumWComponentsWebDriverFactory;
import com.github.bordertech.wcomponents.test.selenium.driver.WebDriverType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.WebDriver;

public final class WebDriverCache {
    private static final Map<String, SeleniumWComponentsWebDriver> RUNNING_DRIVERS = new HashMap<String, SeleniumWComponentsWebDriver>();
    private static final List<SeleniumWComponentsWebDriver> DRIVERS_TO_DESTROY = new ArrayList<SeleniumWComponentsWebDriver>();
    private static final Map<String, List<SeleniumWComponentsWebDriver>> POOL_OF_DRIVERS = new HashMap<String, List<SeleniumWComponentsWebDriver>>();
    private static final String KEY_SEPARATOR = ":";
    private static final String DEFAULT_DRIVER_ID = "default";

    private WebDriverCache() {
    }

    public static <T extends WebDriver> SeleniumWComponentsWebDriver<T> getDriver(WebDriverType<T> driverType) {
        return WebDriverCache.getDriver(driverType, DEFAULT_DRIVER_ID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends WebDriver> SeleniumWComponentsWebDriver<T> getDriver(WebDriverType<T> driverType, String driverId) {
        if (driverType == null) {
            throw new IllegalArgumentException("driverType must not be null.");
        }
        Map<String, SeleniumWComponentsWebDriver> map = RUNNING_DRIVERS;
        synchronized (map) {
            SeleniumWComponentsWebDriver driver = RUNNING_DRIVERS.get(WebDriverCache.getKey(driverType, driverId));
            if (driver == null) {
                return WebDriverCache.createDriver(driverType, driverId);
            }
            return driver;
        }
    }

    private static <T extends WebDriver> SeleniumWComponentsWebDriver<T> createDriver(WebDriverType<T> driverType, String driverId) {
        if (driverType == null) {
            throw new IllegalArgumentException("driverType must not be null.");
        }
        SeleniumWComponentsWebDriver<T> wcompDriver = WebDriverCache.checkPoolOfDrivers(driverType);
        if (wcompDriver == null) {
            wcompDriver = SeleniumWComponentsWebDriverFactory.createDriver(driverType);
        }
        return WebDriverCache.registerDriver(driverType, wcompDriver, driverId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T extends WebDriver> SeleniumWComponentsWebDriver<T> registerDriver(WebDriverType<T> driverType, SeleniumWComponentsWebDriver<T> driver, String driverId) {
        if (driverType == null) {
            throw new IllegalArgumentException("driverType must not be null.");
        }
        if (driver == null) {
            throw new IllegalArgumentException("driver must not be null.");
        }
        String key = WebDriverCache.getKey(driverType, driverId);
        Map<String, SeleniumWComponentsWebDriver> map = RUNNING_DRIVERS;
        synchronized (map) {
            if (RUNNING_DRIVERS.get(key) != null) {
                WebDriverCache.closeDriver(driverType, driverId);
            }
            RUNNING_DRIVERS.put(key, driver);
            DRIVERS_TO_DESTROY.add(driver);
        }
        return driver;
    }

    private static void closeDriversForAllThreads() {
        WebDriverCache.closeDrivers(DRIVERS_TO_DESTROY);
        for (List<SeleniumWComponentsWebDriver> driver : POOL_OF_DRIVERS.values()) {
            if (driver == null) continue;
            WebDriverCache.closeDrivers(driver);
        }
    }

    private static void closeDrivers(Collection<SeleniumWComponentsWebDriver> drivers) {
        RuntimeException e = null;
        for (WebDriver webDriver : drivers) {
            try {
                webDriver.quit();
            }
            catch (RuntimeException ex) {
                if (e != null) continue;
                e = ex;
            }
        }
        drivers.clear();
        if (e != null) {
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeDriver(WebDriverType driverType, String driverId) {
        if (driverType == null) {
            throw new IllegalArgumentException("driverType must not be null.");
        }
        Map<String, SeleniumWComponentsWebDriver> map = RUNNING_DRIVERS;
        synchronized (map) {
            SeleniumWComponentsWebDriver driver = RUNNING_DRIVERS.get(WebDriverCache.getKey(driverType, driverId));
            if (driver != null) {
                RUNNING_DRIVERS.remove(WebDriverCache.getKey(driverType, driverId));
                DRIVERS_TO_DESTROY.remove(driver);
                driver.quit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseDriver(WebDriverType driverType, String driverId) {
        if (driverType == null) {
            throw new IllegalArgumentException("driverType must not be null.");
        }
        Map<String, SeleniumWComponentsWebDriver> map = RUNNING_DRIVERS;
        synchronized (map) {
            SeleniumWComponentsWebDriver driver = RUNNING_DRIVERS.get(WebDriverCache.getKey(driverType, driverId));
            if (driver != null) {
                RUNNING_DRIVERS.remove(WebDriverCache.getKey(driverType, driverId));
                DRIVERS_TO_DESTROY.remove(driver);
                WebDriverCache.saveDriverInPool(driverType, driver);
            }
        }
    }

    private static String getKey(WebDriverType driverType, String driverId) {
        if (driverType == null) {
            throw new IllegalArgumentException("driverType must not be null.");
        }
        if (driverId == null) {
            throw new IllegalArgumentException("driverId must not be null.");
        }
        return driverType.getDriverTypeName() + KEY_SEPARATOR + driverId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SeleniumWComponentsWebDriver checkPoolOfDrivers(WebDriverType type) {
        Map<String, List<SeleniumWComponentsWebDriver>> map = POOL_OF_DRIVERS;
        synchronized (map) {
            List<SeleniumWComponentsWebDriver> drivers = POOL_OF_DRIVERS.get(type.getDriverTypeName());
            if (drivers == null || drivers.isEmpty()) {
                return null;
            }
            SeleniumWComponentsWebDriver driver = drivers.remove(0);
            return driver;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveDriverInPool(WebDriverType type, SeleniumWComponentsWebDriver driver) {
        Map<String, List<SeleniumWComponentsWebDriver>> map = POOL_OF_DRIVERS;
        synchronized (map) {
            List<SeleniumWComponentsWebDriver> drivers = POOL_OF_DRIVERS.get(type.getDriverTypeName());
            if (drivers == null) {
                drivers = new ArrayList<SeleniumWComponentsWebDriver>();
                POOL_OF_DRIVERS.put(type.getDriverTypeName(), drivers);
            }
            drivers.add(driver);
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                WebDriverCache.closeDriversForAllThreads();
            }
        });
    }
}

