/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.wcomponents.test.selenium.element;

import com.github.bordertech.wcomponents.test.selenium.ByLabel;
import com.github.bordertech.wcomponents.test.selenium.SeleniumWComponentsUtil;
import com.github.bordertech.wcomponents.test.selenium.element.SeleniumGroupInputWebElement;
import com.github.bordertech.wcomponents.test.selenium.element.SeleniumWComponentWebElement;
import com.github.bordertech.wcomponents.util.SystemException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public abstract class SeleniumCheckableGroupInputWebElement
extends SeleniumGroupInputWebElement {
    public SeleniumCheckableGroupInputWebElement(WebElement element, WebDriver driver) {
        super(element, driver);
    }

    public List<WebElement> getOptions() {
        return this.findElementsImmediate(By.cssSelector((String)".wc-option"));
    }

    public WebElement getOption(int idx) {
        List<WebElement> options = this.getOptions();
        if (CollectionUtils.isEmpty(options)) {
            throw new SystemException("No options available");
        }
        return options.get(idx);
    }

    public WebElement getOption(String labelText) {
        List<WebElement> options = this.getOptions();
        if (CollectionUtils.isEmpty(options)) {
            throw new SystemException("No options available");
        }
        if (this.isReadOnly()) {
            for (WebElement o : options) {
                if (!labelText.equalsIgnoreCase(o.getText())) continue;
                return o;
            }
            throw new IllegalArgumentException("Could not find option identified by " + labelText);
        }
        SeleniumWComponentWebElement input = this.findElementImmediate(new ByLabel(labelText, false, true));
        return input.findElementImmediate(By.xpath((String)".."));
    }

    public WebElement getInput(int idx) {
        if (this.isReadOnly()) {
            throw new SystemException("Component in a read-only state has no interactive controls.");
        }
        SeleniumWComponentWebElement option = (SeleniumWComponentWebElement)this.getOption(idx);
        return option.findElementImmediate(By.tagName((String)this.getOptionTag()));
    }

    public WebElement getInput(String labelText) {
        if (this.isReadOnly()) {
            throw new SystemException("Component in a read-only state has no interactive controls.");
        }
        return this.findElementImmediate(new ByLabel(labelText, false, true));
    }

    public WebElement getInput(WebElement option) {
        if (this.isReadOnly()) {
            throw new SystemException("Components in a read-only state have no inputs.");
        }
        return SeleniumWComponentsUtil.findElementImmediateForElement(option, By.tagName((String)this.getOptionTag()));
    }

    public List<WebElement> getSelected() {
        List<WebElement> options = this.getOptions();
        if (this.isReadOnly()) {
            return options;
        }
        if (!this.isEnabled()) {
            return new ArrayList<WebElement>();
        }
        ArrayList<WebElement> selected = new ArrayList<WebElement>();
        for (WebElement o : options) {
            if (!this.getInput(o).isSelected()) continue;
            selected.add(o);
        }
        return selected;
    }

    public boolean isSelected(WebElement option) {
        if (this.isReadOnly()) {
            List<WebElement> options = this.getOptions();
            String optionText = option.getText();
            for (WebElement o : options) {
                if (!optionText.equals(o.getText())) continue;
                return true;
            }
            return false;
        }
        if (!this.isEnabled(option)) {
            return false;
        }
        return this.getInput(option).isSelected();
    }

    public boolean isSelected(int idx) {
        if (this.isReadOnly()) {
            return this.getOptions().size() > idx;
        }
        return this.isSelected(this.getOption(idx));
    }

    public boolean isSelected(String labelText) {
        if (this.isReadOnly()) {
            String path = ".//*[text()='" + labelText + "']";
            try {
                this.findElementImmediate(By.xpath((String)path));
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return this.isSelected(this.getOption(labelText));
    }

    public void select(WebElement option) {
        if (!this.isSelected(option)) {
            this.clickNoWait(option);
        }
    }

    public void select(String text) {
        this.select(this.getOption(text));
    }

    public void select(int idx) {
        this.select(this.getOption(idx));
    }

    public void click(WebElement option) {
        if (this.isEnabled(option)) {
            this.getInput(option).click();
        }
    }

    public void click(String labelText) {
        WebElement option = this.getOption(labelText);
        this.click(option);
    }

    public void click(int idx) {
        WebElement option = this.getOption(idx);
        this.click(option);
    }

    public void clickNoWait(WebElement option) {
        if (this.isEnabled(option)) {
            this.clickElementNoWait(this.getInput(option));
        }
    }

    public void clickNoWait(String labelText) {
        WebElement option = this.getOption(labelText);
        this.clickNoWait(option);
    }

    public void clickNoWait(int idx) {
        WebElement option = this.getOption(idx);
        this.clickNoWait(option);
    }

    private boolean isEnabled(WebElement option) {
        if (this.isReadOnly()) {
            return false;
        }
        return this.getInput(option).isEnabled();
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled(this.getOption(0));
    }
}

