/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.wcomponents.test.selenium.element;

import com.github.bordertech.wcomponents.test.selenium.SeleniumWComponentsUtil;
import com.github.bordertech.wcomponents.test.selenium.element.SeleniumWComponentWebElement;
import com.github.bordertech.wcomponents.test.selenium.element.SeleniumWComponentWebProperties;
import com.github.bordertech.wcomponents.util.Util;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class SeleniumWComponentInputWebElement
extends SeleniumWComponentWebElement {
    public static final String TOP_LEVEL_TAG = "span";
    public static final String EDITABLE_TAG = "input";

    public SeleniumWComponentInputWebElement(WebElement element, WebDriver driver) {
        super(element, driver);
    }

    public SeleniumWComponentWebElement getInputField() {
        if (this.isReadOnly()) {
            return null;
        }
        return this.findElementImmediate(By.tagName((String)EDITABLE_TAG));
    }

    public String getValue() {
        if (this.isReadOnly()) {
            return this.getText();
        }
        return this.getInputField().getAttribute(SeleniumWComponentWebProperties.ATTRIBUTE_HTML_VALUE.toString());
    }

    @Override
    public String getAttribute(String name) {
        if (SeleniumWComponentWebProperties.ATTRIBUTE_HTML_VALUE.toString().equals(name)) {
            return this.getValue();
        }
        return super.getAttribute(name);
    }

    public boolean isReadOnly() {
        return !Util.empty((String)this.getAttribute("data-wc-component"));
    }

    @Override
    public boolean isEnabled() {
        if (this.isReadOnly()) {
            return false;
        }
        return this.getInputField().isEnabled();
    }

    @Override
    public void sendKeys(CharSequence ... keys) {
        this.getInputField().sendKeys(keys);
    }

    @Override
    public void sendKeys(boolean wait, CharSequence ... keys) {
        this.getInputField().sendKeys(wait, keys);
    }

    @Override
    public void clear() {
        this.getInputField().clear();
    }

    @Override
    public String getActiveId() {
        if (this.isReadOnly()) {
            return super.getActiveId();
        }
        return this.getInputField().getAttribute("id");
    }

    @Override
    public void click() {
        if (this.isReadOnly()) {
            super.click();
        } else {
            this.getInputField().click();
        }
    }

    @Override
    public void clickNoWait() {
        if (this.isReadOnly()) {
            super.clickNoWait();
        } else {
            this.getInputField().clickNoWait();
        }
    }

    public boolean isCombo() {
        if (this.isReadOnly()) {
            return false;
        }
        return null != this.getAttribute("data-wc-suggest");
    }

    public boolean isMandatory() {
        if (this.isReadOnly()) {
            return false;
        }
        return null != this.getInputField().getAttribute("required");
    }

    public WebElement getSuggestionList() {
        if (!this.isCombo()) {
            return null;
        }
        String listId = this.getAttribute("data-wc-suggest");
        if (Util.empty((String)listId)) {
            return null;
        }
        return SeleniumWComponentsUtil.findElementImmediateForDriver(this.getDriver(), By.xpath((String)("//*[@id='" + listId + "']")));
    }
}

