/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.wcomponents.test.selenium.element;

import com.github.bordertech.wcomponents.test.selenium.element.SeleniumWComponentWebElement;
import org.openqa.selenium.By;
import org.openqa.selenium.ElementNotVisibleException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class SeleniumWDialogWebElement
extends SeleniumWComponentWebElement {
    public static final String DIALOG_TAG = "dialog";
    public static final String DIALOG_OPEN_ATTRIBUTE = "open";
    public static final String MAXIMIZE_RESTORE_CLASS = "wc_maxcont";
    public static final String CLOSE_CLASS = "wc_dialog_close";
    public static final String CONTENT_CLASS = "content";

    public static String getDialogCssSelector() {
        return DIALOG_TAG;
    }

    public static String getOpenDialogCssSelector() {
        return "dialog[open]";
    }

    public SeleniumWDialogWebElement(WebElement element, WebDriver driver) {
        super(element, driver);
        if (!element.getTagName().equals(DIALOG_TAG)) {
            throw new IllegalArgumentException("element is not a WDialog.");
        }
    }

    public SeleniumWComponentWebElement getMaximizeRestoreButton() {
        return this.findElementImmediate(By.cssSelector((String)"button.wc_maxcont"));
    }

    public SeleniumWComponentWebElement getCloseButton() {
        return this.findElementImmediate(By.cssSelector((String)"button.wc_dialog_close"));
    }

    public void close() {
        this.clickElementNoWait(this.getCloseButton());
    }

    public SeleniumWComponentWebElement getContent() {
        return this.findElementImmediate(By.cssSelector((String)".content"));
    }

    public String getHeadingText() {
        return this.getHeading().getText();
    }

    public SeleniumWComponentWebElement getHeading() {
        return this.findElementImmediate(By.cssSelector((String)"header > h1"));
    }

    public boolean isOpen() {
        try {
            String openAttribute = super.getAttribute(DIALOG_OPEN_ATTRIBUTE);
            return openAttribute != null;
        }
        catch (ElementNotVisibleException e) {
            return false;
        }
    }
}

