/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.wcomponents.test.selenium.element;

import com.github.bordertech.wcomponents.test.selenium.SeleniumWComponentsUtil;
import com.github.bordertech.wcomponents.test.selenium.element.SeleniumWComponentWebElement;
import com.github.bordertech.wcomponents.test.selenium.element.SeleniumWMessageBoxWebElement;
import com.github.bordertech.wcomponents.util.SystemException;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class SeleniumWMessagesWebElement
extends SeleniumWComponentWebElement {
    public static final String CLASS_NAME = "wc-panel";

    public SeleniumWMessagesWebElement(WebElement element, WebDriver driver) {
        super(element, driver);
        String className = element.getAttribute("class");
        if (!className.contains(CLASS_NAME)) {
            throw new SystemException("Incorrect element selected for SeleniumWMessagesWebElement. Expected className to include `wc-panel` found: " + className);
        }
    }

    public List<SeleniumWMessageBoxWebElement> getMessageBoxes() {
        WebDriver driver = this.getDriver();
        By by = By.cssSelector((String)"section");
        List<WebElement> boxes = SeleniumWComponentsUtil.findElementsImmediateForDriver(driver, by);
        ArrayList<SeleniumWMessageBoxWebElement> result = new ArrayList<SeleniumWMessageBoxWebElement>();
        for (WebElement w : boxes) {
            result.add(new SeleniumWMessageBoxWebElement(w, driver));
        }
        return result;
    }

    public SeleniumWMessageBoxWebElement getMessageBox(int index) {
        List<SeleniumWMessageBoxWebElement> boxes = this.getMessageBoxes();
        return boxes.get(index);
    }

    public SeleniumWMessageBoxWebElement getMessageBox() {
        return this.getMessageBox(0);
    }

    public WebElement getErrorBox() {
        By by = By.className((String)"wc-messagebox-type-error");
        return this.findViaDriver(by);
    }

    public WebElement getWarningBox() {
        By by = By.className((String)"wc-messagebox-type-warn");
        return this.findViaDriver(by);
    }

    public WebElement getInfoBox() {
        By by = By.className((String)"wc-messagebox-type-info");
        return this.findViaDriver(by);
    }

    public WebElement getSuccessBox() {
        By by = By.className((String)"wc-messagebox-type-success");
        return this.findViaDriver(by);
    }

    private WebElement findViaDriver(By by) {
        return SeleniumWComponentsUtil.findElementImmediateForDriver(this.getDriver(), by);
    }
}

