/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.wcomponents.test.selenium.element;

import com.github.bordertech.wcomponents.test.selenium.SeleniumWComponentsUtil;
import com.github.bordertech.wcomponents.test.selenium.element.SeleniumGroupInputWebElement;
import com.github.bordertech.wcomponents.test.selenium.element.SeleniumWComponentWebElement;
import com.github.bordertech.wcomponents.util.SystemException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.interactions.HasInputDevices;
import org.openqa.selenium.support.ui.Select;

public class SeleniumWMultiDropdownWebElement
extends SeleniumGroupInputWebElement {
    private static final Log LOG = LogFactory.getLog(SeleniumWMultiDropdownWebElement.class);
    private static final String RO_COMPONENT = "multidropdown";

    public SeleniumWMultiDropdownWebElement(WebElement element, WebDriver driver) {
        super(element, driver);
    }

    @Override
    public boolean isEnabled() {
        if (this.isReadOnly()) {
            return false;
        }
        return this.getFirstDropdown().isEnabled();
    }

    @Override
    final String getROComponentName() {
        return RO_COMPONENT;
    }

    public WebElement getFirstDropdown() {
        if (this.isReadOnly()) {
            throw new SystemException("Cannot get active list from a read-only WMultiDropdown");
        }
        return this.findElementImmediate(By.tagName((String)"select"));
    }

    public WebElement getAddButton() {
        if (this.isReadOnly()) {
            throw new SystemException("Cannot get add button from a read-only WMultiDropdown");
        }
        return this.findElementImmediate(By.tagName((String)"button"));
    }

    private List<WebElement> getReadOnlyOptions() {
        return this.findElementsImmediate(By.cssSelector((String)".wc-option"));
    }

    public List<WebElement> getOptions() {
        if (this.isReadOnly()) {
            return this.getReadOnlyOptions();
        }
        WebElement dropdown = this.getFirstDropdown();
        Select se = new Select(dropdown);
        return se.getOptions();
    }

    public List<WebElement> getSelected() {
        if (this.isReadOnly()) {
            return this.getReadOnlyOptions();
        }
        if (!this.isEnabled()) {
            return new ArrayList<WebElement>(0);
        }
        List<WebElement> dropdowns = this.getDropdowns();
        if (dropdowns.isEmpty()) {
            return new ArrayList<WebElement>(0);
        }
        ArrayList<WebElement> selected = new ArrayList<WebElement>(dropdowns.size());
        for (WebElement dropdown : dropdowns) {
            Select se = new Select(dropdown);
            selected.add(se.getFirstSelectedOption());
        }
        return selected;
    }

    public WebElement getDropdown(int idx) {
        if (this.isReadOnly()) {
            throw new SystemException("Cannot get option lists from a read-only WMultiDropdown");
        }
        if (idx < 0) {
            throw new IllegalArgumentException("idx must be >= 0");
        }
        List<WebElement> dropdowns = this.getDropdowns();
        if (idx >= dropdowns.size()) {
            throw new IllegalArgumentException("Cannot get option lists for the given index");
        }
        return dropdowns.get(idx);
    }

    public WebElement getDropdown(String optionText) {
        if (this.isReadOnly()) {
            throw new SystemException("Cannot get option lists from a read-only WMultiDropdown");
        }
        if (optionText == null) {
            throw new IllegalArgumentException("Cannot get a reference to the selected option list without the option text");
        }
        List<WebElement> dropdowns = this.getDropdowns();
        if (dropdowns.isEmpty()) {
            throw new SystemException("Cannot find any selected lists");
        }
        for (WebElement dropdown : dropdowns) {
            Select se = new Select(dropdown);
            WebElement option = se.getFirstSelectedOption();
            if (!optionText.equalsIgnoreCase(option.getText())) continue;
            return dropdown;
        }
        throw new SystemException("Cannot get a list for that option text");
    }

    public WebElement getRemoveButton(WebElement dropdown) {
        WebElement firstOption;
        if (this.isReadOnly()) {
            throw new SystemException("Cannot get remove button from a read-only WMultiDropdown");
        }
        if (dropdown == null) {
            throw new IllegalArgumentException("Cannot get remove button without a reference dropdown");
        }
        String id = dropdown.getAttribute("id");
        if (id.equals((firstOption = this.getFirstDropdown()).getAttribute("id"))) {
            throw new SystemException("Cannot get remove button for the first option");
        }
        String cssSelector = "button[aria-controls='" + id + "']";
        return this.findElementImmediate(By.cssSelector((String)cssSelector));
    }

    public List<WebElement> getDropdowns() {
        if (this.isReadOnly()) {
            throw new SystemException("Cannot get selection lists from a read-only WMultiDropdown");
        }
        return this.findElementsImmediate(By.tagName((String)"select"));
    }

    public boolean isSelected(String labelText) {
        if (this.isReadOnly()) {
            for (WebElement o : this.getReadOnlyOptions()) {
                if (!labelText.equalsIgnoreCase(o.getText())) continue;
                return true;
            }
            return false;
        }
        for (WebElement dropdown : this.getDropdowns()) {
            Select se = new Select(dropdown);
            if (!labelText.equalsIgnoreCase(se.getFirstSelectedOption().getText())) continue;
            return true;
        }
        return false;
    }

    public void deselect(String optionText) {
        if (this.isReadOnly()) {
            throw new SystemException("Cannot deselect option from a read-only WMultiDropdown");
        }
        if (optionText == null) {
            throw new IllegalArgumentException("Cannot deselect option without the option text");
        }
        WebElement dropdown = this.getDropdown(optionText);
        WebElement removeButton = this.getRemoveButton(dropdown);
        this.clickButton(removeButton, false);
    }

    public void select(String optionText) {
        if (this.isReadOnly()) {
            throw new SystemException("Cannot select from a read-only WMultiDropdown");
        }
        this.clickButton(this.getAddButton(), true);
        Select se = new Select(this.getFirstDropdown());
        se.selectByVisibleText(optionText);
    }

    public void switchFirstOption(String toText) {
        if (this.isReadOnly()) {
            throw new SystemException("Cannot switch selection from a read-only WMultiDropdown");
        }
        WebElement dropdown = this.getFirstDropdown();
        Select se = new Select(dropdown);
        se.selectByVisibleText(toText);
    }

    public void switchOption(String fromText, String toText) {
        if (this.isReadOnly()) {
            throw new SystemException("Cannot switch selection from a read-only WMultiDropdown");
        }
        WebElement dropdown = this.getDropdown(fromText);
        Select se = new Select(dropdown);
        se.selectByVisibleText(toText);
    }

    public void deselectAll() {
        if (this.isReadOnly()) {
            throw new SystemException("Cannot deselect all from a read-only WMultiDropdown");
        }
        List<WebElement> dropdowns = this.getDropdowns();
        if (dropdowns.isEmpty()) {
            LOG.warn((Object)"Found an editable WMultiDropdown with no select elements");
            return;
        }
        WebElement dropdown = this.getFirstDropdown();
        Select se = new Select(dropdown);
        se.selectByIndex(0);
        if (dropdowns.size() == 1) {
            return;
        }
        WebElement removeButton = this.getRemoveButton(dropdowns.get(1));
        WebDriver driver = this.getDriver();
        if (driver instanceof HasInputDevices) {
            Actions shiftClick = new Actions(driver);
            shiftClick.keyDown((CharSequence)Keys.SHIFT).click(removeButton).keyUp((CharSequence)Keys.SHIFT).perform();
        } else {
            removeButton.sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.SHIFT, Keys.SPACE})});
        }
        SeleniumWComponentsUtil.waitForPageReady(this.getDriver());
    }

    private void clickButton(WebElement button, boolean wait) {
        if (button instanceof SeleniumWComponentWebElement) {
            if (wait) {
                ((SeleniumWComponentWebElement)button).click();
            } else {
                ((SeleniumWComponentWebElement)button).clickNoWait();
            }
            return;
        }
        button.click();
        if (wait) {
            SeleniumWComponentsUtil.waitForPageReady(this.getDriver());
        }
    }
}

