/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.wcomponents.test.selenium.element;

import com.github.bordertech.wcomponents.test.selenium.SeleniumWComponentsUtil;
import com.github.bordertech.wcomponents.test.selenium.element.SeleniumGroupInputWebElement;
import com.github.bordertech.wcomponents.util.SystemException;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class SeleniumWMultiSelectPairWebElement
extends SeleniumGroupInputWebElement {
    private static final String RO_COMPONENT = "multiselectpair";

    public SeleniumWMultiSelectPairWebElement(WebElement element, WebDriver driver) {
        super(element, driver);
    }

    @Override
    public boolean isEnabled() {
        if (this.isReadOnly()) {
            return false;
        }
        return this.getAvailableList().isEnabled();
    }

    @Override
    final String getROComponentName() {
        return RO_COMPONENT;
    }

    public WebElement getAvailableList() {
        if (this.isReadOnly()) {
            throw new SystemException("Cannot get available list from a read-only WMultiSelectPair");
        }
        return this.findElementImmediate(By.className((String)"wc_msp_av"));
    }

    public WebElement getSelectedList() {
        if (this.isReadOnly()) {
            throw new SystemException("Cannot get selected list from a read-only WMultiSelectPair");
        }
        return this.findElementImmediate(By.className((String)"wc_msp_chos"));
    }

    private List<WebElement> getReadOnlyOptions() {
        return this.findElementsImmediate(By.cssSelector((String)".wc-option"));
    }

    private List<WebElement> getOptions(WebElement list) {
        By by = By.tagName((String)"option");
        return SeleniumWComponentsUtil.findElementsImmediateForElement(list, by);
    }

    public List<WebElement> getOptions() {
        if (this.isReadOnly()) {
            return this.getReadOnlyOptions();
        }
        ArrayList<WebElement> options = new ArrayList<WebElement>();
        options.addAll(this.getOptions(this.getAvailableList()));
        options.addAll(this.getOptions(this.getSelectedList()));
        return options;
    }

    public List<WebElement> getSelected() {
        if (this.isReadOnly()) {
            return this.getReadOnlyOptions();
        }
        if (!this.isEnabled()) {
            return new ArrayList<WebElement>();
        }
        return this.getOptions(this.getSelectedList());
    }

    public WebElement getOption(String labelText) {
        for (WebElement option : this.getOptions()) {
            if (!labelText.equalsIgnoreCase(option.getText())) continue;
            return option;
        }
        throw new IllegalArgumentException("Cannot find option with text" + labelText);
    }

    public boolean isSelected(String labelText) {
        for (WebElement o : this.getSelected()) {
            if (!labelText.equalsIgnoreCase(o.getText())) continue;
            return true;
        }
        return false;
    }

    public boolean isSelected(WebElement option) {
        return this.isSelected(option.getText());
    }

    private WebElement getButton(String selector) {
        if (this.isReadOnly()) {
            throw new SystemException("Cannot get buttons from a read-only WMultiSelectPair");
        }
        return this.findElementImmediate(By.cssSelector((String)("button" + selector)));
    }

    public WebElement getSelectButton() {
        return this.getButton("[value='add']");
    }

    public WebElement getSelectAllButton() {
        return this.getButton("[value='aall']");
    }

    public WebElement getDeselectButton() {
        return this.getButton("[value='rem']");
    }

    public WebElement getDeselectAllButton() {
        return this.getButton("[value='rall']");
    }

    public void select(WebElement option) {
        if (!this.isReadOnly() && this.isEnabled() && !this.isSelected(option)) {
            if (!option.isSelected()) {
                this.clickElementNoWait(option);
            }
            this.clickElementNoWait(this.getSelectButton());
        }
    }

    public void select(String labelText) {
        this.select(this.getOption(labelText));
    }

    public void deselect(WebElement option) {
        if (!this.isReadOnly() && this.isEnabled() && this.isSelected(option)) {
            if (!option.isSelected()) {
                this.clickElementNoWait(option);
            }
            this.clickElementNoWait(this.getDeselectButton());
        }
    }

    public void deselect(String labelText) {
        this.deselect(this.getOption(labelText));
    }

    public void selectAll() {
        if (!this.isReadOnly() && this.isEnabled()) {
            this.clickElementNoWait(this.getSelectAllButton());
        }
    }

    public void deselectAll() {
        if (!this.isReadOnly() && this.isEnabled()) {
            this.clickElementNoWait(this.getDeselectAllButton());
        }
    }
}

