/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.wcomponents.test.selenium.element;

import com.github.bordertech.wcomponents.test.selenium.element.SeleniumWComponentInputWebElement;
import com.github.bordertech.wcomponents.test.selenium.element.SeleniumWComponentWebProperties;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.BooleanUtils;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class SeleniumWRadioButtonWebElement
extends SeleniumWComponentInputWebElement {
    private static final List<String> INPUT_ATTRIBUTES = Arrays.asList("disabled", "required", "checked");
    public static final String TYPE = "radio";

    public SeleniumWRadioButtonWebElement(WebElement element, WebDriver driver) {
        super(element, driver);
        String tagName = element.getTagName();
        if (!tagName.equals("span")) {
            throw new IllegalArgumentException("Element is not the expected wrapper. tag=[" + tagName + "].");
        }
    }

    @Override
    public String getValue() {
        if (this.isReadOnly()) {
            return super.getAttribute(SeleniumWComponentWebProperties.ATTRIBUTE_WRAPPED_VALUE.toString());
        }
        return BooleanUtils.toStringTrueFalse((boolean)this.getInputField().isSelected());
    }

    @Override
    public String getAttribute(String name) {
        if (INPUT_ATTRIBUTES.contains(name)) {
            if (this.isReadOnly()) {
                return null;
            }
            return this.getInputField().getAttribute(name);
        }
        return super.getAttribute(name);
    }

    @Override
    public boolean isSelected() {
        if (this.isReadOnly()) {
            String className = this.getAttribute("class");
            if (null == className) {
                return false;
            }
            List<String> classAsList = Arrays.asList(className.split("\\s"));
            return classAsList.contains(SeleniumWComponentWebProperties.CLASS_READONLY_CHECKED.toString());
        }
        return this.getInputField().isSelected();
    }
}

