/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.wcomponents.test.selenium.element;

import com.github.bordertech.wcomponents.test.selenium.element.SeleniumWComponentInputWebElement;
import com.github.bordertech.wcomponents.test.selenium.element.SeleniumWComponentWebElement;
import com.github.bordertech.wcomponents.util.SystemException;
import com.github.bordertech.wcomponents.util.Util;
import java.util.Arrays;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Select;

public class SeleniumWSelectWebElement
extends SeleniumWComponentInputWebElement {
    private static final List<String> INPUT_ATTRIBUTES = Arrays.asList("disabled", "required");
    public static final String SELECTOR_SELECTED_OPTION = "option[selected]";
    public static final String SELECTOR_FIRST_OPTION = "option:first-of-type";
    public static final String SELECTOR_LAST_OPTION = "option:last-of-type";
    public static final String SELECTOR_NTH_OPTION = "option:nth-child(%s)";
    public static final String SELECT_TAG = "select";
    public static final String RO_MULTI_SELECT_TAG = "ul";
    public static final String RO_MULTI_OPTION_TAG = "li";

    public SeleniumWSelectWebElement(WebElement element, WebDriver driver) {
        super(element, driver);
        String tagName = element.getTagName();
        if (!"span".equals(tagName) && !RO_MULTI_SELECT_TAG.equals(tagName)) {
            throw new IllegalArgumentException("Element is not the expected wrapper. tag=[" + tagName + "].");
        }
    }

    @Override
    public String getValue() {
        WebElement selected = this.getSelectedOption();
        return selected == null ? "" : selected.getText();
    }

    public WebElement getSelectedOption() {
        if (this.isReadOnly()) {
            if (this.isMultiSelect()) {
                try {
                    return this.findElementImmediate(By.tagName((String)RO_MULTI_OPTION_TAG));
                }
                catch (NoSuchElementException nsee) {
                    return null;
                }
            }
            String text = this.getText();
            if (Util.empty((String)text)) {
                return null;
            }
            return this;
        }
        SeleniumWComponentWebElement input = this.getInputField();
        Select se = new Select((WebElement)input);
        try {
            return se.getFirstSelectedOption();
        }
        catch (NoSuchElementException nsee) {
            return null;
        }
    }

    public SeleniumWComponentWebElement getNthOption(int optionNumber) {
        return new SeleniumWComponentWebElement(this.getOptions().get(optionNumber), this.getDriver());
    }

    public SeleniumWComponentWebElement getFirstOption() {
        return this.getNthOption(0);
    }

    public SeleniumWComponentWebElement getLastOption() {
        List<WebElement> options = this.getOptions();
        return new SeleniumWComponentWebElement(options.get(options.size() - 1), this.getDriver());
    }

    @Override
    public String getAttribute(String name) {
        if (INPUT_ATTRIBUTES.contains(name)) {
            if (this.isReadOnly()) {
                return null;
            }
            return this.getInputField().getAttribute(name);
        }
        return super.getAttribute(name);
    }

    @Override
    public SeleniumWComponentWebElement getInputField() {
        if (this.isReadOnly()) {
            return null;
        }
        return this.findElementImmediate(By.tagName((String)SELECT_TAG));
    }

    public boolean isMultiSelect() {
        if (this.isReadOnly()) {
            return RO_MULTI_SELECT_TAG.equals(this.getTagName());
        }
        return "multiple".equals(this.getInputField().getAttribute("multiple"));
    }

    public List<WebElement> getOptions() {
        if (this.isReadOnly()) {
            return this.findElementsImmediate(By.tagName((String)RO_MULTI_OPTION_TAG));
        }
        SeleniumWComponentWebElement input = this.getInputField();
        Select se = new Select((WebElement)input);
        return se.getOptions();
    }

    public List<WebElement> getSelectedOptions() {
        if (this.isReadOnly()) {
            return this.getOptions();
        }
        SeleniumWComponentWebElement input = this.getInputField();
        Select se = new Select((WebElement)input);
        return se.getAllSelectedOptions();
    }

    public WebElement getOption(String optionText) {
        if (optionText == null) {
            throw new SystemException("option text must not be null");
        }
        if (this.isReadOnly()) {
            if (this.isMultiSelect()) {
                for (WebElement we : this.getOptions()) {
                    if (!optionText.equals(we.getText())) continue;
                    return we;
                }
                throw new NoSuchElementException("No option with text provided");
            }
            if (optionText.equals(this.getText())) {
                return this;
            }
            throw new NoSuchElementException("No option with text provided");
        }
        for (WebElement we : this.getOptions()) {
            if (!optionText.equals(we.getText())) continue;
            return we;
        }
        throw new NoSuchElementException("No option with text provided");
    }
}

