/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.wcomponents.test.selenium.element;

import com.github.bordertech.wcomponents.test.selenium.element.SeleniumSimpleSelectWebElement;
import com.github.bordertech.wcomponents.test.selenium.element.SeleniumWComponentWebElement;
import com.github.bordertech.wcomponents.util.SystemException;
import java.text.MessageFormat;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class SeleniumWTableWebElement
extends SeleniumWComponentWebElement {
    public static final String TABLE_TAG_NAME = "div";
    public static final String TABLE_CHILD_TAG_NAME = "table";
    public static final String TABLE_HEADER_TAG_NAME = "thead";
    public static final String TABLE_DIV_CLASS = "wc-table";
    public static final String ROWS_PER_PAGE_TABLE_ATTRIBUTE = "data-wc-rpp";
    public static final String SELECTOR_TABLE_CAPTION = "table caption";
    public static final String SELECTOR_FIRST_ROW_INDEX_OF_PAGE = "span.wc_table_pag_rowstart";
    public static final String SELECTOR_LAST_ROW_INDEX_OF_PAGE = "span.wc_table_pag_rowend";
    public static final String SELECTOR_TOTAL_ROWS = "span.wc_table_pag_total";
    public static final String SELECTOR_FIRST_PAGE_BUTTON = "span.wc_table_pag_btns button:nth-of-type(1)";
    public static final String SELECTOR_PREVIOUS_PAGE_BUTTON = "span.wc_table_pag_btns button:nth-of-type(2)";
    public static final String SELECTOR_NEXT_PAGE_BUTTON = "span.wc_table_pag_btns button:nth-of-type(3)";
    public static final String SELECTOR_LAST_PAGE_BUTTON = "span.wc_table_pag_btns button:nth-of-type(4)";
    public static final String SELECTOR_PAGE_SELECT = "select.wc_table_pag_select";
    public static final String SELECTOR_ROWS_PER_PAGE_SELECT = "select.wc_table_pag_rpp";
    public static final String SELECTOR_COLUMN_HEADER = "thead tr th[data-wc-columnidx=''{0}'']";
    public static final String SELECTOR_COLUMN_HEADER_TEXT = "thead tr th[data-wc-columnidx=''{0}''] div.wc-labelbody";
    public static final String SELECTOR_CELL_CONTENT = "tbody tr[data-wc-rowindex=''{0}''] td:nth-of-type({1})";

    public SeleniumWTableWebElement(WebElement element, WebDriver driver) {
        super(element, driver);
        String elementTag = element.getTagName();
        String elementClass = element.getAttribute("class");
        if (!elementTag.equals(TABLE_TAG_NAME)) {
            if (elementTag.equals(TABLE_CHILD_TAG_NAME)) {
                throw new SystemException("Incorrect element selected for SeleniumWTableWebElement.Expected the wrapper div element containing the table and controls, but instead found the table element.");
            }
            throw new SystemException("Incorrect element selected for SeleniumWTableWebElement. Expected div but found: " + elementTag);
        }
        if (!elementClass.contains(TABLE_DIV_CLASS)) {
            throw new SystemException("Incorrect element selected for SeleniumWTableWebElement. Expected div containing class wc-table but found div with class " + elementClass);
        }
    }

    public int getFirstRowIndexOfPage() {
        SeleniumWComponentWebElement wrapper = this.findElementImmediate(By.cssSelector((String)SELECTOR_FIRST_ROW_INDEX_OF_PAGE));
        return Integer.parseInt(wrapper.getText());
    }

    public int getLastRowIndexOfPage() {
        SeleniumWComponentWebElement wrapper = this.findElementImmediate(By.cssSelector((String)SELECTOR_LAST_ROW_INDEX_OF_PAGE));
        return Integer.parseInt(wrapper.getText());
    }

    public int getTotalRows() {
        SeleniumWComponentWebElement wrapper = this.findElementImmediate(By.cssSelector((String)SELECTOR_TOTAL_ROWS));
        return Integer.parseInt(wrapper.getText());
    }

    public SeleniumWComponentWebElement getTable() {
        return this.findElementImmediate(By.tagName((String)TABLE_CHILD_TAG_NAME));
    }

    public SeleniumWComponentWebElement getFirstPageButton() {
        return this.findElementImmediate(By.cssSelector((String)SELECTOR_FIRST_PAGE_BUTTON));
    }

    public SeleniumWComponentWebElement getPreviousPageButton() {
        return this.findElementImmediate(By.cssSelector((String)SELECTOR_PREVIOUS_PAGE_BUTTON));
    }

    public SeleniumWComponentWebElement getNextPageButton() {
        return this.findElementImmediate(By.cssSelector((String)SELECTOR_NEXT_PAGE_BUTTON));
    }

    public SeleniumWComponentWebElement getLastPageButton() {
        return this.findElementImmediate(By.cssSelector((String)SELECTOR_LAST_PAGE_BUTTON));
    }

    public SeleniumSimpleSelectWebElement getPageSelect() {
        return this.findSeleniumSimpleSelectWebElement(By.cssSelector((String)SELECTOR_PAGE_SELECT));
    }

    public SeleniumSimpleSelectWebElement getRowsPerPageSelect() {
        return this.findSeleniumSimpleSelectWebElement(By.cssSelector((String)SELECTOR_ROWS_PER_PAGE_SELECT));
    }

    public int getCurrentPage() {
        return Integer.parseInt(this.getPageSelect().getSelectedOption().getText());
    }

    public int getTotalPages() {
        return Integer.parseInt(this.getPageSelect().getLastOption().getText());
    }

    public int getRowsPerPage() {
        return Integer.parseInt(this.getTable().getAttribute(ROWS_PER_PAGE_TABLE_ATTRIBUTE));
    }

    public String getTableCaption() {
        return this.findElementImmediate(By.cssSelector((String)SELECTOR_TABLE_CAPTION)).getText();
    }

    public SeleniumWComponentWebElement getTableHeader() {
        return this.findElementImmediate(By.tagName((String)TABLE_HEADER_TAG_NAME));
    }

    public SeleniumWComponentWebElement getHeaderForColumn(int columnIndex) {
        String selector = MessageFormat.format(SELECTOR_COLUMN_HEADER, columnIndex);
        return this.findElementImmediate(By.cssSelector((String)selector));
    }

    public String getHeaderTextForColumn(int columnIndex) {
        String selector = MessageFormat.format(SELECTOR_COLUMN_HEADER_TEXT, columnIndex);
        return this.findElementImmediate(By.cssSelector((String)selector)).getText();
    }

    public SeleniumWComponentWebElement getCellContent(int rowIndex, int columnIndex) {
        int adjustedColIndex = columnIndex + 1;
        String selector = MessageFormat.format(SELECTOR_CELL_CONTENT, rowIndex, adjustedColIndex);
        return this.findElementImmediate(By.cssSelector((String)selector));
    }

    public String getCellText(int rowIndex, int columnIndex) {
        return this.getCellContent(rowIndex, columnIndex).getText();
    }

    public SeleniumSimpleSelectWebElement findSeleniumSimpleSelectWebElement(By by) {
        return new SeleniumSimpleSelectWebElement(this.findElementImmediate(by), this.getDriver());
    }
}

