/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.wcomponents.test.selenium.server;

import com.github.bordertech.wcomponents.WApplication;
import com.github.bordertech.wcomponents.WComponent;
import com.github.bordertech.wcomponents.lde.LdeLauncher;
import com.github.bordertech.wcomponents.test.selenium.DynamicLauncher;
import com.github.bordertech.wcomponents.util.Factory;
import com.github.bordertech.wcomponents.util.SystemException;

public final class ServerCache {
    private static final LdeLauncher LAUNCHER = (LdeLauncher)Factory.newInstance(LdeLauncher.class);
    private static boolean inSuite;

    private ServerCache() {
    }

    public static LdeLauncher getLauncher() {
        return LAUNCHER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUrl() {
        LdeLauncher ldeLauncher = LAUNCHER;
        synchronized (ldeLauncher) {
            return LAUNCHER.getUrl();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopServer() {
        if (ServerCache.isInSuite()) {
            return;
        }
        LdeLauncher ldeLauncher = LAUNCHER;
        synchronized (ldeLauncher) {
            try {
                LAUNCHER.stop();
            }
            catch (Exception ex) {
                throw new SystemException("Unable to stop server", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void restartServer() {
        LdeLauncher ldeLauncher = LAUNCHER;
        synchronized (ldeLauncher) {
            if (ServerCache.isRunning()) {
                ServerCache.stopServer();
            }
            ServerCache.startServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRunning() {
        LdeLauncher ldeLauncher = LAUNCHER;
        synchronized (ldeLauncher) {
            return LAUNCHER.isRunning();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startServer() {
        LdeLauncher ldeLauncher = LAUNCHER;
        synchronized (ldeLauncher) {
            try {
                if (!ServerCache.isRunning()) {
                    LAUNCHER.run();
                }
            }
            catch (Exception ex) {
                throw new SystemException("Unable to start server", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setInSuite(boolean flag) {
        LdeLauncher ldeLauncher = LAUNCHER;
        synchronized (ldeLauncher) {
            inSuite = flag;
        }
    }

    public static boolean isInSuite() {
        return inSuite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WComponent setUI(String key, WComponent ui) {
        if (!(LAUNCHER instanceof DynamicLauncher)) {
            return ui;
        }
        LdeLauncher ldeLauncher = LAUNCHER;
        synchronized (ldeLauncher) {
            DynamicLauncher dynamic = (DynamicLauncher)LAUNCHER;
            dynamic.setCurrentKey(key);
            WApplication egUI = dynamic.getRegisteredComponent(key);
            if (egUI != null) {
                return ui instanceof WApplication ? egUI : egUI.getChildAt(0);
            }
            dynamic.registerComponent(key, ServerCache.wrapUI(ui));
            return ui;
        }
    }

    private static WApplication wrapUI(WComponent ui) {
        WApplication egUI;
        if (ui instanceof WApplication) {
            egUI = (WApplication)ui;
        } else {
            egUI = new WApplication();
            egUI.add(ui);
        }
        return egUI;
    }
}

