/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.wcomponents.test.example;

import com.github.bordertech.wcomponents.Action;
import com.github.bordertech.wcomponents.ActionEvent;
import com.github.bordertech.wcomponents.WButton;
import com.github.bordertech.wcomponents.WComponent;
import com.github.bordertech.wcomponents.WContainer;
import com.github.bordertech.wcomponents.WLabel;
import com.github.bordertech.wcomponents.WTabSet;
import com.github.bordertech.wcomponents.WTextField;
import com.github.bordertech.wcomponents.test.selenium.ByWComponent;
import com.github.bordertech.wcomponents.test.selenium.ByWComponentPath;
import com.github.bordertech.wcomponents.test.selenium.WComponentSeleniumTestCase;
import com.github.bordertech.wcomponents.test.selenium.driver.SeleniumWComponentsWebDriver;
import org.junit.Assert;
import org.junit.Test;
import org.openqa.selenium.By;

public class ExampleSeleniumTest
extends WComponentSeleniumTestCase {
    private final ExampleUI ui = new ExampleUI();

    @Test
    public void testDuplicatorWithNoGettersWComponentPathImpl() {
        SeleniumWComponentsWebDriver driver = this.getDriver();
        ByWComponentPath textFieldPath = new ByWComponentPath((WComponent)this.ui, "ExampleSeleniumTest$TextDuplicator/WTextField");
        driver.findElement(textFieldPath).sendKeys(new CharSequence[]{"dummy"});
        driver.findElement(new ByWComponentPath((WComponent)this.ui, "ExampleSeleniumTest$TextDuplicator/WButton[0]")).click();
        Assert.assertEquals((String)"Incorrect text field text after duplicate", (Object)"dummydummy", (Object)driver.findElement(textFieldPath).getAttribute("value"));
        driver.findElement(new ByWComponentPath((WComponent)this.ui, "ExampleSeleniumTest$TextDuplicator/WButton[1]")).click();
        Assert.assertEquals((String)"Incorrect text field text after clear", (Object)"", (Object)driver.findElement(textFieldPath).getAttribute("value"));
    }

    @Test
    public void testDuplicatorWithNoGettersHtmlImpl() {
        SeleniumWComponentsWebDriver driver = this.getDriver();
        driver.findElement(By.xpath((String)"//input[@type='text']")).sendKeys(new CharSequence[]{"dummy"});
        driver.findElement(By.xpath((String)"//*[text()='Duplicate']")).click();
        Assert.assertEquals((String)"Incorrect text field text after duplicate", (Object)"dummydummy", (Object)driver.findElement(By.xpath((String)"//input[@type='text']")).getAttribute("value"));
        driver.findElement(By.xpath((String)"//*[text()='Clear']")).click();
        Assert.assertEquals((String)"Incorrect text field text after clear", (Object)"", (Object)driver.findElement(By.xpath((String)"//input[@type='text']")).getAttribute("value"));
    }

    @Test
    public void testDuplicatorWithGettersWComponentPathImpl() {
        SeleniumWComponentsWebDriver driver = this.getDriver();
        ByWComponentPath textFieldPath = new ByWComponentPath((WComponent)this.ui, "ExampleSeleniumTest$TextDuplicatorWithGetters/WTextField");
        driver.findElement(new ByWComponentPath((WComponent)this.ui, "WTab[1]")).click();
        driver.findElement(textFieldPath).sendKeys(new CharSequence[]{"dummy"});
        driver.findElement(new ByWComponentPath((WComponent)this.ui, "ExampleSeleniumTest$TextDuplicatorWithGetters/WButton[0]")).click();
        Assert.assertEquals((String)"Incorrect text field text after duplicate", (Object)"dummydummy", (Object)driver.findElement(textFieldPath).getAttribute("value"));
        driver.findElement(new ByWComponentPath((WComponent)this.ui, "ExampleSeleniumTest$TextDuplicatorWithGetters/WButton[1]")).click();
        Assert.assertEquals((String)"Incorrect text field text after clear", (Object)"", (Object)driver.findElement(textFieldPath).getAttribute("value"));
    }

    @Test
    public void testDuplicatorWithGettersWComponentImpl() {
        SeleniumWComponentsWebDriver driver = this.getDriver();
        WTextField textField = this.ui.getTextDuplicatorWithGetters().getTextField();
        WButton duplicateButton = this.ui.getTextDuplicatorWithGetters().getDuplicateButton();
        WButton clearButton = this.ui.getTextDuplicatorWithGetters().getClearButton();
        driver.findElement(new ByWComponentPath((WComponent)this.ui, "WTab[1]")).click();
        driver.findElement(new ByWComponent((WComponent)textField)).sendKeys(new CharSequence[]{"dummy"});
        driver.findElement(new ByWComponent((WComponent)duplicateButton)).click();
        Assert.assertEquals((String)"Incorrect text field text after duplicate", (Object)"dummydummy", (Object)driver.findElement(new ByWComponent((WComponent)textField)).getAttribute("value"));
        driver.findElement(new ByWComponent((WComponent)clearButton)).click();
        Assert.assertEquals((String)"Incorrect text field text after clear", (Object)"", (Object)driver.findElement(new ByWComponent((WComponent)textField)).getAttribute("value"));
    }

    private static class TextDuplicatorWithGetters
    extends TextDuplicator {
        private TextDuplicatorWithGetters() {
        }

        @Override
        public WTextField getTextField() {
            return super.getTextField();
        }

        @Override
        public WButton getDuplicateButton() {
            return super.getDuplicateButton();
        }

        @Override
        public WButton getClearButton() {
            return super.getClearButton();
        }
    }

    private static class TextDuplicator
    extends WContainer {
        private final WTextField textFld = new WTextField();
        private final WButton duplicateButton = new WButton("Duplicate");
        private final WButton clearButton = new WButton("Clear");

        TextDuplicator() {
            this.duplicateButton.setAction(new Action(){

                public void execute(ActionEvent event) {
                    String text = textFld.getText();
                    textFld.setText(text + text);
                }
            });
            this.clearButton.setAction(new Action(){

                public void execute(ActionEvent event) {
                    textFld.setText("");
                }
            });
            this.add((WComponent)new WLabel("Text to duplicate", (WComponent)this.textFld));
            this.add((WComponent)this.textFld);
            this.add((WComponent)this.duplicateButton);
            this.add((WComponent)this.clearButton);
        }

        WTextField getTextField() {
            return this.textFld;
        }

        WButton getDuplicateButton() {
            return this.duplicateButton;
        }

        WButton getClearButton() {
            return this.clearButton;
        }
    }

    private static final class ExampleUI
    extends WContainer {
        private final TextDuplicator textDuplicator = new TextDuplicator();
        private final TextDuplicatorWithGetters textDuplicatorWithGetters = new TextDuplicatorWithGetters();

        private ExampleUI() {
            WTabSet tabs = new WTabSet();
            this.add((WComponent)tabs);
            tabs.addTab((WComponent)this.textDuplicator, "No getter", WTabSet.TAB_MODE_CLIENT);
            tabs.addTab((WComponent)this.textDuplicatorWithGetters, "With getter", WTabSet.TAB_MODE_LAZY);
        }

        public TextDuplicator getTextDuplicator() {
            return this.textDuplicator;
        }

        public TextDuplicatorWithGetters getTextDuplicatorWithGetters() {
            return this.textDuplicatorWithGetters;
        }
    }
}

