/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.wcomponents.test.selenium;

import com.github.bordertech.wcomponents.AbstractWSelectList;
import com.github.bordertech.wcomponents.ComponentWithContext;
import com.github.bordertech.wcomponents.UIContext;
import com.github.bordertech.wcomponents.UIContextHolder;
import com.github.bordertech.wcomponents.WComponent;
import com.github.bordertech.wcomponents.WRadioButton;
import com.github.bordertech.wcomponents.WebUtilities;
import com.github.bordertech.wcomponents.util.Util;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.FindsById;
import org.openqa.selenium.internal.FindsByName;
import org.openqa.selenium.internal.FindsByXPath;

public class ByWComponent
extends By {
    private final WComponent component;
    private UIContext context;
    private final Object value;

    public ByWComponent(ComponentWithContext componentWithContext) {
        this(componentWithContext.getComponent(), componentWithContext.getContext(), null);
    }

    public ByWComponent(WComponent component) {
        this(component, null, null);
    }

    public ByWComponent(WComponent component, UIContext context) {
        this(component, context, null);
    }

    public ByWComponent(WComponent component, UIContext context, Object value) {
        this.component = component;
        this.context = context;
        this.value = value;
    }

    public void setContext(UIContext context) {
        this.context = context;
    }

    protected UIContext getContext() {
        return this.context;
    }

    protected WComponent getComponent() {
        return this.component;
    }

    protected Object getValue() {
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<WebElement> findElement(SearchContext searchContext, UIContext uiContext, WComponent component, Object compValue) {
        List result = new ArrayList();
        UIContextHolder.pushContext((UIContext)uiContext);
        try {
            if (searchContext instanceof FindsById) {
                String componentId = component.getId();
                result = ((FindsById)searchContext).findElementsById(componentId);
            } else if (searchContext instanceof FindsByName) {
                String name = component.getId();
                result = ((FindsByName)searchContext).findElementsByName(name);
            } else {
                String componentId = component.getId();
                result = ((FindsByXPath)searchContext).findElementsByXPath("*[@id = '" + componentId + "']");
            }
        }
        finally {
            UIContextHolder.popContext();
        }
        if (result != null) {
            ByWComponent.narrowResults(result, component, uiContext, compValue);
        }
        return result;
    }

    public List<WebElement> findElements(SearchContext searchContext) {
        return this.findElement(searchContext, this.context, this.component, this.value);
    }

    public String toString() {
        return "ByWComponent:" + this.component.getId() + (this.value == null ? "" : " with value \"" + this.value + '\"');
    }

    public Class<? extends WComponent> getTargetWComponentClass() {
        return this.component.getClass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WebElement findValue(WebElement current, WComponent component, UIContext context, Object value) {
        if (value == null) {
            return current;
        }
        UIContextHolder.pushContext((UIContext)context);
        try {
            if (component instanceof AbstractWSelectList) {
                AbstractWSelectList list = (AbstractWSelectList)component;
                List options = list.getOptions();
                if (options != null) {
                    for (int i = 0; i < options.size(); ++i) {
                        Object option = options.get(i);
                        if (!Util.equals((Object)value, option) && !Util.equals((Object)value.toString(), (Object)list.getDesc(option, i))) continue;
                        WebElement webElement = current.findElement(By.xpath((String)(".//*[@value='" + list.getCode(option, i) + "']")));
                        return webElement;
                    }
                }
                WebElement webElement = null;
                return webElement;
            }
            if (component instanceof WRadioButton) {
                WebElement webElement = value.equals(((WRadioButton)component).getValue()) ? current : null;
                return webElement;
            }
            WebElement webElement = current.findElement(By.xpath((String)(".//*[@value='" + WebUtilities.encode((String)String.valueOf(value)) + "']")));
            return webElement;
        }
        finally {
            UIContextHolder.popContext();
        }
    }

    public static void narrowResults(List<WebElement> results, WComponent component, UIContext context, Object value) {
        if (value != null) {
            for (int i = 0; i < results.size(); ++i) {
                WebElement narrowed = ByWComponent.findValue(results.get(i), component, context, value);
                if (narrowed == null) {
                    results.remove(i--);
                    continue;
                }
                results.set(i, narrowed);
            }
        }
    }
}

