/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.wcomponents.test.selenium;

import com.github.bordertech.wcomponents.WApplication;
import com.github.bordertech.wcomponents.WComponent;
import com.github.bordertech.wcomponents.registry.UIRegistry;
import com.github.bordertech.wcomponents.test.selenium.SeleniumLauncher;
import org.apache.commons.lang3.StringUtils;

public class DynamicLauncher
extends SeleniumLauncher {
    private String uiRegistryKey = null;

    public WApplication setComponentToLaunch(String uniqueId, WApplication componentToLaunch) {
        this.setCurrentKey(uniqueId);
        WApplication appl = this.getRegisteredComponent(uniqueId);
        if (appl != null) {
            return appl;
        }
        this.registerComponent(uniqueId, componentToLaunch);
        return componentToLaunch;
    }

    public void registerComponent(String uniqueId, WApplication componentToLaunch) {
        if (!componentToLaunch.isLocked()) {
            componentToLaunch.setLocked(true);
        }
        UIRegistry.getInstance().register(uniqueId, (WComponent)componentToLaunch);
    }

    public WApplication getRegisteredComponent(String key) {
        UIRegistry reg = UIRegistry.getInstance();
        if (reg.isRegistered(key)) {
            return (WApplication)reg.getUI(key);
        }
        return null;
    }

    public void setCurrentKey(String key) {
        this.uiRegistryKey = key;
    }

    public String getCurrentKey() {
        return this.uiRegistryKey;
    }

    protected String getComponentToLaunchClassName() {
        String key = this.getCurrentKey();
        if (StringUtils.isBlank((CharSequence)key)) {
            return super.getComponentToLaunchClassName();
        }
        return key;
    }
}

