/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.wcomponents.test.selenium;

import com.github.bordertech.wcomponents.test.selenium.WComponentSeleniumTestCase;
import com.github.bordertech.wcomponents.test.selenium.driver.WebDriverType;
import com.github.bordertech.wcomponents.util.ConfigurationProperties;
import com.github.bordertech.wcomponents.util.SystemException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.ArrayUtils;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.Suite;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerScheduler;
import org.junit.runners.model.Statement;

public class MultiBrowserRunner
extends Suite {
    private final List<Runner> runners = new ArrayList<Runner>();

    public MultiBrowserRunner(Class<?> clazz) throws InitializationError {
        super(clazz, Collections.emptyList());
        String testClassName = this.getTestClass().getName();
        Object[] drivers = ConfigurationProperties.getTestSeleniumMultiBrowserDrivers((String)testClassName);
        if (ArrayUtils.isEmpty((Object[])drivers)) {
            throw new SystemException("Cannot run the MultiBrowserRunner without drivers defined in default param [bordertech.wcomponents.test.selenium.driverTypes] or test-specific param [bordertech.wcomponents.test.selenium.driverTypes." + testClassName + "]");
        }
        boolean runParallel = ConfigurationProperties.getTestSeleniumMultiBrowserDriverParallel();
        for (Object driverClassName : drivers) {
            try {
                Class<?> driverClass = Class.forName((String)driverClassName);
                if (!WebDriverType.class.isAssignableFrom(driverClass)) {
                    throw new SystemException("parameter defined WebDriverType does not implement WebDriverType inteface. driverClass=[" + driverClass + "]");
                }
                WebDriverType driverType = (WebDriverType)driverClass.newInstance();
                String driverId = runParallel ? UUID.randomUUID().toString() : null;
                this.runners.add((Runner)new TestClassRunnerForBrowser(this.getTestClass().getJavaClass(), driverType, driverId));
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
                throw new SystemException("class parameter defined WebDriverType could not be instantiated. driverClassName=[" + (String)driverClassName + "]", (Throwable)ex);
            }
        }
        if (runParallel) {
            this.setScheduler(new ThreadPoolScheduler());
        }
    }

    protected List<Runner> getChildren() {
        return this.runners;
    }

    private static final class ThreadPoolScheduler
    implements RunnerScheduler {
        private final ExecutorService executor = Executors.newCachedThreadPool();

        private ThreadPoolScheduler() {
        }

        public void finished() {
            this.executor.shutdown();
            try {
                this.executor.awaitTermination(600L, TimeUnit.SECONDS);
            }
            catch (InterruptedException exc) {
                throw new IllegalStateException("Test execution timed out", exc);
            }
        }

        public void schedule(Runnable childStatement) {
            this.executor.submit(childStatement);
        }
    }

    private static final class TestClassRunnerForBrowser
    extends BlockJUnit4ClassRunner {
        private final String driverId;
        private final WebDriverType driverType;

        private TestClassRunnerForBrowser(Class<?> type, WebDriverType driverType, String driverId) throws InitializationError {
            super(type);
            this.driverType = driverType;
            this.driverId = driverId;
        }

        public Object createTest() throws Exception {
            Object test = super.createTest();
            if (!(test instanceof WComponentSeleniumTestCase)) {
                throw new SystemException("MultiBrowserRunner cannot be used for test that does not extend WComponentSeleniumTestCase. test class: " + test.getClass().getName());
            }
            ((WComponentSeleniumTestCase)test).setDriver(this.driverType, this.driverId);
            return test;
        }

        protected String getName() {
            return super.getName() + this.getTestDetails();
        }

        protected String testName(FrameworkMethod method) {
            return String.format("%s[%s]", method.getName(), this.getTestDetails());
        }

        protected void validateConstructor(List<Throwable> errors) {
            this.validateOnlyOneConstructor(errors);
        }

        protected Statement classBlock(RunNotifier notifier) {
            return this.childrenInvoker(notifier);
        }

        private String getTestDetails() {
            return "." + this.driverType.getDriverTypeName() + ":" + this.driverId;
        }
    }
}

