/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.wcomponents.test.selenium;

import com.github.bordertech.wcomponents.UIContext;
import com.github.bordertech.wcomponents.lde.PlainLauncher;
import com.github.bordertech.wcomponents.servlet.WServlet;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SeleniumLauncher
extends PlainLauncher {
    private static final Log LOG = LogFactory.getLog(SeleniumLauncher.class);
    private static final Map<String, UIContext> CONTEXTS = new HashMap<String, UIContext>();

    public static UIContext getContextForSession(String sessionId) {
        if (StringUtils.isBlank((CharSequence)sessionId)) {
            throw new IllegalArgumentException("sessionId must not be blank.");
        }
        if (CONTEXTS.isEmpty()) {
            LOG.warn((Object)"No sessions exist in SeleniumLauncher. This function requires that the SeleniumLauncher (or subclass) is launched as the LDE launcher.");
        }
        return CONTEXTS.get(sessionId);
    }

    public static void destroyContextForSession(String sessionId) {
        CONTEXTS.remove(sessionId);
    }

    protected WServlet.WServletHelper createServletHelper(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return new SeleniumServletHelper((WServlet)this, httpServletRequest, httpServletResponse);
    }

    private static final class SeleniumServletHelper
    extends WServlet.WServletHelper {
        private SeleniumServletHelper(WServlet servlet, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
            super(servlet, httpServletRequest, httpServletResponse);
        }

        protected void setUIContext(UIContext uiContext) {
            super.setUIContext(uiContext);
            String sessionId = this.getBackingRequest().getSession().getId();
            CONTEXTS.put(sessionId, uiContext);
        }
    }
}

