/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.wcomponents.test.selenium.driver;

import com.github.bordertech.wcomponents.UIContext;
import com.github.bordertech.wcomponents.test.selenium.ByWComponent;
import com.github.bordertech.wcomponents.test.selenium.SeleniumLauncher;
import com.github.bordertech.wcomponents.test.selenium.SeleniumWComponentsUtil;
import com.github.bordertech.wcomponents.test.selenium.driver.ParameterizedWebDriverType;
import com.github.bordertech.wcomponents.test.selenium.element.SeleniumWButtonWebElement;
import com.github.bordertech.wcomponents.test.selenium.element.SeleniumWCheckBoxSelectWebElement;
import com.github.bordertech.wcomponents.test.selenium.element.SeleniumWCheckBoxWebElement;
import com.github.bordertech.wcomponents.test.selenium.element.SeleniumWComponentWebElement;
import com.github.bordertech.wcomponents.test.selenium.element.SeleniumWDialogWebElement;
import com.github.bordertech.wcomponents.test.selenium.element.SeleniumWEmailFieldWebElement;
import com.github.bordertech.wcomponents.test.selenium.element.SeleniumWLabelWebElement;
import com.github.bordertech.wcomponents.test.selenium.element.SeleniumWMessageBoxWebElement;
import com.github.bordertech.wcomponents.test.selenium.element.SeleniumWMessagesWebElement;
import com.github.bordertech.wcomponents.test.selenium.element.SeleniumWMultiDropdownWebElement;
import com.github.bordertech.wcomponents.test.selenium.element.SeleniumWMultiSelectPairWebElement;
import com.github.bordertech.wcomponents.test.selenium.element.SeleniumWPhoneNumberFieldWebElement;
import com.github.bordertech.wcomponents.test.selenium.element.SeleniumWRadioButtonSelectWebElement;
import com.github.bordertech.wcomponents.test.selenium.element.SeleniumWRadioButtonWebElement;
import com.github.bordertech.wcomponents.test.selenium.element.SeleniumWSelectWebElement;
import com.github.bordertech.wcomponents.test.selenium.element.SeleniumWTableWebElement;
import com.github.bordertech.wcomponents.test.selenium.element.SeleniumWTextAreaWebElement;
import com.github.bordertech.wcomponents.test.selenium.element.SeleniumWTextFieldWebElement;
import com.github.bordertech.wcomponents.util.SystemException;
import com.github.bordertech.wcomponents.util.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openqa.selenium.By;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;

public class SeleniumWComponentsWebDriver<T extends WebDriver>
implements WebDriver,
TakesScreenshot {
    private static final Log LOG = LogFactory.getLog(SeleniumWComponentsWebDriver.class);
    private static final String SESSION_ID_COOKIE = "JSESSIONID";
    private final T driver;
    private boolean hasSession = false;

    public void newSession() {
        this.newSession(this.driver.getCurrentUrl());
    }

    public boolean hasSession() {
        return this.hasSession;
    }

    public void newSession(String url) {
        this.driver.manage().deleteAllCookies();
        this.get(url);
    }

    public String getSessionId() {
        Cookie cookie = this.driver.manage().getCookieNamed(SESSION_ID_COOKIE);
        if (cookie == null) {
            return null;
        }
        return cookie.getValue();
    }

    public SeleniumWComponentsWebDriver() {
        this(new ParameterizedWebDriverType().getDriverImplementation());
    }

    public SeleniumWComponentsWebDriver(T driver) {
        this.driver = driver;
    }

    public T getDriver() {
        return this.driver;
    }

    public void waitForPageReady() {
        SeleniumWComponentsUtil.waitForPageReady(this.driver);
    }

    public boolean isOpenDialog() {
        return SeleniumWComponentsUtil.isOpenDialog(this);
    }

    public SeleniumWDialogWebElement getDialog() {
        return SeleniumWComponentsUtil.getDialog(this);
    }

    public void get(String url) {
        this.driver.get(url);
        this.hasSession = true;
        this.waitForPageReady();
    }

    public String getCurrentUrl() {
        this.waitForPageReady();
        return this.driver.getCurrentUrl();
    }

    public String getTitle() {
        this.waitForPageReady();
        return this.driver.getTitle();
    }

    public SeleniumWTextAreaWebElement findWTextArea(By by) {
        return new SeleniumWTextAreaWebElement(this.findElementImmediate(by), this);
    }

    public SeleniumWTextFieldWebElement findWTextField(By by) {
        return new SeleniumWTextFieldWebElement(this.findElementImmediate(by), this);
    }

    public SeleniumWEmailFieldWebElement findWEmailField(By by) {
        return new SeleniumWEmailFieldWebElement(this.findElementImmediate(by), this);
    }

    public SeleniumWPhoneNumberFieldWebElement findWPhoneNumberField(By by) {
        return new SeleniumWPhoneNumberFieldWebElement(this.findElementImmediate(by), this);
    }

    public SeleniumWTableWebElement findWTable(By by) {
        return new SeleniumWTableWebElement(this.findElementImmediate(by), this);
    }

    public SeleniumWCheckBoxWebElement findWCheckBox(By by) {
        return new SeleniumWCheckBoxWebElement(this.findElementImmediate(by), this);
    }

    public SeleniumWRadioButtonWebElement findWRadioButton(By by) {
        return new SeleniumWRadioButtonWebElement(this.findElementImmediate(by), this);
    }

    public SeleniumWRadioButtonSelectWebElement findWRadioButtonSelect(By by) {
        return new SeleniumWRadioButtonSelectWebElement(this.findElementImmediate(by), this);
    }

    public SeleniumWSelectWebElement findWDropdown(By by) {
        return new SeleniumWSelectWebElement(this.findElementImmediate(by), this);
    }

    public SeleniumWSelectWebElement findWSingleSelect(By by) {
        return new SeleniumWSelectWebElement(this.findElementImmediate(by), this);
    }

    public SeleniumWMessagesWebElement findWMessages(By by) {
        return new SeleniumWMessagesWebElement(this.findElementImmediate(by), this);
    }

    public SeleniumWMessageBoxWebElement findWMessageBox(By by) {
        return new SeleniumWMessageBoxWebElement(this.findElementImmediate(by), this);
    }

    public SeleniumWMultiDropdownWebElement findWMultiDropdown(By by) {
        return new SeleniumWMultiDropdownWebElement(this.findElementImmediate(by), this);
    }

    public SeleniumWSelectWebElement findWMultiSelect(By by) {
        return new SeleniumWSelectWebElement(this.findElementImmediate(by), this);
    }

    public SeleniumWMultiSelectPairWebElement findWMultiSelectPair(By by) {
        return new SeleniumWMultiSelectPairWebElement(this.findElementImmediate(by), this);
    }

    public SeleniumWLabelWebElement findWLabel(By by) {
        return new SeleniumWLabelWebElement(this.findElementImmediate(by), this);
    }

    public SeleniumWCheckBoxSelectWebElement findWCheckBoxSelect(By by) {
        return new SeleniumWCheckBoxSelectWebElement(this.findElementImmediate(by), this);
    }

    public SeleniumWLabelWebElement findWLabelWithPartialText(String text, int idx) {
        String selector = "//*[contains(@class, 'wc-label') and contains(text(), '" + text + "')]";
        List<WebElement> elements = this.findElements(By.xpath((String)selector));
        return new SeleniumWLabelWebElement(elements.get(idx), this);
    }

    public SeleniumWLabelWebElement findWLabelWithPartialText(String text) {
        return this.findWLabelWithPartialText(text, 0);
    }

    public SeleniumWButtonWebElement findWButton(By by) {
        return new SeleniumWButtonWebElement(this.findElementImmediate(by), this);
    }

    public SeleniumWButtonWebElement findWButtonByText(String text, boolean searchAttributes, int idx) {
        if (Util.empty((String)text)) {
            throw new IllegalArgumentException("Cannot find a button with no text");
        }
        List<WebElement> buttons = this.findElements(By.cssSelector((String)SeleniumWButtonWebElement.getCssSelector()));
        ArrayList filtered = new ArrayList(buttons.size());
        buttons.forEach(button -> {
            String buttonTextOrTitle = button.getText();
            if (text.equalsIgnoreCase(buttonTextOrTitle)) {
                filtered.add(button);
            } else if (searchAttributes) {
                buttonTextOrTitle = button.getAttribute("title");
                if (text.equalsIgnoreCase(buttonTextOrTitle)) {
                    filtered.add(button);
                } else {
                    buttonTextOrTitle = button.getAttribute("aria-label");
                    if (text.equalsIgnoreCase(buttonTextOrTitle)) {
                        filtered.add(button);
                    }
                }
            }
        });
        return new SeleniumWButtonWebElement((WebElement)filtered.get(idx), this);
    }

    public SeleniumWButtonWebElement findWButtonByText(String text, boolean searchAttributes) {
        return this.findWButtonByText(text, searchAttributes, 0);
    }

    public SeleniumWButtonWebElement findWButtonByText(String text) {
        return this.findWButtonByText(text, true, 0);
    }

    public WebElement findButton(String buttonTextOrTitle, boolean searchAttributes) {
        if (Util.empty((String)buttonTextOrTitle)) {
            throw new IllegalArgumentException("Cannot find a button with no text");
        }
        List<WebElement> buttons = this.findElements(By.tagName((String)"button"));
        for (WebElement button : buttons) {
            String text = button.getText();
            if (buttonTextOrTitle.equalsIgnoreCase(text)) {
                return button;
            }
            if (!searchAttributes) continue;
            text = button.getAttribute("title");
            if (buttonTextOrTitle.equalsIgnoreCase(text)) {
                return button;
            }
            text = button.getAttribute("aria-label");
            if (!buttonTextOrTitle.equalsIgnoreCase(text)) continue;
            return button;
        }
        throw new SystemException("No button containing required text.");
    }

    public SeleniumWComponentWebElement findElementImmediate(By by) {
        if (by instanceof ByWComponent) {
            ((ByWComponent)by).setContext(this.getUserContextForSession());
        }
        try {
            SeleniumWComponentsUtil.configureImmediateImplicitWait(this.driver);
            SeleniumWComponentWebElement seleniumWComponentWebElement = this.wrapElement(this.driver.findElement(by));
            return seleniumWComponentWebElement;
        }
        finally {
            SeleniumWComponentsUtil.configureImplicitWait(this.driver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WebElement> findElementsImmediate(By by) {
        if (by instanceof ByWComponent) {
            ((ByWComponent)by).setContext(this.getUserContextForSession());
        }
        try {
            SeleniumWComponentsUtil.configureImmediateImplicitWait(this.driver);
            List webElements = this.driver.findElements(by);
            ArrayList<SeleniumWComponentWebElement> wrappedList = new ArrayList<SeleniumWComponentWebElement>();
            for (WebElement webElement : webElements) {
                wrappedList.add(this.wrapElement(webElement));
            }
            ArrayList<SeleniumWComponentWebElement> arrayList = wrappedList;
            return arrayList;
        }
        finally {
            SeleniumWComponentsUtil.configureImplicitWait(this.driver);
        }
    }

    public List<WebElement> findElements(By by) {
        return this.findElements(by, false);
    }

    public List<WebElement> findElements(By by, boolean pageWait) {
        if (by instanceof ByWComponent) {
            return this.findElements((ByWComponent)by, pageWait);
        }
        return this.findElementsInt(by, pageWait);
    }

    public SeleniumWComponentWebElement findElement(By by) {
        return this.findElement(by, false);
    }

    public SeleniumWComponentWebElement findElement(By by, boolean pageWait) {
        if (by instanceof ByWComponent) {
            return this.findElement((ByWComponent)by, pageWait);
        }
        return this.findElementInt(by, pageWait);
    }

    public List<WebElement> findElements(ByWComponent by) {
        return this.findElements(by, false);
    }

    public List<WebElement> findElements(ByWComponent by, boolean pageWait) {
        by.setContext(this.getUserContextForSession());
        return this.findElementsInt(by, pageWait);
    }

    public SeleniumWComponentWebElement findElement(ByWComponent by) {
        return this.findElement(by, false);
    }

    public SeleniumWComponentWebElement findElement(ByWComponent by, boolean pageWait) {
        by.setContext(this.getUserContextForSession());
        return this.findElementInt(by, pageWait);
    }

    private List<WebElement> findElementsInt(By by, boolean wait) {
        if (wait) {
            this.waitForPageReady();
        }
        List webElements = this.driver.findElements(by);
        ArrayList<WebElement> wrappedList = new ArrayList<WebElement>();
        for (WebElement webElement : webElements) {
            wrappedList.add(this.wrapElement(webElement));
        }
        return wrappedList;
    }

    private SeleniumWComponentWebElement findElementInt(By by, boolean wait) {
        if (wait) {
            this.waitForPageReady();
        }
        return this.wrapElement(this.driver.findElement(by));
    }

    public String getPageSource() {
        this.waitForPageReady();
        return this.driver.getPageSource();
    }

    public void close() {
        this.driver.close();
    }

    public void quit() {
        this.driver.quit();
    }

    public Set<String> getWindowHandles() {
        this.waitForPageReady();
        return this.driver.getWindowHandles();
    }

    public String getWindowHandle() {
        this.waitForPageReady();
        return this.driver.getWindowHandle();
    }

    public WebDriver.TargetLocator switchTo(boolean wait) {
        if (wait) {
            this.waitForPageReady();
        }
        return this.driver.switchTo();
    }

    public WebDriver.Navigation navigate(boolean wait) {
        if (wait) {
            this.waitForPageReady();
        }
        return this.driver.navigate();
    }

    public WebDriver.TargetLocator switchTo() {
        return this.switchTo(false);
    }

    public WebDriver.Navigation navigate() {
        return this.navigate(false);
    }

    public WebDriver.Options manage() {
        return this.driver.manage();
    }

    public <X> X getScreenshotAs(OutputType<X> target) {
        if (!(this.driver instanceof TakesScreenshot)) {
            LOG.warn((Object)"Attempted to take screenshot but backing driver does not support it.");
            return null;
        }
        try {
            this.waitForPageReady();
        }
        catch (WebDriverException wde) {
            LOG.warn((Object)"Failed to wait for page ready prior to capturing screenshot", (Throwable)wde);
            return null;
        }
        return (X)((TakesScreenshot)this.driver).getScreenshotAs(target);
    }

    public UIContext getUserContextForSession() {
        String sessionId = this.getSessionId();
        if (sessionId != null) {
            return SeleniumLauncher.getContextForSession(sessionId);
        }
        return null;
    }

    public void clearUserContext() {
        String sessionId = this.getSessionId();
        if (sessionId != null) {
            SeleniumLauncher.destroyContextForSession(sessionId);
        }
    }

    protected SeleniumWComponentWebElement wrapElement(WebElement element) {
        if (element == null) {
            return null;
        }
        if (element instanceof SeleniumWComponentWebElement) {
            return (SeleniumWComponentWebElement)element;
        }
        return new SeleniumWComponentWebElement(element, this);
    }
}

