/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.wcomponents.test.selenium.element;

import com.github.bordertech.wcomponents.test.selenium.element.SeleniumWComponentWebElement;
import com.github.bordertech.wcomponents.test.selenium.element.SeleniumWComponentWebProperties;
import com.github.bordertech.wcomponents.util.Util;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public abstract class SeleniumGroupInputWebElement
extends SeleniumWComponentWebElement {
    public static final String WRAPPER_ELEMENT = "fieldset";

    public SeleniumGroupInputWebElement(WebElement element, WebDriver driver) {
        super(element, driver);
        String tagName = element.getTagName();
        if (!WRAPPER_ELEMENT.equalsIgnoreCase(tagName) && !this.isReadOnly()) {
            throw new IllegalArgumentException("Did not find expected tagName, expected fieldset but found " + tagName);
        }
        if (!this.isCorrectReadOnly()) {
            throw new IllegalArgumentException("Did not find expected read-only component.");
        }
    }

    private boolean isCorrectReadOnly() {
        if (this.isReadOnly()) {
            String ro = this.getRoComponent();
            if (!this.getROComponentName().equals(ro)) {
                return false;
            }
        }
        return true;
    }

    public final boolean isReadOnly() {
        return !Util.empty((String)this.getAttribute("data-wc-component"));
    }

    public boolean isMandatory() {
        if (!this.isEnabled()) {
            return false;
        }
        String className = this.getAttribute("class");
        if (className == null) {
            return false;
        }
        return className.contains(SeleniumWComponentWebProperties.CLASS_REQUIRED.toString());
    }

    private String getRoComponent() {
        if (!this.isReadOnly()) {
            return null;
        }
        return this.getAttribute(SeleniumWComponentWebProperties.ATTRIBUTE_WRAPPED_INPUT_TYPE.toString());
    }

    String getOptionTag() {
        return "input";
    }

    abstract String getROComponentName();
}

