/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.wcomponents.test.selenium.element;

import com.github.bordertech.wcomponents.test.selenium.element.SeleniumWComponentWebElement;
import com.github.bordertech.wcomponents.util.SystemException;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Select;

public class SeleniumSimpleSelectWebElement
extends SeleniumWComponentWebElement {
    public static final String TOP_LEVEL_TAG = "select";
    public static final String SELECTOR_NTH_OPTION = "option:nth-child(%s)";

    public SeleniumSimpleSelectWebElement(WebElement element, WebDriver driver) {
        super(element, driver);
        String tagName = element.getTagName();
        if (!TOP_LEVEL_TAG.equals(tagName)) {
            throw new IllegalArgumentException("Element is not the expected wrapper. tag=[" + tagName + "].");
        }
    }

    public String getValue() {
        WebElement selected = this.getSelectedOption();
        return selected == null ? "" : selected.getText();
    }

    public WebElement getSelectedOption() {
        Select se = new Select((WebElement)this);
        return se.getFirstSelectedOption();
    }

    public WebElement getFirstOption() {
        List<WebElement> options = this.getOptions();
        return options.get(0);
    }

    public WebElement getLastOption() {
        List<WebElement> options = this.getOptions();
        return options.get(options.size() - 1);
    }

    public SeleniumWComponentWebElement getNthOption(int optionNumber) {
        return this.findElementImmediate(By.cssSelector((String)String.format(SELECTOR_NTH_OPTION, optionNumber)));
    }

    public boolean isMultiSelect() {
        Select se = new Select((WebElement)this);
        return se.isMultiple();
    }

    public List<WebElement> getOptions() {
        Select se = new Select((WebElement)this);
        return se.getOptions();
    }

    public List<WebElement> getSelectedOptions() {
        Select se = new Select((WebElement)this);
        return se.getAllSelectedOptions();
    }

    public WebElement getOption(String optionText) {
        if (optionText == null) {
            throw new SystemException("option text must not be null");
        }
        for (WebElement we : this.getOptions()) {
            if (!optionText.equals(we.getText())) continue;
            return we;
        }
        throw new NoSuchElementException("No option with text provided");
    }
}

