/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.wcomponents.test.selenium.element;

import com.github.bordertech.wcomponents.UIContext;
import com.github.bordertech.wcomponents.test.selenium.ByWComponent;
import com.github.bordertech.wcomponents.test.selenium.SeleniumWComponentsUtil;
import com.github.bordertech.wcomponents.test.selenium.driver.SeleniumWComponentsWebDriver;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Point;
import org.openqa.selenium.Rectangle;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;

public class SeleniumWComponentWebElement
implements WebElement {
    private final WebElement element;
    private final WebDriver driver;

    public SeleniumWComponentWebElement(WebElement element, WebDriver driver) {
        if (element == null) {
            throw new IllegalArgumentException("WComponentWebElement cannot wrap a null element.");
        }
        if (driver == null) {
            throw new IllegalArgumentException("driver must not be null.");
        }
        this.element = element;
        this.driver = driver;
    }

    protected WebDriver getDriver() {
        return this.driver;
    }

    public void clear() {
        this.element.clear();
    }

    public void click() {
        if (this.element instanceof SeleniumWComponentWebElement) {
            this.element.click();
        } else {
            this.element.click();
            this.waitForPageReady();
        }
    }

    public void clickNoWait() {
        if (this.element instanceof SeleniumWComponentWebElement) {
            ((SeleniumWComponentWebElement)this.element).clickNoWait();
        } else {
            this.element.click();
        }
    }

    public SeleniumWComponentWebElement findElementImmediate(By by) {
        if (by instanceof ByWComponent) {
            ((ByWComponent)by).setContext(this.getUserContextForSession());
        }
        try {
            SeleniumWComponentsUtil.configureImmediateImplicitWait(this.driver);
            SeleniumWComponentWebElement seleniumWComponentWebElement = this.wrapElement(this.element.findElement(by));
            return seleniumWComponentWebElement;
        }
        finally {
            SeleniumWComponentsUtil.configureImplicitWait(this.driver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WebElement> findElementsImmediate(By by) {
        if (by instanceof ByWComponent) {
            ((ByWComponent)by).setContext(this.getUserContextForSession());
        }
        try {
            SeleniumWComponentsUtil.configureImmediateImplicitWait(this.driver);
            List webElements = this.element.findElements(by);
            ArrayList<SeleniumWComponentWebElement> wrappedList = new ArrayList<SeleniumWComponentWebElement>();
            for (WebElement webElement : webElements) {
                wrappedList.add(this.wrapElement(webElement));
            }
            ArrayList<SeleniumWComponentWebElement> arrayList = wrappedList;
            return arrayList;
        }
        finally {
            SeleniumWComponentsUtil.configureImplicitWait(this.driver);
        }
    }

    public SeleniumWComponentWebElement findElement(By by) {
        return this.wrapElement(this.element.findElement(by));
    }

    public List<WebElement> findElements(By by) {
        ArrayList<WebElement> elements = new ArrayList<WebElement>();
        for (WebElement e : this.element.findElements(by)) {
            elements.add(this.wrapElement(e));
        }
        return elements;
    }

    public String getAttribute(String name) {
        return this.element.getAttribute(name);
    }

    public String getTagName() {
        return this.element.getTagName();
    }

    public String getText() {
        return this.element.getText();
    }

    public boolean isEnabled() {
        return this.element.isEnabled();
    }

    public boolean isSelected() {
        return this.element.isSelected();
    }

    public boolean isHidden() {
        return this.element.getAttribute("hidden") != null;
    }

    public void sendKeys(CharSequence ... keys) {
        this.element.sendKeys(keys);
    }

    public void sendKeys(boolean wait, CharSequence ... keys) {
        this.element.sendKeys(keys);
        if (wait) {
            this.waitForPageReady();
        }
    }

    public void submit() {
        this.element.submit();
        this.waitForPageReady();
    }

    public boolean isDisplayed() {
        return this.element.isDisplayed();
    }

    public Point getLocation() {
        return this.element.getLocation();
    }

    public Dimension getSize() {
        return this.element.getSize();
    }

    public String getCssValue(String propertyName) {
        return this.element.getCssValue(propertyName);
    }

    public Rectangle getRect() {
        return this.element.getRect();
    }

    public <X> X getScreenshotAs(OutputType<X> ot) throws WebDriverException {
        return (X)this.element.getScreenshotAs(ot);
    }

    public String getActiveId() {
        return this.getAttribute("id");
    }

    public WebElement getElement() {
        return this.element;
    }

    public UIContext getUserContextForSession() {
        if (this.driver instanceof SeleniumWComponentsWebDriver) {
            return ((SeleniumWComponentsWebDriver)this.driver).getUserContextForSession();
        }
        return null;
    }

    public void waitForPageReady() {
        SeleniumWComponentsUtil.waitForPageReady(this.driver);
    }

    protected void clickElementNoWait(WebElement element) {
        if (element instanceof SeleniumWComponentWebElement) {
            ((SeleniumWComponentWebElement)element).clickNoWait();
        } else {
            element.click();
        }
    }

    protected SeleniumWComponentWebElement wrapElement(WebElement element) {
        if (element == null) {
            return null;
        }
        if (element instanceof SeleniumWComponentWebElement) {
            return (SeleniumWComponentWebElement)element;
        }
        return new SeleniumWComponentWebElement(element, this.getDriver());
    }
}

