/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.wcomponents.test.selenium.element;

import com.github.bordertech.wcomponents.test.selenium.SeleniumWComponentsUtil;
import com.github.bordertech.wcomponents.test.selenium.element.SeleniumWComponentWebElement;
import com.github.bordertech.wcomponents.test.selenium.element.SeleniumWComponentWebProperties;
import com.github.bordertech.wcomponents.util.SystemException;
import com.github.bordertech.wcomponents.util.Util;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class SeleniumWLabelWebElement
extends SeleniumWComponentWebElement {
    private static final String LABEL_ELEMENT = "label";
    private static final String FAUX_LABEL_ELEMENT = "span";
    private static final String CLASS_NAME = "wc-label";
    private static final String LABEL_FOR_ATTRIB = SeleniumWComponentWebProperties.ATTRIBUTE_LABEL_FOR.toString();
    private static final String FAUX_FOR_ATTRIBUTE = SeleniumWComponentWebProperties.ATTRIBUTE_LABEL_FAUX_FOR.toString();
    private static final String RO_FOR_ATTRIBUTE = SeleniumWComponentWebProperties.ATTRIBUTE_LABEL_FOR_READ_ONLY.toString();

    public SeleniumWLabelWebElement(WebElement element, WebDriver driver) {
        super(element, driver);
        String className;
        String tagName = element.getTagName();
        if (!LABEL_ELEMENT.equalsIgnoreCase(tagName) && !FAUX_LABEL_ELEMENT.equalsIgnoreCase(tagName)) {
            throw new SystemException("Incorrect element selected for SeleniumWLabelWebElement. Found: " + tagName);
        }
        if (FAUX_LABEL_ELEMENT.equalsIgnoreCase(tagName) && !(className = element.getAttribute("class")).contains(CLASS_NAME)) {
            throw new SystemException("Incorrect element selected for SeleniumWLabelWebElement. Expected className to include `wc-label` found: " + className);
        }
    }

    public SeleniumWComponentWebElement getLabelledComponent() {
        String tagName = this.getTagName();
        String attribName = LABEL_ELEMENT.equalsIgnoreCase(tagName) ? LABEL_FOR_ATTRIB : FAUX_FOR_ATTRIBUTE;
        String forId = this.getAttribute(attribName);
        if (Util.empty((String)forId) && FAUX_LABEL_ELEMENT.equalsIgnoreCase(tagName)) {
            forId = this.getAttribute(RO_FOR_ATTRIBUTE);
        }
        if (Util.empty((String)forId)) {
            throw new SystemException("No labelled component found, expected id " + forId);
        }
        SeleniumWComponentWebElement element = this.findElementImmediate(By.xpath((String)("//*[@id='" + forId + "']")));
        if (attribName.equals(LABEL_FOR_ATTRIB)) {
            return SeleniumWComponentsUtil.wrapInputElementWithTypedWebElement(this.getDriver(), element);
        }
        return element;
    }

    public WebElement getHint() {
        return this.findElementImmediate(By.cssSelector((String)".wc-label-hint"));
    }

    public boolean isReadOnly() {
        String forId = this.getAttribute(RO_FOR_ATTRIBUTE);
        return !Util.empty((String)forId);
    }

    @Override
    public boolean isHidden() {
        return this.getAttribute("class").contains("wc-off");
    }
}

