/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.wcomponents.test.selenium.element;

import com.github.bordertech.wcomponents.WMessageBox;
import com.github.bordertech.wcomponents.test.selenium.element.SeleniumWComponentWebElement;
import com.github.bordertech.wcomponents.util.SystemException;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class SeleniumWMessageBoxWebElement
extends SeleniumWComponentWebElement {
    public static final String TAG_NAME = "section";
    public static final String CLASS_NAME = "wc-messagebox";
    public static final String MESSAGE_CLASS_NAME = "wc-message";
    public static final String ERROR_CLASS_NAME = "wc-error";
    public static final String VALIDATION_ERRORS_CLASSNAME = "wc-validationerrors";
    public static final String TYPE_ERROR_CLASS_NAME = "wc-messagebox-type-error";
    public static final String TYPE_WARNING_CLASS_NAME = "wc-messagebox-type-warn";
    public static final String TYPE_INFO_CLASS_NAME = "wc-messagebox-type-info";
    public static final String TYPE_SUCCESS_CLASS_NAME = "wc-messagebox-type-success";

    public SeleniumWMessageBoxWebElement(WebElement element, WebDriver driver) {
        super(element, driver);
        if (!TAG_NAME.equalsIgnoreCase(this.getTagName())) {
            throw new SystemException("Incorrect element selected for SeleniumWMessageBoxWebElement. Expected tagname to be `section`but  found: " + this.getTagName());
        }
        String className = element.getAttribute("class");
        if (!className.contains(CLASS_NAME) && !className.contains(VALIDATION_ERRORS_CLASSNAME)) {
            throw new SystemException("Incorrect element selected for SeleniumWMessageBoxWebElement. Expected className to include `wc-messagebox` or `wc-validationerrors` found: " + className);
        }
        if (this.getType() == null && !this.isWValidationErrors()) {
            throw new SystemException("unexpected type for WValidationErrors message box.");
        }
    }

    public List<WebElement> getMessages() {
        if (this.isWValidationErrors()) {
            return this.findElementsImmediate(By.className((String)ERROR_CLASS_NAME));
        }
        return this.findElementsImmediate(By.className((String)MESSAGE_CLASS_NAME));
    }

    public WebElement getMessage(int idx) {
        return this.getMessages().get(idx);
    }

    public WebElement getMessage() {
        return this.getMessage(0);
    }

    private boolean isWValidationErrors() {
        return this.getElement().getAttribute("class").contains(VALIDATION_ERRORS_CLASSNAME);
    }

    private WMessageBox.Type getType() {
        String className = this.getElement().getAttribute("class");
        if (className.contains(TYPE_ERROR_CLASS_NAME)) {
            if (this.isWValidationErrors()) {
                return null;
            }
            return WMessageBox.ERROR;
        }
        if (className.contains(TYPE_WARNING_CLASS_NAME)) {
            return WMessageBox.WARN;
        }
        if (className.contains(TYPE_INFO_CLASS_NAME)) {
            return WMessageBox.INFO;
        }
        if (className.contains(TYPE_SUCCESS_CLASS_NAME)) {
            return WMessageBox.SUCCESS;
        }
        throw new SystemException("Unable to determine message box type.");
    }

    public WMessageBox.Type getMessageBoxType() {
        return this.getType();
    }
}

