/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.wcomponents.test.selenium.element;

import com.github.bordertech.wcomponents.test.selenium.element.SeleniumWComponentInputWebElement;
import com.github.bordertech.wcomponents.test.selenium.element.SeleniumWComponentWebElement;
import com.github.bordertech.wcomponents.test.selenium.element.SeleniumWComponentWebProperties;
import com.github.bordertech.wcomponents.util.SystemException;
import com.github.bordertech.wcomponents.util.Util;
import java.util.Arrays;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class SeleniumWTextAreaWebElement
extends SeleniumWComponentInputWebElement {
    private static final String ATTR_MAX_LENGTH = "data-wc-maxlength";
    private static final List<String> INPUT_ATTRIBUTES = Arrays.asList("disabled", "required", "minlength", "data-wc-maxlength");
    public static final String READ_ONLY_TAG = "pre";
    public static final String RTF_READ_ONLY_TAG = "div";
    public static final String TEXTAREA_TAG = "textarea";

    public SeleniumWTextAreaWebElement(WebElement element, WebDriver driver) {
        super(element, driver);
        String tagName = element.getTagName();
        if (!(tagName.equals("span") || tagName.equals(READ_ONLY_TAG) || tagName.equals(RTF_READ_ONLY_TAG))) {
            throw new IllegalArgumentException("Element is not the expected wrapper. tag=[" + tagName + "].");
        }
    }

    @Override
    public String getValue() {
        return super.getValue().replaceAll("\r\n", "\n");
    }

    @Override
    public String getAttribute(String name) {
        if (SeleniumWComponentWebProperties.ATTRIBUTE_MAX_LENGTH.toString().equals(name)) {
            return this.getInputField().getAttribute(ATTR_MAX_LENGTH);
        }
        if (INPUT_ATTRIBUTES.contains(name)) {
            if (this.isReadOnly()) {
                return null;
            }
            return this.getInputField().getAttribute(name);
        }
        return super.getAttribute(name);
    }

    public int getMaxLength() {
        String maxLength = this.getAttribute(ATTR_MAX_LENGTH);
        if (Util.empty((String)maxLength)) {
            return 0;
        }
        try {
            return Integer.parseInt(maxLength);
        }
        catch (NumberFormatException ex) {
            throw new SystemException("Unexpected non-integer value of maxLength.", (Throwable)ex);
        }
    }

    @Override
    public SeleniumWComponentWebElement getInputField() {
        if (this.isReadOnly()) {
            return null;
        }
        return this.findElementImmediate(By.tagName((String)TEXTAREA_TAG));
    }

    public void clearContent() {
        SeleniumWComponentWebElement input = this.getInputField();
        input.sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.CONTROL, "a"})});
        input.sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.COMMAND, "a"})});
        input.sendKeys(new CharSequence[]{Keys.DELETE});
        input.sendKeys(new CharSequence[]{Keys.BACK_SPACE});
    }
}

