<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ui="https://github.com/bordertech/wcomponents/namespace/ui/v1.0"
                xmlns:html="http://www.w3.org/1999/xhtml"
                xmlns:doc="http://www.oxygenxml.com/ns/doc/xsl"
                version="1.0"
                exclude-result-prefixes="xsl ui html doc">
   <xsl:output encoding="UTF-8"
               indent="no"
               method="html"
               doctype-system="about:legacy-compat"
               omit-xml-declaration="yes"/>
   <xsl:strip-space elements="*"/>
   <!--Saxonica-->
   <xsl:param name="asciimap">
      <xsl:text>{"\u00e0\u00e2\u00e4": "a","\u00e8\u00e9\u00ea\u00eb": "e","\u00ee\u00ef": "i","\u00f4": "o","\u00f9\u00fb\u00fc": "u","c": "\u00e7"}</xsl:text>
   </xsl:param>
   <xsl:param name="btt0">
      <xsl:text>Back to top (press the ESCAPE key to hide this)</xsl:text>
   </xsl:param>
   <xsl:param name="cbg1">
      <xsl:text>Select one or more options</xsl:text>
   </xsl:param>
   <xsl:param name="cbg2">
      <xsl:text>SHIFT + click to action a range of options</xsl:text>
   </xsl:param>
   <xsl:param name="chi1">
      <xsl:text>selected</xsl:text>
   </xsl:param>
   <xsl:param name="chi2">
      <xsl:text>not selected</xsl:text>
   </xsl:param>
   <xsl:param name="cm0">
      <xsl:text>Expand all</xsl:text>
   </xsl:param>
   <xsl:param name="cm1">
      <xsl:text>This component requires a label</xsl:text>
   </xsl:param>
   <xsl:param name="cm2">
      <xsl:text>required</xsl:text>
   </xsl:param>
   <xsl:param name="cm3">
      <xsl:text>Changing the value or selection of this component will cause all of your changes to be saved immediately.</xsl:text>
   </xsl:param>
   <xsl:param name="cm4">
      <xsl:text>[a-zA-Z]</xsl:text>
   </xsl:param>
   <xsl:param name="cu1">
      <xsl:text>has unsaved changes. Would you like to discard them?</xsl:text>
   </xsl:param>
   <xsl:param name="cu2">
      <xsl:text>This page</xsl:text>
   </xsl:param>
   <xsl:param name="day0">
      <xsl:text>Sunday</xsl:text>
   </xsl:param>
   <xsl:param name="day1">
      <xsl:text>Monday</xsl:text>
   </xsl:param>
   <xsl:param name="day2">
      <xsl:text>Tuesday</xsl:text>
   </xsl:param>
   <xsl:param name="day3">
      <xsl:text>Wednesday</xsl:text>
   </xsl:param>
   <xsl:param name="day4">
      <xsl:text>Thursday</xsl:text>
   </xsl:param>
   <xsl:param name="day5">
      <xsl:text>Friday</xsl:text>
   </xsl:param>
   <xsl:param name="day6">
      <xsl:text>Saturday</xsl:text>
   </xsl:param>
   <xsl:param name="df0">
      <xsl:text>Shortcuts: t/y/m = today/yesterday/tomorrow. 
+/-N = +/-N days from now, e.g. +7.</xsl:text>
   </xsl:param>
   <xsl:param name="df1">
      <xsl:text>d M yy,M d yy,d M yyyy,M d yyyy,d MON yy,d MON yyyy,dd MON yy,dd MON yyyy,dMyy,dMyyyy,dMMyy,dMMyyyy,ddMMyyyy,ddMMyy,ddMMyyyy,ddMyyyy,ddMyy,dMONyy,dMONyyyy,yyyy-MM-dd,yyyyMMdd,dd/MM/yyyy,dd/M/yyyy,d/MM/yyyy,d/M/yyyy,dd/MM/yy,dd/M/yy,d/MM/yy,d/M/yy,MM/dd/yyyy,M/yyyydd/,MM/d/yyyy,M/d/yyyy,MM/dd/yy,M/dd/yy,MM/d/yy,M/d/yy,MMddyy,MMddyyyy,MMdyyyy,MMdyy,Mddyyyy,Mddyy,Mdyy,Mdyyyy</xsl:text>
   </xsl:param>
   <xsl:param name="df10">
      <xsl:text>Previous month</xsl:text>
   </xsl:param>
   <xsl:param name="df11">
      <xsl:text>Next month</xsl:text>
   </xsl:param>
   <xsl:param name="df12">
      <xsl:text>Today</xsl:text>
   </xsl:param>
   <xsl:param name="df13">
      <xsl:text>Close</xsl:text>
   </xsl:param>
   <xsl:param name="df2">
      <xsl:text>M y,MON y,M yyyy,MON yyyy,MONy,MONyy,MONyyyy,MMyy,MMyyyy,yyyyMM,yyyyM,Myy,Myyyy,yyMM,yyM,y,yyyy,M,MM,MON,d M,M d,dM,Md,dMM,MMd,ddMM,MMdd,ddM,Mdd,d MON,MON d,dd MON,MON dd,dMON,MONd,ddMON,MONdd,d,dd yyyy,ddyyyy,ddyy,dd yy,dyyyy,dyy</xsl:text>
   </xsl:param>
   <xsl:param name="df3">
      <xsl:text>dd MON yyyy</xsl:text>
   </xsl:param>
   <xsl:param name="df6">
      <xsl:text>yyyy</xsl:text>
   </xsl:param>
   <xsl:param name="df7">
      <xsl:text>Month</xsl:text>
   </xsl:param>
   <xsl:param name="df8">
      <xsl:text>Year</xsl:text>
   </xsl:param>
   <xsl:param name="df9">
      <xsl:text>Calendar date picker</xsl:text>
   </xsl:param>
   <xsl:param name="dlg0">
      <xsl:text>Untitled Dialog</xsl:text>
   </xsl:param>
   <xsl:param name="dlg1">
      <xsl:text>ARROW to move dialog</xsl:text>
   </xsl:param>
   <xsl:param name="dlg2">
      <xsl:text>ARROW RIGHT or ARROW_DOWN to enlarge dialog, ARROW LEFT or  ARROW UP to shrink dialog</xsl:text>
   </xsl:param>
   <xsl:param name="dlg3">
      <xsl:text>Close dialog</xsl:text>
   </xsl:param>
   <xsl:param name="dlg4">
      <xsl:text>Maximise/restore dialog</xsl:text>
   </xsl:param>
   <xsl:param name="iet0">
      <xsl:text>Rotate</xsl:text>
   </xsl:param>
   <xsl:param name="iet1">
      <xsl:text>Left</xsl:text>
   </xsl:param>
   <xsl:param name="iet10">
      <xsl:text>Image Editor</xsl:text>
   </xsl:param>
   <xsl:param name="iet11">
      <xsl:text>Left 90º</xsl:text>
   </xsl:param>
   <xsl:param name="iet12">
      <xsl:text>Right 90º</xsl:text>
   </xsl:param>
   <xsl:param name="iet2">
      <xsl:text>Right</xsl:text>
   </xsl:param>
   <xsl:param name="iet3">
      <xsl:text>Move</xsl:text>
   </xsl:param>
   <xsl:param name="iet4">
      <xsl:text>Left</xsl:text>
   </xsl:param>
   <xsl:param name="iet5">
      <xsl:text>Right</xsl:text>
   </xsl:param>
   <xsl:param name="iet6">
      <xsl:text>Up</xsl:text>
   </xsl:param>
   <xsl:param name="iet7">
      <xsl:text>Down</xsl:text>
   </xsl:param>
   <xsl:param name="iet8">
      <xsl:text>Zoom</xsl:text>
   </xsl:param>
   <xsl:param name="iet9">
      <xsl:text>In</xsl:text>
   </xsl:param>
   <xsl:param name="ietA">
      <xsl:text>Out</xsl:text>
   </xsl:param>
   <xsl:param name="ietB">
      <xsl:text>Reset</xsl:text>
   </xsl:param>
   <xsl:param name="ietC">
      <xsl:text>Cancel</xsl:text>
   </xsl:param>
   <xsl:param name="ietD">
      <xsl:text>Save</xsl:text>
   </xsl:param>
   <xsl:param name="ietE">
      <xsl:text>Photo</xsl:text>
   </xsl:param>
   <xsl:param name="ietF">
      <xsl:text>Speed</xsl:text>
   </xsl:param>
   <xsl:param name="ietF1">
      <xsl:text>Your browser does not support webcam capture</xsl:text>
   </xsl:param>
   <xsl:param name="lang">
      <xsl:text>en</xsl:text>
   </xsl:param>
   <xsl:param name="load1">
      <xsl:text>Loading</xsl:text>
   </xsl:param>
   <xsl:param name="locale">
      <xsl:text>en</xsl:text>
   </xsl:param>
   <xsl:param name="lsc1">
      <xsl:text>move to top</xsl:text>
   </xsl:param>
   <xsl:param name="lsc2">
      <xsl:text>move up</xsl:text>
   </xsl:param>
   <xsl:param name="lsc3">
      <xsl:text>move down</xsl:text>
   </xsl:param>
   <xsl:param name="lsc4">
      <xsl:text>move to bottom</xsl:text>
   </xsl:param>
   <xsl:param name="lstldr0">
      <xsl:text>An error occurred loading the list%s</xsl:text>
   </xsl:param>
   <xsl:param name="lstldr1">
      <xsl:text>Retry</xsl:text>
   </xsl:param>
   <xsl:param name="mb0">
      <xsl:text>An error has occurred</xsl:text>
   </xsl:param>
   <xsl:param name="mb1">
      <xsl:text>Warning</xsl:text>
   </xsl:param>
   <xsl:param name="mb2">
      <xsl:text>Information</xsl:text>
   </xsl:param>
   <xsl:param name="mb3">
      <xsl:text>Success</xsl:text>
   </xsl:param>
   <xsl:param name="media1">
      <xsl:text>play</xsl:text>
   </xsl:param>
   <xsl:param name="media2">
      <xsl:text>pause</xsl:text>
   </xsl:param>
   <xsl:param name="menu1">
      <xsl:text>wc_coleast</xsl:text>
   </xsl:param>
   <xsl:param name="menu2">
      <xsl:text>wc_colwest</xsl:text>
   </xsl:param>
   <xsl:param name="menu3">
      <xsl:text>Close</xsl:text>
   </xsl:param>
   <xsl:param name="mfc0">
      <xsl:text>Add item to: </xsl:text>
   </xsl:param>
   <xsl:param name="mfc1">
      <xsl:text>Remove item. Shift + click remove button to remove all.</xsl:text>
   </xsl:param>
   <xsl:param name="mfc2">
      <xsl:text>select an option</xsl:text>
   </xsl:param>
   <xsl:param name="mfc3">
      <xsl:text>You have reached the maximum options to select.</xsl:text>
   </xsl:param>
   <xsl:param name="mfu0">
      <xsl:text>The file you have selected is too large (%1$s %3$s).
Maximum file size is %2$s %3$s.</xsl:text>
   </xsl:param>
   <xsl:param name="mfu1">
      <xsl:text>The file you have selected is not of an accepted type.
Only the following type/s are accepted: %s.</xsl:text>
   </xsl:param>
   <xsl:param name="mfu2">
      <xsl:text>If you navigate away from this page your current file upload will be cancelled.
Are you sure you wish to proceed?</xsl:text>
   </xsl:param>
   <xsl:param name="mfu3">
      <xsl:text>bytes</xsl:text>
   </xsl:param>
   <xsl:param name="mfu4">
      <xsl:text>file selector</xsl:text>
   </xsl:param>
   <xsl:param name="mfu5">
      <xsl:text>kilobytes</xsl:text>
   </xsl:param>
   <xsl:param name="mfu6">
      <xsl:text>megabytes</xsl:text>
   </xsl:param>
   <xsl:param name="mfu7">
      <xsl:text>gigabytes</xsl:text>
   </xsl:param>
   <xsl:param name="mfu8">
      <xsl:text>Are you sure you wish to remove this file?</xsl:text>
   </xsl:param>
   <xsl:param name="mfu9">
      <xsl:text>You cannot upload more files, the maximum allowed is %2$s.</xsl:text>
   </xsl:param>
   <xsl:param name="mnth0">
      <xsl:text>January</xsl:text>
   </xsl:param>
   <xsl:param name="mnth1">
      <xsl:text>February</xsl:text>
   </xsl:param>
   <xsl:param name="mnth2">
      <xsl:text>March</xsl:text>
   </xsl:param>
   <xsl:param name="mnth3">
      <xsl:text>April</xsl:text>
   </xsl:param>
   <xsl:param name="mnth4">
      <xsl:text>May</xsl:text>
   </xsl:param>
   <xsl:param name="mnth5">
      <xsl:text>June</xsl:text>
   </xsl:param>
   <xsl:param name="mnth6">
      <xsl:text>July</xsl:text>
   </xsl:param>
   <xsl:param name="mnth7">
      <xsl:text>August</xsl:text>
   </xsl:param>
   <xsl:param name="mnth8">
      <xsl:text>September</xsl:text>
   </xsl:param>
   <xsl:param name="mnth9">
      <xsl:text>October</xsl:text>
   </xsl:param>
   <xsl:param name="mnthA">
      <xsl:text>November</xsl:text>
   </xsl:param>
   <xsl:param name="mnthB">
      <xsl:text>December</xsl:text>
   </xsl:param>
   <xsl:param name="mnthabbr0">
      <xsl:text>Jan</xsl:text>
   </xsl:param>
   <xsl:param name="mnthabbr1">
      <xsl:text>Feb</xsl:text>
   </xsl:param>
   <xsl:param name="mnthabbr2">
      <xsl:text>Mar</xsl:text>
   </xsl:param>
   <xsl:param name="mnthabbr3">
      <xsl:text>Apr</xsl:text>
   </xsl:param>
   <xsl:param name="mnthabbr4">
      <xsl:text>May</xsl:text>
   </xsl:param>
   <xsl:param name="mnthabbr5">
      <xsl:text>Jun</xsl:text>
   </xsl:param>
   <xsl:param name="mnthabbr6">
      <xsl:text>Jul</xsl:text>
   </xsl:param>
   <xsl:param name="mnthabbr7">
      <xsl:text>Aug</xsl:text>
   </xsl:param>
   <xsl:param name="mnthabbr8">
      <xsl:text>Sep</xsl:text>
   </xsl:param>
   <xsl:param name="mnthabbr9">
      <xsl:text>Oct</xsl:text>
   </xsl:param>
   <xsl:param name="mnthabbrA">
      <xsl:text>Nov</xsl:text>
   </xsl:param>
   <xsl:param name="mnthabbrB">
      <xsl:text>Dec</xsl:text>
   </xsl:param>
   <xsl:param name="msp0">
      <xsl:text>Add </xsl:text>
   </xsl:param>
   <xsl:param name="msp1">
      <xsl:text>Add All </xsl:text>
   </xsl:param>
   <xsl:param name="msp2">
      <xsl:text>Remove</xsl:text>
   </xsl:param>
   <xsl:param name="msp3">
      <xsl:text>Remove All</xsl:text>
   </xsl:param>
   <xsl:param name="mx0">
      <xsl:text>%d characters remaining</xsl:text>
   </xsl:param>
   <xsl:param name="p1">
      <xsl:text>Untitled Section</xsl:text>
   </xsl:param>
   <xsl:param name="rbg1">
      <xsl:text>Select an option</xsl:text>
   </xsl:param>
   <xsl:param name="rt0">
      <xsl:text>You must have JavaScript enabled to use this application.</xsl:text>
   </xsl:param>
   <xsl:param name="sbxs1">
      <xsl:text>abcdefghijklmnopqrstuvwxyz0123456789~`!@#$%^&amp;*()-_=+[{]}\|;:'",&lt;.&gt;/? </xsl:text>
   </xsl:param>
   <xsl:param name="sk1">
      <xsl:text>Skip to </xsl:text>
   </xsl:param>
   <xsl:param name="tble1">
      <xsl:text>No data</xsl:text>
   </xsl:param>
   <xsl:param name="tble13">
      <xsl:text>Select/deselect all</xsl:text>
   </xsl:param>
   <xsl:param name="tble4">
      <xsl:text>Expand or collapse sections</xsl:text>
   </xsl:param>
   <xsl:param name="tble5">
      <xsl:text>Sorted descending</xsl:text>
   </xsl:param>
   <xsl:param name="tble6">
      <xsl:text>Sorted ascending</xsl:text>
   </xsl:param>
   <xsl:param name="tble7">
      <xsl:text>Sortable but not sorted</xsl:text>
   </xsl:param>
   <xsl:param name="tog1">
      <xsl:text>Select:</xsl:text>
   </xsl:param>
   <xsl:param name="tog2">
      <xsl:text>All</xsl:text>
   </xsl:param>
   <xsl:param name="tog3">
      <xsl:text>None</xsl:text>
   </xsl:param>
   <xsl:param name="tog4">
      <xsl:text>Select all</xsl:text>
   </xsl:param>
   <xsl:param name="tog5">
      <xsl:text>Collapse all</xsl:text>
   </xsl:param>
   <xsl:param name="tre1">
      <xsl:text>Show/hide content</xsl:text>
   </xsl:param>
   <xsl:param name="trs1">
      <xsl:text>Select one or more rows</xsl:text>
   </xsl:param>
   <xsl:param name="trs2">
      <xsl:text>Select a row</xsl:text>
   </xsl:param>
   <xsl:param name="twm1">
      <xsl:text>Warning</xsl:text>
   </xsl:param>
   <xsl:param name="twm2">
      <xsl:text>&lt;p&gt;Your session will be automatically ended within the next %s minutes.&lt;/p&gt;&lt;p&gt;This is because the server has not registered any activity for some time.&lt;/p&gt;&lt;p&gt;To reset your session timer you can do one of the following actions:&lt;/p&gt;&lt;ul&gt;&lt;li&gt;save your work; or&lt;/li&gt;&lt;li&gt;navigate to a different page.&lt;/li&gt;&lt;/ul&gt;</xsl:text>
   </xsl:param>
   <xsl:param name="twm3">
      <xsl:text>Session Expired</xsl:text>
   </xsl:param>
   <xsl:param name="twm4">
      <xsl:text>&lt;p&gt;Your session has expired.&lt;/p&gt;&lt;p&gt;There may have been changes that were not saved.&lt;/p&gt;&lt;p&gt;To start a new session you can do one of the following actions:&lt;/p&gt;&lt;ul&gt;&lt;li&gt;navigate to the home page; or&lt;/li&gt;&lt;li&gt;close this window and open a new application.&lt;/li&gt;&lt;/ul&gt;</xsl:text>
   </xsl:param>
   <xsl:param name="wdtp0">
      <xsl:text>First page</xsl:text>
   </xsl:param>
   <xsl:param name="wdtp1">
      <xsl:text>Previous page</xsl:text>
   </xsl:param>
   <xsl:param name="wdtp10">
      <xsl:text>all</xsl:text>
   </xsl:param>
   <xsl:param name="wdtp2">
      <xsl:text>Next page</xsl:text>
   </xsl:param>
   <xsl:param name="wdtp3">
      <xsl:text>Last page</xsl:text>
   </xsl:param>
   <xsl:param name="wdtp4">
      <xsl:text>Page</xsl:text>
   </xsl:param>
   <xsl:param name="wdtp5">
      <xsl:text>1 result</xsl:text>
   </xsl:param>
   <xsl:param name="wdtp6">
      <xsl:text>^ of # results</xsl:text>
   </xsl:param>
   <xsl:param name="wdtp7">
      <xsl:text>^ - | of # results</xsl:text>
   </xsl:param>
   <xsl:param name="wdtp9">
      <xsl:text>Rows per page</xsl:text>
   </xsl:param>
   <xsl:param name="isDebug" select="1"/>
   <xsl:param name="xslPath">
		    <xsl:call-template name="getXslPath"/>
	  </xsl:param>
   <xsl:key name="triggerKey" match="//ui:ajaxTrigger" use="@triggerId"/>
   <xsl:key name="collapsibleGroupKey"
            match="//ui:collapsible[@groupName]"
            use="@groupName"/>
   <xsl:key name="checkboxIdKey" match="//ui:checkBox[@groupName]" use="@id"/>
   <xsl:key name="checkboxGroupKey"
            match="//ui:checkBox[@groupName]"
            use="@groupName"/>
   <xsl:key name="errorKey" match="//ui:error" use="@for"/>
   <xsl:key name="labelKey" match="//ui:label" use="@for"/>
   <xsl:key name="targetKey" match="//ui:ajaxTargetId" use="@targetId"/>
   <xsl:key name="labelableElementKey"
            match="//ui:button|//ui:checkBox|//ui:dateField|//ui:dropdown|//ui:emailField|//ui:fileUpload[@async='false']|//ui:listBox|//ui:numberField|//ui:passwordField|//ui:phoneNumberField|//ui:printButton|//ui:progressBar|//ui:radioButton|//ui:selectToggle[@renderAs='control']|//ui:textArea|//ui:textField"
            use="@id"/>
   <xsl:key name="conditionKey" match="//ui:radioButton" use="@id"/>
   <xsl:variable name="t" select="'true'"/>
   <xsl:variable name="scriptDir">
		    <xsl:choose>
			      <xsl:when test="$isDebug=1">
				        <xsl:text>scripts_debug</xsl:text>
			      </xsl:when>
			      <xsl:otherwise>
				        <xsl:text>scripts</xsl:text>
			      </xsl:otherwise>
		    </xsl:choose>
	  </xsl:variable>
   <xsl:variable name="resourceRoot">
		    <xsl:value-of select="substring-before($xslPath, 'xslt')"/>
	  </xsl:variable>
   <xsl:variable name="cacheBuster">
		    <xsl:value-of select="substring-after($xslPath, '?')"/>
	  </xsl:variable>
   <xsl:template match="ui:button|ui:printButton">
		    <button name="{@id}" value="x">
			      <xsl:attribute name="type">
				        <xsl:choose>
					          <xsl:when test="self::ui:printButton or parent::ui:dialog">
						            <xsl:text>button</xsl:text>
					          </xsl:when>
					          <xsl:otherwise>
						            <xsl:text>submit</xsl:text>
					          </xsl:otherwise>
				        </xsl:choose>
			      </xsl:attribute>
			
			      <xsl:attribute name="class">
				        <xsl:call-template name="commonClassHelper"/>
				        <xsl:if test="self::ui:button">
					          <xsl:if test="@unsavedChanges">
						            <xsl:text> wc_unsaved</xsl:text>
					          </xsl:if>
					          <xsl:if test="@cancel">
						            <xsl:text> wc_btn_cancel</xsl:text>
					          </xsl:if>
					          <xsl:if test="parent::ui:action">
						            <xsl:text> wc_table_cond</xsl:text>
					          </xsl:if>
				        </xsl:if>
				        <xsl:if test="@type='link'">
					          <xsl:text> wc_btn_link</xsl:text>
				        </xsl:if>
				        <xsl:if test="@imagePosition">
					          <xsl:value-of select="concat(' wc_btn_img',@imagePosition)"/>
				        </xsl:if>
				        <xsl:if test="@imageUrl and not(@imagePosition)">
					          <xsl:text> wc_btn_img</xsl:text>
				        </xsl:if>
			      </xsl:attribute>
			

			
			      <xsl:if test="self::ui:button">
				        <xsl:if test="@msg">
					          <xsl:attribute name="data-wc-btnmsg">
						            <xsl:value-of select="@msg"/>
					          </xsl:attribute>
				        </xsl:if>
				
				        <xsl:choose>
					          <xsl:when test="@cancel or parent::ui:action">
						            <xsl:attribute name="formnovalidate">
							              <xsl:text>formnovalidate</xsl:text>
						            </xsl:attribute>
					          </xsl:when>
					          <xsl:when test="@validates">
						            <xsl:attribute name="data-wc-validate">
							              <xsl:value-of select="@validates"/>
						            </xsl:attribute>
					          </xsl:when>
					          <xsl:when test="key('triggerKey',@id)">
						
						            <xsl:attribute name="formnovalidate">
							              <xsl:text>formnovalidate</xsl:text>
						            </xsl:attribute>
					          </xsl:when>
				        </xsl:choose>
				        <xsl:if test="@popup or parent::ui:dialog">
					          <xsl:attribute name="aria-haspopup">
						            <xsl:copy-of select="$t"/>
					          </xsl:attribute>
				        </xsl:if>
				        <xsl:choose>
					          <xsl:when test="parent::ui:dialog">
						            <xsl:attribute name="data-wc-dialogconf">
							              <xsl:value-of select="parent::ui:dialog/@id"/>
						            </xsl:attribute>
					          </xsl:when>
					          <xsl:when test="parent::ui:action">
						            <xsl:variable name="conditions">
							              <xsl:apply-templates select="../ui:condition" mode="action"/>
						            </xsl:variable>
						            <xsl:if test="$conditions != ''">
							              <xsl:attribute name="data-wc-condition">
								                <xsl:text>[</xsl:text>
								                <xsl:value-of select="$conditions"/>
								                <xsl:text>]</xsl:text>
							              </xsl:attribute>
						            </xsl:if>
					          </xsl:when>
				        </xsl:choose>
			      </xsl:if>
			      <xsl:call-template name="buttonLinkCommon"/>
		    </button>
	  </xsl:template>
   <xsl:template match="ui:checkBox|ui:radioButton">
		    <xsl:variable name="type">
			      <xsl:choose>
				        <xsl:when test="self::ui:checkBox or not(@groupName)">
					          <xsl:text>checkbox</xsl:text>
				        </xsl:when>
				        <xsl:otherwise>
					          <xsl:text>radio</xsl:text>
				        </xsl:otherwise>
			      </xsl:choose>
		    </xsl:variable>
		    <xsl:variable name="id">
			      <xsl:value-of select="@id"/>
		    </xsl:variable>
		    <xsl:variable name="name">
			      <xsl:choose>
				        <xsl:when test="@groupName and self::ui:radioButton">
					          <xsl:value-of select="@groupName"/>
				        </xsl:when>
				        <xsl:otherwise>
					          <xsl:value-of select="$id"/>
				        </xsl:otherwise>
			      </xsl:choose>
		    </xsl:variable>
		    <xsl:variable name="myLabel" select="key('labelKey',$id)"/>
		    <xsl:choose>
			      <xsl:when test="@readOnly">
				        <xsl:call-template name="readOnlyControl">
					          <xsl:with-param name="class">
						            <xsl:if test="@selected">
							              <xsl:text>wc_ro_sel</xsl:text>
						            </xsl:if>
					          </xsl:with-param>
					          <xsl:with-param name="toolTip">
						            <xsl:choose>
							              <xsl:when test="@selected">
								                <xsl:value-of select="$chi1"/>
							              </xsl:when>
							              <xsl:otherwise>
								                <xsl:value-of select="$chi2"/>
							              </xsl:otherwise>
						            </xsl:choose>
					          </xsl:with-param>
					          <xsl:with-param name="label" select="$myLabel[1]"/>
				        </xsl:call-template>
				        <xsl:apply-templates select="$myLabel[1]" mode="checkable">
					          <xsl:with-param name="labelableElement" select="."/>
				        </xsl:apply-templates>
			      </xsl:when>
			      <xsl:otherwise>
				        <xsl:variable name="isError" select="key('errorKey',$id)"/>
				        <xsl:element name="input">
					          <xsl:attribute name="type">
						            <xsl:value-of select="$type"/>
					          </xsl:attribute>
					          <xsl:call-template name="commonControlAttributes">
						            <xsl:with-param name="isError" select="$isError"/>
						            <xsl:with-param name="name" select="$name"/>
						            <xsl:with-param name="myLabel" select="$myLabel[1]"/>
					          </xsl:call-template>
					
					          <xsl:if test="self::ui:checkBox">
						            <xsl:attribute name="value">
							              <xsl:copy-of select="$t"/>
						            </xsl:attribute>
						            <xsl:attribute name="data-wc-cb">
							              <xsl:text>x</xsl:text>
						            </xsl:attribute>
					          </xsl:if>
					          <xsl:if test="@groupName and self::ui:checkBox">
						            <xsl:attribute name="data-wc-cbgroup">
							              <xsl:value-of select="@groupName"/>
						            </xsl:attribute>
					          </xsl:if>
					          <xsl:if test="@selected">
						            <xsl:attribute name="checked">
							              <xsl:text>checked</xsl:text>
						            </xsl:attribute>
					          </xsl:if>
				        </xsl:element>
				        <xsl:choose>
					          <xsl:when test="$myLabel">
						            <xsl:apply-templates select="$myLabel[1]" mode="checkable">
							              <xsl:with-param name="labelableElement" select="."/>
						            </xsl:apply-templates>
					          </xsl:when>
					          <xsl:otherwise>
						            <xsl:call-template name="checkLabel">
							              <xsl:with-param name="force" select="1"/>
						            </xsl:call-template>
					          </xsl:otherwise>
				        </xsl:choose>
				        <xsl:if test="self::ui:radioButton">
					          <xsl:call-template name="hField">
						            <xsl:with-param name="name" select="$name"/>
					          </xsl:call-template>
				        </xsl:if>
			      </xsl:otherwise>
		    </xsl:choose>
	  </xsl:template>
   <xsl:template match="ui:checkBoxSelect|ui:radioButtonSelect">
		    <xsl:variable name="inputType">
			      <xsl:choose>
				        <xsl:when test="self::ui:checkBoxSelect">
					          <xsl:text>checkbox</xsl:text>
				        </xsl:when>
				        <xsl:otherwise>
					          <xsl:text>radio</xsl:text>
				        </xsl:otherwise>
			      </xsl:choose>
		    </xsl:variable>
		    <xsl:variable name="readOnly">
			      <xsl:choose>
				        <xsl:when test="@readOnly">
					          <xsl:number value="1"/>
				        </xsl:when>
				        <xsl:otherwise>
					          <xsl:number value="0"/>
				        </xsl:otherwise>
			      </xsl:choose>
		    </xsl:variable>
		    <xsl:variable name="hasSingleSelectionRO">
			      <xsl:choose>
				        <xsl:when test="$readOnly=1 and ($inputType='radio' or count(ui:option[@selected]) &lt;=1)">
					          <xsl:number value="1"/>
				        </xsl:when>
				        <xsl:otherwise>
					          <xsl:number value="0"/>
				        </xsl:otherwise>
			      </xsl:choose>
		    </xsl:variable>
		    <xsl:variable name="id">
			      <xsl:value-of select="@id"/>
		    </xsl:variable>
		    <xsl:variable name="myLabel" select="key('labelKey',$id)[1]"/>

		    <xsl:choose>
			      <xsl:when test="$hasSingleSelectionRO=1">
				        <xsl:call-template name="readOnlyControl">
					          <xsl:with-param name="applies" select="ui:option[@selected]"/>
					          <xsl:with-param name="useReadOnlyMode" select="1"/>
					          <xsl:with-param name="label" select="$myLabel"/>
				        </xsl:call-template>
			      </xsl:when>
			      <xsl:otherwise>
				        <xsl:variable name="isError" select="key('errorKey',$id)"/>
				        <xsl:variable name="title">
					          <xsl:choose>
						            <xsl:when test="@toolTip ">
							              <xsl:value-of select="normalize-space(@toolTip)"/>
						            </xsl:when>
						            <xsl:when test="@required and self::ui:checkBoxSelect">
							              <xsl:value-of select="$cbg1"/>
						            </xsl:when>
						            <xsl:when test="@required">
							              <xsl:value-of select="$rbg1"/>
						            </xsl:when>
					          </xsl:choose>
				        </xsl:variable>
				        <xsl:variable name="element">
					          <xsl:choose>
						            <xsl:when test="$readOnly=1">div</xsl:when>
						            <xsl:otherwise>fieldset</xsl:otherwise>
					          </xsl:choose>
				        </xsl:variable>
				        <xsl:element name="{$element}">
					          <xsl:call-template name="commonWrapperAttributes">
						            <xsl:with-param name="isError" select="$isError"/>
						            <xsl:with-param name="isControl" select="1 - $readOnly"/>
						            <xsl:with-param name="class">
							              <xsl:text>wc_chkgrp</xsl:text>
							              <xsl:if test="not(@frameless)">
								                <xsl:text> wc_chkgrp_bdr</xsl:text>
							              </xsl:if>
						            </xsl:with-param>
					          </xsl:call-template>

					          <xsl:if test="$title!=''">
						            <xsl:attribute name="title">
							              <xsl:value-of select="$title"/>
						            </xsl:attribute>
					          </xsl:if>
					          <xsl:if test="$readOnly=0">
						            <xsl:if test="@min">
							              <xsl:attribute name="data-wc-min">
								                <xsl:value-of select="@min"/>
							              </xsl:attribute>
						            </xsl:if>
						            <xsl:if test="@max">
							              <xsl:attribute name="data-wc-max">
								                <xsl:value-of select="@max"/>
							              </xsl:attribute>
						            </xsl:if>
						            <xsl:call-template name="makeLegend">
							              <xsl:with-param name="myLabel" select="$myLabel"/>
						            </xsl:call-template>
					          </xsl:if>

					          <xsl:variable name="firstItemAccessKey">
						            <xsl:if test="$myLabel">
							              <xsl:value-of select="$myLabel/@accessKey"/>
						            </xsl:if>
					          </xsl:variable>
					          <xsl:variable name="layout" select="@layout"/>
					          <xsl:variable name="cols">
						            <xsl:choose>
							              <xsl:when test="$layout='column' and @layoutColumnCount and @layoutColumnCount &gt; 1">
								                <xsl:number value="@layoutColumnCount"/>
							              </xsl:when>
							              <xsl:otherwise>
								                <xsl:number value="1"/>
							              </xsl:otherwise>
						            </xsl:choose>
					          </xsl:variable>
					
					          <xsl:variable name="rows">
						            <xsl:choose>
							              <xsl:when test="$cols=1">
								                <xsl:number value="0"/>
							              </xsl:when>
							              <xsl:when test="$readOnly=1">
								                <xsl:value-of select="ceiling(count(ui:option[@selected]) div $cols)"/>
							              </xsl:when>
							              <xsl:otherwise>
								                <xsl:value-of select="ceiling(count(ui:option) div $cols)"/>
							              </xsl:otherwise>
						            </xsl:choose>
					          </xsl:variable>
					
					          <xsl:choose>
						            <xsl:when test="$readOnly=1 and $rows=0">
							              <xsl:element name="ul">
								                <xsl:attribute name="class">
									                  <xsl:value-of select="$layout"/>
									                  <xsl:text> wc_list_nb</xsl:text>
								                </xsl:attribute>
								                <xsl:apply-templates select="ui:option[@selected]" mode="checkableGroupInList">
									                  <xsl:with-param name="firstItemAccessKey" select="$firstItemAccessKey"/>
									                  <xsl:with-param name="inputName" select="$id"/>
									                  <xsl:with-param name="type" select="$inputType"/>
									                  <xsl:with-param name="readOnly" select="$readOnly"/>
								                </xsl:apply-templates>
							              </xsl:element>
						            </xsl:when>
						            <xsl:when test="$readOnly=1 and $rows=1">
							              <xsl:apply-templates select="ui:option[@selected]" mode="checkableGroup">
								                <xsl:with-param name="firstItemAccessKey" select="$firstItemAccessKey"/>
								                <xsl:with-param name="inputName" select="$id"/>
								                <xsl:with-param name="type" select="$inputType"/>
								                <xsl:with-param name="readOnly" select="$readOnly"/>
								                <xsl:with-param name="rows" select="0"/>
							              </xsl:apply-templates>
						            </xsl:when>
						            <xsl:when test="$readOnly=1">
							              <xsl:apply-templates select="ui:option[@selected][position() mod $rows = 1]"
                                          mode="checkableGroup">
								                <xsl:with-param name="firstItemAccessKey" select="$firstItemAccessKey"/>
								                <xsl:with-param name="inputName" select="$id"/>
								                <xsl:with-param name="type" select="$inputType"/>
								                <xsl:with-param name="readOnly" select="$readOnly"/>
								                <xsl:with-param name="rows" select="$rows"/>
							              </xsl:apply-templates>
						            </xsl:when>
						            <xsl:when test="$rows=0 and ui:option">
							              <xsl:element name="div">
								                <xsl:attribute name="class">
									                  <xsl:value-of select="$layout"/>
								                </xsl:attribute>
								                <xsl:apply-templates select="ui:option" mode="checkableGroupInList">
									                  <xsl:with-param name="firstItemAccessKey" select="$firstItemAccessKey"/>
									                  <xsl:with-param name="inputName" select="$id"/>
									                  <xsl:with-param name="type" select="$inputType"/>
									                  <xsl:with-param name="readOnly" select="$readOnly"/>
								                </xsl:apply-templates>
							              </xsl:element>
						            </xsl:when>
						            <xsl:when test="$rows=1 and  ui:option">
							              <xsl:apply-templates select="ui:option" mode="checkableGroup">
								                <xsl:with-param name="firstItemAccessKey" select="$firstItemAccessKey"/>
								                <xsl:with-param name="inputName" select="$id"/>
								                <xsl:with-param name="type" select="$inputType"/>
								                <xsl:with-param name="readOnly" select="$readOnly"/>
								                <xsl:with-param name="rows" select="0"/>
							              </xsl:apply-templates>
						            </xsl:when>
						            <xsl:when test="ui:option">
							              <xsl:apply-templates select="ui:option[position() mod $rows = 1]" mode="checkableGroup">
								                <xsl:with-param name="firstItemAccessKey" select="$firstItemAccessKey"/>
								                <xsl:with-param name="inputName" select="$id"/>
								                <xsl:with-param name="type" select="$inputType"/>
								                <xsl:with-param name="readOnly" select="$readOnly"/>
								                <xsl:with-param name="rows" select="$rows"/>
							              </xsl:apply-templates>
						            </xsl:when>
					          </xsl:choose>
					          <xsl:if test="$readOnly=0">
						            <xsl:call-template name="hField"/>
						            <xsl:call-template name="inlineError">
							              <xsl:with-param name="errors" select="$isError"/>
						            </xsl:call-template>
					          </xsl:if>
				        </xsl:element>
			      </xsl:otherwise>
		    </xsl:choose>
	  </xsl:template>
   <xsl:template match="ui:messageBox|ui:validationErrors">
		    <xsl:variable name="type">
			      <xsl:choose>
				        <xsl:when test="self::ui:validationErrors">
					          <xsl:text>error</xsl:text>
				        </xsl:when>
				        <xsl:otherwise>
					          <xsl:value-of select="@type"/>
				        </xsl:otherwise>
			      </xsl:choose>
		    </xsl:variable>
		    <xsl:element name="SECTION">
			      <xsl:attribute name="id">
				        <xsl:value-of select="@id"/>
			      </xsl:attribute>
			      <xsl:attribute name="class">
				        <xsl:call-template name="commonClassHelper"/>
				        <xsl:value-of select="concat(' wc_msgbox ', $type)"/>
			      </xsl:attribute>
			      <h1>
				        <span>
					          <xsl:choose>
						            <xsl:when test="@title">
							              <xsl:value-of select="@title"/>
						            </xsl:when>
						            <xsl:when test="$type='error'">
							              <xsl:value-of select="$mb0"/>
						            </xsl:when>
						            <xsl:when test="$type='warn'">
							              <xsl:value-of select="$mb1"/>
						            </xsl:when>
						            <xsl:when test="$type='info'">
							              <xsl:value-of select="$mb2"/>
						            </xsl:when>
						            <xsl:when test="$type='success'">
							              <xsl:value-of select="$mb3"/>
						            </xsl:when>
					          </xsl:choose>
				        </span>
			      </h1>
			      <ul>
				        <xsl:apply-templates/>
			      </ul>
		    </xsl:element>
	  </xsl:template>
   <xsl:template match="html:link|html:base|html:meta"/>
   <xsl:template match="html:link[ancestor::ui:ajaxTarget]">
		    <xsl:copy-of select="."/>
	  </xsl:template>
   <xsl:template match="html:input|html:img|html:br">
		    <xsl:copy-of select="."/>
	  </xsl:template>
   <xsl:template match="html:acronym|html:applet|html:bgsound|html:dir|html:frame|html:frameset|html:noframes|html:isindex|html:listing|html:nextid|html:noembed|html:plaintext|html:rb|html:strike|html:xmp|html:basefont|html:big|html:blink|html:center|html:font|html:marquee|html:multicol|html:nobr|html:spacer|html:tt"/>
   <xsl:template match="html:form"/>
   <xsl:template match="ui:audio|ui:video">
		    <xsl:variable name="elementType">
			      <xsl:choose>
				        <xsl:when test="self::ui:audio">
					          <xsl:text>AUDIO</xsl:text>
				        </xsl:when>
				        <xsl:otherwise>
					          <xsl:text>VIDEO</xsl:text>
				        </xsl:otherwise>
			      </xsl:choose>
		    </xsl:variable>
		    <span id="{@id}">
			      <xsl:call-template name="makeCommonClass"/>
			      <xsl:if test="@toolTip">
				        <xsl:attribute name="title">
					          <xsl:value-of select="normalize-space(@toolTip)"/>
				        </xsl:attribute>
			      </xsl:if>
			      <xsl:call-template name="hideElementIfHiddenSet"/>
			      <xsl:call-template name="ajaxTarget"/>
			      <xsl:element name="{$elementType}">
				        <xsl:if test="@autoplay and not(@controls='none')">
					          <xsl:attribute name="autoplay">
						            <xsl:value-of select="@autoplay"/>
					          </xsl:attribute>
				        </xsl:if>
				        <xsl:attribute name="preload">
					          <xsl:choose>
						            <xsl:when test="@preload">
							              <xsl:value-of select="@preload"/>
						            </xsl:when>
						            <xsl:otherwise>
							              <xsl:text>auto</xsl:text>
						            </xsl:otherwise>
					          </xsl:choose>
				        </xsl:attribute>
				        <xsl:if test="@mediagroup">
					          <xsl:attribute name="mediagroup">
						            <xsl:value-of select="@mediagroup"/>
					          </xsl:attribute>
				        </xsl:if>
				        <xsl:if test="@loop and not(@controls='none')">
					          <xsl:attribute name="loop">
						            <xsl:value-of select="@loop"/>
					          </xsl:attribute>
				        </xsl:if>
				        <xsl:if test="@muted and not(@controls='none')">
					          <xsl:attribute name="muted">
						            <xsl:value-of select="@muted"/>
					          </xsl:attribute>
				        </xsl:if>
				        <xsl:if test="@alt">
					          <xsl:attribute name="data-wc-alt">
						            <xsl:value-of select="@alt"/>
					          </xsl:attribute>
				        </xsl:if>
				        <xsl:choose>
					          <xsl:when test="not(@controls='play' or @controls='none')">
						            <xsl:attribute name="controls">
							              <xsl:text>controls</xsl:text>
						            </xsl:attribute>
					          </xsl:when>
					          <xsl:otherwise>
						            <xsl:attribute name="data-wc-controls">
							              <xsl:value-of select="@controls"/>
						            </xsl:attribute>
					          </xsl:otherwise>
				        </xsl:choose>
				        <xsl:if test="@poster">
					          <xsl:attribute name="poster">
						            <xsl:value-of select="@poster"/>
					          </xsl:attribute>
				        </xsl:if>
				        <xsl:if test="@width">
					          <xsl:attribute name="width">
						            <xsl:value-of select="@width"/>
					          </xsl:attribute>
				        </xsl:if>
				        <xsl:if test="@height">
					          <xsl:attribute name="height">
						            <xsl:value-of select="@height"/>
					          </xsl:attribute>
				        </xsl:if>
				        <xsl:apply-templates select="ui:src"/>
				        <xsl:apply-templates select="ui:track"/>
				        <xsl:call-template name="mediaUnsupportedContent"/>
			      </xsl:element>
		    </span>
	  </xsl:template>
   <xsl:template match="ui:message">
		    <li>
			      <xsl:call-template name="makeCommonClass"/>
			      <xsl:apply-templates/>
		    </li>
	  </xsl:template>
   <xsl:template match="ui:multiDropdown|ui:multiTextField">
		    <xsl:variable name="readOnly">
			      <xsl:if test="@readOnly">
				        <xsl:number value="1"/>
			      </xsl:if>
		    </xsl:variable>
		    <xsl:variable name="id" select="@id"/>
		    <xsl:variable name="myLabel" select="key('labelKey',$id)[1]"/>
		
		    <xsl:choose>
			      <xsl:when test="$readOnly=1 and (self::ui:multiDropdown[count(.//ui:option[@selected]) &lt;= 1])">
				        <xsl:call-template name="readOnlyControl">
					          <xsl:with-param name="applies" select=".//ui:option[@selected]"/>
					          <xsl:with-param name="useReadOnlyMode" select="1"/>
					          <xsl:with-param name="label" select="$myLabel"/>
				        </xsl:call-template>
			      </xsl:when>
			      <xsl:when test="$readOnly=1 and (self::ui:multiTextField[count(ui:value) &lt;= 1])">
				        <xsl:call-template name="readOnlyControl">
					          <xsl:with-param name="useReadOnlyMode" select="1"/>
					          <xsl:with-param name="label" select="$myLabel"/>
				        </xsl:call-template>
			      </xsl:when>
			      <xsl:when test="$readOnly=1">
				        <ul class="wc_list_nb">
					          <xsl:call-template name="commonAttributes"/>
					          <xsl:if test="$myLabel">
						            <xsl:attribute name="aria-labelledby">
							              <xsl:value-of select="$myLabel/@id"/>
						            </xsl:attribute>
					          </xsl:if>
					          <xsl:choose>
						            <xsl:when test="self::ui:multiDropdown">
							              <xsl:apply-templates select="ui:option[@selected]|ui:optgroup[ui:option[@selected]]"
                                          mode="readOnly">
								                <xsl:with-param name="single" select="0"/>
							              </xsl:apply-templates>
						            </xsl:when>
						            <xsl:otherwise>
							              <xsl:apply-templates select="ui:value" mode="readOnlyList"/>
						            </xsl:otherwise>
					          </xsl:choose>
				        </ul>
			      </xsl:when>
			      <xsl:otherwise>
				        <xsl:variable name="isError" select="key('errorKey',$id)"/>
				        <fieldset aria-relevant="additions removals" aria-atomic="false">
					          <xsl:call-template name="commonWrapperAttributes">
						            <xsl:with-param name="isError" select="$isError"/>
						            <xsl:with-param name="class">wc_mfc</xsl:with-param>
					          </xsl:call-template>
					          <xsl:if test="@min">
						            <xsl:attribute name="data-wc-min">
							              <xsl:value-of select="@min"/>
						            </xsl:attribute>
					          </xsl:if>
					          <xsl:if test="@max">
						            <xsl:attribute name="data-wc-max">
							              <xsl:value-of select="@max"/>
						            </xsl:attribute>
					          </xsl:if>
					          <xsl:call-template name="makeLegend">
						            <xsl:with-param name="myLabel" select="$myLabel"/>
					          </xsl:call-template>
					          <ul class="wc_list_nb">
						            <xsl:choose>
							
							              <xsl:when test="self::ui:multiDropdown">
								                <xsl:call-template name="multiDropDownContentRenderer">
									                  <xsl:with-param name="myLabel" select="$myLabel"/>
								                </xsl:call-template>
							              </xsl:when>
							              <xsl:otherwise>
								                <xsl:call-template name="multiTextFieldContentRenderer">
									                  <xsl:with-param name="myLabel" select="$myLabel"/>
								                </xsl:call-template>
							              </xsl:otherwise>
						            </xsl:choose>
					          </ul>
					          <xsl:call-template name="inlineError">
						            <xsl:with-param name="errors" select="$isError"/>
					          </xsl:call-template>
				        </fieldset>
			      </xsl:otherwise>
		    </xsl:choose>
	  </xsl:template>
   <xsl:template match="ui:optgroup"/>
   <xsl:template match="ui:option"/>
   <xsl:template match="ui:dropdown|ui:listBox">
		    <xsl:variable name="id" select="@id"/>
		    <xsl:variable name="myLabel" select="key('labelKey',$id)"/>
		    <xsl:choose>
			      <xsl:when test="not(@readOnly)">
				        <xsl:variable name="isError" select="key('errorKey',$id)"/>
				        <xsl:if test="not($myLabel)">
					          <xsl:call-template name="checkLabel">
						            <xsl:with-param name="force" select="1"/>
					          </xsl:call-template>
				        </xsl:if>
				        <select>
					          <xsl:call-template name="commonControlAttributes">
						            <xsl:with-param name="isError" select="$isError"/>
						            <xsl:with-param name="name" select="$id"/>
						            <xsl:with-param name="live" select="'off'"/>
						            <xsl:with-param name="myLabel" select="$myLabel[1]"/>
					          </xsl:call-template>
					          <xsl:if test="self::ui:listBox and not(@single)">
						            <xsl:attribute name="multiple">
							              <xsl:text>multiple</xsl:text>
						            </xsl:attribute>
						            <xsl:if test="@min">
							              <xsl:attribute name="data-wc-min">
								                <xsl:value-of select="@min"/>
							              </xsl:attribute>
						            </xsl:if>
						            <xsl:if test="@max">
							              <xsl:attribute name="data-wc-max">
								                <xsl:value-of select="@max"/>
							              </xsl:attribute>
						            </xsl:if>
					          </xsl:if>
					          <xsl:if test="@data">
						            <xsl:attribute name="data-wc-list">
							              <xsl:value-of select="@data"/>
						            </xsl:attribute>
					          </xsl:if>
					          <xsl:if test="@rows">
						            <xsl:attribute name="size">
							              <xsl:value-of select="@rows"/>
						            </xsl:attribute>
					          </xsl:if>
					          <xsl:if test="@optionWidth">
						            <xsl:attribute name="style">
							              <xsl:text>width:</xsl:text>
							              <xsl:value-of select="@optionWidth"/>
							              <xsl:text>em;</xsl:text>
						            </xsl:attribute>
					          </xsl:if>
					          <xsl:apply-templates mode="selectableList"/>
				        </select>
				        <xsl:call-template name="inlineError">
					          <xsl:with-param name="errors" select="$isError"/>
				        </xsl:call-template>
				        <xsl:if test="self::ui:listBox">
					          <xsl:call-template name="hField"/>
				        </xsl:if>
			      </xsl:when>
			      <xsl:when test="count(.//ui:option[@selected]) = 1">
				        <xsl:call-template name="readOnlyControl">
					          <xsl:with-param name="applies" select=".//ui:option[@selected]"/>
					          <xsl:with-param name="useReadOnlyMode" select="1"/>
					          <xsl:with-param name="label" select="$myLabel"/>
					          <xsl:with-param name="style">
						            <xsl:choose>
							              <xsl:when test="@type='combo' and @optionWidth">
								                <xsl:text>width:</xsl:text>
								                <xsl:value-of select="@optionWidth"/>
								                <xsl:text>em;</xsl:text>
							              </xsl:when>
							              <xsl:otherwise>
								                <xsl:value-of select="''"/>
							              </xsl:otherwise>
						            </xsl:choose>
					          </xsl:with-param>
				        </xsl:call-template>
			      </xsl:when>
			      <xsl:when test=".//ui:option[@selected]">
				        <ul id="{$id}" class="wc_list_nb">
					          <xsl:if test="$myLabel">
						            <xsl:attribute name="aria-labelledby">
							              <xsl:value-of select="$myLabel/@id"/>
						            </xsl:attribute>
					          </xsl:if>
					          <xsl:call-template name="hideElementIfHiddenSet"/>
					          <xsl:call-template name="ajaxTarget"/>
					          <xsl:apply-templates select="ui:option[@selected]|ui:optgroup[ui:option[@selected]]"
                                    mode="readOnly">
						            <xsl:with-param name="single" select="0"/>
					          </xsl:apply-templates>
				        </ul>
			      </xsl:when>
			      <xsl:otherwise>
				
				        <xsl:call-template name="readOnlyControl">
					          <xsl:with-param name="applies" select="'none'"/>
					          <xsl:with-param name="label" select="$myLabel"/>
				        </xsl:call-template>
			      </xsl:otherwise>
		    </xsl:choose>
	  </xsl:template>
   <xsl:template match="ui:textField|ui:phoneNumberField|ui:emailField|ui:numberField|ui:passwordField">
		    <xsl:variable name="id" select="@id"/>
		    <xsl:variable name="type">
			      <xsl:choose>
				        <xsl:when test="self::ui:textField">
					          <xsl:text>text</xsl:text>
				        </xsl:when>
				        <xsl:when test="self::ui:numberField">
					          <xsl:text>number</xsl:text>
				        </xsl:when>
				        <xsl:when test="self::ui:passwordField">
					          <xsl:text>password</xsl:text>
				        </xsl:when>
				        <xsl:when test="self::ui:emailField">
					          <xsl:text>email</xsl:text>
				        </xsl:when>
				        <xsl:when test="self::ui:phoneNumberField">
					          <xsl:text>tel</xsl:text>
				        </xsl:when>
			      </xsl:choose>
		    </xsl:variable>
		    <xsl:variable name="readOnly">
			      <xsl:if test="@readOnly">
				        <xsl:number value="1"/>
			      </xsl:if>
		    </xsl:variable>
		    <xsl:variable name="myLabel" select="key('labelKey',$id)[1]"/>
		    <xsl:choose>
			      <xsl:when test="$readOnly=1">
				        <xsl:call-template name="readOnlyControl">
					          <xsl:with-param name="label" select="$myLabel"/>
				        </xsl:call-template>
			      </xsl:when>
			      <xsl:otherwise>
				        <xsl:variable name="isError" select="key('errorKey',$id)"/>
				        <xsl:if test="not($myLabel)">
					          <xsl:call-template name="checkLabel">
						            <xsl:with-param name="force" select="1"/>
					          </xsl:call-template>
				        </xsl:if>
				        <xsl:element name="input">
					          <xsl:call-template name="commonControlAttributes">
						            <xsl:with-param name="isError" select="$isError"/>
						            <xsl:with-param name="name" select="$id"/>
						            <xsl:with-param name="live" select="'off'"/>
						            <xsl:with-param name="myLabel" select="$myLabel[1]"/>
					          </xsl:call-template>
					          <xsl:if test="@maxLength">
						            <xsl:attribute name="maxLength">
							              <xsl:value-of select="@maxLength"/>
						            </xsl:attribute>
					          </xsl:if>
					          <xsl:if test="@required">
						            <xsl:attribute name="placeholder">
							              <xsl:value-of select="$cm2"/>
						            </xsl:attribute>
					          </xsl:if>
					          <xsl:if test="@list">
						            <xsl:attribute name="role">
							              <xsl:text>combobox</xsl:text>
						            </xsl:attribute>
						            <xsl:attribute name="aria-autocomplete">
							              <xsl:text>both</xsl:text>
						            </xsl:attribute>
						
						            <xsl:attribute name="autocomplete">
							              <xsl:text>off</xsl:text>
						            </xsl:attribute>
						            <xsl:attribute name="aria-owns">
							              <xsl:value-of select="@list"/>
						            </xsl:attribute>
					          </xsl:if>
					          <xsl:attribute name="type">
						            <xsl:value-of select="$type"/>
					          </xsl:attribute>
					          <xsl:attribute name="value">
						            <xsl:value-of select="."/>
					          </xsl:attribute>
					          <xsl:if test="@size and not(self::ui:numberField)">
						            <xsl:attribute name="size">
							              <xsl:value-of select="@size"/>
						            </xsl:attribute>
					          </xsl:if>
					          <xsl:if test="self::ui:numberField">
						
						            <xsl:attribute name="autocomplete">
							              <xsl:text>off</xsl:text>
						            </xsl:attribute>
					          </xsl:if>
					          <xsl:choose>
						            <xsl:when test="@minLength">
							              <xsl:attribute name="data-wc-minlength">
								                <xsl:value-of select="@minLength"/>
							              </xsl:attribute>
						            </xsl:when>
						            <xsl:when test="@min">
							              <xsl:attribute name="min">
								                <xsl:value-of select="@min"/>
								
								                <xsl:if test="contains(@step,'.') and not(contains(@min,'.'))">
									                  <xsl:text>.0</xsl:text>
								                </xsl:if>
							              </xsl:attribute>
						            </xsl:when>
					          </xsl:choose>
					          <xsl:if test="@max">
						            <xsl:attribute name="max">
							              <xsl:value-of select="@max"/>
						            </xsl:attribute>
					          </xsl:if>
					          <xsl:if test="@pattern">
						            <xsl:attribute name="pattern">
							              <xsl:value-of select="@pattern"/>
						            </xsl:attribute>
					          </xsl:if>
					          <xsl:if test="@step">
						
						            <xsl:variable name="step">
							              <xsl:choose>
								                <xsl:when test="not(@min) and contains(@step,'.')">
									                  <xsl:number value="round(number(@step))"/>
								                </xsl:when>
								                <xsl:otherwise>
									                  <xsl:value-of select="number(@step)"/>
								                </xsl:otherwise>
							              </xsl:choose>
						            </xsl:variable>
						            <xsl:if test="$step != '' and $step != 0">
							              <xsl:attribute name="step">
								                <xsl:value-of select="$step"/>
							              </xsl:attribute>
						            </xsl:if>
					          </xsl:if>
				        </xsl:element>
				        <xsl:call-template name="inlineError">
					          <xsl:with-param name="errors" select="$isError"/>
				        </xsl:call-template>
			      </xsl:otherwise>
		    </xsl:choose>
	  </xsl:template>
   <xsl:template match="*">
		    <xsl:element name="{local-name()}">
			      <xsl:copy-of select="@*"/>
			      <xsl:apply-templates/>
		    </xsl:element>
	  </xsl:template>
   <xsl:template match="@*">
		    <xsl:copy/>
	  </xsl:template>
   <xsl:template match="text()">
		    <xsl:value-of select="."/>
	  </xsl:template>
   <xsl:template match="ui:abbr">
		    <xsl:if test="text()">
			      <xsl:variable name="element">
				        <xsl:choose>
					          <xsl:when test="@toolTip">abbr</xsl:when>
					          <xsl:otherwise>span</xsl:otherwise>
				        </xsl:choose>
			      </xsl:variable>
			      <xsl:element name="{$element}">
				        <xsl:call-template name="makeCommonClass"/>
				        <xsl:value-of select="."/>
			      </xsl:element>
		    </xsl:if>
	  </xsl:template>
   <xsl:template match="ui:additionalParameters"/>
   <xsl:template match="ui:ajaxResponse">
		    <xsl:choose>
			      <xsl:when test="ui:ajaxTarget/node()[not(self::ui:file)]">
				        <xsl:element name="div">
					          <xsl:attribute name="class">wc-ajaxresponse</xsl:attribute>
					          <xsl:if test="@defaultFocusId">
						            <xsl:attribute name="data-focusid">
                     <xsl:value-of select="@defaultFocusId"/>
                  </xsl:attribute>
					          </xsl:if>
					          <xsl:apply-templates/>
					          <xsl:apply-templates select=".//ui:dialog[ui:content][1]" mode="withcontent"/>
				        </xsl:element>
			      </xsl:when>
			      <xsl:otherwise>
				        <xsl:element name="html">
					          <xsl:attribute name="lang">
						            <xsl:value-of select="$lang"/>
					          </xsl:attribute>
					          <xsl:element name="head">
						            <xsl:element name="title">
							              <xsl:text>Pseudo AJAX iframe</xsl:text>
						            </xsl:element>
					          </xsl:element>
					          <xsl:element name="body">
						            <xsl:apply-templates mode="pseudoAjax"/>
					          </xsl:element>
				        </xsl:element>
			      </xsl:otherwise>
		    </xsl:choose>
	  </xsl:template>
   <xsl:template match="ui:ajaxTarget">
		    <xsl:element name="div">
			      <xsl:attribute name="class">wc-ajaxtarget</xsl:attribute>
			      <xsl:attribute name="data-id">
            <xsl:value-of select="@id"/>
         </xsl:attribute>
			      <xsl:attribute name="data-action">
            <xsl:value-of select="@action"/>
         </xsl:attribute>
			      <xsl:apply-templates/>
			      <xsl:call-template name="registrationScripts"/>
		    </xsl:element>
	  </xsl:template>
   <xsl:template match="ui:ajaxTargetId">
		    <xsl:text>"</xsl:text>
		    <xsl:value-of select="@targetId"/>
		    <xsl:text>"</xsl:text>
		    <xsl:if test="position() != last()">
			      <xsl:text>,</xsl:text>
		    </xsl:if>
	  </xsl:template>
   <xsl:template match="ui:ajaxTrigger"/>
   <xsl:template match="ui:application/ui:param">
		    <xsl:element name="input">
			      <xsl:attribute name="type">
				        <xsl:text>hidden</xsl:text>
			      </xsl:attribute>
			      <xsl:attribute name="name">
				        <xsl:value-of select="@name"/>
			      </xsl:attribute>
			      <xsl:attribute name="value">
				        <xsl:value-of select="@value"/>
			      </xsl:attribute>
		    </xsl:element>
	  </xsl:template>
   <xsl:template match="ui:application">
		    <xsl:variable name="baseAjaxUrl">
			      <xsl:value-of select="@ajaxUrl"/>
		    </xsl:variable>
		    <form action="{@applicationUrl}"
            method="POST"
            id="{@id}"
            data-wc-datalisturl="{@dataUrl}">
			      <xsl:attribute name="data-wc-ajaxurl">
				        <xsl:value-of select="$baseAjaxUrl"/>
				        <xsl:if test="ui:param">
					          <xsl:choose>
						            <xsl:when test="contains($baseAjaxUrl, '?')">
							              <xsl:text>&amp;</xsl:text>
						            </xsl:when>
						            <xsl:otherwise>
							              <xsl:text>?</xsl:text>
						            </xsl:otherwise>
					          </xsl:choose>
					          <xsl:apply-templates select="ui:param" mode="get"/>
				        </xsl:if>
			      </xsl:attribute>
			      <xsl:attribute name="class">
				        <xsl:call-template name="commonClassHelper"/>
				        <xsl:if test="@unsavedChanges or .//ui:button[@unsavedChanges] or .//ui:menuItem[@unsavedChanges]">
					          <xsl:text> wc_unsaved</xsl:text>
				        </xsl:if>
			      </xsl:attribute>
			
			      <xsl:attribute name="novalidate">
            <xsl:text>novalidate</xsl:text>
         </xsl:attribute>
			      <xsl:call-template name="ajaxTarget"/>
			      <xsl:apply-templates/>
			      <xsl:apply-templates select=".//ui:dialog[ui:content][1]" mode="withcontent"/>
		    </form>
	  </xsl:template>
   <xsl:template match="ui:application[ancestor::ui:application]"/>
   <xsl:template match="ui:north|ui:south">
		    <xsl:param name="vgap" select="0"/>
		    <xsl:call-template name="borderLayoutCell">
			      <xsl:with-param name="vgap">
				        <xsl:value-of select="$vgap"/>
			      </xsl:with-param>
		    </xsl:call-template>
	  </xsl:template>
   <xsl:template match="ui:east|ui:west|ui:center">
		    <xsl:param name="hgap" select="0"/>
		    <xsl:call-template name="borderLayoutCell">
			      <xsl:with-param name="hgap">
				        <xsl:choose>
					          <xsl:when test="$hgap = 0 or count(../ui:west|../ui:center|../ui:east) &gt; 1">
						            <xsl:value-of select="$hgap"/>
					          </xsl:when>
					          <xsl:otherwise>
						            <xsl:number value="0"/>
					          </xsl:otherwise>
				        </xsl:choose>
			      </xsl:with-param>
		    </xsl:call-template>
	  </xsl:template>
   <xsl:template match="ui:borderLayout">
		    <xsl:variable name="vgap">
			      <xsl:call-template name="getHVGap">
				        <xsl:with-param name="gap" select="@vgap"/>
			      </xsl:call-template>
		    </xsl:variable>
		    <xsl:element name="div">
			      <xsl:attribute name="class">
				        <xsl:text>borderLayout</xsl:text>
			      </xsl:attribute>
			      <xsl:apply-templates select="ui:north"/>
			      <xsl:variable name="colCount" select="count(ui:west|ui:center|ui:east)"/>
			      <xsl:if test="$colCount &gt;0">
				        <xsl:element name="div">
					          <xsl:attribute name="class">
						            <xsl:text>wc_borderLayout_middle</xsl:text>
					          </xsl:attribute>
					          <xsl:if test="ui:north and ($vgap != 0)">
						            <xsl:attribute name="style">
							              <xsl:value-of select="concat('margin-top:',$vgap,';')"/>
						            </xsl:attribute>
					          </xsl:if>
					          <xsl:variable name="hgap">
						            <xsl:choose>
							              <xsl:when test="not(@hgap) or @hgap='0' or $colCount=1">
								                <xsl:number value="0"/>
							              </xsl:when>
							              <xsl:otherwise>
								                <xsl:call-template name="getHVGap">
									                  <xsl:with-param name="divisor" select="2"/>
								                </xsl:call-template>
							              </xsl:otherwise>
						            </xsl:choose>
					          </xsl:variable>
					          <xsl:apply-templates select="ui:west">
						            <xsl:with-param name="hgap" select="$hgap"/>
					          </xsl:apply-templates>
					          <xsl:apply-templates select="ui:center">
						            <xsl:with-param name="hgap" select="$hgap"/>
					          </xsl:apply-templates>
					          <xsl:apply-templates select="ui:east">
						            <xsl:with-param name="hgap" select="$hgap"/>
					          </xsl:apply-templates>
				        </xsl:element>
			      </xsl:if>
			      <xsl:apply-templates select="ui:south">
				        <xsl:with-param name="vgap" select="$vgap"/>
			      </xsl:apply-templates>
		    </xsl:element>
	  </xsl:template>
   <xsl:template match="ui:collapsible">
		    <xsl:variable name="collapsed">
			      <xsl:if test="@collapsed">
				        <xsl:number value="1"/>
			      </xsl:if>
		    </xsl:variable>
		    <xsl:element name="DETAILS">
			      <xsl:attribute name="id">
				        <xsl:value-of select="@id"/>
			      </xsl:attribute>
			      <xsl:call-template name="makeCommonClass"/>
			      <xsl:if test="$collapsed != 1">
				        <xsl:attribute name="open">
					          <xsl:text>open</xsl:text>
				        </xsl:attribute>
			      </xsl:if>
			      <xsl:call-template name="setARIALive">
				        <xsl:with-param name="live">
					          <xsl:choose>
						            <xsl:when test="@mode='dynamic'">
							              <xsl:text>assertive</xsl:text>
						            </xsl:when>
						            <xsl:otherwise>
							              <xsl:text>polite</xsl:text>
						            </xsl:otherwise>
					          </xsl:choose>
				        </xsl:with-param>
			      </xsl:call-template>
			      <xsl:call-template name="hideElementIfHiddenSet"/>
			      <xsl:apply-templates select="ui:margin"/>
			      <xsl:element name="SUMMARY">
				        <xsl:attribute name="tabIndex">
					          <xsl:text>0</xsl:text>
				        </xsl:attribute>
				        <xsl:choose>
					          <xsl:when test="@level">
						            <xsl:element name="h{@level}">
							              <xsl:apply-templates select="ui:decoratedLabel"/>
						            </xsl:element>
					          </xsl:when>
					          <xsl:otherwise>
						            <xsl:apply-templates select="ui:decoratedLabel"/>
					          </xsl:otherwise>
				        </xsl:choose>
			      </xsl:element>
			      <xsl:apply-templates select="ui:content" mode="collapsible"/>
		    </xsl:element>
	  </xsl:template>
   <xsl:template match="ui:expandCollapseAll">
		    <xsl:call-template name="collapsibleToggle"/>
	  </xsl:template>
   <xsl:template match="ui:column">
		    <xsl:param name="hgap"/>
		    <xsl:if test="parent::ui:row or parent::ui:ajaxTarget">
			      <xsl:call-template name="column">
				        <xsl:with-param name="hgap" select="$hgap"/>
			      </xsl:call-template>
		    </xsl:if>
	  </xsl:template>
   <xsl:template match="ui:columnLayout">
		    <xsl:element name="div">
			      <xsl:attribute name="class">
				        <xsl:text>columnLayout</xsl:text>
			      </xsl:attribute>
			      <xsl:variable name="width">
				        <xsl:choose>
					          <xsl:when test="ui:column[1]/@width">
						            <xsl:value-of select="ui:column[1]/@width"/>
					          </xsl:when>
					          <xsl:otherwise>
						            <xsl:number value="0"/>
					          </xsl:otherwise>
				        </xsl:choose>
			      </xsl:variable>
			      <xsl:variable name="hgap">
				        <xsl:call-template name="getHVGap">
					          <xsl:with-param name="divisor" select="2"/>
				        </xsl:call-template>
			      </xsl:variable>
			      <xsl:variable name="vgap">
				        <xsl:call-template name="getHVGap">
					          <xsl:with-param name="gap" select="@vgap"/>
				        </xsl:call-template>
			      </xsl:variable>
			      <xsl:variable name="cols" select="count(ui:column)"/>
			      <xsl:choose>
				        <xsl:when test="$cols=1">
					          <xsl:apply-templates select="ui:cell" mode="clRow">
						            <xsl:with-param name="align" select="ui:column[1]/@align"/>
						            <xsl:with-param name="width" select="$width"/>
						            <xsl:with-param name="hgap" select="$hgap"/>
						            <xsl:with-param name="vgap" select="$vgap"/>
						            <xsl:with-param name="cols" select="$cols"/>
					          </xsl:apply-templates>
				        </xsl:when>
				        <xsl:otherwise>
					          <xsl:apply-templates select="ui:cell[position() mod $cols = 1]" mode="clRow">
						            <xsl:with-param name="align" select="ui:column[1]/@align"/>
						            <xsl:with-param name="width" select="$width"/>
						            <xsl:with-param name="hgap" select="$hgap"/>
						            <xsl:with-param name="vgap" select="$vgap"/>
						            <xsl:with-param name="cols" select="$cols"/>
					          </xsl:apply-templates>
				        </xsl:otherwise>
			      </xsl:choose>
		    </xsl:element>
	  </xsl:template>
   <xsl:template match="comment()|ui:comment"/>
   <xsl:template match="ui:content">
		    <xsl:apply-templates/>
	  </xsl:template>
   <xsl:template match="ui:css"/>
   <xsl:template match="ui:datalist">
		    <xsl:element name="select">
			      <xsl:apply-templates select="ui:option" mode="selectableList"/>
		    </xsl:element>
	  </xsl:template>
   <xsl:template match="ui:dateField">
		    <xsl:variable name="id" select="@id"/>
		    <xsl:variable name="pickId">
			      <xsl:value-of select="concat('cal-', $id)"/>
		    </xsl:variable>
		    <xsl:variable name="isError" select="key('errorKey',$id)"/>
		    <xsl:variable name="myLabel" select="key('labelKey',$id)[1]"/>
		    <xsl:choose>
			      <xsl:when test="@readOnly">
				        <xsl:variable name="tagName">
					          <xsl:choose>
						            <xsl:when test="@allowPartial">
							              <xsl:text>span</xsl:text>
						            </xsl:when>
						            <xsl:otherwise>
							              <xsl:text>TIME</xsl:text>
						            </xsl:otherwise>
					          </xsl:choose>
				        </xsl:variable>
				        <xsl:element name="{$tagName}">
					          <xsl:call-template name="commonAttributes"/>
					          <xsl:attribute name="class">
						            <xsl:call-template name="commonClassHelper"/>
						            <xsl:text> wc_datero wc_ro</xsl:text>
					          </xsl:attribute>
					          <xsl:if test="$myLabel">
						            <xsl:attribute name="aria-labelledby">
							              <xsl:value-of select="$myLabel/@id"/>
						            </xsl:attribute>
					          </xsl:if>
					          <xsl:choose>
						            <xsl:when test="@date">
							              <xsl:variable name="datetimeattrib">
								                <xsl:choose>
									                  <xsl:when test="$tagName='span'">
										                    <xsl:text>data-wc-value</xsl:text>
									                  </xsl:when>
									                  <xsl:otherwise>
										                    <xsl:text>datetime</xsl:text>
									                  </xsl:otherwise>
								                </xsl:choose>
							              </xsl:variable>
							              <xsl:attribute name="{$datetimeattrib}">
								                <xsl:value-of select="@date"/>
							              </xsl:attribute>
						            </xsl:when>
						            <xsl:otherwise>
							              <xsl:value-of select="normalize-space(.)"/>
						            </xsl:otherwise>
					          </xsl:choose>
				        </xsl:element>
			      </xsl:when>
			      <xsl:otherwise>
				        <xsl:variable name="inputId">
					          <xsl:value-of select="concat($id,'-f')"/>
				        </xsl:variable>
				        <xsl:if test="not($myLabel)">
					          <xsl:call-template name="checkLabel">
						            <xsl:with-param name="for" select="$inputId"/>
						            <xsl:with-param name="force" select="1"/>
					          </xsl:call-template>
				        </xsl:if>
				
				        <div id="{$id}">
					          <xsl:call-template name="hideElementIfHiddenSet"/>
					          <xsl:call-template name="ajaxTarget">
						            <xsl:with-param name="live" select="'off'"/>
					          </xsl:call-template>
					          <xsl:call-template name="disabledElement">
						            <xsl:with-param name="isControl" select="0"/>
					          </xsl:call-template>
					          <xsl:call-template name="makeCommonClass"/>
					          <xsl:attribute name="role">
						            <xsl:text>combobox</xsl:text>
					          </xsl:attribute>
					          <xsl:call-template name="requiredElement">
						            <xsl:with-param name="useNative" select="0"/>
					          </xsl:call-template>
					          <xsl:attribute name="aria-autocomplete">
						            <xsl:text>both</xsl:text>
					          </xsl:attribute>
					          <xsl:call-template name="disabledElement"/>
					          <xsl:attribute name="aria-expanded">
						            <xsl:text>false</xsl:text>
					          </xsl:attribute>
					          <xsl:if test="$isError">
						            <xsl:call-template name="invalid"/>
					          </xsl:if>
					          <xsl:attribute name="data-wc-name">
						            <xsl:value-of select="@id"/>
						            <xsl:text>-date</xsl:text>
					          </xsl:attribute>
					          <xsl:if test="@date">
						            <xsl:attribute name="data-wc-value">
							              <xsl:value-of select="@date"/>
						            </xsl:attribute>
					          </xsl:if>
					          <xsl:if test="not($myLabel)">
						            <xsl:call-template name="ariaLabel"/>
					          </xsl:if>
					          <xsl:element name="input">
						
						            <xsl:attribute name="type">
							              <xsl:choose>
								                <xsl:when test="@allowPartial">
									                  <xsl:text>text</xsl:text>
								                </xsl:when>
								                <xsl:otherwise>
									                  <xsl:text>date</xsl:text>
								                </xsl:otherwise>
							              </xsl:choose>
						            </xsl:attribute>
						            <xsl:attribute name="id">
							              <xsl:value-of select="$inputId"/>
						            </xsl:attribute>
						            <xsl:attribute name="name">
							              <xsl:value-of select="$id"/>
						            </xsl:attribute>
						            <xsl:if test="not(@date)">
							              <xsl:attribute name="value">
								                <xsl:value-of select="."/>
							              </xsl:attribute>
						            </xsl:if>

						
						            <xsl:attribute name="autocomplete">
							              <xsl:text>off</xsl:text>
						            </xsl:attribute>
						            <xsl:attribute name="aria-owns">
							              <xsl:value-of select="$pickId"/>
						            </xsl:attribute>
						            <xsl:call-template name="title">
							              <xsl:with-param name="contentAfter" select="$df0"/>
						            </xsl:call-template>

						            <xsl:if test="@min">
							              <xsl:choose>
								                <xsl:when test="@allowPartial">
									                  <xsl:attribute name="data-wc-min">
										                    <xsl:value-of select="@min"/>
									                  </xsl:attribute>
								                </xsl:when>
								                <xsl:otherwise>
									                  <xsl:attribute name="min">
										                    <xsl:value-of select="@min"/>
									                  </xsl:attribute>
								                </xsl:otherwise>
							              </xsl:choose>
						            </xsl:if>
						            <xsl:if test="@max">
							              <xsl:choose>
								                <xsl:when test="@allowPartial">
									                  <xsl:attribute name="data-wc-max">
										                    <xsl:value-of select="@max"/>
									                  </xsl:attribute>
								                </xsl:when>
								                <xsl:otherwise>
									                  <xsl:attribute name="max">
										                    <xsl:value-of select="@max"/>
									                  </xsl:attribute>
								                </xsl:otherwise>
							              </xsl:choose>
						            </xsl:if>
						            <xsl:if test="@required">
							              <xsl:attribute name="placeholder">
								                <xsl:value-of select="$cm2"/>
							              </xsl:attribute>
						            </xsl:if>
						            <xsl:call-template name="ajaxController"/>
						            <xsl:call-template name="disabledElement">
							              <xsl:with-param name="isControl" select="1"/>
						            </xsl:call-template>
					          </xsl:element>
					
					          <xsl:element name="button">
						            <xsl:attribute name="value">
							              <xsl:value-of select="$inputId"/>
						            </xsl:attribute>
						            <xsl:attribute name="tabindex">
							              <xsl:text>-1</xsl:text>
						            </xsl:attribute>
						
						            <xsl:attribute name="id">
							              <xsl:value-of select="$pickId"/>
						            </xsl:attribute>
						            <xsl:attribute name="type">
							              <xsl:text>button</xsl:text>
						            </xsl:attribute>
						            <xsl:attribute name="aria-haspopup">
							              <xsl:copy-of select="$t"/>
						            </xsl:attribute>
						            <xsl:attribute name="class">
							              <xsl:text>wc_wdf_cal wc_btn_nada</xsl:text>
						            </xsl:attribute>
						            <xsl:call-template name="hideElementIfHiddenSet"/>
						            <xsl:call-template name="disabledElement">
							              <xsl:with-param name="isControl" select="1"/>
						            </xsl:call-template>
						            <xsl:attribute name="title">
							              <xsl:value-of select="$df9"/>
						            </xsl:attribute>
					          </xsl:element>
					          <xsl:element name="ul">
						            <xsl:attribute name="role">
							              <xsl:text>listbox</xsl:text>
						            </xsl:attribute>
						            <xsl:element name="li">
							              <xsl:attribute name="role">option</xsl:attribute>
						            </xsl:element>
					          </xsl:element>
				        </div>
				        <xsl:call-template name="inlineError">
					          <xsl:with-param name="errors" select="$isError"/>
				        </xsl:call-template>
			      </xsl:otherwise>
		    </xsl:choose>
	  </xsl:template>
   <xsl:template match="ui:debugInfo|ui:debug"/>
   <xsl:template match="ui:labelBody|ui:labelHead|ui:labelTail">
		    <xsl:param name="output" select="'span'"/>
		    <xsl:element name="{$output}">
			      <xsl:attribute name="id">
				        <xsl:value-of select="@id"/>
			      </xsl:attribute>
			      <xsl:attribute name="class">
				        <xsl:text>wc_dlbl_seg </xsl:text>
				        <xsl:value-of select="local-name(.)"/>
			      </xsl:attribute>
			      <xsl:apply-templates/>
		    </xsl:element>
	  </xsl:template>
   <xsl:template match="ui:decoratedLabel">
		    <xsl:param name="output" select="'span'"/>
		    <xsl:element name="{$output}">
			      <xsl:attribute name="id">
				        <xsl:value-of select="@id"/>
			      </xsl:attribute>
			      <xsl:attribute name="class">
				        <xsl:call-template name="commonClassHelper"/>
				        <xsl:if test="@type">
					          <xsl:value-of select="concat(' ',@type)"/>
				        </xsl:if>
			      </xsl:attribute>
			      <xsl:call-template name="hideElementIfHiddenSet"/>
			      <xsl:call-template name="ajaxTarget">
				        <xsl:with-param name="live" select="'off'"/>
			      </xsl:call-template>
			      <xsl:apply-templates select="*">
				        <xsl:with-param name="output" select="$output"/>
			      </xsl:apply-templates>
		    </xsl:element>
	  </xsl:template>
   <xsl:template match="ui:data">
		    <xsl:element name="dd">
			      <xsl:apply-templates/>
		    </xsl:element>
	  </xsl:template>
   <xsl:template match="ui:term">
		    <xsl:element name="dt">
			      <xsl:value-of select="@text"/>
		    </xsl:element>
		    <xsl:apply-templates select="ui:data"/>
	  </xsl:template>
   <xsl:template match="ui:definitionList">
		    <xsl:element name="dl">
			      <xsl:attribute name="id">
				        <xsl:value-of select="@id"/>
			      </xsl:attribute>
			      <xsl:attribute name="class">
				        <xsl:call-template name="commonClassHelper"/>
				        <xsl:if test="@type">
					          <xsl:value-of select="concat(' ', @type)"/>
				        </xsl:if>
			      </xsl:attribute>
			
			      <xsl:apply-templates select="ui:margin"/>
			      <xsl:call-template name="ajaxTarget">
				        <xsl:with-param name="live" select="'off'"/>
			      </xsl:call-template>
			      <xsl:apply-templates select="ui:term"/>
		    </xsl:element>
	  </xsl:template>
   <xsl:template match="ui:dialog"/>
   <xsl:template match="ui:dialog[ui:button and not(ui:content)]">
		    <xsl:apply-templates select="ui:button"/>
	  </xsl:template>
   <xsl:template match="ui:dropdown[@type='combo' and not(@readOnly='true')]">
		    <xsl:variable name="id" select="@id"/>
		    <xsl:variable name="isError" select="key('errorKey',$id)"/>
		    <xsl:variable name="myLabel" select="key('labelKey',$id)"/>
		    <xsl:variable name="listId" select="concat($id, '-l')"/>
		    <xsl:if test="not($myLabel)">
			      <xsl:call-template name="checkLabel">
				        <xsl:with-param name="force" select="1"/>
			      </xsl:call-template>
		    </xsl:if>
		    <xsl:element name="input">
			      <xsl:attribute name="type">
				        <xsl:text>text</xsl:text>
			      </xsl:attribute>
			      <xsl:attribute name="role">
				        <xsl:text>combobox</xsl:text>
			      </xsl:attribute>
			      <xsl:attribute name="aria-autocomplete">
				        <xsl:text>both</xsl:text>
			      </xsl:attribute>
			      <xsl:attribute name="aria-owns">
				        <xsl:value-of select="$listId"/>
			      </xsl:attribute>
			
			      <xsl:attribute name="autocomplete">
				        <xsl:text>off</xsl:text>
			      </xsl:attribute>
			      <xsl:if test="@optionWidth">
				        <xsl:attribute name="size">
					          <xsl:value-of select="@optionWidth"/>
				        </xsl:attribute>
			      </xsl:if>
			      <xsl:if test="@data">
				        <xsl:attribute name="data-wc-list">
					          <xsl:value-of select="@data"/>
				        </xsl:attribute>
			      </xsl:if>
			      <xsl:call-template name="commonControlAttributes">
				        <xsl:with-param name="isError" select="$isError"/>
				        <xsl:with-param name="name" select="$id"/>
				        <xsl:with-param name="live" select="'off'"/>
				        <xsl:with-param name="value">
					          <xsl:choose>
						            <xsl:when test="@data">
							              <xsl:apply-templates select="ui:option[1]" mode="comboValue"/>
						            </xsl:when>
						            <xsl:otherwise>
							              <xsl:apply-templates select=".//ui:option[@selected][1]" mode="comboValue"/>
						            </xsl:otherwise>
					          </xsl:choose>
				        </xsl:with-param>
				        <xsl:with-param name="myLabel" select="$myLabel[1]"/>
			      </xsl:call-template>
		    </xsl:element>
		    <xsl:element name="ul">
			      <xsl:attribute name="id">
				        <xsl:value-of select="$listId"/>
			      </xsl:attribute>
			      <xsl:attribute name="role">
				        <xsl:text>listbox</xsl:text>
			      </xsl:attribute>
			      <xsl:attribute name="aria-controls">
				        <xsl:value-of select="$id"/>
			      </xsl:attribute>
			      <xsl:call-template name="hiddenElement"/>
			      <xsl:apply-templates mode="comboDataList"/>
		    </xsl:element>
	  </xsl:template>
   <xsl:template match="ui:input">
		    <xsl:param name="parentLayout"/>
		    <xsl:param name="labelWidth"/>
		    <xsl:param name="isCheckRadio"/>
		    <xsl:variable name="inputWidth" select="../@inputWidth"/>
		    <xsl:element name="div">
			      <xsl:attribute name="class">
				        <xsl:text>input</xsl:text>
				        <xsl:if test="$inputWidth">
					          <xsl:text> inputWidth</xsl:text>
				        </xsl:if>
			      </xsl:attribute>
			
			      <xsl:variable name="inputContainerWidth">
				        <xsl:if test="$labelWidth!=''">
					          <xsl:value-of select="100 - format-number($labelWidth,'#')"/>
				        </xsl:if>
			      </xsl:variable>
			      <xsl:variable name="inputStyle">
				        <xsl:if test="$parentLayout and $labelWidth!=''">
					          <xsl:choose>
						            <xsl:when test="not($inputWidth)">
							              <xsl:value-of select="concat('width:',$inputContainerWidth,'%;')"/>
							              <xsl:value-of select="concat('max-width:',$inputContainerWidth,'%;')"/>
						            </xsl:when>
						            <xsl:otherwise>
							              <xsl:value-of select="concat('max-width:',$inputContainerWidth,'%;')"/>
						            </xsl:otherwise>
					          </xsl:choose>
					
					          <xsl:if test="not($labelWidth='100') and ($parentLayout='stacked' or preceding-sibling::ui:label/@hidden)">
						            <xsl:text>margin-left:</xsl:text>
						            <xsl:value-of select="format-number($labelWidth,'#')"/>
						            <xsl:text>%;</xsl:text>
					          </xsl:if>
				        </xsl:if>
				        <xsl:if test="$inputWidth">
					          <xsl:value-of select="concat('width:',$inputWidth,'%;')"/>
				        </xsl:if>
			      </xsl:variable>
			      <xsl:if test="$inputStyle!=''">
				        <xsl:attribute name="style">
					          <xsl:value-of select="$inputStyle"/>
				        </xsl:attribute>
			      </xsl:if>
			      <xsl:choose>
				        <xsl:when test="$isCheckRadio!=1">
					          <xsl:apply-templates select="node()[not(self::ui:fieldIndicator)]"/>
					          <xsl:apply-templates select="ui:fieldIndicator"/>
				        </xsl:when>
				        <xsl:otherwise>
					          <xsl:apply-templates select="ui:checkBox|ui:radioButton|ui:selectToggle"/>
					          <xsl:apply-templates select="node()[not(self::ui:fieldIndicator or self::ui:checkBox or self::ui:radioButton or self::ui:selectToggle)]"/>
					          <xsl:apply-templates select="ui:fieldIndicator"/>
				        </xsl:otherwise>
			      </xsl:choose>
		    </xsl:element>
	  </xsl:template>
   <xsl:template match="ui:field">
		    <xsl:param name="labelWidth" select="../@labelWidth"/>
		    <xsl:param name="layout" select="../@layout"/>
		    <xsl:if test="parent::ui:fieldLayout or parent::ui:ajaxTarget">
			
			      <xsl:variable name="hasParentLayout" select="parent::ui:fieldLayout"/>
			
			      <xsl:variable name="isCheckRadio">
				        <xsl:call-template name="fieldIsCheckRadio"/>
			      </xsl:variable>
			      <li id="{@id}">
				        <xsl:attribute name="id">
					          <xsl:value-of select="@id"/>
				        </xsl:attribute>

				        <xsl:call-template name="makeCommonClass"/>
				
				        <xsl:if test="not(parent::ui:fieldLayout)">
					          <xsl:attribute name="data-wc-nop">
						            <xsl:copy-of select="$t"/>
					          </xsl:attribute>
				        </xsl:if>
				        <xsl:call-template name="hideElementIfHiddenSet"/>
				        <xsl:call-template name="ajaxTarget"/>
				        <xsl:if test=" not($layout = 'stacked') and ($isCheckRadio=1 or not(ui:label))">
					          <span class="wc_fld_pl">
						            <xsl:if test="$labelWidth!=''">
							              <xsl:attribute name="style">
								                <xsl:value-of select="concat('width:',$labelWidth,'%;')"/>
							              </xsl:attribute>
						            </xsl:if>
						            <xsl:text> </xsl:text>
					          </span>
				        </xsl:if>
				        <xsl:if test="$isCheckRadio!=1">
					          <xsl:apply-templates select="ui:label">
						            <xsl:with-param name="style">
							              <xsl:if test="$labelWidth!='' and not($layout = 'stacked')">
								                <xsl:value-of select="concat('width:',$labelWidth,'%;')"/>
							              </xsl:if>
						            </xsl:with-param>
					          </xsl:apply-templates>
				        </xsl:if>
				        <xsl:apply-templates select="ui:input">
					          <xsl:with-param name="labelWidth" select="$labelWidth"/>
					          <xsl:with-param name="parentLayout" select="$layout"/>
					          <xsl:with-param name="isCheckRadio" select="$isCheckRadio"/>
				        </xsl:apply-templates>
			      </li>
		    </xsl:if>
	  </xsl:template>
   <xsl:template match="ui:fieldLayout">
		    <xsl:variable name="element">
			      <xsl:choose>
				        <xsl:when test="@ordered">
					          <xsl:text>ol</xsl:text>
				        </xsl:when>
				        <xsl:otherwise>
					          <xsl:text>ul</xsl:text>
				        </xsl:otherwise>
			      </xsl:choose>
		    </xsl:variable>
		    <xsl:element name="{$element}">
			      <xsl:attribute name="id">
            <xsl:value-of select="@id"/>
         </xsl:attribute>
			      <xsl:attribute name="class">
				        <xsl:call-template name="commonClassHelper"/>
				        <xsl:value-of select="concat(' ', @layout)"/>
			      </xsl:attribute>
			      <xsl:if test="@ordered and @ordered &gt; 1">
				        <xsl:attribute name="start">
					          <xsl:value-of select="@ordered"/>
				        </xsl:attribute>
			      </xsl:if>
			      <xsl:call-template name="hideElementIfHiddenSet"/>
			      <xsl:call-template name="ajaxTarget"/>
			      <xsl:if test="@labelWidth">
				        <xsl:attribute name="data-wc-labelwidth">
					          <xsl:value-of select="@labelWidth"/>
				        </xsl:attribute>
			      </xsl:if>
			      <xsl:apply-templates select="ui:margin"/>
			      <xsl:apply-templates select="ui:field"/>
		    </xsl:element>
	  </xsl:template>
   <xsl:template match="ui:fieldSet">
		    <xsl:variable name="frame">
			      <xsl:value-of select="@frame"/>
		    </xsl:variable>
		
		    <xsl:variable name="isError" select="key('errorKey',@id)"/>
		    <xsl:element name="fieldset">
			      <xsl:attribute name="id">
				        <xsl:value-of select="@id"/>
			      </xsl:attribute>
			      <xsl:attribute name="class">
				        <xsl:call-template name="commonClassHelper"/>
				        <xsl:if test="$frame='noborder' or $frame='none'">
					          <xsl:text> noborder</xsl:text>
				        </xsl:if>
				        <xsl:if test="$frame='notext' or $frame='none'">
					          <xsl:text> notext</xsl:text>
				        </xsl:if>
				        <xsl:if test="@required">
					          <xsl:text> wc_req</xsl:text>
				        </xsl:if>
			      </xsl:attribute>
			      <xsl:apply-templates select="ui:margin"/>
			      <xsl:if test="$isError">
				        <xsl:call-template name="invalid"/>
			      </xsl:if>
			      <xsl:call-template name="hideElementIfHiddenSet"/>

			      <xsl:call-template name="ajaxTarget"/>
			
			      <xsl:element name="legend">
				        <xsl:call-template name="accessKey"/>
				        <xsl:apply-templates select="ui:decoratedLabel"/>
				        <xsl:if test="normalize-space(ui:decoratedLabel/*)='' and not(ui:decoratedLabel//ui:image)">
					          <xsl:value-of select="$cm1"/>
				        </xsl:if>
				        <xsl:if test="@required">
					          <xsl:call-template name="offscreenSpan">
						            <xsl:with-param name="text">
							              <xsl:value-of select="$cm2"/>
						            </xsl:with-param>
					          </xsl:call-template>
				        </xsl:if>
			      </xsl:element>

			      <xsl:apply-templates select="ui:content"/>
			      <xsl:if test="$isError">
				        <xsl:call-template name="inlineError">
					          <xsl:with-param name="errors" select="$isError"/>
				        </xsl:call-template>
			      </xsl:if>
		    </xsl:element>
	  </xsl:template>
   <xsl:template match="ui:fieldIndicator">
		    <ul id="{@id}">
			      <xsl:attribute name="class">
				        <xsl:call-template name="commonClassHelper"/>
				        <xsl:value-of select="concat(' ', @type)"/>
			      </xsl:attribute>
			      <xsl:apply-templates/>
		    </ul>
	  </xsl:template>
   <xsl:template match="ui:fieldIndicator[@type='error']"/>
   <xsl:template match="ui:figure">
		    <xsl:variable name="mode" select="@mode"/>
		    <xsl:element name="FIGURE">
			      <xsl:attribute name="id">
				        <xsl:value-of select="@id"/>
			      </xsl:attribute>
			      <xsl:attribute name="class">
				        <xsl:call-template name="commonClassHelper"/>
				        <xsl:if test="$mode='lazy' and @hidden">
					          <xsl:text> wc_magic</xsl:text>
				        </xsl:if>
			      </xsl:attribute>
			      <xsl:if test="ui:decoratedLabel">
				        <xsl:attribute name="aria-labelledby">
					          <xsl:value-of select="ui:decoratedLabel/@id"/>
				        </xsl:attribute>
			      </xsl:if>
			      <xsl:apply-templates select="ui:margin"/>
			      <xsl:call-template name="hideElementIfHiddenSet"/>
			      <xsl:if test="*[not(self::ui:margin)] or not($mode='eager')">
				        <xsl:if test="ui:content">
					          <div class="content">
						            <xsl:apply-templates select="ui:content"/>
					          </div>
				        </xsl:if>
				        <xsl:element name="FIGCAPTION">
					          <xsl:apply-templates select="ui:decoratedLabel"/>
				        </xsl:element>
			      </xsl:if>
		    </xsl:element>
	  </xsl:template>
   <xsl:template match="ui:file">
		    <xsl:call-template name="fileInList"/>
	  </xsl:template>
   <xsl:template match="ui:fileUpload">
		    <xsl:variable name="id" select="@id"/>
		    <xsl:variable name="isError" select="key('errorKey',$id)"/>
		    <xsl:variable name="readOnly">
			      <xsl:if test="@readOnly">
				        <xsl:number value="1"/>
			      </xsl:if>
		    </xsl:variable>
		    <xsl:variable name="legacy">
			      <xsl:if test="@async='false'">
				        <xsl:number value="1"/>
			      </xsl:if>
		    </xsl:variable>
		    <xsl:variable name="maxFiles" select="@maxFiles"/>
		    <xsl:variable name="myLabel" select="key('labelKey',$id)[1]"/>

		    <xsl:variable name="cols">
			      <xsl:choose>
				        <xsl:when test="@cols">
					          <xsl:value-of select="@cols"/>
				        </xsl:when>
				        <xsl:otherwise>
					          <xsl:number value="0"/>
				        </xsl:otherwise>
			      </xsl:choose>
		    </xsl:variable>

		    <xsl:choose>
			      <xsl:when test="$readOnly=1 and $legacy=1">
				        <xsl:call-template name="readOnlyControl">
					          <xsl:with-param name="label" select="$myLabel"/>
				        </xsl:call-template>
			      </xsl:when>
			      <xsl:when test="$legacy=1">
				        <xsl:call-template name="fileInput">
					          <xsl:with-param name="id" select="$id"/>
				        </xsl:call-template>
				        <xsl:call-template name="inlineError">
					          <xsl:with-param name="errors" select="$isError"/>
				        </xsl:call-template>
			      </xsl:when>
			      <xsl:otherwise>
				        <xsl:variable name="containerTag">
					          <xsl:if test="$readOnly!=1">
						            <xsl:text>fieldset</xsl:text>
					          </xsl:if>
					          <xsl:if test="$readOnly=1">
						            <xsl:text>div</xsl:text>
					          </xsl:if>
				        </xsl:variable>
				        <xsl:element name="{$containerTag}">
					          <xsl:call-template name="commonWrapperAttributes">
						            <xsl:with-param name="isError" select="$isError"/>
						            <xsl:with-param name="myLabel" select="$myLabel"/>
					          </xsl:call-template>
					          <xsl:if test="@ajax=$t">
						            <xsl:attribute name="data-wc-ajaxalias">
							              <xsl:value-of select="@id"/>
						            </xsl:attribute>
					          </xsl:if>
					          <xsl:attribute name="data-wc-cols">
						            <xsl:value-of select="$cols"/>
					          </xsl:attribute>
					          <xsl:if test="$readOnly!=1">
						            <xsl:call-template name="makeLegend">
							              <xsl:with-param name="myLabel" select="$myLabel"/>
						            </xsl:call-template>

						            <xsl:variable name="inputId" select="concat($id,generate-id())"/>
						            <xsl:element name="label">
							              <xsl:attribute name="class">
								                <xsl:text>wc_off</xsl:text>
							              </xsl:attribute>
							              <xsl:attribute name="for">
								                <xsl:value-of select="$inputId"/>
							              </xsl:attribute>
							              <xsl:value-of select="$mfu4"/>
						            </xsl:element>
						            <xsl:call-template name="fileInput">
							              <xsl:with-param name="id" select="$inputId"/>
						            </xsl:call-template>
						            <xsl:call-template name="inlineError">
							              <xsl:with-param name="errors" select="$isError"/>
						            </xsl:call-template>
					          </xsl:if>
					          <xsl:if test="ui:file">
						            <xsl:variable name="numFiles" select="count(ui:file)"/>
						            <xsl:choose>
							              <xsl:when test="$cols &gt; 1 and $cols &gt;= $numFiles">
								                <div class="wc_files">
									                  <xsl:apply-templates select="ui:file[1]" mode="columns">
										                    <xsl:with-param name="rows" select="$numFiles"/>
									                  </xsl:apply-templates>
								                </div>
							              </xsl:when>
							              <xsl:when test="$cols &gt; 1">
								                <xsl:variable name="rows">
									                  <xsl:value-of select="ceiling($numFiles div $cols)"/>
								                </xsl:variable>
								                <div class="wc_files">
									                  <xsl:apply-templates select="ui:file[position() mod $rows = 1]" mode="columns">
										                    <xsl:with-param name="rows" select="$rows"/>
									                  </xsl:apply-templates>
								                </div>
							              </xsl:when>
							              <xsl:otherwise>
								                <ul>
									                  <xsl:attribute name="class">
										                    <xsl:text>wc_filelist wc_list_nb</xsl:text>
										                    <xsl:if test="$cols = 0">
											                      <xsl:text> wc_list_flat</xsl:text>
										                    </xsl:if>
									                  </xsl:attribute>
									                  <xsl:apply-templates select="ui:file"/>
								                </ul>
							              </xsl:otherwise>
						            </xsl:choose>
					          </xsl:if>
				        </xsl:element>
			      </xsl:otherwise>
		    </xsl:choose>
	  </xsl:template>
   <xsl:template match="ui:filterControl"/>
   <xsl:template match="ui:flowLayout">
		    <xsl:element name="div">
			      <xsl:attribute name="class">
				        <xsl:value-of select="concat('flowLayout ',@align)"/>
				        <xsl:if test="@valign">
					          <xsl:value-of select="concat(' ',@valign)"/>
				        </xsl:if>
			      </xsl:attribute>
			      <xsl:variable name="hgap">
				        <xsl:call-template name="getHVGap"/>
			      </xsl:variable>
			      <xsl:variable name="vgap">
				        <xsl:call-template name="getHVGap">
					          <xsl:with-param name="gap" select="@vgap"/>
				        </xsl:call-template>
			      </xsl:variable>
			      <xsl:variable name="align">
				        <xsl:value-of select="@align"/>
			      </xsl:variable>
			      <xsl:apply-templates select="ui:cell[node()]" mode="fl">
				        <xsl:with-param name="align" select="$align"/>
				        <xsl:with-param name="hgap" select="$hgap"/>
				        <xsl:with-param name="vgap" select="$vgap"/>
			      </xsl:apply-templates>
		    </xsl:element>
	  </xsl:template>
   <xsl:template match="ui:gridLayout">
		    <xsl:if test="ui:cell">
			      <div class="{local-name(.)}">
				        <xsl:variable name="cols" select="@cols"/>
				        <xsl:variable name="rows" select="@rows"/>
				
				        <xsl:variable name="useCols">
					          <xsl:choose>
						            <xsl:when test="$cols &gt; 0">
							              <xsl:number value="$cols"/>
						            </xsl:when>
						            <xsl:when test="$rows &gt; 0">
							              <xsl:value-of select="ceiling(count(ui:cell) div $rows)"/>
						            </xsl:when>
						            <xsl:otherwise>
							              <xsl:number value="1"/>
						            </xsl:otherwise>
					          </xsl:choose>
				        </xsl:variable>
				
				        <xsl:variable name="colWidth">
					          <xsl:choose>
						            <xsl:when test="$useCols=1">
							              <xsl:text>100%</xsl:text>
						            </xsl:when>
						            <xsl:otherwise>
							              <xsl:value-of select="format-number(1 div $useCols,'##0.###%')"/>
						            </xsl:otherwise>
					          </xsl:choose>
				        </xsl:variable>
				
				        <xsl:variable name="hgap">
					          <xsl:choose>
						            <xsl:when test="$useCols=1">
							              <xsl:number value="0"/>
						            </xsl:when>
						            <xsl:otherwise>
							              <xsl:call-template name="getHVGap">
								                <xsl:with-param name="divisor" select="2"/>
							              </xsl:call-template>
						            </xsl:otherwise>
					          </xsl:choose>
				        </xsl:variable>
				
				        <xsl:variable name="vgap">
					          <xsl:call-template name="getHVGap">
						            <xsl:with-param name="gap" select="@vgap"/>
					          </xsl:call-template>
				        </xsl:variable>
				
				        <xsl:choose>
					          <xsl:when test="$useCols=1">
						            <xsl:apply-templates select="ui:cell" mode="gl">
							              <xsl:with-param name="vgap" select="$vgap"/>
						            </xsl:apply-templates>
					          </xsl:when>
					          <xsl:otherwise>
						            <xsl:apply-templates select="ui:cell[position() mod $useCols = 1]" mode="gl">
							              <xsl:with-param name="cols" select="$useCols"/>
							              <xsl:with-param name="colWidth" select="$colWidth"/>
							              <xsl:with-param name="hgap" select="$hgap"/>
							              <xsl:with-param name="vgap" select="$vgap"/>
						            </xsl:apply-templates>
					          </xsl:otherwise>
				        </xsl:choose>
			      </div>
		    </xsl:if>		
	  </xsl:template>
   <xsl:template match="ui:heading">
		    <xsl:element name="{concat('h',@level)}">
			      <xsl:attribute name="id">
				        <xsl:value-of select="@id"/>
			      </xsl:attribute>
			      <xsl:call-template name="makeCommonClass"/>
			      <xsl:call-template name="ajaxTarget"/>
			      <xsl:apply-templates select="ui:margin"/>
			      <xsl:choose>
				        <xsl:when test="ui:decoratedLabel">
					          <xsl:apply-templates select="ui:decoratedLabel"/>
				        </xsl:when>
				        <xsl:otherwise>
					          <xsl:value-of select="."/>
				        </xsl:otherwise>
			      </xsl:choose>
		    </xsl:element>
	  </xsl:template>
   <xsl:template match="ui:image">
		    <xsl:element name="img">
			      <xsl:attribute name="id">
				        <xsl:value-of select="@id"/>
			      </xsl:attribute>
			      <xsl:call-template name="makeCommonClass"/>
			      <xsl:attribute name="src">
				        <xsl:value-of select="@src"/>
			      </xsl:attribute>
			      <xsl:attribute name="alt">
				        <xsl:value-of select="@alt"/>
			      </xsl:attribute>
			      <xsl:if test="@width">
				        <xsl:attribute name="width">
					          <xsl:value-of select="@width"/>
				        </xsl:attribute>
			      </xsl:if>
			      <xsl:if test="@height">
				        <xsl:attribute name="height">
					          <xsl:value-of select="@height"/>
				        </xsl:attribute>
			      </xsl:if>
			      <xsl:call-template name="hideElementIfHiddenSet"/>
			      <xsl:call-template name="ajaxTarget"/>
		    </xsl:element>
		    <xsl:if test="@editor">
			      <xsl:call-template name="imageEditButton">
				        <xsl:with-param name="text">
					          <xsl:text>Edit</xsl:text>
				        </xsl:with-param>
			      </xsl:call-template>
		    </xsl:if>
	  </xsl:template>
   <xsl:template match="html:wc-imageedit"/>
   <xsl:template match="ui:js"/>
   <xsl:template match="ui:label">
		    <xsl:param name="style"/>
		    <xsl:variable name="for" select="@for"/>

		    <xsl:choose>
			
			      <xsl:when test="$for and $for!=''">
				        <xsl:variable name="labelableElement" select="key('labelableElementKey',$for)[1]"/>
				        <xsl:choose>
					          <xsl:when test="$labelableElement">
						
						            <xsl:if test="not(local-name($labelableElement)='checkBox' or local-name($labelableElement)='radioButton' or local-name($labelableElement)='selectToggle')">
							              <xsl:call-template name="makeLabel">
								                <xsl:with-param name="labelableElement" select="$labelableElement"/>
								                <xsl:with-param name="style" select="$style"/>
							              </xsl:call-template>
						            </xsl:if>
					          </xsl:when>
					          <xsl:otherwise>
						
						            <xsl:variable name="forElement" select="//*[@id=$for and not(self::ui:application)]"/>
						            <xsl:choose>
							              <xsl:when test="$forElement">
								                <xsl:call-template name="makeFauxLabel">
									                  <xsl:with-param name="forElement" select="$forElement"/>
									                  <xsl:with-param name="style" select="$style"/>
								                </xsl:call-template>
							              </xsl:when>
							              <xsl:otherwise>
								                <xsl:call-template name="makeLabelForNothing">
									                  <xsl:with-param name="style" select="$style"/>
								                </xsl:call-template>
							              </xsl:otherwise>
						            </xsl:choose>
					          </xsl:otherwise>
				        </xsl:choose>
			      </xsl:when>
			      <xsl:when test="not($for)">
				
				        <xsl:variable name="labelableDescendant"
                          select=".//ui:button|.//ui:checkBox|.//ui:dateField|.//ui:dropdown|.//ui:emailField|.//ui:fileUpload[@async='false']|.//ui:listBox|.//ui:numberField|.//ui:passwordField|.//ui:phoneNumberField|.//ui:printButton|.//ui:progressBar|.//ui:radioButton|.//ui:textArea|.//ui:textField"/>
				        <xsl:choose>
					          <xsl:when test="count($labelableDescendant)=1">
						            <xsl:call-template name="makeLabel">
							              <xsl:with-param name="labelableElement" select="$labelableDescendant[1]"/>
							              <xsl:with-param name="style" select="$style"/>
						            </xsl:call-template>
					          </xsl:when>
					          <xsl:otherwise>
						            <xsl:call-template name="makeLabelForNothing">
							              <xsl:with-param name="style" select="$style"/>
						            </xsl:call-template>
					          </xsl:otherwise>
				        </xsl:choose>
			      </xsl:when>
			      <xsl:otherwise>
				
				        <xsl:call-template name="makeLabelForNothing">
					          <xsl:with-param name="style" select="$style"/>
				        </xsl:call-template>
			      </xsl:otherwise>
		    </xsl:choose>
	  </xsl:template>
   <xsl:template match="ui:windowAttributes"/>
   <xsl:template match="ui:link">
		    <xsl:param name="imageAltText" select="''"/>
		    <xsl:variable name="type" select="@type"/>
		    <xsl:variable name="hasPopup">
			      <xsl:if test="ui:windowAttributes[count(@*) &gt; 1] or ($type='button' and ui:windowAttributes)">
				        <xsl:number value="1"/>
			      </xsl:if>
		    </xsl:variable>
		    <xsl:variable name="elementType">
			      <xsl:choose>
				        <xsl:when test="$type='button' or $hasPopup=1">
					          <xsl:text>button</xsl:text>
				        </xsl:when>
				        <xsl:otherwise>
					          <xsl:text>a</xsl:text>
				        </xsl:otherwise>
			      </xsl:choose>
		    </xsl:variable>
		    <xsl:variable name="class">
			      <xsl:call-template name="commonClassHelper"/>
			      <xsl:if test="@imagePosition">
				        <xsl:value-of select="concat(' wc_btn_img',@imagePosition)"/>
			      </xsl:if>
		    </xsl:variable>
		    <xsl:element name="{$elementType}">
			      <xsl:choose>
				        <xsl:when test="$elementType='a'">
					          <xsl:attribute name="href">
						            <xsl:value-of select="@url"/>
					          </xsl:attribute>
					          <xsl:if test="@rel">
						            <xsl:attribute name="rel">
							              <xsl:value-of select="@rel"/>
						            </xsl:attribute>
					          </xsl:if>
					          <xsl:if test="ui:windowAttributes">
						
						            <xsl:attribute name="target">
							              <xsl:value-of select="ui:windowAttributes/@name"/>
						            </xsl:attribute>
					          </xsl:if>
					          <xsl:attribute name="class">
						            <xsl:value-of select="$class"/>
					          </xsl:attribute>
				        </xsl:when>
				        <xsl:otherwise>
					          <xsl:attribute name="type">
						            <xsl:text>button</xsl:text>
					          </xsl:attribute>
					          <xsl:attribute name="class">
						            <xsl:value-of select="$class"/>
						            <xsl:if test="not($type='button')">
							              <xsl:text> wc_btn_link</xsl:text>
						            </xsl:if>
						            <xsl:if test="@imageUrl and not(@imagePosition)">
							              <xsl:text> wc_btn_img</xsl:text>
						            </xsl:if>
					          </xsl:attribute>
					
					          <xsl:attribute name="data-wc-url">
						            <xsl:value-of select="@url"/>
					          </xsl:attribute>
					          <xsl:if test="$hasPopup=1">
						            <xsl:attribute name="aria-haspopup">
							              <xsl:copy-of select="$t"/>
						            </xsl:attribute>
						            <xsl:attribute name="data-wc-specs">
							              <xsl:apply-templates select="ui:windowAttributes" mode="specs"/>
						            </xsl:attribute>
						            <xsl:attribute name="data-wc-window">
							              <xsl:value-of select="ui:windowAttributes/@name"/>
						            </xsl:attribute>
					          </xsl:if>
				        </xsl:otherwise>
			      </xsl:choose>
			      <xsl:call-template name="buttonLinkCommon">
				        <xsl:with-param name="imageAltText" select="$imageAltText"/>
			      </xsl:call-template>
		    </xsl:element>
	  </xsl:template>
   <xsl:template match="ui:listLayout">
		    <xsl:variable name="listElement">
			      <xsl:choose>
				        <xsl:when test="@ordered=$t">
					          <xsl:text>ol</xsl:text>
				        </xsl:when>
				        <xsl:otherwise>
					          <xsl:text>ul</xsl:text>
				        </xsl:otherwise>
			      </xsl:choose>
		    </xsl:variable>
		    <xsl:element name="{$listElement}">
			      <xsl:attribute name="class">
				        <xsl:value-of select="normalize-space(concat('listLayout ',@type,' ', @align))"/>
				        <xsl:if test="not(@align)">
					          <xsl:text> left</xsl:text>
				        </xsl:if>
				        <xsl:choose>
					          <xsl:when test="@ordered=$t and (not(@separator) or @separator='none')">
						            <xsl:text> none</xsl:text>
					          </xsl:when>
					          <xsl:when test="not(@ordered=$t) and @separator">
						            <xsl:value-of select="concat(' ',@separator)"/>
					          </xsl:when>
					          <xsl:when test="not(@ordered=$t)">
						            <xsl:text> none</xsl:text>
					          </xsl:when>
				        </xsl:choose>
				        <xsl:if test="not(@ordered=$t)">
				</xsl:if>
			      </xsl:attribute>
			      <xsl:variable name="hgap">
				        <xsl:call-template name="getHVGap"/>
			      </xsl:variable>
			      <xsl:variable name="vgap">
				        <xsl:call-template name="getHVGap">
					          <xsl:with-param name="gap" select="@vgap"/>
				        </xsl:call-template>
			      </xsl:variable>
			      <xsl:apply-templates mode="ll">
				        <xsl:with-param name="hgap" select="$hgap"/>
				        <xsl:with-param name="vgap" select="$vgap"/>
			      </xsl:apply-templates>
		    </xsl:element>
	  </xsl:template>
   <xsl:template match="ui:margin">
		    <xsl:param name="style"/>
		    <xsl:variable name="margin">
			      <xsl:choose>
				        <xsl:when test="@all">
					          <xsl:call-template name="pxWithUnit">
						            <xsl:with-param name="gap" select="@all"/>
					          </xsl:call-template>
				        </xsl:when>
				        <xsl:otherwise>
					
					          <xsl:call-template name="pxWithUnit">
						            <xsl:with-param name="gap" select="@north"/>
					          </xsl:call-template>
					          <xsl:value-of select="' '"/>
					          <xsl:call-template name="pxWithUnit">
						            <xsl:with-param name="gap" select="@east"/>
					          </xsl:call-template>
					          <xsl:value-of select="' '"/>
					          <xsl:call-template name="pxWithUnit">
						            <xsl:with-param name="gap" select="@south"/>
					          </xsl:call-template>
					          <xsl:value-of select="' '"/>
					          <xsl:call-template name="pxWithUnit">
						            <xsl:with-param name="gap" select="@west"/>
					          </xsl:call-template>
				        </xsl:otherwise>
			      </xsl:choose>
		    </xsl:variable>
		    <xsl:if test="$margin != '' or $style != ''">
			      <xsl:attribute name="style">
				        <xsl:if test="$margin != ''">
					          <xsl:value-of select="concat('margin:',$margin,';')"/>
				        </xsl:if>
				        <xsl:if test="$style != ''">
					          <xsl:value-of select="$style"/>
				        </xsl:if>
			      </xsl:attribute>
		    </xsl:if>
	  </xsl:template>
   <xsl:template match="ui:menu">
		    <xsl:variable name="id" select="@id"/>
		    <xsl:variable name="type" select="@type"/>
		    <xsl:variable name="isError" select="key('errorKey',$id)"/>

		    <xsl:variable name="isBarFlyout">
			      <xsl:if test="$type='bar' or $type='flyout'">
				        <xsl:number value="1"/>
			      </xsl:if>
		    </xsl:variable>

		    <xsl:element name="div">
			      <xsl:attribute name="id">
				        <xsl:value-of select="$id"/>
			      </xsl:attribute>
			      <xsl:call-template name="ajaxTarget"/>

			      <xsl:apply-templates select="ui:margin"/>
			
			      <xsl:attribute name="class">
				        <xsl:call-template name="commonClassHelper"/>
				        <xsl:value-of select="concat(' ', @type)"/>
			      </xsl:attribute>

			
			      <xsl:attribute name="role">
				        <xsl:choose>
					          <xsl:when test="@type='tree'">
						            <xsl:text>tree</xsl:text>
					          </xsl:when>
					          <xsl:when test="$isBarFlyout=1">
						            <xsl:text>menubar</xsl:text>
					          </xsl:when>
					          <xsl:otherwise>
						            <xsl:text>menu</xsl:text>
					          </xsl:otherwise>
				        </xsl:choose>
			      </xsl:attribute>
			      <xsl:if test="@selectMode">
				        <xsl:choose>
					          <xsl:when test="@type='tree'">
						            <xsl:attribute name="aria-multiselectable">
							              <xsl:choose>
								                <xsl:when test="@selectMode='multiple'">
									                  <xsl:copy-of select="$t"/>
								                </xsl:when>
								                <xsl:otherwise>
									                  <xsl:text>false</xsl:text>
								                </xsl:otherwise>
							              </xsl:choose>
						            </xsl:attribute>
					          </xsl:when>
					          <xsl:otherwise>
						            <xsl:attribute name="data-wc-selectmode">
							              <xsl:value-of select="@selectMode"/>
						            </xsl:attribute>
					          </xsl:otherwise>
				        </xsl:choose>
			      </xsl:if>
			      <xsl:if test="$isError">
				        <xsl:call-template name="invalid"/>
			      </xsl:if>
			      <xsl:call-template name="hideElementIfHiddenSet"/>

			      <xsl:apply-templates select="*"/>
			      <xsl:call-template name="inlineError">
				        <xsl:with-param name="errors" select="$isError"/>
			      </xsl:call-template>
			      <xsl:call-template name="hField"/>
		    </xsl:element>
	  </xsl:template>
   <xsl:template match="ui:menu[ancestor::ui:menu]"/>
   <xsl:template match="ui:menuGroup">
		    <xsl:call-template name="separator"/>
		    <xsl:apply-templates select="*[not(self::ui:decoratedLabel)]"/>
		    <xsl:call-template name="separator"/>
	  </xsl:template>
   <xsl:template match="ui:menuItem">
		    <xsl:variable name="myAncestorMenu" select="ancestor::ui:menu[1]"/>
		    <xsl:variable name="myAncestorSubmenu"
                    select="ancestor::ui:submenu[ancestor::ui:menu[1]=$myAncestorMenu or not($myAncestorMenu)][1]"/>
		    <xsl:variable name="id" select="@id"/>
		    <xsl:variable name="menuType" select="$myAncestorMenu/@type"/>
		
		    <xsl:variable name="noContextMenu">
			      <xsl:if test="not($myAncestorMenu)">
				        <xsl:number value="1"/>
			      </xsl:if>
		    </xsl:variable>
		    <xsl:variable name="noContextSubMenu">
			      <xsl:if test="$noContextMenu=1 and not($myAncestorSubmenu)">
				        <xsl:number value="1"/>
			      </xsl:if>
		    </xsl:variable>

		    <xsl:variable name="actionType">
			      <xsl:choose>
				        <xsl:when test="@url">
					          <xsl:number value="1"/>
				        </xsl:when>
				        <xsl:when test="@submit">
					          <xsl:number value="2"/>
				        </xsl:when>
				        <xsl:otherwise>
					          <xsl:number value="0"/>
				        </xsl:otherwise>
			      </xsl:choose>
		    </xsl:variable>

		    <xsl:variable name="menuItemElement">
			      <xsl:choose>
				        <xsl:when test="$actionType=0">
					          <xsl:text>div</xsl:text>
				        </xsl:when>
				        <xsl:otherwise>
					          <xsl:text>button</xsl:text>
				        </xsl:otherwise>
			      </xsl:choose>
		    </xsl:variable>

		    <xsl:variable name="isButton">
			      <xsl:choose>
				        <xsl:when test="$actionType=0">
					          <xsl:number value="0"/>
				        </xsl:when>
				        <xsl:otherwise>
					          <xsl:number value="1"/>
				        </xsl:otherwise>
			      </xsl:choose>
		    </xsl:variable>

		    <xsl:element name="{$menuItemElement}">
			      <xsl:attribute name="id">
				        <xsl:value-of select="$id"/>
			      </xsl:attribute>
			      <xsl:attribute name="class">
				        <xsl:call-template name="commonClassHelper"/>
				        <xsl:if test="$actionType &gt; 0">
					          <xsl:text> wc_btn_nada</xsl:text>
					          <xsl:if test="@cancel">
						            <xsl:text> wc_btn_cancel</xsl:text>
					          </xsl:if>
					          <xsl:if test="@unsavedChanges">
						            <xsl:text> wc_unsaved</xsl:text>
					          </xsl:if>
				        </xsl:if>
			      </xsl:attribute>
			      <xsl:if test="@toolTip">
				        <xsl:attribute name="title">
					          <xsl:value-of select="normalize-space(@toolTip)"/>
				        </xsl:attribute>
			      </xsl:if>
			      <xsl:choose>
				        <xsl:when test="$actionType=1">
					          <xsl:attribute name="type">
						            <xsl:text>button</xsl:text>
					          </xsl:attribute>
					          <xsl:attribute name="data-wc-url">
						            <xsl:value-of select="@url"/>
					          </xsl:attribute>
					          <xsl:if test="@targetWindow">
						            <xsl:attribute name="data-wc-window">
							              <xsl:value-of select="@targetWindow"/>
						            </xsl:attribute>
						            <xsl:attribute name="aria-haspopup">
							              <xsl:copy-of select="$t"/>
						            </xsl:attribute>
					          </xsl:if>
				        </xsl:when>
				        <xsl:when test="$actionType=2">
					          <xsl:attribute name="type">
						            <xsl:text>submit</xsl:text>
					          </xsl:attribute>
					          <xsl:attribute name="name">
						            <xsl:value-of select="$id"/>
					          </xsl:attribute>
					          <xsl:attribute name="value">
						            <xsl:text>x</xsl:text>
					          </xsl:attribute>
					
					          <xsl:choose>
						            <xsl:when test="@cancel">
							              <xsl:attribute name="formnovalidate">
								                <xsl:text>formnovalidate</xsl:text>
							              </xsl:attribute>
						            </xsl:when>
						            <xsl:when test="@validates">
							              <xsl:attribute name="data-wc-validate">
								                <xsl:value-of select="@validates"/>
							              </xsl:attribute>
						            </xsl:when>
						            <xsl:when test="key('triggerKey',@id)">
							              <xsl:attribute name="formnovalidate">
								                <xsl:text>formnovalidate</xsl:text>
							              </xsl:attribute>
						            </xsl:when>
					          </xsl:choose>
				        </xsl:when>
			      </xsl:choose>
			      <xsl:if test="@msg">
				        <xsl:attribute name="data-wc-btnmsg">
					          <xsl:value-of select="@msg"/>
				        </xsl:attribute>
			      </xsl:if>
			      <xsl:call-template name="ajaxController"/>
			      <xsl:call-template name="hideElementIfHiddenSet"/>
			      <xsl:choose>
				        <xsl:when test="$myAncestorMenu">
					
					          <xsl:variable name="isSelectable">
						            <xsl:call-template name="menuRoleIsSelectable">
							              <xsl:with-param name="type" select="$menuType"/>
							              <xsl:with-param name="myAncestorMenu" select="$myAncestorMenu"/>
							              <xsl:with-param name="myAncestorSubmenu" select="$myAncestorSubmenu"/>
						            </xsl:call-template>
					          </xsl:variable>
					          <xsl:attribute name="role">
						            <xsl:choose>
							              <xsl:when test="$menuType='tree'">
								                <xsl:text>treeitem</xsl:text>
							              </xsl:when>
							              <xsl:when test="$isSelectable=1 and ($myAncestorSubmenu[not(@selectMode='single')] or (not($myAncestorSubmenu) and $myAncestorMenu[not(@selectMode='single')]))">
								                <xsl:text>menuitemcheckbox</xsl:text>
							              </xsl:when>
							              <xsl:when test="$isSelectable=1">
								                <xsl:text>menuitemradio</xsl:text>
							              </xsl:when>
							              <xsl:otherwise>
								                <xsl:text>menuitem</xsl:text>
							              </xsl:otherwise>
						            </xsl:choose>
					          </xsl:attribute>
					          <xsl:if test="$isSelectable=1">
						            <xsl:variable name="selectionAttribute">
							              <xsl:choose>
								                <xsl:when test="$menuType='tree'">
									                  <xsl:text>aria-selected</xsl:text>
								                </xsl:when>
								                <xsl:otherwise>
									                  <xsl:text>aria-checked</xsl:text>
								                </xsl:otherwise>
							              </xsl:choose>
						            </xsl:variable>
						            <xsl:attribute name="{$selectionAttribute}">
							              <xsl:choose>
								                <xsl:when test="@selected">
									                  <xsl:copy-of select="$t"/>
								                </xsl:when>
								                <xsl:otherwise>
									                  <xsl:text>false</xsl:text>
								                </xsl:otherwise>
							              </xsl:choose>
						            </xsl:attribute>
					          </xsl:if>
					          <xsl:variable name="tabindex">
						            <xsl:call-template name="menuTabIndexHelper">
							              <xsl:with-param name="menu" select="$myAncestorMenu"/>
						            </xsl:call-template>
					          </xsl:variable>
					          <xsl:if test="$tabindex!=''">
						            <xsl:attribute name="tabindex">
							              <xsl:value-of select="$tabindex"/>
						            </xsl:attribute>
					          </xsl:if>

					
					          <xsl:choose>
						            <xsl:when test="@disabled">
							              <xsl:call-template name="disabledElement">
								                <xsl:with-param name="isControl" select="$isButton"/>
							              </xsl:call-template>
						            </xsl:when>
						            <xsl:otherwise>
							
							              <xsl:variable name="disabledAncestor"
                                   select="ancestor::*[@disabled and         (($noContextMenu=1 and self::ui:submenu) or         ($myAncestorMenu and (self::ui:menu[.=$myAncestorMenu] or self::ui:submenu[ancestor::ui:menu[1]=$myAncestorMenu])))]"/>
							              <xsl:if test="$disabledAncestor">
								                <xsl:call-template name="disabledElement">
									                  <xsl:with-param name="field" select="$disabledAncestor"/>
									                  <xsl:with-param name="isControl" select="$isButton"/>
								                </xsl:call-template>
							              </xsl:if>
						            </xsl:otherwise>
					          </xsl:choose>
					
					          <xsl:if test="@accessKey and not($myAncestorSubmenu)">
						            <xsl:call-template name="accessKey"/>
					          </xsl:if>
				        </xsl:when>
				        <xsl:otherwise>
					
					          <xsl:attribute name="role">
						            <xsl:text>dummy</xsl:text>
					          </xsl:attribute>
					          <xsl:attribute name="tabindex">
						            <xsl:text>-1</xsl:text>
					          </xsl:attribute>
					          <xsl:if test="@accessKey">
						            <xsl:attribute name="accesskey">
							              <xsl:value-of select="@accessKey"/>
						            </xsl:attribute>
					          </xsl:if>
					
					          <xsl:call-template name="disabledElement">
						            <xsl:with-param name="isControl" select="$isButton"/>
					          </xsl:call-template>
					
					          <xsl:if test="@selected">
						            <xsl:attribute name="data-wc-selected">
							              <xsl:value-of select="@selected"/>
						            </xsl:attribute>
					          </xsl:if>
					          <xsl:if test="@selectable">
						            <xsl:attribute name="data-wc-selectable">
							              <xsl:value-of select="@selectable"/>
						            </xsl:attribute>
					          </xsl:if>
				        </xsl:otherwise>
			      </xsl:choose>
			      <xsl:apply-templates select="ui:decoratedLabel">
				        <xsl:with-param name="output">
					          <xsl:choose>
						            <xsl:when test="$isButton=1">
							              <xsl:text>span</xsl:text>
						            </xsl:when>
						            <xsl:otherwise>
							              <xsl:text>div</xsl:text>
						            </xsl:otherwise>
					          </xsl:choose>
				        </xsl:with-param>
			      </xsl:apply-templates>
		    </xsl:element>
	  </xsl:template>
   <xsl:template match="ui:multiSelectPair">
		    <xsl:variable name="id">
			      <xsl:value-of select="@id"/>
		    </xsl:variable>
		    <xsl:variable name="readOnly">
			      <xsl:if test="@readOnly">
				        <xsl:number value="1"/>
			      </xsl:if>
		    </xsl:variable>
		    <xsl:variable name="size">
			      <xsl:choose>
				        <xsl:when test="@size">
					          <xsl:value-of select="@size"/>
				        </xsl:when>
				        <xsl:otherwise>7</xsl:otherwise>
			      </xsl:choose>
		    </xsl:variable>
		    <xsl:variable name="isError" select="key('errorKey',$id)"/>
		    <xsl:variable name="myLabel" select="key('labelKey',$id)[1]"/>
		    <xsl:variable name="element">
			      <xsl:choose>
				        <xsl:when test="$readOnly=1">div</xsl:when>
				        <xsl:otherwise>fieldset</xsl:otherwise>
			      </xsl:choose>
		    </xsl:variable>
		    <xsl:element name="{$element}">
			      <xsl:call-template name="commonWrapperAttributes">
				        <xsl:with-param name="isError" select="$isError"/>
				        <xsl:with-param name="isControl">
					          <xsl:choose>
						            <xsl:when test="$readOnly=1">
							              <xsl:number value="0"/>
						            </xsl:when>
						            <xsl:otherwise>
							              <xsl:number value="1"/>
						            </xsl:otherwise>
					          </xsl:choose>
				        </xsl:with-param>
				        <xsl:with-param name="myLabel" select="$myLabel"/>
			      </xsl:call-template>
			      <xsl:choose>
				        <xsl:when test="$readOnly!=1">
					          <xsl:if test="@min">
						            <xsl:attribute name="data-wc-min">
							              <xsl:value-of select="@min"/>
						            </xsl:attribute>
					          </xsl:if>
					          <xsl:if test="@max">
						            <xsl:attribute name="data-wc-max">
							              <xsl:value-of select="@max"/>
						            </xsl:attribute>
					          </xsl:if>
					          <xsl:call-template name="makeLegend">
						            <xsl:with-param name="myLabel" select="$myLabel"/>
					          </xsl:call-template>

					
					          <xsl:variable name="availId" select="concat($id, '-a')"/>
					          <span>
						            <label for="{$availId}">
							              <xsl:value-of select="@fromListName"/>
						            </label>
						
						            <select id="{$availId}"
                          multiple="multiple"
                          class="wc_msp_av"
                          size="{$size}">
							              <xsl:call-template name="disabledElement">
								                <xsl:with-param name="isControl" select="1"/>
							              </xsl:call-template>
							              <xsl:apply-templates select="ui:option[not(@selected)]|ui:optgroup[ui:option[not(@selected)]]"
                                          mode="multiselectPair">
								                <xsl:with-param name="applyWhich" select="'unselected'"/>
							              </xsl:apply-templates>
						            </select>
					          </span>
					
					          <span class="wc_msp_btncol">
						            <xsl:call-template name="multiSelectPairButton">
							              <xsl:with-param name="value" select="'add'"/>
							              <xsl:with-param name="buttonText" select="$msp0"/>
						            </xsl:call-template>
						            <xsl:call-template name="multiSelectPairButton">
							              <xsl:with-param name="value" select="'aall'"/>
							              <xsl:with-param name="buttonText" select="$msp1"/>
						            </xsl:call-template>
						            <xsl:call-template name="multiSelectPairButton">
							              <xsl:with-param name="value" select="'rem'"/>
							              <xsl:with-param name="buttonText" select="$msp2"/>
						            </xsl:call-template>
						            <xsl:call-template name="multiSelectPairButton">
							              <xsl:with-param name="value" select="'rall'"/>
							              <xsl:with-param name="buttonText" select="$msp3"/>
						            </xsl:call-template>
					          </span>
					
					          <xsl:variable name="toId">
						            <xsl:value-of select="concat($id, '-s')"/>
					          </xsl:variable>
					          <span>
						            <label for="{$toId}">
							              <xsl:value-of select="@toListName"/>
						            </label>
						
						            <select id="{$toId}"
                          multiple="multiple"
                          class="wc_msp_chos"
                          size="{$size}">
							              <xsl:call-template name="disabledElement">
								                <xsl:with-param name="isControl" select="1"/>
							              </xsl:call-template>
							              <xsl:apply-templates select="ui:option[@selected]|ui:optgroup[ui:option[@selected]]"
                                          mode="multiselectPair">
								                <xsl:with-param name="applyWhich" select="'selected'"/>
							              </xsl:apply-templates>
						            </select>
					          </span>
					          <xsl:if test="@shuffle">
						            <xsl:call-template name="listSortControls">
							              <xsl:with-param name="id" select="$toId"/>
						            </xsl:call-template>
					          </xsl:if>
					          <select multiple="multiple" class="wc_msp_order" hidden="hidden">
						            <xsl:call-template name="disabledElement">
							              <xsl:with-param name="isControl" select="1"/>
						            </xsl:call-template>
						            <xsl:apply-templates mode="multiselectPair"/>
					          </select>
					          <xsl:call-template name="hField"/>
				        </xsl:when>
				        <xsl:when test="count(.//ui:option[@selected]) &gt; 0">
					          <ul class="wc_list_nb">
						            <xsl:apply-templates select="ui:option[@selected]|ui:optgroup[ui:option[@selected]]"
                                       mode="multiselectPair">
							              <xsl:with-param name="readOnly" select="1"/>
							              <xsl:with-param name="applyWhich" select="'selected'"/>
						            </xsl:apply-templates>
					          </ul>
				        </xsl:when>
			      </xsl:choose>
			      <xsl:if test="$readOnly!=1">
				        <xsl:call-template name="inlineError">
					          <xsl:with-param name="errors" select="$isError"/>
				        </xsl:call-template>
			      </xsl:if>
		    </xsl:element>
	  </xsl:template>
   <xsl:template match="ui:value">
		    <xsl:param name="myLabel"/>
		    <li>
			      <xsl:call-template name="multiTextFieldInput"/>
			      <xsl:call-template name="multiFieldIcon">
				        <xsl:with-param name="myLabel" select="$myLabel"/>
			      </xsl:call-template>
		    </li>
	  </xsl:template>
   <xsl:template match="ui:nl">
		    <xsl:text>&#xD;
</xsl:text>
	  </xsl:template>
   <xsl:template match="ui:content[parent::ui:panel]">
		    <xsl:element name="div">
			      <xsl:attribute name="class">
				        <xsl:text>content</xsl:text>
			      </xsl:attribute>
			      <xsl:apply-templates/>
		    </xsl:element>
	  </xsl:template>
   <xsl:template match="ui:panel">
		    <xsl:variable name="id" select="@id"/>
		
		    <xsl:variable name="containerElement">
			      <xsl:call-template name="WPanelContainerElement"/>
		    </xsl:variable>
		    <xsl:element name="{$containerElement}">
			      <xsl:attribute name="id">
				        <xsl:value-of select="$id"/>
			      </xsl:attribute>
			      <xsl:attribute name="class">
				        <xsl:call-template name="WPanelClass"/>
			      </xsl:attribute>
			      <xsl:if test="@buttonId">
				        <xsl:attribute name="data-wc-submit">
					          <xsl:value-of select="@buttonId"/>
				        </xsl:attribute>
			      </xsl:if>
			      <xsl:if test="@type='header'">
				        <xsl:attribute name="role">
					          <xsl:text>banner</xsl:text>
				        </xsl:attribute>
			      </xsl:if>
			      <xsl:if test="@mode or key('targetKey',$id) or parent::ui:ajaxTarget[@action='replace']">
				        <xsl:call-template name="setARIALive"/>
				        <xsl:if test="@mode">
					          <xsl:attribute name="data-wc-ajaxalias">
						            <xsl:value-of select="$id"/>
					          </xsl:attribute>
				        </xsl:if>
			      </xsl:if>
			      <xsl:call-template name="hideElementIfHiddenSet"/>
			      <xsl:apply-templates select="ui:margin"/>
			      <xsl:if test="*[not(self::ui:margin)]/node() or not(@mode='eager')">
				
				        <xsl:call-template name="WPanelVisiblePanelTitle"/>
				
				        <xsl:call-template name="WPanelContentPrep"/>
			      </xsl:if>
		    </xsl:element>
	  </xsl:template>
   <xsl:template match="ui:popup"/>
   <xsl:template match="ui:progressBar">
		    <xsl:variable name="percentage" select="round(100 * (@value div @max))"/>
		    <xsl:variable name="barText">
			      <xsl:choose>
				        <xsl:when test="@output='percent'">
					          <xsl:value-of select="concat($percentage,'%')"/>
				        </xsl:when>
				        <xsl:otherwise>
					          <xsl:value-of select="concat(@value,'/',@max)"/>
				        </xsl:otherwise>
			      </xsl:choose>
		    </xsl:variable>
		    <xsl:element name="PROGRESS">
			      <xsl:attribute name="id">
				        <xsl:value-of select="@id"/>
			      </xsl:attribute>
			      <xsl:attribute name="value">
				        <xsl:value-of select="@value"/>
			      </xsl:attribute>
			      <xsl:attribute name="max">
				        <xsl:value-of select="@max"/>
			      </xsl:attribute>
			      <xsl:if test="@toolTip">
				        <xsl:attribute name="title">
					          <xsl:value-of select="@toolTip"/>
				        </xsl:attribute>
			      </xsl:if>
			      <xsl:attribute name="class">
				        <xsl:call-template name="commonClassHelper"/>
				        <xsl:if test="@type">
					          <xsl:value-of select="concat(' ', @type)"/>
				        </xsl:if>
			      </xsl:attribute>
			      <xsl:call-template name="ajaxTarget"/>
			      <xsl:call-template name="hideElementIfHiddenSet"/>
			      <xsl:element name="span">
				        <xsl:attribute name="role">
					          <xsl:text>progressbar</xsl:text>
				        </xsl:attribute>
				        <xsl:attribute name="aria-valuemax">
					          <xsl:value-of select="@max"/>
				        </xsl:attribute>
				        <xsl:attribute name="aria-valuenow">
					          <xsl:value-of select="@value"/>
				        </xsl:attribute>
				        <xsl:attribute name="aria-valuetext">
					          <xsl:value-of select="$barText"/>
				        </xsl:attribute>
				        <xsl:element name="span">
					          <xsl:attribute name="role">
						            <xsl:text>presentation</xsl:text>
					          </xsl:attribute>
					          <xsl:attribute name="style">
						            <xsl:value-of select="concat('width: ',$percentage,'%;')"/>
					          </xsl:attribute>
					          <xsl:text> </xsl:text>
				        </xsl:element>
				        <xsl:element name="span">
					          <xsl:attribute name="role">
						            <xsl:text>presentation</xsl:text>
					          </xsl:attribute>
					          <xsl:value-of select="$barText"/>
				        </xsl:element>
			      </xsl:element>
		    </xsl:element>
	  </xsl:template>
   <xsl:template match="ui:redirect"/>
   <xsl:template match="ui:root">
		    <html lang="{$lang}">
			      <head>
				        <xsl:call-template name="addHeadMetaBeforeTitle"/>
				        <title>
					          <xsl:value-of select="@title"/>
				        </title>

				        <link type="text/css" id="wc_css_screen" rel="stylesheet">
					          <xsl:attribute name="href">
						            <xsl:value-of select="$resourceRoot"/>
						            <xsl:text>style/screen</xsl:text>
						            <xsl:if test="$isDebug=1">
							              <xsl:text>_debug</xsl:text>
						            </xsl:if>
						            <xsl:text>.css?</xsl:text>
						            <xsl:value-of select="$cacheBuster"/>
					          </xsl:attribute>
				        </link>
				
				        <xsl:apply-templates select="ui:application/ui:css" mode="inHead"/>
				        <xsl:apply-templates select=".//html:link[@rel='stylesheet']" mode="inHead"/>

				
				        <xsl:call-template name="makeRequireConfig"/>

				
				        <xsl:call-template name="makeIE8CompatScripts"/>

				        <xsl:call-template name="externalScript">
					          <xsl:with-param name="scriptName" select="'lib/require'"/>
				        </xsl:call-template>

				
				        <xsl:variable name="scriptId" select="generate-id()"/>
				
				        <xsl:variable name="styleLoaderId" select="concat($scriptId,'-styleloader')"/>
				        <script type="text/javascript" id="{$styleLoaderId}">
					          <xsl:text>require(["wc/compat/compat!"], function() {</xsl:text>
					          <xsl:text>require(["wc/loader/style", "wc/dom/removeElement"</xsl:text>
					          <xsl:if test="$isDebug=1">
						            <xsl:text>,"wc/debug/consoleColor", "wc/debug/a11y", "wc/debug/indicator"</xsl:text>
					          </xsl:if>
					          <xsl:text>], function(s, r){try{s.load();}finally{r("</xsl:text>
					          <xsl:value-of select="$styleLoaderId"/>
					          <xsl:text>", 250);}});</xsl:text>
					          <xsl:text>});</xsl:text>
				        </script>

				        <xsl:call-template name="registrationScripts"/>
				
				        <xsl:apply-templates select="ui:application/ui:js" mode="inHead"/>
				        <xsl:apply-templates select=".//html:base|.//html:link[not(@rel='icon' or @rel='shortcut icon' or @rel='stylesheet')]|.//html:meta"
                                 mode="inHead"/>
			      </head>
			      <xsl:variable name="bodyClass">
				        <xsl:call-template name="wcBodyClass"/>
			      </xsl:variable>
			      <body>
				        <xsl:if test="$bodyClass!=''">
					          <xsl:attribute name="class">
						            <xsl:value-of select="normalize-space($bodyClass)"/>
					          </xsl:attribute>
				        </xsl:if>
				        <xsl:if test="$isDebug=1">
					          <xsl:comment>
						XSLT processor: <xsl:value-of select="system-property('xsl:vendor')"/>
						base-uri available? <xsl:value-of select="function-available('base-uri')"/>
					          </xsl:comment>
				        </xsl:if>
				
				        <div id="wc_shim" class="wc_shim_loading">
					          <xsl:text> </xsl:text>
					          <noscript>
						            <p>
							              <xsl:value-of select="$rt0"/>
						            </p>
					          </noscript>
				        </div>
				        <div id="wc_ui_loading">
					          <div tabindex="0">
						            <xsl:value-of select="$load1"/>
					          </div>
				        </div>
				        <xsl:apply-templates/>
			      </body>
		    </html>
	  </xsl:template>
   <xsl:template match="ui:row">
		    <div id="{@id}">
			      <xsl:call-template name="makeCommonClass"/>
			      <xsl:call-template name="ajaxTarget"/>
			      <xsl:apply-templates select="ui:margin"/>
			      <xsl:apply-templates select="ui:column">
				        <xsl:with-param name="hgap">
					          <xsl:call-template name="getHVGap">
						            <xsl:with-param name="divisor" select="2"/>
					          </xsl:call-template>
				        </xsl:with-param>
			      </xsl:apply-templates>
		    </div>
	  </xsl:template>
   <xsl:template match="ui:section">
		    <xsl:variable name="mode" select="@mode"/>
		    <xsl:element name="SECTION">
			      <xsl:attribute name="id">
				        <xsl:value-of select="@id"/>
			      </xsl:attribute>
			      <xsl:attribute name="class">
				        <xsl:call-template name="WSectionClass"/>
			      </xsl:attribute>
			      <xsl:apply-templates select="ui:margin"/>
			      <xsl:call-template name="hideElementIfHiddenSet"/>
			      <xsl:if test="*[not(self::ui:margin)] or not($mode='eager')">
				        <xsl:apply-templates select="ui:decoratedLabel" mode="section"/>
				        <xsl:element name="div">
					          <xsl:attribute name="class">
						            <xsl:text>content</xsl:text>
					          </xsl:attribute>
					          <xsl:apply-templates select="ui:panel"/>
				        </xsl:element>
			      </xsl:if>
		    </xsl:element>
	  </xsl:template>
   <xsl:template match="ui:selectToggle">
		
		    <xsl:call-template name="selectToggle">
			      <xsl:with-param name="for" select="@target"/>
			      <xsl:with-param name="name" select="@id"/>
			      <xsl:with-param name="roundTrip" select="@roundTrip"/>
			      <xsl:with-param name="selected" select="@selected"/>
			      <xsl:with-param name="type">
				        <xsl:choose>
					          <xsl:when test="@renderAs='control'">
						            <xsl:text>control</xsl:text>
					          </xsl:when>
					          <xsl:otherwise>
						            <xsl:text>text</xsl:text>
					          </xsl:otherwise>
				        </xsl:choose>
			      </xsl:with-param>
		    </xsl:call-template>
		    <xsl:if test="@renderAs='control'">
			      <xsl:variable name="myLabel" select="key('labelKey',@id)[1]"/>
			      <xsl:if test="$myLabel">
				        <xsl:apply-templates select="$myLabel" mode="checkable">
					          <xsl:with-param name="labelableElement" select="."/>
				        </xsl:apply-templates>
			      </xsl:if>
		    </xsl:if>
	  </xsl:template>
   <xsl:template match="ui:separator">
		    <xsl:call-template name="separator"/>
	  </xsl:template>
   <xsl:template match="ui:session[count(.|((//ui:session)[1])) = 1]">
		    <div id="wc_session_container"
           class="wc_session"
           role="alert"
           hidden="hiddden">
			      <xsl:call-template name="setARIALive"/>
		    </div>
	  </xsl:template>
   <xsl:template match="ui:session">
		    <xsl:comment>Ignoring repeats of ui:session.</xsl:comment>
	  </xsl:template>
   <xsl:template match="ui:shuffler">
		    <xsl:variable name="id" select="@id"/>
		    <xsl:variable name="myLabel" select="key('labelKey',$id)[1]"/>
		    <xsl:choose>
			      <xsl:when test="@readOnly">
				        <xsl:element name="ul">
					          <xsl:attribute name="id">
						            <xsl:value-of select="$id"/>
					          </xsl:attribute>
					          <xsl:call-template name="title"/>
					          <xsl:attribute name="class">
						            <xsl:call-template name="commonClassHelper"/>
						            <xsl:text> wc_list_nb</xsl:text>
					          </xsl:attribute>
					          <xsl:if test="$myLabel">
						            <xsl:attribute name="aria-labelledby">
							              <xsl:value-of select="$myLabel/@id"/>
						            </xsl:attribute>
					          </xsl:if>
					          <xsl:call-template name="hideElementIfHiddenSet"/>
					          <xsl:call-template name="ajaxTarget">
						            <xsl:with-param name="live" select="'off'"/>
					          </xsl:call-template>
					          <xsl:apply-templates select="ui:option|ui:optgroup" mode="readOnly">
						            <xsl:with-param name="showOptions" select="'all'"/>
						            <xsl:with-param name="single" select="0"/>
					          </xsl:apply-templates>
				        </xsl:element>
			      </xsl:when>
			      <xsl:otherwise>
				        <fieldset>
					          <xsl:call-template name="commonWrapperAttributes">
						            <xsl:with-param name="isControl" select="1"/>
						            <xsl:with-param name="myLabel" select="$myLabel"/>
					          </xsl:call-template>
					          <xsl:if test="$myLabel">
						            <xsl:call-template name="title"/>
					          </xsl:if>
					          <xsl:call-template name="makeLegend">
						            <xsl:with-param name="myLabel" select="$myLabel"/>
					          </xsl:call-template>
					          <xsl:variable name="listId" select="concat($id,'-list')"/>
					          <xsl:element name="select">
						            <xsl:attribute name="id">
							              <xsl:value-of select="$listId"/>
						            </xsl:attribute>
						            <xsl:attribute name="class">
							              <xsl:text>shuffler</xsl:text>
						            </xsl:attribute>
						            <xsl:call-template name="disabledElement">
							              <xsl:with-param name="isControl" select="1"/>
						            </xsl:call-template>
						            <xsl:attribute name="multiple">
							              <xsl:text>multiple</xsl:text>
						            </xsl:attribute>
						            <xsl:if test="@rows &gt; 2">
							              <xsl:attribute name="size">
								                <xsl:value-of select="@rows"/>
							              </xsl:attribute>
						            </xsl:if>
						            <xsl:apply-templates mode="selectableList"/>
					          </xsl:element>
					          <xsl:call-template name="listSortControls">
						            <xsl:with-param name="id" select="$listId"/>
					          </xsl:call-template>
				        </fieldset>
			      </xsl:otherwise>
		    </xsl:choose>
	  </xsl:template>
   <xsl:template match="ui:skipLinks">
		    <xsl:variable name="containerList"
                    select="ancestor::ui:application[1]//ui:panel[@accessKey and @title]"/>
		    <xsl:if test="$containerList">
			      <xsl:element name="NAV">
				        <xsl:call-template name="makeCommonClass"/>
				        <xsl:apply-templates select="$containerList" mode="skipLinks"/>
			      </xsl:element>
		    </xsl:if>
	  </xsl:template>
   <xsl:template match="ui:src">
		    <xsl:element name="SOURCE">
			      <xsl:attribute name="src">
				        <xsl:value-of select="@uri"/>
			      </xsl:attribute>
			      <xsl:if test="@type">
				        <xsl:attribute name="type">
					          <xsl:value-of select="@type"/>
				        </xsl:attribute>
			      </xsl:if>
		    </xsl:element>
	  </xsl:template>
   <xsl:template match="ui:submenu">
		    <xsl:variable name="myAncestorMenu" select="ancestor::ui:menu[1]"/>
		    <xsl:variable name="myAncestorSubmenu"
                    select="ancestor::ui:submenu[ancestor::ui:menu[1]=$myAncestorMenu or not(ancestor::ui:menu)][1]"/>
		    <xsl:variable name="id" select="@id"/>
		
		    <xsl:variable name="noContextMenu">
			      <xsl:if test="not($myAncestorMenu)">
				        <xsl:number value="1"/>
			      </xsl:if>
		    </xsl:variable>
		    <xsl:variable name="noContextSubMenu">
			      <xsl:if test="$noContextMenu=1 and not($myAncestorSubmenu)">
				        <xsl:number value="1"/>
			      </xsl:if>
		    </xsl:variable>
		    <xsl:variable name="type" select="$myAncestorMenu/@type"/>
		    <xsl:variable name="stickyOpen">
			      <xsl:choose>
				        <xsl:when test="$myAncestorMenu">
					          <xsl:call-template name="hasStickyOpen">
						            <xsl:with-param name="type" select="$type"/>
					          </xsl:call-template>
				        </xsl:when>
				        <xsl:otherwise>
					          <xsl:number value="1"/>
					
				        </xsl:otherwise>
			      </xsl:choose>
		    </xsl:variable>
		    <xsl:variable name="open">
			      <xsl:choose>
				        <xsl:when test="@open and $stickyOpen=1">
					          <xsl:number value="1"/>
				        </xsl:when>
				        <xsl:otherwise>
					          <xsl:number value="0"/>
				        </xsl:otherwise>
			      </xsl:choose>
		    </xsl:variable>

		    <xsl:element name="div">
			      <xsl:attribute name="id">
				        <xsl:value-of select="$id"/>
			      </xsl:attribute>
			
			      <xsl:call-template name="makeCommonClass"/>
			      <xsl:if test="$type='tree'">
				        <xsl:attribute name="aria-expanded">
					          <xsl:choose>
						            <xsl:when test="$open=1">
							              <xsl:copy-of select="$t"/>
						            </xsl:when>
						            <xsl:otherwise>
							              <xsl:text>false</xsl:text>
						            </xsl:otherwise>
					          </xsl:choose>
				        </xsl:attribute>
			      </xsl:if>
			      <xsl:if test="@selectMode and not($type='tree')">
				        <xsl:attribute name="data-wc-selectmode">
					          <xsl:value-of select="@selectMode"/>
				        </xsl:attribute>
			      </xsl:if>
			      <xsl:call-template name="hideElementIfHiddenSet"/>
			      <xsl:attribute name="role">
				        <xsl:choose>
					          <xsl:when test="$type='tree'">
						            <xsl:text>treeitem</xsl:text>
					          </xsl:when>
					          <xsl:when test="$myAncestorMenu">
						            <xsl:text>menuitem</xsl:text>
					          </xsl:when>
					          <xsl:otherwise>
						            <xsl:text>dummy</xsl:text>
					          </xsl:otherwise>
				        </xsl:choose>
			      </xsl:attribute>
			
			      <xsl:variable name="this" select="."/>
			      <xsl:variable name="disabledAncestor"
                       select="ancestor-or-self::*[@disabled and          (self::ui:submenu[.=$this] or          ($myAncestorMenu and (self::ui:menu[.=$myAncestorMenu] or self::ui:submenu[ancestor::ui:menu[1]=$myAncestorMenu])) or          ($noContextMenu=1 and self::ui:submenu))]"/>
			      <xsl:if test="$disabledAncestor">
				        <xsl:call-template name="disabledElement">
					          <xsl:with-param name="field" select="$disabledAncestor"/>
				        </xsl:call-template>
			      </xsl:if>
			
			      <xsl:element name="button">
				        <xsl:attribute name="type">
					          <xsl:text>button</xsl:text>
				        </xsl:attribute>
				        <xsl:attribute name="id">
					          <xsl:value-of select="$id"/>
					          <xsl:text>-o</xsl:text>
				        </xsl:attribute>
				        <xsl:if test="not($type='tree')">
					          <xsl:attribute name="aria-haspopup">
						            <xsl:copy-of select="$t"/>
					          </xsl:attribute>
				        </xsl:if>
				        <xsl:attribute name="name">
					          <xsl:value-of select="$id"/>
				        </xsl:attribute>
				        <xsl:attribute name="class">
					          <xsl:text>wc_btn_nada</xsl:text>
				        </xsl:attribute>
				        <xsl:if test="@toolTip">
					          <xsl:attribute name="title">
						            <xsl:value-of select="normalize-space(@toolTip)"/>
					          </xsl:attribute>
				        </xsl:if>
				
				        <xsl:attribute name="aria-controls">
					          <xsl:value-of select="ui:content/@id"/>
				        </xsl:attribute>
				
				        <xsl:if test="$disabledAncestor">
					          <xsl:call-template name="disabledElement">
						            <xsl:with-param name="field" select="$disabledAncestor"/>
						            <xsl:with-param name="isControl" select="1"/>
					          </xsl:call-template>
				        </xsl:if>
				        <xsl:choose>
					          <xsl:when test="$myAncestorMenu">
						            <xsl:variable name="tabindex">
							              <xsl:call-template name="menuTabIndexHelper">
								                <xsl:with-param name="menu" select="$myAncestorMenu"/>
							              </xsl:call-template>
						            </xsl:variable>
						            <xsl:if test="$tabindex!=''">
							              <xsl:attribute name="tabindex">
								                <xsl:value-of select="$tabindex"/>
							              </xsl:attribute>
						            </xsl:if>
						
						            <xsl:if test="@accessKey and not($myAncestorSubmenu)">
							              <xsl:call-template name="accessKey"/>
						            </xsl:if>
					          </xsl:when>
					          <xsl:otherwise>
						            <xsl:attribute name="tabindex">
							              <xsl:text>-1</xsl:text>
						            </xsl:attribute>
					          </xsl:otherwise>
				        </xsl:choose>
				        <xsl:apply-templates select="ui:decoratedLabel"/>
			      </xsl:element>
			      <xsl:apply-templates select="ui:content" mode="submenu">
				        <xsl:with-param name="open" select="$open"/>
				        <xsl:with-param name="type" select="$type"/>
			      </xsl:apply-templates>
		    </xsl:element>
	  </xsl:template>
   <xsl:template match="ui:subordinate|ui:componentGroup|ui:target|ui:onTrue|ui:onFalse|ui:and|ui:or|ui:not"/>
   <xsl:template match="ui:component">
		    <xsl:text>"</xsl:text>
		    <xsl:value-of select="@id"/>
		    <xsl:text>"</xsl:text>
		    <xsl:if test="position() != last()">
			      <xsl:text>,</xsl:text>
		    </xsl:if>
	  </xsl:template>
   <xsl:template match="ui:suggestions">
		    <ul id="{@id}" role="listbox" hidden="hidden">
			      <xsl:call-template name="makeCommonClass"/>
			      <xsl:if test="@min">
				        <xsl:attribute name="data-wc-min">
					          <xsl:value-of select="@min"/>
				        </xsl:attribute>
			      </xsl:if>
			      <xsl:if test="@data">
				        <xsl:attribute name="data-wc-list">
					          <xsl:value-of select="@data"/>
				        </xsl:attribute>
			      </xsl:if>
			      <xsl:if test="@ajax">
				        <xsl:attribute name="data-wc-chat">
					          <xsl:value-of select="1"/>
				        </xsl:attribute>
			      </xsl:if>
			      <xsl:apply-templates/>
		    </ul>
	  </xsl:template>
   <xsl:template match="ui:suggestion">
		    <xsl:call-template name="fauxOption"/>
	  </xsl:template>
   <xsl:template match="ui:tab">
		    <xsl:param name="tabset" select="ancestor::ui:tabset[1]"/>
		    <xsl:param name="firstOpenTab"/>

		    <xsl:variable name="id" select="@id"/>
		    <xsl:variable name="type" select="$tabset/@type"/>
		    <xsl:variable name="isDisabled">
			      <xsl:if test="@disabled or $tabset/@disabled">
				        <xsl:number value="1"/>
			      </xsl:if>
		    </xsl:variable>
		    <xsl:variable name="isOpen">
			
			      <xsl:if test="$firstOpenTab=. or ($type='accordion' and @open)">
				        <xsl:number value="1"/>
			      </xsl:if>
		    </xsl:variable>
		    <xsl:variable name="expandSelectAttrib">
			      <xsl:choose>
				        <xsl:when test="$type='accordion'">
					          <xsl:text>aria-expanded</xsl:text>
				        </xsl:when>
				        <xsl:otherwise>
					          <xsl:text>aria-selected</xsl:text>
				        </xsl:otherwise>
			      </xsl:choose>
		    </xsl:variable>
		    <xsl:variable name="tabElement">
			      <xsl:call-template name="tabElement"/>
		    </xsl:variable>
		    <xsl:element name="{$tabElement}">
			      <xsl:attribute name="id">
				        <xsl:value-of select="$id"/>
			      </xsl:attribute>
			      <xsl:attribute name="role">
				        <xsl:text>tab</xsl:text>
			      </xsl:attribute>
			      <xsl:attribute name="class">
				        <xsl:call-template name="commonClassHelper"/>
				        <xsl:text> wc_btn_nada</xsl:text>
			      </xsl:attribute>
			      <xsl:call-template name="title"/>
			      <xsl:attribute name="{$expandSelectAttrib}">
				        <xsl:choose>
					          <xsl:when test="$isOpen=1">
						            <xsl:copy-of select="$t"/>
					          </xsl:when>
					          <xsl:otherwise>
						            <xsl:text>false</xsl:text>
					          </xsl:otherwise>
				        </xsl:choose>
			      </xsl:attribute>
			      <xsl:attribute name="aria-controls">
				        <xsl:value-of select="ui:tabContent/@id"/>
			      </xsl:attribute>
			      <xsl:if test="$tabElement='button'">
				        <xsl:attribute name="type">
					          <xsl:text>button</xsl:text>
				        </xsl:attribute>
			      </xsl:if>
			      <xsl:if test="$isDisabled=1">
				
				        <xsl:choose>
					          <xsl:when test="$tabElement='button'">
						            <xsl:attribute name="disabled">
							              <xsl:text>disabled</xsl:text>
						            </xsl:attribute>
					          </xsl:when>
					          <xsl:otherwise>
						            <xsl:attribute name="aria-disabled">
							              <xsl:value-of select="$t"/>
						            </xsl:attribute>
					          </xsl:otherwise>
				        </xsl:choose>
			      </xsl:if>
			      <xsl:variable name="tabIndex">
				        <xsl:choose>
					          <xsl:when test="$isDisabled=1">
						            <xsl:text>-1</xsl:text>
					          </xsl:when>
					          <xsl:when test="$firstOpenTab=. or ($isOpen=1 and not($tabset))">
						            <xsl:text>0</xsl:text>
					          </xsl:when>
					          <xsl:otherwise>
						            <xsl:text>-1</xsl:text>
					          </xsl:otherwise>
				        </xsl:choose>
			      </xsl:variable>
			      <xsl:if test="$tabIndex!=''">
				        <xsl:attribute name="tabindex">
					          <xsl:value-of select="$tabIndex"/>
				        </xsl:attribute>
			      </xsl:if>
			
			      <xsl:if test="not($firstOpenTab=.)">
				        <xsl:call-template name="hideTab"/>
			      </xsl:if>
			      <xsl:call-template name="accessKey"/>
			      <xsl:variable name="labelElement">
				        <xsl:choose>
					          <xsl:when test="$tabElement='div'">
						            <xsl:text>div</xsl:text>
					          </xsl:when>
					          <xsl:otherwise>
						            <xsl:text>span</xsl:text>
					          </xsl:otherwise>
				        </xsl:choose>
			      </xsl:variable>
			      <xsl:apply-templates select="ui:decoratedLabel">
				        <xsl:with-param name="output" select="$labelElement"/>
			      </xsl:apply-templates>
		    </xsl:element>
		    <xsl:if test="$type='accordion'">
			      <xsl:apply-templates select="ui:tabContent">
				        <xsl:with-param name="open" select="$isOpen"/>
			      </xsl:apply-templates>
		    </xsl:if>
	  </xsl:template>
   <xsl:template match="ui:tabContent">
		    <xsl:param name="open"/>
		    <xsl:variable name="id">
			      <xsl:value-of select="@id"/>
		    </xsl:variable>
		    <xsl:variable name="mode" select="../@mode"/>
		    <xsl:element name="div">
			      <xsl:attribute name="id">
				        <xsl:value-of select="$id"/>
			      </xsl:attribute>
			      <xsl:attribute name="role">
				        <xsl:text>tabpanel</xsl:text>
			      </xsl:attribute>
			      <xsl:attribute name="class">
				        <xsl:text>tabContent</xsl:text>
				        <xsl:if test="$mode='server'">
					          <xsl:text> wc_lame</xsl:text>
				        </xsl:if>
				        <xsl:choose>
					          <xsl:when test="$open=1">
						            <xsl:if test="$mode='dynamic'">
							              <xsl:text> wc_magic wc_dynamic</xsl:text>
						            </xsl:if>
					          </xsl:when>
					          <xsl:when test="($mode='lazy') or ($mode='eager') or ($mode='dynamic')">
						            <xsl:text> wc_magic</xsl:text>
						            <xsl:if test="$mode='dynamic'">
							              <xsl:text> wc_dynamic</xsl:text>
						            </xsl:if>
					          </xsl:when>
				        </xsl:choose>
			      </xsl:attribute>
			      <xsl:if test="$open!=1">
				        <xsl:call-template name="hiddenElement"/>
			      </xsl:if>
			      <xsl:if test="($mode='lazy') or ($mode='eager') or ($mode='dynamic')">
				        <xsl:attribute name="data-wc-ajaxalias">
					          <xsl:value-of select="../@id"/>
				        </xsl:attribute>
			      </xsl:if>
			      <xsl:call-template name="setARIALive"/>
			      <xsl:variable name="contentHeight" select="ancestor::ui:tabset[1]/@contentHeight"/>
			      <xsl:if test="$contentHeight and $contentHeight!=''">
				        <xsl:attribute name="style">
					          <xsl:value-of select="concat('height:',$contentHeight,';overflow-y:auto;')"/>
				        </xsl:attribute>
			      </xsl:if>
			      <xsl:if test="../@disabled or ancestor::ui:tabset[1]/@disabled">
				        <xsl:attribute name="aria-disabled">
					          <xsl:copy-of select="$t"/>
				        </xsl:attribute>
			      </xsl:if>
			      <xsl:apply-templates/>
		    </xsl:element>
	  </xsl:template>
   <xsl:template match="ui:tabGroup"/>
   <xsl:template match="ui:action/ui:condition"/>
   <xsl:template match="ui:action">
		    <xsl:apply-templates select="ui:button"/>
	  </xsl:template>
   <xsl:template match="ui:actions">
		    <xsl:apply-templates select="ui:action"/>
	  </xsl:template>
   <xsl:template match="ui:noData">
		    <div class="noData">
			      <xsl:value-of select="."/>
			      <xsl:if test="not(node())">
				        <xsl:value-of select="$tble1"/>
			      </xsl:if>
		    </div>
	  </xsl:template>
   <xsl:template match="ui:pagination">
		    <xsl:param name="idSuffix"/>
		    <xsl:variable name="tableId" select="../@id"/>
		    <xsl:variable name="name">
			      <xsl:value-of select="concat($tableId, '.page')"/>
		    </xsl:variable>
		    <xsl:variable name="id">
			      <xsl:value-of select="concat($name, $idSuffix)"/>
		    </xsl:variable>
		    <xsl:variable name="pages">
			      <xsl:choose>
				        <xsl:when test="not(@rowsPerPage)">
					          <xsl:number value="1"/>
				        </xsl:when>
				        <xsl:otherwise>
					          <xsl:value-of select="ceiling(@rows div @rowsPerPage)"/>
				        </xsl:otherwise>
			      </xsl:choose>
		    </xsl:variable>
		    <xsl:if test="@rows &gt; 0">
			      <xsl:call-template name="paginationDescription"/>
			      <label for="{$id}">
				        <xsl:value-of select="$wdtp4"/>
				        <select id="{$id}" class="wc_table_pag_select">
					
					          <xsl:if test="@mode='dynamic'">
						            <xsl:call-template name="tableAjaxController">
							              <xsl:with-param name="tableId" select="$tableId"/>
						            </xsl:call-template>
					          </xsl:if>
					          <xsl:choose>
						            <xsl:when test="$pages=1">
							              <xsl:attribute name="disabled">
								                <xsl:text>disabled</xsl:text>
							              </xsl:attribute>
						            </xsl:when>
						            <xsl:otherwise>
							              <xsl:call-template name="disabledElement">
								                <xsl:with-param name="field" select="parent::ui:table"/>
								                <xsl:with-param name="isControl" select="1"/>
							              </xsl:call-template>
						            </xsl:otherwise>
					          </xsl:choose>
					          <xsl:call-template name="pagination.option.for.loop">
						            <xsl:with-param name="i" select="0"/>
						            <xsl:with-param name="count" select="$pages"/>
						            <xsl:with-param name="current" select="@currentPage"/>
					          </xsl:call-template>
				        </select>
			      </label>
			
			
			      <xsl:apply-templates select="ui:rowsSelect">
				        <xsl:with-param name="tableId" select="$tableId"/>
				        <xsl:with-param name="idSuffix" select="$idSuffix"/>
			      </xsl:apply-templates>
			
			
			      <xsl:variable name="buttonType">
				        <xsl:choose>
					          <xsl:when test="@mode='server'">
						            <xsl:text>submit</xsl:text>
					          </xsl:when>
					          <xsl:otherwise>
						            <xsl:text>button</xsl:text>
					          </xsl:otherwise>
				        </xsl:choose>
			      </xsl:variable>
			      <span class="wc_table_pag_btns">
				        <xsl:call-template name="paginationButton">
					          <xsl:with-param name="title" select="$wdtp0"/>
					          <xsl:with-param name="type" select="$buttonType"/>
					          <xsl:with-param name="idSuffix" select="concat($idSuffix,'1')"/>
					          <xsl:with-param name="disabled">
						            <xsl:if test="$pages=1 or @currentPage = 0">
							              <xsl:number value="1"/>
						            </xsl:if>
					          </xsl:with-param>
				        </xsl:call-template>
				        <xsl:call-template name="paginationButton">
					          <xsl:with-param name="title" select="$wdtp1"/>
					          <xsl:with-param name="type" select="$buttonType"/>
					          <xsl:with-param name="idSuffix" select="concat($idSuffix,'2')"/>
					          <xsl:with-param name="disabled">
						            <xsl:if test="$pages=1 or @currentPage = 0">
							              <xsl:number value="1"/>
						            </xsl:if>
					          </xsl:with-param>
				        </xsl:call-template>
				        <xsl:call-template name="paginationButton">
					          <xsl:with-param name="title" select="$wdtp2"/>
					          <xsl:with-param name="type" select="$buttonType"/>
					          <xsl:with-param name="idSuffix" select="concat($idSuffix,'3')"/>
					          <xsl:with-param name="disabled">
						            <xsl:if test="$pages=1 or @currentPage = $pages -1">
							              <xsl:number value="1"/>
						            </xsl:if>
					          </xsl:with-param>
				        </xsl:call-template>
				        <xsl:call-template name="paginationButton">
					          <xsl:with-param name="title" select="$wdtp3"/>
					          <xsl:with-param name="type" select="$buttonType"/>
					          <xsl:with-param name="idSuffix" select="concat($idSuffix,'4')"/>
					          <xsl:with-param name="disabled">
						            <xsl:if test="$pages=1 or @currentPage = $pages -1">
							              <xsl:number value="1"/>
						            </xsl:if>
					          </xsl:with-param>
				        </xsl:call-template>
			      </span>
		    </xsl:if>
	  </xsl:template>
   <xsl:template match="ui:rowExpansion">
		    <xsl:variable name="tableId" select="../@id"/>
		
		    <xsl:if test="..//ui:subTr[ancestor::ui:table[1]/@id=$tableId]">
			      <xsl:call-template name="collapsibleToggle">
				        <xsl:with-param name="id">
					          <xsl:value-of select="concat($tableId, '-textall')"/>
				        </xsl:with-param>
				        <xsl:with-param name="for">
					          <xsl:value-of select="$tableId"/>
				        </xsl:with-param>
			      </xsl:call-template>
		    </xsl:if>
	  </xsl:template>
   <xsl:template match="ui:rowSelection">
		    <xsl:variable name="tableId" select="../@id"/>
		    <xsl:variable name="numberOfRows"
                    select="count(..//ui:tr[not(@unselectable) and ancestor::ui:table[1]/@id = $tableId])"/>
		    <xsl:if test="$numberOfRows &gt; 0">
			      <xsl:variable name="numberSelectedRows"
                       select="count(..//ui:tr[@selected and ancestor::ui:table[1]/@id = $tableId])"/>
			      <xsl:variable name="selected">
				        <xsl:choose>
					          <xsl:when test="$numberSelectedRows = 0">
						            <xsl:text>none</xsl:text>
					          </xsl:when>
					          <xsl:when test="@toggle">
						
						            <xsl:variable name="numberUnselectedParentRows"
                                select="count(..//ui:tr[@selected and          ancestor::ui:table[1]/@id = $tableId and          .//ui:subTr[ancestor::ui:table[1]/@id = $tableId]/ui:tr[not(@unselectable or @selected)]])"/>
						            <xsl:choose>
							              <xsl:when test="$numberSelectedRows = $numberUnselectedParentRows">
								                <xsl:text>none</xsl:text>
							              </xsl:when>
							              <xsl:when test="$numberUnselectedParentRows = 0 and $numberSelectedRows = $numberOfRows">
								                <xsl:text>all</xsl:text>
							              </xsl:when>
							              <xsl:otherwise>
								                <xsl:text>some</xsl:text>
							              </xsl:otherwise>
						            </xsl:choose>
					          </xsl:when>
					          <xsl:when test="$numberOfRows = $numberSelectedRows">
						            <xsl:text>all</xsl:text>
					          </xsl:when>
					          <xsl:when test="count(..//ui:tr[@selected])=0">
						            <xsl:text>none</xsl:text>
					          </xsl:when>
					          <xsl:otherwise>
						            <xsl:text>some</xsl:text>
					          </xsl:otherwise>
				        </xsl:choose>
			      </xsl:variable>
			      <xsl:variable name="controlLabel">
				        <xsl:if test="@selectAll='control'">
					          <xsl:value-of select="$tble13"/>
				        </xsl:if>
			      </xsl:variable>
			      <xsl:variable name="bodyId" select="concat(../@id,'-tb')"/>
			      <xsl:call-template name="selectToggle">
				        <xsl:with-param name="for" select="$bodyId"/>
				        <xsl:with-param name="id" select="$bodyId"/>
				        <xsl:with-param name="selected" select="$selected"/>
				        <xsl:with-param name="label" select="$controlLabel"/>
				        <xsl:with-param name="roundTrip" select="@submitOnChange"/>
				        <xsl:with-param name="type" select="@selectAll"/>
			      </xsl:call-template>
		    </xsl:if>
	  </xsl:template>
   <xsl:template match="ui:rowsSelect">
		    <xsl:param name="tableId"/>
		    <xsl:param name="idSuffix"/>
		    <xsl:variable name="rppChooserName">
			      <xsl:value-of select="concat($tableId,'.rows', $idSuffix)"/>
		    </xsl:variable>
		    <label for="{$rppChooserName}">
			      <xsl:value-of select="$wdtp9"/>
			      <select id="{$rppChooserName}" class="wc_table_pag_rpp">
				
				        <xsl:call-template name="tableAjaxController">
					          <xsl:with-param name="tableId" select="$tableId"/>
				        </xsl:call-template>
				        <xsl:call-template name="disabledElement">
					          <xsl:with-param name="field" select="ancestor::ui:table[1]"/>
					          <xsl:with-param name="isControl" select="1"/>
				        </xsl:call-template>
				        <xsl:apply-templates mode="rowsPerPage">
					          <xsl:with-param name="rowsPerPage" select="../@rowsPerPage"/>
				        </xsl:apply-templates>
			      </select>
		    </label>
	  </xsl:template>
   <xsl:template match="ui:sort"/>
   <xsl:template match="ui:subTr/ui:content">
		    <xsl:param name="myTable"/>
		    <xsl:param name="parentIsClosed" select="0"/>
		    <xsl:param name="topRowIsStriped" select="0"/>
		    <xsl:param name="indent" select="0"/>
		
		    <xsl:variable name="tableId" select="$myTable/@id"/>
		
		    <tr id="{concat($tableId,'-subtrc',../../@rowIndex)}"
          role="row"
          aria-level="{count(ancestor::ui:subTr[ancestor::ui:table[1]/@id=$tableId]) + 1}">
			      <xsl:if test="$parentIsClosed=1 or ancestor::ui:subTr[not(@open) or @open='false']">
				        <xsl:call-template name="hiddenElement"/>
			      </xsl:if>
			      <xsl:attribute name="class">
				        <xsl:call-template name="commonClassHelper"/>
				        <xsl:if test="$topRowIsStriped=1">
					          <xsl:text> wc_table_stripe</xsl:text>
				        </xsl:if>
			      </xsl:attribute>
			
			
			      <xsl:if test="$myTable/ui:rowSelection">
				        <td role="gridcell">
					          <xsl:text> </xsl:text>
				        </td>
			      </xsl:if>
			
			
			      <td class="wc_table_rowexp_container" role="gridcell">
				        <xsl:text> </xsl:text>
			      </td>

			      <td role="gridcell">
				        <xsl:if test="@spanAllCols=$t">
					          <xsl:attribute name="colspan">
						            <xsl:value-of select="count(../../*) -1"/>
					          </xsl:attribute>
				        </xsl:if>
				        <xsl:if test="$indent &gt; 0">
					          <xsl:call-template name="cellIndentationHelper">
						            <xsl:with-param name="indent" select="$indent"/>
					          </xsl:call-template>
				        </xsl:if>
				        <xsl:apply-templates/>
			      </td>
		    </tr>
	  </xsl:template>
   <xsl:template match="ui:subTr">
		    <xsl:param name="myTable"/>
		    <xsl:param name="parentIsClosed" select="0"/>
		    <xsl:param name="topRowIsStriped" select="0"/>
		    <xsl:param name="indent" select="0"/>
		    <xsl:param name="hasRole" select="0"/>
		
		
		    <xsl:choose>
			      <xsl:when test="*">
				        <xsl:apply-templates select="*">
					          <xsl:with-param name="myTable" select="$myTable"/>
					          <xsl:with-param name="parentIsClosed" select="$parentIsClosed"/>
					          <xsl:with-param name="indent" select="$indent"/>
					          <xsl:with-param name="topRowIsStriped" select="$topRowIsStriped"/>
					          <xsl:with-param name="hasRole" select="$hasRole"/>
				        </xsl:apply-templates>
			      </xsl:when>
			      <xsl:otherwise>
				        <xsl:variable name="tableId" select="$myTable/@id"/>
				        <tr id="{concat($tableId,'-subtr',../@rowIndex)}" hidden="hidden"/>
			      </xsl:otherwise>
		    </xsl:choose>
	  </xsl:template>
   <xsl:template match="ui:tbody">
		    <xsl:param name="hasRole" select="0"/>
		    <tbody id="{concat(../@id,'-tb')}">
			      <xsl:if test="../@separators='both' or ../@separators='horizontal'">
				        <xsl:attribute name="class">wc_table_rowsep</xsl:attribute>
			      </xsl:if>
			      <xsl:apply-templates select="ui:tr">
				        <xsl:with-param name="myTable" select=".."/>
				        <xsl:with-param name="hasRole" select="$hasRole"/>
			      </xsl:apply-templates>
		    </tbody>
	  </xsl:template>
   <xsl:template match="ui:td">
		    <xsl:param name="myTable"/>
		    <xsl:param name="indent" select="0"/>
		    <xsl:param name="hasRole" select="0"/>
		
		    <xsl:variable name="tableId" select="$myTable/@id"/>
		    <xsl:variable name="tbleColPos">
			      <xsl:value-of select="position()"/>
		    </xsl:variable>
		    <xsl:variable name="colHeaderElement"
                    select="$myTable/ui:thead/ui:th[position()=$tbleColPos]"/>
		    <xsl:variable name="rowHeaderElement" select="../ui:th[1]"/>
		
		    <td>
			      <xsl:if test="$hasRole &gt; 0">
				        <xsl:attribute name="role">gridcell</xsl:attribute>
			      </xsl:if>
			      <xsl:attribute name="class">
				        <xsl:call-template name="commonClassHelper"/>
				
				        <xsl:if test="$myTable/@striping = 'cols' and position() mod 2 = 0">
					          <xsl:text> wc_table_stripe</xsl:text>
				        </xsl:if>
				        <xsl:variable name="alignedCol">
					          <xsl:value-of select="$colHeaderElement/@align"/>
				        </xsl:variable>
				        <xsl:choose>
					          <xsl:when test="$alignedCol!=''">
						            <xsl:value-of select="concat(' ',$alignedCol)"/>
					          </xsl:when>
					          <xsl:otherwise>
						            <xsl:text> left</xsl:text>
					          </xsl:otherwise>
				        </xsl:choose>
			      </xsl:attribute>
			
			      <xsl:if test="$colHeaderElement or $rowHeaderElement">
				        <xsl:attribute name="headers">
					          <xsl:variable name="colHeader">
						            <xsl:if test="$colHeaderElement">
							              <xsl:value-of select="concat($tableId,'-thh',$tbleColPos)"/>
						            </xsl:if>
					          </xsl:variable>
					          <xsl:variable name="rowHeader">
						            <xsl:if test="$rowHeaderElement">
							              <xsl:value-of select="concat($tableId,'-trh',../@rowIndex)"/>
						            </xsl:if>
					          </xsl:variable>
					          <xsl:value-of select="normalize-space(concat($colHeader,' ',$rowHeader))"/>
				        </xsl:attribute>
			      </xsl:if>
			      <xsl:if test="$indent &gt; 0 and not(preceding-sibling::*)">
				        <xsl:call-template name="cellIndentationHelper">
					          <xsl:with-param name="indent" select="$indent"/>
				        </xsl:call-template>
			      </xsl:if>
			      <xsl:apply-templates/>
		    </td>
	  </xsl:template>
   <xsl:template match="ui:th">
		    <xsl:param name="myTable"/>
		    <xsl:param name="indent" select="0"/>
		    <xsl:param name="hasRole" select="0"/>
		
		    <xsl:variable name="tableId" select="$myTable/@id"/>
		
		    <th id="{concat($tableId,'-trh',../@rowIndex)}" scope="row">
			      <xsl:if test="$hasRole &gt; 0">
				        <xsl:attribute name="role">
					          <xsl:text>rowheader</xsl:text>
				        </xsl:attribute>
			      </xsl:if>
			      <xsl:if test="$myTable/ui:thead">
				        <xsl:variable name="myHeader" select="$myTable/ui:thead/ui:th[1]"/>
				        <xsl:if test="$myHeader">
					          <xsl:attribute name="headers">
						            <xsl:value-of select="concat($tableId,'-thh','1')"/>
					          </xsl:attribute>
				        </xsl:if>
				        <xsl:variable name="align">
					          <xsl:value-of select="$myHeader/@align"/>
				        </xsl:variable>
				        <xsl:attribute name="class">
					          <xsl:choose>
						            <xsl:when test="$align!=''">
							              <xsl:value-of select="$align"/>
						            </xsl:when>
						            <xsl:otherwise>
							              <xsl:text>left</xsl:text>
						            </xsl:otherwise>
					          </xsl:choose>
				        </xsl:attribute>
			      </xsl:if>
			      <xsl:if test="$indent &gt; 0">
				        <xsl:call-template name="cellIndentationHelper">
					          <xsl:with-param name="indent" select="$indent"/>
				        </xsl:call-template>
			      </xsl:if>
			      <xsl:apply-templates select="ui:decoratedLabel">
				        <xsl:with-param name="output" select="'div'"/>
			      </xsl:apply-templates>
		    </th>
	  </xsl:template>
   <xsl:template match="ui:thead">
		    <xsl:param name="hasRole" select="0"/>
		    <thead>
			      <tr>
				        <xsl:if test="$hasRole &gt; 0">
					          <xsl:attribute name="role">
						            <xsl:text>row</xsl:text>
					          </xsl:attribute>
				        </xsl:if>
				        <xsl:if test="../ui:rowSelection">
					          <th class="wc_table_sel_wrapper" scope="col">
						            <xsl:if test="$hasRole &gt; 0">
							              <xsl:attribute name="role">
								                <xsl:text>columnheader</xsl:text>
							              </xsl:attribute>
						            </xsl:if>
						            <xsl:choose>
							              <xsl:when test="../ui:rowSelection/@selectAll = 'control'">
								                <xsl:apply-templates select="../ui:rowSelection"/>
							              </xsl:when>
							              <xsl:otherwise>
								                <xsl:attribute name="aria-hidden">true</xsl:attribute>
								                <xsl:text> </xsl:text>
							              </xsl:otherwise>
						            </xsl:choose>
					          </th>
				        </xsl:if>
				        <xsl:if test="../ui:rowExpansion">
					          <th class="wc_table_rowexp_container" scope="col">
						            <xsl:if test="$hasRole &gt; 0">
							              <xsl:attribute name="role">
								                <xsl:text>columnheader</xsl:text>
							              </xsl:attribute>
						            </xsl:if>
						            <xsl:call-template name="offscreenSpan">
							              <xsl:with-param name="text" select="$tble4"/>
						            </xsl:call-template>
					          </th>
				        </xsl:if>
				        <xsl:apply-templates select="ui:th" mode="thead">
					          <xsl:with-param name="hasRole" select="$hasRole"/>
				        </xsl:apply-templates>
			      </tr>
		    </thead>
	  </xsl:template>
   <xsl:template match="ui:tr">
		    <xsl:param name="myTable"/>
		    <xsl:param name="hasRole" select="0"/>
		    <xsl:param name="parentIsClosed" select="0"/>
		    <xsl:param name="topRowIsStriped" select="0"/>

		    <xsl:variable name="tableId" select="$myTable/@id"/>
		    <xsl:variable name="rowId" select="concat($tableId,'-',@rowIndex)"/>

		    <xsl:variable name="selectableRow">
			      <xsl:if test="$myTable/ui:rowSelection">
				        <xsl:value-of select="1"/>
			      </xsl:if>
		    </xsl:variable>

		    <xsl:variable name="hasRowExpansion">
			      <xsl:if test="$myTable/ui:rowExpansion">
				        <xsl:value-of select="1"/>
			      </xsl:if>
		    </xsl:variable>

		    <xsl:variable name="indent">
			      <xsl:choose>
				        <xsl:when test="$hasRowExpansion=1 and $myTable/@type='hierarchic' and parent::ui:subTr">
					          <xsl:value-of select="count(ancestor::ui:subTr[ancestor::ui:table[1] = $myTable])"/>
				        </xsl:when>
				        <xsl:otherwise>
					          <xsl:number value="0"/>
				        </xsl:otherwise>
			      </xsl:choose>
		    </xsl:variable>

		

		    <xsl:variable name="removeRow">
			      <xsl:choose>
				
				        <xsl:when test="$parentIsClosed=1 or @hidden=$t or parent::ui:subTr[not(@open=$t)] or (ancestor::ui:subTr[not(@open=$t) and ancestor::ui:table[1]/@id=$tableId])">
					          <xsl:value-of select="1"/>
				        </xsl:when>
				        <xsl:when test="parent::ui:tbody and $myTable/ui:pagination/@mode = 'client'">
					          <xsl:call-template name="clientRowClosedHelper">
						            <xsl:with-param name="myTable" select="$myTable"/>
					          </xsl:call-template>
				        </xsl:when>
				        <xsl:otherwise>
					          <xsl:value-of select="0"/>
				        </xsl:otherwise>
			      </xsl:choose>
		    </xsl:variable>
		
		    <xsl:variable name="isSelectToggle">
			      <xsl:if test="$hasRowExpansion + $selectableRow = 2 and $myTable/ui:rowSelection/@toggle and ui:subTr/ui:tr[not(@unselectable)]">
				        <xsl:number value="1"/>
			      </xsl:if>
		    </xsl:variable>

		    <tr id="{$rowId}" data-wc-rowindex="{@rowIndex}">
			      <xsl:if test="$hasRole &gt; 0">
				        <xsl:attribute name="role">row</xsl:attribute>
			      </xsl:if>

			      <xsl:attribute name="class">
				        <xsl:call-template name="commonClassHelper"/>
				        <xsl:choose>
					          <xsl:when test="parent::ui:tbody">
						            <xsl:if test="$myTable/@striping='rows' and position() mod 2 = 0">
							              <xsl:text> wc_table_stripe</xsl:text>
						            </xsl:if>
						            <xsl:if test="$myTable/ui:pagination">
							              <xsl:text> wc_table_pag_row</xsl:text>
						            </xsl:if>
					          </xsl:when>
					          <xsl:when test="$topRowIsStriped=1">
						            <xsl:text> wc_table_stripe</xsl:text>
					          </xsl:when>
				        </xsl:choose>
				
			      </xsl:attribute>

			      <xsl:if test="$hasRowExpansion=1">
				        <xsl:if test="ui:subTr">
					          <xsl:attribute name="aria-expanded">
						            <xsl:choose>
							              <xsl:when test="ui:subTr/@open=$t">
								                <xsl:copy-of select="$t"/>
							              </xsl:when>
							              <xsl:otherwise>
								                <xsl:text>false</xsl:text>
							              </xsl:otherwise>
						            </xsl:choose>
					          </xsl:attribute>

					          <xsl:variable name="expMode" select="$myTable/ui:rowExpansion/@mode"/>

					          <xsl:variable name="isOpen">
						            <xsl:if test="ui:subTr/@open=$t">
							              <xsl:value-of select="1"/>
						            </xsl:if>
					          </xsl:variable>

					          <xsl:attribute name="aria-controls">
						            <xsl:choose>
							              <xsl:when test="ui:subTr/ui:tr">
								                <xsl:apply-templates select="ui:subTr/ui:tr" mode="subRowControlIdentifier">
									                  <xsl:with-param name="tableId" select="$tableId"/>
								                </xsl:apply-templates>
							              </xsl:when>
							              <xsl:when test="ui:subTr/ui:content">
								                <xsl:value-of select="concat($tableId,'-subtrc',@rowIndex)"/>
							              </xsl:when>
							              <xsl:otherwise>
								                <xsl:value-of select="concat($tableId,'-subtr',@rowIndex)"/>
							              </xsl:otherwise>
						            </xsl:choose>
					          </xsl:attribute>

					          <xsl:variable name="expansionMode">
						            <xsl:choose>
							              <xsl:when test="($expMode='lazy' or $expMode='eager') and $isOpen=1">
								                <xsl:text>client</xsl:text>
							              </xsl:when>
							              <xsl:when test="$expMode='eager'">
								                <xsl:text>lazy</xsl:text>
							              </xsl:when>
							              <xsl:when test="$expMode">
								                <xsl:value-of select="$expMode"/>
							              </xsl:when>
							              <xsl:otherwise>
								                <xsl:text>client</xsl:text>
							              </xsl:otherwise>
						            </xsl:choose>
					          </xsl:variable>

					          <xsl:if test="$expansionMode='lazy' or $expansionMode='dynamic'">
						            <xsl:attribute name="data-wc-ajaxalias">
							              <xsl:value-of select="$tableId"/>
						            </xsl:attribute>
						            <xsl:if test="$expansionMode='lazy'">
							              <xsl:attribute name="data-wc-expmode">
								                <xsl:value-of select="$expansionMode"/>
							              </xsl:attribute>
						            </xsl:if>
					          </xsl:if>
				        </xsl:if>

				        <xsl:if test="parent::ui:subTr">
					          <xsl:call-template name="setARIALive"/>
				        </xsl:if>

				        <xsl:attribute name="aria-level">
					          <xsl:value-of select="count(ancestor::ui:subTr[ancestor::ui:table[1]/@id=$tableId]) + 1"/>
				        </xsl:attribute>
			      </xsl:if>

			
			      <xsl:if test="$selectableRow=1 and not(@unselectable=$t)">
				        <xsl:attribute name="aria-selected">
					          <xsl:choose>
						            <xsl:when test="$isSelectToggle=1 and .//ui:subTr[ancestor::ui:table[1]/@id = $tableId]/ui:tr[not(@unselectable or @selected)]">
							
							              <xsl:text>false</xsl:text>
						            </xsl:when>
						            <xsl:when test="$isSelectToggle = 1 or @selected = $t">
							              <xsl:copy-of select="$t"/>
						            </xsl:when>
						            <xsl:otherwise>
							              <xsl:text>false</xsl:text>
						            </xsl:otherwise>
					          </xsl:choose>
				        </xsl:attribute>

				        <xsl:attribute name="tabindex">
					          <xsl:text>0</xsl:text>
				        </xsl:attribute>

				        <xsl:attribute name="data-wc-name">
					          <xsl:value-of select="concat($tableId,'.selected')"/>
				        </xsl:attribute>

				        <xsl:attribute name="data-wc-value">
					          <xsl:value-of select="@rowIndex"/>
				        </xsl:attribute>
				
				

				
				        <xsl:choose>
					          <xsl:when test="@disabled">
						            <xsl:call-template name="disabledElement"/>
					          </xsl:when>
					          <xsl:when test="$myTable/@disabled">
						            <xsl:call-template name="disabledElement">
							              <xsl:with-param name="field" select="$myTable"/>
						            </xsl:call-template>
					          </xsl:when>
				        </xsl:choose>
			      </xsl:if>

			      <xsl:if test="$removeRow=1">
				        <xsl:call-template name="hiddenElement"/>
			      </xsl:if>

			      <xsl:choose>
				        <xsl:when test="@disabled">
					          <xsl:call-template name="disabledElement"/>
				        </xsl:when>
				        <xsl:otherwise>
					          <xsl:call-template name="disabledElement">
						            <xsl:with-param name="field" select="$myTable"/>
					          </xsl:call-template>
				        </xsl:otherwise>
			      </xsl:choose>

			
			


			
			      <xsl:if test="$selectableRow=1">
				        <td class="wc_table_sel_wrapper" aria-hidden="true">
					          <xsl:if test="$isSelectToggle=1">
						            <xsl:variable name="subRowToggleControlId"
                                select="concat($rowId, '_toggleController')"/>
						            <xsl:variable name="subRowToggleControlButtonId"
                                select="concat($subRowToggleControlId, '_showbtn')"/>
						            <xsl:variable name="subRowToggleControlContentId"
                                select="concat($subRowToggleControlId, '_content')"/>
						
						            <div class="menu flyout" role="menubar" id="{$subRowToggleControlId}">
							              <div class="submenu" role="menuitem">
								                <button type="button"
                                aria-haspopup="true"
                                class="wc_btn_nada"
                                id="{$subRowToggleControlButtonId}"
                                aria-controls="{$subRowToggleControlContentId}">
									                  <span class="wc_off">
                              <xsl:value-of select="$tble13"/>
                           </span>
								                </button>
								                <div class="submenucontent wc_seltog"
                             role="menu"
                             aria-expanded="false"
                             id="{$subRowToggleControlContentId}"
                             aria-labelledby="{$subRowToggleControlButtonId}">
									                  <xsl:variable name="allSelectableSubRows"
                                         select="count(.//ui:subTr[ancestor::ui:table[1]/@id = $tableId]/ui:tr[not(@unselectable)])"/>
									                  <xsl:variable name="allUnselectedSubRows"
                                         select="count(.//ui:subTr[ancestor::ui:table[1]/@id = $tableId]/ui:tr[not(@unselectable or @selected)])"/>
									                  <xsl:variable name="subRowControlList">
										                    <xsl:value-of select="concat($rowId, ' ')"/>
										                    <xsl:apply-templates select="ui:subTr//ui:tr[ancestor::ui:table[1]/@id = $tableId]"
                                                   mode="subRowControlIdentifier">
											                      <xsl:with-param name="tableId" select="$tableId"/>
										                    </xsl:apply-templates>
									                  </xsl:variable>
									                  <button type="button"
                                   role="menuitemradio"
                                   class="menuitem wc_seltog wc_btn_nada"
                                   aria-controls="{$subRowControlList}"
                                   data-wc-value="all">
										                    <xsl:attribute name="aria-checked">
											                      <xsl:choose>
												                        <xsl:when test="$allUnselectedSubRows = 0">
													                          <xsl:text>true</xsl:text>
												                        </xsl:when>
												                        <xsl:otherwise>
													                          <xsl:text>false</xsl:text>
												                        </xsl:otherwise>
											                      </xsl:choose>
										                    </xsl:attribute>
										                    <span class="wc_off">
                                 <xsl:value-of select="$tog1"/> 
                              </span>
										                    <xsl:value-of select="$tog2"/>
									                  </button>
									                  <button type="button"
                                   role="menuitemradio"
                                   class="menuitem wc_seltog wc_btn_nada"
                                   aria-controls="{$subRowControlList}"
                                   data-wc-value="none">
										                    <xsl:attribute name="aria-checked">
											                      <xsl:choose>
												                        <xsl:when test="$allSelectableSubRows = $allUnselectedSubRows">
													                          <xsl:text>true</xsl:text>
												                        </xsl:when>
												                        <xsl:otherwise>
													                          <xsl:text>false</xsl:text>
												                        </xsl:otherwise>
											                      </xsl:choose>
										                    </xsl:attribute>
										                    <span class="wc_off">
                                 <xsl:value-of select="$tog1"/> 
                              </span>
										                    <xsl:value-of select="$tog3"/>
									                  </button>
								                </div>
							              </div>
						            </div>
					          </xsl:if>
				        </td>
			      </xsl:if>
			
			      <xsl:if test="$myTable/ui:rowExpansion">
				
				        <td class="wc_table_rowexp_container">
					          <xsl:if test="ui:subTr">
						            <xsl:attribute name="role">button</xsl:attribute>
						            <xsl:attribute name="aria-controls">
							              <xsl:value-of select="$rowId"/>
						            </xsl:attribute>
						            <xsl:attribute name="tabindex">0</xsl:attribute>
						            <xsl:call-template name="offscreenSpan">
							              <xsl:with-param name="text">
								                <xsl:value-of select="$tre1"/>
							              </xsl:with-param>
						            </xsl:call-template>
					          </xsl:if>
				        </td>
			      </xsl:if>

			      <xsl:apply-templates select="ui:th|ui:td">
				        <xsl:with-param name="myTable" select="$myTable"/>
				        <xsl:with-param name="indent" select="$indent"/>
				        <xsl:with-param name="hasRole" select="$hasRole"/>
			      </xsl:apply-templates>
		    </tr>
		
		    <xsl:apply-templates select="ui:subTr">
			      <xsl:with-param name="myTable" select="$myTable"/>
			      <xsl:with-param name="parentIsClosed" select="$removeRow"/>
			      <xsl:with-param name="indent" select="$indent"/>
			      <xsl:with-param name="topRowIsStriped">
				        <xsl:choose>
					          <xsl:when test="$topRowIsStriped=1 or (parent::ui:tbody and $myTable/@striping='rows' and position() mod 2 = 0)">
						            <xsl:number value="1"/>
					          </xsl:when>
					          <xsl:otherwise>
						            <xsl:number value="0"/>
					          </xsl:otherwise>
				        </xsl:choose>
			      </xsl:with-param>
			      <xsl:with-param name="hasRole" select="$hasRole"/>
		    </xsl:apply-templates>
	  </xsl:template>
   <xsl:template match="ui:table">
		    <xsl:variable name="id" select="@id"/>
		
		    <xsl:variable name="isError" select="key('errorKey',$id)"/>

		    <xsl:variable name="disabled">
			      <xsl:if test="@disabled">
				        <xsl:number value="1"/>
			      </xsl:if>
		    </xsl:variable>
		
		    <xsl:variable name="hasToggleSelectMode">
			      <xsl:if test="ui:rowSelection[@toggle and @multiple] and ui:rowExpansion and ui:tbody/ui:tr/ui:subTr">
				        <xsl:number value="1"/>
			      </xsl:if>
		    </xsl:variable>

		    <div id="{$id}">
			      <xsl:attribute name="class">
				        <xsl:call-template name="WTableContainerClass">
					          <xsl:with-param name="isError" select="$isError"/>
				        </xsl:call-template>
			      </xsl:attribute>

			      <xsl:call-template name="hideElementIfHiddenSet"/>

			      <xsl:if test="ui:pagination[@mode='dynamic' or @mode='client'] or ui:rowExpansion[@mode='lazy' or @mode='dynamic'] or ui:sort[@mode='dynamic'] or key('targetKey',$id) or parent::ui:ajaxTarget[@action='replace']">
				        <xsl:call-template name="setARIALive"/>
			      </xsl:if>

			      <xsl:apply-templates select="ui:margin"/>
			
			      <xsl:call-template name="disabledElement"/>

			
			      <xsl:if test="@activeFilters">
				        <xsl:attribute name="data-wc-activefilter">
					          <xsl:value-of select="@activeFilters"/>
				        </xsl:attribute>
			      </xsl:if>

			

			      <xsl:choose>
				        <xsl:when test="ui:tbody/ui:noData">
					
					          <xsl:apply-templates select="ui:tbody/ui:noData"/>
				        </xsl:when>
				        <xsl:otherwise>
					          <xsl:variable name="rowExpansion">
						            <xsl:choose>
							              <xsl:when test="ui:rowExpansion">
								                <xsl:value-of select="1"/>
							              </xsl:when>
							              <xsl:otherwise>
								                <xsl:value-of select="0"/>
							              </xsl:otherwise>
						            </xsl:choose>
					          </xsl:variable>

					          <xsl:variable name="rowSelection">
						            <xsl:choose>
							              <xsl:when test="ui:rowSelection">
								                <xsl:value-of select="1"/>
							              </xsl:when>
							              <xsl:otherwise>
								                <xsl:value-of select="0"/>
							              </xsl:otherwise>
						            </xsl:choose>
					          </xsl:variable>

					          <xsl:variable name="hasRole" select="$rowExpansion + $rowSelection"/>


					
					          <xsl:call-template name="topControls"/>

					          <xsl:variable name="class">
						            <xsl:if test="ui:thead/ui:th[@width]">
							              <xsl:text>wc_table_fix</xsl:text>
						            </xsl:if>
						            <xsl:if test="@type='hierarchic'">
							              <xsl:text> hierarchic</xsl:text>
						            </xsl:if>
						            <xsl:if test="$hasToggleSelectMode = 1">
							              <xsl:text> wc_table_hastoggleselect</xsl:text>
						            </xsl:if>
					          </xsl:variable>

					          <table>
						            <xsl:if test="$hasRole &gt; 0">
							              <xsl:attribute name="role">
								                <xsl:choose>
									                  <xsl:when test="$rowExpansion=1">
										                    <xsl:text>treegrid</xsl:text>
									                  </xsl:when>
									                  <xsl:otherwise>
										                    <xsl:text>grid</xsl:text>
									                  </xsl:otherwise>
								                </xsl:choose>
							              </xsl:attribute>
							              <xsl:attribute name="aria-readonly">true</xsl:attribute>
							              <xsl:if test="$rowSelection=1">
								                <xsl:attribute name="aria-multiselectable">
									                  <xsl:choose>
										                    <xsl:when test="ui:rowSelection/@multiple">
											                      <xsl:text>true</xsl:text>
										                    </xsl:when>
										                    <xsl:otherwise>
											                      <xsl:text>false</xsl:text>
										                    </xsl:otherwise>
									                  </xsl:choose>
								                </xsl:attribute>
							              </xsl:if>
						            </xsl:if>
						            <xsl:if test="$class != ''">
							              <xsl:attribute name="class">
								                <xsl:value-of select="normalize-space($class)"/>
							              </xsl:attribute>
						            </xsl:if>
						            <xsl:if test="ui:pagination">
							              <xsl:attribute name="data-wc-rpp">
								                <xsl:choose>
									                  <xsl:when test="ui:pagination/@rowsPerPage">
										                    <xsl:value-of select="ui:pagination/@rowsPerPage"/>
									                  </xsl:when>
									                  <xsl:otherwise>
										                    <xsl:value-of select="ui:pagination/@rows"/>
									                  </xsl:otherwise>
								                </xsl:choose>
							              </xsl:attribute>
						            </xsl:if>
						            <xsl:if test="ui:sort">
							              <xsl:attribute name="sortable">sortable</xsl:attribute>
						            </xsl:if>

						            <xsl:call-template name="caption"/>

						            <colgroup>
							              <xsl:if test="@separators='both' or @separators='vertical'">
								                <xsl:attribute name="class">
									                  <xsl:text>wc_table_colsep</xsl:text>
								                </xsl:attribute>
							              </xsl:if>

							              <xsl:if test="$rowSelection=1">
								                <col>
									                  <xsl:attribute name="class">
										                    <xsl:text>wc_table_colauto</xsl:text>
										                    <xsl:if test="$hasToggleSelectMode = 1">
											                      <xsl:text> wc_table_col_hasmenu</xsl:text>
										                    </xsl:if>
									                  </xsl:attribute>
									                  <xsl:if test="$isDebug=1">
										                    <xsl:comment>row selection column</xsl:comment>
									                  </xsl:if>
								                </col>
							              </xsl:if>

							              <xsl:if test="$rowExpansion=1">
								                <col class="wc_table_colauto">
									                  <xsl:if test="$isDebug=1">
										                    <xsl:comment>row expansion column</xsl:comment>
									                  </xsl:if>
								                </col>
							              </xsl:if>

							              <xsl:choose>
								                <xsl:when test="ui:thead/ui:th">
									                  <xsl:apply-templates select="ui:thead/ui:th" mode="col">
										                    <xsl:with-param name="stripe">
											                      <xsl:if test="@striping='cols'">
												                        <xsl:value-of select="1"/>
											                      </xsl:if>
										                    </xsl:with-param>
										                    <xsl:with-param name="sortCol" select="ui:sort/@col"/>
									                  </xsl:apply-templates>
								                </xsl:when>
								                <xsl:otherwise>
									                  <xsl:apply-templates select="ui:tbody/ui:tr[1]/ui:th|ui:tbody/ui:tr[1]/ui:td" mode="col">
										                    <xsl:with-param name="stripe">
											                      <xsl:if test="@striping='cols'">
												                        <xsl:value-of select="1"/>
											                      </xsl:if>
										                    </xsl:with-param>
										                    <xsl:with-param name="sortCol" select="ui:sort/@col"/>
									                  </xsl:apply-templates>
								                </xsl:otherwise>
							              </xsl:choose>
						            </colgroup>
						            <xsl:apply-templates select="ui:thead">
							              <xsl:with-param name="hasRole" select="$hasRole"/>
						            </xsl:apply-templates>


						            <xsl:apply-templates select="ui:tbody">
							              <xsl:with-param name="hasRole" select="$hasRole"/>
							              <xsl:with-param name="disabled" select="$disabled"/>
						            </xsl:apply-templates>
					          </table>

					          <xsl:call-template name="tableBottomControls">
						            <xsl:with-param name="addCols" select="$hasRole"/>
						            <xsl:with-param name="disabled" select="$disabled"/>
					          </xsl:call-template>
					          <xsl:call-template name="hField"/>
				        </xsl:otherwise>
			      </xsl:choose>
			      <xsl:call-template name="inlineError">
				        <xsl:with-param name="errors" select="$isError"/>
			      </xsl:call-template>
		    </div>
	  </xsl:template>
   <xsl:template match="ui:tabset">
		    <xsl:variable name="firstOpenTab"
                    select="(ui:tab[@open=$t]|ui:tabGroup/ui:tab[@open=$t])[1]"/>
		
		    <xsl:variable name="tabsAfterContent">
			      <xsl:call-template name="tabsAfterContent"/>
		    </xsl:variable>

		    <div id="{@id}">
			      <xsl:attribute name="class">
				        <xsl:call-template name="WTabsetClass"/>
			      </xsl:attribute>

			      <xsl:call-template name="disabledElement"/>
			      <xsl:call-template name="hideElementIfHiddenSet"/>
			      <xsl:call-template name="ajaxTarget"/>
			
			      <xsl:apply-templates select="ui:margin"/>
			
			
			      <xsl:if test="$tabsAfterContent!=1">
				        <xsl:call-template name="doTabList">
					          <xsl:with-param name="firstOpenTab" select="$firstOpenTab"/>
				        </xsl:call-template>
			      </xsl:if>
			
			      <xsl:if test="not(@type='accordion')">
				        <xsl:element name="div">
					          <xsl:attribute name="role">
						            <xsl:text>presentation</xsl:text>
					          </xsl:attribute>
					          <xsl:apply-templates select="ui:tab|ui:tabGroup/ui:tab" mode="content">
						            <xsl:with-param name="tabset" select="."/>
						            <xsl:with-param name="tabsetId" select="@id"/>
						            <xsl:with-param name="type" select="@type"/>
						            <xsl:with-param name="firstOpenTab" select="$firstOpenTab"/>
					          </xsl:apply-templates>
				        </xsl:element>
			      </xsl:if>
			      <xsl:if test="$tabsAfterContent=1">
				        <xsl:call-template name="doTabList">
					          <xsl:with-param name="firstOpenTab" select="$firstOpenTab"/>
				        </xsl:call-template>
			      </xsl:if>
		    </div>
	  </xsl:template>
   <xsl:template match="ui:text">
		    <xsl:variable name="type" select="@type"/>
		
		    <xsl:variable name="class">
			      <xsl:call-template name="commonClassHelper"/>
		    </xsl:variable>
		    <xsl:choose>
			      <xsl:when test="@space='paragraphs'">
				        <xsl:apply-templates select="text()" mode="para">
					          <xsl:with-param name="type" select="$type"/>
					          <xsl:with-param name="class" select="$class"/>
				        </xsl:apply-templates>
			      </xsl:when>
			      <xsl:when test="@space">
				        <pre class="{$class}">
					          <xsl:apply-templates mode="pre">
						            <xsl:with-param name="type" select="$type"/>
					          </xsl:apply-templates>
				        </pre>
			      </xsl:when>
			      <xsl:otherwise>
				        <xsl:variable name="elementType">
					          <xsl:call-template name="WStyledTextGetElementFromType"/>
				        </xsl:variable>
				        <xsl:element name="{$elementType}">
					          <xsl:attribute name="class">
						            <xsl:value-of select="$class"/>
						            <xsl:if test="$type !=''">
							              <xsl:value-of select="concat(' ', $type)"/>
						            </xsl:if>
					          </xsl:attribute>
					          <xsl:apply-templates/>
				        </xsl:element>
			      </xsl:otherwise>
		    </xsl:choose>
	  </xsl:template>
   <xsl:template match="ui:textArea">
		    <xsl:variable name="id" select="@id"/>
		    <xsl:variable name="readOnly">
			      <xsl:if test="@readOnly=$t">
				        <xsl:number value="1"/>
			      </xsl:if>
		    </xsl:variable>
		    <xsl:variable name="tickerId" select="concat(@id,'_ticker')"/>
		    <xsl:variable name="myLabel" select="key('labelKey',$id)"/>
		    <xsl:choose>
			      <xsl:when test="$readOnly=1">
				        <xsl:call-template name="readOnlyControl">
					          <xsl:with-param name="label" select="$myLabel[1]"/>
				        </xsl:call-template>
			      </xsl:when>
			      <xsl:otherwise>
				        <xsl:variable name="isError" select="key('errorKey',$id)"/>
				        <xsl:if test="not($myLabel)">
					          <xsl:call-template name="checkLabel">
						            <xsl:with-param name="force" select="1"/>
					          </xsl:call-template>
				        </xsl:if>
				        <xsl:element name="textarea">
					          <xsl:call-template name="commonControlAttributes">
						            <xsl:with-param name="isError" select="$isError"/>
						            <xsl:with-param name="name" select="$id"/>
						            <xsl:with-param name="live" select="'off'"/>
						            <xsl:with-param name="myLabel" select="$myLabel[1]"/>
					          </xsl:call-template>
					          <xsl:if test="@maxLength">
						            <xsl:attribute name="data-wc-maxlength">
							              <xsl:value-of select="@maxLength"/>
						            </xsl:attribute>
						            <xsl:attribute name="aria-owns">
							              <xsl:value-of select="$tickerId"/>
						            </xsl:attribute>
					          </xsl:if>
					          <xsl:if test="@minLength">
						            <xsl:attribute name="data-wc-min">
							              <xsl:value-of select="@minLength"/>
						            </xsl:attribute>
					          </xsl:if>
					          <xsl:if test="@required=$t">
						            <xsl:attribute name="placeholder">
							              <xsl:value-of select="$cm2"/>
						            </xsl:attribute>
					          </xsl:if>
					          <xsl:if test="@cols">
						            <xsl:attribute name="cols">
							              <xsl:value-of select="@cols"/>
						            </xsl:attribute>
					          </xsl:if>
					          <xsl:if test="@rows">
						            <xsl:attribute name="rows">
							              <xsl:value-of select="@rows"/>
						            </xsl:attribute>
					          </xsl:if>
					          <xsl:value-of select="."/>
				        </xsl:element>
				        <xsl:if test="@maxLength">
					          <xsl:variable name="chrs" select="@maxLength - string-length(text())"/>
					          <xsl:element name="output">
						            <xsl:attribute name="id">
							              <xsl:value-of select="$tickerId"/>
						            </xsl:attribute>
						            <xsl:attribute name="name">
							              <xsl:value-of select="$tickerId"/>
						            </xsl:attribute>
						            <xsl:attribute name="for">
							              <xsl:value-of select="@id"/>
						            </xsl:attribute>
						            <xsl:call-template name="hiddenElement"/>
						
						            <xsl:if test="string-length(text()) &gt; @maxLength">
						               <xsl:attribute name="class">
							                 <xsl:text>wc_error</xsl:text>
						               </xsl:attribute>
						            </xsl:if>
					          </xsl:element>
				        </xsl:if>
				        <xsl:call-template name="inlineError">
					          <xsl:with-param name="errors" select="$isError"/>
				        </xsl:call-template>
			      </xsl:otherwise>
		    </xsl:choose>
	  </xsl:template>
   <xsl:template match="ui:analytic|ui:tracking"/>
   <xsl:template match="ui:error">
		    <li class="error">
			      <a href="{concat('#',@for)}">
				        <xsl:apply-templates/>
			      </a>
		    </li>
	  </xsl:template>
   <xsl:template match="ui:version">
		    <xsl:variable name="buildNumber">
			      <xsl:text>1.0.5</xsl:text>
		    </xsl:variable>
		    <xsl:value-of select="$buildNumber"/>
		    <xsl:variable name="serv" select="@server"/>
		    <xsl:if test="$serv and $serv != $buildNumber">
			      <xsl:value-of select="concat(' (Server version: ',$serv,')')"/>
		    </xsl:if>
	  </xsl:template>
   <xsl:template match="ui:track">
		    <xsl:element name="TRACK">
			      <xsl:attribute name="src">
				        <xsl:value-of select="@src"/>
			      </xsl:attribute>
			      <xsl:if test="@lang">
				        <xsl:attribute name="srclang">
					          <xsl:value-of select="@lang"/>
				        </xsl:attribute>
			      </xsl:if>
			      <xsl:if test="@desc">
				        <xsl:attribute name="label">
					          <xsl:value-of select="@desc"/>
				        </xsl:attribute>
			      </xsl:if>
			      <xsl:if test="@kind">
				        <xsl:attribute name="kind">
					          <xsl:value-of select="@kind"/>
				        </xsl:attribute>
			      </xsl:if>
		    </xsl:element>
	  </xsl:template>
   <xsl:template match="*" mode="getIdList">
		    <xsl:value-of select="@id"/>
		    <xsl:if test="position() != last()">
			      <xsl:value-of select="' '"/>
		    </xsl:if>
	  </xsl:template>
   <xsl:template match="*" mode="registerIds">
		    <xsl:text>"</xsl:text>
		    <xsl:choose>
			      <xsl:when test="self::ui:tab">
				        <xsl:value-of select="ui:tabContent/@id"/>
			      </xsl:when>
			      <xsl:when test="self::ui:collapsible or self::ui:submenu">
				        <xsl:value-of select="ui:content/@id"/>
			      </xsl:when>
			      <xsl:otherwise>
				        <xsl:value-of select="@id"/>
			      </xsl:otherwise>
		    </xsl:choose>
		    <xsl:text>"</xsl:text>
		    <xsl:if test="position()!=last()">
			      <xsl:text>,</xsl:text>
		    </xsl:if>
	  </xsl:template>
   <xsl:template match="ui:option" mode="checkableGroupInList">
		    <xsl:param name="firstItemAccessKey"/>
		    <xsl:param name="inputName"/>
		    <xsl:param name="type"/>
		    <xsl:param name="readOnly" select="0"/>
		    <xsl:if test="$readOnly=0 or @selected">
			      <xsl:variable name="localAccessKey">
				        <xsl:if test="position()=1 and $firstItemAccessKey != ''">
					          <xsl:value-of select="$firstItemAccessKey"/>
				        </xsl:if>
			      </xsl:variable>
			      <xsl:call-template name="checkableSelectOption">
				        <xsl:with-param name="optionName" select="$inputName"/>
				        <xsl:with-param name="optionType" select="$type"/>
				        <xsl:with-param name="readOnly" select="$readOnly"/>
				        <xsl:with-param name="cgAccessKey" select="$localAccessKey"/>
			      </xsl:call-template>
		    </xsl:if>
	  </xsl:template>
   <xsl:template match="ui:option" mode="checkableGroup">
		    <xsl:param name="firstItemAccessKey"/>
		    <xsl:param name="inputName"/>
		    <xsl:param name="type"/>
		    <xsl:param name="rows"/>
		    <xsl:param name="readOnly"/>
		    <xsl:variable name="firstAccessKey">
			      <xsl:if test="position()=1">
				        <xsl:value-of select="$firstItemAccessKey"/>
			      </xsl:if>
		    </xsl:variable>
		    <xsl:variable name="layout" select="../@layout"/>
		    <xsl:variable name="elementName">
			      <xsl:choose>
				        <xsl:when test="$readOnly=1">
					          <xsl:text>ul</xsl:text>
				        </xsl:when>
				        <xsl:when test="$layout='flat'">
					          <xsl:text>span</xsl:text>
				        </xsl:when>
				        <xsl:otherwise>
					          <xsl:text>div</xsl:text>
				        </xsl:otherwise>
			      </xsl:choose>
		    </xsl:variable>
		    <xsl:element name="{$elementName}">
			      <xsl:attribute name="class">
				        <xsl:value-of select="$layout"/>
				        <xsl:if test="$elementName='ul'">
					          <xsl:text> wc_list_nb</xsl:text>
				        </xsl:if>
			      </xsl:attribute>
			      <xsl:call-template name="checkableSelectOption">
				        <xsl:with-param name="optionName" select="$inputName"/>
				        <xsl:with-param name="optionType" select="$type"/>
				        <xsl:with-param name="readOnly" select="$readOnly"/>
				        <xsl:with-param name="cgAccessKey" select="$firstAccessKey"/>
			      </xsl:call-template>			
			      <xsl:if test="$rows &gt; 0">
				        <xsl:choose>
					          <xsl:when test="$readOnly=1">
						            <xsl:apply-templates select="following-sibling::ui:option[@selected][position() &lt; $rows]"
                                       mode="checkableGroupInList">
							              <xsl:with-param name="inputName" select="$inputName"/>
							              <xsl:with-param name="type" select="$type"/>
							              <xsl:with-param name="readOnly" select="1"/>
						            </xsl:apply-templates>
					          </xsl:when>
					          <xsl:otherwise>
						            <xsl:apply-templates select="following-sibling::ui:option[position() &lt; $rows]"
                                       mode="checkableGroupInList">
							              <xsl:with-param name="inputName" select="$inputName"/>
							              <xsl:with-param name="type" select="$type"/>
						            </xsl:apply-templates>
					          </xsl:otherwise>
				        </xsl:choose>
			      </xsl:if>
		    </xsl:element>
	  </xsl:template>
   <xsl:template match="ui:option" mode="readOnly">
		    <xsl:param name="single" select="1"/>
		    <xsl:param name="className"/>
		    <xsl:choose>
			      <xsl:when test="$single=1">
				        <xsl:value-of select="."/>
			      </xsl:when>
			      <xsl:otherwise>
				        <xsl:variable name="class">
					          <xsl:if test="parent::ui:optgroup">wc_inoptgroup</xsl:if>
					          <xsl:if test="$className!=''">
						            <xsl:value-of select="concat(' ',$className)"/>
					          </xsl:if>
				        </xsl:variable>
				        <li>
					          <xsl:if test="$class!=''">
						            <xsl:attribute name="class">
							              <xsl:value-of select="normalize-space($class)"/>
						            </xsl:attribute>
					          </xsl:if>
					          <xsl:value-of select="."/>
				        </li>
			      </xsl:otherwise>
		    </xsl:choose>
	  </xsl:template>
   <xsl:template match="ui:option" mode="selectableList">
		    <xsl:variable name="value" select="@value"/>
		    <option>
			      <xsl:attribute name="value">
				        <xsl:choose>
					          <xsl:when test="$value">
						            <xsl:value-of select="$value"/>
					          </xsl:when>
					          <xsl:otherwise>
						            <xsl:value-of select="."/>
					          </xsl:otherwise>
				        </xsl:choose>
			      </xsl:attribute>
			      <xsl:if test="@selected">
				        <xsl:attribute name="selected">selected</xsl:attribute>
			      </xsl:if>
			      <xsl:if test="@isNull">
				        <xsl:attribute name="data-wc-null">
					          <xsl:text>1</xsl:text>
				        </xsl:attribute>
			      </xsl:if>
			      <xsl:value-of select="."/>
		    </option>
	  </xsl:template>
   <xsl:template match="ui:option" mode="multiDropDown">
		    <xsl:param name="isSingular"/>
		    <xsl:param name="myLabel"/>
		    <xsl:variable name="option" select="."/>
		    <xsl:variable name="ancestorMDD" select="ancestor::ui:multiDropdown"/>
		    <xsl:variable name="id" select="$ancestorMDD/@id"/>
		    <li>
			      <xsl:element name="select">
				        <xsl:attribute name="name">
					          <xsl:value-of select="$id"/>
				        </xsl:attribute>
				        <xsl:attribute name="id">
					          <xsl:value-of select="concat($id,generate-id(),'-',position())"/>
				        </xsl:attribute>
				        <xsl:attribute name="title">
					          <xsl:value-of select="$mfc2"/>
				        </xsl:attribute>
				        <xsl:if test="$ancestorMDD/@submitOnChange">
					          <xsl:attribute name="class">
						            <xsl:text>wc_soc</xsl:text>
					          </xsl:attribute>
				        </xsl:if>
				        <xsl:call-template name="disabledElement">
					          <xsl:with-param name="isControl" select="1"/>
					          <xsl:with-param name="field" select="$ancestorMDD"/>
				        </xsl:call-template>
				        <xsl:if test="$ancestorMDD/@data">
					          <xsl:attribute name="data-wc-list">
						            <xsl:value-of select="$ancestorMDD/@data"/>
					          </xsl:attribute>
				        </xsl:if>
				        <xsl:apply-templates select="$ancestorMDD/*" mode="mfcInList">
					          <xsl:with-param name="option" select="$option"/>
					          <xsl:with-param name="isSingular" select="$isSingular"/>
				        </xsl:apply-templates>
			      </xsl:element>
			      <xsl:call-template name="multiFieldIcon">
				        <xsl:with-param name="myLabel" select="$myLabel"/>
			      </xsl:call-template>
		    </li>
	  </xsl:template>
   <xsl:template match="ui:option" mode="mfcInList">
		    <xsl:param name="option"/>
		    <xsl:param name="isSingular"/>
		    <xsl:element name="option">
			      <xsl:attribute name="value">
				        <xsl:value-of select="@value"/>
			      </xsl:attribute>
			      <xsl:if test=". = $option and $isSingular=''">
				        <xsl:attribute name="selected">
					          <xsl:text>selected</xsl:text>
				        </xsl:attribute>
			      </xsl:if>
			      <xsl:if test="@isNull">
				        <xsl:attribute name="data-wc-null">
					          <xsl:text>1</xsl:text>
				        </xsl:attribute>
			      </xsl:if>
			      <xsl:value-of select="."/>
		    </xsl:element>
	  </xsl:template>
   <xsl:template match="ui:option" mode="multiselectPair">
		    <xsl:param name="readOnly"/>
		    <xsl:choose>
			      <xsl:when test="$readOnly!=1">
				        <option value="{@value}">
					          <xsl:value-of select="normalize-space(.)"/>
				        </option>
			      </xsl:when>
			      <xsl:otherwise>
				        <li>
					          <xsl:if test="parent::ui:optgroup">
						            <xsl:attribute name="class">
							              <xsl:text>wc_inoptgroup</xsl:text>
						            </xsl:attribute>
					          </xsl:if>
					          <xsl:choose>
						            <xsl:when test="normalize-space(.)">
							              <xsl:value-of select="normalize-space(.)"/>
						            </xsl:when>
						            <xsl:otherwise>
							              <xsl:value-of select="@value"/>
						            </xsl:otherwise>
					          </xsl:choose>
				        </li>
			      </xsl:otherwise>
		    </xsl:choose>
	  </xsl:template>
   <xsl:template match="ui:option" mode="comboDataList">
		    <xsl:call-template name="fauxOption">
			      <xsl:with-param name="value">
				        <xsl:value-of select="."/>
			      </xsl:with-param>
		    </xsl:call-template>
	  </xsl:template>
   <xsl:template match="ui:option" mode="comboValue">
		    <xsl:value-of select="."/>
	  </xsl:template>
   <xsl:template match="ui:option" mode="rowsPerPage">
		    <xsl:param name="rowsPerPage"/>
		    <xsl:variable name="value" select="@value"/>
		    <option value="{$value}">
			      <xsl:if test="$rowsPerPage=$value">
				        <xsl:attribute name="selected">
					          <xsl:text>selected</xsl:text>
				        </xsl:attribute>
			      </xsl:if>
			      <xsl:choose>
				        <xsl:when test="$value='0'">
					          <xsl:value-of select="$wdtp10"/>
				        </xsl:when>
				        <xsl:otherwise>
					          <xsl:value-of select="$value"/>
				        </xsl:otherwise>
			      </xsl:choose>
		    </option>
	  </xsl:template>
   <xsl:template match="html:link|html:base|html:meta" mode="inHead">
		    <xsl:variable name="el" select="local-name()"/>
		
		    <xsl:element name="{$el}">
			      <xsl:apply-templates select="@*"/>
		    </xsl:element>
	  </xsl:template>
   <xsl:template match="ui:optgroup" mode="readOnly">
		    <xsl:param name="showOptions" select="'selected'"/>
		    <xsl:param name="className"/>
		    <li class="wc_optgroup">
			      <xsl:value-of select="@label"/>
		    </li>
		    <xsl:choose>
			      <xsl:when test="$showOptions='all'">
				        <xsl:apply-templates select="ui:option" mode="readOnly">
					          <xsl:with-param name="className" select="$className"/>
					          <xsl:with-param name="single" select="0"/>
				        </xsl:apply-templates>
			      </xsl:when>
			      <xsl:otherwise>
				        <xsl:apply-templates select="ui:option[@selected]" mode="readOnly">
					          <xsl:with-param name="className" select="$className"/>
					          <xsl:with-param name="single" select="0"/>
				        </xsl:apply-templates>
			      </xsl:otherwise>
		    </xsl:choose>
	  </xsl:template>
   <xsl:template match="ui:optgroup" mode="selectableList">
		    <optgroup label="{@label}">
			      <xsl:apply-templates mode="selectableList"/>
		    </optgroup>
	  </xsl:template>
   <xsl:template match="ui:optgroup" mode="mfcInList">
		    <xsl:param name="option"/>
		    <xsl:param name="isSingular"/>
		    <xsl:element name="optgroup">
			      <xsl:attribute name="label">
				        <xsl:value-of select="@label"/>
			      </xsl:attribute>
			      <xsl:apply-templates select="ui:option" mode="mfcInList">
				        <xsl:with-param name="option" select="$option"/>
				        <xsl:with-param name="isSingular" select="$isSingular"/>
			      </xsl:apply-templates>
		    </xsl:element>
	  </xsl:template>
   <xsl:template match="ui:optgroup" mode="multiselectPair">
		    <xsl:param name="applyWhich" select="'all'"/>
		    <xsl:param name="readOnly"/>
		    <xsl:choose>
			      <xsl:when test="$readOnly!=1">
				        <optgroup label="{@label}">
					          <xsl:choose>
						            <xsl:when test="$applyWhich='selected'">
							              <xsl:apply-templates select="ui:option[@selected]" mode="multiselectPair"/>
						            </xsl:when>
						            <xsl:when test="$applyWhich='unselected'">
							              <xsl:apply-templates select="ui:option[not(@selected)]" mode="multiselectPair"/>
						            </xsl:when>
						            <xsl:otherwise>
							
							              <xsl:apply-templates mode="multiselectPair"/>
						            </xsl:otherwise>
					          </xsl:choose>
				        </optgroup>
			      </xsl:when>
			      <xsl:otherwise>
				        <li class="wc_optgroup">
					          <xsl:value-of select="@label"/>
				        </li>
				        <xsl:apply-templates select="ui:option[@selected]" mode="multiselectPair">
					          <xsl:with-param name="readOnly" select="$readOnly"/>
				        </xsl:apply-templates>
			      </xsl:otherwise>
		    </xsl:choose>
	  </xsl:template>
   <xsl:template match="ui:optgroup" mode="comboDataList">
		    <xsl:apply-templates mode="comboDataList"/>
	  </xsl:template>
   <xsl:template match="ui:ajaxTarget" mode="pseudoAjax">
		    <xsl:apply-templates/>
	  </xsl:template>
   <xsl:template match="ui:ajaxTargetId" mode="controlled">
		    <xsl:value-of select="@targetId"/>
		    <xsl:value-of select="' '"/>
	  </xsl:template>
   <xsl:template match="ui:ajaxTrigger" mode="JS">
		    <xsl:text>{"oneShot":</xsl:text>
		    <xsl:choose>
			      <xsl:when test="not(@allowedUses)">
				        <xsl:text>false</xsl:text>
			      </xsl:when>
			      <xsl:otherwise>
				        <xsl:copy-of select="$t"/>
			      </xsl:otherwise>
		    </xsl:choose>
		    <xsl:text>,"loads":[</xsl:text>
		    <xsl:apply-templates select="*"/>
		    <xsl:text>],"id":"</xsl:text>
		    <xsl:value-of select="@triggerId"/>
		    <xsl:text>","alias":"</xsl:text>
		    <xsl:value-of select="@triggerId"/>
		    <xsl:text>"}</xsl:text>
		    <xsl:if test="position() != last()">
			      <xsl:text>,</xsl:text>
		    </xsl:if>
	  </xsl:template>
   <xsl:template match="ui:ajaxTrigger" mode="JSdelay">
		    <xsl:text>{"id":"</xsl:text>
		    <xsl:value-of select="@triggerId"/>
		    <xsl:text>","delay":</xsl:text>
		    <xsl:value-of select="@delay"/>
		    <xsl:text>}</xsl:text>
		    <xsl:if test="position()!=last()">
			      <xsl:text>,</xsl:text>
		    </xsl:if>
	  </xsl:template>
   <xsl:template match="ui:ajaxTrigger" mode="controlled">
		    <xsl:apply-templates mode="controlled"/>
	  </xsl:template>
   <xsl:template match="ui:application/ui:param" mode="get">
		    <xsl:value-of select="concat(@name,'=',@value)"/>
		    <xsl:if test="position()!=last()">
			      <xsl:text>&amp;</xsl:text>
		    </xsl:if>
	  </xsl:template>
   <xsl:template match="ui:content" mode="collapsible">
		    <xsl:variable name="mode" select="../@mode"/>
		    <xsl:element name="div">
			      <xsl:attribute name="id">
				        <xsl:value-of select="@id"/>
			      </xsl:attribute>
			
			      <xsl:attribute name="aria-describedby">
				        <xsl:value-of select="../ui:decoratedLabel/@id"/>
			      </xsl:attribute>
			      <xsl:choose>
				        <xsl:when test="$mode='dynamic' or $mode='eager' or ($mode='lazy' and ../@collapsed)">
					          <xsl:attribute name="class">
						            <xsl:text>wc_magic</xsl:text>
						            <xsl:if test="$mode='dynamic'">
							              <xsl:text> wc_dynamic</xsl:text>
						            </xsl:if>
					          </xsl:attribute>
					          <xsl:attribute name="data-wc-ajaxalias">
						            <xsl:value-of select="../@id"/>
					          </xsl:attribute>
				        </xsl:when>
				        <xsl:when test="$mode='server'">
					          <xsl:attribute name="class">
						            <xsl:text>wc_lame</xsl:text>
					          </xsl:attribute>
				        </xsl:when>
			      </xsl:choose>
			      <xsl:apply-templates/>
		    </xsl:element>
	  </xsl:template>
   <xsl:template match="ui:content" mode="submenu">
		    <xsl:param name="open" select="0"/>
		    <xsl:param name="type"/>
		    <xsl:variable name="mode" select="../@mode"/>
		
		    <xsl:variable name="isAjaxMode">
			      <xsl:if test="$mode='dynamic' or $mode='eager' or ($mode='lazy' and $open!=1)">
				        <xsl:number value="1"/>
			      </xsl:if>
		    </xsl:variable>
		
		    <xsl:variable name="submenuId">
			      <xsl:value-of select="../@id"/>
		    </xsl:variable>
		
		    <xsl:element name="div">
			      <xsl:attribute name="id">
				        <xsl:value-of select="@id"/>
			      </xsl:attribute>
			      <xsl:attribute name="aria-labelledby">
				        <xsl:value-of select="$submenuId"/>
				        <xsl:text>-o</xsl:text>
			      </xsl:attribute>
			      <xsl:attribute name="class">
				        <xsl:text>submenucontent</xsl:text>
				        <xsl:choose>
					          <xsl:when test="$isAjaxMode=1">
						            <xsl:text> wc_magic</xsl:text>
						            <xsl:if test="$mode='dynamic'">
							              <xsl:text> wc_dynamic</xsl:text>
						            </xsl:if>
					          </xsl:when>
					          <xsl:when test="$mode='server'">
						            <xsl:text> wc_lame</xsl:text>
					          </xsl:when>
				        </xsl:choose>
			      </xsl:attribute>
			      <xsl:if test="$isAjaxMode=1">
				        <xsl:attribute name="data-wc-ajaxalias">
					          <xsl:value-of select="$submenuId"/>
				        </xsl:attribute>
			      </xsl:if>
			      <xsl:attribute name="role">
				        <xsl:choose>
					          <xsl:when test="$type='tree'">
						            <xsl:text>group</xsl:text>
					          </xsl:when>
					          <xsl:otherwise>
						            <xsl:text>menu</xsl:text>
					          </xsl:otherwise>
				        </xsl:choose>
			      </xsl:attribute>
			      <xsl:if test="not($type='tree')">
				        <xsl:attribute name="aria-expanded">
					          <xsl:choose>
						            <xsl:when test="$open=1">
							              <xsl:copy-of select="$t"/>
						            </xsl:when>
						            <xsl:otherwise>
							              <xsl:text>false</xsl:text>
						            </xsl:otherwise>
					          </xsl:choose>
				        </xsl:attribute>
				        <xsl:if test="not(*)">
					
					          <span role="menuitem" class="wc_menuitem_dummy" hidden="hidden"/>
				        </xsl:if>
			      </xsl:if>
			      <xsl:apply-templates select="*"/>
		    </xsl:element>
	  </xsl:template>
   <xsl:template match="ui:cell" mode="clInRow">
		    <xsl:param name="hgap"/>
		
		    <xsl:variable name="colPos" select="position() + 1"/>
		
		    <xsl:variable name="myColumn" select="../ui:column[position() = $colPos]"/>
		    <xsl:variable name="width">
			      <xsl:choose>
				        <xsl:when test="$myColumn/@width">
					          <xsl:value-of select="$myColumn/@width"/>
				        </xsl:when>
				        <xsl:otherwise>
					          <xsl:number value="0"/>
				        </xsl:otherwise>
			      </xsl:choose>
		    </xsl:variable>
		    <xsl:call-template name="column">
			      <xsl:with-param name="align" select="$myColumn/@align"/>
			      <xsl:with-param name="width" select="$width"/>
			      <xsl:with-param name="hgap" select="$hgap"/>
		    </xsl:call-template>
	  </xsl:template>
   <xsl:template match="ui:cell" mode="clRow">
		    <xsl:param name="align"/>
		    <xsl:param name="width"/>
		    <xsl:param name="hgap"/>
		    <xsl:param name="vgap"/>
		    <xsl:param name="cols"/>
		    <div class="row">
			      <xsl:if test="position() &gt; 1 and $vgap !=0">
				        <xsl:attribute name="style">
					          <xsl:text>margin-top:</xsl:text>
					          <xsl:value-of select="$vgap"/>
					          <xsl:text>;</xsl:text>
				        </xsl:attribute>
			      </xsl:if>

			      <xsl:call-template name="column">
				        <xsl:with-param name="align" select="$align"/>
				        <xsl:with-param name="width" select="$width"/>
				        <xsl:with-param name="hgap" select="$hgap"/>
				        <xsl:with-param name="ignoreLeftGap" select="1"/>
			      </xsl:call-template>
			      <xsl:if test="$cols &gt; 1">
				        <xsl:apply-templates select="following-sibling::ui:cell[position() &lt; $cols]" mode="clInRow">
					          <xsl:with-param name="hgap" select="$hgap"/>
				        </xsl:apply-templates>
			      </xsl:if>
		    </div>
	  </xsl:template>
   <xsl:template match="ui:cell" mode="fl">
		    <xsl:param name="align"/>
		    <xsl:param name="hgap"/>
		    <xsl:param name="vgap"/>
		    <xsl:variable name="style">
			      <xsl:if test="position() &gt; 1">
				        <xsl:choose>
					          <xsl:when test="$align = 'vertical'">
						            <xsl:if test="$vgap !=0">
							              <xsl:text>margin-top:</xsl:text>
							              <xsl:value-of select="$vgap"/>
							              <xsl:text>;</xsl:text>
						            </xsl:if>
					          </xsl:when>
					          <xsl:when test="$hgap != 0">
						            <xsl:text>margin-left:</xsl:text>
						            <xsl:value-of select="$hgap"/>
						            <xsl:text>;</xsl:text>
					          </xsl:when>
				        </xsl:choose>
			      </xsl:if>
		    </xsl:variable>
		    <div class="{local-name(.)}">
			      <xsl:if test="$style != ''">
				        <xsl:attribute name="style">
					          <xsl:value-of select="$style"/>
				        </xsl:attribute>
			      </xsl:if>
			      <xsl:apply-templates/>
		    </div>
	  </xsl:template>
   <xsl:template match="ui:cell" mode="gl">
		    <xsl:param name="cols" select="1"/>
		    <xsl:param name="colWidth" select="'100%'"/>
		    <xsl:param name="hgap" select="0"/>
		    <xsl:param name="vgap" select="0"/>

		    <xsl:choose>
			      <xsl:when test="$cols=1">
				        <xsl:call-template name="gridCell">
					          <xsl:with-param name="vgap" select="$vgap"/>
				        </xsl:call-template>
			      </xsl:when>
			      <xsl:otherwise>
				        <div class="row">
					
					          <xsl:if test="$vgap != 0 and position() &gt; 1">
						            <xsl:if test="$vgap != 0">
							              <xsl:attribute name="style">
								                <xsl:value-of select="concat('padding-top:',$vgap,';')"/>
							              </xsl:attribute>
						            </xsl:if>
					          </xsl:if>
					          <xsl:call-template name="gridCell">
						            <xsl:with-param name="width" select="$colWidth"/>
						            <xsl:with-param name="hgap" select="$hgap"/>
					          </xsl:call-template>
					          <xsl:if test="$cols &gt; 1">
						            <xsl:apply-templates select="following-sibling::ui:cell[position() &lt; $cols]" mode="inRow">
							              <xsl:with-param name="width" select="$colWidth"/>
							              <xsl:with-param name="hgap" select="$hgap"/>
						            </xsl:apply-templates>
					          </xsl:if>
				        </div>
			      </xsl:otherwise>
		    </xsl:choose>
	  </xsl:template>
   <xsl:template match="ui:cell" mode="inRow">
		    <xsl:param name="width"/>
		    <xsl:param name="hgap"/>
		    <xsl:call-template name="gridCell">
			      <xsl:with-param name="width" select="$width"/>
			      <xsl:with-param name="hgap" select="$hgap"/>
			      <xsl:with-param name="inRow" select="1"/>
		    </xsl:call-template>
	  </xsl:template>
   <xsl:template match="ui:cell" mode="ll">
		    <xsl:param name="hgap"/>
		    <xsl:param name="vgap"/>
		    <xsl:if test="node()">
			      <xsl:element name="li">
				
				        <xsl:if test="../@type='striped' and position() mod 2 = 0">
					          <xsl:attribute name="class">
						            <xsl:text> wc_iestripe</xsl:text>
					          </xsl:attribute>
				        </xsl:if>
				        <xsl:variable name="gapStyle">
					          <xsl:if test="position() &gt; 1">
						            <xsl:choose>
							              <xsl:when test="../@type='flat' and $hgap !=0">
									               <xsl:text>margin-left:</xsl:text>
								                <xsl:value-of select="$hgap"/>
								                <xsl:text>;</xsl:text>
							              </xsl:when>
							              <xsl:when test="$vgap !=0">
									               <xsl:text>margin-top:</xsl:text>
								                <xsl:value-of select="$vgap"/>
								                <xsl:text>;</xsl:text>
							              </xsl:when>
						            </xsl:choose>
					          </xsl:if>
				        </xsl:variable>
				        <xsl:if test="$gapStyle!=''">
					          <xsl:attribute name="style">
						            <xsl:value-of select="$gapStyle"/>
					          </xsl:attribute>
				        </xsl:if>
				        <xsl:apply-templates/>
			      </xsl:element>
		    </xsl:if>
	  </xsl:template>
   <xsl:template match="ui:css" mode="inHead">
		    <xsl:element name="link">
			      <xsl:attribute name="href">
				        <xsl:value-of select="@url"/>
			      </xsl:attribute>
			      <xsl:attribute name="type">
				        <xsl:text>text/css</xsl:text>
			      </xsl:attribute>
			      <xsl:attribute name="rel">
				        <xsl:text>stylesheet</xsl:text>
			      </xsl:attribute>
		    </xsl:element>
	  </xsl:template>
   <xsl:template match="ui:dialog" mode="JS">
		    <xsl:text>{"id":"</xsl:text>
		    <xsl:value-of select="@id"/>
		    <xsl:text>","form":"</xsl:text>
		    <xsl:choose>
			      <xsl:when test="ancestor::ui:application">
				        <xsl:value-of select="ancestor::ui:application/@id"/>
			      </xsl:when>
			      <xsl:otherwise>
				        <xsl:value-of select="ancestor::*[@id][1]/@id"/>
			      </xsl:otherwise>
		    </xsl:choose>
		    <xsl:text>"</xsl:text>
		    <xsl:if test="@class">
			      <xsl:text>,"className":</xsl:text>
			      <xsl:value-of select="@class"/>
		    </xsl:if>
		    <xsl:if test="@width">
			      <xsl:text>,"width":</xsl:text>
			      <xsl:value-of select="@width"/>
		    </xsl:if>
		    <xsl:if test="@height">
			      <xsl:text>,"height":</xsl:text>
			      <xsl:value-of select="@height"/>
		    </xsl:if>
		    <xsl:if test="@resizable">
			      <xsl:text>,"resizable":</xsl:text>
			      <xsl:value-of select="@resizable"/>
		    </xsl:if>
		    <xsl:if test="@modal">
			      <xsl:text>,"modal":</xsl:text>
			      <xsl:value-of select="@modal"/>
		    </xsl:if>
		    <xsl:if test="@title">
			      <xsl:text>,"title":"</xsl:text>
			      <xsl:value-of select="@title" disable-output-escaping="yes"/>
			      <xsl:text>"</xsl:text>
		    </xsl:if>
		    <xsl:if test="(ui:content and //ui:dialog[ui:content][1]=.) or (@open and not(//ui:dialog/ui:content) and //ui:dialog[@open][1]=.)">
			      <xsl:text>,"open":true</xsl:text>
		    </xsl:if>
		    <xsl:text>}</xsl:text>
		    <xsl:if test="position()!=last()">
			      <xsl:text>,</xsl:text>
		    </xsl:if>
	  </xsl:template>
   <xsl:template match="ui:dialog" mode="withcontent">
		    <xsl:element name="DIALOG">
			      <xsl:attribute name="id">
				        <xsl:text>dialogid</xsl:text>
			      </xsl:attribute>
			      <xsl:attribute name="class">
				        <xsl:call-template name="commonClassHelper"/>
				        <xsl:text>wc_dragflow wc_resizeflow</xsl:text>
			      </xsl:attribute>
			      <xsl:element name="HEADER">
				        <xsl:attribute name="tabindex">
					          <xsl:text>0</xsl:text>
				        </xsl:attribute>
				        <xsl:element name="span">
					          <xsl:element name="button">
						            <xsl:attribute name="class">
							              <xsl:text>wc_maxcont wc_btn_nada</xsl:text>
						            </xsl:attribute>
						            <xsl:attribute name="type">
							              <xsl:text>button</xsl:text>
						            </xsl:attribute>
						            <xsl:attribute name="title">
							              <xsl:value-of select="$dlg4"/>
						            </xsl:attribute>
						            <xsl:attribute name="aria-pressed">
							              <xsl:text>false</xsl:text>
						            </xsl:attribute>
						            <xsl:attribute name="data-wc-resize">
							              <xsl:text>dialogid</xsl:text>
						            </xsl:attribute>
						            <xsl:text> </xsl:text>
					          </xsl:element>
					          <xsl:element name="button">
						            <xsl:attribute name="class">
							              <xsl:text>wc_dialog_close wc_btn_nada</xsl:text>
						            </xsl:attribute>
						            <xsl:attribute name="type">
							              <xsl:text>button</xsl:text>
						            </xsl:attribute>
						            <xsl:attribute name="title">
							              <xsl:value-of select="$dlg3"/>
						            </xsl:attribute>
						            <xsl:text> </xsl:text>
					          </xsl:element>
				        </xsl:element>
				        <xsl:element name="h1">
					          <xsl:choose>
						            <xsl:when test="@title">
							              <xsl:value-of select="@title"/>
						            </xsl:when>
						            <xsl:otherwise>
							              <xsl:value-of select="$dlg0"/>
						            </xsl:otherwise>
					          </xsl:choose>
				        </xsl:element>
			      </xsl:element>
			      <xsl:element name="div">
				        <xsl:attribute name="aria-live">
					          <xsl:text>assertive</xsl:text>
				        </xsl:attribute>
				        <xsl:attribute name="id">
					          <xsl:value-of select="@id"/>
				        </xsl:attribute>
				        <xsl:apply-templates select="ui:content"/>
			      </xsl:element>
			      <xsl:element name="FOOTER">
				        <xsl:element name="button">
					          <xsl:attribute name="class">
						            <xsl:text>wc_resize wc_btn_nada</xsl:text>
					          </xsl:attribute>
					          <xsl:attribute name="data-wc-resize">
						            <xsl:text>dialogid</xsl:text>
					          </xsl:attribute>
					          <xsl:attribute name="type">
						            <xsl:text>button</xsl:text>
					          </xsl:attribute>
					          <xsl:text> </xsl:text>
				        </xsl:element>
			      </xsl:element>
		    </xsl:element>
	  </xsl:template>
   <xsl:template match="ui:file" mode="columns">
		    <xsl:param name="rows"/>
		    <ul class="wc_list_nb wc_filelist">
			      <xsl:call-template name="fileInList"/>
			      <xsl:apply-templates select="following-sibling::ui:file[position() &lt; $rows]"/>
		    </ul>
	  </xsl:template>
   <xsl:template match="html:wc-imageedit" mode="JS">
		    <xsl:text>{"id":"</xsl:text>
		    <xsl:value-of select="@id"/>
		    <xsl:text>"</xsl:text>
		    <xsl:if test="@class">
			      <xsl:text>,"className":</xsl:text>
			      <xsl:value-of select="@class"/>
		    </xsl:if>
		    <xsl:if test="@width">
			      <xsl:text>,"width":</xsl:text>
			      <xsl:value-of select="@width"/>
		    </xsl:if>
		    <xsl:if test="@height">
			      <xsl:text>,"height":</xsl:text>
			      <xsl:value-of select="@height"/>
		    </xsl:if>
		    <xsl:if test="@camera">
			      <xsl:text>,"camera":</xsl:text>
			      <xsl:value-of select="@camera"/>
		    </xsl:if>
		    <xsl:if test="@overlay">
			      <xsl:text>,"overlay":"</xsl:text>
			      <xsl:value-of select="@overlay"/>
			      <xsl:text>"</xsl:text>
		    </xsl:if>
		    <xsl:text>}</xsl:text>
		    <xsl:if test="position()!=last()">
			      <xsl:text>,</xsl:text>
		    </xsl:if>
	  </xsl:template>
   <xsl:template match="ui:js" mode="inHead">
		    <script type="text/javascript" src="{@url}"/>
	  </xsl:template>
   <xsl:template match="ui:label" mode="checkable">
		    <xsl:param name="labelableElement"/>
		    <xsl:call-template name="makeLabel">
			      <xsl:with-param name="labelableElement" select="$labelableElement"/>
		    </xsl:call-template>
	  </xsl:template>
   <xsl:template match="ui:label" mode="legend">
		    <xsl:param name="labelableElement"/>
		    <xsl:variable name="submitNotAjaxTrigger">
			      <xsl:if test="$labelableElement and $labelableElement/@submitOnChange and count(key('triggerKey',$labelableElement/@id))=0">
				        <xsl:number value="1"/>
			      </xsl:if>
		    </xsl:variable>
		    <xsl:variable name="isEmpty">
			      <xsl:if test="normalize-space(.)='' and not(.//ui:image)">
				        <xsl:number value="1"/>
			      </xsl:if>
		    </xsl:variable>
		    <xsl:variable name="className">
			      <xsl:choose>
				        <xsl:when test="$isEmpty = 1">
					          <xsl:text>wc_error</xsl:text>
				        </xsl:when>
				        <xsl:otherwise>wc_off</xsl:otherwise>
			      </xsl:choose>
		    </xsl:variable>
		    <legend class="{$className}">
			      <xsl:call-template name="accessKey"/>
			      <xsl:if test="$isEmpty = 1">
				        <xsl:value-of select="$cm1"/>
			      </xsl:if>
			      <xsl:apply-templates/>
			      <xsl:call-template name="WLabelHint">
				        <xsl:with-param name="submitNotAjaxTrigger" select="$submitNotAjaxTrigger"/>
			      </xsl:call-template>
			      <xsl:if test="$labelableElement and $labelableElement/@required">
				        <xsl:call-template name="offscreenSpan">
					          <xsl:with-param name="text">
						            <xsl:value-of select="$cm2"/>
					          </xsl:with-param>
				        </xsl:call-template>
			      </xsl:if>
		    </legend>
	  </xsl:template>
   <xsl:template match="ui:label" mode="selectToggle">
		    <xsl:variable name="value">
			      <xsl:value-of select="."/>
		    </xsl:variable>
		    <xsl:choose>
			      <xsl:when test="$value!='' or @hint">
				        <xsl:value-of select="normalize-space(concat($value,' ',@hint))"/>
			      </xsl:when>
			      <xsl:when test="@toolTip">
				        <xsl:value-of select="@toolTip"/>
			      </xsl:when>
			      <xsl:otherwise>
				        <xsl:value-of select="$tog4"/>
			      </xsl:otherwise>
		    </xsl:choose>
	  </xsl:template>
   <xsl:template match="ui:windowAttributes" mode="specs">
		    <xsl:call-template name="getPopupSpecs"/>
	  </xsl:template>
   <xsl:template match="ui:value" mode="readOnly">
		    <xsl:value-of select="."/>
	  </xsl:template>
   <xsl:template match="ui:value" mode="readOnlyList">
		    <xsl:element name="li">
			      <xsl:value-of select="."/>
		    </xsl:element>
	  </xsl:template>
   <xsl:template match="ui:panel" mode="skipLinks">
		    <xsl:element name="a">
			      <xsl:attribute name="href">
				        <xsl:text>#</xsl:text>
				        <xsl:value-of select="@id"/>
			      </xsl:attribute>
			      <xsl:value-of select="concat($sk1, @title)"/>
		    </xsl:element>
	  </xsl:template>
   <xsl:template match="ui:popup" mode="JS">
		    <xsl:text>["</xsl:text>
		    <xsl:value-of select="@url"/>
		    <xsl:text>","</xsl:text>
		    <xsl:choose>
			      <xsl:when test="@targetWindow">
				        <xsl:value-of select="@targetWindow"/>
			      </xsl:when>
			      <xsl:otherwise>
				
				        <xsl:value-of select="generate-id(.)"/>
			      </xsl:otherwise>
		    </xsl:choose>
		    <xsl:text>","</xsl:text>
		    <xsl:call-template name="getPopupSpecs"/>
		    <xsl:text>"]</xsl:text>
		    <xsl:if test="position()!=last()">
			      <xsl:text>,</xsl:text>
		    </xsl:if>
	  </xsl:template>
   <xsl:template match="ui:redirect" mode="JS">
		    <xsl:text>"</xsl:text>
		    <xsl:value-of select="@url"/>
		    <xsl:text>"</xsl:text>
	  </xsl:template>
   <xsl:template match="ui:labelBody" mode="section">
		    <xsl:element name="h1">
			      <xsl:attribute name="id">
				        <xsl:value-of select="@id"/>
			      </xsl:attribute>
			      <xsl:attribute name="class">
				        <xsl:text>wc_dlbl_seg labelBody</xsl:text>
			      </xsl:attribute>
			      <xsl:apply-templates/>
		    </xsl:element>
	  </xsl:template>
   <xsl:template match="ui:decoratedLabel" mode="section">
		    <xsl:element name="header">
			      <xsl:attribute name="id">
				        <xsl:value-of select="@id"/>
			      </xsl:attribute>
			      <xsl:call-template name="makeCommonClass"/>
			      <xsl:call-template name="hideElementIfHiddenSet"/>
			      <xsl:call-template name="ajaxTarget">
				        <xsl:with-param name="live" select="'off'"/>
			      </xsl:call-template>
			
			      <xsl:apply-templates select="ui:labelHead">
				        <xsl:with-param name="output" select="'div'"/>
			      </xsl:apply-templates>
			      <xsl:apply-templates select="ui:labelBody" mode="section"/>
			      <xsl:apply-templates select="ui:labelTail">
				        <xsl:with-param name="output" select="'div'"/>
			      </xsl:apply-templates>
		    </xsl:element>
	  </xsl:template>
   <xsl:template match="ui:selectToggle" mode="JS">
		    <xsl:text>{"identifier":"</xsl:text>
		    <xsl:value-of select="@id"/>
		    <xsl:text>","groupName":"</xsl:text>
		    <xsl:value-of select="@target"/>
		    <xsl:text>"}</xsl:text>
		    <xsl:if test="position() != last()">
			      <xsl:text>,</xsl:text>
		    </xsl:if>
	  </xsl:template>
   <xsl:template match="ui:src" mode="link">
		    <xsl:element name="a">
			      <xsl:attribute name="href">
				        <xsl:value-of select="@uri"/>
			      </xsl:attribute>
			      <xsl:attribute name="class">
				        <xsl:text>src</xsl:text>
			      </xsl:attribute>
			      <xsl:attribute name="data-wc-attach">
				        <xsl:text>data-wc-attach</xsl:text>
			      </xsl:attribute>
			      <xsl:if test="@type">
				        <xsl:attribute name="title">
					          <xsl:value-of select="@type"/>
				        </xsl:attribute>
			      </xsl:if>
			      <xsl:choose>
				        <xsl:when test="../@alt">
					          <xsl:value-of select="../@alt"/>
					          <xsl:if test="@type">
						            <xsl:value-of select="concat(' (',@type,')')"/>
					          </xsl:if>
				        </xsl:when>
				        <xsl:when test="../@toolTip">
					          <xsl:value-of select="../@toolTip"/>
					          <xsl:if test="@type">
						            <xsl:value-of select="concat(' (',@type,')')"/>
					          </xsl:if>
				        </xsl:when>
				        <xsl:when test="@type">
					          <xsl:value-of select="@type"/>
				        </xsl:when>
				        <xsl:otherwise>
					          <xsl:value-of select="@uri"/>
				        </xsl:otherwise>
			      </xsl:choose>
		    </xsl:element>
		    <xsl:if test="position()!=last()">
			      <xsl:text> </xsl:text>
		    </xsl:if>
	  </xsl:template>
   <xsl:template match="ui:subordinate" mode="JS">
		    <xsl:text>{ id: '</xsl:text>
		    <xsl:value-of select="@id"/>
		    <xsl:text>', test: function (test){ return </xsl:text>
		    <xsl:apply-templates select="ui:and|ui:or|ui:not|ui:condition" mode="subordinate"/>
		    <xsl:text>;}, onTrue: [</xsl:text>
		    <xsl:apply-templates select="ui:onTrue" mode="JS"/>
		    <xsl:text>], onFalse: [</xsl:text>
		    <xsl:apply-templates select="ui:onFalse" mode="JS"/>
		    <xsl:text>], controllers: [</xsl:text>
		    <xsl:apply-templates select="descendant::ui:condition" mode="ids"/>
		    <xsl:text>]}</xsl:text>
		    <xsl:if test="position() != last()">
			      <xsl:text>,</xsl:text>
		    </xsl:if>
	  </xsl:template>
   <xsl:template match="ui:and|ui:or|ui:condition|ui:not" mode="subordinate">
		    <xsl:if test="preceding-sibling::ui:and|preceding-sibling::ui:or|preceding-sibling::ui:condition|preceding-sibling::ui:not">
			      <xsl:choose>
				        <xsl:when test="parent::ui:or">
					          <xsl:text> || </xsl:text>
				        </xsl:when>
				        <xsl:otherwise>
					          <xsl:text> &amp;&amp; </xsl:text>
				        </xsl:otherwise>
			      </xsl:choose>
		    </xsl:if>
		    <xsl:choose>
			      <xsl:when test="self::ui:not | self::ui:and | self::ui:or">
				        <xsl:if test="self::ui:not">
					          <xsl:text>!</xsl:text>
				        </xsl:if>
				        <xsl:text>(</xsl:text>
				        <xsl:apply-templates mode="subordinate"/>
				        <xsl:text>)</xsl:text>
			      </xsl:when>
			      <xsl:when test="self::ui:condition">
				
				        <xsl:variable name="valSlashEscaped">
					          <xsl:call-template name="replaceString">
						            <xsl:with-param name="text" select="@value"/>
						            <xsl:with-param name="replace" select="'\'"/>
						            <xsl:with-param name="with" select="'\\'"/>
					          </xsl:call-template>
				        </xsl:variable>
				
				        <xsl:variable name="valEscaped">
					          <xsl:call-template name="replaceString">
						            <xsl:with-param name="text" select="$valSlashEscaped"/>
						            <xsl:with-param name="replace">
							              <xsl:text>'</xsl:text>
						            </xsl:with-param>
						            <xsl:with-param name="with">
							              <xsl:text>\'</xsl:text>
						            </xsl:with-param>
					          </xsl:call-template>
				        </xsl:variable>
				        <xsl:text>test('</xsl:text>
				        <xsl:value-of select="@controller"/>
				        <xsl:text>', '</xsl:text>
				        <xsl:value-of select="$valEscaped"/>
				        <xsl:if test="@operator">
					          <xsl:text>', '</xsl:text>
					          <xsl:value-of select="@operator"/>
				        </xsl:if>
				        <xsl:text>')</xsl:text>
			      </xsl:when>
		    </xsl:choose>
	  </xsl:template>
   <xsl:template match="ui:componentGroup" mode="JS">
		    <xsl:text>{"name":"</xsl:text>
		    <xsl:value-of select="@id"/>
		    <xsl:text>","identifiers":[</xsl:text>
		    <xsl:apply-templates select="ui:component"/>
		    <xsl:text>]}</xsl:text>
		    <xsl:if test="position() != last()">
			      <xsl:text>,</xsl:text>
		    </xsl:if>
	  </xsl:template>
   <xsl:template match="ui:condition" mode="ids">
		    <xsl:text>'</xsl:text>
		    <xsl:value-of select="@controller"/>
		    <xsl:text>'</xsl:text>
		    <xsl:if test="position() != last()">
			      <xsl:text>,</xsl:text>
		    </xsl:if>
	  </xsl:template>
   <xsl:template match="ui:condition" mode="action">
		    <xsl:text>{"min":"</xsl:text>
		    <xsl:value-of select="@minSelectedRows"/>
		    <xsl:text>","max":"</xsl:text>
		    <xsl:value-of select="@maxSelectedRows"/>
		    <xsl:text>","type":"</xsl:text>
		    <xsl:value-of select="@type"/>
		    <xsl:text>","message":"</xsl:text>
		    <xsl:value-of select="@message"/>
		    <xsl:text>"}</xsl:text>
		    <xsl:if test="position()!=last()">
			      <xsl:text>,</xsl:text>
		    </xsl:if>
	  </xsl:template>
   <xsl:template match="ui:onTrue|ui:onFalse" mode="JS">
		    <xsl:text>{type:'</xsl:text>
		    <xsl:value-of select="@action"/>
		    <xsl:text>', targets:[</xsl:text>
		    <xsl:apply-templates select="ui:target" mode="subordinate"/>
		    <xsl:text>]}</xsl:text>
		    <xsl:if test="position() != last()">
			      <xsl:text>,</xsl:text>
		    </xsl:if>
	  </xsl:template>
   <xsl:template match="ui:target" mode="subordinate">
		    <xsl:text>{id:'</xsl:text>
		    <xsl:value-of select="@id"/>
		    <xsl:text>', groupId:'</xsl:text>
		    <xsl:value-of select="@groupId"/>
		    <xsl:text>'}</xsl:text>
		    <xsl:if test="position() != last()">
			      <xsl:text>,</xsl:text>
		    </xsl:if>
	  </xsl:template>
   <xsl:template match="ui:tab" mode="content">
		    <xsl:param name="tabset"/>
		    <xsl:param name="tabsetId"/>
		    <xsl:param name="type"/>
		    <xsl:param name="firstOpenTab"/>

		    <xsl:apply-templates select="ui:tabContent">
			      <xsl:with-param name="open">
				        <xsl:if test="$firstOpenTab=. or ($type='accordion' and @open)">
					          <xsl:number value="1"/>
				        </xsl:if>
			      </xsl:with-param>
		    </xsl:apply-templates>
	  </xsl:template>
   <xsl:template match="ui:rowSelection" mode="JS">
		    <xsl:text>{"identifier":"</xsl:text>
		    <xsl:value-of select="concat(../@id,'-tb','-st')"/>
		    <xsl:text>","groupName":"</xsl:text>
		    <xsl:value-of select="concat(../@id,'-tb')"/>
		    <xsl:text>"}</xsl:text>
		    <xsl:if test="position() != last()">
			      <xsl:text>,</xsl:text>
		    </xsl:if>
	  </xsl:template>
   <xsl:template match="ui:th" mode="thead">
		    <xsl:param name="hasRole" select="0"/>

		    <xsl:variable name="tableId" select="../../@id"/>
		
		    <th id="{concat($tableId,'-thh', position())}" scope="col">
			      <xsl:if test="$hasRole &gt; 0">
				        <xsl:attribute name="role">
					          <xsl:text>columnheader</xsl:text>
				        </xsl:attribute>
			      </xsl:if>
			      <xsl:attribute name="class">
				        <xsl:choose>
					          <xsl:when test="@align">
						            <xsl:value-of select="@align"/>
					          </xsl:when>
					          <xsl:otherwise>
						            <xsl:text>left</xsl:text>
					          </xsl:otherwise>
				        </xsl:choose>
			      </xsl:attribute>
			      <xsl:attribute name="data-wc-columnidx">
				        <xsl:value-of select="position() - 1"/>
			      </xsl:attribute>
			
			      <xsl:if test="@sortable=$t">
				        <xsl:variable name="sortControl" select="../../ui:sort"/>
				
				        <xsl:if test="$sortControl">
					          <xsl:attribute name="tabindex">0</xsl:attribute>
					
					          <xsl:variable name="sortDesc" select="$sortControl/@descending"/>
					          <xsl:variable name="sortCol" select="$sortControl/@col"/>
					
					          <xsl:variable name="isSorted">
						            <xsl:choose>
							              <xsl:when test="position()-1 = $sortCol">
								                <xsl:number value="1"/>
							              </xsl:when>
							              <xsl:otherwise>
								                <xsl:number value="0"/>
							              </xsl:otherwise>
						            </xsl:choose>
					          </xsl:variable>
					
					          <xsl:if test="$isSorted=1">
						            <xsl:attribute name="sorted">
							              <xsl:if test="$sortDesc=$t">
								                <xsl:text>reversed </xsl:text>
							              </xsl:if>
							              <xsl:text>1</xsl:text>
						            </xsl:attribute>
					          </xsl:if>
					
					          <xsl:attribute name="aria-sort">
						            <xsl:choose>
							              <xsl:when test="$isSorted=0">
								                <xsl:text>none</xsl:text>
							              </xsl:when>
							              <xsl:when test="$sortDesc=$t">
								                <xsl:text>descending</xsl:text>
							              </xsl:when>
							              <xsl:otherwise>
								                <xsl:text>ascending</xsl:text>
							              </xsl:otherwise>
						            </xsl:choose>
					          </xsl:attribute>
					
					          <xsl:attribute name="title">
						            <xsl:choose>
							              <xsl:when test="$isSorted=0">
								                <xsl:value-of select="$tble7"/>
							              </xsl:when>
							              <xsl:when test="$sortDesc=$t">
								                <xsl:value-of select="$tble5"/>
							              </xsl:when>
							              <xsl:otherwise>
								                <xsl:value-of select="$tble6"/>
							              </xsl:otherwise>
						            </xsl:choose>
					          </xsl:attribute>
					
					          <xsl:variable name="sortMode">
						            <xsl:choose>
							              <xsl:when test="$sortControl/@mode">
								                <xsl:value-of select="$sortControl/@mode"/>
							              </xsl:when>
							              <xsl:otherwise>
								                <xsl:text>dynamic</xsl:text>
							              </xsl:otherwise>
						            </xsl:choose>
					          </xsl:variable>
					
					          <xsl:if test="$sortMode='dynamic'">
						            <xsl:call-template name="tableAjaxController">
							              <xsl:with-param name="tableId" select="$tableId"/>
						            </xsl:call-template>
					          </xsl:if>
					
					          <xsl:attribute name="data-wc-sortmode">
						            <xsl:value-of select="$sortMode"/>
					          </xsl:attribute>
				        </xsl:if>
			      </xsl:if>
			      <xsl:apply-templates select="ui:decoratedLabel">
				        <xsl:with-param name="output" select="'div'"/>
			      </xsl:apply-templates>
		    </th>
	  </xsl:template>
   <xsl:template match="ui:th|ui:td" mode="col">
		    <xsl:param name="stripe"/>
		    <xsl:param name="sortCol"/>
		    <xsl:variable name="class">
			      <xsl:if test="$stripe=1 and position() mod 2 = 0">
				        <xsl:text>wc_table_stripe</xsl:text>
			      </xsl:if>
			      <xsl:if test="$sortCol and position() = $sortCol + 1">
				        <xsl:text> wc_table_sort_sorted</xsl:text>
			      </xsl:if>
		    </xsl:variable>
		    <col>
			      <xsl:if test="$class !=''">
				        <xsl:attribute name="class">
					          <xsl:value-of select="normalize-space($class)"/>
				        </xsl:attribute>
			      </xsl:if>
			      <xsl:if test="@width">
				        <xsl:attribute name="style">
					          <xsl:value-of select="concat('width:',@width,'%')"/>
				        </xsl:attribute>
			      </xsl:if>
		    </col>
	  </xsl:template>
   <xsl:template match="ui:tr" mode="subRowControlIdentifier">
		    <xsl:param name="tableId"/>
		    <xsl:value-of select="concat($tableId,'-',@rowIndex)"/>
		    <xsl:if test="position()!=last()">
			      <xsl:value-of select="' '"/>
		    </xsl:if>
	  </xsl:template>
   <xsl:template match="text()" mode="para">
		    <xsl:param name="type" select="'plain'"/>
		    <xsl:param name="class"/>
		    <xsl:element name="p">
			      <xsl:attribute name="class">
				        <xsl:value-of select="$class"/>
			      </xsl:attribute>
			      <xsl:call-template name="WStyledTextContent">
				        <xsl:with-param name="type" select="$type"/>
			      </xsl:call-template>
		    </xsl:element>
	  </xsl:template>
   <xsl:template match="text()" mode="pre">
		    <xsl:param name="type" select="'plain'"/>
		    <xsl:call-template name="WStyledTextContent">
			      <xsl:with-param name="type" select="$type"/>
		    </xsl:call-template>
	  </xsl:template>
   <xsl:template match="text()" mode="space">
		    <xsl:param name="space"/>
		    <xsl:param name="type" select="'plain'"/>
		    <xsl:param name="class"/>
		    <xsl:choose>
			      <xsl:when test="$space='paragraphs'">
				        <xsl:element name="p">
					          <xsl:attribute name="class">
						            <xsl:value-of select="$class"/>
					          </xsl:attribute>
					          <xsl:call-template name="WStyledTextContent">
						            <xsl:with-param name="type" select="$type"/>
						            <xsl:with-param name="space" select="$space"/>
					          </xsl:call-template>
				        </xsl:element>
			      </xsl:when>
			      <xsl:otherwise>
				        <xsl:call-template name="WStyledTextContent">
					          <xsl:with-param name="type" select="$type"/>
					          <xsl:with-param name="space" select="$space"/>
				        </xsl:call-template>
			      </xsl:otherwise>
		    </xsl:choose>
	  </xsl:template>
   <xsl:template match="ui:error" mode="inline">
		    <li class="error">
			      <xsl:apply-templates/>
		    </li>
	  </xsl:template>
   <xsl:template match="ui:track" mode="link">
		    <a href="{@src}" class="track">
			      <xsl:if test="@lang">
				        <xsl:attribute name="lang">
					          <xsl:value-of select="@lang"/>
				        </xsl:attribute>
			      </xsl:if>
			      <xsl:attribute name="data-wc-attach">
				        <xsl:text>data-wc-attach</xsl:text>
			      </xsl:attribute>
			      <xsl:if test="@desc">
				        <xsl:value-of select="@desc"/>
			      </xsl:if>
			      <xsl:if test="@kind">
				        <xsl:text> (</xsl:text>
				        <xsl:value-of select="@kind"/>
				        <xsl:text> )</xsl:text>
			      </xsl:if>
		    </a>
		    <xsl:if test="position()!=last()">
			      <xsl:value-of select="' '"/>
		    </xsl:if>
	  </xsl:template>
   <xsl:template name="accessKey">
		    <xsl:if test="@accessKey">
			      <xsl:attribute name="accesskey">
				        <xsl:value-of select="@accessKey"/>
			      </xsl:attribute>
			      <xsl:attribute name="aria-describedby">
				        <xsl:value-of select="concat(@id,'-wctt')"/>
			      </xsl:attribute>
			      <xsl:call-template name="tooltip"/>
		    </xsl:if>
	  </xsl:template>
   <xsl:template name="ajaxController">
		    <xsl:param name="id" select="@id"/>
		    <xsl:variable name="trigger" select="key('triggerKey',$id)"/>
		    <xsl:if test="$trigger">
			      <xsl:variable name="idList">
				        <xsl:apply-templates select="$trigger" mode="controlled"/>
			      </xsl:variable>
			      <xsl:if test="$idList != ''">
				        <xsl:attribute name="aria-controls">
					          <xsl:value-of select="normalize-space($idList)"/>
				        </xsl:attribute>
			      </xsl:if>
			      <xsl:attribute name="data-wc-ajaxalias">
				        <xsl:value-of select="$id"/>
			      </xsl:attribute>
		    </xsl:if>
	  </xsl:template>
   <xsl:template name="ajaxTarget">
		    <xsl:param name="id" select="@id"/>
		    <xsl:param name="live" select="'polite'"/>
		    <xsl:if test="key('targetKey',$id) or parent::ui:ajaxTarget[@action='replace']">
			      <xsl:call-template name="setARIALive">
				        <xsl:with-param name="live" select="$live"/>
			      </xsl:call-template>
		    </xsl:if>
	  </xsl:template>
   <xsl:template name="ariaLabel">
		    <xsl:if test="@accessibleText">
			      <xsl:attribute name="aria-label">
				        <xsl:value-of select="@accessibleText"/>
			      </xsl:attribute>
		    </xsl:if>
	  </xsl:template>
   <xsl:template name="setARIALive">
		    <xsl:param name="live" select="'polite'"/>
		    <xsl:attribute name="aria-live">
			      <xsl:value-of select="$live"/>
		    </xsl:attribute>
	  </xsl:template>
   <xsl:template name="commonControlAttributes">
		    <xsl:param name="id" select="@id"/>
		    <xsl:param name="isError"/>
		    <xsl:param name="name"/>
		    <xsl:param name="value" select="@value"/>
		    <xsl:param name="live" select="'polite'"/>
		    <xsl:param name="myLabel" select="key('labelKey',$id)[1]"/>

		    <xsl:call-template name="commonAttributes">
			      <xsl:with-param name="id" select="$id"/>
			      <xsl:with-param name="live" select="$live"/>
			      <xsl:with-param name="isControl" select="1"/>
		    </xsl:call-template>
		    <xsl:if test="not($name='')">
			      <xsl:attribute name="name">
				        <xsl:value-of select="$name"/>
			      </xsl:attribute>
		    </xsl:if>
		    <xsl:if test="$value">
			      <xsl:attribute name="value">
				        <xsl:value-of select="$value"/>
			      </xsl:attribute>
		    </xsl:if>
		    <xsl:if test="$isError and $isError !=''">
			      <xsl:call-template name="invalid"/>
		    </xsl:if>

		    <xsl:attribute name="class">
			      <xsl:call-template name="commonClassHelper"/>
			      <xsl:if test="@submitOnChange and not(@list)">
				        <xsl:text> wc_soc</xsl:text>
			      </xsl:if>
		    </xsl:attribute>

		    <xsl:call-template name="requiredElement"/>
		    <xsl:call-template name="ajaxController">
			      <xsl:with-param name="id">
				        <xsl:choose>
					          <xsl:when test="self::ui:radioButton">
						            <xsl:value-of select="@groupName"/>
					          </xsl:when>
					          <xsl:otherwise>
						            <xsl:value-of select="@id"/>
					          </xsl:otherwise>
				        </xsl:choose>
			      </xsl:with-param>
		    </xsl:call-template>
		    <xsl:if test="@buttonId">
			      <xsl:attribute name="data-wc-submit">
				        <xsl:value-of select="@buttonId"/>
			      </xsl:attribute>
		    </xsl:if>
		
		    <xsl:call-template name="title"/>
		    <xsl:if test="not($myLabel)">
			      <xsl:call-template name="ariaLabel"/>
		    </xsl:if>
	  </xsl:template>
   <xsl:template name="commonWrapperAttributes">
		    <xsl:param name="id" select="@id"/>
		    <xsl:param name="isError"/>
		    <xsl:param name="live" select="'polite'"/>
		    <xsl:param name="isControl" select="1"/>
		    <xsl:param name="class"/>
		    <xsl:param name="myLabel"/>
		
		    <xsl:call-template name="commonAttributes">
			      <xsl:with-param name="id" select="$id"/>
			      <xsl:with-param name="live" select="$live"/>
			      <xsl:with-param name="isControl" select="$isControl"/>
			      <xsl:with-param name="isWrapper" select="1"/>
		    </xsl:call-template>
		    <xsl:attribute name="class">
			      <xsl:call-template name="commonClassHelper"/>
			      <xsl:if test="not(@readOnly)">
				        <xsl:text> notext noborder</xsl:text>
				        <xsl:if test="@required">
					          <xsl:text> wc_req</xsl:text>
				        </xsl:if>
			      </xsl:if>
			      <xsl:if test="$class!= ''">
				        <xsl:value-of select="concat(' ', $class)"/>
			      </xsl:if>
		    </xsl:attribute>
		    <xsl:call-template name="ajaxController">
			      <xsl:with-param name="id" select="$id"/>
		    </xsl:call-template>
		    <xsl:if test="@readOnly and $myLabel">
			      <xsl:attribute name="aria-labelledby">
				        <xsl:value-of select="$myLabel/@id"/>
			      </xsl:attribute>
		    </xsl:if>
		    <xsl:if test="$isError and $isError !=''">
			      <xsl:call-template name="invalid"/>
		    </xsl:if>
	  </xsl:template>
   <xsl:template name="commonAttributes">
		    <xsl:param name="id" select="@id"/>
		    <xsl:param name="live" select="'polite'"/>
		    <xsl:param name="isControl" select="0"/>
		    <xsl:param name="readOnly" select="@readOnly"/>
		    <xsl:param name="isWrapper" select="0"/>
		    <xsl:attribute name="id">
			      <xsl:value-of select="$id"/>
		    </xsl:attribute>
		    <xsl:call-template name="hideElementIfHiddenSet"/>
		    <xsl:call-template name="ajaxTarget">
			      <xsl:with-param name="live" select="$live"/>
		    </xsl:call-template>
		    <xsl:if test="not($readOnly=$t or $isWrapper=1)">
			      <xsl:call-template name="disabledElement">
				        <xsl:with-param name="isControl" select="$isControl"/>
			      </xsl:call-template>
		    </xsl:if>
	  </xsl:template>
   <xsl:template name="drawButtonImage">
		    <xsl:param name="imageAltText" select="''"/>
		    <xsl:variable name="text">
			      <xsl:value-of select="text()"/>
		    </xsl:variable>
		    <xsl:element name="img">
			      <xsl:attribute name="src">
				        <xsl:value-of select="@imageUrl"/>
			      </xsl:attribute>
			      <xsl:attribute name="alt">
				        <xsl:choose>
					          <xsl:when test="$imageAltText!=''">
						            <xsl:value-of select="$imageAltText"/>
					          </xsl:when>
					          <xsl:when test="$text!=''">
						            <xsl:choose>
							
							              <xsl:when test="@imagePosition">
								                <xsl:value-of select="''"/>
							              </xsl:when>
							
							              <xsl:otherwise>
								                <xsl:value-of select="$text"/>
							              </xsl:otherwise>
						            </xsl:choose>
					          </xsl:when>
				        </xsl:choose>
			      </xsl:attribute>
		    </xsl:element>
	  </xsl:template>
   <xsl:template name="buttonLinkCommon">
		    <xsl:param name="imageAltText" select="''"/>
		    <xsl:attribute name="id">
			      <xsl:value-of select="@id"/>
		    </xsl:attribute>

		    <xsl:if test="@toolTip">
			      <xsl:attribute name="title">
				        <xsl:value-of select="normalize-space(@toolTip)"/>
			      </xsl:attribute>
		    </xsl:if>

		    <xsl:variable name="isControl">
			      <xsl:choose>
				        <xsl:when test="self::ui:link and (@type='button' or ui:windowAttributes[count(@*) &gt; 1])">
					          <xsl:number value="1"/>
				        </xsl:when>
				        <xsl:when test="self::ui:link">
					          <xsl:number value="0"/>
				        </xsl:when>
				        <xsl:otherwise>
					          <xsl:number value="1"/>
				        </xsl:otherwise>
			      </xsl:choose>
		    </xsl:variable>
		    <xsl:choose>
			      <xsl:when test="@disabled">
				        <xsl:call-template name="disabledElement">
					          <xsl:with-param name="isControl" select="$isControl"/>
				        </xsl:call-template>
			      </xsl:when>
			      <xsl:when test="parent::ui:action">
				        <xsl:call-template name="disabledElement">
					          <xsl:with-param name="field" select="ancestor::ui:table[1]"/>
					          <xsl:with-param name="isControl" select="1"/>
				        </xsl:call-template>
			      </xsl:when>
		    </xsl:choose>
		    <xsl:call-template name="hideElementIfHiddenSet"/>
		    <xsl:call-template name="ajaxController"/>
		    <xsl:call-template name="ajaxTarget">
			      <xsl:with-param name="live" select="'off'"/>
		    </xsl:call-template>
		    <xsl:call-template name="accessKey"/>
		    <xsl:choose>
			      <xsl:when test="@imageUrl">
				        <xsl:choose>
					          <xsl:when test="@imagePosition='n' or @imagePosition='w'">
						            <xsl:call-template name="drawButtonImage">
							              <xsl:with-param name="imageAltText" select="$imageAltText"/>
						            </xsl:call-template>
						            <xsl:apply-templates/>
					          </xsl:when>
					          <xsl:when test="@imagePosition">
						            <xsl:apply-templates/>
						            <xsl:call-template name="drawButtonImage">
							              <xsl:with-param name="imageAltText" select="$imageAltText"/>
						            </xsl:call-template>
					          </xsl:when>
					          <xsl:otherwise>
						            <xsl:call-template name="drawButtonImage">
							              <xsl:with-param name="imageAltText" select="$imageAltText"/>
						            </xsl:call-template>
					          </xsl:otherwise>
				        </xsl:choose>
			      </xsl:when>
			      <xsl:otherwise>
				        <xsl:apply-templates/>
			      </xsl:otherwise>
		    </xsl:choose>
	  </xsl:template>
   <xsl:template name="checkableSelectOption">
		    <xsl:param name="optionName"/>
		    <xsl:param name="optionType"/>
		    <xsl:param name="readOnly"/>
		    <xsl:param name="cgAccessKey"/>
		    <xsl:variable name="uid">
			      <xsl:value-of select="concat(../@id,generate-id())"/>
		    </xsl:variable>
		    <xsl:variable name="elementName">
			      <xsl:choose>
				        <xsl:when test="$readOnly=1">
					          <xsl:text>li</xsl:text>
				        </xsl:when>
				        <xsl:when test="../@layout='flat'">
					          <xsl:text>span</xsl:text>
				        </xsl:when>
				        <xsl:otherwise>
					          <xsl:text>div</xsl:text>
				        </xsl:otherwise>
			      </xsl:choose>
		    </xsl:variable>
		    <xsl:element name="{$elementName}">
			      <xsl:choose>
				        <xsl:when test="$readOnly=1">
					          <xsl:call-template name="checkableSelectOptionLabel"/>
				        </xsl:when>
				        <xsl:otherwise>
					          <xsl:element name="input">
						            <xsl:attribute name="type">
							              <xsl:value-of select="$optionType"/>
						            </xsl:attribute>
						            <xsl:attribute name="id">
							              <xsl:value-of select="$uid"/>
						            </xsl:attribute>
						            <xsl:attribute name="name">
							              <xsl:value-of select="$optionName"/>
						            </xsl:attribute>
						            <xsl:attribute name="value">
							              <xsl:value-of select="@value"/>
						            </xsl:attribute>
						            <xsl:if test="../@submitOnChange">
							              <xsl:attribute name="class">
								                <xsl:text>wc_soc</xsl:text>
							              </xsl:attribute>
						            </xsl:if>
						            <xsl:if test="@isNull and $optionType='radio'">
							              <xsl:attribute name="data-wc-null">
								                <xsl:text>1</xsl:text>
							              </xsl:attribute>
						            </xsl:if>
						            <xsl:if test="$cgAccessKey!=''">
							              <xsl:attribute name="accesskey">
								                <xsl:value-of select="$cgAccessKey"/>
							              </xsl:attribute>
						            </xsl:if>
						            <xsl:if test="@selected">
							              <xsl:attribute name="checked">checked</xsl:attribute>
						            </xsl:if>
						            <xsl:call-template name="disabledElement">
							              <xsl:with-param name="isControl" select="1"/>
							              <xsl:with-param name="field" select="parent::*"/>
						            </xsl:call-template>
						            <xsl:if test="parent::ui:radioButtonSelect">
							              <xsl:call-template name="requiredElement">
								                <xsl:with-param name="field" select="parent::ui:radioButtonSelect"/>
							              </xsl:call-template>
						            </xsl:if>
					          </xsl:element>
					          <xsl:element name="label">
						            <xsl:attribute name="for">
							              <xsl:value-of select="$uid"/>
						            </xsl:attribute>
						            <xsl:call-template name="checkableSelectOptionLabel"/>
					          </xsl:element>
				        </xsl:otherwise>
			      </xsl:choose>
		    </xsl:element>
	  </xsl:template>
   <xsl:template name="checkableSelectOptionLabel">
		    <xsl:choose>
			      <xsl:when test="normalize-space(.)">
				        <xsl:value-of select="."/>
			      </xsl:when>
			      <xsl:when test="@value">
				        <xsl:value-of select="@value"/>
			      </xsl:when>
			      <xsl:otherwise>
				        <xsl:value-of select="$cm1"/>
			      </xsl:otherwise>
		    </xsl:choose>
	  </xsl:template>
   <xsl:template name="collapsibleToggle">
		    <xsl:param name="id" select="@id"/>
		    <xsl:param name="for" select="@groupName"/>

		    <xsl:variable name="mode">
			      <xsl:choose>
				        <xsl:when test="@roundTrip or @mode='server'">
					          <xsl:text>server</xsl:text>
				        </xsl:when>
				        <xsl:when test="@mode='dynamic' or @mode='lazy'">
					          <xsl:value-of select="@mode"/>
				        </xsl:when>
				        <xsl:otherwise>
					          <xsl:text>client</xsl:text>
				        </xsl:otherwise>
			      </xsl:choose>
		    </xsl:variable>
		
		    <xsl:variable name="group" select="key('collapsibleGroupKey', $for)"/>
		    <xsl:variable name="targetList">
			      <xsl:choose>
				        <xsl:when test="$mode='server'">
					          <xsl:value-of select="''"/>
				        </xsl:when>
				        <xsl:when test="self::ui:rowExpansion">
					          <xsl:value-of select="$for"/>
				        </xsl:when>
				        <xsl:when test="$group">
					          <xsl:apply-templates select="$group" mode="getIdList"/>
				        </xsl:when>
				
			      </xsl:choose>
		    </xsl:variable>
		    <xsl:variable name="toggleClass">
			      <xsl:value-of select="local-name(.)"/>
		    </xsl:variable>
		    <ul id="{$id}" role="radiogroup">
			      <xsl:call-template name="makeCommonClass"/>
			      <xsl:call-template name="ajaxTarget"/>
			      <li>
				        <xsl:call-template name="toggleElement">
					          <xsl:with-param name="mode" select="$mode"/>
					          <xsl:with-param name="id" select="concat($id,'-expand')"/>
					          <xsl:with-param name="for" select="$targetList"/>
					          <xsl:with-param name="name" select="$id"/>
					          <xsl:with-param name="value" select="'expand'"/>
					          <xsl:with-param name="text" select="$cm0"/>
					          <xsl:with-param name="class" select="$toggleClass"/>
				        </xsl:call-template>
			      </li>
			      <li>
				        <xsl:call-template name="toggleElement">
					          <xsl:with-param name="mode" select="'client'"/>
					          <xsl:with-param name="id" select="concat($id,'-collapse')"/>
					          <xsl:with-param name="for" select="$targetList"/>
					          <xsl:with-param name="name" select="$id"/>
					          <xsl:with-param name="value" select="'collapse'"/>
					          <xsl:with-param name="text" select="$tog5"/>
					          <xsl:with-param name="class" select="$toggleClass"/>
				        </xsl:call-template>
			      </li>
		    </ul>
	  </xsl:template>
   <xsl:template name="column">
		    <xsl:param name="align" select="@align"/>
		    <xsl:param name="width" select="@width"/>
		    <xsl:param name="hgap" select="0"/>
		    <xsl:param name="ignoreLeftGap" select="0"/>
	
		    <xsl:variable name="style">
			      <xsl:if test="$width and $width != 0">
				        <xsl:value-of select="concat('width:',$width,'%;')"/>
			      </xsl:if>
			      <xsl:if test="$hgap != 0">
				        <xsl:if test="(self::ui:cell and $ignoreLeftGap = 0) or (self:: ui:column and position() &gt; 1)">
					          <xsl:value-of select="concat('padding-left:',$hgap,';')"/>
				        </xsl:if>
				        <xsl:if test="(self::ui:cell and $ignoreLeftGap = 1) or position() != last()">
					          <xsl:value-of select="concat('padding-right:',$hgap,';')"/>
				        </xsl:if>
			      </xsl:if>
		    </xsl:variable>
	
		    <div>
			      <xsl:if test="self::ui:column">
				        <xsl:attribute name="id">
					          <xsl:value-of select="@id"/>
				        </xsl:attribute>
				        <xsl:call-template name="ajaxTarget"/>
			      </xsl:if>
			      <xsl:attribute name="class">
				        <xsl:call-template name="commonClassHelper"/>
				        <xsl:choose>
					          <xsl:when test="$align">
						            <xsl:value-of select="concat(' ',$align)"/>
					          </xsl:when>
					          <xsl:otherwise>
						            <xsl:text> left</xsl:text>
					          </xsl:otherwise>
				        </xsl:choose>
			      </xsl:attribute>
			      <xsl:if test="$style != ''">
				        <xsl:attribute name="style">
					          <xsl:value-of select="$style"/>
				        </xsl:attribute>
			      </xsl:if>
			      <xsl:apply-templates/>
		    </div>
	  </xsl:template>
   <xsl:template name="disabledElement">
		    <xsl:param name="isControl" select="0"/>
		    <xsl:param name="field" select="."/>
		
		    <xsl:if test="$field/@disabled">
			      <xsl:choose>
				        <xsl:when test="$isControl=1">
					          <xsl:attribute name="disabled">
						            <xsl:text>disabled</xsl:text>
					          </xsl:attribute>
				        </xsl:when>
				        <xsl:otherwise>
					          <xsl:attribute name="aria-disabled">
						            <xsl:copy-of select="$t"/>
					          </xsl:attribute>
				        </xsl:otherwise>
			      </xsl:choose>
		    </xsl:if>
	  </xsl:template>
   <xsl:template name="fauxOption">
		    <xsl:param name="value" select="@value"/>
		    <li data-wc-value="{$value}" role="option" tabIndex="0">
			      <xsl:value-of select="$value"/>
		    </li>
	  </xsl:template>
   <xsl:template name="getHVGap">
		    <xsl:param name="gap" select="@hgap"/>
		    <xsl:param name="divisor" select="1"/>
		    <xsl:choose>
			      <xsl:when test="$gap">
				        <xsl:variable name="px" select="format-number($gap,'0')"/>
				        <xsl:value-of select="$px div $divisor"/>
				        <xsl:text>px</xsl:text>
			      </xsl:when>
			      <xsl:otherwise>
				        <xsl:number value="0"/>
			      </xsl:otherwise>
		    </xsl:choose>
	  </xsl:template>
   <xsl:template name="hField">
		    <xsl:param name="name" select="@id"/>
		    <xsl:element name="input">
			      <xsl:attribute name="type">
				        <xsl:text>hidden</xsl:text>
			      </xsl:attribute>
			      <xsl:attribute name="name">
				        <xsl:value-of select="concat($name,'-h')"/>
			      </xsl:attribute>
			      <xsl:attribute name="value">
				        <xsl:text>x</xsl:text>
			      </xsl:attribute>
			      <xsl:if test="@disabled='true'">
				        <xsl:attribute name="disabled">
					          <xsl:text>disabled</xsl:text>
				        </xsl:attribute>
			      </xsl:if>
		    </xsl:element>
	  </xsl:template>
   <xsl:template name="hiddenElement">
		    <xsl:attribute name="hidden">
			      <xsl:text>hidden</xsl:text>
		    </xsl:attribute>
	  </xsl:template>
   <xsl:template name="hideElementIfHiddenSet">
		    <xsl:if test="@hidden">
			      <xsl:call-template name="hiddenElement"/>
		    </xsl:if>
	  </xsl:template>
   <xsl:template name="inlineError">
		    <xsl:param name="errors"/>
		    <xsl:param name="id" select="@id"/>
		    <xsl:if test="$errors">
			      <xsl:element name="ul">
				        <xsl:attribute name="class">
					          <xsl:text>error</xsl:text>
				        </xsl:attribute>
				        <xsl:attribute name="id">
					          <xsl:value-of select="concat($id,'-err')"/>
				        </xsl:attribute>
				        <xsl:apply-templates select="$errors" mode="inline"/>
			      </xsl:element>
		    </xsl:if>
	  </xsl:template>
   <xsl:template name="invalid">
		    <xsl:param name="id" select="@id"/>
		    <xsl:attribute name="aria-invalid">
			      <xsl:copy-of select="$t"/>
		    </xsl:attribute>
		    <xsl:attribute name="aria-describedby">
			      <xsl:value-of select="concat($id,'-err')"/>
		    </xsl:attribute>
	  </xsl:template>
   <xsl:template name="listSortControl">
		    <xsl:param name="id"/>
		    <xsl:param name="value"/>
		    <xsl:param name="toolTip"/>
		    <button class="wc_sorter wc_ibtn"
              type="button"
              value="{$value}"
              aria-controls="{$id}"
              title="{$toolTip}">
			      <xsl:call-template name="disabledElement">
				        <xsl:with-param name="isControl" select="1"/>
			      </xsl:call-template>
		    </button>
	  </xsl:template>
   <xsl:template name="listSortControls">
		    <xsl:param name="id" select="@id"/>
		    <span class="wc_sortcont">
			      <xsl:call-template name="listSortControl">
				        <xsl:with-param name="id" select="$id"/>
				        <xsl:with-param name="value" select="'top'"/>
				        <xsl:with-param name="toolTip" select="$lsc1"/>
			      </xsl:call-template>
			      <xsl:call-template name="listSortControl">
				        <xsl:with-param name="id" select="$id"/>
				        <xsl:with-param name="value" select="'up'"/>
				        <xsl:with-param name="toolTip" select="$lsc2"/>
			      </xsl:call-template>
			      <xsl:call-template name="listSortControl">
				        <xsl:with-param name="id" select="$id"/>
				        <xsl:with-param name="value" select="'down'"/>
				        <xsl:with-param name="toolTip" select="$lsc3"/>
			      </xsl:call-template>
			      <xsl:call-template name="listSortControl">
				        <xsl:with-param name="id" select="$id"/>
				        <xsl:with-param name="value" select="'bottom'"/>
				        <xsl:with-param name="toolTip" select="$lsc4"/>
			      </xsl:call-template>
		    </span>
	  </xsl:template>
   <xsl:template name="makeLegend">
		    <xsl:param name="myLabel"/>
		    <xsl:choose>
			      <xsl:when test="$myLabel">
				        <xsl:apply-templates select="$myLabel" mode="legend">
					          <xsl:with-param name="labelableElement" select="."/>
				        </xsl:apply-templates>
			      </xsl:when>
			      <xsl:when test="@toolTip">
				        <xsl:call-template name="makeTextLegend">
					          <xsl:with-param name="content">
						            <xsl:value-of select="normalize-space(@toolTip)"/>
					          </xsl:with-param>
				        </xsl:call-template>
			      </xsl:when>
			      <xsl:when test="@accessibleText">
				        <xsl:call-template name="makeTextLegend">
					          <xsl:with-param name="content">
						            <xsl:value-of select="normalize-space(@accessibleText)"/>
					          </xsl:with-param>
				        </xsl:call-template>
			      </xsl:when>
			      <xsl:when test="not(ancestor::ui:ajaxTarget)">
				        <xsl:call-template name="makeTextLegend">
					          <xsl:with-param name="content">
						            <xsl:value-of select="$cm1"/>
					          </xsl:with-param>
				        </xsl:call-template>
			      </xsl:when>
		    </xsl:choose>
	  </xsl:template>
   <xsl:template name="makeTextLegend">
		    <xsl:param name="content"/>
		    <legend class="wc_off">
			      <xsl:value-of select="$content"/>
			      <xsl:if test="@required">
				        <xsl:call-template name="offscreenSpan">
					          <xsl:with-param name="text">
						            <xsl:value-of select="$cm2"/>
					          </xsl:with-param>
				        </xsl:call-template>
			      </xsl:if>
		    </legend>
	  </xsl:template>
   <xsl:template name="mediaUnsupportedContent">
		    <xsl:apply-templates select="ui:src" mode="link"/>
		    <xsl:if test="ui:src and ui:track">
			      <xsl:element name="br"/>
		    </xsl:if>
		    <xsl:apply-templates select="ui:track" mode="link"/>
	  </xsl:template>
   <xsl:template name="checkLabel">
		    <xsl:param name="id" select="@id"/>
		    <xsl:param name="for" select="@id"/>
		    <xsl:param name="force" select="0"/>
		    <xsl:if test="not(@toolTip or @accessibleText or ancestor::ui:ajaxTarget or ancestor::ui:label[not(@for)]) and (force=1 or not(key('labelKey',$id))) ">
			
			      <label class="wc_error" id="{concat($for,'dlbl')}" for="{$for}">
				        <xsl:value-of select="$cm1"/>
			      </label>
		    </xsl:if>
	  </xsl:template>
   <xsl:template name="multiFieldIcon">
		    <xsl:param name="isSingular"/>
		    <xsl:param name="myLabel"/>
		
		    <xsl:variable name="id">
			      <xsl:choose>
				        <xsl:when test="self::ui:multiTextField">
					          <xsl:value-of select="@id"/>
				        </xsl:when>
				        <xsl:otherwise>
					          <xsl:value-of select="../@id"/>
				        </xsl:otherwise>
			      </xsl:choose>
		    </xsl:variable>
		
		    <xsl:variable name="toolTip">
			      <xsl:choose>
				        <xsl:when test="$isSingular=1 or position() = 1">
					          <xsl:value-of select="$mfc0"/>
					          <xsl:if test="$myLabel">
						            <xsl:value-of select="$myLabel"/>
					          </xsl:if>
				        </xsl:when>
				        <xsl:otherwise>
					          <xsl:value-of select="$mfc1"/>
				        </xsl:otherwise>
			      </xsl:choose>
		    </xsl:variable>
		
		    <button type="button" title="{$toolTip}">
			      <xsl:attribute name="aria-controls">
				        <xsl:choose>
					          <xsl:when test="self::ui:multiTextField or position() = 1">
						            <xsl:value-of select="$id"/>
					          </xsl:when>
					          <xsl:otherwise>
						            <xsl:value-of select="concat($id, generate-id(), '-', position())"/>
					          </xsl:otherwise>
				        </xsl:choose>
			      </xsl:attribute>
			      <xsl:choose>
				        <xsl:when test="self::ui:multiTextField">
					          <xsl:call-template name="disabledElement">
						            <xsl:with-param name="isControl" select="1"/>
					          </xsl:call-template>
				        </xsl:when>
				        <xsl:otherwise>
					          <xsl:call-template name="disabledElement">
						            <xsl:with-param name="isControl" select="1"/>
						            <xsl:with-param name="field" select="parent::*"/>
					          </xsl:call-template>
				        </xsl:otherwise>
			      </xsl:choose>
		    </button>
	  </xsl:template>
   <xsl:template name="commonClassHelper">
		    <xsl:value-of select="local-name()"/>
		    <xsl:if test="@class">
			      <xsl:value-of select="concat(' ', @class)"/>
		    </xsl:if>
	  </xsl:template>
   <xsl:template name="makeCommonClass">
		    <xsl:attribute name="class">
			      <xsl:call-template name="commonClassHelper"/>
		    </xsl:attribute>
	  </xsl:template>
   <xsl:template name="offscreenSpan">
		    <xsl:param name="text"/>
		    <xsl:param name="class"/>
		    <xsl:if test="$text!=''">
			      <span>
				        <xsl:attribute name="class">
					          <xsl:text>wc_off</xsl:text>
					          <xsl:if test="$class!=''">
						            <xsl:value-of select="concat(' ', $class)"/>
					          </xsl:if>
				        </xsl:attribute>
				        <xsl:value-of select="concat(' ',$text)"/>
			      </span>
		    </xsl:if>
	  </xsl:template>
   <xsl:template name="getPopupSpecs">
		    <xsl:if test="@top">
			      <xsl:value-of select="concat('top=',@top,'px,')"/>
		    </xsl:if>
		    <xsl:if test="@left">
			      <xsl:value-of select="concat('left=',@left,'px,')"/>
		    </xsl:if>
		    <xsl:if test="@width">
			      <xsl:value-of select="concat('width=',@width,'px,')"/>
		    </xsl:if>
		    <xsl:if test="@height">
			      <xsl:value-of select="concat('height=',@height,'px,')"/>
		    </xsl:if>
		    <xsl:choose>
			      <xsl:when test="@resizable">
				        <xsl:text>resizable=yes,</xsl:text>
			      </xsl:when>
			      <xsl:otherwise>
				        <xsl:text>resizable=no,</xsl:text>
			      </xsl:otherwise>
		    </xsl:choose>
		    <xsl:choose>
			      <xsl:when test="@showMenubar">
				        <xsl:text>menubar=yes,</xsl:text>
			      </xsl:when>
			      <xsl:otherwise>
				        <xsl:text>menubar=no,</xsl:text>
			      </xsl:otherwise>
		    </xsl:choose>
		    <xsl:choose>
			      <xsl:when test="@showToolbar">
				        <xsl:text>toolbar=yes,</xsl:text>
			      </xsl:when>
			      <xsl:otherwise>
				        <xsl:text>toolbar=no,</xsl:text>
			      </xsl:otherwise>
		    </xsl:choose>
		    <xsl:choose>
			      <xsl:when test="@showLocation">
				        <xsl:text>location=yes,</xsl:text>
			      </xsl:when>
			      <xsl:otherwise>
				        <xsl:text>location=no,</xsl:text>
			      </xsl:otherwise>
		    </xsl:choose>
		    <xsl:choose>
			      <xsl:when test="@showStatus">
				        <xsl:text>status=yes,</xsl:text>
			      </xsl:when>
			      <xsl:otherwise>
				        <xsl:text>status=no,</xsl:text>
			      </xsl:otherwise>
		    </xsl:choose>
		    <xsl:choose>
			      <xsl:when test="@showScrollbars">
				        <xsl:text>scrollbars=yes</xsl:text>
			      </xsl:when>
			      <xsl:otherwise>
				        <xsl:text>scrollbars=no</xsl:text>
			      </xsl:otherwise>
		    </xsl:choose>
	  </xsl:template>
   <xsl:template name="readOnlyControl">
		    <xsl:param name="class" select="''"/>
		    <xsl:param name="style" select="''"/>
		    <xsl:param name="applies" select="''"/>
		    <xsl:param name="useReadOnlyMode"/>
		    <xsl:param name="toolTip" select="''"/>
		    <xsl:param name="label"/>

		    <xsl:variable name="linkWithText">
			      <xsl:if test="text() and (self::ui:phoneNumberField or self::ui:emailField)">
				        <xsl:number value="1"/>
			      </xsl:if>
		    </xsl:variable>
		    <xsl:variable name="elementName">
			      <xsl:choose>
				        <xsl:when test="self::ui:textArea">
					
					          <xsl:text>pre</xsl:text>
				        </xsl:when>
				        <xsl:when test="$linkWithText=1">
					          <xsl:text>a</xsl:text>
				        </xsl:when>
				        <xsl:otherwise>
					          <xsl:text>span</xsl:text>
				        </xsl:otherwise>
			      </xsl:choose>
		    </xsl:variable>
		    <xsl:element name="{$elementName}">
			      <xsl:call-template name="commonAttributes"/>
			      <xsl:call-template name="title">
				        <xsl:with-param name="title" select="$toolTip"/>
			      </xsl:call-template>
			      <xsl:attribute name="class">
				        <xsl:call-template name="commonClassHelper"/>
				        <xsl:text> wc_ro</xsl:text>
				        <xsl:if test="$class != ''">
					          <xsl:value-of select="concat(' ', $class)"/>
				        </xsl:if>
			      </xsl:attribute>
			      <xsl:if test="$style!=''">
				        <xsl:attribute name="style">
					          <xsl:value-of select="$style"/>
				        </xsl:attribute>
			      </xsl:if>
			      <xsl:if test="$label">
				        <xsl:attribute name="aria-labelledby">
					          <xsl:value-of select="$label/@id"/>
				        </xsl:attribute>
			      </xsl:if>
			      <xsl:if test="$linkWithText=1">
				        <xsl:attribute name="href">
					          <xsl:choose>
						            <xsl:when test="self::ui:emailField">
							              <xsl:text>mailto:</xsl:text>
						            </xsl:when>
						            <xsl:otherwise>
							              <xsl:text>tel:</xsl:text>
						            </xsl:otherwise>
					          </xsl:choose>
					          <xsl:value-of select="."/>
				        </xsl:attribute>
			      </xsl:if>
			      <xsl:if test="$applies!='none'">
				        <xsl:choose>
					          <xsl:when test="$applies!='' and $useReadOnlyMode=1">
						            <xsl:apply-templates select="$applies" mode="readOnly"/>
					          </xsl:when>
					          <xsl:when test="$applies!=''">
						            <xsl:apply-templates select="$applies"/>
					          </xsl:when>
					          <xsl:when test="$useReadOnlyMode=1">
						            <xsl:apply-templates select="*" mode="readOnly"/>
					          </xsl:when>
					          <xsl:otherwise>
						            <xsl:apply-templates/>
					          </xsl:otherwise>
				        </xsl:choose>
			      </xsl:if>
		    </xsl:element>
	  </xsl:template>
   <xsl:template name="commonRequiredLibraries">
		    <xsl:if test=".//ui:dateField">
			
			      <xsl:text>"wc/ui/numberField","wc/ui/calendar",</xsl:text>
		    </xsl:if>
		
		    <xsl:if test=".//ui:dropdown[not(@readOnly)]">
			      <xsl:text>"wc/ui/dropdown","wc/ui/selectboxSearch",</xsl:text>
		    </xsl:if>
		
		
		    <xsl:if test=".//ui:error or .//ui:skipLinks or .//ui:link[substring(@url, 1, 1)='#']">
			      <xsl:text>"wc/ui/internalLink",</xsl:text>
		    </xsl:if>
		
		    <xsl:if test=".//ui:fieldLayout">
			      <xsl:text>"wc/ui/field",</xsl:text>
		    </xsl:if>
		
		
		    <xsl:if test=".//ui:label or .//ui:fieldSet">
			      <xsl:text>"wc/ui/label",</xsl:text>
		    </xsl:if>
		
		    <xsl:if test=".//ui:numberField[not(@readOnly)]">
			      <xsl:text>"wc/ui/numberField",</xsl:text>
		    </xsl:if>
		
		    <xsl:if test=".//ui:textArea[not(@readOnly)]">
			      <xsl:text>"wc/ui/textArea",</xsl:text>
		    </xsl:if>
		
		
		    <xsl:if test=".//ui:textField[not(@readOnly)] or .//ui:numberField[not(@readOnly)] or .//ui:emailField[not(@readOnly)] or .//ui:passwordField[not(@readOnly)] or .//ui:phoneNumberField[not(@readOnly)]">
			      <xsl:text>"wc/ui/textField",</xsl:text>
		    </xsl:if>
		
		    <xsl:if test=".//@accessKey">
			      <xsl:text>"wc/ui/tooltip",</xsl:text>
		    </xsl:if>
		    <xsl:if test=".//@buttonId">
			      <xsl:text>"wc/ui/defaultSubmit",</xsl:text>
		    </xsl:if>
	  </xsl:template>
   <xsl:template name="coreRegistrationScripts">
		    <xsl:variable name="componentGroups" select=".//ui:componentGroup"/>
		    <xsl:variable name="dialogs" select=".//ui:dialog"/>
		    <xsl:variable name="dataListCombos"
                    select=".//ui:dropdown[@data and @type and not(@readOnly)]|.//ui:suggestions[@data]"/>
		    <xsl:variable name="dataListComponents"
                    select=".//ui:dropdown[@data and not(@type) and not(@readOnly)]|.//ui:listBox[@data and not(@readOnly)]|.//ui:shuffler[@data and not(@readOnly)]"/>
		    <xsl:variable name="filedrops" select=".//ui:fileUpload[not(@readOnly)]"/>
		    <xsl:variable name="multiDDData"
                    select=".//ui:multiDropdown[@data and not(@readOnly)]"/>
		    <xsl:variable name="popups" select=".//ui:popup"/>
		    <xsl:variable name="redirects" select=".//ui:redirect"/>
		    <xsl:variable name="rtfs" select=".//ui:textArea[ui:rtf]"/>
		    <xsl:variable name="selectToggles"
                    select=".//ui:selectToggle|.//ui:rowSelection[@selectAll]"/>
		    <xsl:variable name="subordinates" select=".//ui:subordinate"/>
		    <xsl:variable name="eagerness" select="//*[@mode='eager']"/>
		    <xsl:variable name="hasAjaxTriggers" select=".//ui:ajaxTrigger"/>
		    <xsl:variable name="timeoutWarn" select=".//ui:session[1]"/>
		    <xsl:variable name="editors" select=".//html:wc-imageedit"/>

		    <xsl:if test="$componentGroups">
			      <xsl:text>require(["wc/ui/subordinate"], function(c){c.registerGroups([</xsl:text>
			      <xsl:apply-templates select="$componentGroups" mode="JS"/>
			      <xsl:text>]);});</xsl:text>
		    </xsl:if>
		    <xsl:if test="$editors">
			      <xsl:text>require(["wc/ui/imageEdit"], function(c){c.register([</xsl:text>
			      <xsl:apply-templates select="$editors" mode="JS"/>
			      <xsl:text>]);});</xsl:text>
		    </xsl:if>
		    <xsl:if test="$dialogs">
			      <xsl:text>require(["wc/ui/dialog"], function(c){c.register([</xsl:text>
			      <xsl:apply-templates select="$dialogs" mode="JS"/>
			      <xsl:text>]);});</xsl:text>
		    </xsl:if>
		    <xsl:if test="$dataListCombos">
			      <xsl:text>require(["wc/ui/comboLoader"], function(c){c.register([</xsl:text>
			      <xsl:apply-templates select="$dataListCombos" mode="registerIds"/>
			      <xsl:text>]);});</xsl:text>
		    </xsl:if>
		    <xsl:if test="$dataListComponents">
			      <xsl:text>require(["wc/ui/selectLoader"], function(c){c.register([</xsl:text>
			      <xsl:apply-templates select="$dataListComponents" mode="registerIds"/>
			      <xsl:text>]);});</xsl:text>
		    </xsl:if>
		    <xsl:if test="$filedrops">
			      <xsl:text>require(["wc/ui/multiFileUploader"], function(c){c.register([</xsl:text>
			      <xsl:apply-templates select="$filedrops" mode="registerIds"/>
			      <xsl:text>]);});</xsl:text>
		    </xsl:if>
		    <xsl:if test="$multiDDData">
			      <xsl:text>require(["wc/ui/multiFormComponent"], function(c){c.register([</xsl:text>
			      <xsl:apply-templates select="$multiDDData" mode="registerIds"/>
			      <xsl:text>]);});</xsl:text>
		    </xsl:if>
		    <xsl:if test="$popups">
			      <xsl:text>require(["wc/ui/popup"], function(c){c.register([</xsl:text>
			      <xsl:apply-templates select="$popups" mode="JS"/>
			      <xsl:text>])});</xsl:text>
		    </xsl:if>
		    <xsl:if test="$redirects">
			      <xsl:text>require(["wc/ui/redirect"], function(c){c.register(</xsl:text>
			      <xsl:apply-templates select="$redirects[1]" mode="JS"/>
			      <xsl:text>);});</xsl:text>
		    </xsl:if>
		    <xsl:if test="$rtfs">
			      <xsl:text>require(["wc/ui/rtf"], function(c){c.register([</xsl:text>
			      <xsl:apply-templates select="$rtfs" mode="registerIds"/>
			      <xsl:text>]);});</xsl:text>
		    </xsl:if>
		    <xsl:if test="$selectToggles">
			      <xsl:text>require(["wc/ui/selectToggle","wc/ui/radioAnalog"], function(c){c.register([</xsl:text>
			      <xsl:apply-templates select="$selectToggles" mode="JS"/>
			      <xsl:text>]);});</xsl:text>
		    </xsl:if>
		    <xsl:if test="$subordinates">
			      <xsl:text>require(["wc/ui/subordinate","wc/ui/SubordinateAction"], function(c){c.register([</xsl:text>
			      <xsl:apply-templates select="$subordinates" mode="JS"/>
			      <xsl:text>]);});</xsl:text>
		    </xsl:if>
		    <xsl:if test="$timeoutWarn">
			      <xsl:text>require(["wc/ui/timeoutWarn"], function(c){</xsl:text>
				     <xsl:text>c.initTimer(</xsl:text>
				     <xsl:value-of select="$timeoutWarn/@timeout"/>
				     <xsl:if test="$timeoutWarn/@warn">
					       <xsl:text>,</xsl:text>
					       <xsl:value-of select="$timeoutWarn/@warn"/>
				     </xsl:if>
			      <xsl:text>);});</xsl:text>
		    </xsl:if>
		    <xsl:if test="$eagerness">
			      <xsl:text>require(["wc/ui/containerload"], function(c){c.register([</xsl:text>
			      <xsl:apply-templates select="$eagerness" mode="registerIds"/>
			      <xsl:text>]);});</xsl:text>
		    </xsl:if>
		    <xsl:if test="$hasAjaxTriggers">
			
			      <xsl:text>require(["wc/ui/ajaxRegion","wc/ui/ajax/genericSubscriber"], function(c, s){c.register([</xsl:text>
			      <xsl:apply-templates select="$hasAjaxTriggers" mode="JS"/>
			      <xsl:text>]);});</xsl:text>
			      <xsl:variable name="hasDelayedAjaxTriggers" select=".//ui:ajaxTrigger[@delay]"/>
			      <xsl:if test="$hasDelayedAjaxTriggers">
				        <xsl:text>require(["wc/ui/ajax/delayedTrigger"], function(c){c.register([</xsl:text>
				        <xsl:apply-templates select="$hasDelayedAjaxTriggers" mode="JSdelay"/>
				        <xsl:text>]);});</xsl:text>
			      </xsl:if>
		    </xsl:if>
		    <xsl:if test="//@defaultFocusId">
			      <xsl:text>require(["wc/ui/onloadFocusControl"], function(c){c.register("</xsl:text>
			      <xsl:value-of select="//@defaultFocusId[1]"/>
			      <xsl:text>");});</xsl:text>
		    </xsl:if>
		    <xsl:text>require(["wc/has"], function(has){</xsl:text>
		    <xsl:text>if(has("ie")===8){require(["wc/fix/defaultSubmit_ie8"]);}</xsl:text>
		    <xsl:text>});</xsl:text>
		    <xsl:call-template name="localRegistrationScripts"/>
	  </xsl:template>
   <xsl:template name="impl_registration"/>
   <xsl:template name="localRegistrationScripts"/>
   <xsl:template name="localRequiredLibraries"/>
   <xsl:template name="requiredLibraries">
		    <xsl:variable name="libs">
			
			      <xsl:call-template name="commonRequiredLibraries"/>

			

			      <xsl:if test=".//ui:audio or .//ui:video">
				        <xsl:text>"wc/ui/mediaplayer",</xsl:text>
			      </xsl:if>
			      <xsl:if test=".//ui:checkBox[not(@readOnly)] or .//ui:checkBoxSelect[not(@readOnly)]">
				        <xsl:text>"wc/ui/checkBox",</xsl:text>
				        <xsl:if test=".//ui:checkBoxSelect[not(@readOnly)]">
					          <xsl:text>"wc/ui/checkBoxSelect",</xsl:text>
				        </xsl:if>
			      </xsl:if>
			      <xsl:if test=".//ui:collapsible">
				        <xsl:text>"wc/ui/collapsible",</xsl:text>
			      </xsl:if>
			      <xsl:if test=".//ui:expandCollapseAll">
				        <xsl:text>"wc/ui/collapsibleToggle",</xsl:text>
			      </xsl:if>
			      <xsl:if test=".//ui:fileUpload">
				        <xsl:text>"wc/ui/multiFileUploader","wc/ui/fileUpload",</xsl:text>
			      </xsl:if>
			
			      <xsl:if test=".//ui:listBox[not(@readOnly)]">
				        <xsl:text>"wc/ui/dropdown",</xsl:text>
			      </xsl:if>
			      <xsl:if test=".//ui:link[@type='button' or ui:windowAttributes[count(@*) &gt; 1]]">
				        <xsl:text>"wc/ui/navigationButton",</xsl:text>
			      </xsl:if>
			      <xsl:if test=".//ui:menu">
				        <xsl:text>"wc/ui/menu",</xsl:text>
				
			      </xsl:if>
			      <xsl:if test=".//ui:multiDropdown[not(@readOnly)]">
				        <xsl:text>"wc/ui/multiFormComponent",</xsl:text>
			      </xsl:if>
			      <xsl:if test=".//ui:multiSelectPair[not(@readOnly)]">
				        <xsl:text>"wc/ui/multiSelectPair",</xsl:text>
			      </xsl:if>
			      <xsl:if test=".//ui:multiTextField[not(@readOnly)]">
				        <xsl:text>"wc/ui/multiFormComponent","wc/ui/textField",</xsl:text>
			      </xsl:if>
			      <xsl:if test=".//ui:printButton">
				        <xsl:text>"wc/ui/printButton",</xsl:text>
			      </xsl:if>
			      <xsl:if test=".//ui:radioButtonSelect[not(@readOnly)] or .//ui:radioButton[not(@readOnly)]">
				        <xsl:text>"wc/ui/radioButtonSelect",</xsl:text>
			      </xsl:if>
			      <xsl:if test=".//ui:shuffler[not(@readOnly)] or .//ui:multiSelectPair[@shuffle and not(@readOnly)]">
				        <xsl:text>"wc/ui/shuffler",</xsl:text>
			      </xsl:if>
			      <xsl:if test=".//ui:suggestions or .//ui:dropdown[@type and not(@readOnly)]">
				        <xsl:text>"wc/ui/comboBox",</xsl:text>
			      </xsl:if>
			      <xsl:if test=".//ui:table">
				        <xsl:text>"wc/ui/table",</xsl:text>
				
			      </xsl:if>
			      <xsl:if test=".//ui:tabset">
				        <xsl:text>"wc/ui/tabset",</xsl:text>
			      </xsl:if>
			      <xsl:if test=".//ui:session">
				        <xsl:text>"wc/ui/timeoutWarn",</xsl:text>
			      </xsl:if>
			      <xsl:if test=".//*[@submitOnChange and not(@readOnly)]">
				        <xsl:text>"wc/ui/onchangeSubmit",</xsl:text>
			      </xsl:if>
			      <xsl:if test=".//@cancel">
				        <xsl:text>"wc/ui/cancelButton",</xsl:text>
			      </xsl:if>
			      <xsl:if test=".//@msg">
				        <xsl:text>"wc/ui/confirm",</xsl:text>
			      </xsl:if>
			
			      <xsl:if test=".//@mode='dynamic' or .//@mode='lazy' or .//@mode='server'">
				        <xsl:text>"wc/ui/containerload",</xsl:text>
			      </xsl:if>
			      <xsl:call-template name="localRequiredLibraries"/>
		    </xsl:variable>
		    <xsl:variable name="nLibs" select="normalize-space($libs)"/>
		    <xsl:if test="$nLibs !=''">
			      <xsl:text>require([</xsl:text>
			      <xsl:value-of select="substring($nLibs,1,string-length($nLibs)-1)"/>
			      <xsl:text>]);</xsl:text>
		    </xsl:if>
	  </xsl:template>
   <xsl:template name="registrationScripts">
		    <xsl:variable name="rego">
			      <xsl:call-template name="coreRegistrationScripts"/>
			      <xsl:call-template name="requiredLibraries"/>
		    </xsl:variable>
		    <xsl:if test="$rego!='' or self::ui:root">
			      <xsl:variable name="scriptId" select="generate-id()"/>
			      <script type="text/javascript" class="registrationScripts" id="{$scriptId}">
				        <xsl:text>require(["wc/compat/compat!"], function(){</xsl:text>
				        <xsl:text>require(["wc/i18n/i18n!"], function(){</xsl:text>
				        <xsl:text>require(["wc/common"], function(c){if(c){try{</xsl:text>
				        <xsl:if test="self::ui:root">
					
					          <xsl:text>require(["wc/fixes"], function(f){require(f);});</xsl:text>
				        </xsl:if>
				        <xsl:if test="$rego!=''">
					          <xsl:value-of select="$rego"/>
				        </xsl:if>
				        <xsl:text>}finally{require(["wc/dom/removeElement"],function(r){r("</xsl:text>
				        <xsl:value-of select="$scriptId"/>
				        <xsl:text>",250);});}}});</xsl:text>
				        <xsl:text>});});</xsl:text>
			      </script>
		    </xsl:if>

		
		    <xsl:call-template name="impl_registration"/>
	  </xsl:template>
   <xsl:template name="requiredElement">
		    <xsl:param name="field" select="."/>
		    <xsl:param name="useNative" select="1"/>
		    <xsl:if test="$field/@required">
			      <xsl:choose>
				        <xsl:when test="$useNative=1">
					          <xsl:attribute name="required">
						            <xsl:text>required</xsl:text>
					          </xsl:attribute>
				        </xsl:when>
				        <xsl:otherwise>
					          <xsl:attribute name="aria-required">
						            <xsl:copy-of select="$t"/>
					          </xsl:attribute>
				        </xsl:otherwise>
			      </xsl:choose>
		    </xsl:if>
	  </xsl:template>
   <xsl:template name="selectToggle">
		    <xsl:param name="id" select="@id"/>
		    <xsl:param name="name"/>
		    <xsl:param name="for"/>
		    <xsl:param name="selected"/>
		    <xsl:param name="roundTrip"/>
		    <xsl:param name="label"/>
		    <xsl:param name="type" select="'text'"/>
	
		    <xsl:variable name="toggleId">
			      <xsl:value-of select="$id"/>
			      <xsl:if test="not(self::ui:selectToggle)">
				        <xsl:text>-st</xsl:text>
			      </xsl:if>
		    </xsl:variable>
	
		    <xsl:variable name="mode">
			      <xsl:choose>
				        <xsl:when test="$roundTrip=$t">
					          <xsl:text>server</xsl:text>
				        </xsl:when>
				        <xsl:otherwise>
					          <xsl:text>client</xsl:text>
				        </xsl:otherwise>
			      </xsl:choose>
		    </xsl:variable>
		
		    <xsl:variable name="isCheckboxTarget" select="key('checkboxIdKey',$for)"/>
		
		    <xsl:variable name="thisGroupName">
			      <xsl:if test="$isCheckboxTarget">
				        <xsl:value-of select="$isCheckboxTarget[1]/@groupName"/>
			      </xsl:if>
		    </xsl:variable>
		
		    <xsl:variable name="targetList">
			      <xsl:choose>
				        <xsl:when test="$isCheckboxTarget and $thisGroupName!=''">
					          <xsl:apply-templates select="key('checkboxGroupKey',$thisGroupName)" mode="getIdList"/>
				        </xsl:when>
				        <xsl:otherwise>
					          <xsl:value-of select="$for"/>
				        </xsl:otherwise>
			      </xsl:choose>
		    </xsl:variable>
		
		    <xsl:variable name="myLabel" select="key('labelKey',$id)[1]"/>
		
		    <xsl:choose>
			      <xsl:when test="$type='text'">
				        <xsl:variable name="subClass">
					          <xsl:value-of select="local-name(.)"/>
					          <xsl:text> wc_seltog</xsl:text>
				        </xsl:variable>
				        <span id="{$toggleId}" role="radiogroup">
					          <xsl:attribute name="class">
						            <xsl:call-template name="commonClassHelper"/>
						            <xsl:text> wc_seltog</xsl:text>
					          </xsl:attribute>
					          <xsl:call-template name="ajaxTarget"/>
					          <xsl:if test="$isCheckboxTarget">
						            <xsl:attribute name="data-wc-cbgroup">
							              <xsl:value-of select="$thisGroupName"/>
						            </xsl:attribute>
					          </xsl:if>
					          <xsl:choose>
						            <xsl:when test="self::ui:rowSelection">
							              <xsl:call-template name="disabledElement">
								                <xsl:with-param name="field" select=".."/>
							              </xsl:call-template>
						            </xsl:when>
						            <xsl:otherwise>
							              <xsl:call-template name="disabledElement"/>
						            </xsl:otherwise>
					          </xsl:choose>
					          <xsl:variable name="defaultLabelId">
						            <xsl:value-of select="$toggleId"/>
						            <xsl:text>-l</xsl:text>
					          </xsl:variable>
					
					          <span id="{$defaultLabelId}">
						            <xsl:choose>
							              <xsl:when test="$label!=''">
								                <xsl:value-of select="$label"/>
							              </xsl:when>
							              <xsl:when test="self::ui:rowSelection">
								                <xsl:value-of select="$tog1"/>
							              </xsl:when>
							              <xsl:when test="not($myLabel)">
								                <xsl:value-of select="$tog1"/>
							              </xsl:when>
						            </xsl:choose>
					          </span>
					
					          <xsl:variable name="labelId">
						            <xsl:choose>
							              <xsl:when test="self::ui:rowSelection">
								                <xsl:value-of select="$defaultLabelId"/>
							              </xsl:when>
							              <xsl:when test="$myLabel">
								                <xsl:value-of select="$myLabel/@id"/>
							              </xsl:when>
							              <xsl:otherwise>
								                <xsl:value-of select="$defaultLabelId"/>
							              </xsl:otherwise>
						            </xsl:choose>
					          </xsl:variable>
					
					          <xsl:call-template name="toggleElement">
						            <xsl:with-param name="mode" select="$mode"/>
						            <xsl:with-param name="id" select="concat($id,'-select-all')"/>
						            <xsl:with-param name="for" select="$targetList"/>
						            <xsl:with-param name="name" select="$name"/>
						            <xsl:with-param name="value" select="'all'"/>
						            <xsl:with-param name="class" select="$subClass"/>
						            <xsl:with-param name="text" select="$tog2"/>
						            <xsl:with-param name="selected">
							              <xsl:if test="$selected='all'">
								                <xsl:number value="1"/>
							              </xsl:if>
						            </xsl:with-param>
						            <xsl:with-param name="labelId" select="$labelId"/>
					          </xsl:call-template>
	
					          <xsl:call-template name="toggleElement">
						            <xsl:with-param name="mode" select="$mode"/>
						            <xsl:with-param name="id" select="concat($id,'-select-none')"/>
						            <xsl:with-param name="for" select="$targetList"/>
						            <xsl:with-param name="name" select="$name"/>
						            <xsl:with-param name="value" select="'none'"/>
						            <xsl:with-param name="class" select="$subClass"/>
						            <xsl:with-param name="text" select="$tog3"/>
						            <xsl:with-param name="selected">
							              <xsl:if test="$selected='none'">
								                <xsl:number value="1"/>
							              </xsl:if>
						            </xsl:with-param>
						            <xsl:with-param name="labelId" select="$labelId"/>
					          </xsl:call-template>
				        </span>
			      </xsl:when>
			      <xsl:otherwise>
				        <button id="{$toggleId}" role="checkbox" aria-controls="{$targetList}">
					          <xsl:attribute name="type">
						            <xsl:choose>
							              <xsl:when test="$mode='server'">
								                <xsl:text>submit</xsl:text>
							              </xsl:when>
							              <xsl:otherwise>
								                <xsl:text>button</xsl:text>
							              </xsl:otherwise>
						            </xsl:choose>
					          </xsl:attribute>
					          <xsl:if test="$mode='server'">
						            <xsl:attribute name="formnovalidate">
							              <xsl:text>formnovalidate</xsl:text>
						            </xsl:attribute>
					          </xsl:if>
					          <xsl:attribute name="aria-checked">
						            <xsl:choose>
							              <xsl:when test="$selected='all'">
								                <xsl:copy-of select="$t"/>
							              </xsl:when>
							              <xsl:when test="$selected='some'">
								                <xsl:text>mixed</xsl:text>
							              </xsl:when>
							              <xsl:otherwise>
								                <xsl:text>false</xsl:text>
							              </xsl:otherwise>
						            </xsl:choose>
					          </xsl:attribute>
					
					          <xsl:if test="$name!=''">
						            <xsl:attribute name="data-wc-name">
							              <xsl:value-of select="$name"/>
						            </xsl:attribute>
					          </xsl:if>
					          <xsl:attribute name="class">
						            <xsl:call-template name="commonClassHelper"/>
						            <xsl:text> wc_seltog wc_btn_nada</xsl:text>
					          </xsl:attribute>
					          <xsl:attribute name="title">
						            <xsl:choose>
							              <xsl:when test="$label!=''">
								                <xsl:value-of select="$label"/>
							              </xsl:when>
							              <xsl:when test="self::ui:rowSelection">
								                <xsl:value-of select="$tog4"/>
							              </xsl:when>
							              <xsl:when test="$myLabel">
								                <xsl:apply-templates select="$myLabel" mode="selectToggle"/>
							              </xsl:when>
							              <xsl:otherwise>
								                <xsl:value-of select="$tog4"/>
							              </xsl:otherwise>
						            </xsl:choose>
					          </xsl:attribute>
					          <xsl:choose>
						            <xsl:when test="self::ui:selectToggle">
							              <xsl:call-template name="disabledElement">
								                <xsl:with-param name="isControl" select="1"/>
							              </xsl:call-template>
						            </xsl:when>
						            <xsl:otherwise>
							              <xsl:call-template name="disabledElement">
								                <xsl:with-param name="isControl" select="1"/>
								                <xsl:with-param name="field" select="parent::ui:table"/>
							              </xsl:call-template>
						            </xsl:otherwise>
					          </xsl:choose>
					          <xsl:if test="$isCheckboxTarget">
						            <xsl:attribute name="data-wc-cbgroup">
							              <xsl:value-of select="$thisGroupName"/>
						            </xsl:attribute>
					          </xsl:if>
				        </button>
			      </xsl:otherwise>
		    </xsl:choose>
	  </xsl:template>
   <xsl:template name="separatorOrientation">
		    <xsl:variable name="sepV" select="'vertical'"/>
		    <xsl:variable name="orientation">
			
			      <xsl:if test="parent::ui:menu or parent::ui:menuGroup[parent::ui:menu]">
				        <xsl:variable name="menuType" select="ancestor::ui:menu[1]/@type"/>
				        <xsl:if test="$menuType='bar' or $menuType='flyout'">
					          <xsl:value-of select="$sepV"/>
				        </xsl:if>
			      </xsl:if>
		    </xsl:variable>
		    <xsl:if test="$orientation=$sepV">
			      <xsl:attribute name="aria-orientation">
				        <xsl:value-of select="$sepV"/>
			      </xsl:attribute>
		    </xsl:if>
	  </xsl:template>
   <xsl:template name="separator">
		    <xsl:element name="hr">
			      <xsl:attribute name="role">
				        <xsl:text>separator</xsl:text>
			      </xsl:attribute>
			      <xsl:call-template name="makeCommonClass"/>
			      <xsl:call-template name="separatorOrientation"/>
		    </xsl:element>
	  </xsl:template>
   <xsl:template name="title">
		    <xsl:param name="title"/>
		    <xsl:param name="contentAfter"/>

		    <xsl:variable name="text">
			      <xsl:choose>
				        <xsl:when test="$title!=''">
					          <xsl:value-of select="$title"/>
				        </xsl:when>
				        <xsl:when test="@toolTip">
					          <xsl:value-of select="@toolTip"/>
				        </xsl:when>
			      </xsl:choose>
			      <xsl:if test="$contentAfter !=''">
				        <xsl:value-of select="normalize-space(concat(' ', $contentAfter))"/>
			      </xsl:if>
		    </xsl:variable>

		    <xsl:variable name="content" select="normalize-space($text)"/>

		    <xsl:if test="$content !=''">
			      <xsl:attribute name="title">
				        <xsl:value-of select="$content"/>
			      </xsl:attribute>
		    </xsl:if>
	  </xsl:template>
   <xsl:template name="toggleElement">
		    <xsl:param name="mode"/>
		    <xsl:param name="id"/>
		    <xsl:param name="for"/>
		    <xsl:param name="name"/>
		    <xsl:param name="value"/>
		    <xsl:param name="class"/>
		    <xsl:param name="text"/>
		    <xsl:param name="selected"/>
		    <xsl:param name="labelId"/>
	
		    <xsl:variable name="localClass">
			      <xsl:text>wc_btn_nada</xsl:text>
			      <xsl:if test="$class!=''">
				        <xsl:value-of select="concat(' ',$class)"/>
			      </xsl:if>
		    </xsl:variable>

		    <button id="{$id}"
              role="radio"
              class="{$localClass}"
              data-wc-value="{$value}">
			      <xsl:if test="$name !=''">
				        <xsl:attribute name="data-wc-name">
					          <xsl:value-of select="$name"/>
				        </xsl:attribute>
			      </xsl:if>
			      <xsl:attribute name="type">
				        <xsl:choose>
					          <xsl:when test="$mode='client' or $mode='' or not($mode)">
						            <xsl:text>button</xsl:text>
					          </xsl:when>
					          <xsl:otherwise>
						            <xsl:text>submit</xsl:text>
					          </xsl:otherwise>
				        </xsl:choose>
			      </xsl:attribute>
			      <xsl:if test="$labelId != ''">
				        <xsl:attribute name="aria-labelledby">
					          <xsl:value-of select="$labelId"/>
				        </xsl:attribute>
			      </xsl:if>
			      <xsl:attribute name="aria-checked">
				        <xsl:choose>
					          <xsl:when test="$selected=1">
						            <xsl:copy-of select="$t"/>
					          </xsl:when>
					          <xsl:otherwise>
						            <xsl:text>false</xsl:text>
					          </xsl:otherwise>
				        </xsl:choose>
			      </xsl:attribute>
			      <xsl:if test="$for!=''">
				        <xsl:attribute name="aria-controls">
					          <xsl:value-of select="$for"/>
				        </xsl:attribute>
			      </xsl:if>
			      <xsl:choose>
				        <xsl:when test="$mode='dynamic' or $mode='lazy'">
					          <xsl:attribute name="data-wc-ajaxalias">
						            <xsl:value-of select="$for"/>
					          </xsl:attribute>
				        </xsl:when>
				        <xsl:when test="$mode='server'">
					          <xsl:attribute name="formnovalidate">
						            <xsl:text>formnovalidate</xsl:text>
					          </xsl:attribute>
				        </xsl:when>
			      </xsl:choose>
			      <xsl:choose>
				        <xsl:when test="self::ui:rowSelection or self::ui:rowExpansion">
						
					          <xsl:call-template name="disabledElement">
						            <xsl:with-param name="isControl" select="1"/>
						            <xsl:with-param name="field" select="parent::ui:table"/>
					          </xsl:call-template>
				        </xsl:when>
				        <xsl:when test="self::ui:selectToggle">
					          <xsl:call-template name="disabledElement">
						            <xsl:with-param name="isControl" select="1"/>
					          </xsl:call-template>
				        </xsl:when>
			      </xsl:choose>
			      <xsl:value-of select="$text"/>
		    </button>
	  </xsl:template>
   <xsl:template name="tooltip">
		    <xsl:param name="ttAccessKey" select="@accessKey"/>
		    <xsl:param name="id" select="@id"/>
		    <xsl:if test="$ttAccessKey!=''">
			      <span id="{concat($id,'-wctt')}" role="tooltip" hidden="hidden">
				        <xsl:value-of select="$ttAccessKey"/>
			      </span>
		    </xsl:if>
	  </xsl:template>
   <xsl:template name="borderLayoutCell">
		    <xsl:param name="hgap" select="0"/>
		    <xsl:param name="vgap" select="0"/>
		    <xsl:element name="div">
			      <xsl:attribute name="class">
				        <xsl:value-of select="local-name(.)"/>
				        <xsl:if test="self::ui:west or self::ui:east or self::ui:center">
					
					          <xsl:variable name="colCount" select="count(../ui:west|../ui:east|../ui:center)"/>
					          <xsl:choose>
						            <xsl:when test="$colCount = 1">
							              <xsl:text> wc_borderLayout_middle100</xsl:text>
						            </xsl:when>
						            <xsl:when test="(self::ui:west or self::ui:east) and ../ui:center">
							              <xsl:text> wc_borderLayout_middle25</xsl:text>
						            </xsl:when>
						            <xsl:when test="(self::ui:east and (../ui:west)) or (self::ui:west and (../ui:east)) or ($colCount = 3 and self::ui:center)">
							              <xsl:text> wc_borderLayout_middle50</xsl:text>
						            </xsl:when>
						            <xsl:when test="self::ui:center">
							              <xsl:text> wc_borderLayout_middle75</xsl:text>
						            </xsl:when>
					          </xsl:choose>
				        </xsl:if>
			      </xsl:attribute>
			      <xsl:if test=" $hgap!=0 or $vgap!=0">
				        <xsl:attribute name="style">
					          <xsl:if test="$hgap!=0">
						            <xsl:choose>
							              <xsl:when test="self::ui:east">
								                <xsl:value-of select="concat('padding-left:',$hgap,';')"/>
							              </xsl:when>
							              <xsl:when test="self::ui:west">
								                <xsl:value-of select="concat('padding-right:',$hgap,';')"/>
							              </xsl:when>
							              <xsl:otherwise>
								                <xsl:if test="../ui:west">
									                  <xsl:value-of select="concat('padding-left:',$hgap,';')"/>
								                </xsl:if>
								                <xsl:if test="../ui:east">
									                  <xsl:value-of select="concat('padding-right:',$hgap,';')"/>
								                </xsl:if>
							              </xsl:otherwise>
						            </xsl:choose>
					          </xsl:if>
					          <xsl:if test="$vgap!=0">
						            <xsl:value-of select="concat('margin-top:',$vgap,';')"/>
					          </xsl:if>
				        </xsl:attribute>
			      </xsl:if>
			      <xsl:apply-templates/>
		    </xsl:element>
	  </xsl:template>
   <xsl:template name="fieldIsCheckRadio">
		    <xsl:variable name="labelFor" select="ui:label/@for"/>
		    <xsl:variable name="labelledElementLocalName">
			      <xsl:if test="ui:label/@for">
				        <xsl:value-of select="local-name(key('labelableElementKey',$labelFor)[1])"/>
			      </xsl:if>
		    </xsl:variable>
		    <xsl:choose>
			      <xsl:when test="$labelledElementLocalName='radioButton' or $labelledElementLocalName='checkBox' or $labelledElementLocalName='selectToggle'">
				        <xsl:number value="1"/>
			      </xsl:when>
			      <xsl:otherwise>
				        <xsl:number value="0"/>
			      </xsl:otherwise>
		    </xsl:choose>
	  </xsl:template>
   <xsl:template name="fileInfo">
		    <xsl:value-of select="concat(@name,' (',@size,' ',') ',$mfu3)"/>
		
	  </xsl:template>
   <xsl:template name="fileInput">
		    <xsl:param name="id"/>
		    <xsl:variable name="maxFiles" select="@maxFiles"/>
		    <xsl:element name="input">
			      <xsl:attribute name="type">
				        <xsl:text>file</xsl:text>
			      </xsl:attribute>
			      <xsl:attribute name="id">
				        <xsl:value-of select="$id"/>
			      </xsl:attribute>
			      <xsl:attribute name="name">
				        <xsl:value-of select="@id"/>
			      </xsl:attribute>
			      <xsl:call-template name="ajaxTarget">
				        <xsl:with-param name="live" select="'off'"/>
			      </xsl:call-template>
			      <xsl:attribute name="data-dropzone">
				        <xsl:choose>
					          <xsl:when test="@dropzone">
						            <xsl:value-of select="@dropzone"/>
					          </xsl:when>
					          <xsl:otherwise>
						            <xsl:value-of select="@id"/>
					          </xsl:otherwise>					
				        </xsl:choose>
			      </xsl:attribute>
			      <xsl:if test="@editor">
				        <xsl:attribute name="data-editor">
					          <xsl:value-of select="@editor"/>
				        </xsl:attribute>
			      </xsl:if>
			      <xsl:choose>
				        <xsl:when test="$maxFiles='1'">
					          <xsl:call-template name="requiredElement"/>
				        </xsl:when>
				        <xsl:otherwise>
					          <xsl:attribute name="multiple">
						            <xsl:text>multiple</xsl:text>
					          </xsl:attribute>
				        </xsl:otherwise>
			      </xsl:choose>
			      <xsl:call-template name="disabledElement">
				        <xsl:with-param name="isControl" select="1"/>
			      </xsl:call-template>
			      <xsl:call-template name="title"/>
			      <xsl:if test="@acceptedMimeTypes">
				        <xsl:attribute name="accept">
					          <xsl:value-of select="@acceptedMimeTypes"/>
				        </xsl:attribute>
			      </xsl:if>
			      <xsl:if test="@maxFileSize">
				        <xsl:attribute name="data-wc-maxfilesize">
					          <xsl:value-of select="@maxFileSize"/>
				        </xsl:attribute>
			      </xsl:if>
			      <xsl:if test="$maxFiles">
				        <xsl:attribute name="data-wc-maxfiles">
					          <xsl:value-of select="$maxFiles"/>
				        </xsl:attribute>
			      </xsl:if>
		    </xsl:element>
		    <xsl:if test="@camera=$t">
			      <xsl:call-template name="imageEditButton">
				        <xsl:with-param name="text">
					          <xsl:text>Camera</xsl:text>
				        </xsl:with-param>
			      </xsl:call-template>
		    </xsl:if>
	  </xsl:template>
   <xsl:template name="fileInList">
		    <xsl:variable name="readOnly" select="../@readOnly"/>
		    <xsl:variable name="removeTxt" select="concat('Delete attachment: ', @name)"/>
		
		    <xsl:element name="li">
			      <xsl:attribute name="id">
				
				        <xsl:value-of select="@id"/>
			      </xsl:attribute>
			      <xsl:attribute name="data-containerid">
				        <xsl:value-of select="../@id"/>
			      </xsl:attribute>
			      <xsl:attribute name="class">
            <xsl:value-of select="local-name()"/>
         </xsl:attribute>
			      <xsl:choose>
				        <xsl:when test="ui:link">
					          <xsl:apply-templates select="ui:link">
						            <xsl:with-param name="imageAltText"
                                  select="concat('Thumbnail for uploaded file: ', @name)"/>
					          </xsl:apply-templates>
				        </xsl:when>
				        <xsl:otherwise>
					
					          <xsl:call-template name="fileInfo"/>
				        </xsl:otherwise>
			      </xsl:choose>
			      <xsl:if test="not($readOnly=$t)">
				        <button type="button" class="wc_btn_nada" title="{$removeTxt}">
					          <xsl:call-template name="offscreenSpan">
						            <xsl:with-param name="text">
							              <xsl:value-of select="$removeTxt"/>
						            </xsl:with-param>
					          </xsl:call-template>
				        </button>
			      </xsl:if>
		    </xsl:element>
	  </xsl:template>
   <xsl:template name="gridCell">
		    <xsl:param name="width"/>
		    <xsl:param name="hgap" select="0"/>
		    <xsl:param name="vgap" select="0"/>
		    <xsl:param name="inRow"/>
		    <xsl:variable name="style">
			      <xsl:if test="$width !=''">
				        <xsl:value-of select="concat('width:',$width,';')"/>
			      </xsl:if>
			      <xsl:if test="$vgap != 0">
				        <xsl:value-of select="concat('padding-top:',$vgap,';')"/>
			      </xsl:if>
			      <xsl:if test="$hgap != 0">
				        <xsl:if test="position() != last() or $inRow!=1">
					          <xsl:value-of select="concat('padding-right:',$hgap,';')"/>
				        </xsl:if>
				        <xsl:if test="$inRow = 1">
					          <xsl:value-of select="concat('padding-left:',$hgap,';')"/>
				        </xsl:if>
			      </xsl:if>
		    </xsl:variable>
		    <div class="{local-name(.)}">
			      <xsl:if test="$style!=''">
				        <xsl:attribute name="style">
					          <xsl:value-of select="$style"/>
				        </xsl:attribute>
			      </xsl:if>
			      <xsl:apply-templates/>
		    </div>
	  </xsl:template>
   <xsl:template name="imageEditButton">
		    <xsl:param name="text"/>
		    <button type="button" data-editor="{@editor}">
			      <xsl:choose>
				        <xsl:when test="self::ui:image">
					          <xsl:attribute name="data-selector">
						            <xsl:value-of select="@editor"/>
					          </xsl:attribute>
					          <xsl:attribute name="data-img">
						            <xsl:value-of select="@id"/>
					          </xsl:attribute>
				        </xsl:when>
				        <xsl:otherwise>
					          <xsl:attribute name="data-selector">
						            <xsl:value-of select="@id"/>
					          </xsl:attribute>
					          <xsl:attribute name="class">
						            <xsl:text>wc_btn_camera</xsl:text>
					          </xsl:attribute>
				        </xsl:otherwise>
			      </xsl:choose>
			      <span class="wc_off">
				        <xsl:value-of select="$text"/>
			      </span>
		    </button>
	  </xsl:template>
   <xsl:template name="WLabelHint">
		    <xsl:param name="submitNotAjaxTrigger" select="0"/>
		    <xsl:if test="@hint or $submitNotAjaxTrigger=1">
			      <xsl:element name="span">
				        <xsl:attribute name="class">
					          <xsl:text>hint</xsl:text>
				        </xsl:attribute>
				        <xsl:value-of select="@hint"/>
				        <xsl:if test="$submitNotAjaxTrigger=1">
					          <xsl:if test="@hint">
						            <xsl:element name="br"/>
					          </xsl:if>
					          <xsl:value-of select="$cm3"/>
				        </xsl:if>
			      </xsl:element>
		    </xsl:if>
	  </xsl:template>
   <xsl:template name="labelClassHelper">
		    <xsl:param name="element"/>
		    <xsl:param name="readOnly" select="0"/>
		    <xsl:attribute name="class">
			      <xsl:call-template name="commonClassHelper"/>
			      <xsl:if test="@hidden">
				
				        <xsl:text> wc_off</xsl:text>
			      </xsl:if>
			      <xsl:if test="$readOnly!=1 and $element and $element/@required">
				        <xsl:text> wc_req</xsl:text>
			      </xsl:if>
		    </xsl:attribute>
	  </xsl:template>
   <xsl:template name="labelCommonAttributes">
		    <xsl:param name="element"/>
		    <xsl:param name="style"/>
		
		    <xsl:attribute name="id">
			      <xsl:value-of select="@id"/>
		    </xsl:attribute>
		
		    <xsl:call-template name="title"/>
		
		    <xsl:if test="$element">
			      <xsl:if test="$element/@hidden">
				        <xsl:call-template name="hiddenElement"/>
			      </xsl:if>
		    </xsl:if>
		
		    <xsl:call-template name="ajaxTarget"/>
		
		    <xsl:if test="$style != ''">
			      <xsl:attribute name="style">
				        <xsl:value-of select="$style"/>
			      </xsl:attribute>
		    </xsl:if>
	  </xsl:template>
   <xsl:template name="labelHintHelper">
		    <xsl:param name="element"/>
		    <xsl:param name="readOnly" select="0"/>
		
		
		    <xsl:variable name="submitOnChange">
			      <xsl:choose>
				        <xsl:when test="$readOnly=1">
					          <xsl:number value="0"/>
				        </xsl:when>
				        <xsl:when test="$element and $element/@submitOnChange">
					          <xsl:number value="1"/>
				        </xsl:when>
				        <xsl:otherwise>
					          <xsl:number value="0"/>
				        </xsl:otherwise>
			      </xsl:choose>
		    </xsl:variable>
		
		    <xsl:call-template name="WLabelHint">
			      <xsl:with-param name="submitNotAjaxTrigger">
				        <xsl:if test="$submitOnChange=1 and count(key('triggerKey',@for))=0">
					          <xsl:number value="1"/>
				        </xsl:if>
			      </xsl:with-param>
		    </xsl:call-template>
	  </xsl:template>
   <xsl:template name="makeFauxLabel">
		    <xsl:param name="forElement"/>
		    <xsl:param name="style"/>

		    <xsl:variable name="readOnly">
			      <xsl:if test="$forElement/@readOnly">
				        <xsl:number value="1"/>
			      </xsl:if>
		    </xsl:variable>

		
		    <span tabindex="-1" aria-hidden="true">
			      <xsl:call-template name="labelCommonAttributes">
				        <xsl:with-param name="element" select="$forElement"/>
				        <xsl:with-param name="style" select="$style"/>
			      </xsl:call-template>

			      <xsl:choose>
				        <xsl:when test="$readOnly=1">
					          <xsl:attribute name="data-wc-rofor">
						            <xsl:value-of select="@for"/>
					          </xsl:attribute>
				        </xsl:when>
				        <xsl:otherwise>
					          <xsl:attribute name="data-wc-for">
						            <xsl:value-of select="@for"/>
					          </xsl:attribute>
					          <xsl:call-template name="hideElementIfHiddenSet"/>
				        </xsl:otherwise>
			      </xsl:choose>

			      <xsl:call-template name="labelClassHelper">
				        <xsl:with-param name="element" select="$forElement"/>
				        <xsl:with-param name="readOnly" select="$readOnly"/>
			      </xsl:call-template>

			      <xsl:apply-templates/>

			      <xsl:call-template name="labelHintHelper">
				        <xsl:with-param name="element" select="$forElement"/>
				        <xsl:with-param name="readOnly" select="$readOnly"/>
			      </xsl:call-template>
		    </span>
	  </xsl:template>
   <xsl:template name="makeLabel">
		    <xsl:param name="labelableElement"/>
		    <xsl:param name="style"/>

		    <xsl:variable name="readOnly">
			      <xsl:if test="$labelableElement/@readOnly">
				        <xsl:number value="1"/>
			      </xsl:if>
		    </xsl:variable>

		    <xsl:variable name="elementType">
			      <xsl:choose>
				        <xsl:when test="$readOnly=1">
					          <xsl:text>span</xsl:text>
				        </xsl:when>
				        <xsl:otherwise>
					          <xsl:text>label</xsl:text>
				        </xsl:otherwise>
			      </xsl:choose>
		    </xsl:variable>

		    <xsl:element name="{$elementType}">
			      <xsl:call-template name="labelCommonAttributes">
				        <xsl:with-param name="element" select="$labelableElement"/>
				        <xsl:with-param name="style" select="$style"/>
			      </xsl:call-template>

			      <xsl:choose>
				        <xsl:when test="$elementType='label'">
					          <xsl:if test="@for and @for!=''">
						            <xsl:attribute name="for">
							              <xsl:value-of select="@for"/>
							
							              <xsl:choose>
								                <xsl:when test="name($labelableElement) = 'ui:dateField'">
									                  <xsl:text>-f</xsl:text>
								                </xsl:when>
							              </xsl:choose>
						            </xsl:attribute>
					          </xsl:if>
				        </xsl:when>
				        <xsl:otherwise>
					          <xsl:attribute name="data-wc-rofor">
						            <xsl:value-of select="@for"/>
					          </xsl:attribute>
				        </xsl:otherwise>
			      </xsl:choose>

			      <xsl:call-template name="labelClassHelper">
				        <xsl:with-param name="element" select="$labelableElement"/>
				        <xsl:with-param name="readOnly" select="$readOnly"/>
			      </xsl:call-template>

			      <xsl:if test="$elementType='label'">
				        <xsl:call-template name="accessKey"/>
			      </xsl:if>

			      <xsl:apply-templates/>
			      <xsl:if test="normalize-space(.)='' and not(.//ui:image)">
				        <xsl:value-of select="$cm1"/>
			      </xsl:if>

			      <xsl:if test="$elementType='label' and $labelableElement/@required">
				        <xsl:call-template name="offscreenSpan">
					          <xsl:with-param name="text">
						            <xsl:value-of select="$cm2"/>
					          </xsl:with-param>
				        </xsl:call-template>
			      </xsl:if>

			      <xsl:call-template name="labelHintHelper">
				        <xsl:with-param name="element" select="$labelableElement"/>
				        <xsl:with-param name="readOnly" select="$readOnly"/>
			      </xsl:call-template>
		    </xsl:element>
		
		    <xsl:if test="name($labelableElement) = 'ui:checkBox' or name($labelableElement) = 'ui:radioButton'">
			      <xsl:call-template name="inlineError">
				        <xsl:with-param name="errors" select="key('errorKey',@for)"/>
				        <xsl:with-param name="id" select="@for"/>
			      </xsl:call-template>
		    </xsl:if>
	  </xsl:template>
   <xsl:template name="makeLabelForNothing">
		    <xsl:param name="style"/>
		    <xsl:element name="span">
			      <xsl:call-template name="labelCommonAttributes">
				        <xsl:with-param name="element" select="false()"/>
				        <xsl:with-param name="style" select="$style"/>
			      </xsl:call-template>
			
			      <xsl:call-template name="labelClassHelper"/>
			
			      <xsl:call-template name="hideElementIfHiddenSet"/>
			      <xsl:apply-templates/>
			      <xsl:call-template name="WLabelHint"/>
		    </xsl:element>
	  </xsl:template>
   <xsl:template name="pxWithUnit">
		    <xsl:param name="gap" select="'0'"/>
		    <xsl:value-of select="$gap"/>
		
		    <xsl:if test="$gap !='0'">
			      <xsl:text>px</xsl:text>
		    </xsl:if>
	  </xsl:template>
   <xsl:template name="hasStickyOpen">
		    <xsl:param name="type"/>
		    <xsl:choose>
			
			      <xsl:when test="$type='tree' or not($type)">
				        <xsl:number value="1"/>
			      </xsl:when>
			      <xsl:otherwise>
				        <xsl:number value="0"/>
			      </xsl:otherwise>
		    </xsl:choose>
	  </xsl:template>
   <xsl:template name="menuRoleIsSelectable">
		    <xsl:param name="type"/>
		    <xsl:param name="myAncestorMenu"/>
		    <xsl:param name="myAncestorSubmenu"/>
		    <xsl:choose>
			      <xsl:when test="@selectable='false'">
				        <xsl:number value="0"/>
			      </xsl:when>
			
			      <xsl:when test="type='tree' and $myAncestorMenu/@selectMode">
				        <xsl:number value="1"/>
			      </xsl:when>
			      <xsl:when test="type='tree'">
				        <xsl:number value="0"/>
			      </xsl:when>
			
			      <xsl:when test="@selectable">
				        <xsl:number value="1"/>
			      </xsl:when>
			
			      <xsl:when test="not($myAncestorMenu or $myAncestorSubmenu)">
				        <xsl:number value="0"/>
			      </xsl:when>
			
			      <xsl:when test="$myAncestorSubmenu/@selectMode">
				        <xsl:number value="1"/>
			      </xsl:when>
			      <xsl:when test="$myAncestorSubmenu">
				        <xsl:number value="0"/>
			      </xsl:when>
			      <xsl:when test="$myAncestorMenu/@selectMode">
				        <xsl:number value="1"/>
			      </xsl:when>
			      <xsl:otherwise>
				        <xsl:number value="0"/>
			      </xsl:otherwise>
		    </xsl:choose>
	  </xsl:template>
   <xsl:template name="menuTabIndexHelper">
		    <xsl:param name="menu"/>
		    <xsl:variable name="stickyOpen">
			      <xsl:call-template name="hasStickyOpen">
				        <xsl:with-param name="type" select="$menu/@type"/>
			      </xsl:call-template>
		    </xsl:variable>
		    <xsl:choose>
			
			      <xsl:when test="not($menu)">
				
				        <xsl:text>-1</xsl:text>
			      </xsl:when>
			
			      <xsl:when test="@disabled">
				        <xsl:if test="self::ui:menuItem and not(@url or @submit)">
					          <xsl:text>-1</xsl:text>
				        </xsl:if>
			      </xsl:when>
			
			      <xsl:when test="ancestor::ui:submenu[1][ancestor::ui:menu[1]=$menu and (@disabled or $stickyOpen=0 or not(@open))]">-1</xsl:when>
			      <xsl:otherwise>0</xsl:otherwise>
		    </xsl:choose>
	  </xsl:template>
   <xsl:template name="multiDropDownContentRenderer">
		    <xsl:param name="myLabel"/>
		    <xsl:choose>
			      <xsl:when test="count(.//ui:option[@selected]) = 0">
				        <xsl:apply-templates select="(ui:option|ui:optgroup/ui:option)[1]" mode="multiDropDown">
					          <xsl:with-param name="isSingular" select="1"/>
					          <xsl:with-param name="myLabel" select="$myLabel"/>
				        </xsl:apply-templates>
			      </xsl:when>
			      <xsl:otherwise>
				        <xsl:apply-templates select=".//ui:option[@selected]" mode="multiDropDown">
					          <xsl:with-param name="myLabel" select="$myLabel"/>
				        </xsl:apply-templates>
			      </xsl:otherwise>
		    </xsl:choose>
	  </xsl:template>
   <xsl:template name="multiSelectPairButton">
		    <xsl:param name="value"/>
		    <xsl:param name="buttonText"/>
		    <button type="button"
              value="{$value}"
              title="{$buttonText}"
              class="wc_ibtn"
              aria-controls="{concat(@id, '-a',' ',@id, '-s')}">
			      <xsl:call-template name="disabledElement">
				        <xsl:with-param name="isControl" select="1"/>
			      </xsl:call-template>
		    </button>
	  </xsl:template>
   <xsl:template name="multiTextFieldContentRenderer">
		    <xsl:param name="myLabel"/>
		    <xsl:choose>
			      <xsl:when test="ui:value">
				        <xsl:apply-templates>
					          <xsl:with-param name="myLabel" select="$myLabel"/>
				        </xsl:apply-templates>
			      </xsl:when>
			      <xsl:otherwise>
				        <li>
					          <xsl:call-template name="multiTextFieldInput"/>
					          <xsl:call-template name="multiFieldIcon">
						            <xsl:with-param name="isSingular" select="1"/>
						            <xsl:with-param name="myLabel" select="$myLabel"/>
					          </xsl:call-template>
				        </li>
			      </xsl:otherwise>
		    </xsl:choose>
	  </xsl:template>
   <xsl:template name="multiTextFieldInput">
		    <xsl:variable name="field" select="ancestor-or-self::ui:multiTextField"/>
		    <xsl:variable name="fieldId">
			      <xsl:value-of select="$field/@id"/>
		    </xsl:variable>
		    <xsl:variable name="name">
			      <xsl:value-of select="$fieldId"/>
		    </xsl:variable>
		    <xsl:variable name="size">
			      <xsl:value-of select="$field/@size"/>
		    </xsl:variable>
		    <xsl:variable name="maxlength">
			      <xsl:value-of select="$field/@maxLength"/>
		    </xsl:variable>
		    <xsl:variable name="minLength">
			      <xsl:value-of select="$field/@minLength"/>
		    </xsl:variable>
		    <xsl:variable name="pattern">
			      <xsl:value-of select="$field/@pattern"/>
		    </xsl:variable>
		    <xsl:element name="input">
			      <xsl:attribute name="type">
				        <xsl:text>text</xsl:text>
			      </xsl:attribute>
			      <xsl:attribute name="name">
				        <xsl:value-of select="$name"/>
			      </xsl:attribute>
			      <xsl:attribute name="id">
				        <xsl:value-of select="concat($fieldId,generate-id())"/>
				        <xsl:if test="self::ui:value">
					          <xsl:value-of select="concat('-',position())"/>
				        </xsl:if>
			      </xsl:attribute>
			      <xsl:attribute name="title">
				        <xsl:value-of select="$mfc2"/>
			      </xsl:attribute>
			      <xsl:if test="$size != ''">
				        <xsl:attribute name="size">
					          <xsl:value-of select="$size"/>
				        </xsl:attribute>
			      </xsl:if>
			      <xsl:if test="$maxlength!=''">
				        <xsl:attribute name="maxlength">
					          <xsl:value-of select="$maxlength"/>
				        </xsl:attribute>
			      </xsl:if>
			      <xsl:if test="$pattern!=''">
				        <xsl:attribute name="pattern">
					          <xsl:value-of select="$pattern"/>
				        </xsl:attribute>
			      </xsl:if>
			      <xsl:if test="$minLength!=''">
				        <xsl:attribute name="data-wc-minlength">
					          <xsl:value-of select="$minLength"/>
				        </xsl:attribute>
			      </xsl:if>
			      <xsl:call-template name="disabledElement">
				        <xsl:with-param name="isControl" select="1"/>
				        <xsl:with-param name="field" select="$field"/>
			      </xsl:call-template>
			      <xsl:if test="self::ui:value">
				        <xsl:attribute name="value">
					          <xsl:value-of select="."/>
				        </xsl:attribute>
			      </xsl:if>
		    </xsl:element>
	  </xsl:template>
   <xsl:template name="WPanelClass">
		    <xsl:call-template name="commonClassHelper"/>
		    <xsl:if test="@type">
			      <xsl:value-of select="concat(' ',@type)"/>
		    </xsl:if>
		    <xsl:choose>
			      <xsl:when test="(@mode='lazy' and @hidden)">
            <xsl:text> wc_magic</xsl:text>
         </xsl:when>
			      <xsl:when test="@mode='dynamic'">
            <xsl:text> wc_magic wc_dynamic</xsl:text>
         </xsl:when>
		    </xsl:choose>
	  </xsl:template>
   <xsl:template name="WPanelContainerElement">
		    <xsl:param name="overrideType"/>
		    <xsl:variable name="type" select="@type"/>
		    <xsl:choose>
			      <xsl:when test="$type='chrome' or $type='action'">
				        <xsl:text>SECTION</xsl:text>
			      </xsl:when>
			      <xsl:when test="contains($type,'header')">
				        <xsl:text>HEADER</xsl:text>
			      </xsl:when>
			      <xsl:when test="contains($type,'footer')">
				        <xsl:text>FOOTER</xsl:text>
			      </xsl:when>
			      <xsl:when test="$overrideType!=''">
				        <xsl:value-of select="$overrideType"/>
			      </xsl:when>
			      <xsl:otherwise>
				        <xsl:text>div</xsl:text>
			      </xsl:otherwise>
		    </xsl:choose>
	  </xsl:template>
   <xsl:template name="WPanelContentPrep">
		    <xsl:apply-templates select="*[not(self::ui:margin)]"/>
	  </xsl:template>
   <xsl:template name="WPanelVisiblePanelTitle">
		    <xsl:if test="(@type='chrome' or @type='action')">
			      <h1>
				        <xsl:value-of select="@title"/>
				        <xsl:if test="not(@title)">
					
					          <xsl:text>Accessibility Error</xsl:text>
				        </xsl:if>
			      </h1>
		    </xsl:if>
	  </xsl:template>
   <xsl:template name="addHeadMetaBeforeTitle">
		
		    <xsl:call-template name="includeFavicon"/>
		
		    <xsl:element name="meta">
			      <xsl:attribute name="name">
				        <xsl:text>format-detection</xsl:text>
			      </xsl:attribute>
			      <xsl:attribute name="content">
				        <xsl:text>telephone=no</xsl:text>
			      </xsl:attribute>
		    </xsl:element>
		    <xsl:element name="meta">
			      <xsl:attribute name="name">
            <xsl:text>viewport</xsl:text>
         </xsl:attribute>
			      <xsl:attribute name="content">
            <xsl:text>initial-scale=1</xsl:text>
         </xsl:attribute>
		    </xsl:element>
	  </xsl:template>
   <xsl:template name="externalScript">
		    <xsl:param name="scriptName"/>
		    <xsl:element name="script">
			      <xsl:attribute name="type">
				        <xsl:text>text/javascript</xsl:text>
			      </xsl:attribute>
			      <xsl:attribute name="src">
				        <xsl:value-of select="concat($resourceRoot, $scriptDir, '/', $scriptName, '.js?', $cacheBuster)"/>
			      </xsl:attribute>
		    </xsl:element>
	  </xsl:template>
   <xsl:template name="getXslPath">
		    <xsl:variable name="field">
			      <xsl:value-of select="//processing-instruction('xml-stylesheet')"/>
		    </xsl:variable>
		    <xsl:variable name="stripStartQuote">
			      <xsl:value-of select="substring-after($field, 'href=&#34;')"/>
		    </xsl:variable>
		    <xsl:variable name="qsunescaped">
			      <xsl:call-template name="replaceString">
				        <xsl:with-param name="text" select="$stripStartQuote"/>
				
				        <xsl:with-param name="replace" select="'&amp;amp;'"/>
				        <xsl:with-param name="with" select="'&amp;'"/>
			      </xsl:call-template>
		    </xsl:variable>
		    <xsl:value-of select="substring-before($qsunescaped, '&#34;')"/>
	  </xsl:template>
   <xsl:template name="includeFavicon">
		    <xsl:choose>
			      <xsl:when test="ui:application/@icon">
				        <xsl:call-template name="faviconHelper">
					          <xsl:with-param name="href">
						            <xsl:value-of select="ui:application[@icon][1]/@icon"/>
					          </xsl:with-param>
				        </xsl:call-template>
			      </xsl:when>
			      <xsl:when test="//html:link[@rel='shortcut icon' or @rel='icon']">
				        <xsl:comment>using link element</xsl:comment>
				        <xsl:apply-templates select="//html:link[@rel='shortcut icon' or @rel='icon'][1]"/>
			      </xsl:when>
			      <xsl:otherwise>
				        <xsl:call-template name="faviconHelper">
					          <xsl:with-param name="href" select="concat($resourceRoot,'images/favicon.ico')"/>
				        </xsl:call-template>
			      </xsl:otherwise>
		    </xsl:choose>
	  </xsl:template>
   <xsl:template name="faviconHelper">
		    <xsl:param name="href"/>
		    <xsl:if test="$href!=''">
			      <xsl:element name="link">
				        <xsl:attribute name="rel">
					          <xsl:text>shortcut icon</xsl:text>
				        </xsl:attribute>
				        <xsl:attribute name="href">
					          <xsl:value-of select="$href"/>
				        </xsl:attribute>
			      </xsl:element>
		    </xsl:if>
	  </xsl:template>
   <xsl:template name="localConfig"/>
   <xsl:template name="makeIE8CompatScripts">
		    <xsl:comment>[if lte IE 8]&gt;
&lt;script type="text/javascript"&gt;
(function(){
	var i,el=["DETAILS","DATALIST","ASIDE","DIALOG","SUMMARY","SECTION","HEADER","NAV","FOOTER","METER","OUTPUT","PROGRESS","AUDIO","VIDEO","SOURCE","TIME","TRACK","FIGCAPTION","FIGURE"];
	require.config["wc/fix/html5Fix_ie8"]={elements:el};
	for(i=0;i &lt; el.length;i++){document.createElement(el[i]);}})();
&lt;/script&gt;
&lt;![endif]</xsl:comment>
	  </xsl:template>
   <xsl:template name="makeRequireConfig">
		    <xsl:element name="script">
			      <xsl:attribute name="type">
				        <xsl:text>text/javascript</xsl:text>
			      </xsl:attribute>
			      <xsl:attribute name="class">
				        <xsl:text>wcconfig</xsl:text>
			      </xsl:attribute>
			
			      <xsl:text>(function(){
	var wcconfig, timing,
		config = {
					paths: {
						tinyMCE: "lib/tinymce/tinymce.min",
						Promise: "lib/Promise.min",
						fabric: "lib/fabric",
						Mustache: "lib/mustache/mustache.min",
						axs: "lib/axs_testing",
						axe: "lib/axe.min"
					},
					shim: {
						tinyMCE: {
							exports: "tinyMCE",
							init: function () {
								this.tinyMCE.DOM.events.domLoaded = true;
								return this.tinyMCE;
							}
						},
						Promise: {
							exports: "Promise"
						},
						fabric: {
							exports: "fabric"
						},
						axs: {
							exports: "axs"
						},
						axe: {
							exports: "axe"
						}
					},
					deps:[],

			</xsl:text>
			      <xsl:value-of select="concat('baseUrl:&#34;', normalize-space($resourceRoot), $scriptDir, '/&#34;,&#xA;')"/>
			      <xsl:value-of select="concat('urlArgs:&#34;', $cacheBuster, '&#34;&#xA;')"/>
			      <xsl:text>};
wcconfig = {"wc/xml/xslTransform": {</xsl:text>
			      <xsl:value-of select="concat('xslEngine:&#34;', system-property('xsl:vendor'), '&#34;,&#xA;')"/>
			
			      <xsl:value-of select="concat('xslUrl:&#34;', normalize-space($xslPath), '&#34;')"/>
			      <xsl:text>},
"wc/i18n/i18n": {</xsl:text>
			      <xsl:value-of select="concat('locale:&#34;', normalize-space($locale), '&#34;')"/>
			      <xsl:text>},
"wc/loader/resource": {</xsl:text>
			      <xsl:value-of select="concat('xmlBaseUrl:&#34;', normalize-space($resourceRoot), 'xml/&#34;,&#xA;')"/>
			      <xsl:value-of select="concat('cachebuster:&#34;', $cacheBuster, '&#34;')"/>
			      <xsl:text>},
"wc/loader/style":{</xsl:text>
			      <xsl:value-of select="concat('cssBaseUrl:&#34;', normalize-space($resourceRoot), 'style/&#34;,&#xA;')"/>
			      <xsl:value-of select="concat('cachebuster:&#34;', $cacheBuster, '&#34;')"/>
			      <xsl:if test="$isDebug=1">
				        <xsl:text>,debug:1</xsl:text>
			      </xsl:if>
			      <xsl:call-template name="styleLoaderConfig"/>
			      <xsl:text>}</xsl:text>
			      <xsl:call-template name="localConfig"/>
			      <xsl:text>};
</xsl:text>
			
			      <xsl:text>
	try{
		timing = {};
		timing[document.readyState] = (new Date()).getTime();
		document.onreadystatechange = function(){
				timing[document.readyState] = (new Date()).getTime();
				if(window.requirejs) window.requirejs.config({"config":{"wc/compat/navigationTiming":{"timing": timing}}});
			};
		wcconfig["wc/compat/navigationTiming"] = {"timing": timing};
	}
	catch(ex){}
	config.config = wcconfig;
	if(window.requirejs) window.requirejs.config(config);
	else require = config;
})();</xsl:text>
		    </xsl:element>
	  </xsl:template>
   <xsl:template name="replaceString">
		    <xsl:param name="text"/>
		    <xsl:param name="replace"/>
		    <xsl:param name="with"/>
		    <xsl:choose>
			      <xsl:when test="contains($text, $replace)">
				        <xsl:value-of select="substring-before($text, $replace)"/>
				        <xsl:value-of select="$with"/>
				        <xsl:call-template name="replaceString">
					          <xsl:with-param name="text" select="substring-after($text,$replace)"/>
					          <xsl:with-param name="replace" select="$replace"/>
					          <xsl:with-param name="with" select="$with"/>
				        </xsl:call-template>
			      </xsl:when>
			      <xsl:otherwise>
				        <xsl:value-of select="$text"/>
			      </xsl:otherwise>
		    </xsl:choose>
	  </xsl:template>
   <xsl:template name="styleLoaderConfig"/>
   <xsl:template name="wcBodyClass">
		    <xsl:if test="$isDebug=1">
			      <xsl:text>wc_debug</xsl:text>
		    </xsl:if>
	  </xsl:template>
   <xsl:template name="WSectionClass">
		    <xsl:call-template name="commonClassHelper"/>
		    <xsl:if test="@mode='lazy' and @hidden">
			      <xsl:text> wc_magic</xsl:text>
		    </xsl:if>
	  </xsl:template>
   <xsl:template name="hideTab">
		    <xsl:choose>
			      <xsl:when test="parent::ui:ajaxTarget">
				
				        <xsl:if test="not(@open)">
					          <xsl:call-template name="hideElementIfHiddenSet"/>
				        </xsl:if>
			      </xsl:when>
			      <xsl:otherwise>
				        <xsl:call-template name="hideElementIfHiddenSet"/>
			      </xsl:otherwise>
		    </xsl:choose>
	  </xsl:template>
   <xsl:template name="tabElement">
		    <xsl:text>button</xsl:text>
	  </xsl:template>
   <xsl:template name="WTableContainerClass">
		    <xsl:param name="isError"/>
		    <xsl:call-template name="commonClassHelper"/>
		    <xsl:if test="$isError">
			      <xsl:text> wc_error</xsl:text>
		    </xsl:if>
	  </xsl:template>
   <xsl:template name="caption">
		    <xsl:if test="@caption and not(@caption='')">
			      <caption>
				        <xsl:value-of select="@caption"/>	
			      </caption>
		    </xsl:if>
	  </xsl:template>
   <xsl:template name="cellIndentationHelper">
		    <xsl:param name="indent" select="0"/>
		    <xsl:if test="$indent &gt; 0">
			      <span class="wc-row-indent" aria-hidden="true">
</span>
			      <xsl:call-template name="cellIndentationHelper">
				        <xsl:with-param name="indent" select="$indent - 1"/>
			      </xsl:call-template>
		    </xsl:if>
	  </xsl:template>
   <xsl:template name="tableAjaxController">
		    <xsl:param name="tableId"/>
		    <xsl:attribute name="aria-controls">
			      <xsl:value-of select="$tableId"/>
		    </xsl:attribute>
		    <xsl:attribute name="data-wc-ajaxalias">
			      <xsl:value-of select="$tableId"/>
		    </xsl:attribute>
	  </xsl:template>
   <xsl:template name="tableBottomControls">
		    <xsl:variable name="showPagination">
			      <xsl:choose>
				        <xsl:when test="ui:pagination and not(ui:pagination/@controls='top')">
					          <xsl:number value="1"/>
				        </xsl:when>
				        <xsl:otherwise>
					          <xsl:number value="0"/>
				        </xsl:otherwise>
			      </xsl:choose>
		    </xsl:variable>
		    <xsl:if test="ui:actions or $showPagination=1">
			      <div>
				        <xsl:if test="$showPagination=1">
					          <div class="wc_table_pag_cont">
						            <xsl:apply-templates select="ui:pagination"/>
					          </div>
				        </xsl:if>
				        <xsl:if test="ui:actions">
					          <div>
						            <xsl:apply-templates select="ui:actions"/>
					          </div>
				        </xsl:if>
			      </div>
		    </xsl:if>
	  </xsl:template>
   <xsl:template name="topControls">
		    <xsl:variable name="id" select="@id"/>
		    <xsl:variable name="hasExpandAll">
			      <xsl:choose>
				        <xsl:when test="ui:rowExpansion/@expandAll=$t and .//ui:subTr[ancestor::ui:table[1]/@id=$id]">
					          <xsl:number value="1"/>
				        </xsl:when>
				        <xsl:otherwise>
					          <xsl:number value="0"/>
				        </xsl:otherwise>
			      </xsl:choose>
		    </xsl:variable>
		
		    <xsl:variable name="hasRowSelection">
			      <xsl:choose>
				        <xsl:when test="ui:rowSelection[@selectAll='text'] and ..//ui:tr[not(@unselectable=$t) and ancestor::ui:table[1]/@id=$id]">
					          <xsl:number value="1"/>
				        </xsl:when>
				        <xsl:otherwise>
					          <xsl:number value="0"/>
				        </xsl:otherwise>
			      </xsl:choose>
		    </xsl:variable>
		
		    <xsl:variable name="hasPagination">
			      <xsl:choose>
				        <xsl:when test="not(ui:pagination) or not(ui:pagination/@controls) or ui:pagination/@controls = 'bottom'">
					          <xsl:number value="0"/>
				        </xsl:when>
				        <xsl:when test="ui:pagination">
					          <xsl:number value="1"/>
				        </xsl:when>
				        <xsl:otherwise>
					          <xsl:number value="0"/>
				        </xsl:otherwise>
			      </xsl:choose>
		    </xsl:variable>

		    <xsl:if test="$hasExpandAll + $hasRowSelection + $hasPagination &gt; 0">
			      <div class="wc_table_top_controls">
				        <xsl:if test="$hasRowSelection = 1">
					          <div class="wc_table_sel_cont">
						            <xsl:apply-templates select="ui:rowSelection"/>
					          </div>
				        </xsl:if>
				        <xsl:if test="$hasExpandAll = 1">
					          <div class="wc_table_exp_cont">
						            <xsl:apply-templates select="ui:rowExpansion"/>
					          </div>
				        </xsl:if>
				        <xsl:if test="$hasPagination = 1">
					          <div class="wc_table_pag_cont">
						            <xsl:apply-templates select="ui:pagination">
							              <xsl:with-param name="idSuffix" select="'top'"/>
						            </xsl:apply-templates>
					          </div>
				        </xsl:if>
			      </div>
		    </xsl:if>
	  </xsl:template>
   <xsl:template name="paginationDescription">
		    <xsl:variable name="rpp" select="@rowsPerPage"/>
		    <xsl:variable name="startRow">
			      <xsl:choose>
				        <xsl:when test="$rpp">
					          <xsl:value-of select="@currentPage * $rpp + 1"/>
				        </xsl:when>
				        <xsl:otherwise>
					          <xsl:number value="1"/>
				        </xsl:otherwise>
			      </xsl:choose>
		    </xsl:variable>
		    <xsl:variable name="prelimEndRow">
			      <xsl:choose>
				        <xsl:when test="$rpp">
					          <xsl:value-of select="$startRow + $rpp - 1"/>
				        </xsl:when>
				        <xsl:otherwise>
					          <xsl:number value="@rows"/>
				        </xsl:otherwise>
			      </xsl:choose>
		    </xsl:variable>
		
		    <xsl:variable name="endRow">
			      <xsl:choose>
				        <xsl:when test="$prelimEndRow &gt; @rows">
					          <xsl:value-of select="@rows"/>
				        </xsl:when>
				        <xsl:otherwise>
					          <xsl:value-of select="$prelimEndRow"/>
				        </xsl:otherwise>
			      </xsl:choose>
		    </xsl:variable>

		    <xsl:variable name="numberPlaceHolder1" select="'^'"/>
		    <xsl:variable name="numberPlaceHolder2" select="'|'"/>
		    <xsl:variable name="numberPlaceHolder3" select="'#'"/>
		    <span class="wc_table_pag_rows">
			      <xsl:choose>
				        <xsl:when test="@rows = 1">
					          <xsl:value-of select="$wdtp5"/>
				        </xsl:when>
				        <xsl:when test="$rpp = 1">
					          <xsl:variable name="oneRowPerPageString" select="$wdtp6"/>
					          <xsl:value-of select="substring-before($oneRowPerPageString,$numberPlaceHolder1)"/>
					          <span class="wc_table_pag_rowstart">
						            <xsl:value-of select="$startRow"/>
					          </span>
					          <xsl:variable name="subString1"
                             select="substring-after($oneRowPerPageString,$numberPlaceHolder1)"/>
					          <xsl:value-of select="substring-before($subString1,$numberPlaceHolder3)"/>
					          <xsl:value-of select="@rows"/>
					          <xsl:value-of select="substring-after($subString1,$numberPlaceHolder3)"/>
				        </xsl:when>
				        <xsl:otherwise>
					          <xsl:variable name="manyRowsPerPageString" select="$wdtp7"/>
					          <xsl:value-of select="substring-before($manyRowsPerPageString,$numberPlaceHolder1)"/>
					          <span class="wc_table_pag_rowstart">
						            <xsl:value-of select="$startRow"/>
					          </span>
					          <xsl:variable name="subString2a"
                             select="substring-after($manyRowsPerPageString,$numberPlaceHolder1)"/>
					          <xsl:value-of select="substring-before($subString2a,$numberPlaceHolder2)"/>
					          <span class="wc_table_pag_rowend">
						            <xsl:value-of select="$endRow"/>
					          </span>
					          <xsl:variable name="subString2b"
                             select="substring-after($subString2a,$numberPlaceHolder2)"/>
					          <xsl:value-of select="substring-before($subString2b,$numberPlaceHolder3)"/>
					          <xsl:value-of select="@rows"/>
					          <xsl:value-of select="substring-after($subString2b,$numberPlaceHolder3)"/>
				        </xsl:otherwise>
			      </xsl:choose>
		    </span>
	  </xsl:template>
   <xsl:template name="paginationButton">
		    <xsl:param name="title"/>
		    <xsl:param name="type"/>
		    <xsl:param name="idSuffix"/>
		    <xsl:param name="disabled"/>
		    <xsl:element name="button">
			      <xsl:attribute name="id">
				        <xsl:value-of select="concat(../@id,'.pagination.',$idSuffix)"/>
			      </xsl:attribute>
			      <xsl:attribute name="title">
				        <xsl:value-of select="$title"/>
			      </xsl:attribute>
			      <xsl:attribute name="type">
				        <xsl:value-of select="$type"/>
			      </xsl:attribute>
			      <xsl:if test="$type='submit'">
				        <xsl:attribute name="formnovalidate">
					          <xsl:text>formnovalidate</xsl:text>
				        </xsl:attribute>
			      </xsl:if>
			      <xsl:attribute name="class">
				        <xsl:text>wc_ibtn</xsl:text>
			      </xsl:attribute>
			      <xsl:choose>
				        <xsl:when test="$disabled = 1">
					          <xsl:attribute name="disabled">
						            <xsl:text>disabled</xsl:text>
					          </xsl:attribute>
				        </xsl:when>
				        <xsl:otherwise>
					          <xsl:call-template name="disabledElement">
						            <xsl:with-param name="field" select="parent::ui:table"/>
						            <xsl:with-param name="isControl" select="1"/>
					          </xsl:call-template>
				        </xsl:otherwise>
			      </xsl:choose>
		    </xsl:element>
	  </xsl:template>
   <xsl:template name="pagination.option.for.loop">
		    <xsl:param name="i"/>
		    <xsl:param name="count"/>
		    <xsl:param name="current"/>
		    <xsl:if test="$i &lt; $count">
			      <option value="{$i}">
				        <xsl:if test="$i = $current">
					          <xsl:attribute name="selected">selected</xsl:attribute>
				        </xsl:if>
				        <xsl:value-of select="$i + 1"/>
			      </option>
			      <xsl:call-template name="pagination.option.for.loop">
				        <xsl:with-param name="i" select="$i + 1"/>
				        <xsl:with-param name="count" select="$count"/>
				        <xsl:with-param name="current" select="$current"/>
			      </xsl:call-template>
		    </xsl:if>
	  </xsl:template>
   <xsl:template name="clientRowClosedHelper">
		    <xsl:param name="myTable"/>
		    <xsl:variable name="clientPaginationRows">
			      <xsl:choose>
				        <xsl:when test="$myTable/ui:pagination/@rowsPerPage">
					          <xsl:value-of select="$myTable/ui:pagination/@rowsPerPage"/>
				        </xsl:when>
				        <xsl:otherwise>
					          <xsl:value-of select="$myTable/ui:pagination/@rows"/>
				        </xsl:otherwise>
			      </xsl:choose>
		    </xsl:variable>
		    <xsl:variable name="tableCurrentPage" select="$myTable/ui:pagination/@currentPage"/>
		    <xsl:variable name="myPosition" select="count(preceding-sibling::ui:tr) + 1"/>
		    <xsl:variable name="activeStart"
                    select="($clientPaginationRows * $tableCurrentPage) + 1"/>
		    <xsl:choose>
			      <xsl:when test="(($myPosition &lt; $activeStart) or ($myPosition &gt;= ($activeStart + $clientPaginationRows)))">
				        <xsl:value-of select="1"/>
			      </xsl:when>
			      <xsl:otherwise>
				        <xsl:value-of select="0"/>
			      </xsl:otherwise>
		    </xsl:choose>
	  </xsl:template>
   <xsl:template name="WTabsetClass">
		    <xsl:call-template name="commonClassHelper"/>
		    <xsl:value-of select="concat(' ', @type)"/>
		    <xsl:if test="@type='left' or @type='right'">
			      <xsl:text> wc_tab_lr</xsl:text>
		    </xsl:if>
	  </xsl:template>
   <xsl:template name="doTabList">
		    <xsl:param name="firstOpenTab"/>
		    <xsl:element name="div">
			      <xsl:attribute name="role">
				        <xsl:text>tablist</xsl:text>
			      </xsl:attribute>
			      <xsl:if test="@type='accordion'">
				        <xsl:attribute name="aria-multiselectable">
					          <xsl:choose>
						            <xsl:when test="@single">false</xsl:when>
						            <xsl:otherwise>true</xsl:otherwise>
					          </xsl:choose>
				        </xsl:attribute>
			      </xsl:if>
			      <xsl:call-template name="tabsetApply">
				        <xsl:with-param name="firstOpenTab" select="$firstOpenTab"/>
			      </xsl:call-template>
		    </xsl:element>
	  </xsl:template>
   <xsl:template name="tabsAfterContent">
		    <xsl:if test="@type ='right'">
			      <xsl:number value="1"/>
		    </xsl:if>
	  </xsl:template>
   <xsl:template name="tabsetApply">
		    <xsl:param name="firstOpenTab"/>
		    <xsl:apply-templates select="ui:tab|ui:tabGroup/ui:tab">
			      <xsl:with-param name="tabset" select="."/>
			      <xsl:with-param name="firstOpenTab" select="$firstOpenTab"/>
		    </xsl:apply-templates>
	  </xsl:template>
   <xsl:template name="WStyledTextContent">
		    <xsl:param name="type"/>
		    <xsl:variable name="innerElem">
			      <xsl:call-template name="WStyledTextGetElementFromType">
				        <xsl:with-param name="type" select="$type"/>
			      </xsl:call-template>
		    </xsl:variable>
		    <xsl:choose>
			      <xsl:when test="$type='plain' or not($type)">
				        <xsl:value-of select="."/>
			      </xsl:when>
			      <xsl:when test="$innerElem !=''">
				        <xsl:element name="{$innerElem}">
					          <xsl:attribute name="class">
						            <xsl:value-of select="$type"/>
					          </xsl:attribute>
					          <xsl:value-of select="."/>
				        </xsl:element>
			      </xsl:when>
			      <xsl:otherwise>
				        <xsl:value-of select="."/>
			      </xsl:otherwise>
		    </xsl:choose>
	  </xsl:template>
   <xsl:template name="WStyledTextGetElementFromType">
		    <xsl:param name="type" select="@type"/>
		    <xsl:choose>
			      <xsl:when test="$type='emphasised' or $type='highPriority'">
				        <xsl:text>strong</xsl:text>
			      </xsl:when>
			      <xsl:when test="$type='mediumPriority'">
				        <xsl:text>em</xsl:text>
			      </xsl:when>
			      <xsl:when test="$type='insert'">
				        <xsl:text>ins</xsl:text>
			      </xsl:when>
			      <xsl:when test="$type='delete'">
				        <xsl:text>del</xsl:text>
			      </xsl:when>
			      <xsl:when test="self::ui:text">
				        <xsl:text>span</xsl:text>
			      </xsl:when>
		    </xsl:choose>
	  </xsl:template>
</xsl:stylesheet>
