/**
 * @module
 * @requires module:wc/timers
 */
define(["wc/timers"], /** @param timers wc/timers @ignore */ function(timers) {
	"use strict";

	/**
	 * Provides a helper to remove elements from the DOM. This helper was built especially to remove SCRIPT elements
	 * generated by the registration scripts and debugInfo registration. You probably don't want to use it as a generic
	 * element removal wrapper but you could.
	 *
	 * @function module:wc/dom/removeElement
	 *
	 * @param {string} id The id of the element to be removed.
	 * @param {int} [useTimeout] If set then wrap the removal in a timeout of this many milliseconds. Probably pointless
	 * especially if this is called from a finally block.
	 */
	function remove(id, useTimeout) {
		var _timeout = useTimeout || 0;
		if (!id) {
			return;
		}

		function _remove() {
			var el,
				parent;
			if ((el = document.getElementById(id)) && (parent = el.parentNode)) {
				parent.removeChild(el);
			}
		}

		if (useTimeout || useTimeout === 0) {
			timers.setTimeout(_remove, _timeout);
		}
		else {
			_remove();
		}
	}
	return remove;
});
