/*! aXe v1.1.1
 * Copyright (c) 2015 Deque Systems, Inc.
 *
 * Your use of this Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This entire copyright notice must appear in every copy of this file you
 * distribute or in any file that contains substantial portions of this source
 * code.
 */
!function(a,b){function c(a){"use strict";var b,d,e=a;if(null!==a&&"object"==typeof a)if(Array.isArray(a))for(e=[],b=0,d=a.length;d>b;b++)e[b]=c(a[b]);else{e={};for(b in a)e[b]=c(a[b])}return e}function d(a){"use strict";var b=a||{};return b.rules=b.rules||[],b.tools=b.tools||[],b.checks=b.checks||[],b.data=b.data||{checks:{},rules:{}},b}function e(a,b,c){"use strict";var d,e;for(d=0,e=a.length;e>d;d++)b[c](a[d])}function f(a){"use strict";a=d(a),S.commons=R=a.commons,this.reporter=a.reporter,this.rules=[],this.tools={},this.checks={},e(a.rules,this,"addRule"),e(a.tools,this,"addTool"),e(a.checks,this,"addCheck"),this.data=a.data||{checks:{},rules:{}},H(a.style)}function g(a){"use strict";this.id=a.id,this.data=null,this.relatedNodes=[],this.result=null}function h(a){"use strict";this.id=a.id,this.options=a.options,this.selector=a.selector,this.evaluate=a.evaluate,a.after&&(this.after=a.after),a.matches&&(this.matches=a.matches),this.enabled=a.hasOwnProperty("enabled")?a.enabled:!0}function i(a,b){"use strict";if(!T.isHidden(b)){var c=T.findBy(a,"node",b);c||a.push({node:b,include:[],exclude:[]})}}function j(a,c,d){"use strict";a.frames=a.frames||[];var e,f,g=b.querySelectorAll(d.shift());a:for(var h=0,i=g.length;i>h;h++){f=g[h];for(var j=0,k=a.frames.length;k>j;j++)if(a.frames[j].node===f){a.frames[j][c].push(d);break a}e={node:f,include:[],exclude:[]},d&&e[c].push(d),a.frames.push(e)}}function k(a){"use strict";if(a&&"object"==typeof a||a instanceof NodeList){if(a instanceof Node)return{include:[a],exclude:[]};if(a.hasOwnProperty("include")||a.hasOwnProperty("exclude"))return{include:a.include||[b],exclude:a.exclude||[]};if(a.length===+a.length)return{include:a,exclude:[]}}return"string"==typeof a?{include:[a],exclude:[]}:{include:[b],exclude:[]}}function l(a,c){"use strict";for(var d,e=[],f=0,g=a[c].length;g>f;f++){if(d=a[c][f],"string"==typeof d){e=e.concat(T.toArray(b.querySelectorAll(d)));break}d&&d.length?d.length>1?j(a,c,d):e=e.concat(T.toArray(b.querySelectorAll(d[0]))):e.push(d)}return e.filter(function(a){return a})}function m(a){"use strict";var c=this;this.frames=[],this.initiator=a&&"boolean"==typeof a.initiator?a.initiator:!0,this.page=!1,a=k(a),this.exclude=a.exclude,this.include=a.include,this.include=l(this,"include"),this.exclude=l(this,"exclude"),T.select("frame, iframe",this).forEach(function(a){M(a,c)&&i(c.frames,a)}),1===this.include.length&&this.include[0]===b&&(this.page=!0)}function n(a){"use strict";this.id=a.id,this.result=S.constants.result.NA,this.pageLevel=a.pageLevel,this.impact=null,this.nodes=[]}function o(a,b){"use strict";this._audit=b,this.id=a.id,this.selector=a.selector||"*",this.excludeHidden="boolean"==typeof a.excludeHidden?a.excludeHidden:!0,this.enabled="boolean"==typeof a.enabled?a.enabled:!0,this.pageLevel="boolean"==typeof a.pageLevel?a.pageLevel:!1,this.any=a.any||[],this.all=a.all||[],this.none=a.none||[],this.tags=a.tags||[],a.matches&&(this.matches=a.matches)}function p(a){"use strict";return T.getAllChecks(a).map(function(b){var c=a._audit.checks[b.id||b];return"function"==typeof c.after?c:null}).filter(Boolean)}function q(a,b){"use strict";var c=[];return a.forEach(function(a){var d=T.getAllChecks(a);d.forEach(function(a){a.id===b&&c.push(a)})}),c}function r(a){"use strict";return a.filter(function(a){return a.filtered!==!0})}function s(a){"use strict";var b=["any","all","none"],c=a.nodes.filter(function(a){var c=0;return b.forEach(function(b){a[b]=r(a[b]),c+=a[b].length}),c>0});return a.pageLevel&&c.length&&(c=[c.reduce(function(a,c){return a?(b.forEach(function(b){a[b].push.apply(a[b],c[b])}),a):void 0})]),c}function t(a){"use strict";a.source=a.source||{},this.id=a.id,this.options=a.options,this._run=a.source.run,this._cleanup=a.source.cleanup,this.active=!1}function u(a){"use strict";if(!S._audit)throw new Error("No audit configured");var c=T.queue();Object.keys(S._audit.tools).forEach(function(a){var b=S._audit.tools[a];b.active&&c.defer(function(a){b.cleanup(a)})}),T.toArray(b.querySelectorAll("frame, iframe")).forEach(function(a){c.defer(function(b){return T.sendCommandToFrame(a,{command:"cleanup-tool"},b)})}),c.then(a)}function v(a,c){"use strict";var d=a&&a.context||{};d.include&&!d.include.length&&(d.include=[b]);var e=a&&a.options||{};switch(a.command){case"rules":return x(d,e,c);case"run-tool":return y(a.parameter,a.selectorArray,e,c);case"cleanup-tool":return u(c)}}function w(a){"use strict";return"string"==typeof a&&W[a]?W[a]:"function"==typeof a?a:V}function x(a,b,c){"use strict";a=new m(a);var d=T.queue(),e=S._audit;a.frames.length&&d.defer(function(c){T.collectResultsFromFrames(a,b,"rules",null,c)}),d.defer(function(c){e.run(a,b,c)}),d.then(function(d){var f=T.mergeResults(d.map(function(a){return{results:a}}));a.initiator&&(f=e.after(f,b),f=f.map(T.finalizeRuleResult)),c(f)})}function y(a,c,d,e){"use strict";if(!S._audit)throw new Error("No audit configured");if(c.length>1){var f=b.querySelector(c.shift());return T.sendCommandToFrame(f,{options:d,command:"run-tool",parameter:a,selectorArray:c},e)}var g=b.querySelector(c.shift());S._audit.tools[a].run(g,d,e)}function z(a,b){"use strict";if(b=b||300,a.length>b){var c=a.indexOf(">");a=a.substring(0,c+1)}return a}function A(a){"use strict";var b=a.outerHTML;return b||"function"!=typeof XMLSerializer||(b=(new XMLSerializer).serializeToString(a)),z(b||"")}function B(a,b){"use strict";b=b||{},this.selector=b.selector||[T.getSelector(a)],this.source=void 0!==b.source?b.source:A(a),this.element=a}function C(a,b){"use strict";Object.keys(S.constants.raisedMetadata).forEach(function(c){var d=S.constants.raisedMetadata[c],e=b.reduce(function(a,b){var e=d.indexOf(b[c]);return e>a?e:a},-1);d[e]&&(a[c]=d[e])})}function D(a){"use strict";var b=a.any.length||a.all.length||a.none.length;return b?S.constants.result.FAIL:S.constants.result.PASS}function E(a){"use strict";function b(a){return T.extendBlacklist({},a,["result"])}var c=T.extendBlacklist({violations:[],passes:[]},a,["nodes"]);return a.nodes.forEach(function(a){var d=T.getFailingChecks(a),e=D(d);return e===S.constants.result.FAIL?(C(a,T.getAllChecks(d)),a.any=d.any.map(b),a.all=d.all.map(b),a.none=d.none.map(b),void c.violations.push(a)):(a.any=a.any.filter(function(a){return a.result}).map(b),a.all=a.all.map(b),a.none=a.none.map(b),void c.passes.push(a))}),C(c,c.violations),c.result=c.violations.length?S.constants.result.FAIL:c.passes.length?S.constants.result.PASS:c.result,c}function F(a){"use strict";for(var b=1,c=a.nodeName;a=a.previousElementSibling;)a.nodeName===c&&b++;return b}function G(a,b){"use strict";var c,d,e=a.parentNode.children;if(!e)return!1;var f=e.length;for(c=0;f>c;c++)if(d=e[c],d!==a&&T.matchesSelector(d,b))return!0;return!1}function H(a){"use strict";if(X&&X.parentNode&&(X.parentNode.removeChild(X),X=null),a){var c=b.head||b.getElementsByTagName("head")[0];return X=b.createElement("style"),X.type="text/css",void 0===X.styleSheet?X.appendChild(b.createTextNode(a)):X.styleSheet.cssText=a,c.appendChild(X),X}}function I(a,b,c){"use strict";a.forEach(function(a){a.node.selector.unshift(c),a.node=new T.DqElement(b,a.node);var d=T.getAllChecks(a);d.length&&d.forEach(function(a){a.relatedNodes.forEach(function(a){a.selector.unshift(c),a=new T.DqElement(b,a)})})})}function J(a,b){"use strict";for(var c,d,e=b[0].node,f=0,g=a.length;g>f;f++)if(d=a[f].node,c=T.nodeSorter(d.element,e.element),c>0||0===c&&e.selector.length<d.selector.length)return void a.splice.apply(a,[f,0].concat(b));a.push.apply(a,b)}function K(a){"use strict";return a&&a.results?Array.isArray(a.results)?a.results.length?a.results:null:[a.results]:null}function L(a){"use strict";return a.sort(function(a,b){return T.contains(a,b)?1:-1})[0]}function M(a,b){"use strict";var c=b.include&&L(b.include.filter(function(b){return T.contains(b,a)})),d=b.exclude&&L(b.exclude.filter(function(b){return T.contains(b,a)}));return!d&&c||d&&T.contains(d,c)?!0:!1}function N(a,b,c){"use strict";for(var d=0,e=b.length;e>d;d++)-1===a.indexOf(b[d])&&M(b[d],c)&&a.push(b[d])}var O,P=function(){"use strict";function a(a){var b,c,d=a.Element.prototype,e=["matches","matchesSelector","mozMatchesSelector","webkitMatchesSelector","msMatchesSelector"],f=e.length;for(b=0;f>b;b++)if(c=e[b],d[c])return c}var b;return function(c,d){return b&&c[b]||(b=a(c.ownerDocument.defaultView)),c[b](d)}}(),Q=function(a){"use strict";for(var b,c=String(a),d=c.length,e=-1,f="",g=c.charCodeAt(0);++e<d;){if(b=c.charCodeAt(e),0==b)throw new Error("INVALID_CHARACTER_ERR");f+=b>=1&&31>=b||b>=127&&159>=b||0==e&&b>=48&&57>=b||1==e&&b>=48&&57>=b&&45==g?"\\"+b.toString(16)+" ":(1!=e||45!=b||45!=g)&&(b>=128||45==b||95==b||b>=48&&57>=b||b>=65&&90>=b||b>=97&&122>=b)?c.charAt(e):"\\"+c.charAt(e)}return f};!function(a){function b(a,b,c){var d=b&&c||0,e=0;for(b=b||[],a.toLowerCase().replace(/[0-9a-f]{2}/g,function(a){16>e&&(b[d+e++]=l[a])});16>e;)b[d+e++]=0;return b}function c(a,b){var c=b||0,d=k;return d[a[c++]]+d[a[c++]]+d[a[c++]]+d[a[c++]]+"-"+d[a[c++]]+d[a[c++]]+"-"+d[a[c++]]+d[a[c++]]+"-"+d[a[c++]]+d[a[c++]]+"-"+d[a[c++]]+d[a[c++]]+d[a[c++]]+d[a[c++]]+d[a[c++]]+d[a[c++]]}function d(a,b,d){var e=b&&d||0,f=b||[];a=a||{};var g=null!=a.clockseq?a.clockseq:p,h=null!=a.msecs?a.msecs:(new Date).getTime(),i=null!=a.nsecs?a.nsecs:r+1,j=h-q+(i-r)/1e4;if(0>j&&null==a.clockseq&&(g=g+1&16383),(0>j||h>q)&&null==a.nsecs&&(i=0),i>=1e4)throw new Error("uuid.v1(): Can't create more than 10M uuids/sec");q=h,r=i,p=g,h+=122192928e5;var k=(1e4*(268435455&h)+i)%4294967296;f[e++]=k>>>24&255,f[e++]=k>>>16&255,f[e++]=k>>>8&255,f[e++]=255&k;var l=h/4294967296*1e4&268435455;f[e++]=l>>>8&255,f[e++]=255&l,f[e++]=l>>>24&15|16,f[e++]=l>>>16&255,f[e++]=g>>>8|128,f[e++]=255&g;for(var m=a.node||o,n=0;6>n;n++)f[e+n]=m[n];return b?b:c(f)}function e(a,b,d){var e=b&&d||0;"string"==typeof a&&(b="binary"==a?new j(16):null,a=null),a=a||{};var g=a.random||(a.rng||f)();if(g[6]=15&g[6]|64,g[8]=63&g[8]|128,b)for(var h=0;16>h;h++)b[e+h]=g[h];return b||c(g)}var f,g=a.crypto||a.msCrypto;if(!f&&g&&g.getRandomValues){var h=new Uint8Array(16);f=function(){return g.getRandomValues(h),h}}if(!f){var i=new Array(16);f=function(){for(var a,b=0;16>b;b++)0===(3&b)&&(a=4294967296*Math.random()),i[b]=a>>>((3&b)<<3)&255;return i}}for(var j="function"==typeof a.Buffer?a.Buffer:Array,k=[],l={},m=0;256>m;m++)k[m]=(m+256).toString(16).substr(1),l[k[m]]=m;var n=f(),o=[1|n[0],n[1],n[2],n[3],n[4],n[5]],p=16383&(n[6]<<8|n[7]),q=0,r=0;O=e,O.v1=d,O.v4=e,O.parse=b,O.unparse=c,O.BufferClass=j}(a);var R,S={},T=S.utils={};T.matchesSelector=P,T.escapeSelector=Q,T.clone=c;var U={};f.prototype.addRule=function(a){"use strict";a.metadata&&(this.data.rules[a.id]=a.metadata);for(var b,c=0,d=this.rules.length;d>c;c++)if(b=this.rules[c],b.id===a.id)return void(this.rules[c]=new o(a,this));this.rules.push(new o(a,this))},f.prototype.addTool=function(a){"use strict";this.tools[a.id]=new t(a)},f.prototype.addCheck=function(a){"use strict";a.metadata&&(this.data.checks[a.id]=a.metadata),this.checks[a.id]=new h(a)},f.prototype.run=function(a,b,c){"use strict";var d=T.queue();this.rules.forEach(function(c){T.ruleShouldRun(c,a,b)&&d.defer(function(d){c.run(a,b,d)})}),d.then(c)},f.prototype.after=function(a,b){"use strict";var c=this.rules;return a.map(function(a){var d=T.findBy(c,"id",a.id);return d.after(a,b)})},h.prototype.matches=function(a){"use strict";return!this.selector||T.matchesSelector(a,this.selector)?!0:!1},h.prototype.run=function(a,b,c){"use strict";b=b||{};var d=b.hasOwnProperty("enabled")?b.enabled:this.enabled,e=b.options||this.options;if(d&&this.matches(a)){var f,h=new g(this),i=T.checkHelper(h,c);try{f=this.evaluate.call(i,a,e)}catch(j){return S.log(j.message,j.stack),void c(null)}i.isAsync||(h.result=f,setTimeout(function(){c(h)},0))}else c(null)},o.prototype.matches=function(){"use strict";return!0},o.prototype.gather=function(a){"use strict";var b=T.select(this.selector,a);return this.excludeHidden?b.filter(function(a){return!T.isHidden(a)}):b},o.prototype.runChecks=function(a,b,c,d){"use strict";var e=this,f=T.queue();this[a].forEach(function(a){var d=e._audit.checks[a.id||a],g=T.getCheckOption(d,e.id,c);f.defer(function(a){d.run(b,g,a)})}),f.then(function(b){b=b.filter(function(a){return a}),d({type:a,results:b})})},o.prototype.run=function(a,b,c){"use strict";var d,e=this.gather(a),f=T.queue(),g=this;d=new n(this),e.forEach(function(a){g.matches(a)&&f.defer(function(c){var e=T.queue();e.defer(function(c){g.runChecks("any",a,b,c)}),e.defer(function(c){g.runChecks("all",a,b,c)}),e.defer(function(c){g.runChecks("none",a,b,c)}),e.then(function(b){if(b.length){var e=!1,f={node:new T.DqElement(a)};b.forEach(function(a){var b=a.results.filter(function(a){return a});f[a.type]=b,b.length&&(e=!0)}),e&&d.nodes.push(f)}c()})})}),f.then(function(){c(d)})},o.prototype.after=function(a,b){"use strict";var c=p(this),d=this.id;return c.forEach(function(c){var e=q(a.nodes,c.id),f=T.getCheckOption(c,d,b),g=c.after(e,f);e.forEach(function(a){-1===g.indexOf(a)&&(a.filtered=!0)})}),a.nodes=s(a),a},t.prototype.run=function(a,b,c){"use strict";b="undefined"==typeof b?this.options:b,this.active=!0,this._run(a,b,c)},t.prototype.cleanup=function(a){"use strict";this.active=!1,this._cleanup(a)},S.constants={},S.constants.result={PASS:"PASS",FAIL:"FAIL",NA:"NA"},S.constants.raisedMetadata={impact:["minor","moderate","serious","critical"]},S.version="dev",a.axe=S,S.log=function(){"use strict";"object"==typeof console&&console.log&&Function.prototype.apply.call(console.log,console,arguments)},S.cleanup=u,S.configure=function(a){"use strict";var b=S._audit;if(!b)throw new Error("No audit configured");a.reporter&&("function"==typeof a.reporter||W[a.reporter])&&(b.reporter=a.reporter),a.checks&&a.checks.forEach(function(a){b.addCheck(a)}),a.rules&&a.rules.forEach(function(a){b.addRule(a)}),a.tools&&a.tools.forEach(function(a){b.addTool(a)})},S.getRules=function(a){"use strict";a=a||[];var b=a.length?S._audit.rules.filter(function(b){return!!a.filter(function(a){return-1!==b.tags.indexOf(a)}).length}):S._audit.rules,c=S._audit.data.rules||{};return b.map(function(a){var b=c[a.id]||{};return{ruleId:a.id,description:b.description,help:b.help,helpUrl:b.helpUrl,tags:a.tags}})},S._load=function(a){"use strict";T.respondable.subscribe("axe.ping",function(a,b){b({axe:!0})}),T.respondable.subscribe("axe.start",v),S._audit=new f(a)};var V,W={};S.reporter=function(a,b,c){"use strict";W[a]=b,c&&(V=b)},S.a11yCheck=function(a,b,c){"use strict";"function"==typeof b&&(c=b,b={}),b&&"object"==typeof b||(b={});var d=S._audit;if(!d)throw new Error("No audit configured");var e=w(b.reporter||d.reporter);x(a,b,function(a){e(a,c)})},S.tool=y,U.failureSummary=function(a){"use strict";var b={};return b.none=a.none.concat(a.all),b.any=a.any,Object.keys(b).map(function(a){return b[a].length?S._audit.data.failureSummaries[a].failureMessage(b[a].map(function(a){return a.message||""})):void 0}).filter(function(a){return void 0!==a}).join("\n\n")},U.formatCheck=function(a){"use strict";return{id:a.id,impact:a.impact,message:a.message,data:a.data,relatedNodes:a.relatedNodes.map(U.formatNode)}},U.formatChecks=function(a,b){"use strict";return a.any=b.any.map(U.formatCheck),a.all=b.all.map(U.formatCheck),a.none=b.none.map(U.formatCheck),a},U.formatNode=function(a){"use strict";return{target:a?a.selector:null,html:a?a.source:null}},U.formatRuleResult=function(a){"use strict";return{id:a.id,description:a.description,help:a.help,helpUrl:a.helpUrl||null,impact:null,tags:a.tags,nodes:[]}},U.splitResultsWithChecks=function(a){"use strict";return U.splitResults(a,U.formatChecks)},U.splitResults=function(b,c){"use strict";var d=[],e=[];return b.forEach(function(a){function b(b){var d=b.result||a.result,e=U.formatNode(b.node);return e.impact=b.impact||null,c(e,b,d)}var f,g=U.formatRuleResult(a);f=T.clone(g),f.impact=a.impact||null,f.nodes=a.violations.map(b),g.nodes=a.passes.map(b),f.nodes.length&&d.push(f),g.nodes.length&&e.push(g)}),{violations:d,passes:e,url:a.location.href,timestamp:new Date}},S.reporter("na",function(a,b){"use strict";var c=a.filter(function(a){return 0===a.violations.length&&0===a.passes.length}).map(U.formatRuleResult),d=U.splitResultsWithChecks(a);b({violations:d.violations,passes:d.passes,notApplicable:c,timestamp:d.timestamp,url:d.url})}),S.reporter("no-passes",function(a,b){"use strict";var c=U.splitResultsWithChecks(a);b({violations:c.violations,timestamp:c.timestamp,url:c.url})}),S.reporter("raw",function(a,b){"use strict";b(a)}),S.reporter("v1",function(a,b){"use strict";var c=U.splitResults(a,function(a,b,c){return c===S.constants.result.FAIL&&(a.failureSummary=U.failureSummary(b)),a});b({violations:c.violations,passes:c.passes,timestamp:c.timestamp,url:c.url})}),S.reporter("v2",function(a,b){"use strict";var c=U.splitResultsWithChecks(a);b({violations:c.violations,passes:c.passes,timestamp:c.timestamp,url:c.url})},!0),T.checkHelper=function(a,b){"use strict";return{isAsync:!1,async:function(){return this.isAsync=!0,function(c){a.value=c,b(a)}},data:function(b){a.data=b},relatedNodes:function(b){b=b instanceof Node?[b]:T.toArray(b),a.relatedNodes=b.map(function(a){return new T.DqElement(a)})}}},T.sendCommandToFrame=function(a,b,c){"use strict";var d=a.contentWindow;if(!d)return S.log("Frame does not have a content window",a),c({});var e=setTimeout(function(){e=setTimeout(function(){S.log("No response from frame: ",a),c(null)},0)},500);T.respondable(d,"axe.ping",null,function(){clearTimeout(e),e=setTimeout(function(){S.log("Error returning results from frame: ",a),c({}),c=null},3e4),T.respondable(d,"axe.start",b,function(a){c&&(clearTimeout(e),c(a))})})},T.collectResultsFromFrames=function(a,b,c,d,e){"use strict";function f(e){var f={options:b,command:c,parameter:d,context:{initiator:!1,page:a.page,include:e.include||[],exclude:e.exclude||[]}};g.defer(function(a){var b=e.node;T.sendCommandToFrame(b,f,function(c){return c?a({results:c,frameElement:b,frame:T.getSelector(b)}):void a(null)})})}for(var g=T.queue(),h=a.frames,i=0,j=h.length;j>i;i++)f(h[i]);g.then(function(a){e(T.mergeResults(a))})},T.contains=function(a,b){"use strict";return"function"==typeof a.contains?a.contains(b):!!(16&a.compareDocumentPosition(b))},B.prototype.toJSON=function(){"use strict";return{selector:this.selector,source:this.source}},T.DqElement=B,T.extendBlacklist=function(a,b,c){"use strict";c=c||[];for(var d in b)b.hasOwnProperty(d)&&-1===c.indexOf(d)&&(a[d]=b[d]);return a},T.extendMetaData=function(a,b){"use strict";for(var c in b)if(b.hasOwnProperty(c))if("function"==typeof b[c])try{a[c]=b[c](a)}catch(d){a[c]=null}else a[c]=b[c]},T.getFailingChecks=function(a){"use strict";var b=a.any.filter(function(a){return!a.result});return{all:a.all.filter(function(a){return!a.result}),any:b.length===a.any.length?b:[],none:a.none.filter(function(a){return!!a.result})}},T.finalizeRuleResult=function(a){"use strict";return T.publishMetaData(a),E(a)},T.findBy=function(a,b,c){"use strict";a=a||[];var d,e;for(d=0,e=a.length;e>d;d++)if(a[d][b]===c)return a[d]},T.getAllChecks=function(a){"use strict";var b=[];return b.concat(a.any||[]).concat(a.all||[]).concat(a.none||[])},T.getCheckOption=function(a,b,c){"use strict";var d=((c.rules&&c.rules[b]||{}).checks||{})[a.id],e=(c.checks||{})[a.id],f=a.enabled,g=a.options;return e&&(e.hasOwnProperty("enabled")&&(f=e.enabled),e.hasOwnProperty("options")&&(g=e.options)),d&&(d.hasOwnProperty("enabled")&&(f=d.enabled),d.hasOwnProperty("options")&&(g=d.options)),{enabled:f,options:g}},T.getSelector=function(a){"use strict";function c(a){return T.escapeSelector(a)}for(var d,e=[];a.parentNode;){if(d="",a.id&&1===b.querySelectorAll("#"+T.escapeSelector(a.id)).length){e.unshift("#"+T.escapeSelector(a.id));break}if(a.className&&"string"==typeof a.className&&(d="."+a.className.trim().split(/\s+/).map(c).join("."),("."===d||G(a,d))&&(d="")),!d){if(d=T.escapeSelector(a.nodeName).toLowerCase(),"html"===d||"body"===d){e.unshift(d);break}G(a,d)&&(d+=":nth-of-type("+F(a)+")")}e.unshift(d),a=a.parentNode}return e.join(" > ")};var X;T.isHidden=function(b,c){"use strict";if(9===b.nodeType)return!1;var d=a.getComputedStyle(b,null);return d&&b.parentNode&&"none"!==d.getPropertyValue("display")&&(c||"hidden"!==d.getPropertyValue("visibility"))&&"true"!==b.getAttribute("aria-hidden")?T.isHidden(b.parentNode,!0):!0},T.mergeResults=function(a){"use strict";var b=[];return a.forEach(function(a){var c=K(a);c&&c.length&&c.forEach(function(c){c.nodes&&a.frame&&I(c.nodes,a.frameElement,a.frame);var d=T.findBy(b,"id",c.id);d?c.nodes.length&&J(d.nodes,c.nodes):b.push(c)})}),b},T.nodeSorter=function(a,b){"use strict";return a===b?0:4&a.compareDocumentPosition(b)?-1:1},T.publishMetaData=function(a){"use strict";function b(a){return function(b){var d=c[b.id]||{},e=d.messages||{},f=T.extendBlacklist({},d,["messages"]);f.message=b.result===a?e.pass:e.fail,T.extendMetaData(b,f)}}var c=S._audit.data.checks||{},d=S._audit.data.rules||{},e=T.findBy(S._audit.rules,"id",a.id)||{};a.tags=T.clone(e.tags||[]);var f=b(!0),g=b(!1);a.nodes.forEach(function(a){a.any.forEach(f),a.all.forEach(f),a.none.forEach(g)}),T.extendMetaData(a,T.clone(d[a.id]||{}))},function(){"use strict";function a(){}function b(){function b(){for(var a=e.length;a>f;f++){var b=e[f],d=b.shift();b.push(c(f)),d.apply(null,b)}}function c(a){return function(b){e[a]=b,--g||d()}}function d(){h(e)}var e=[],f=0,g=0,h=a;return{defer:function(a){e.push([a]),++g,b()},then:function(a){h=a,g||d()},abort:function(b){h=a,b(e)}}}T.queue=b}(),function(b){"use strict";function c(a){return"object"==typeof a&&"string"==typeof a.uuid&&a._respondable===!0}function d(a,b,c,d,e){var f={uuid:d,topic:b,message:c,_respondable:!0};h[d]=e,a.postMessage(JSON.stringify(f),"*")}function e(a,b,c,e){var f=O.v1();d(a,b,c,f,e)}function f(a,b){var c=b.topic,d=b.message,e=i[c];e&&e(d,g(a.source,null,b.uuid))}function g(a,b,c){return function(e,f){d(a,b,e,c,f)}}var h={},i={};e.subscribe=function(a,b){i[a]=b},a.addEventListener("message",function(a){if("string"==typeof a.data){var b;try{b=JSON.parse(a.data)}catch(d){}if(c(b)){var e=b.uuid;h[e]&&(h[e](b.message,g(a.source,b.topic,e)),h[e]=null),f(a,b)}}},!1),b.respondable=e}(T),T.ruleShouldRun=function(a,b,c){"use strict";if(a.pageLevel&&!b.page)return!1;var d=c.runOnly,e=(c.rules||{})[a.id];return d?"rule"===d.type?-1!==d.values.indexOf(a.id):!!(d.values||[]).filter(function(b){return-1!==a.tags.indexOf(b)}).length:(e&&e.hasOwnProperty("enabled")?e.enabled:a.enabled)?!0:!1},T.select=function(a,b){"use strict";for(var c,d=[],e=0,f=b.include.length;f>e;e++)c=b.include[e],c.nodeType===c.ELEMENT_NODE&&T.matchesSelector(c,a)&&N(d,[c],b),N(d,c.querySelectorAll(a),b);return d.sort(T.nodeSorter)},T.toArray=function(a){"use strict";return Array.prototype.slice.call(a)},S._load({data:{rules:{accesskeys:{description:"Ensures every accesskey attribute value is unique",help:"accesskey attribute value must be unique",helpUrl:"https://dequeuniversity.com/rules/axe/1.1/accesskeys"},"area-alt":{description:"Ensures <area> elements of image maps have alternate text",help:"Active <area> elements must have alternate text",helpUrl:"https://dequeuniversity.com/rules/axe/1.1/area-alt"},"aria-allowed-attr":{description:"Ensures ARIA attributes are allowed for an element's role",help:"Elements must only use allowed ARIA attributes",helpUrl:"https://dequeuniversity.com/rules/axe/1.1/aria-allowed-attr"},"aria-required-attr":{description:"Ensures elements with ARIA roles have all required ARIA attributes",help:"Required ARIA attributes must be provided",helpUrl:"https://dequeuniversity.com/rules/axe/1.1/aria-required-attr"},"aria-required-children":{description:"Ensures elements with an ARIA role that require child roles contain them",help:"Certain ARIA roles must contain particular children",helpUrl:"https://dequeuniversity.com/rules/axe/1.1/aria-required-children"},"aria-required-parent":{description:"Ensures elements with an ARIA role that require parent roles are contained by them",help:"Certain ARIA roles must be contained by particular parents",helpUrl:"https://dequeuniversity.com/rules/axe/1.1/aria-required-parent"},"aria-roles":{description:"Ensures all elements with a role attribute use a valid value",help:"ARIA roles used must conform to valid values",helpUrl:"https://dequeuniversity.com/rules/axe/1.1/aria-roles"},"aria-valid-attr-value":{description:"Ensures all ARIA attributes have valid values",help:"ARIA attributes must conform to valid values",helpUrl:"https://dequeuniversity.com/rules/axe/1.1/aria-valid-attr-value"},"aria-valid-attr":{description:"Ensures attributes that begin with aria- are valid ARIA attributes",help:"ARIA attributes must conform to valid names",helpUrl:"https://dequeuniversity.com/rules/axe/1.1/aria-valid-attr"},"audio-caption":{description:"Ensures <audio> elements have captions",help:"<audio> elements must have a captions track",helpUrl:"https://dequeuniversity.com/rules/axe/1.1/audio-caption"},blink:{description:"Ensures <blink> elements are not used",help:"<blink> elements are deprecated and must not be used",helpUrl:"https://dequeuniversity.com/rules/axe/1.1/blink"},"button-name":{description:"Ensures buttons have discernible text",help:"Buttons must have discernible text",helpUrl:"https://dequeuniversity.com/rules/axe/1.1/button-name"},bypass:{description:"Ensures each page has at least one mechanism for a user to bypass navigation and jump straight to the content",help:"Page must have means to bypass repeated blocks",helpUrl:"https://dequeuniversity.com/rules/axe/1.1/bypass"},checkboxgroup:{description:'Ensures related <input type="checkbox"> elements have a group and that that group designation is consistent',help:"Checkbox inputs with the same name attribute value must be part of a group",helpUrl:"https://dequeuniversity.com/rules/axe/1.1/checkboxgroup"},"color-contrast":{description:"Ensures the contrast between foreground and background colors meets WCAG 2 AA contrast ratio thresholds",help:"Elements must have sufficient color contrast",helpUrl:"https://dequeuniversity.com/rules/axe/1.1/color-contrast"},"data-table":{description:"Ensures data tables are marked up semantically and have the correct header structure",help:"Data tables should be marked up properly",helpUrl:"https://dequeuniversity.com/rules/axe/1.1/data-table"},"definition-list":{description:"Ensures <dl> elements are structured correctly",help:"<dl> elements must only directly contain properly-ordered <dt> and <dd> groups, <script> or <template> elements",helpUrl:"https://dequeuniversity.com/rules/axe/1.1/definition-list"},dlitem:{description:"Ensures <dt> and <dd> elements are contained by a <dl>",help:"<dt> and <dd> elements must be contained by a <dl>",helpUrl:"https://dequeuniversity.com/rules/axe/1.1/dlitem"},"document-title":{description:"Ensures each HTML document contains a non-empty <title> element",help:"Documents must have <title> element to aid in navigation",helpUrl:"https://dequeuniversity.com/rules/axe/1.1/document-title"},"duplicate-id":{description:"Ensures every id attribute value is unique",help:"id attribute value must be unique",helpUrl:"https://dequeuniversity.com/rules/axe/1.1/duplicate-id"},"empty-heading":{description:"Ensures headings have discernible text",help:"Headings must not be empty",helpUrl:"https://dequeuniversity.com/rules/axe/1.1/empty-heading"},"frame-title":{description:"Ensures <iframe> and <frame> elements contain a unique and non-empty title attribute",help:"Frames must have unique title attribute",helpUrl:"https://dequeuniversity.com/rules/axe/1.1/frame-title"},"heading-order":{description:"Ensures the order of headings is semantically correct",help:"Heading levels should only increase by one",helpUrl:"https://dequeuniversity.com/rules/axe/1.1/heading-order"},"html-lang":{description:"Ensures every HTML document has a lang attribute and its value is valid",help:"<html> element must have a valid lang attribute",helpUrl:"https://dequeuniversity.com/rules/axe/1.1/html-lang"},"image-alt":{description:"Ensures <img> elements have alternate text or a role of none or presentation",help:"Images must have alternate text",helpUrl:"https://dequeuniversity.com/rules/axe/1.1/image-alt"},"input-image-alt":{description:'Ensures <input type="image"> elements have alternate text',help:"Image buttons must have alternate text",helpUrl:"https://dequeuniversity.com/rules/axe/1.1/input-image-alt"},"label-title-only":{description:"Ensures that every form element is not solely labeled using the title or aria-describedby attributes",help:"Form elements should have a visible label",helpUrl:"https://dequeuniversity.com/rules/axe/1.1/label-title-only"},label:{description:"Ensures every form element has a label",help:"Form elements must have labels",helpUrl:"https://dequeuniversity.com/rules/axe/1.1/label"},"layout-table":{description:"Ensures presentational <table> elements do not use <th>, <caption> elements or the summary attribute",help:"Layout tables must not use data table elements",helpUrl:"https://dequeuniversity.com/rules/axe/1.1/layout-table"},"link-name":{description:"Ensures links have discernible text",help:"Links must have discernible text",helpUrl:"https://dequeuniversity.com/rules/axe/1.1/link-name"},list:{description:"Ensures that lists are structured correctly",help:"<ul> and <ol> must only directly contain <li>, <script> or <template> elements",helpUrl:"https://dequeuniversity.com/rules/axe/1.1/list"},listitem:{description:"Ensures <li> elements are used semantically",help:"<li> elements must be contained in a <ul> or <ol>",helpUrl:"https://dequeuniversity.com/rules/axe/1.1/listitem"},marquee:{description:"Ensures <marquee> elements are not used",help:"<marquee> elements are deprecated and must not be used",helpUrl:"https://dequeuniversity.com/rules/axe/1.1/marquee"},"meta-refresh":{description:'Ensures <meta http-equiv="refresh"> is not used',help:"Timed refresh must not exist",helpUrl:"https://dequeuniversity.com/rules/axe/1.1/meta-refresh"},"meta-viewport":{description:'Ensures <meta name="viewport"> does not disable text scaling and zooming',help:"Zooming and scaling must not be disabled",helpUrl:"https://dequeuniversity.com/rules/axe/1.1/meta-viewport"},"object-alt":{description:"Ensures <object> elements have alternate text",help:"<object> elements must have alternate text",helpUrl:"https://dequeuniversity.com/rules/axe/1.1/object-alt"},radiogroup:{description:'Ensures related <input type="radio"> elements have a group and that the group designation is consistent',help:"Radio inputs with the same name attribute value must be part of a group",helpUrl:"https://dequeuniversity.com/rules/axe/1.1/radiogroup"},region:{description:"Ensures all content is contained within a landmark region",help:"Content should be contained in a landmark region",helpUrl:"https://dequeuniversity.com/rules/axe/1.1/region"},scope:{description:"Ensures the scope attribute is used correctly on tables",help:"scope attribute should be used correctly",helpUrl:"https://dequeuniversity.com/rules/axe/1.1/scope"},"server-side-image-map":{description:"Ensures that server-side image maps are not used",help:"Server-side image maps must not be used",helpUrl:"https://dequeuniversity.com/rules/axe/1.1/server-side-image-map"},"skip-link":{description:"Ensures the first link on the page is a skip link",help:"The page should have a skip link as its first link",helpUrl:"https://dequeuniversity.com/rules/axe/1.1/skip-link"},tabindex:{description:"Ensures tabindex attribute values are not greater than 0",help:"Elements should not have tabindex greater than zero",helpUrl:"https://dequeuniversity.com/rules/axe/1.1/tabindex"},"valid-lang":{description:"Ensures lang attributes have valid values",help:"lang attribute must have a valid value",helpUrl:"https://dequeuniversity.com/rules/axe/1.1/valid-lang"},"video-caption":{description:"Ensures <video> elements have captions",help:"<video> elements must have captions",
helpUrl:"https://dequeuniversity.com/rules/axe/1.1/video-caption"},"video-description":{description:"Ensures <video> elements have audio descriptions",help:"<video> elements must have an audio description track",helpUrl:"https://dequeuniversity.com/rules/axe/1.1/video-description"}},checks:{accesskeys:{impact:"critical",messages:{pass:function(a){var b="Accesskey attribute value is unique";return b},fail:function(a){var b="Document has multiple elements with the same accesskey";return b}}},"non-empty-alt":{impact:"critical",messages:{pass:function(a){var b="Element has a non-empty alt attribute";return b},fail:function(a){var b="Element has no alt attribute or the alt attribute is empty";return b}}},"aria-label":{impact:"critical",messages:{pass:function(a){var b="aria-label attribute exists and is not empty";return b},fail:function(a){var b="aria-label attribute does not exist or is empty";return b}}},"aria-labelledby":{impact:"critical",messages:{pass:function(a){var b="aria-labelledby attribute exists and references elements that are visible to screen readers";return b},fail:function(a){var b="aria-labelledby attribute does not exist, references elements that do not exist or references elements that are empty or not visible";return b}}},"aria-allowed-attr":{impact:"critical",messages:{pass:function(a){var b="ARIA attributes are used correctly for the defined role";return b},fail:function(a){var b="ARIA attribute"+(a.data&&a.data.length>1?"s are":" is")+" not allowed:",c=a.data;if(c)for(var d,e=-1,f=c.length-1;f>e;)d=c[e+=1],b+=" "+d;return b}}},"aria-required-attr":{impact:"critical",messages:{pass:function(a){var b="All required ARIA attributes are present";return b},fail:function(a){var b="Required ARIA attribute"+(a.data&&a.data.length>1?"s":"")+" not present:",c=a.data;if(c)for(var d,e=-1,f=c.length-1;f>e;)d=c[e+=1],b+=" "+d;return b}}},"aria-required-children":{impact:"critical",messages:{pass:function(a){var b="Required ARIA children are present";return b},fail:function(a){var b="Required ARIA "+(a.data&&a.data.length>1?"children":"child")+" role not present:",c=a.data;if(c)for(var d,e=-1,f=c.length-1;f>e;)d=c[e+=1],b+=" "+d;return b}}},"aria-required-parent":{impact:"critical",messages:{pass:function(a){var b="Required ARIA parent role present";return b},fail:function(a){var b="Required ARIA parent"+(a.data&&a.data.length>1?"s":"")+" role not present:",c=a.data;if(c)for(var d,e=-1,f=c.length-1;f>e;)d=c[e+=1],b+=" "+d;return b}}},invalidrole:{impact:"critical",messages:{pass:function(a){var b="ARIA role is valid";return b},fail:function(a){var b="Role must be one of the valid ARIA roles";return b}}},abstractrole:{impact:"serious",messages:{pass:function(a){var b="Abstract roles are not used";return b},fail:function(a){var b="Abstract roles cannot be directly used";return b}}},"aria-valid-attr-value":{impact:"critical",messages:{pass:function(a){var b="ARIA attribute values are valid";return b},fail:function(a){var b="Invalid ARIA attribute value"+(a.data&&a.data.length>1?"s":"")+":",c=a.data;if(c)for(var d,e=-1,f=c.length-1;f>e;)d=c[e+=1],b+=" "+d;return b}}},"aria-valid-attr":{impact:"critical",messages:{pass:function(a){var b="ARIA attribute name"+(a.data&&a.data.length>1?"s":"")+" are valid";return b},fail:function(a){var b="Invalid ARIA attribute name"+(a.data&&a.data.length>1?"s":"")+":",c=a.data;if(c)for(var d,e=-1,f=c.length-1;f>e;)d=c[e+=1],b+=" "+d;return b}}},caption:{impact:"critical",messages:{pass:function(a){var b="The multimedia element has a captions track";return b},fail:function(a){var b="The multimedia element does not have a captions track";return b}}},exists:{impact:"minor",messages:{pass:function(a){var b="Element does not exist";return b},fail:function(a){var b="Element exists";return b}}},"non-empty-if-present":{impact:"critical",messages:{pass:function(a){var b="Element ";return b+=a.data?"has a non-empty value attribute":"does not have a value attribute"},fail:function(a){var b="Element has a value attribute and the value attribute is empty";return b}}},"non-empty-value":{impact:"critical",messages:{pass:function(a){var b="Element has a non-empty value attribute";return b},fail:function(a){var b="Element has no value attribute or the value attribute is empty";return b}}},"button-has-visible-text":{impact:"critical",messages:{pass:function(a){var b="Element has inner text that is visible to screen readers";return b},fail:function(a){var b="Element does not have inner text that is visible to screen readers";return b}}},"role-presentation":{impact:"moderate",messages:{pass:function(a){var b='Element\'s default semantics were overriden with role="presentation"';return b},fail:function(a){var b='Element\'s default semantics were not overridden with role="presentation"';return b}}},"role-none":{impact:"moderate",messages:{pass:function(a){var b='Element\'s default semantics were overriden with role="none"';return b},fail:function(a){var b='Element\'s default semantics were not overridden with role="none"';return b}}},"duplicate-img-label":{impact:"minor",messages:{pass:function(a){var b="Element does not duplicate existing text in <img> alt text";return b},fail:function(a){var b="Element contains <img> element with alt text that duplicates existing text";return b}}},"focusable-no-name":{impact:"serious",messages:{pass:function(a){var b="Element is not in tab order or has accessible text";return b},fail:function(a){var b="Element is in tab order and does not have accessible text";return b}}},"internal-link-present":{impact:"critical",messages:{pass:function(a){var b="Valid skip link found";return b},fail:function(a){var b="No valid skip link found";return b}}},"header-present":{impact:"moderate",messages:{pass:function(a){var b="Page has a header";return b},fail:function(a){var b="Page does not have a header";return b}}},landmark:{impact:"serious",messages:{pass:function(a){var b="Page has a landmark region";return b},fail:function(a){var b="Page does not have a landmark region";return b}}},"group-labelledby":{impact:"critical",messages:{pass:function(a){var b='All elements with the name "'+a.data.name+'" reference the same element with aria-labelledby';return b},fail:function(a){var b='All elements with the name "'+a.data.name+'" do not reference the same element with aria-labelledby';return b}}},fieldset:{impact:"critical",messages:{pass:function(a){var b="Element is contained in a fieldset";return b},fail:function(a){var b="",c=a.data&&a.data.failureCode;return b+="no-legend"===c?"Fieldset does not have a legend as its first child":"empty-legend"===c?"Legend does not have text that is visible to screen readers":"mixed-inputs"===c?"Fieldset contains unrelated inputs":"no-group-label"===c?"ARIA group does not have aria-label or aria-labelledby":"group-mixed-inputs"===c?"ARIA group contains unrelated inputs":"Element does not have a containing fieldset or ARIA group"}}},"color-contrast":{impact:"critical",messages:{pass:function(a){var b="";return b+=a.data&&a.data.contrastRatio?"Element has sufficient color contrast of "+a.data.contrastRatio:"Unable to determine contrast ratio"},fail:function(a){var b="Element has insufficient color contrast of "+a.data.contrastRatio+" (foreground color: "+a.data.fgColor+", background color: "+a.data.bgColor+", font size: "+a.data.fontSize+", font weight: "+a.data.fontWeight+")";return b}}},"consistent-columns":{impact:"critical",messages:{pass:function(a){var b="Table has consistent column widths";return b},fail:function(a){var b="Table does not have the same number of columns in every row";return b}}},"cell-no-header":{impact:"critical",messages:{pass:function(a){var b="All data cells have table headers";return b},fail:function(a){var b="Some data cells do not have table headers";return b}}},"headers-visible-text":{impact:"critical",messages:{pass:function(a){var b="Header cell has visible text";return b},fail:function(a){var b="Header cell does not have visible text";return b}}},"headers-attr-reference":{impact:"critical",messages:{pass:function(a){var b="headers attribute references elements that are visible to screen readers";return b},fail:function(a){var b="headers attribute references element that is not visible to screen readers";return b}}},"th-scope":{impact:"serious",messages:{pass:function(a){var b="<th> elements use scope attribute";return b},fail:function(a){var b="<th> elements must use scope attribute";return b}}},"no-caption":{impact:"serious",messages:{pass:function(a){var b="Table has a <caption>";return b},fail:function(a){var b="Table does not have a <caption>";return b}}},"th-headers-attr":{impact:"serious",messages:{pass:function(a){var b="<th> elements do not use headers attribute";return b},fail:function(a){var b="<th> elements should not use headers attribute";return b}}},"th-single-row-column":{impact:"serious",messages:{pass:function(a){var b="<th> elements are used when there is only a single row and single column of headers";return b},fail:function(a){var b="<th> elements should only be used when there is a single row and single column of headers";return b}}},"same-caption-summary":{impact:"moderate",messages:{pass:function(a){var b="Content of summary attribute and <caption> are not duplicated";return b},fail:function(a){var b="Content of summary attribute and <caption> element are indentical";return b}}},rowspan:{impact:"critical",messages:{pass:function(a){var b="Table does not have cells with rowspan attribute greater than 1";return b},fail:function(a){var b="Table has cells whose rowspan attribute is not equal to 1";return b}}},"structured-dlitems":{impact:"serious",messages:{pass:function(a){var b="When not empty, element has both <dt> and <dd> elements";return b},fail:function(a){var b="When not empty, element does not have at least one <dt> element followed by at least one <dd> element";return b}}},"only-dlitems":{impact:"serious",messages:{pass:function(a){var b="Element only has children that are <dt> or <dd> elements";return b},fail:function(a){var b="Element has children that are not <dt> or <dd> elements";return b}}},dlitem:{impact:"serious",messages:{pass:function(a){var b="Description list item has a <dl> parent element";return b},fail:function(a){var b="Description list item does not have a <dl> parent element";return b}}},"doc-has-title":{impact:"moderate",messages:{pass:function(a){var b="Document has a non-empty <title> element";return b},fail:function(a){var b="Document does not have a non-empty <title> element";return b}}},"duplicate-id":{impact:"critical",messages:{pass:function(a){var b="Document has no elements that share the same id attribute";return b},fail:function(a){var b="Document has multiple elements with the same id attribute: "+a.data;return b}}},"has-visible-text":{impact:"critical",messages:{pass:function(a){var b="Element has text that is visible to screen readers";return b},fail:function(a){var b="Element does not have text that is visible to screen readers";return b}}},"non-empty-title":{impact:"critical",messages:{pass:function(a){var b="Element has a title attribute";return b},fail:function(a){var b="Element has no title attribute or the title attribute is empty";return b}}},"unique-frame-title":{impact:"serious",messages:{pass:function(a){var b="Element's title attribute is unique";return b},fail:function(a){var b="Element's title attribute is not unique";return b}}},"heading-order":{impact:"minor",messages:{pass:function(a){var b="Heading order valid";return b},fail:function(a){var b="Heading order invalid";return b}}},"has-lang":{impact:"serious",messages:{pass:function(a){var b="The <html> element has a lang attribute";return b},fail:function(a){var b="The <html> element does not have a lang attribute";return b}}},"valid-lang":{impact:"serious",messages:{pass:function(a){var b="Value of lang attribute is included in the list of valid languages";return b},fail:function(a){var b="Value of lang attribute not included in the list of valid languages";return b}}},"has-alt":{impact:"critical",messages:{pass:function(a){var b="Element has an alt attribute";return b},fail:function(a){var b="Element does not have an alt attribute";return b}}},"title-only":{impact:"serious",messages:{pass:function(a){var b="Form element does not solely use title attribute for its label";return b},fail:function(a){var b="Only title used to generate label for form element";return b}}},"implicit-label":{impact:"critical",messages:{pass:function(a){var b="Form element has an implicit (wrapped) <label>";return b},fail:function(a){var b="Form element does not have an implicit (wrapped) <label>";return b}}},"explicit-label":{impact:"critical",messages:{pass:function(a){var b="Form element has an explicit <label>";return b},fail:function(a){var b="Form element does not have an explicit <label>";return b}}},"help-same-as-label":{impact:"minor",messages:{pass:function(a){var b="Help text (title or aria-describedby) does not duplicate label text";return b},fail:function(a){var b="Help text (title or aria-describedby) text is the same as the label text";return b}}},"multiple-label":{impact:"serious",messages:{pass:function(a){var b="Form element does not have multiple <label> elements";return b},fail:function(a){var b="Form element has multiple <label> elements";return b}}},"has-th":{impact:"serious",messages:{pass:function(a){var b="Layout table does not use <th> elements";return b},fail:function(a){var b="Layout table uses <th> elements";return b}}},"has-caption":{impact:"serious",messages:{pass:function(a){var b="Layout table does not use <caption> element";return b},fail:function(a){var b="Layout table uses <caption> element";return b}}},"has-summary":{impact:"serious",messages:{pass:function(a){var b="Layout table does not use summary attribute";return b},fail:function(a){var b="Layout table uses summary attribute";return b}}},"only-listitems":{impact:"serious",messages:{pass:function(a){var b="List element only has children that are <li>, <script> or <template> elements";return b},fail:function(a){var b="List element has children that are not <li>, <script> or <template> elements";return b}}},listitem:{impact:"critical",messages:{pass:function(a){var b="List item has a <ul> or <ol> parent element";return b},fail:function(a){var b="List item does not have a <ul> or <ol> parent element";return b}}},"meta-refresh":{impact:"critical",messages:{pass:function(a){var b="<meta> tag does not immediately refresh the page";return b},fail:function(a){var b="<meta> tag forces timed refresh of page";return b}}},"meta-viewport":{impact:"critical",messages:{pass:function(a){var b="<meta> tag does not disable zooming";return b},fail:function(a){var b="<meta> tag disables zooming";return b}}},region:{impact:"moderate",messages:{pass:function(a){var b="Content contained by ARIA landmark";return b},fail:function(a){var b="Content not contained by an ARIA landmark";return b}}},"html5-scope":{impact:"serious",messages:{pass:function(a){var b="Scope attribute is only used on table header elements (<th>)";return b},fail:function(a){var b="In HTML 5, scope attributes may only be used on table header elements (<th>)";return b}}},"html4-scope":{impact:"serious",messages:{pass:function(a){var b="Scope attribute is only used on table cell elements (<th> and <td>)";return b},fail:function(a){var b="In HTML 4, the scope attribute may only be used on table cell elements (<th> and <td>)";return b}}},"scope-value":{impact:"critical",messages:{pass:function(a){var b="Scope attribute is used correctly";return b},fail:function(a){var b="The value of the scope attribute may only be 'row' or 'col'";return b}}},"skip-link":{impact:"critical",messages:{pass:function(a){var b="Valid skip link found";return b},fail:function(a){var b="No valid skip link found";return b}}},tabindex:{impact:"serious",messages:{pass:function(a){var b="Element does not have a tabindex greater than 0";return b},fail:function(a){var b="Element has a tabindex greater than 0";return b}}},description:{impact:"serious",messages:{pass:function(a){var b="The multimedia element has an audio description track";return b},fail:function(a){var b="The multimedia element does not have an audio description track";return b}}}},failureSummaries:{any:{failureMessage:function(a){var b="Fix any of the following:",c=a;if(c)for(var d,e=-1,f=c.length-1;f>e;)d=c[e+=1],b+="\n  "+d.split("\n").join("\n  ");return b}},none:{failureMessage:function(a){var b="Fix all of the following:",c=a;if(c)for(var d,e=-1,f=c.length-1;f>e;)d=c[e+=1],b+="\n  "+d.split("\n").join("\n  ");return b}}}},rules:[{id:"accesskeys",selector:"[accesskey]",tags:["wcag2a","wcag211"],all:[],any:[],none:["accesskeys"]},{id:"area-alt",selector:"map area[href]",excludeHidden:!1,tags:["wcag2a","wcag111","section508","section508a"],all:[],any:["non-empty-alt","aria-label","aria-labelledby"],none:[]},{id:"aria-allowed-attr",tags:["wcag2a","wcag411"],all:[],any:["aria-allowed-attr"],none:[]},{id:"aria-required-attr",selector:"[role]",tags:["wcag2a","wcag411"],all:[],any:["aria-required-attr"],none:[]},{id:"aria-required-children",selector:"[role]",tags:["wcag2a","wcag411"],all:[],any:["aria-required-children"],none:[]},{id:"aria-required-parent",selector:"[role]",tags:["wcag2a","wcag411"],all:[],any:["aria-required-parent"],none:[]},{id:"aria-roles",selector:"[role]",tags:["wcag2a","wcag411"],all:[],any:[],none:["invalidrole","abstractrole"]},{id:"aria-valid-attr-value",tags:["wcag2a","wcag411"],all:[],any:[{options:[],id:"aria-valid-attr-value"}],none:[]},{id:"aria-valid-attr",tags:["wcag2a","wcag411"],all:[],any:[{options:[],id:"aria-valid-attr"}],none:[]},{id:"audio-caption",selector:"audio",excludeHidden:!1,tags:["wcag2a","wcag122","section508","section508a"],all:[],any:[],none:["caption"]},{id:"blink",selector:"blink",tags:["wcag2a","wcag222"],all:[],any:[],none:["exists"]},{id:"button-name",selector:'button, [role="button"], input[type="button"], input[type="submit"], input[type="reset"]',tags:["wcag2a","wcag412","section508","section508a"],all:[],any:["non-empty-if-present","non-empty-value","button-has-visible-text","aria-label","aria-labelledby","role-presentation","role-none"],none:["duplicate-img-label","focusable-no-name"]},{id:"bypass",selector:"html",pageLevel:!0,matches:function(a){return!!a.querySelector("a[href]")},tags:["wcag2a","wcag241","section508","section508o"],all:[],any:["internal-link-present","header-present","landmark"],none:[]},{id:"checkboxgroup",selector:"input[type=checkbox][name]",tags:["wcag2a","wcag131"],all:[],any:["group-labelledby","fieldset"],none:[]},{id:"color-contrast",selector:"*",tags:["wcag2aa","wcag143"],all:[],any:["color-contrast"],none:[]},{id:"data-table",selector:"table",matches:function(a){return R.table.isDataTable(a)},tags:["wcag2a","wcag131"],all:[],any:["consistent-columns"],none:["cell-no-header","headers-visible-text","headers-attr-reference","th-scope","no-caption","th-headers-attr","th-single-row-column","same-caption-summary","rowspan"]},{id:"definition-list",selector:"dl",tags:["wcag2a","wcag131"],all:[],any:[],none:["structured-dlitems","only-dlitems"]},{id:"dlitem",selector:"dd, dt",tags:["wcag2a","wcag131"],all:[],any:["dlitem"],none:[]},{id:"document-title",selector:"html",tags:["wcag2a","wcag242"],all:[],any:["doc-has-title"],none:[]},{id:"duplicate-id",selector:"[id]",tags:["wcag2a","wcag411"],all:[],any:["duplicate-id"],none:[]},{id:"empty-heading",selector:'h1, h2, h3, h4, h5, h6, [role="heading"]',tags:["wcag2a","wcag131"],all:[],any:["has-visible-text","role-presentation","role-none"],none:[]},{id:"frame-title",selector:"frame, iframe",tags:["wcag2a","wcag241"],all:[],any:["non-empty-title"],none:["unique-frame-title"]},{id:"heading-order",selector:"h1,h2,h3,h4,h5,h6,[role=heading]",enabled:!1,tags:["best-practice"],all:[],any:["heading-order"],none:[]},{id:"html-lang",selector:"html",tags:["wcag2a","wcag311"],all:[],any:["has-lang"],none:[{options:["aa","ab","ae","af","ak","am","an","ar","as","av","ay","az","ba","be","bg","bh","bi","bm","bn","bo","br","bs","ca","ce","ch","co","cr","cs","cu","cv","cy","da","de","dv","dz","ee","el","en","eo","es","et","eu","fa","ff","fi","fj","fo","fr","fy","ga","gd","gl","gn","gu","gv","ha","he","hi","ho","hr","ht","hu","hy","hz","ia","id","ie","ig","ii","ik","in","io","is","it","iu","iw","ja","ji","jv","jw","ka","kg","ki","kj","kk","kl","km","kn","ko","kr","ks","ku","kv","kw","ky","la","lb","lg","li","ln","lo","lt","lu","lv","mg","mh","mi","mk","ml","mn","mo","mr","ms","mt","my","na","nb","nd","ne","ng","nl","nn","no","nr","nv","ny","oc","oj","om","or","os","pa","pi","pl","ps","pt","qu","rm","rn","ro","ru","rw","sa","sc","sd","se","sg","sh","si","sk","sl","sm","sn","so","sq","sr","ss","st","su","sv","sw","ta","te","tg","th","ti","tk","tl","tn","to","tr","ts","tt","tw","ty","ug","uk","ur","uz","ve","vi","vo","wa","wo","xh","yi","yo","za","zh","zu"],id:"valid-lang"}]},{id:"image-alt",selector:"img",tags:["wcag2a","wcag111","section508","section508a"],all:[],any:["has-alt","aria-label","aria-labelledby","non-empty-title","role-presentation","role-none"],none:[]},{id:"input-image-alt",selector:'input[type="image"]',tags:["wcag2a","wcag111","section508","section508a"],all:[],any:["non-empty-alt","aria-label","aria-labelledby"],none:[]},{id:"label-title-only",selector:"input:not([type='hidden']):not([type='image']):not([type='button']):not([type='submit']):not([type='reset']), select, textarea",enabled:!1,tags:["best-practice"],all:[],any:[],none:["title-only"]},{id:"label",selector:"input:not([type='hidden']):not([type='image']):not([type='button']):not([type='submit']):not([type='reset']), select, textarea",tags:["wcag2a","wcag332","wcag131","section508","section508n"],all:[],any:["aria-label","aria-labelledby","implicit-label","explicit-label","non-empty-title"],none:["help-same-as-label","multiple-label"]},{id:"layout-table",selector:"table",matches:function(a){return!R.table.isDataTable(a)},tags:["wcag2a","wcag131"],all:[],any:[],none:["has-th","has-caption","has-summary"]},{id:"link-name",selector:'a[href]:not([role="button"]), [role=link][href]',tags:["wcag2a","wcag111","wcag412","section508","section508a"],all:[],any:["has-visible-text","aria-label","aria-labelledby","role-presentation","role-none"],none:["duplicate-img-label","focusable-no-name"]},{id:"list",selector:"ul, ol",tags:["wcag2a","wcag131"],all:[],any:[],none:["only-listitems"]},{id:"listitem",selector:"li",tags:["wcag2a","wcag131"],all:[],any:["listitem"],none:[]},{id:"marquee",selector:"marquee",tags:["wcag2a","wcag222","section508","section508j"],all:[],any:[],none:["exists"]},{id:"meta-refresh",selector:'meta[http-equiv="refresh"]',excludeHidden:!1,tags:["wcag2a","wcag2aaa","wcag221","wcag224","wcag325"],all:[],any:["meta-refresh"],none:[]},{id:"meta-viewport",selector:'meta[name="viewport"]',excludeHidden:!1,tags:["wcag2aa","wcag144"],all:[],any:["meta-viewport"],none:[]},{id:"object-alt",selector:"object",tags:["wcag2a","wcag111"],all:[],any:["has-visible-text"],none:[]},{id:"radiogroup",selector:"input[type=radio][name]",tags:["wcag2a","wcag131"],all:[],any:["group-labelledby","fieldset"],none:[]},{id:"region",selector:"html",pageLevel:!0,enabled:!1,tags:["best-practice"],all:[],any:["region"],none:[]},{id:"scope",selector:"[scope]",enabled:!1,tags:["best-practice"],all:[],any:["html5-scope","html4-scope"],none:["scope-value"]},{id:"server-side-image-map",selector:"img[ismap]",tags:["wcag2a","wcag211","section508","section508f"],all:[],any:[],none:["exists"]},{id:"skip-link",selector:"a[href]",pageLevel:!0,enabled:!1,tags:["best-practice"],all:[],any:["skip-link"],none:[]},{id:"tabindex",selector:"[tabindex]",tags:["best-practice"],all:[],any:["tabindex"],none:[]},{id:"valid-lang",selector:"[lang]:not(html), [xml\\:lang]:not(html)",tags:["wcag2aa","wcag312"],all:[],any:[],none:[{options:["aa","ab","ae","af","ak","am","an","ar","as","av","ay","az","ba","be","bg","bh","bi","bm","bn","bo","br","bs","ca","ce","ch","co","cr","cs","cu","cv","cy","da","de","dv","dz","ee","el","en","eo","es","et","eu","fa","ff","fi","fj","fo","fr","fy","ga","gd","gl","gn","gu","gv","ha","he","hi","ho","hr","ht","hu","hy","hz","ia","id","ie","ig","ii","ik","in","io","is","it","iu","iw","ja","ji","jv","jw","ka","kg","ki","kj","kk","kl","km","kn","ko","kr","ks","ku","kv","kw","ky","la","lb","lg","li","ln","lo","lt","lu","lv","mg","mh","mi","mk","ml","mn","mo","mr","ms","mt","my","na","nb","nd","ne","ng","nl","nn","no","nr","nv","ny","oc","oj","om","or","os","pa","pi","pl","ps","pt","qu","rm","rn","ro","ru","rw","sa","sc","sd","se","sg","sh","si","sk","sl","sm","sn","so","sq","sr","ss","st","su","sv","sw","ta","te","tg","th","ti","tk","tl","tn","to","tr","ts","tt","tw","ty","ug","uk","ur","uz","ve","vi","vo","wa","wo","xh","yi","yo","za","zh","zu"],id:"valid-lang"}]},{id:"video-caption",selector:"video",tags:["wcag2a","wcag122","wcag123","section508","section508a"],all:[],any:[],none:["caption"]},{id:"video-description",selector:"video",tags:["wcag2aa","wcag125","section508","section508a"],all:[],any:[],none:["description"]}],checks:[{id:"abstractrole",evaluate:function(a,b){return"abstract"===R.aria.getRoleType(a.getAttribute("role"))}},{id:"aria-allowed-attr",matches:function(a){var b=a.getAttribute("role");b||(b=R.aria.implicitRole(a));var c=R.aria.allowedAttr(b);if(b&&c){var d=/^aria-/;if(a.hasAttributes())for(var e=a.attributes,f=0,g=e.length;g>f;f++)if(d.test(e[f].nodeName))return!0}return!1},evaluate:function(a,b){var c,d,e,f=[],g=a.getAttribute("role"),h=a.attributes;if(g||(g=R.aria.implicitRole(a)),e=R.aria.allowedAttr(g),g&&e)for(var i=0,j=h.length;j>i;i++)c=h[i],d=c.nodeName,R.aria.validateAttr(d)&&-1===e.indexOf(d)&&f.push(d+'="'+c.nodeValue+'"');return f.length?(this.data(f),!1):!0}},{id:"invalidrole",evaluate:function(a,b){return!R.aria.isValidRole(a.getAttribute("role"))}},{id:"aria-required-attr",evaluate:function(a,b){var c=[];if(a.hasAttributes()){var d,e=a.getAttribute("role"),f=R.aria.requiredAttr(e);if(e&&f)for(var g=0,h=f.length;h>g;g++)d=f[g],a.getAttribute(d)||c.push(d)}return c.length?(this.data(c),!1):!0}},{id:"aria-required-children",evaluate:function(a,b){function c(a,b,c){if(null===a)return!1;var d=g(b),e=['[role="'+b+'"]'];return d&&(e=e.concat(d)),e=e.join(","),c?h(a,e)||!!a.querySelector(e):!!a.querySelector(e)}function d(a,b){var d,e;for(d=0,e=a.length;e>d;d++)if(null!==a[d]&&c(a[d],b,!0))return!0;return!1}function e(a,b,e){var f,g=b.length,h=[],j=i(a,"aria-owns");for(f=0;g>f;f++){var k=b[f];if(c(a,k)||d(j,k)){if(!e)return null}else e&&h.push(k)}return h.length?h:!e&&b.length?b:null}var f=R.aria.requiredOwned,g=R.aria.implicitNodes,h=R.utils.matchesSelector,i=R.dom.idrefs,j=a.getAttribute("role"),k=f(j);if(!k)return!0;var l=!1,m=k.one;if(!m){var l=!0;m=k.all}var n=e(a,m,l);return n?(this.data(n),!1):!0}},{id:"aria-required-parent",evaluate:function(a,c){function d(a){var b=R.aria.implicitNodes(a)||[];return b.concat('[role="'+a+'"]').join(",")}function e(a,b,c){var e,f,g=a.getAttribute("role"),h=[];if(b||(b=R.aria.requiredContext(g)),!b)return null;for(e=0,f=b.length;f>e;e++){if(c&&R.utils.matchesSelector(a,d(b[e])))return null;if(R.dom.findUp(a,d(b[e])))return null;h.push(b[e])}return h}function f(a){for(var c=[],d=null;a;)a.id&&(d=b.querySelector("[aria-owns~="+R.utils.escapeSelector(a.id)+"]"),d&&c.push(d)),a=a.parentNode;return c.length?c:null}var g=e(a);if(!g)return!0;var h=f(a);if(h)for(var i=0,j=h.length;j>i;i++)if(g=e(h[i],g,!0),!g)return!0;return this.data(g),!1}},{id:"aria-valid-attr-value",matches:function(a){var b=/^aria-/;if(a.hasAttributes())for(var c=a.attributes,d=0,e=c.length;e>d;d++)if(b.test(c[d].nodeName))return!0;return!1},evaluate:function(a,b){b=Array.isArray(b)?b:[];for(var c,d,e=[],f=/^aria-/,g=a.attributes,h=0,i=g.length;i>h;h++)c=g[h],d=c.nodeName,-1===b.indexOf(d)&&f.test(d)&&!R.aria.validateAttrValue(a,d)&&e.push(d+'="'+c.nodeValue+'"');return e.length?(this.data(e),!1):!0},options:[]},{id:"aria-valid-attr",matches:function(a){var b=/^aria-/;if(a.hasAttributes())for(var c=a.attributes,d=0,e=c.length;e>d;d++)if(b.test(c[d].nodeName))return!0;return!1},evaluate:function(a,b){b=Array.isArray(b)?b:[];for(var c,d=[],e=/^aria-/,f=a.attributes,g=0,h=f.length;h>g;g++)c=f[g].nodeName,-1===b.indexOf(c)&&e.test(c)&&!R.aria.validateAttr(c)&&d.push(c);return d.length?(this.data(d),!1):!0},options:[]},{id:"color-contrast",matches:function(a){var c=a.nodeName,d=a.type,e=b;if("INPUT"===c)return-1===["hidden","range","color","checkbox","radio","image"].indexOf(d)&&!a.disabled;if("SELECT"===c)return!!a.options.length&&!a.disabled;if("TEXTAREA"===c)return!a.disabled;if("OPTION"===c)return!1;if("BUTTON"===c&&a.disabled)return!1;if("LABEL"===c){var f=a.htmlFor&&e.getElementById(a.htmlFor);if(f&&f.disabled)return!1;var f=a.querySelector('input:not([type="hidden"]):not([type="image"]):not([type="button"]):not([type="submit"]):not([type="reset"]), select, textarea');if(f&&f.disabled)return!1}if(a.id){var f=e.querySelector("[aria-labelledby~="+R.utils.escapeSelector(a.id)+"]");if(f&&f.disabled)return!1}if(""===R.text.visible(a,!1,!0))return!1;var g,h,i=b.createRange(),j=a.childNodes,k=j.length;for(h=0;k>h;h++)g=j[h],3===g.nodeType&&""!==R.text.sanitize(g.nodeValue)&&i.selectNodeContents(g);var l=i.getClientRects();for(k=l.length,h=0;k>h;h++)if(R.dom.visuallyOverlaps(l[h],a))return!0;return!1},evaluate:function(b,c){var d=[],e=R.color.getBackgroundColor(b,d),f=R.color.getForegroundColor(b);if(null===f||null===e)return!0;var g=a.getComputedStyle(b),h=parseFloat(g.getPropertyValue("font-size")),i=g.getPropertyValue("font-weight"),j=-1!==["bold","bolder","600","700","800","900"].indexOf(i),k=R.color.hasValidContrastRatio(e,f,h,j);return this.data({fgColor:f.toHexString(),bgColor:e.toHexString(),contrastRatio:k.contrastRatio.toFixed(2),fontSize:(72*h/96).toFixed(1)+"pt",fontWeight:j?"bold":"normal"}),k.isValid||this.relatedNodes(d),k.isValid}},{id:"fieldset",evaluate:function(a,c){function d(a,b){return R.utils.toArray(a.querySelectorAll('select,textarea,button,input:not([name="'+b+'"]):not([type="hidden"])'))}function e(a,b){var c=a.firstElementChild;if(!c||"LEGEND"!==c.nodeName)return j.relatedNodes([a]),i="no-legend",!1;if(!R.text.accessibleText(c))return j.relatedNodes([c]),i="empty-legend",!1;var e=d(a,b);return e.length?(j.relatedNodes(e),i="mixed-inputs",!1):!0}function f(a,b){var c=R.dom.idrefs(a,"aria-labelledby").some(function(a){return a&&R.text.accessibleText(a)}),e=a.getAttribute("aria-label");if(!(c||e&&R.text.sanitize(e)))return j.relatedNodes(a),i="no-group-label",!1;var f=d(a,b);return f.length?(j.relatedNodes(f),i="group-mixed-inputs",!1):!0}function g(a,b){return R.utils.toArray(a).filter(function(a){return a!==b})}function h(c){var d=R.utils.escapeSelector(a.name),h=b.querySelectorAll('input[type="'+R.utils.escapeSelector(a.type)+'"][name="'+d+'"]');if(h.length<2)return!0;var k=R.dom.findUp(c,"fieldset"),l=R.dom.findUp(c,'[role="group"]'+("radio"===a.type?',[role="radiogroup"]':""));return l||k?k?e(k,d):f(l,d):(i="no-group",j.relatedNodes(g(h,c)),!1)}var i,j=this,k={name:a.getAttribute("name"),type:a.getAttribute("type")},l=h(a);return l||(k.failureCode=i),this.data(k),l},after:function(a,b){var c={};return a.filter(function(a){if(a.result)return!0;var b=a.data;if(b){if(c[b.type]=c[b.type]||{},!c[b.type][b.name])return c[b.type][b.name]=[b],!0;var d=c[b.type][b.name].some(function(a){return a.failureCode===b.failureCode});return d||c[b.type][b.name].push(b),!d}return!1})}},{id:"group-labelledby",evaluate:function(a,c){this.data({name:a.getAttribute("name"),type:a.getAttribute("type")});var d=b.querySelectorAll('input[type="'+R.utils.escapeSelector(a.type)+'"][name="'+R.utils.escapeSelector(a.name)+'"]');return d.length<=1?!0:0!==[].map.call(d,function(a){var b=a.getAttribute("aria-labelledby");return b?b.split(/\s+/):[]}).reduce(function(a,b){return a.filter(function(a){return-1!==b.indexOf(a)})}).filter(function(a){
var c=b.getElementById(a);return c&&R.text.accessibleText(c)}).length},after:function(a,b){var c={};return a.filter(function(a){var b=a.data;return b&&(c[b.type]=c[b.type]||{},!c[b.type][b.name])?(c[b.type][b.name]=!0,!0):!1})}},{id:"accesskeys",evaluate:function(a,b){return this.data(a.getAttribute("accesskey")),this.relatedNodes([a]),!0},after:function(a,b){var c={};return a.filter(function(a){return c[a.data]?(c[a.data].relatedNodes.push(a.relatedNodes[0]),!1):(c[a.data]=a,a.relatedNodes=[],!0)}).map(function(a){return a.result=!!a.relatedNodes.length,a})}},{id:"focusable-no-name",evaluate:function(a,b){var c=a.getAttribute("tabindex"),d=R.dom.isFocusable(a)&&c>-1;return d?!R.text.accessibleText(a):!1}},{id:"tabindex",evaluate:function(a,b){return a.tabIndex<=0}},{id:"duplicate-img-label",evaluate:function(a,b){for(var c=a.querySelectorAll("img"),d=R.text.visible(a,!0),e=0,f=c.length;f>e;e++){var g=R.text.accessibleText(c[e]);if(g===d&&""!==d)return!0}return!1},enabled:!1},{id:"explicit-label",evaluate:function(a,c){var d=b.querySelector('label[for="'+R.utils.escapeSelector(a.id)+'"]');return d?!!R.text.accessibleText(d):!1},selector:"[id]"},{id:"help-same-as-label",evaluate:function(a,b){var c=R.text.label(a),d=a.getAttribute("title");if(!c)return!1;if(!d&&(d="",a.getAttribute("aria-describedby"))){var e=R.dom.idrefs(a,"aria-describedby");d=e.map(function(a){return a?R.text.accessibleText(a):""}).join("")}return R.text.sanitize(d)===R.text.sanitize(c)},enabled:!1},{id:"implicit-label",evaluate:function(a,b){var c=R.dom.findUp(a,"label");return c?!!R.text.accessibleText(c):!1}},{id:"multiple-label",evaluate:function(a,c){for(var d=[].slice.call(b.querySelectorAll('label[for="'+R.utils.escapeSelector(a.id)+'"]')),e=a.parentNode;e;)"LABEL"===e.tagName&&-1===d.indexOf(e)&&d.push(e),e=e.parentNode;return this.relatedNodes(d),d.length>1}},{id:"title-only",evaluate:function(a,b){var c=R.text.label(a);return!(c||!a.getAttribute("title")&&!a.getAttribute("aria-describedby"))}},{id:"has-lang",evaluate:function(a,b){return a.hasAttribute("lang")||a.hasAttribute("xml:lang")}},{id:"valid-lang",options:["aa","ab","ae","af","ak","am","an","ar","as","av","ay","az","ba","be","bg","bh","bi","bm","bn","bo","br","bs","ca","ce","ch","co","cr","cs","cu","cv","cy","da","de","dv","dz","ee","el","en","eo","es","et","eu","fa","ff","fi","fj","fo","fr","fy","ga","gd","gl","gn","gu","gv","ha","he","hi","ho","hr","ht","hu","hy","hz","ia","id","ie","ig","ii","ik","in","io","is","it","iu","iw","ja","ji","jv","jw","ka","kg","ki","kj","kk","kl","km","kn","ko","kr","ks","ku","kv","kw","ky","la","lb","lg","li","ln","lo","lt","lu","lv","mg","mh","mi","mk","ml","mn","mo","mr","ms","mt","my","na","nb","nd","ne","ng","nl","nn","no","nr","nv","ny","oc","oj","om","or","os","pa","pi","pl","ps","pt","qu","rm","rn","ro","ru","rw","sa","sc","sd","se","sg","sh","si","sk","sl","sm","sn","so","sq","sr","ss","st","su","sv","sw","ta","te","tg","th","ti","tk","tl","tn","to","tr","ts","tt","tw","ty","ug","uk","ur","uz","ve","vi","vo","wa","wo","xh","yi","yo","za","zh","zu"],evaluate:function(a,b){var c=(a.getAttribute("lang")||"").trim().toLowerCase(),d=(a.getAttribute("xml:lang")||"").trim().toLowerCase(),e=[];return(b||[]).forEach(function(a){a=a.toLowerCase(),!c||c!==a&&0!==c.indexOf(a.toLowerCase()+"-")||(c=null),!d||d!==a&&0!==d.indexOf(a.toLowerCase()+"-")||(d=null)}),d&&e.push('xml:lang="'+d+'"'),c&&e.push('lang="'+c+'"'),e.length?(this.data(e),!0):!1}},{id:"dlitem",evaluate:function(a,b){return"DL"===a.parentNode.tagName}},{id:"has-listitem",evaluate:function(a,b){var c=a.children;if(0===c.length)return!0;for(var d=0;d<c.length;d++)if("LI"===c[d].nodeName)return!1;return!0}},{id:"listitem",evaluate:function(a,b){return-1!==["UL","OL"].indexOf(a.parentNode.tagName)}},{id:"only-dlitems",evaluate:function(a,b){for(var c,d=[],e=a.childNodes,f=!1,g=0;g<e.length;g++)c=e[g],1===c.nodeType&&"DT"!==c.nodeName&&"DD"!==c.nodeName&&"SCRIPT"!==c.nodeName&&"TEMPLATE"!==c.nodeName?d.push(c):3===c.nodeType&&""!==c.nodeValue.trim()&&(f=!0);d.length&&this.relatedNodes(d);var h=!!d.length||f;return h}},{id:"only-listitems",evaluate:function(a,b){for(var c,d=[],e=a.childNodes,f=!1,g=0;g<e.length;g++)c=e[g],1===c.nodeType&&"LI"!==c.nodeName&&"SCRIPT"!==c.nodeName&&"TEMPLATE"!==c.nodeName?d.push(c):3===c.nodeType&&""!==c.nodeValue.trim()&&(f=!0);return d.length&&this.relatedNodes(d),!!d.length||f}},{id:"structured-dlitems",evaluate:function(a,b){var c=a.children;if(!c||!c.length)return!1;for(var d=!1,e=!1,f=0;f<c.length;f++){if("DT"===c[f].nodeName&&(d=!0),d&&"DD"===c[f].nodeName)return!1;"DD"===c[f].nodeName&&(e=!0)}return d||e}},{id:"caption",evaluate:function(a,b){return!a.querySelector("track[kind=captions]")}},{id:"description",evaluate:function(a,b){return!a.querySelector("track[kind=descriptions]")}},{id:"meta-viewport",evaluate:function(a,b){for(var c,d=a.getAttribute("content")||"",e=d.split(/[;,]/),f={},g=0,h=e.length;h>g;g++){c=e[g].split("=");var i=c.shift();i&&c.length&&(f[i.trim()]=c.join("=").trim())}return f["maximum-scale"]&&parseFloat(f["maximum-scale"])<5?!1:"no"===f["user-scalable"]?!1:!0}},{id:"header-present",selector:"html",evaluate:function(a,b){return!!a.querySelector('h1, h2, h3, h4, h5, h6, [role="heading"]')}},{id:"heading-order",evaluate:function(a,b){var c=a.getAttribute("aria-level");if(null!==c)return this.data(parseInt(c,10)),!0;var d=a.tagName.match(/H(\d)/);return d?(this.data(parseInt(d[1],10)),!0):!0},after:function(a,b){if(a.length<2)return a;for(var c=a[0].data,d=1;d<a.length;d++)a[d].result&&a[d].data>c+1&&(a[d].result=!1),c=a[d].data;return a}},{id:"internal-link-present",selector:"html",evaluate:function(a,b){return!!a.querySelector('a[href^="#"]')}},{id:"landmark",selector:"html",evaluate:function(a,b){return!!a.querySelector('[role="main"]')}},{id:"meta-refresh",evaluate:function(a,b){var c=a.getAttribute("content")||"",d=c.split(/[;,]/);return""===c||"0"===d[0]}},{id:"region",evaluate:function(a,b){function c(a){return h&&R.dom.isFocusable(R.dom.getElementByReference(h,"href"))&&h===a}function d(a){var b=a.getAttribute("role");return b&&-1!==g.indexOf(b)}function e(a){return d(a)?null:c(a)?f(a):R.dom.isVisible(a,!0)&&(R.text.visible(a,!0,!0)||R.dom.isVisualContent(a))?a:f(a)}function f(a){var b=R.utils.toArray(a.children);return 0===b.length?[]:b.map(e).filter(function(a){return null!==a}).reduce(function(a,b){return a.concat(b)},[])}var g=R.aria.getRolesByType("landmark"),h=a.querySelector("a[href]"),i=f(a);return this.relatedNodes(i),!i.length},after:function(a,b){return[a[0]]}},{id:"skip-link",selector:"a[href]",evaluate:function(a,b){return R.dom.isFocusable(R.dom.getElementByReference(a,"href"))},after:function(a,b){return[a[0]]}},{id:"unique-frame-title",evaluate:function(a,b){return this.data(a.title),!0},after:function(a,b){var c={};return a.forEach(function(a){c[a.data]=void 0!==c[a.data]?++c[a.data]:0}),a.filter(function(a){return!!c[a.data]})}},{id:"aria-label",evaluate:function(a,b){var c=a.getAttribute("aria-label");return!!(c?R.text.sanitize(c).trim():"")}},{id:"aria-labelledby",evaluate:function(a,b){var c,d,e=R.dom.idrefs(a,"aria-labelledby"),f=e.length;for(d=0;f>d;d++)if(c=e[d],c&&R.text.accessibleText(c).trim())return!0;return!1}},{id:"button-has-visible-text",evaluate:function(a,b){return R.text.accessibleText(a).length>0},selector:'button, [role="button"]:not(input)'},{id:"doc-has-title",evaluate:function(a,c){var d=b.title;return!!(d?R.text.sanitize(d).trim():"")}},{id:"duplicate-id",evaluate:function(a,c){for(var d=b.querySelectorAll('[id="'+R.utils.escapeSelector(a.id)+'"]'),e=[],f=0;f<d.length;f++)d[f]!==a&&e.push(d[f]);return e.length&&this.relatedNodes(e),this.data(a.getAttribute("id")),d.length<=1},after:function(a,b){var c=[];return a.filter(function(a){return-1===c.indexOf(a.data)?(c.push(a.data),!0):!1})}},{id:"exists",evaluate:function(a,b){return!0}},{id:"has-alt",evaluate:function(a,b){return a.hasAttribute("alt")}},{id:"has-visible-text",evaluate:function(a,b){return R.text.accessibleText(a).length>0}},{id:"non-empty-alt",evaluate:function(a,b){var c=a.getAttribute("alt");return!!(c?R.text.sanitize(c).trim():"")}},{id:"non-empty-if-present",evaluate:function(a,b){var c=a.getAttribute("value");return this.data(c),null===c||""!==R.text.sanitize(c).trim()},selector:'[type="submit"], [type="reset"]'},{id:"non-empty-title",evaluate:function(a,b){var c=a.getAttribute("title");return!!(c?R.text.sanitize(c).trim():"")}},{id:"non-empty-value",evaluate:function(a,b){var c=a.getAttribute("value");return!!(c?R.text.sanitize(c).trim():"")},selector:'[type="button"]'},{id:"role-none",evaluate:function(a,b){return"none"===a.getAttribute("role")}},{id:"role-presentation",evaluate:function(a,b){return"presentation"===a.getAttribute("role")}},{id:"cell-no-header",evaluate:function(a,b){for(var c,d,e=[],f=0,g=a.rows.length;g>f;f++){c=a.rows[f];for(var h=0,i=c.cells.length;i>h;h++)d=c.cells[h],!R.table.isDataCell(d)||R.aria.label(d)||R.table.getHeaders(d).length||e.push(d)}return e.length?(this.relatedNodes(e),!0):!1}},{id:"consistent-columns",evaluate:function(a,b){for(var c,d=R.table.toArray(a),e=[],f=0,g=d.length;g>f;f++)0===f?c=d[f].length:c!==d[f].length&&e.push(a.rows[f]);return!e.length}},{id:"has-caption",evaluate:function(a,b){return!!a.caption}},{id:"has-summary",evaluate:function(a,b){return!!a.summary}},{id:"has-th",evaluate:function(a,b){for(var c,d,e=[],f=0,g=a.rows.length;g>f;f++){c=a.rows[f];for(var h=0,i=c.cells.length;i>h;h++)d=c.cells[h],"TH"===d.nodeName&&e.push(d)}return e.length?(this.relatedNodes(e),!0):!1}},{id:"headers-attr-reference",evaluate:function(a,b){function c(a){a&&R.text.accessibleText(a)||g.push(e)}for(var d,e,f,g=[],h=0,i=a.rows.length;i>h;h++){d=a.rows[h];for(var j=0,k=d.cells.length;k>j;j++)e=d.cells[j],f=R.dom.idrefs(e,"headers"),f.length&&f.forEach(c)}return g.length?(this.relatedNodes(g),!0):!1}},{id:"headers-visible-text",evaluate:function(a,b){for(var c,d,e=[],f=0,g=a.rows.length;g>f;f++){c=a.rows[f];for(var h=0,i=c.cells.length;i>h;h++)d=c.cells[h],R.table.isHeader(d)&&!R.text.accessibleText(d)&&e.push(d)}return e.length?(this.relatedNodes(e),!0):!1}},{id:"html4-scope",evaluate:function(a,c){return R.dom.isHTML5(b)?!1:"TH"===a.nodeName||"TD"===a.nodeName}},{id:"html5-scope",evaluate:function(a,c){return R.dom.isHTML5(b)?"TH"===a.nodeName:!1}},{id:"no-caption",evaluate:function(a,b){return!(a.caption||{}).textContent},enabled:!1},{id:"rowspan",evaluate:function(a,b){for(var c,d,e=[],f=0,g=a.rows.length;g>f;f++){c=a.rows[f];for(var h=0,i=c.cells.length;i>h;h++)d=c.cells[h],1!==d.rowSpan&&e.push(d)}return e.length?(this.relatedNodes(e),!0):!1}},{id:"same-caption-summary",selector:"table",evaluate:function(a,b){return!(!a.summary||!a.caption)&&a.summary===R.text.accessibleText(a.caption)}},{id:"scope-value",evaluate:function(a,b){var c=a.getAttribute("scope");return"row"!==c&&"col"!==c}},{id:"th-headers-attr",evaluate:function(a,b){for(var c,d,e=[],f=0,g=a.rows.length;g>f;f++){c=a.rows[f];for(var h=0,i=c.cells.length;i>h;h++)d=c.cells[h],"TH"===d.nodeName&&d.getAttribute("headers")&&e.push(d)}return e.length?(this.relatedNodes(e),!0):!1}},{id:"th-scope",evaluate:function(a,b){for(var c,d,e=[],f=0,g=a.rows.length;g>f;f++){c=a.rows[f];for(var h=0,i=c.cells.length;i>h;h++)d=c.cells[h],"TH"!==d.nodeName||d.getAttribute("scope")||e.push(d)}return e.length?(this.relatedNodes(e),!0):!1}},{id:"th-single-row-column",evaluate:function(a,b){for(var c,d,e,f=[],g=[],h=0,i=a.rows.length;i>h;h++){c=a.rows[h];for(var j=0,k=c.cells.length;k>j;j++)d=c.cells[j],d.nodeName&&(R.table.isColumnHeader(d)&&-1===g.indexOf(h)?g.push(h):R.table.isRowHeader(d)&&(e=R.table.getCellPosition(d),-1===f.indexOf(e.x)&&f.push(e.x)))}return g.length>1||f.length>1?!0:!1}}],commons:function(){function c(b){var c,d=a.getComputedStyle(b);if("none"!==d.getPropertyValue("background-image"))return null;var e=d.getPropertyValue("background-color");"transparent"===e?c=new r.Color(0,0,0,0):(c=new r.Color,c.parseRgbString(e));var f=d.getPropertyValue("opacity");return c.alpha=c.alpha*f,c}function d(a){"use strict";var b=a.match(/rect\s*\(([0-9]+)px,?\s*([0-9]+)px,?\s*([0-9]+)px,?\s*([0-9]+)px\s*\)/);return b&&5===b.length?b[3]-b[1]<=0&&b[2]-b[4]<=0:!1}function e(a){var c=null;return a.id&&(c=b.querySelector('label[for="'+v.escapeSelector(a.id)+'"]'))?c:c=s.findUp(a,"label")}function f(a){return-1!==["button","reset","submit"].indexOf(a.type)}function g(a){return"TEXTAREA"===a.nodeName||"SELECT"===a.nodeName||"INPUT"===a.nodeName&&"hidden"!==a.type}function h(a){return-1!==["BUTTON","SUMMARY","A"].indexOf(a.nodeName)}function i(a){return-1!==["TABLE","FIGURE"].indexOf(a.nodeName)}function j(a){if("INPUT"===a.nodeName)return!a.hasAttribute("type")||-1!==y.indexOf(a.getAttribute("type"))&&a.value?a.value:"";if("SELECT"===a.nodeName){var b=a.options;if(b&&b.length){for(var c="",d=0;d<b.length;d++)b[d].selected&&(c+=" "+b[d].text);return u.sanitize(c)}return""}return"TEXTAREA"===a.nodeName&&a.value?a.value:""}function k(a,b){var c=a.querySelector(b);return c?u.accessibleText(c):""}function l(a){if(!a)return!1;switch(a.nodeName){case"SELECT":case"TEXTAREA":return!0;case"INPUT":return!a.hasAttribute("type")||-1!==y.indexOf(a.getAttribute("type"));default:return!1}}function m(a){return"INPUT"===a.nodeName&&"image"===a.type||-1!==["IMG","APPLET","AREA"].indexOf(a.nodeName)}function n(a){return!!u.sanitize(a)}var o={},p=o.aria={},q=p._lut={};q.attributes={"aria-activedescendant":{type:"idref"},"aria-atomic":{type:"boolean",values:["true","false"]},"aria-autocomplete":{type:"nmtoken",values:["inline","list","both","none"]},"aria-busy":{type:"boolean",values:["true","false"]},"aria-checked":{type:"nmtoken",values:["true","false","mixed","undefined"]},"aria-colcount":{type:"int"},"aria-colindex":{type:"int"},"aria-colspan":{type:"int"},"aria-controls":{type:"idrefs"},"aria-describedby":{type:"idrefs"},"aria-disabled":{type:"boolean",values:["true","false"]},"aria-dropeffect":{type:"nmtokens",values:["copy","move","reference","execute","popup","none"]},"aria-expanded":{type:"nmtoken",values:["true","false","undefined"]},"aria-flowto":{type:"idrefs"},"aria-grabbed":{type:"nmtoken",values:["true","false","undefined"]},"aria-haspopup":{type:"boolean",values:["true","false"]},"aria-hidden":{type:"boolean",values:["true","false"]},"aria-invalid":{type:"nmtoken",values:["true","false","spelling","grammar"]},"aria-label":{type:"string"},"aria-labelledby":{type:"idrefs"},"aria-level":{type:"int"},"aria-live":{type:"nmtoken",values:["off","polite","assertive"]},"aria-multiline":{type:"boolean",values:["true","false"]},"aria-multiselectable":{type:"boolean",values:["true","false"]},"aria-orientation":{type:"nmtoken",values:["horizontal","vertical"]},"aria-owns":{type:"idrefs"},"aria-posinset":{type:"int"},"aria-pressed":{type:"nmtoken",values:["true","false","mixed","undefined"]},"aria-readonly":{type:"boolean",values:["true","false"]},"aria-relevant":{type:"nmtokens",values:["additions","removals","text","all"]},"aria-required":{type:"boolean",values:["true","false"]},"aria-rowcount":{type:"int"},"aria-rowindex":{type:"int"},"aria-rowspan":{type:"int"},"aria-selected":{type:"nmtoken",values:["true","false","undefined"]},"aria-setsize":{type:"int"},"aria-sort":{type:"nmtoken",values:["ascending","descending","other","none"]},"aria-valuemax":{type:"decimal"},"aria-valuemin":{type:"decimal"},"aria-valuenow":{type:"decimal"},"aria-valuetext":{type:"string"}},q.globalAttributes=["aria-atomic","aria-busy","aria-controls","aria-describedby","aria-disabled","aria-dropeffect","aria-flowto","aria-grabbed","aria-haspopup","aria-hidden","aria-invalid","aria-label","aria-labelledby","aria-live","aria-owns","aria-relevant"],q.role={alert:{type:"widget",attributes:{allowed:["aria-expanded"]},owned:null,nameFrom:["author"],context:null},alertdialog:{type:"widget",attributes:{allowed:["aria-expanded"]},owned:null,nameFrom:["author"],context:null},application:{type:"landmark",attributes:{allowed:["aria-expanded"]},owned:null,nameFrom:["author"],context:null},article:{type:"structure",attributes:{allowed:["aria-expanded"]},owned:null,nameFrom:["author"],context:null,implicit:["article"]},banner:{type:"landmark",attributes:{allowed:["aria-expanded"]},owned:null,nameFrom:["author"],context:null},button:{type:"widget",attributes:{allowed:["aria-expanded","aria-pressed"]},owned:null,nameFrom:["author","contents"],context:null,implicit:["button",'input[type="button"]','input[type="image"]']},cell:{type:"structure",attributes:{allowed:["aria-colindex","aria-colspan","aria-rowindex","aria-rowspan"]},owned:null,nameFrom:["author","contents"],context:["row"]},checkbox:{type:"widget",attributes:{required:["aria-checked"]},owned:null,nameFrom:["author","contents"],context:null,implicit:['input[type="checkbox"]']},columnheader:{type:"structure",attributes:{allowed:["aria-expanded","aria-sort","aria-readonly","aria-selected","aria-required"]},owned:null,nameFrom:["author","contents"],context:["row"]},combobox:{type:"composite",attributes:{required:["aria-expanded"],allowed:["aria-autocomplete","aria-required","aria-activedescendant"]},owned:{all:["listbox","textbox"]},nameFrom:["author"],context:null},command:{nameFrom:["author"],type:"abstract"},complementary:{type:"landmark",attributes:{allowed:["aria-expanded"]},owned:null,nameFrom:["author"],context:null,implicit:["aside"]},composite:{nameFrom:["author"],type:"abstract"},contentinfo:{type:"landmark",attributes:{allowed:["aria-expanded"]},owned:null,nameFrom:["author"],context:null},definition:{type:"structure",attributes:{allowed:["aria-expanded"]},owned:null,nameFrom:["author"],context:null},dialog:{type:"widget",attributes:{allowed:["aria-expanded"]},owned:null,nameFrom:["author"],context:null,implicit:["dialog"]},directory:{type:"structure",attributes:{allowed:["aria-expanded"]},owned:null,nameFrom:["author","contents"],context:null},document:{type:"structure",attributes:{allowed:["aria-expanded"]},owned:null,nameFrom:["author"],context:null,implicit:["body"]},form:{type:"landmark",attributes:{allowed:["aria-expanded"]},owned:null,nameFrom:["author"],context:null},grid:{type:"composite",attributes:{allowed:["aria-level","aria-multiselectable","aria-readonly","aria-activedescendant","aria-expanded"]},owned:{one:["rowgroup","row"]},nameFrom:["author"],context:null},gridcell:{type:"widget",attributes:{allowed:["aria-selected","aria-readonly","aria-expanded","aria-required"]},owned:null,nameFrom:["author","contents"],context:["row"]},group:{type:"structure",attributes:{allowed:["aria-activedescendant","aria-expanded"]},owned:null,nameFrom:["author"],context:null,implicit:["details"]},heading:{type:"structure",attributes:{allowed:["aria-level","aria-expanded"]},owned:null,nameFrom:["author","contents"],context:null,implicit:["h1","h2","h3","h4","h5","h6"]},img:{type:"structure",attributes:{allowed:["aria-expanded"]},owned:null,nameFrom:["author"],context:null,implicit:["img"]},input:{nameFrom:["author"],type:"abstract"},landmark:{nameFrom:["author"],type:"abstract"},link:{type:"widget",attributes:{allowed:["aria-expanded"]},owned:null,nameFrom:["author","contents"],context:null,implicit:["a[href]"]},list:{type:"structure",attributes:{allowed:["aria-expanded"]},owned:{all:["listitem"]},nameFrom:["author"],context:null,implicit:["ol","ul"]},listbox:{type:"composite",attributes:{allowed:["aria-activedescendant","aria-multiselectable","aria-required","aria-expanded"]},owned:{all:["option"]},nameFrom:["author"],context:null,implicit:["select"]},listitem:{type:"structure",attributes:{allowed:["aria-level","aria-posinset","aria-setsize","aria-expanded"]},owned:null,nameFrom:["author","contents"],context:["list"],implicit:["li"]},log:{type:"widget",attributes:{allowed:["aria-expanded"]},owned:null,nameFrom:["author"],context:null},main:{type:"landmark",attributes:{allowed:["aria-expanded"]},owned:null,nameFrom:["author"],context:null},marquee:{type:"widget",attributes:{allowed:["aria-expanded"]},owned:null,nameFrom:["author"],context:null},math:{type:"structure",attributes:{allowed:["aria-expanded"]},owned:null,nameFrom:["author"],context:null},menu:{type:"composite",attributes:{allowed:["aria-activedescendant","aria-expanded"]},owned:{one:["menuitem","menuitemradio","menuitemcheckbox"]},nameFrom:["author"],context:null},menubar:{type:"composite",attributes:{allowed:["aria-activedescendant","aria-expanded"]},owned:null,nameFrom:["author"],context:null},menuitem:{type:"widget",attributes:null,owned:null,nameFrom:["author","contents"],context:["menu","menubar"]},menuitemcheckbox:{type:"widget",attributes:{required:["aria-checked"]},owned:null,nameFrom:["author","contents"],context:["menu","menubar"]},menuitemradio:{type:"widget",attributes:{allowed:["aria-selected","aria-posinset","aria-setsize"],required:["aria-checked"]},owned:null,nameFrom:["author","contents"],context:["menu","menubar"]},navigation:{type:"landmark",attributes:{allowed:["aria-expanded"]},owned:null,nameFrom:["author"],context:null},none:{type:"structure",attributes:null,owned:null,nameFrom:["author"],context:null},note:{type:"structure",attributes:{allowed:["aria-expanded"]},owned:null,nameFrom:["author"],context:null},option:{type:"widget",attributes:{allowed:["aria-selected","aria-posinset","aria-setsize","aria-checked"]},owned:null,nameFrom:["author","contents"],context:["listbox"]},presentation:{type:"structure",attributes:null,owned:null,nameFrom:["author"],context:null},progressbar:{type:"widget",attributes:{allowed:["aria-valuetext","aria-valuenow","aria-valuemax","aria-valuemin"]},owned:null,nameFrom:["author"],context:null},radio:{type:"widget",attributes:{allowed:["aria-selected","aria-posinset","aria-setsize"],required:["aria-checked"]},owned:null,nameFrom:["author","contents"],context:null,implicit:['input[type="radio"]']},radiogroup:{type:"composite",attributes:{allowed:["aria-activedescendant","aria-required","aria-expanded"]},owned:{all:["radio"]},nameFrom:["author"],context:null},range:{nameFrom:["author"],type:"abstract"},region:{type:"structure",attributes:{allowed:["aria-expanded"]},owned:null,nameFrom:["author"],context:null,implicit:["section"]},roletype:{type:"abstract"},row:{type:"structure",attributes:{allowed:["aria-level","aria-selected","aria-activedescendant","aria-expanded"]},owned:{one:["cell","columnheader","rowheader","gridcell"]},nameFrom:["author","contents"],context:["rowgroup","grid","treegrid","table"]},rowgroup:{type:"structure",attributes:{allowed:["aria-activedescendant","aria-expanded"]},owned:{all:["row"]},nameFrom:["author","contents"],context:["grid","table"]},rowheader:{type:"structure",attributes:{allowed:["aria-sort","aria-required","aria-readonly","aria-expanded","aria-selected"]},owned:null,nameFrom:["author","contents"],context:["row"]},scrollbar:{type:"widget",attributes:{required:["aria-controls","aria-orientation","aria-valuenow","aria-valuemax","aria-valuemin"],allowed:["aria-valuetext"]},owned:null,nameFrom:["author"],context:null},search:{type:"landmark",attributes:{allowed:["aria-expanded"]},owned:null,nameFrom:["author"],context:null},searchbox:{type:"widget",attributes:{allowed:["aria-activedescendant","aria-autocomplete","aria-multiline","aria-readonly","aria-required"]},owned:null,nameFrom:["author"],context:null,implicit:['input[type="search"]']},section:{nameFrom:["author","contents"],type:"abstract"},sectionhead:{nameFrom:["author","contents"],type:"abstract"},select:{nameFrom:["author"],type:"abstract"},separator:{type:"structure",attributes:{allowed:["aria-expanded","aria-orientation"]},owned:null,nameFrom:["author"],context:null},slider:{type:"widget",attributes:{allowed:["aria-valuetext","aria-orientation"],required:["aria-valuenow","aria-valuemax","aria-valuemin"]},owned:null,nameFrom:["author"],context:null},spinbutton:{type:"widget",attributes:{allowed:["aria-valuetext","aria-required"],required:["aria-valuenow","aria-valuemax","aria-valuemin"]},owned:null,nameFrom:["author"],context:null},status:{type:"widget",attributes:{allowed:["aria-expanded"]},owned:null,nameFrom:["author"],context:null,implicit:["output"]},structure:{type:"abstract"},"switch":{type:"widget",attributes:{required:["aria-checked"]},owned:null,nameFrom:["author","contents"],context:null},tab:{type:"widget",attributes:{allowed:["aria-selected","aria-expanded"]},owned:null,nameFrom:["author","contents"],context:["tablist"]},table:{type:"structure",attributes:{allowed:["aria-colcount","aria-rowcount"]},owned:{one:["rowgroup","row"]},nameFrom:["author"],context:null,implicit:["table"]},tablist:{type:"composite",attributes:{allowed:["aria-activedescendant","aria-expanded","aria-level","aria-multiselectable"]},owned:{all:["tab"]},nameFrom:["author"],context:null},tabpanel:{type:"widget",attributes:{allowed:["aria-expanded"]},owned:null,nameFrom:["author"],context:null},text:{type:"structure",owned:null,nameFrom:["author","contents"],context:null},textbox:{type:"widget",attributes:{allowed:["aria-activedescendant","aria-autocomplete","aria-multiline","aria-readonly","aria-required"]},owned:null,nameFrom:["author"],context:null,implicit:['input[type="text"]',"input:not([type])"]},timer:{type:"widget",attributes:{allowed:["aria-expanded"]},owned:null,nameFrom:["author"],context:null},toolbar:{type:"structure",attributes:{allowed:["aria-activedescendant","aria-expanded"]},owned:null,nameFrom:["author"],context:null,implicit:['menu[type="toolbar"]']},tooltip:{type:"widget",attributes:{allowed:["aria-expanded"]},owned:null,nameFrom:["author","contents"],context:null},tree:{type:"composite",attributes:{allowed:["aria-activedescendant","aria-multiselectable","aria-required","aria-expanded"]},owned:{all:["treeitem"]},nameFrom:["author"],context:null},treegrid:{type:"composite",attributes:{allowed:["aria-activedescendant","aria-expanded","aria-level","aria-multiselectable","aria-readonly","aria-required"]},owned:{all:["treeitem"]},nameFrom:["author"],context:null},treeitem:{type:"widget",attributes:{allowed:["aria-checked","aria-selected","aria-expanded","aria-level","aria-posinset","aria-setsize"]},owned:null,nameFrom:["author","contents"],context:["treegrid","tree"]},widget:{type:"abstract"},window:{nameFrom:["author"],type:"abstract"}};var r={};o.color=r;var s=o.dom={},t=o.table={},u=o.text={},v=o.utils={};v.escapeSelector=S.utils.escapeSelector,v.matchesSelector=S.utils.matchesSelector,v.clone=S.utils.clone,p.requiredAttr=function(a){"use strict";var b=q.role[a],c=b&&b.attributes&&b.attributes.required;return c||[]},p.allowedAttr=function(a){"use strict";var b=q.role[a],c=b&&b.attributes&&b.attributes.allowed||[],d=b&&b.attributes&&b.attributes.required||[];return c.concat(q.globalAttributes).concat(d)},p.validateAttr=function(a){"use strict";return!!q.attributes[a]},p.validateAttrValue=function(a,c){"use strict";var d,e,f,g,h=b,i=a.getAttribute(c),j=q.attributes[c];if(!j)return!0;if(j.values)return"string"==typeof i&&-1!==j.values.indexOf(i.toLowerCase())?!0:!1;switch(j.type){case"idref":return!(!i||!h.getElementById(i));case"idrefs":for(d=v.tokenList(i),e=0,f=d.length;f>e;e++)if(d[e]&&!h.getElementById(d[e]))return!1;return!!d.length;case"string":return!0;case"decimal":return g=i.match(/^[-+]?([0-9]*)\.?([0-9]*)$/),!(!g||!g[1]&&!g[2]);case"int":return/^[-+]?[0-9]+$/.test(i)}},p.label=function(a){var b,c;return a.getAttribute("aria-labelledby")&&(b=s.idrefs(a,"aria-labelledby"),c=b.map(function(a){return a?u.visible(a,!0):""}).join(" ").trim())?c:(c=a.getAttribute("aria-label"),c&&(c=u.sanitize(c).trim())?c:null)},p.isValidRole=function(a){"use strict";return q.role[a]?!0:!1},p.getRolesWithNameFromContents=function(){return Object.keys(q.role).filter(function(a){return q.role[a].nameFrom&&-1!==q.role[a].nameFrom.indexOf("contents")})},p.getRolesByType=function(a){return Object.keys(q.role).filter(function(b){return q.role[b].type===a})},p.getRoleType=function(a){var b=q.role[a];return b&&b.type||null},p.requiredOwned=function(a){"use strict";var b=null,c=q.role[a];return c&&(b=v.clone(c.owned)),b},p.requiredContext=function(a){"use strict";var b=null,c=q.role[a];return c&&(b=v.clone(c.context)),b},p.implicitNodes=function(a){"use strict";var b=null,c=q.role[a];return c&&c.implicit&&(b=v.clone(c.implicit)),b},p.implicitRole=function(a){"use strict";var b,c,d,e=q.role;for(b in e)if(e.hasOwnProperty(b)&&(c=e[b],c.implicit))for(var f=0,g=c.implicit.length;g>f;f++)if(d=c.implicit[f],v.matchesSelector(a,d))return b;return null},r.Color=function(a,b,c,d){this.red=a,this.green=b,this.blue=c,this.alpha=d,this.toHexString=function(){var a=Math.round(this.red).toString(16),b=Math.round(this.green).toString(16),c=Math.round(this.blue).toString(16);return"#"+(this.red>15.5?a:"0"+a)+(this.green>15.5?b:"0"+b)+(this.blue>15.5?c:"0"+c)};var e=/^rgb\((\d+), (\d+), (\d+)\)$/,f=/^rgba\((\d+), (\d+), (\d+), (\d*(\.\d+)?)\)/;this.parseRgbString=function(a){var b=a.match(e);return b?(this.red=parseInt(b[1],10),this.green=parseInt(b[2],10),this.blue=parseInt(b[3],10),void(this.alpha=1)):(b=a.match(f),b?(this.red=parseInt(b[1],10),this.green=parseInt(b[2],10),this.blue=parseInt(b[3],10),void(this.alpha=parseFloat(b[4]))):void 0)},this.getRelativeLuminance=function(){var a=this.red/255,b=this.green/255,c=this.blue/255,d=.03928>=a?a/12.92:Math.pow((a+.055)/1.055,2.4),e=.03928>=b?b/12.92:Math.pow((b+.055)/1.055,2.4),f=.03928>=c?c/12.92:Math.pow((c+.055)/1.055,2.4);return.2126*d+.7152*e+.0722*f}},r.flattenColors=function(a,b){var c=a.alpha,d=(1-c)*b.red+c*a.red,e=(1-c)*b.green+c*a.green,f=(1-c)*b.blue+c*a.blue,g=a.alpha+b.alpha*(1-a.alpha);return new r.Color(d,e,f,g)},r.getContrast=function(a,b){if(!b||!a)return null;b.alpha<1&&(b=r.flattenColors(b,a));var c=a.getRelativeLuminance(),d=b.getRelativeLuminance();return(Math.max(d,c)+.05)/(Math.min(d,c)+.05)},r.hasValidContrastRatio=function(a,b,c,d){var e=r.getContrast(a,b),f=d&&Math.ceil(72*c)/96<14||!d&&Math.ceil(72*c)/96<18;return{isValid:f&&e>=4.5||!f&&e>=3,contrastRatio:e}},s.isOpaque=function(a){var b=c(a);return null===b||1===b.alpha?!0:!1};var w=function(c,d){for(var e,f,g,h,i,j,k,l=[],m=!1,n=c,o=a.getComputedStyle(n);null!==n&&(!s.isOpaque(n)||0===parseInt(o.getPropertyValue("height"),10));)g=o.getPropertyValue("position"),h=o.getPropertyValue("top"),i=o.getPropertyValue("bottom"),j=o.getPropertyValue("left"),k=o.getPropertyValue("right"),("static"!==g&&"relative"!==g||"relative"===g&&("auto"!==j||"auto"!==k||"auto"!==h||"auto"!==i))&&(m=!0),n=n.parentElement,null!==n&&(o=a.getComputedStyle(n),0!==parseInt(o.getPropertyValue("height"),10)&&l.push(n));if(m&&s.supportsElementsFromPoint(b)){if(e=s.elementsFromPoint(b,Math.ceil(d.left+1),Math.ceil(d.top+1)),f=e.indexOf(c),-1===f)return null;e&&f<e.length-1&&(l=e.slice(f+1))}return l};r.getBackgroundColor=function(a,b){var d,e,f=c(a);if(!b||null!==f&&0===f.alpha||b.push(a),null===f||1===f.alpha)return f;a.scrollIntoView();var g=a.getBoundingClientRect(),h=a,i=[{color:f,node:a}],j=w(h,g);if(!j)return null;for(;1!==f.alpha;){if(d=j.shift(),!d&&"HTML"!==h.tagName)return null;if(d||"HTML"!==h.tagName){if(!s.visuallyContains(a,d))return null;if(e=c(d),!b||null!==e&&0===e.alpha||b.push(d),null===e)return null}else e=new r.Color(255,255,255,1);h=d,f=e,i.push({color:f,node:h})}for(var k=i.pop(),l=k.color;void 0!==(k=i.pop());)l=r.flattenColors(k.color,l);return l},r.getForegroundColor=function(b){var c=a.getComputedStyle(b),d=new r.Color;d.parseRgbString(c.getPropertyValue("color"));var e=c.getPropertyValue("opacity");if(d.alpha=d.alpha*e,1===d.alpha)return d;var f=r.getBackgroundColor(b);return null===f?null:r.flattenColors(d,f)},s.supportsElementsFromPoint=function(a){var b=a.createElement("x");return b.style.cssText="pointer-events:auto","auto"===b.style.pointerEvents||!!a.msElementsFromPoint},s.elementsFromPoint=function(a,b,c){var d,e,f,g=[],h=[];if(a.msElementsFromPoint){var i=a.msElementsFromPoint(b,c);return i?Array.prototype.slice.call(i):null;
}for(;(d=a.elementFromPoint(b,c))&&-1===g.indexOf(d)&&null!==d&&(g.push(d),h.push({value:d.style.getPropertyValue("pointer-events"),priority:d.style.getPropertyPriority("pointer-events")}),d.style.setProperty("pointer-events","none","important"),!s.isOpaque(d)););for(e=h.length;f=h[--e];)g[e].style.setProperty("pointer-events",f.value?f.value:"",f.priority);return g},s.findUp=function(a,c){"use strict";var d,e=b.querySelectorAll(c),f=e.length;if(!f)return null;for(e=v.toArray(e),d=a.parentNode;d&&-1===e.indexOf(d);)d=d.parentNode;return d},s.getElementByReference=function(a,c){"use strict";var d,e=a.getAttribute(c),f=b;if(e&&"#"===e.charAt(0)){if(e=e.substring(1),d=f.getElementById(e))return d;if(d=f.getElementsByName(e),d.length)return d[0]}return null},s.getElementCoordinates=function(a){"use strict";var c=s.getScrollOffset(b),d=c.left,e=c.top,f=a.getBoundingClientRect();return{top:f.top+e,right:f.right+d,bottom:f.bottom+e,left:f.left+d,width:f.right-f.left,height:f.bottom-f.top}},s.getScrollOffset=function(a){"use strict";if(!a.nodeType&&a.document&&(a=a.document),9===a.nodeType){var b=a.documentElement,c=a.body;return{left:b&&b.scrollLeft||c&&c.scrollLeft||0,top:b&&b.scrollTop||c&&c.scrollTop||0}}return{left:a.scrollLeft,top:a.scrollTop}},s.getViewportSize=function(a){"use strict";var b,c=a.document,d=c.documentElement;return a.innerWidth?{width:a.innerWidth,height:a.innerHeight}:d?{width:d.clientWidth,height:d.clientHeight}:(b=c.body,{width:b.clientWidth,height:b.clientHeight})},s.idrefs=function(a,c){"use strict";var d,e,f=b,g=[],h=a.getAttribute(c);if(h)for(h=v.tokenList(h),d=0,e=h.length;e>d;d++)g.push(f.getElementById(h[d]));return g},s.isFocusable=function(a){"use strict";if(!a||a.disabled||!s.isVisible(a)&&"AREA"!==a.nodeName)return!1;switch(a.nodeName){case"A":case"AREA":if(a.href)return!0;break;case"INPUT":return"hidden"!==a.type;case"TEXTAREA":case"SELECT":case"DETAILS":case"BUTTON":return!0}var b=a.getAttribute("tabindex");return b&&!isNaN(parseInt(b,10))?!0:!1},s.isHTML5=function(a){var b=a.doctype;return null===b?!1:"html"===b.name&&!b.publicId&&!b.systemId},s.isNode=function(a){"use strict";return a instanceof Node},s.isOffscreen=function(c){"use strict";var d,e=b.documentElement,f=a.getComputedStyle(b.body||e).getPropertyValue("direction"),g=s.getElementCoordinates(c);if(g.bottom<0)return!0;if("ltr"===f){if(g.right<0)return!0}else if(d=Math.max(e.scrollWidth,s.getViewportSize(a).width),g.left>d)return!0;return!1},s.isVisible=function(b,c,e){"use strict";var f,g=b.nodeName,h=b.parentNode;return 9===b.nodeType?!0:(f=a.getComputedStyle(b,null),null===f?!1:"none"===f.getPropertyValue("display")||"STYLE"===g||"SCRIPT"===g||!c&&d(f.getPropertyValue("clip"))||!e&&("hidden"===f.getPropertyValue("visibility")||!c&&s.isOffscreen(b))||c&&"true"===b.getAttribute("aria-hidden")?!1:h?s.isVisible(h,c,!0):!1)},s.isVisualContent=function(a){"use strict";switch(a.tagName.toUpperCase()){case"IMG":case"IFRAME":case"OBJECT":case"VIDEO":case"AUDIO":case"CANVAS":case"SVG":case"MATH":case"BUTTON":case"SELECT":case"TEXTAREA":case"KEYGEN":case"PROGRESS":case"METER":return!0;case"INPUT":return"hidden"!==a.type;default:return!1}},s.visuallyContains=function(b,c){var d=b.getBoundingClientRect(),e=c.getBoundingClientRect(),f=e.top,g=e.left,h={top:f-c.scrollTop,bottom:f-c.scrollTop+c.scrollHeight,left:g-c.scrollLeft,right:g-c.scrollLeft+c.scrollWidth};if(d.left<h.left&&d.left<e.left||d.top<h.top&&d.top<e.top||d.right>h.right&&d.right>e.right||d.bottom>h.bottom&&d.bottom>e.bottom)return!1;var i=a.getComputedStyle(c);return d.right>e.right||d.bottom>e.bottom?"scroll"===i.overflow||"auto"===i.overflow||"hidden"===i.overflow||c instanceof HTMLBodyElement||c instanceof HTMLHtmlElement:!0},s.visuallyOverlaps=function(b,c){var d=c.getBoundingClientRect(),e=d.top,f=d.left,g={top:e-c.scrollTop,bottom:e-c.scrollTop+c.scrollHeight,left:f-c.scrollLeft,right:f-c.scrollLeft+c.scrollWidth};if(b.left>g.right&&b.left>d.right||b.top>g.bottom&&b.top>d.bottom||b.right<g.left&&b.right<d.left||b.bottom<g.top&&b.bottom<d.top)return!1;var h=a.getComputedStyle(c);return b.left>d.right||b.top>d.bottom?"scroll"===h.overflow||"auto"===h.overflow||c instanceof HTMLBodyElement||c instanceof HTMLHtmlElement:!0},t.getCellPosition=function(a){for(var b,c=t.toArray(s.findUp(a,"table")),d=0;d<c.length;d++)if(c[d]&&(b=c[d].indexOf(a),-1!==b))return{x:b,y:d}},t.getHeaders=function(a){if(a.getAttribute("headers"))return o.dom.idrefs(a,"headers");for(var b,c=[],d=o.table.toArray(o.dom.findUp(a,"table")),e=o.table.getCellPosition(a),f=e.x-1;f>=0;f--)b=d[e.y][f],o.table.isRowHeader(b)&&c.unshift(b);for(var g=e.y-1;g>=0;g--)b=d[g][e.x],b&&o.table.isColumnHeader(b)&&c.unshift(b);return c},t.isColumnHeader=function(a){var b=a.getAttribute("scope");if("col"===b)return!0;if(b||"TH"!==a.nodeName)return!1;for(var c,d=t.getCellPosition(a),e=t.toArray(s.findUp(a,"table")),f=e[d.y],g=0,h=f.length;h>g;g++)if(c=f[g],c!==a&&t.isDataCell(c))return!1;return!0},t.isDataCell=function(a){return a.children.length||a.textContent.trim()?"TD"===a.nodeName:!1},t.isDataTable=function(b){var c=b.getAttribute("role");if(("presentation"===c||"none"===c)&&!s.isFocusable(b))return!1;if("true"===b.getAttribute("contenteditable")||s.findUp(b,'[contenteditable="true"]'))return!0;if("grid"===c||"treegrid"===c||"table"===c)return!0;if("landmark"===o.aria.getRoleType(c))return!0;if("0"===b.getAttribute("datatable"))return!1;if(b.getAttribute("summary"))return!0;if(b.tHead||b.tFoot||b.caption)return!0;for(var d=0,e=b.children.length;e>d;d++)if("COLGROUP"===b.children[d].nodeName)return!0;for(var f,g,h=0,i=b.rows.length,j=!1,k=0;i>k;k++){f=b.rows[k];for(var l=0,m=f.cells.length;m>l;l++){if(g=f.cells[l],j||g.offsetWidth===g.clientWidth&&g.offsetHeight===g.clientHeight||(j=!0),g.getAttribute("scope")||g.getAttribute("headers")||g.getAttribute("abbr"))return!0;if("TH"===g.nodeName)return!0;if(1===g.children.length&&"ABBR"===g.children[0].nodeName)return!0;h++}}if(b.getElementsByTagName("table").length)return!1;if(2>i)return!1;var n=b.rows[Math.ceil(i/2)];if(1===n.cells.length&&1===n.cells[0].colSpan)return!1;if(n.cells.length>=5)return!0;if(j)return!0;var p,q;for(k=0;i>k;k++){if(f=b.rows[k],p&&p!==a.getComputedStyle(f).getPropertyValue("background-color"))return!0;if(p=a.getComputedStyle(f).getPropertyValue("background-color"),q&&q!==a.getComputedStyle(f).getPropertyValue("background-image"))return!0;q=a.getComputedStyle(f).getPropertyValue("background-image")}return i>=20?!0:s.getElementCoordinates(b).width>.95*s.getViewportSize(a).width?!1:10>h?!1:b.querySelector("object, embed, iframe, applet")?!1:!0},t.isHeader=function(a){return t.isColumnHeader(a)||t.isRowHeader(a)?!0:a.id?!!b.querySelector('[headers~="'+v.escapeSelector(a.id)+'"]'):!1},t.isRowHeader=function(a){var b=a.getAttribute("scope");if("row"===b)return!0;if(b||"TH"!==a.nodeName)return!1;if(t.isColumnHeader(a))return!1;for(var c,d=t.getCellPosition(a),e=t.toArray(s.findUp(a,"table")),f=0,g=e.length;g>f;f++)if(c=e[f][d.x],c!==a&&t.isDataCell(c))return!1;return!0},t.toArray=function(a){for(var b=[],c=a.rows,d=0,e=c.length;e>d;d++){var f=c[d].cells;b[d]=b[d]||[];for(var g=0,h=0,i=f.length;i>h;h++)for(var j=0;j<f[h].colSpan;j++){for(var k=0;k<f[h].rowSpan;k++){for(b[d+k]=b[d+k]||[];b[d+k][g];)g++;b[d+k][g]=f[h]}g++}}return b};var x={submit:"Submit",reset:"Reset"},y=["text","search","tel","url","email","date","time","number","range","color"],z=["a","em","strong","small","mark","abbr","dfn","i","b","s","u","code","var","samp","kbd","sup","sub","q","cite","span","bdo","bdi","br","wbr","ins","del","img","embed","object","iframe","map","area","script","noscript","ruby","video","audio","input","textarea","select","button","label","output","datalist","keygen","progress","command","canvas","time","meter"];return u.accessibleText=function(a){function b(a,b,c){var i="";if(h(a)&&(i=d(a,!1,!1)||"",n(i)))return i;if("FIGURE"===a.nodeName&&(i=k(a,"figcaption"),n(i)))return i;if("TABLE"===a.nodeName){if(i=k(a,"caption"),n(i))return i;if(i=a.getAttribute("title")||a.getAttribute("summary")||"",n(i))return i}if(m(a))return a.getAttribute("alt")||"";if(g(a)&&!c){if(f(a))return a.value||a.title||x[a.type]||"";var j=e(a);if(j)return o(j,b,!0)}return""}function c(a,b,c){return!b&&a.hasAttribute("aria-labelledby")?u.sanitize(s.idrefs(a,"aria-labelledby").map(function(b){return a===b&&q.pop(),o(b,!0,a!==b)}).join(" ")):c&&l(a)||!a.hasAttribute("aria-label")?"":u.sanitize(a.getAttribute("aria-label"))}function d(a,b,c){for(var d,e=a.childNodes,f="",g=0;g<e.length;g++)d=e[g],3===d.nodeType?f+=d.textContent:1===d.nodeType&&(-1===z.indexOf(d.nodeName.toLowerCase())&&(f+=" "),f+=o(e[g],b,c));return f}function o(a,e,f){"use strict";var g="";if(null===a||!s.isVisible(a,!0)||-1!==q.indexOf(a))return"";q.push(a);var h=a.getAttribute("role");return g+=c(a,e,f),n(g)?g:(g=b(a,e,f),n(g)?g:f&&(g+=j(a),n(g))?g:i(a)||h&&-1===p.getRolesWithNameFromContents().indexOf(h)||(g=d(a,e,f),!n(g))?a.hasAttribute("title")?a.getAttribute("title"):"":g)}var q=[];return u.sanitize(o(a))},u.label=function(a){var c,d;return(d=p.label(a))?d:a.id&&(c=b.querySelector('label[for="'+v.escapeSelector(a.id)+'"]'),d=c&&u.visible(c,!0))?d:(c=s.findUp(a,"label"),d=c&&u.visible(c,!0),d?d:null)},u.sanitize=function(a){"use strict";return a.replace(/\r\n/g,"\n").replace(/\u00A0/g," ").replace(/[\s]{2,}/g," ").trim()},u.visible=function(a,b,c){"use strict";var d,e,f,g=a.childNodes,h=g.length,i="";for(d=0;h>d;d++)e=g[d],3===e.nodeType?(f=e.nodeValue,f&&s.isVisible(a,b)&&(i+=e.nodeValue)):c||(i+=u.visible(e,b));return u.sanitize(i)},v.toArray=function(a){"use strict";return Array.prototype.slice.call(a)},v.tokenList=function(a){"use strict";return a.trim().replace(/\s{2,}/g," ").split(" ")},o}()}),S.version="1.1.1"}(window,window.document);