<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ui="https://github.com/bordertech/wcomponents/namespace/ui/v1.0"
                xmlns:html="http://www.w3.org/1999/xhtml"
                version="2.0"
                exclude-result-prefixes="xsl ui html">
   <xsl:output encoding="UTF-8"
               indent="no"
               method="html"
               doctype-system="about:legacy-compat"
               omit-xml-declaration="yes"/>
   <xsl:strip-space elements="*"/>
   <xsl:param name="isDebug" select="1"/>
   <xsl:param name="xslPath"
              select="substring-before(replace(substring-after(//processing-instruction('xml-stylesheet'), 'href=&#34;'), '&amp;amp;', '&amp;'), '&#34;')"/>
   <xsl:variable name="resourceRoot">
      <xsl:value-of select="substring-before($xslPath, 'xslt')"/>
   </xsl:variable>
   <xsl:variable name="cacheBuster">
      <xsl:value-of select="substring-after($xslPath, '?')"/>
   </xsl:variable>
   <xsl:template match="ui:root">
      <xsl:variable name="scriptDir">
         <xsl:choose>
            <xsl:when test="number($isDebug) eq 1">
               <xsl:text>scripts_debug</xsl:text>
            </xsl:when>
            <xsl:otherwise>
               <xsl:text>scripts</xsl:text>
            </xsl:otherwise>
         </xsl:choose>
      </xsl:variable>
      <xsl:variable name="registeredComponents">
         <xsl:call-template name="registrationScripts"/>
      </xsl:variable>
      <html lang="{@lang}">
         <head>
            <xsl:choose>
               <xsl:when test="ui:application/@icon">
                  <xsl:call-template name="faviconHelper">
                     <xsl:with-param name="href">
                        <xsl:value-of select="ui:application[@icon][1]/@icon"/>
                     </xsl:with-param>
                  </xsl:call-template>
               </xsl:when>
               <xsl:when test="//html:link[@rel eq 'shortcut icon' or @rel eq 'icon']">
                  <xsl:apply-templates select="//html:link[contains(@rel, 'icon')][1]"/>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:call-template name="faviconHelper">
                     <xsl:with-param name="href" select="concat($resourceRoot, 'resource/favicon.ico')"/>
                  </xsl:call-template>
               </xsl:otherwise>
            </xsl:choose>
            <meta name="format-detection" content="telephone=no"/>
            <meta name="viewport" content="initial-scale=1"/>
            <title>
               <xsl:value-of select="@title"/>
            </title>
            <xsl:variable name="mainCssUrl">
               <xsl:call-template name="cssUrl">
                  <xsl:with-param name="filename" select="'wc'"/>
               </xsl:call-template>
            </xsl:variable>
            <link type="text/css"
                  rel="stylesheet"
                  id="wc_css_screen"
                  data-wc-loader="style"
                  href="{$mainCssUrl}"
                  media="screen"/>
            <xsl:if test="$isDebug = 1">
               <xsl:variable name="debugCssUrl">
                  <xsl:call-template name="cssUrl">
                     <xsl:with-param name="filename" select="'wcdebug'"/>
                  </xsl:call-template>
               </xsl:variable>
               <link type="text/css"
                     rel="stylesheet"
                     href="{$debugCssUrl}"
                     media="screen"
                     data-wc-loader="style"/>
            </xsl:if>
            <link type="text/css"
                  rel="stylesheet"
                  href="{concat($resourceRoot, 'resource/fontawesome/css/font-awesome.min.css')}"
                  media="screen"/>
            <xsl:call-template name="addOldIECSS"/>
            <xsl:variable name="wcScriptDir" select="concat($scriptDir, '/wc')"/>
            <xsl:variable name="libScriptDir" select="concat($scriptDir, '/lib')"/>
            <script type="text/javascript">
               <xsl:text>(function(){
	var wcconfig, timing,
		config = {
				paths: {
					wc: "</xsl:text>
               <xsl:value-of select="$wcScriptDir"/>
               <xsl:text>",
					lib: "</xsl:text>
               <xsl:value-of select="$libScriptDir"/>
               <xsl:text>",
					"lib/sprintf": "</xsl:text>
               <xsl:value-of select="$libScriptDir"/>
               <xsl:text>/sprintf.min",
					"tinyMCE": "</xsl:text>
               <xsl:value-of select="$libScriptDir"/>
               <xsl:text>/tinymce/tinymce.min",
					Promise: "</xsl:text>
               <xsl:value-of select="$libScriptDir"/>
               <xsl:text>/Promise",
					ccv: "</xsl:text>
               <xsl:value-of select="$libScriptDir"/>
               <xsl:text>/ccv",
					face: "</xsl:text>
               <xsl:value-of select="$libScriptDir"/>
               <xsl:text>/face",
					getUserMedia: "</xsl:text>
               <xsl:value-of select="$libScriptDir"/>
               <xsl:text>/getusermedia-js/getUserMedia.min",
					axs: "</xsl:text>
               <xsl:value-of select="$libScriptDir"/>
               <xsl:text>/axs_testing",
					axe: "</xsl:text>
               <xsl:value-of select="$libScriptDir"/>
               <xsl:text>/axe.min"
				},
				shim: {
					tinyMCE: {
						exports: "tinyMCE",
						init: function () {
							this.tinyMCE.DOM.events.domLoaded = true;
							return this.tinyMCE;
						}},
					ccv: {exports: "ccv"},
					face: {exports: "cascade"},
					getUserMedia: {exports: "getUserMedia"},
					axs: {exports: "axs"},
					axe: {exports: "axe"}
				},
				deps:[],

			</xsl:text>
               <xsl:value-of select="concat('baseUrl:&#34;', normalize-space($resourceRoot), '&#34;,&#xA;')"/>
               <xsl:value-of select="concat('urlArgs:&#34;', $cacheBuster, '&#34;&#xA;')"/>
               <xsl:text>};
wcconfig = {"wc/loader/resource": {</xsl:text>
               <xsl:value-of select="concat('resourceBaseUrl:&#34;', normalize-space($resourceRoot), 'resource/&#34;,&#xA;')"/>
               <xsl:value-of select="concat('cachebuster:&#34;', $cacheBuster, '&#34;')"/>
               <xsl:text>}
};
</xsl:text>
               <xsl:text>
	try{
		timing = {};
		timing[document.readyState] = (new Date()).getTime();
		document.onreadystatechange = function(){
				timing[document.readyState] = (new Date()).getTime();
				if(window.requirejs &amp;&amp; window.requirejs.config) window.requirejs.config({"config":{"wc/compat/navigationTiming":{"timing": timing}}});
			};
		wcconfig["wc/compat/navigationTiming"] = {"timing": timing};
		wcconfig["wc/config"] = { "dehydrated": JSON.stringify(wcconfig) };
	}
	catch(ex){}
	config.config = wcconfig;
	if(window.requirejs) window.requirejs.config(config);
	else require = config;
})();</xsl:text>
            </script>
            <script type="text/javascript"
                    src="{concat($resourceRoot, $scriptDir, '/lib/require.js?', $cacheBuster)}"/>
            <script type="text/javascript" class="registrationScripts">
               <xsl:text>require(["wc/compat/compat!"], function(){</xsl:text>
               <xsl:text>require(["wc/common"], function(){</xsl:text>
               <xsl:if test="$registeredComponents ne ''">
                  <xsl:value-of select="$registeredComponents"/>
               </xsl:if>
               <xsl:text>require(["wc/loader/style"],function(s){s.load();</xsl:text>
               <xsl:apply-templates select="ui:application/ui:css" mode="inHead"/>
               <xsl:apply-templates select=".//html:link[@rel eq 'stylesheet']" mode="inHead"/>
               <xsl:text>});</xsl:text>
               <xsl:text>});</xsl:text>
               <xsl:text>});</xsl:text>
            </script>
            <xsl:apply-templates select="ui:application/ui:js" mode="inHead"/>
            <xsl:apply-templates select=".//html:base | .//html:link[not(contains(@rel, 'icon') or @rel eq 'stylesheet')] | .//html:meta"
                                 mode="inHead"/>
         </head>
         <xsl:variable name="domready">
            <xsl:choose>
               <xsl:when test="$registeredComponents = ''">true</xsl:when>
               <xsl:otherwise>false</xsl:otherwise>
            </xsl:choose>
         </xsl:variable>
         <body data-wc-domready="{$domready}">
            <noscript>
               <p>You must have JavaScript enabled to use this application.</p>
            </noscript>
            <xsl:apply-templates>
               <xsl:with-param name="nojs">
                  <xsl:choose>
                     <xsl:when test="$registeredComponents ne ''">
                        <xsl:number value="0"/>
                     </xsl:when>
                     <xsl:otherwise>
                        <xsl:number value="1"/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:with-param>
            </xsl:apply-templates>
         </body>
      </html>
   </xsl:template>
   <xsl:template match="ui:ajaxresponse">
      <xsl:choose>
         <xsl:when test="ui:ajaxtarget/node()[not(self::ui:file)]">
            <div class="wc-ajaxresponse">
               <xsl:if test="@defaultFocusId">
                  <xsl:attribute name="data-focusid">
                     <xsl:value-of select="@defaultFocusId"/>
                  </xsl:attribute>
               </xsl:if>
               <xsl:apply-templates select="*"/>
            </div>
         </xsl:when>
         <xsl:otherwise>
            <html lang="en">
               <head>
                  <title>
                     <xsl:text>Pseudo AJAX iframe</xsl:text>
                  </title>
               </head>
               <body>
                  <xsl:apply-templates mode="pseudoAjax"/>
               </body>
            </html>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xsl:template match="ui:ajaxtarget">
      <div class="wc-ajaxtarget" data-id="{@id}" data-action="{@action}">
         <xsl:apply-templates/>
         <xsl:call-template name="registrationScripts"/>
      </div>
   </xsl:template>
   <xsl:template match="    comment() | ui:comment | html:link | html:base | html:meta |    html:form | ui:additionalParameters | ui:analytic | ui:tracking | ui:debugInfo |    ui:debug"/>
   <xsl:template match="*">
      <xsl:element name="{local-name()}">
         <xsl:apply-templates select="@*"/>
         <xsl:apply-templates/>
      </xsl:element>
   </xsl:template>
   <xsl:template match="@*">
      <xsl:copy/>
   </xsl:template>
   <xsl:template match="text()">
      <xsl:value-of select="."/>
   </xsl:template>
   <xsl:template match="html:link[ancestor::ui:ajaxtarget]">
      <xsl:choose>
         <xsl:when test="@rel = 'stylesheet'">
            <script type="text/javascript">
               <xsl:text>require(["wc/loader/style"],function(s){s.add("</xsl:text>
               <xsl:value-of select="@href"/>
               <xsl:text>","</xsl:text>
               <xsl:if test="@media">
                  <xsl:value-of select="@media"/>
               </xsl:if>
               <xsl:text>", true);});</xsl:text>
            </script>
         </xsl:when>
         <xsl:otherwise>
            <xsl:copy-of select="."/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xsl:template match="html:input | html:img | html:br | html:hr">
      <xsl:element name="{local-name(.)}">
         <xsl:apply-templates select="@*"/>
      </xsl:element>
   </xsl:template>
   <xsl:template match="ui:ajaxtrigger"/>
   <xsl:template match="ui:ajaxtargetid">
      <xsl:text>"</xsl:text>
      <xsl:value-of select="@targetId"/>
      <xsl:text>"</xsl:text>
      <xsl:if test="position() ne last()">
         <xsl:text>,</xsl:text>
      </xsl:if>
   </xsl:template>
   <xsl:template match="ui:checkboxselect[@readOnly]">
      <xsl:variable name="layoutClass">
         <xsl:if test="@layout">
            <xsl:value-of select="concat(' wc-layout-', @layout)"/>
         </xsl:if>
      </xsl:variable>
      <span id="{@id}"
            data-wc-component="checkboxselect"
            class="{normalize-space(concat('wc-checkboxselect wc-checkableselect ', @class, $layoutClass))}">
         <xsl:if test="@hidden">
            <xsl:attribute name="hidden">
               <xsl:text>hidden</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:choose>
            <xsl:when test="@layoutColumnCount and number(@layoutColumnCount) gt 1">
               <span data-wc-colcount="{@layoutColumnCount}">
                  <xsl:apply-templates mode="checkbleGroupRO" select="ui:option"/>
               </span>
            </xsl:when>
            <xsl:otherwise>
               <xsl:apply-templates mode="checkbleGroupRO" select="ui:option"/>
            </xsl:otherwise>
         </xsl:choose>
      </span>
   </xsl:template>
   <xsl:template match="ui:radiobuttonselect[@readOnly]">
      <xsl:variable name="layoutClass">
         <xsl:if test="@layout">
            <xsl:value-of select="concat(' wc-layout-', @layout)"/>
         </xsl:if>
      </xsl:variable>
      <span id="{@id}"
            data-wc-component="radiobuttonselect"
            class="{normalize-space(concat('wc-radiobuttonselect wc-checkableselect ', @class, $layoutClass))}">
         <xsl:if test="@hidden">
            <xsl:attribute name="hidden">
               <xsl:text>hidden</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:apply-templates mode="checkbleGroupRO" select="ui:option"/>
      </span>
   </xsl:template>
   <xsl:template match="ui:checkboxselect">
      <xsl:variable name="additional">
         <xsl:if test="@frameless">
            <xsl:text> wc_noborder</xsl:text>
         </xsl:if>
         <xsl:if test="@required">
            <xsl:text> wc_req</xsl:text>
         </xsl:if>
         <xsl:if test="@layout">
            <xsl:value-of select="concat(' wc-layout-', @layout)"/>
         </xsl:if>
      </xsl:variable>
      <fieldset id="{@id}"
                class="{normalize-space(concat('wc-checkboxselect wc-checkableselect ', $additional))}">
         <xsl:if test="@hidden">
            <xsl:attribute name="hidden">
               <xsl:text>hidden</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="@toolTip">
            <xsl:attribute name="title">
               <xsl:value-of select="@toolTip"/>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="@accessibleText">
            <xsl:attribute name="aria-label">
               <xsl:value-of select="@accessibleText"/>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="ui:fieldindicator">
            <xsl:if test="ui:fieldindicator[@id]">
               <xsl:attribute name="aria-describedby">
                  <xsl:value-of select="ui:fieldindicator/@id"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="ui:fieldindicator[@type='error']">
               <xsl:attribute name="aria-invalid">
                  <xsl:text>true</xsl:text>
               </xsl:attribute>
            </xsl:if>
         </xsl:if>
         <xsl:if test="ui:option">
            <xsl:if test="@min">
               <xsl:attribute name="data-wc-min">
                  <xsl:value-of select="@min"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@max">
               <xsl:attribute name="data-wc-max">
                  <xsl:value-of select="@max"/>
               </xsl:attribute>
            </xsl:if>
            <div>
               <xsl:if test="@layoutColumnCount and number(@layoutColumnCount) gt 1">
                  <xsl:attribute name="data-wc-colcount">
                     <xsl:value-of select="@layoutColumnCount"/>
                  </xsl:attribute>
               </xsl:if>
               <xsl:apply-templates mode="checkbleGroup" select="ui:option">
                  <xsl:with-param name="type" select="'checkbox'"/>
               </xsl:apply-templates>
            </div>
         </xsl:if>
         <xsl:apply-templates select="ui:fieldindicator"/>
         <xsl:element name="input">
            <xsl:attribute name="type">
               <xsl:text>hidden</xsl:text>
            </xsl:attribute>
            <xsl:attribute name="name">
               <xsl:value-of select="concat(@id, '-h')"/>
            </xsl:attribute>
            <xsl:attribute name="value">
               <xsl:text>x</xsl:text>
            </xsl:attribute>
            <xsl:if test="@disabled">
               <xsl:attribute name="disabled">
                  <xsl:text>disabled</xsl:text>
               </xsl:attribute>
            </xsl:if>
         </xsl:element>
      </fieldset>
   </xsl:template>
   <xsl:template match="ui:radiobuttonselect">
      <xsl:variable name="additional">
         <xsl:value-of select="@class"/>
         <xsl:if test="@frameless">
            <xsl:text> wc_noborder</xsl:text>
         </xsl:if>
         <xsl:if test="@required">
            <xsl:text> wc_req</xsl:text>
         </xsl:if>
         <xsl:if test="@layout">
            <xsl:value-of select="concat(' wc-layout-', @layout)"/>
         </xsl:if>
      </xsl:variable>
      <fieldset id="{@id}"
                class="{normalize-space(concat('wc-radiobuttonselect wc-checkableselect ', $additional))}">
         <xsl:if test="@hidden">
            <xsl:attribute name="hidden">
               <xsl:text>hidden</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="@toolTip">
            <xsl:attribute name="title">
               <xsl:value-of select="@toolTip"/>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="@accessibleText">
            <xsl:attribute name="aria-label">
               <xsl:value-of select="@accessibleText"/>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="ui:fieldindicator">
            <xsl:if test="ui:fieldindicator[@id]">
               <xsl:attribute name="aria-describedby">
                  <xsl:value-of select="ui:fieldindicator/@id"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="ui:fieldindicator[@type='error']">
               <xsl:attribute name="aria-invalid">
                  <xsl:text>true</xsl:text>
               </xsl:attribute>
            </xsl:if>
         </xsl:if>
         <xsl:if test="ui:option">
            <div>
               <xsl:if test="@layoutColumnCount and number(@layoutColumnCount) gt 1">
                  <xsl:attribute name="data-wc-colcount">
                     <xsl:value-of select="@layoutColumnCount"/>
                  </xsl:attribute>
               </xsl:if>
               <xsl:apply-templates mode="checkbleGroup" select="ui:option">
                  <xsl:with-param name="type" select="'radio'"/>
               </xsl:apply-templates>
            </div>
         </xsl:if>
         <xsl:apply-templates select="ui:fieldindicator"/>
         <xsl:element name="input">
            <xsl:attribute name="type">
               <xsl:text>hidden</xsl:text>
            </xsl:attribute>
            <xsl:attribute name="name">
               <xsl:value-of select="concat(@id, '-h')"/>
            </xsl:attribute>
            <xsl:attribute name="value">
               <xsl:text>x</xsl:text>
            </xsl:attribute>
            <xsl:if test="@disabled">
               <xsl:attribute name="disabled">
                  <xsl:text>disabled</xsl:text>
               </xsl:attribute>
            </xsl:if>
         </xsl:element>
      </fieldset>
   </xsl:template>
   <xsl:template match="ui:panel">
      <xsl:param name="type" select="@type"/>
      <xsl:variable name="containerElement">
         <xsl:choose>
            <xsl:when test="$type eq 'chrome' or $type eq 'action'">
               <xsl:text>section</xsl:text>
            </xsl:when>
            <xsl:when test="$type eq 'header' or $type eq 'footer'">
               <xsl:value-of select="$type"/>
            </xsl:when>
            <xsl:otherwise>
               <xsl:text>div</xsl:text>
            </xsl:otherwise>
         </xsl:choose>
      </xsl:variable>
      <xsl:variable name="additionalClass">
         <xsl:value-of select="@class"/>
         <xsl:choose>
            <xsl:when test="(@mode eq 'lazy' and @hidden)">
               <xsl:text> wc_magic</xsl:text>
            </xsl:when>
            <xsl:when test="@mode eq 'dynamic'">
               <xsl:text> wc_magic wc_dynamic</xsl:text>
            </xsl:when>
         </xsl:choose>
         <xsl:if test="@type">
            <xsl:value-of select="concat(' wc-panel-type-', @type)"/>
         </xsl:if>
         <xsl:apply-templates select="ui:margin" mode="asclass"/>
      </xsl:variable>
      <xsl:element name="{$containerElement}">
         <xsl:attribute name="id">
            <xsl:value-of select="@id"/>
         </xsl:attribute>
         <xsl:attribute name="class">
            <xsl:value-of select="normalize-space(concat('wc-panel ', $additionalClass))"/>
         </xsl:attribute>
         <xsl:if test="@buttonId">
            <xsl:attribute name="data-wc-submit">
               <xsl:value-of select="@buttonId"/>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="$type eq 'header'">
            <xsl:attribute name="role">
               <xsl:text>banner</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="@mode">
            <xsl:attribute name="aria-live">
               <xsl:text>polite</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="@title and @accessKey">
            <xsl:if test="@title">
               <xsl:attribute name="data-wc-title">
                  <xsl:value-of select="@title"/>
               </xsl:attribute>
               <xsl:if test="@accessKey">
                  <xsl:attribute name="accesskey">
                     <xsl:value-of select="@accessKey"/>
                  </xsl:attribute>
               </xsl:if>
            </xsl:if>
         </xsl:if>
         <xsl:if test="@hidden">
            <xsl:attribute name="hidden">
               <xsl:text>hidden</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="*[not(self::ui:margin)]/node() or not(@mode eq 'eager')">
            <xsl:if test="(@type eq 'chrome' or @type eq 'action')">
               <h1>
                  <xsl:value-of select="normalize-space(@title)"/>
               </h1>
            </xsl:if>
            <xsl:apply-templates/>
         </xsl:if>
      </xsl:element>
   </xsl:template>
   <xsl:template match="ui:borderlayout">
      <xsl:variable name="vgap">
         <xsl:if test="@vgap">
            <xsl:call-template name="gapClass">
               <xsl:with-param name="gap" select="@vgap"/>
               <xsl:with-param name="isVGap" select="1"/>
            </xsl:call-template>
         </xsl:if>
      </xsl:variable>
      <div>
         <xsl:attribute name="class">
            <xsl:value-of select="normalize-space(concat('wc-borderlayout ', $vgap))"/>
         </xsl:attribute>
         <xsl:apply-templates select="ui:north"/>
         <xsl:if test="count(ui:west|ui:center|ui:east) gt 0">
            <div>
               <xsl:attribute name="class">
                  <xsl:text>wc_bl_mid</xsl:text>
                  <xsl:if test="@hgap">
                     <xsl:call-template name="gapClass">
                        <xsl:with-param name="gap" select="@hgap"/>
                     </xsl:call-template>
                  </xsl:if>
               </xsl:attribute>
               <xsl:apply-templates select="ui:west"/>
               <xsl:apply-templates select="ui:center"/>
               <xsl:apply-templates select="ui:east"/>
            </div>
         </xsl:if>
         <xsl:apply-templates select="ui:south"/>
      </div>
   </xsl:template>
   <xsl:template match="ui:north|ui:south">
      <div class="wc-{local-name()}">
         <xsl:apply-templates/>
      </div>
   </xsl:template>
   <xsl:template match="ui:east|ui:west|ui:center">
      <div>
         <xsl:attribute name="class">
            <xsl:value-of select="concat('wc-',local-name(.))"/>
            <xsl:variable name="colCount" select="count(../ui:west|../ui:east|../ui:center)"/>
            <xsl:variable name="classPrefix">
               <xsl:text> wc_bl_mid</xsl:text>
            </xsl:variable>
            <xsl:choose>
               <xsl:when test="number($colCount) eq 1">
                  <xsl:value-of select="concat($classPrefix, '100')"/>
               </xsl:when>
               <xsl:when test="(self::ui:west or self::ui:east) and ../ui:center">
                  <xsl:value-of select="concat($classPrefix, '25')"/>
               </xsl:when>
               <xsl:when test="(self::ui:east and (../ui:west)) or (self::ui:west and (../ui:east)) or (number($colCount) eq 3 and self::ui:center)">
                  <xsl:value-of select="concat($classPrefix, '50')"/>
               </xsl:when>
               <xsl:when test="self::ui:center">
                  <xsl:value-of select="concat($classPrefix, '75')"/>
               </xsl:when>
            </xsl:choose>
         </xsl:attribute>
         <xsl:apply-templates/>
      </div>
   </xsl:template>
   <xsl:template match="ui:columnlayout">
      <xsl:variable name="additional">
         <xsl:if test="@vgap">
            <xsl:call-template name="gapClass">
               <xsl:with-param name="gap" select="@vgap"/>
               <xsl:with-param name="isVGap" select="1"/>
            </xsl:call-template>
         </xsl:if>
         <xsl:if test="@align">
            <xsl:value-of select="concat(' wc-align-', @align)"/>
         </xsl:if>
      </xsl:variable>
      <div>
         <xsl:attribute name="class">
            <xsl:value-of select="normalize-space(concat('wc-columnlayout ', $additional))"/>
         </xsl:attribute>
         <xsl:variable name="width">
            <xsl:choose>
               <xsl:when test="ui:column[1]/@width">
                  <xsl:value-of select="ui:column[1]/@width"/>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:number value="0"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:variable>
         <xsl:variable name="cols" select="count(ui:column)"/>
         <xsl:choose>
            <xsl:when test="number($cols) eq 1">
               <xsl:apply-templates select="ui:cell" mode="clRow">
                  <xsl:with-param name="align" select="ui:column[1]/@align"/>
                  <xsl:with-param name="width" select="$width"/>
                  <xsl:with-param name="cols" select="$cols"/>
               </xsl:apply-templates>
            </xsl:when>
            <xsl:otherwise>
               <xsl:apply-templates select="ui:cell[position() mod number($cols) eq 1]" mode="clRow">
                  <xsl:with-param name="align" select="ui:column[1]/@align"/>
                  <xsl:with-param name="width" select="$width"/>
                  <xsl:with-param name="cols" select="$cols"/>
               </xsl:apply-templates>
            </xsl:otherwise>
         </xsl:choose>
      </div>
   </xsl:template>
   <xsl:template match="ui:flowlayout">
      <xsl:variable name="class">
         <xsl:if test="@gap">
            <xsl:call-template name="gapClass">
               <xsl:with-param name="gap" select="@gap"/>
               <xsl:with-param name="isVGap">
                  <xsl:choose>
                     <xsl:when test="@align and @align eq 'vertical'">
                        <xsl:number value="1"/>
                     </xsl:when>
                     <xsl:otherwise>
                        <xsl:number value="0"/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:with-param>
            </xsl:call-template>
         </xsl:if>
         <xsl:if test="@align">
            <xsl:value-of select="concat(' wc-align-', @align)"/>
         </xsl:if>
         <xsl:if test="@valign">
            <xsl:value-of select="concat(' wc_fl_', @valign)"/>
         </xsl:if>
      </xsl:variable>
      <div class="{normalize-space(concat('wc-flowlayout ', $class))}">
         <xsl:apply-templates mode="fl" select="ui:cell[node()]"/>
      </div>
   </xsl:template>
   <xsl:template match="ui:gridlayout">
      <xsl:if test="ui:cell">
         <xsl:variable name="cols" select="@cols"/>
         <xsl:variable name="rows" select="@rows"/>
         <xsl:variable name="useCols">
            <xsl:choose>
               <xsl:when test="number($cols) gt 0">
                  <xsl:number value="number($cols)"/>
               </xsl:when>
               <xsl:when test="number($rows) gt 0">
                  <xsl:value-of select="ceiling(count(ui:cell) div number($rows))"/>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:number value="1"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:variable>
         <xsl:variable name="vgap">
            <xsl:if test="@vgap">
               <xsl:call-template name="gapClass">
                  <xsl:with-param name="gap" select="@vgap"/>
                  <xsl:with-param name="isVGap" select="1"/>
               </xsl:call-template>
            </xsl:if>
         </xsl:variable>
         <xsl:variable name="additional">
            <xsl:if test="number($useCols) le 12">
               <xsl:value-of select="concat('wc-gridlayout-col-', $useCols)"/>
            </xsl:if>
            <xsl:value-of select="$vgap"/>
         </xsl:variable>
         <div class="{normalize-space(concat('wc-gridlayout ', $additional))}">
            <xsl:choose>
               <xsl:when test="number($useCols) eq 1">
                  <xsl:apply-templates mode="gl" select="ui:cell"/>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:apply-templates mode="gl" select="ui:cell[(position() mod number($useCols)) eq 1]">
                     <xsl:with-param name="cols" select="number($useCols)"/>
                     <xsl:with-param name="colWidth">
                        <xsl:if test="number($useCols) gt 12">
                           <xsl:value-of select="format-number(1 div number($useCols), '##0.###%')"/>
                        </xsl:if>
                     </xsl:with-param>
                  </xsl:apply-templates>
               </xsl:otherwise>
            </xsl:choose>
         </div>
      </xsl:if>
   </xsl:template>
   <xsl:template match="ui:listlayout">
      <xsl:variable name="listElement">
         <xsl:choose>
            <xsl:when test="@ordered">
               <xsl:text>ol</xsl:text>
            </xsl:when>
            <xsl:otherwise>
               <xsl:text>ul</xsl:text>
            </xsl:otherwise>
         </xsl:choose>
      </xsl:variable>
      <xsl:variable name="additionalClasses">
         <xsl:if test="@gap">
            <xsl:call-template name="gapClass">
               <xsl:with-param name="gap" select="@gap"/>
               <xsl:with-param name="isVGap">
                  <xsl:choose>
                     <xsl:when test="@type eq 'flat'">
                        <xsl:number value="0"/>
                     </xsl:when>
                     <xsl:otherwise>
                        <xsl:number value="1"/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:with-param>
            </xsl:call-template>
         </xsl:if>
         <xsl:choose>
            <xsl:when test="@align">
               <xsl:value-of select="concat(' wc-align-', @align)"/>
            </xsl:when>
            <xsl:otherwise>
               <xsl:text> wc-align-left</xsl:text>
            </xsl:otherwise>
         </xsl:choose>
         <xsl:if test="@type">
            <xsl:value-of select="concat(' wc-listlayout-type-', @type)"/>
         </xsl:if>
         <xsl:choose>
            <xsl:when test="not(@separator) or @separator eq 'none'">
               <xsl:text> wc_list_nb</xsl:text>
            </xsl:when>
            <xsl:when test="not(@ordered)">
               <xsl:value-of select="concat(' wc-listlayout-separator-', @separator)"/>
            </xsl:when>
         </xsl:choose>
      </xsl:variable>
      <xsl:element name="{$listElement}">
         <xsl:attribute name="class">
            <xsl:value-of select="normalize-space(concat('wc-listlayout ', $additionalClasses))"/>
         </xsl:attribute>
         <xsl:apply-templates mode="ll"/>
      </xsl:element>
   </xsl:template>
   <xsl:template match="ui:row">
      <xsl:variable name="additional">
         <xsl:value-of select="@class"/>
         <xsl:if test="@gap">
            <xsl:call-template name="gapClass">
               <xsl:with-param name="gap" select="@gap"/>
            </xsl:call-template>
         </xsl:if>
         <xsl:if test="@align">
            <xsl:value-of select="concat(' wc-align-', @align)"/>
         </xsl:if>
         <xsl:apply-templates select="ui:margin" mode="asclass"/>
      </xsl:variable>
      <div id="{@id}" class="{normalize-space(concat('wc-row ', $additional))}">
         <xsl:apply-templates select="ui:column"/>
      </div>
   </xsl:template>
   <xsl:template match="ui:column">
      <xsl:variable name="additional">
         <xsl:value-of select="@class"/>
         <xsl:text> wc-align-</xsl:text>
         <xsl:choose>
            <xsl:when test="@align">
               <xsl:value-of select="@align"/>
            </xsl:when>
            <xsl:otherwise>
               <xsl:text>left</xsl:text>
            </xsl:otherwise>
         </xsl:choose>
         <xsl:if test="@width and number(@width) ne 0">
            <xsl:value-of select="concat(' wc_col_',@width)"/>
         </xsl:if>
         <xsl:apply-templates select="ui:margin" mode="asclass"/>
      </xsl:variable>
      <div id="{@id}" class="{normalize-space(concat('wc-column ', $additional))}">
         <xsl:apply-templates select="node()[not(self::ui:margin)]"/>
      </div>
   </xsl:template>
   <xsl:template match="ui:content">
      <xsl:param name="class" select="''"/>
      <div class="{normalize-space(concat('wc-content ', $class))}">
         <xsl:if test="@id">
            <xsl:attribute name="id">
               <xsl:value-of select="@id"/>
            </xsl:attribute>
         </xsl:if>
         <xsl:apply-templates/>
      </div>
   </xsl:template>
   <xsl:template match="ui:fileupload[@readOnly]">
      <span id="{@id}"
            class="{normalize-space(concat('wc-fileupload wc-ro-input ', @class))}"
            data-wc-component="fileupload">
         <xsl:if test="@hidden">
            <xsl:attribute name="hidden">
               <xsl:text>hidden</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:apply-templates/>
      </span>
   </xsl:template>
   <xsl:template match="ui:fileupload">
      <span id="{@id}"
            class="{normalize-space(concat('wc-fileupload wc-input-wrapper ', @class))}">
         <xsl:if test="@disabled">
            <xsl:attribute name="aria-disabled">
               <xsl:text>true</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="@hidden">
            <xsl:attribute name="hidden">
               <xsl:text>hidden</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:element name="input">
            <xsl:attribute name="id">
               <xsl:value-of select="concat(@id, '_input')"/>
            </xsl:attribute>
            <xsl:attribute name="type">
               <xsl:text>file</xsl:text>
            </xsl:attribute>
            <xsl:attribute name="name">
               <xsl:value-of select="@id"/>
            </xsl:attribute>
            <xsl:if test="@required">
               <xsl:attribute name="required">
                  <xsl:text>required</xsl:text>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@disabled">
               <xsl:attribute name="disabled">
                  <xsl:text>disabled</xsl:text>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@accessibleText">
               <xsl:attribute name="aria-label">
                  <xsl:value-of select="@accessibleText"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@buttonId">
               <xsl:attribute name="data-wc-submit">
                  <xsl:value-of select="@buttonId"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="ui:fieldindicator">
               <xsl:if test="ui:fieldindicator[@id]">
                  <xsl:attribute name="aria-describedby">
                     <xsl:value-of select="ui:fieldindicator/@id"/>
                  </xsl:attribute>
               </xsl:if>
               <xsl:if test="ui:fieldindicator[@type='error']">
                  <xsl:attribute name="aria-invalid">
                     <xsl:text>true</xsl:text>
                  </xsl:attribute>
               </xsl:if>
            </xsl:if>
            <xsl:if test="@toolTip">
               <xsl:attribute name="title">
                  <xsl:value-of select="@toolTip"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@acceptedMimeTypes">
               <xsl:attribute name="accept">
                  <xsl:value-of select="@acceptedMimeTypes"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@maxFileSize">
               <xsl:attribute name="data-wc-maxfilesize">
                  <xsl:value-of select="@maxFileSize"/>
               </xsl:attribute>
            </xsl:if>
         </xsl:element>
         <xsl:apply-templates select="ui:fieldindicator"/>
      </span>
   </xsl:template>
   <xsl:template match="ui:multifileupload[@readOnly]">
      <xsl:variable name="roClass">
         <xsl:if test="@ajax">
            <xsl:text> wc-ajax</xsl:text>
         </xsl:if>
      </xsl:variable>
      <xsl:choose>
         <xsl:when test="not(ui:file)">
            <span id="{@id}"
                  data-wc-component="multifileupload"
                  class="{normalize-space(concat('wc-multifileupload ', @class, $roClass))}">
               <xsl:if test="@hidden">
                  <xsl:attribute name="hidden">
                     <xsl:text>hidden</xsl:text>
                  </xsl:attribute>
               </xsl:if>
            </span>
         </xsl:when>
         <xsl:when test="not(@cols) or number(@cols) le 1 or number(@cols) ge count(ui:file)">
            <ul id="{@id}" data-wc-component="multifileupload">
               <xsl:variable name="additional">
                  <xsl:value-of select="$roClass"/>
                  <xsl:choose>
                     <xsl:when test="@cols = 0 or number(@cols) ge count(ui:file)">
                        <xsl:text> wc-listlayout-type-flat wc-hgap-sm</xsl:text>
                     </xsl:when>
                     <xsl:otherwise>
                        <xsl:text> wc-vgap-sm</xsl:text>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:variable>
               <xsl:attribute name="class">
                  <xsl:value-of select="normalize-space(concat('wc-multifileupload ', @class, $additional))"/>
               </xsl:attribute>
               <xsl:if test="@hidden">
                  <xsl:attribute name="hidden">
                     <xsl:text>hidden</xsl:text>
                  </xsl:attribute>
               </xsl:if>
               <xsl:apply-templates/>
            </ul>
         </xsl:when>
         <xsl:otherwise>
            <div id="{@id}"
                 data-wc-cols="{@cols}"
                 data-wc-component="multifileupload">
               <xsl:attribute name="class">
                  <xsl:value-of select="normalize-space(concat('wc-multifileupload ', @class, $roClass))"/>
               </xsl:attribute>
               <xsl:if test="@hidden">
                  <xsl:attribute name="hidden">
                     <xsl:text>hidden</xsl:text>
                  </xsl:attribute>
               </xsl:if>
               <xsl:if test="@toolTip">
                  <xsl:attribute name="title">
                     <xsl:value-of select="@toolTip"/>
                  </xsl:attribute>
               </xsl:if>
               <xsl:if test="@accessibleText">
                  <xsl:attribute name="aria-label">
                     <xsl:value-of select="@accessibleText"/>
                  </xsl:attribute>
               </xsl:if>
               <xsl:if test="ui:fieldindicator">
                  <xsl:if test="ui:fieldindicator[@id]">
                     <xsl:attribute name="aria-describedby">
                        <xsl:value-of select="ui:fieldindicator/@id"/>
                     </xsl:attribute>
                  </xsl:if>
                  <xsl:if test="ui:fieldindicator[@type='error']">
                     <xsl:attribute name="aria-invalid">
                        <xsl:text>true</xsl:text>
                     </xsl:attribute>
                  </xsl:if>
               </xsl:if>
               <xsl:variable name="rows" select="ceiling(count(ui:file) div number(@cols))"/>
               <div class="wc_files wc-row wc-hgap-med wc-respond">
                  <xsl:apply-templates mode="columns" select="ui:file[position() mod number($rows) eq 1]">
                     <xsl:with-param name="rows" select="$rows"/>
                  </xsl:apply-templates>
               </div>
            </div>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xsl:template match="ui:multifileupload">
      <xsl:variable name="cols">
         <xsl:choose>
            <xsl:when test="@cols">
               <xsl:number value="number(@cols)"/>
            </xsl:when>
            <xsl:otherwise>
               <xsl:number value="0"/>
            </xsl:otherwise>
         </xsl:choose>
      </xsl:variable>
      <xsl:variable name="additional">
         <xsl:value-of select="@class"/>
         <xsl:if test="@required">
            <xsl:text> wc_req</xsl:text>
         </xsl:if>
         <xsl:if test="@ajax">
            <xsl:text> wc-ajax</xsl:text>
         </xsl:if>
      </xsl:variable>
      <fieldset id="{@id}"
                data-wc-cols="{$cols}"
                class="{normalize-space(concat('wc-multifileupload wc_noborder ', $additional))}">
         <xsl:if test="@hidden">
            <xsl:attribute name="hidden">
               <xsl:text>hidden</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="@toolTip">
            <xsl:attribute name="title">
               <xsl:value-of select="@toolTip"/>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="@accessibleText">
            <xsl:attribute name="aria-label">
               <xsl:value-of select="@accessibleText"/>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="ui:fieldindicator">
            <xsl:if test="ui:fieldindicator[@id]">
               <xsl:attribute name="aria-describedby">
                  <xsl:value-of select="ui:fieldindicator/@id"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="ui:fieldindicator[@type='error']">
               <xsl:attribute name="aria-invalid">
                  <xsl:text>true</xsl:text>
               </xsl:attribute>
            </xsl:if>
         </xsl:if>
         <label class="wc-off" for="{concat(@id,'_input')}">
            <xsl:text>{{#i18n}}file_inputLabel{{/i18n}}</xsl:text>
         </label>
         <xsl:element name="input">
            <xsl:attribute name="id">
               <xsl:value-of select="concat(@id, '_input')"/>
            </xsl:attribute>
            <xsl:attribute name="type">
               <xsl:text>file</xsl:text>
            </xsl:attribute>
            <xsl:attribute name="name">
               <xsl:value-of select="@id"/>
            </xsl:attribute>
            <xsl:if test="@toolTip">
               <xsl:attribute name="title">
                  <xsl:value-of select="@toolTip"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@disabled">
               <xsl:attribute name="disabled">
                  <xsl:text>disabled</xsl:text>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@accessibleText">
               <xsl:attribute name="aria-label">
                  <xsl:value-of select="@accessibleText"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@buttonId">
               <xsl:attribute name="data-wc-submit">
                  <xsl:value-of select="@buttonId"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="ui:fieldindicator">
               <xsl:if test="ui:fieldindicator[@id]">
                  <xsl:attribute name="aria-describedby">
                     <xsl:value-of select="ui:fieldindicator/@id"/>
                  </xsl:attribute>
               </xsl:if>
               <xsl:if test="ui:fieldindicator[@type='error']">
                  <xsl:attribute name="aria-invalid">
                     <xsl:text>true</xsl:text>
                  </xsl:attribute>
               </xsl:if>
            </xsl:if>
            <xsl:if test="@submitOnChange">
               <xsl:attribute name="class">
                  <xsl:text>wc_soc</xsl:text>
               </xsl:attribute>
            </xsl:if>
            <xsl:attribute name="multiple">
               <xsl:text>multiple</xsl:text>
            </xsl:attribute>
            <xsl:attribute name="data-dropzone">
               <xsl:choose>
                  <xsl:when test="@dropzone">
                     <xsl:value-of select="@dropzone"/>
                  </xsl:when>
                  <xsl:otherwise>
                     <xsl:value-of select="@id"/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:attribute>
            <xsl:if test="@acceptedMimeTypes">
               <xsl:attribute name="accept">
                  <xsl:value-of select="@acceptedMimeTypes"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@maxFileSize">
               <xsl:attribute name="data-wc-maxfilesize">
                  <xsl:value-of select="@maxFileSize"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@editor">
               <xsl:attribute name="data-wc-editor">
                  <xsl:value-of select="@editor"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@maxFiles">
               <xsl:attribute name="data-wc-maxfiles">
                  <xsl:value-of select="@maxFiles"/>
               </xsl:attribute>
            </xsl:if>
         </xsl:element>
         <xsl:if test="@camera">
            <button class="wc_btn_camera wc_btn_icon wc-invite"
                    data-wc-editor="{@editor}"
                    data-wc-selector="{@id}"
                    type="button">
               <span class="wc-off">Camera</span>
               <i aria-hidden="true" class="fa fa-video-camera"/>
            </button>
         </xsl:if>
         <xsl:if test="ui:file">
            <xsl:choose>
               <xsl:when test="number($cols) gt 1">
                  <div class="wc_files wc-row wc-hgap-med wc-respond wc-margin-n-sm">
                     <xsl:variable name="numFiles" select="count(ui:file)"/>
                     <xsl:choose>
                        <xsl:when test="number($cols) ge number($numFiles)">
                           <xsl:apply-templates mode="columns" select="ui:file[1]">
                              <xsl:with-param name="rows" select="number($numFiles)"/>
                           </xsl:apply-templates>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:variable name="rows" select="ceiling(number($numFiles) div number($cols))"/>
                           <xsl:apply-templates mode="columns" select="ui:file[position() mod number($rows) eq 1]">
                              <xsl:with-param name="rows" select="$rows"/>
                           </xsl:apply-templates>
                        </xsl:otherwise>
                     </xsl:choose>
                  </div>
               </xsl:when>
               <xsl:otherwise>
                  <ul>
                     <xsl:attribute name="class">
                        <xsl:text>wc_list_nb wc_filelist wc-margin-n-sm</xsl:text>
                        <xsl:choose>
                           <xsl:when test="@cols = 0">
                              <xsl:text> wc-listlayout-type-flat</xsl:text>
                           </xsl:when>
                           <xsl:otherwise>
                              <xsl:text> wc-vgap-sm</xsl:text>
                           </xsl:otherwise>
                        </xsl:choose>
                     </xsl:attribute>
                     <xsl:apply-templates select="ui:file"/>
                  </ul>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:if>
         <xsl:apply-templates select="ui:fieldindicator"/>
      </fieldset>
   </xsl:template>
   <xsl:template match="ui:file">
      <xsl:call-template name="fileInList"/>
   </xsl:template>
   <xsl:template match="ui:phonenumberfield[@readOnly]">
      <xsl:variable name="localClass"
                    select="normalize-space(concat('wc-phonenumberfield wc-ro-input ', @class))"/>
      <xsl:choose>
         <xsl:when test="text()">
            <xsl:variable name="href">
               <xsl:value-of select="text()"/>
            </xsl:variable>
            <a href="{concat('tel:', $href)}"
               id="{@id}"
               class="{$localClass}"
               data-wc-component="phonenumberfield">
               <xsl:if test="@hidden">
                  <xsl:attribute name="hidden">
                     <xsl:text>hidden</xsl:text>
                  </xsl:attribute>
               </xsl:if>
               <xsl:value-of select="text()"/>
            </a>
         </xsl:when>
         <xsl:otherwise>
            <span id="{@id}"
                  class="{$localClass}"
                  data-wc-component="phonenumberfield">
               <xsl:if test="@hidden">
                  <xsl:attribute name="hidden">
                     <xsl:text>hidden</xsl:text>
                  </xsl:attribute>
               </xsl:if>
            </span>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xsl:template match="ui:textfield[@readOnly] | ui:passwordfield[@readOnly]">
      <span id="{@id}"
            class="{normalize-space(concat('wc-', local-name(), ' wc-ro-input ', @class))}"
            data-wc-component="{local-name()}">
         <xsl:if test="@hidden">
            <xsl:attribute name="hidden">
               <xsl:text>hidden</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:apply-templates/>
      </span>
   </xsl:template>
   <xsl:template match="ui:emailfield[@readOnly]">
      <xsl:variable name="localClass"
                    select="normalize-space(concat('wc-emailfield wc-ro-input ', @class))"/>
      <xsl:choose>
         <xsl:when test="text()">
            <xsl:variable name="href">
               <xsl:value-of select="text()"/>
            </xsl:variable>
            <a href="{$href}"
               id="{@id}"
               class="{$localClass}"
               data-wc-component="emailfield">
               <xsl:if test="@hidden">
                  <xsl:attribute name="hidden">
                     <xsl:text>hidden</xsl:text>
                  </xsl:attribute>
               </xsl:if>
               <xsl:value-of select="text()"/>
            </a>
         </xsl:when>
         <xsl:otherwise>
            <span id="{@id}" class="{$localClass}" data-wc-component="emailfield">
               <xsl:if test="@hidden">
                  <xsl:attribute name="hidden">
                     <xsl:text>hidden</xsl:text>
                  </xsl:attribute>
               </xsl:if>
            </span>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xsl:template match="ui:textfield | ui:phonenumberfield | ui:emailfield | ui:passwordfield">
      <span id="{@id}">
         <xsl:variable name="additional">
            <xsl:value-of select="@class"/>
            <xsl:if test="@list">
               <xsl:text> wc-combo</xsl:text>
            </xsl:if>
         </xsl:variable>
         <xsl:attribute name="class">
            <xsl:value-of select="normalize-space(concat('wc-', local-name(),' wc-input-wrapper ', $additional))"/>
         </xsl:attribute>
         <xsl:if test="@disabled">
            <xsl:attribute name="aria-disabled">
               <xsl:text>true</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="@hidden">
            <xsl:attribute name="hidden">
               <xsl:text>hidden</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="@list">
            <xsl:attribute name="role">
               <xsl:text>combobox</xsl:text>
            </xsl:attribute>
            <xsl:attribute name="aria-expanded">
               <xsl:text>false</xsl:text>
            </xsl:attribute>
            <xsl:attribute name="data-wc-suggest">
               <xsl:value-of select="@list"/>
            </xsl:attribute>
            <xsl:attribute name="aria-autocomplete">
               <xsl:text>list</xsl:text>
            </xsl:attribute>
            <xsl:if test="@toolTip">
               <xsl:attribute name="title">
                  <xsl:value-of select="@toolTip"/>
               </xsl:attribute>
            </xsl:if>
         </xsl:if>
         <xsl:element name="input">
            <xsl:attribute name="id">
               <xsl:value-of select="concat(@id, '_input')"/>
            </xsl:attribute>
            <xsl:attribute name="type">
               <xsl:choose>
                  <xsl:when test="self::ui:textfield">
                     <xsl:text>text</xsl:text>
                  </xsl:when>
                  <xsl:when test="self::ui:emailfield">
                     <xsl:text>email</xsl:text>
                  </xsl:when>
                  <xsl:when test="self::ui:passwordfield">
                     <xsl:text>password</xsl:text>
                  </xsl:when>
                  <xsl:otherwise>
                     <xsl:text>tel</xsl:text>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:attribute>
            <xsl:attribute name="name">
               <xsl:value-of select="@id"/>
            </xsl:attribute>
            <xsl:attribute name="value">
               <xsl:value-of select="text()"/>
            </xsl:attribute>
            <xsl:if test="@required">
               <xsl:attribute name="required">
                  <xsl:text>required</xsl:text>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@disabled">
               <xsl:attribute name="disabled">
                  <xsl:text>disabled</xsl:text>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@accessibleText">
               <xsl:attribute name="aria-label">
                  <xsl:value-of select="@accessibleText"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@buttonId">
               <xsl:attribute name="data-wc-submit">
                  <xsl:value-of select="@buttonId"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="ui:fieldindicator">
               <xsl:if test="ui:fieldindicator[@id]">
                  <xsl:attribute name="aria-describedby">
                     <xsl:value-of select="ui:fieldindicator/@id"/>
                  </xsl:attribute>
               </xsl:if>
               <xsl:if test="ui:fieldindicator[@type='error']">
                  <xsl:attribute name="aria-invalid">
                     <xsl:text>true</xsl:text>
                  </xsl:attribute>
               </xsl:if>
            </xsl:if>
            <xsl:if test="(@submitOnChange and not(@list))">
               <xsl:attribute name="class">
                  <xsl:text>wc_soc</xsl:text>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@toolTip and not(@list)">
               <xsl:attribute name="title">
                  <xsl:value-of select="@toolTip"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:choose>
               <xsl:when test="@list">
                  <xsl:attribute name="role">
                     <xsl:text>textbox</xsl:text>
                  </xsl:attribute>
                  <xsl:attribute name="autocomplete">
                     <xsl:text>off</xsl:text>
                  </xsl:attribute>
               </xsl:when>
               <xsl:when test="@autocomplete">
                  <xsl:attribute name="autocomplete">
                     <xsl:value-of select="@autocomplete"/>
                  </xsl:attribute>
               </xsl:when>
               <xsl:when test="self::ui:emailfield">
                  <xsl:attribute name="autocomplete">
                     <xsl:text>email</xsl:text>
                  </xsl:attribute>
               </xsl:when>
               <xsl:when test="self::ui:phonenumberfield">
                  <xsl:attribute name="autocomplete">
                     <xsl:text>tel</xsl:text>
                  </xsl:attribute>
               </xsl:when>
            </xsl:choose>
            <xsl:if test="@size">
               <xsl:attribute name="size">
                  <xsl:value-of select="@size"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@maxLength">
               <xsl:attribute name="maxlength">
                  <xsl:value-of select="@maxLength"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@minLength">
               <xsl:attribute name="minlength">
                  <xsl:value-of select="@minLength"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@pattern">
               <xsl:attribute name="pattern">
                  <xsl:value-of select="@pattern"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@placeholder">
               <xsl:attribute name="placeholder">
                  <xsl:value-of select="@placeholder"/>
               </xsl:attribute>
            </xsl:if>
         </xsl:element>
         <xsl:if test="@list">
            <button aria-hidden="true"
                    class="wc_suggest wc-invite"
                    id="{concat(@id, '_list')}"
                    tabindex="-1"
                    type="button"
                    value="{concat(@id,'_input')}">
               <xsl:if test="@disabled">
                  <xsl:attribute name="disabled">
                     <xsl:text>disabled</xsl:text>
                  </xsl:attribute>
               </xsl:if>
               <i aria-hidden="true" class="fa fa-caret-down"/>
            </button>
         </xsl:if>
         <xsl:apply-templates select="ui:fieldindicator"/>
      </span>
   </xsl:template>
   <xsl:template match="ui:checkbox | ui:radiobutton">
      <span id="{@id}"
            class="{normalize-space(concat('wc-', local-name(), ' wc-input-wrapper ', @class))}">
         <xsl:if test="@disabled">
            <xsl:attribute name="aria-disabled">
               <xsl:text>true</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="@hidden">
            <xsl:attribute name="hidden">
               <xsl:text>hidden</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:element name="input">
            <xsl:attribute name="id">
               <xsl:value-of select="concat(@id, '_input')"/>
            </xsl:attribute>
            <xsl:attribute name="type">
               <xsl:choose>
                  <xsl:when test="self::ui:checkbox">
                     <xsl:text>checkbox</xsl:text>
                  </xsl:when>
                  <xsl:otherwise>
                     <xsl:text>radio</xsl:text>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:attribute>
            <xsl:attribute name="name">
               <xsl:choose>
                  <xsl:when test="self::ui:checkbox">
                     <xsl:value-of select="@id"/>
                  </xsl:when>
                  <xsl:otherwise>
                     <xsl:value-of select="@groupName"/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:attribute>
            <xsl:if test="@toolTip">
               <xsl:attribute name="title">
                  <xsl:value-of select="@toolTip"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@required">
               <xsl:attribute name="required">
                  <xsl:text>required</xsl:text>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@disabled">
               <xsl:attribute name="disabled">
                  <xsl:text>disabled</xsl:text>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@accessibleText">
               <xsl:attribute name="aria-label">
                  <xsl:value-of select="@accessibleText"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@buttonId">
               <xsl:attribute name="data-wc-submit">
                  <xsl:value-of select="@buttonId"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="ui:fieldindicator">
               <xsl:if test="ui:fieldindicator[@id]">
                  <xsl:attribute name="aria-describedby">
                     <xsl:value-of select="ui:fieldindicator/@id"/>
                  </xsl:attribute>
               </xsl:if>
               <xsl:if test="ui:fieldindicator[@type='error']">
                  <xsl:attribute name="aria-invalid">
                     <xsl:text>true</xsl:text>
                  </xsl:attribute>
               </xsl:if>
            </xsl:if>
            <xsl:if test="@submitOnChange">
               <xsl:attribute name="class">
                  <xsl:text>wc_soc</xsl:text>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@selected">
               <xsl:attribute name="checked">
                  <xsl:text>checked</xsl:text>
               </xsl:attribute>
            </xsl:if>
            <xsl:choose>
               <xsl:when test="self::ui:checkbox">
                  <xsl:attribute name="value">
                     <xsl:text>true</xsl:text>
                  </xsl:attribute>
                  <xsl:if test="@groupName">
                     <xsl:attribute name="data-wc-group">
                        <xsl:value-of select="@groupName"/>
                     </xsl:attribute>
                  </xsl:if>
               </xsl:when>
               <xsl:when test="@value">
                  <xsl:attribute name="value">
                     <xsl:value-of select="@value"/>
                  </xsl:attribute>
               </xsl:when>
            </xsl:choose>
         </xsl:element>
         <xsl:choose>
            <xsl:when test="self::ui:checkbox">
               <xsl:apply-templates select="ui:fieldindicator"/>
            </xsl:when>
            <xsl:otherwise>
               <xsl:element name="input">
                  <xsl:attribute name="type">
                     <xsl:text>hidden</xsl:text>
                  </xsl:attribute>
                  <xsl:attribute name="name">
                     <xsl:value-of select="concat(@groupName, '-h')"/>
                  </xsl:attribute>
                  <xsl:attribute name="value">
                     <xsl:text>x</xsl:text>
                  </xsl:attribute>
                  <xsl:if test="@disabled">
                     <xsl:attribute name="disabled">
                        <xsl:text>disabled</xsl:text>
                     </xsl:attribute>
                  </xsl:if>
               </xsl:element>
            </xsl:otherwise>
         </xsl:choose>
      </span>
   </xsl:template>
   <xsl:template match="ui:checkbox[@readOnly] | ui:radiobutton[@readOnly]">
      <span id="{@id}" data-wc-component="{local-name()}">
         <xsl:variable name="additional">
            <xsl:value-of select="@class"/>
            <xsl:if test="@selected">
               <xsl:text> wc_ro_sel</xsl:text>
            </xsl:if>
         </xsl:variable>
         <xsl:attribute name="class">
            <xsl:value-of select="normalize-space(concat('wc-', local-name(),' wc-ro-input ', $additional))"/>
         </xsl:attribute>
         <xsl:attribute name="title">
            <xsl:choose>
               <xsl:when test="@selected">
                  <xsl:text>{{#i18n}}input_selected{{/i18n}}</xsl:text>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:text>{{#i18n}}input_unselected{{/i18n}}</xsl:text>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:attribute>
         <xsl:attribute name="data-wc-value">
            <xsl:choose>
               <xsl:when test="@selected">
                  <xsl:text>true</xsl:text>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:text>false</xsl:text>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:attribute>
         <xsl:if test="@hidden">
            <xsl:attribute name="hidden">
               <xsl:text>hidden</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:variable name="iconclass">
            <xsl:choose>
               <xsl:when test="self::ui:checkbox and @selected">fa-check-square-o</xsl:when>
               <xsl:when test="self::ui:checkbox">fa-square-o</xsl:when>
               <xsl:when test="@selected">fa-dot-circle-o</xsl:when>
               <xsl:otherwise>fa-circle-o</xsl:otherwise>
            </xsl:choose>
         </xsl:variable>
         <i aria-hidden="true" class="fa {$iconclass}"/>
      </span>
   </xsl:template>
   <xsl:template match="ui:datalist">
      <select>
         <xsl:apply-templates mode="selectableList" select="ui:option"/>
      </select>
   </xsl:template>
   <xsl:template match="ui:shuffler[@readOnly]">
      <ol id="{@id}" data-wc-component="shuffler">
         <xsl:attribute name="class">
            <xsl:value-of select="normalize-space(concat('wc-shuffler wc_list_nb wc-ro-input ', @class))"/>
         </xsl:attribute>
         <xsl:if test="@hidden">
            <xsl:attribute name="hidden">
               <xsl:text>hidden</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="@toolTip">
            <xsl:attribute name="title">
               <xsl:value-of select="@toolTip"/>
            </xsl:attribute>
         </xsl:if>
         <xsl:apply-templates mode="readOnly" select="ui:option | ui:optgroup">
            <xsl:with-param name="single" select="0"/>
         </xsl:apply-templates>
      </ol>
   </xsl:template>
   <xsl:template match="ui:shuffler">
      <span id="{@id}">
         <xsl:attribute name="class">
            <xsl:value-of select="normalize-space(concat('wc-shuffler wc-input-wrapper ', @class))"/>
         </xsl:attribute>
         <xsl:if test="@disabled">
            <xsl:attribute name="aria-disabled">
               <xsl:text>true</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="@hidden">
            <xsl:attribute name="hidden">
               <xsl:text>hidden</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:variable name="listId" select="concat(@id, '_input')"/>
         <select autocomplete="off"
                 class="wc_shuffler wc-noajax"
                 id="{$listId}"
                 multiple="multiple">
            <xsl:if test="@disabled">
               <xsl:attribute name="disabled">
                  <xsl:text>disabled</xsl:text>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="number(@rows) gt 2">
               <xsl:attribute name="size">
                  <xsl:value-of select="@rows"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="ui:fieldindicator">
               <xsl:if test="ui:fieldindicator[@id]">
                  <xsl:attribute name="aria-describedby">
                     <xsl:value-of select="ui:fieldindicator/@id"/>
                  </xsl:attribute>
               </xsl:if>
               <xsl:if test="ui:fieldindicator[@type='error']">
                  <xsl:attribute name="aria-invalid">
                     <xsl:text>true</xsl:text>
                  </xsl:attribute>
               </xsl:if>
            </xsl:if>
            <xsl:apply-templates mode="selectableList" select="ui:option | ui:optgroup"/>
         </select>
         <xsl:call-template name="listSortControls">
            <xsl:with-param name="id" select="$listId"/>
         </xsl:call-template>
         <xsl:apply-templates select="ui:fieldindicator"/>
      </span>
   </xsl:template>
   <xsl:template match="ui:multiselectpair[@readOnly]">
      <ul id="{@id}"
          class="wc-multiselectpair wc-vgap-sm"
          data-wc-component="multiselectpair">
         <xsl:if test="@hidden">
            <xsl:attribute name="hidden">
               <xsl:text>hidden</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:apply-templates mode="readOnly" select="ui:option | ui:optgroup[ui:option]">
            <xsl:with-param name="single" select="0"/>
         </xsl:apply-templates>
      </ul>
   </xsl:template>
   <xsl:template match="ui:multiselectpair">
      <xsl:variable name="size">
         <xsl:choose>
            <xsl:when test="@size">
               <xsl:value-of select="@size"/>
            </xsl:when>
            <xsl:otherwise>7</xsl:otherwise>
         </xsl:choose>
      </xsl:variable>
      <fieldset id="{@id}">
         <xsl:variable name="additional">
            <xsl:value-of select="@class"/>
            <xsl:if test="@required">
               <xsl:text> wc_req</xsl:text>
            </xsl:if>
         </xsl:variable>
         <xsl:attribute name="class">
            <xsl:value-of select="normalize-space(concat('wc-multiselectpair wc_noborder ', $additional))"/>
         </xsl:attribute>
         <xsl:if test="@hidden">
            <xsl:attribute name="hidden">
               <xsl:text>hidden</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="@toolTip">
            <xsl:attribute name="title">
               <xsl:value-of select="@toolTip"/>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="@accessibleText">
            <xsl:attribute name="aria-label">
               <xsl:value-of select="@accessibleText"/>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="ui:fieldindicator">
            <xsl:if test="ui:fieldindicator[@id]">
               <xsl:attribute name="aria-describedby">
                  <xsl:value-of select="ui:fieldindicator/@id"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="ui:fieldindicator[@type='error']">
               <xsl:attribute name="aria-invalid">
                  <xsl:text>true</xsl:text>
               </xsl:attribute>
            </xsl:if>
         </xsl:if>
         <xsl:if test="@min">
            <xsl:attribute name="data-wc-min">
               <xsl:value-of select="@min"/>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="@max">
            <xsl:attribute name="data-wc-max">
               <xsl:value-of select="@max"/>
            </xsl:attribute>
         </xsl:if>
         <xsl:variable name="availId" select="concat(@id, '_a')"/>
         <span>
            <label for="{$availId}">
               <xsl:value-of select="@fromListName"/>
            </label>
            <select autocomplete="off"
                    class="wc_msp_av wc-noajax"
                    id="{$availId}"
                    multiple="multiple"
                    size="{$size}">
               <xsl:if test="@disabled">
                  <xsl:attribute name="disabled">
                     <xsl:text>disabled</xsl:text>
                  </xsl:attribute>
               </xsl:if>
               <xsl:apply-templates mode="multiselectPair"
                                    select="ui:option[not(@selected)] | ui:optgroup[ui:option[not(@selected)]]">
                  <xsl:with-param name="applyWhich" select="'unselected'"/>
               </xsl:apply-templates>
            </select>
         </span>
         <span class="wc_msp_btncol">
            <xsl:text> </xsl:text>
            <button aria-controls="{concat(@id, '_a',' ',@id, '_s')}"
                    class="wc_btn_icon wc-invite"
                    type="button"
                    value="add">
               <xsl:attribute name="title">
                  <xsl:text>{{#i18n}}msp_add{{/i18n}}</xsl:text>
               </xsl:attribute>
               <xsl:if test="@disabled">
                  <xsl:attribute name="disabled">
                     <xsl:text>disabled</xsl:text>
                  </xsl:attribute>
               </xsl:if>
               <i aria-hidden="true" class="fa fa-fw fa-angle-right"/>
            </button>
            <button aria-controls="{concat(@id, '_a',' ',@id, '_s')}"
                    class="wc_btn_icon wc-invite"
                    type="button"
                    value="aall">
               <xsl:attribute name="title">
                  <xsl:text>{{#i18n}}msp_addAll{{/i18n}}</xsl:text>
               </xsl:attribute>
               <xsl:if test="@disabled">
                  <xsl:attribute name="disabled">
                     <xsl:text>disabled</xsl:text>
                  </xsl:attribute>
               </xsl:if>
               <i aria-hidden="true" class="fa fa-fw fa-angle-double-right"/>
            </button>
            <button aria-controls="{concat(@id, '_a',' ',@id, '_s')}"
                    class="wc_btn_icon wc-invite"
                    type="button"
                    value="rem">
               <xsl:attribute name="title">
                  <xsl:text>{{#i18n}}msp_remove{{/i18n}}</xsl:text>
               </xsl:attribute>
               <xsl:if test="@disabled">
                  <xsl:attribute name="disabled">
                     <xsl:text>disabled</xsl:text>
                  </xsl:attribute>
               </xsl:if>
               <i aria-hidden="true" class="fa fa-fw fa-angle-left"/>
            </button>
            <button aria-controls="{concat(@id, '_a',' ',@id, '_s')}"
                    class="wc_btn_icon wc-invite"
                    type="button"
                    value="rall">
               <xsl:attribute name="title">
                  <xsl:text>{{#i18n}}msp_removeAll{{/i18n}}</xsl:text>
               </xsl:attribute>
               <xsl:if test="@disabled">
                  <xsl:attribute name="disabled">
                     <xsl:text>disabled</xsl:text>
                  </xsl:attribute>
               </xsl:if>
               <i aria-hidden="true" class="fa fa-fw fa-angle-double-left"/>
            </button>
         </span>
         <xsl:variable name="toId" select="concat(@id, '_s')"/>
         <span>
            <label for="{$toId}">
               <xsl:value-of select="@toListName"/>
            </label>
            <select autocomplete="off"
                    class="wc_msp_chos wc-noajax"
                    id="{$toId}"
                    multiple="multiple"
                    size="{$size}">
               <xsl:if test="@disabled">
                  <xsl:attribute name="disabled">
                     <xsl:text>disabled</xsl:text>
                  </xsl:attribute>
               </xsl:if>
               <xsl:apply-templates mode="multiselectPair"
                                    select="ui:option[@selected] | ui:optgroup[ui:option[@selected]]">
                  <xsl:with-param name="applyWhich" select="'selected'"/>
               </xsl:apply-templates>
            </select>
         </span>
         <xsl:if test="@shuffle">
            <xsl:call-template name="listSortControls">
               <xsl:with-param name="id" select="$toId"/>
            </xsl:call-template>
         </xsl:if>
         <select autocomplete="off"
                 class="wc_msp_order wc_nolabel"
                 hidden="hidden"
                 multiple="multiple">
            <xsl:if test="@disabled">
               <xsl:attribute name="disabled">
                  <xsl:text>disabled</xsl:text>
               </xsl:attribute>
            </xsl:if>
            <xsl:apply-templates mode="multiselectPair"/>
         </select>
         <xsl:apply-templates select="ui:fieldindicator"/>
         <xsl:element name="input">
            <xsl:attribute name="type">
               <xsl:text>hidden</xsl:text>
            </xsl:attribute>
            <xsl:attribute name="name">
               <xsl:value-of select="concat(@id, '-h')"/>
            </xsl:attribute>
            <xsl:attribute name="value">
               <xsl:text>x</xsl:text>
            </xsl:attribute>
            <xsl:if test="@disabled">
               <xsl:attribute name="disabled">
                  <xsl:text>disabled</xsl:text>
               </xsl:attribute>
            </xsl:if>
         </xsl:element>
      </fieldset>
   </xsl:template>
   <xsl:template match="ui:selecttoggle">
      <xsl:choose>
         <xsl:when test="@renderAs eq 'control'">
            <span id="{@id}"
                  class="{normalize-space(concat('wc-selecttoggle wc-input-wrapper ', @class))}">
               <xsl:call-template name="selectToggle">
                  <xsl:with-param name="id" select="concat(@id, '_input')"/>
                  <xsl:with-param name="for" select="@target"/>
                  <xsl:with-param name="name" select="@id"/>
                  <xsl:with-param name="selected" select="@selected"/>
                  <xsl:with-param name="type">
                     <xsl:text>control</xsl:text>
                  </xsl:with-param>
               </xsl:call-template>
            </span>
         </xsl:when>
         <xsl:otherwise>
            <xsl:call-template name="selectToggle">
               <xsl:with-param name="for" select="@target"/>
               <xsl:with-param name="name" select="@id"/>
               <xsl:with-param name="selected" select="@selected"/>
               <xsl:with-param name="type">
                  <xsl:text>text</xsl:text>
               </xsl:with-param>
            </xsl:call-template>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xsl:template match="ui:collapsibletoggle">
      <xsl:variable name="id" select="@id"/>
      <xsl:variable name="for" select="@groupName"/>
      <xsl:variable name="mode">
         <xsl:choose>
            <xsl:when test="@mode and (@mode eq 'dynamic' or @mode eq 'lazy')">
               <xsl:value-of select="@mode"/>
            </xsl:when>
            <xsl:otherwise>
               <xsl:text>client</xsl:text>
            </xsl:otherwise>
         </xsl:choose>
      </xsl:variable>
      <xsl:variable name="toggleClass">wc_collapsibletoggle</xsl:variable>
      <ul id="{$id}"
          role="radiogroup"
          class="{normalize-space(concat('wc-collapsibletoggle wc_coltog ', @class))}">
         <xsl:attribute name="data-wc-group">
            <xsl:value-of select="$for"/>
         </xsl:attribute>
         <li>
            <xsl:call-template name="toggleElement">
               <xsl:with-param name="id" select="concat($id,'-ex')"/>
               <xsl:with-param name="name" select="$id"/>
               <xsl:with-param name="value" select="'expand'"/>
               <xsl:with-param name="text">
                  <xsl:text>{{#i18n}}expandall{{/i18n}}</xsl:text>
               </xsl:with-param>
               <xsl:with-param name="class" select="'wc_collapsibletoggle'"/>
            </xsl:call-template>
         </li>
         <li>
            <xsl:call-template name="toggleElement">
               <xsl:with-param name="id" select="concat($id,'-col')"/>
               <xsl:with-param name="name" select="$id"/>
               <xsl:with-param name="value" select="'collapse'"/>
               <xsl:with-param name="text">
                  <xsl:text>{{#i18n}}collapseall{{/i18n}}</xsl:text>
               </xsl:with-param>
               <xsl:with-param name="class" select="'wc_collapsibletoggle'"/>
            </xsl:call-template>
         </li>
      </ul>
   </xsl:template>
   <xsl:template match="ui:rowexpansion">
      <xsl:variable name="tableId" select="../@id"/>
      <xsl:variable name="id" select="concat($tableId, '_texall')"/>
      <xsl:if test="..//ui:subtr[ancestor::ui:table[1]/@id eq $tableId]">
         <xsl:variable name="mode">
            <xsl:choose>
               <xsl:when test="@mode and (@mode eq 'dynamic' or @mode eq 'lazy')">
                  <xsl:value-of select="@mode"/>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:text>client</xsl:text>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:variable>
         <ul id="{$id}" role="radiogroup" class="wc-rowexpansion wc_coltog">
            <xsl:attribute name="data-wc-group">
               <xsl:value-of select="$tableId"/>
            </xsl:attribute>
            <li>
               <xsl:call-template name="toggleElement">
                  <xsl:with-param name="id" select="concat($id,'-ex')"/>
                  <xsl:with-param name="name" select="$id"/>
                  <xsl:with-param name="value" select="'expand'"/>
                  <xsl:with-param name="text">
                     <xsl:text>{{#i18n}}expandall{{/i18n}}</xsl:text>
                  </xsl:with-param>
                  <xsl:with-param name="class" select="'wc_rowexpansion'"/>
               </xsl:call-template>
            </li>
            <li>
               <xsl:call-template name="toggleElement">
                  <xsl:with-param name="id" select="concat($id,'-col')"/>
                  <xsl:with-param name="name" select="$id"/>
                  <xsl:with-param name="value" select="'collapse'"/>
                  <xsl:with-param name="text">
                     <xsl:text>{{#i18n}}collapseall{{/i18n}}</xsl:text>
                  </xsl:with-param>
                  <xsl:with-param name="class" select="'wc_rowexpansion'"/>
               </xsl:call-template>
            </li>
         </ul>
      </xsl:if>
   </xsl:template>
   <xsl:template match="ui:rowselection">
      <xsl:variable name="tableId" select="../@id"/>
      <xsl:variable name="numberOfRows"
                    select="count(..//ui:tr[not(@unselectable) and ancestor::ui:table[1]/@id eq $tableId])"/>
      <xsl:if test="number($numberOfRows) gt 0">
         <xsl:variable name="numberSelectedRows"
                       select="count(..//ui:tr[@selected and ancestor::ui:table[1]/@id eq $tableId])"/>
         <xsl:variable name="selected">
            <xsl:choose>
               <xsl:when test="number($numberOfRows) eq 0">
                  <xsl:text>none</xsl:text>
               </xsl:when>
               <xsl:when test="@toggle">
                  <xsl:variable name="numberUnselectedParentRows"
                                select="count(..//ui:tr[@selected and        ancestor::ui:table[1]/@id eq $tableId and        .//ui:subtr[ancestor::ui:table[1]/@id eq $tableId]/ui:tr[not(@unselectable or @selected)]])"/>
                  <xsl:choose>
                     <xsl:when test="number($numberSelectedRows) eq number($numberUnselectedParentRows)">
                        <xsl:text>none</xsl:text>
                     </xsl:when>
                     <xsl:when test="number($numberUnselectedParentRows) eq 0 and number($numberSelectedRows) eq number($numberOfRows)">
                        <xsl:text>all</xsl:text>
                     </xsl:when>
                     <xsl:otherwise>
                        <xsl:text>some</xsl:text>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:when>
               <xsl:when test="number($numberOfRows) eq number($numberSelectedRows)">
                  <xsl:text>all</xsl:text>
               </xsl:when>
               <xsl:when test="count(..//ui:tr[@selected]) eq 0">
                  <xsl:text>none</xsl:text>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:text>some</xsl:text>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:variable>
         <xsl:variable name="bodyId" select="concat(../@id,'_tb')"/>
         <xsl:call-template name="selectToggle">
            <xsl:with-param name="id" select="$bodyId"/>
            <xsl:with-param name="for" select="$bodyId"/>
            <xsl:with-param name="selected" select="$selected"/>
            <xsl:with-param name="type" select="@selectAll"/>
         </xsl:call-template>
      </xsl:if>
   </xsl:template>
   <xsl:template match="ui:application">
      <xsl:param name="nojs" select="0"/>
      <xsl:variable name="baseAjaxUrl">
         <xsl:value-of select="@ajaxUrl"/>
      </xsl:variable>
      <xsl:variable name="additional">
         <xsl:value-of select="@class"/>
         <xsl:if test="@unsavedChanges or .//html:button[@class and contains(@class, 'wc_unsaved')] or .//ui:menuitem[@unsavedChanges]">
            <xsl:text> wc_unsaved</xsl:text>
         </xsl:if>
      </xsl:variable>
      <form action="{@applicationUrl}"
            method="post"
            id="{@id}"
            data-wc-datalisturl="{$baseAjaxUrl}"
            novalidate="novalidate"
            class="{normalize-space(concat('wc-application ', $additional))}">
         <xsl:attribute name="data-wc-ajaxurl">
            <xsl:value-of select="$baseAjaxUrl"/>
            <xsl:if test="ui:param">
               <xsl:choose>
                  <xsl:when test="contains($baseAjaxUrl, '?')">
                     <xsl:text>&amp;</xsl:text>
                  </xsl:when>
                  <xsl:otherwise>
                     <xsl:text>?</xsl:text>
                  </xsl:otherwise>
               </xsl:choose>
               <xsl:apply-templates select="ui:param" mode="get"/>
            </xsl:if>
         </xsl:attribute>
         <xsl:apply-templates/>
      </form>
   </xsl:template>
   <xsl:template match="ui:application/ui:param">
      <xsl:element name="input">
         <xsl:attribute name="type">
            <xsl:text>hidden</xsl:text>
         </xsl:attribute>
         <xsl:attribute name="name">
            <xsl:value-of select="@name"/>
         </xsl:attribute>
         <xsl:attribute name="value">
            <xsl:value-of select="@value"/>
         </xsl:attribute>
      </xsl:element>
   </xsl:template>
   <xsl:template match="ui:css"/>
   <xsl:template match="ui:js"/>
   <xsl:template match="ui:collapsible">
      <xsl:variable name="margin">
         <xsl:apply-templates select="ui:margin" mode="asclass"/>
      </xsl:variable>
      <details id="{@id}"
               class="{normalize-space(concat('wc-collapsble ', @class, $margin))}">
         <xsl:if test="not(@collapsed)">
            <xsl:attribute name="open">
               <xsl:text>open</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="@groupName and @groupName != @id">
            <xsl:attribute name="data-wc-group">
               <xsl:value-of select="@groupName"/>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="@hidden">
            <xsl:attribute name="hidden">
               <xsl:text>hidden</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <summary tabindex="0">
            <xsl:variable name="iconclass">
               <xsl:text>fa-caret-</xsl:text>
               <xsl:choose>
                  <xsl:when test="@collapsed">right</xsl:when>
                  <xsl:otherwise>down</xsl:otherwise>
               </xsl:choose>
            </xsl:variable>
            <i aria-hidden="true" class="fa {$iconclass}"/>
            <xsl:choose>
               <xsl:when test="@level">
                  <xsl:element name="h{@level}">
                     <xsl:apply-templates select="ui:decoratedlabel"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:apply-templates select="ui:decoratedlabel"/>
               </xsl:otherwise>
            </xsl:choose>
         </summary>
         <xsl:variable name="isAjax">
            <xsl:choose>
               <xsl:when test="@mode eq 'dynamic' or @mode eq 'eager' or (@mode eq 'lazy' and @collapsed)">
                  <xsl:number value="1"/>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:number value="0"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:variable>
         <xsl:apply-templates select="ui:content" mode="collapsible">
            <xsl:with-param name="class">
               <xsl:if test="number($isAjax) eq 1">
                  <xsl:text>wc_magic</xsl:text>
                  <xsl:if test="@mode eq 'dynamic'">
                     <xsl:text> wc_dynamic</xsl:text>
                  </xsl:if>
               </xsl:if>
            </xsl:with-param>
            <xsl:with-param name="ajaxId">
               <xsl:if test="number($isAjax) eq 1">
                  <xsl:value-of select="@id"/>
               </xsl:if>
            </xsl:with-param>
            <xsl:with-param name="labelId" select="ui:decoratedlabel/@id"/>
         </xsl:apply-templates>
      </details>
   </xsl:template>
   <xsl:template match="ui:datefield[@readOnly and @allowPartial]">
      <span id="{@id}"
            class="{normalize-space(concat('wc-datefield ', @class))}"
            data-wc-component="datefield">
         <xsl:if test="@hidden">
            <xsl:attribute name="hidden">
               <xsl:text>hidden</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:choose>
            <xsl:when test="@date">
               <xsl:attribute name="data-wc-value">
                  <xsl:value-of select="@date"/>
               </xsl:attribute>
            </xsl:when>
            <xsl:otherwise>
               <xsl:value-of select="text()"/>
            </xsl:otherwise>
         </xsl:choose>
      </span>
   </xsl:template>
   <xsl:template match="ui:datefield[@readOnly]">
      <time id="{@id}"
            class="{normalize-space(concat('wc-datefield ', @class))}"
            data-wc-component="datefield">
         <xsl:if test="@hidden">
            <xsl:attribute name="hidden">
               <xsl:text>hidden</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:choose>
            <xsl:when test="@date">
               <xsl:attribute name="datetime">
                  <xsl:value-of select="@date"/>
               </xsl:attribute>
            </xsl:when>
            <xsl:otherwise>
               <xsl:value-of select="text()"/>
            </xsl:otherwise>
         </xsl:choose>
      </time>
   </xsl:template>
   <xsl:template match="ui:datefield">
      <div id="{@id}"
           class="{normalize-space(concat('wc-datefield wc-input-wrapper ', @class))}">
         <xsl:if test="@disabled">
            <xsl:attribute name="aria-disabled">
               <xsl:text>true</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="@hidden">
            <xsl:attribute name="hidden">
               <xsl:text>hidden</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:element name="input">
            <xsl:attribute name="id">
               <xsl:value-of select="concat(@id, '_input')"/>
            </xsl:attribute>
            <xsl:attribute name="name">
               <xsl:value-of select="@id"/>
            </xsl:attribute>
            <xsl:attribute name="type">
               <xsl:text>date</xsl:text>
            </xsl:attribute>
            <xsl:if test="@toolTip">
               <xsl:attribute name="title">
                  <xsl:value-of select="@toolTip"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@required">
               <xsl:attribute name="required">
                  <xsl:text>required</xsl:text>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@disabled">
               <xsl:attribute name="disabled">
                  <xsl:text>disabled</xsl:text>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@accessibleText">
               <xsl:attribute name="aria-label">
                  <xsl:value-of select="@accessibleText"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@buttonId">
               <xsl:attribute name="data-wc-submit">
                  <xsl:value-of select="@buttonId"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="ui:fieldindicator">
               <xsl:if test="ui:fieldindicator[@id]">
                  <xsl:attribute name="aria-describedby">
                     <xsl:value-of select="ui:fieldindicator/@id"/>
                  </xsl:attribute>
               </xsl:if>
               <xsl:if test="ui:fieldindicator[@type='error']">
                  <xsl:attribute name="aria-invalid">
                     <xsl:text>true</xsl:text>
                  </xsl:attribute>
               </xsl:if>
            </xsl:if>
            <xsl:if test="@submitOnChange">
               <xsl:attribute name="class">
                  <xsl:text>wc_soc</xsl:text>
               </xsl:attribute>
            </xsl:if>
            <xsl:attribute name="value">
               <xsl:choose>
                  <xsl:when test="@date">
                     <xsl:value-of select="@date"/>
                  </xsl:when>
                  <xsl:otherwise>
                     <xsl:value-of select="text()"/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:attribute>
            <xsl:if test="@min">
               <xsl:attribute name="min">
                  <xsl:value-of select="@min"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@max">
               <xsl:attribute name="max">
                  <xsl:value-of select="@max"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@autocomplete">
               <xsl:attribute name="autocomplete">
                  <xsl:value-of select="@autocomplete"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="not(@date) and normalize-space(.) ne ''">
               <xsl:attribute name="aria-invalid">
                  <xsl:text>true</xsl:text>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@placeholder">
               <xsl:attribute name="placeholder">
                  <xsl:value-of select="@placeholder"/>
               </xsl:attribute>
            </xsl:if>
         </xsl:element>
         <xsl:apply-templates select="ui:fieldindicator"/>
      </div>
   </xsl:template>
   <xsl:template match="ui:datefield[@allowPartial and not(@readOnly)]">
      <div id="{@id}"
           class="{normalize-space(concat('wc-datefield wc_datefield_partial wc-input-wrapper ', @class))}"
           role="combobox"
           aria-autocomplete="list"
           aria-expanded="false">
         <xsl:if test="@disabled">
            <xsl:attribute name="aria-disabled">
               <xsl:text>true</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="@hidden">
            <xsl:attribute name="hidden">
               <xsl:text>hidden</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="@date">
            <xsl:attribute name="data-wc-value">
               <xsl:value-of select="@date"/>
            </xsl:attribute>
         </xsl:if>
         <xsl:element name="input">
            <xsl:attribute name="id">
               <xsl:value-of select="concat(@id, '_input')"/>
            </xsl:attribute>
            <xsl:attribute name="type">
               <xsl:text>text</xsl:text>
            </xsl:attribute>
            <xsl:attribute name="name">
               <xsl:value-of select="@id"/>
            </xsl:attribute>
            <xsl:if test="@toolTip">
               <xsl:attribute name="title">
                  <xsl:value-of select="@toolTip"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@required">
               <xsl:attribute name="required">
                  <xsl:text>required</xsl:text>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@disabled">
               <xsl:attribute name="disabled">
                  <xsl:text>disabled</xsl:text>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@accessibleText">
               <xsl:attribute name="aria-label">
                  <xsl:value-of select="@accessibleText"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@buttonId">
               <xsl:attribute name="data-wc-submit">
                  <xsl:value-of select="@buttonId"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="ui:fieldindicator">
               <xsl:if test="ui:fieldindicator[@id]">
                  <xsl:attribute name="aria-describedby">
                     <xsl:value-of select="ui:fieldindicator/@id"/>
                  </xsl:attribute>
               </xsl:if>
               <xsl:if test="ui:fieldindicator[@type='error']">
                  <xsl:attribute name="aria-invalid">
                     <xsl:text>true</xsl:text>
                  </xsl:attribute>
               </xsl:if>
            </xsl:if>
            <xsl:if test="@submitOnChange">
               <xsl:attribute name="class">
                  <xsl:text>wc_soc</xsl:text>
               </xsl:attribute>
            </xsl:if>
            <xsl:attribute name="value">
               <xsl:choose>
                  <xsl:when test="@date">
                     <xsl:value-of select="@date"/>
                  </xsl:when>
                  <xsl:otherwise>
                     <xsl:value-of select="text()"/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:attribute>
            <xsl:attribute name="autocomplete">
               <xsl:text>off</xsl:text>
            </xsl:attribute>
            <xsl:if test="@placeholder">
               <xsl:attribute name="placeholder">
                  <xsl:value-of select="@placeholder"/>
               </xsl:attribute>
            </xsl:if>
         </xsl:element>
         <button aria-hidden="true"
                 class="wc_wdf_cal wc-invite"
                 tabindex="-1"
                 type="button"
                 value="{concat(@id,'_input')}">
            <xsl:if test="@disabled">
               <xsl:attribute name="disabled">
                  <xsl:text>disabled</xsl:text>
               </xsl:attribute>
            </xsl:if>
            <i aria-hidden="true" class="fa fa-calendar"/>
         </button>
         <span aria-busy="true" role="listbox"/>
         <xsl:apply-templates select="ui:fieldindicator"/>
      </div>
   </xsl:template>
   <xsl:template match="ui:decoratedlabel">
      <xsl:param name="output" select="'span'"/>
      <xsl:element name="{$output}">
         <xsl:attribute name="id">
            <xsl:value-of select="@id"/>
         </xsl:attribute>
         <xsl:attribute name="class">
            <xsl:text>wc-decoratedlabel</xsl:text>
            <xsl:if test="@type">
               <xsl:value-of select="concat(' wc-decoratedlabel-type-', @type)"/>
            </xsl:if>
            <xsl:if test="@class">
               <xsl:value-of select="concat(' ', @class)"/>
            </xsl:if>
         </xsl:attribute>
         <xsl:if test="@hidden">
            <xsl:attribute name="hidden">
               <xsl:text>hidden</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:apply-templates select="*">
            <xsl:with-param name="output" select="$output"/>
         </xsl:apply-templates>
      </xsl:element>
   </xsl:template>
   <xsl:template match="ui:labelbody|ui:labelhead|ui:labeltail">
      <xsl:param name="output" select="'span'"/>
      <xsl:element name="{$output}">
         <xsl:attribute name="id">
            <xsl:value-of select="@id"/>
         </xsl:attribute>
         <xsl:attribute name="class">
            <xsl:value-of select="concat('wc-', local-name(), ' wc_dlbl_seg')"/>
         </xsl:attribute>
         <xsl:apply-templates/>
      </xsl:element>
   </xsl:template>
   <xsl:template match="ui:definitionlist">
      <xsl:variable name="additional">
         <xsl:value-of select="@class"/>
         <xsl:if test="@type">
            <xsl:value-of select="concat(' wc-definitionlist-type-', @type)"/>
         </xsl:if>
         <xsl:apply-templates select="ui:margin" mode="asclass"/>
      </xsl:variable>
      <dl id="{@id}"
          class="{normalize-space(concat('wc-definitionlist ', $additional))}">
         <xsl:if test="@hidden">
            <xsl:attribute name="hidden">
               <xsl:text>hidden</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:apply-templates select="ui:term"/>
      </dl>
   </xsl:template>
   <xsl:template match="ui:term">
      <dt>
         <xsl:value-of select="@text"/>
      </dt>
      <xsl:apply-templates select="ui:data"/>
   </xsl:template>
   <xsl:template match="ui:data">
      <dd>
         <xsl:apply-templates/>
      </dd>
   </xsl:template>
   <xsl:template match="ui:dialog">
      <xsl:apply-templates select="html:button"/>
   </xsl:template>
   <xsl:template match="ui:dropdown[@readOnly]">
      <span id="{@id}"
            class="{normalize-space(concat('wc-dropdown wc-ro-input ', @class))}"
            data-wc-component="dropdown">
         <xsl:if test="@hidden">
            <xsl:attribute name="hidden">
               <xsl:text>hidden</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:apply-templates mode="readOnly" select=".//ui:option"/>
      </span>
   </xsl:template>
   <xsl:template match="ui:dropdown">
      <xsl:variable name="additional">
         <xsl:value-of select="@class"/>
         <xsl:if test="@type">
            <xsl:value-of select="concat(' wc-dropdown-type-', @type)"/>
         </xsl:if>
      </xsl:variable>
      <span id="{@id}"
            class="{normalize-space(concat('wc-dropdown wc-input-wrapper ', $additional))}">
         <xsl:if test="@disabled">
            <xsl:attribute name="aria-disabled">
               <xsl:text>true</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="@hidden">
            <xsl:attribute name="hidden">
               <xsl:text>hidden</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="@data">
            <xsl:attribute name="data-wc-list">
               <xsl:value-of select="@data"/>
            </xsl:attribute>
         </xsl:if>
         <select id="{concat(@id, '_input')}" name="{@id}">
            <xsl:if test="@toolTip">
               <xsl:attribute name="title">
                  <xsl:value-of select="@toolTip"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@required">
               <xsl:attribute name="required">
                  <xsl:text>required</xsl:text>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@disabled">
               <xsl:attribute name="disabled">
                  <xsl:text>disabled</xsl:text>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@accessibleText">
               <xsl:attribute name="aria-label">
                  <xsl:value-of select="@accessibleText"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@buttonId">
               <xsl:attribute name="data-wc-submit">
                  <xsl:value-of select="@buttonId"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="ui:fieldindicator">
               <xsl:if test="ui:fieldindicator[@id]">
                  <xsl:attribute name="aria-describedby">
                     <xsl:value-of select="ui:fieldindicator/@id"/>
                  </xsl:attribute>
               </xsl:if>
               <xsl:if test="ui:fieldindicator[@type='error']">
                  <xsl:attribute name="aria-invalid">
                     <xsl:text>true</xsl:text>
                  </xsl:attribute>
               </xsl:if>
            </xsl:if>
            <xsl:if test="@submitOnChange or @optionWidth">
               <xsl:attribute name="class">
                  <xsl:if test="@submitOnChange">
                     <xsl:text>wc_soc</xsl:text>
                  </xsl:if>
                  <xsl:if test="@optionWidth">
                     <xsl:if test="@submitOnChange">
                        <xsl:value-of select="' '"/>
                     </xsl:if>
                     <xsl:text>wc-dd-ow-</xsl:text>
                     <xsl:value-of select="@optionWidth"/>
                  </xsl:if>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@autocomplete">
               <xsl:attribute name="autocomplete">
                  <xsl:value-of select="@autocomplete"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:apply-templates mode="selectableList" select="ui:option | ui:optgroup"/>
         </select>
         <xsl:apply-templates select="ui:fieldindicator"/>
      </span>
   </xsl:template>
   <xsl:template match="ui:dropdown[@type = 'combo' and not(@readOnly)]">
      <span id="{@id}"
            aria-autocomplete="list"
            aria-expanded="false"
            role="combobox"
            class="{normalize-space(concat('wc-dropdown wc-dropdown-type-combo wc-input-wrapper wc-combo ', @class))}">
         <xsl:if test="@disabled">
            <xsl:attribute name="aria-disabled">
               <xsl:text>true</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="@hidden">
            <xsl:attribute name="hidden">
               <xsl:text>hidden</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="@required">
            <xsl:attribute name="aria-required">
               <xsl:text>true</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="@toolTip">
            <xsl:attribute name="title">
               <xsl:value-of select="@toolTip"/>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="@data">
            <xsl:attribute name="data-wc-list">
               <xsl:value-of select="@data"/>
            </xsl:attribute>
         </xsl:if>
         <xsl:element name="input">
            <xsl:attribute name="id">
               <xsl:value-of select="concat(@id, '_input')"/>
            </xsl:attribute>
            <xsl:attribute name="type">
               <xsl:text>text</xsl:text>
            </xsl:attribute>
            <xsl:attribute name="name">
               <xsl:value-of select="@id"/>
            </xsl:attribute>
            <xsl:attribute name="value">
               <xsl:choose>
                  <xsl:when test="@data">
                     <xsl:value-of select="ui:option[1]"/>
                  </xsl:when>
                  <xsl:otherwise>
                     <xsl:value-of select=".//ui:option[@selected][1]"/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:attribute>
            <xsl:attribute name="role">
               <xsl:text>textbox</xsl:text>
            </xsl:attribute>
            <xsl:if test="@required">
               <xsl:attribute name="required">
                  <xsl:text>required</xsl:text>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@disabled">
               <xsl:attribute name="disabled">
                  <xsl:text>disabled</xsl:text>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@accessibleText">
               <xsl:attribute name="aria-label">
                  <xsl:value-of select="@accessibleText"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@buttonId">
               <xsl:attribute name="data-wc-submit">
                  <xsl:value-of select="@buttonId"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="ui:fieldindicator">
               <xsl:if test="ui:fieldindicator[@id]">
                  <xsl:attribute name="aria-describedby">
                     <xsl:value-of select="ui:fieldindicator/@id"/>
                  </xsl:attribute>
               </xsl:if>
               <xsl:if test="ui:fieldindicator[@type='error']">
                  <xsl:attribute name="aria-invalid">
                     <xsl:text>true</xsl:text>
                  </xsl:attribute>
               </xsl:if>
            </xsl:if>
            <xsl:if test="@optionWidth or @submitOnChange">
               <xsl:attribute name="class">
                  <xsl:if test="@submitOnChange">
                     <xsl:text>wc_soc</xsl:text>
                  </xsl:if>
                  <xsl:if test="@optionWidth">
                     <xsl:if test="@submitOnChange">
                        <xsl:value-of select="' '"/>
                     </xsl:if>
                     <xsl:text>wc-dd-ow-</xsl:text>
                     <xsl:value-of select="@optionWidth"/>
                  </xsl:if>
               </xsl:attribute>
            </xsl:if>
            <xsl:attribute name="autocomplete">
               <xsl:text>off</xsl:text>
            </xsl:attribute>
            <xsl:if test="@optionWidth">
               <xsl:attribute name="size">
                  <xsl:value-of select="@optionWidth"/>
               </xsl:attribute>
            </xsl:if>
         </xsl:element>
         <button aria-hidden="true"
                 class="wc_suggest wc-invite"
                 id="{concat(@id, '_list')}"
                 tabindex="-1"
                 type="button"
                 value="{concat(@id,'_input')}">
            <xsl:if test="@disabled">
               <xsl:attribute name="disabled">
                  <xsl:text>disabled</xsl:text>
               </xsl:attribute>
            </xsl:if>
            <i aria-hidden="true" class="fa fa-caret-down"/>
         </button>
         <span aria-controls="{@id}" id="{concat(@id, '_l')}" role="listbox">
            <xsl:if test="not(*)">
               <xsl:attribute name="aria-busy">
                  <xsl:text>true</xsl:text>
               </xsl:attribute>
            </xsl:if>
            <xsl:apply-templates mode="comboDataList" select="ui:option | ui:optgroup"/>
         </span>
         <xsl:apply-templates select="ui:fieldindicator"/>
      </span>
   </xsl:template>
   <xsl:template match="ui:fieldlayout">
      <xsl:variable name="additional">
         <xsl:value-of select="@class"/>
         <xsl:apply-templates select="ui:margin" mode="asclass"/>
         <xsl:if test="@labelWidth">
            <xsl:value-of select="concat(' wc_fld_lblwth_',@labelWidth)"/>
         </xsl:if>
         <xsl:if test="@ordered">
            <xsl:text> wc_ordered</xsl:text>
         </xsl:if>
         <xsl:if test="@layout">
            <xsl:value-of select="concat(' wc-layout-', @layout)"/>
         </xsl:if>
      </xsl:variable>
      <div role="presentation"
           id="{@id}"
           class="{normalize-space(concat('wc-fieldlayout ', $additional))}">
         <xsl:if test="@hidden">
            <xsl:attribute name="hidden">
               <xsl:text>hidden</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="@ordered and number(@ordered) ne 1">
            <xsl:attribute name="style">
               <xsl:value-of select="concat('counter-reset: wcfld ', number(@ordered) - 1, ';')"/>
            </xsl:attribute>
         </xsl:if>
         <xsl:apply-templates select="ui:field"/>
      </div>
   </xsl:template>
   <xsl:template match="ui:field">
      <xsl:variable name="additional">
         <xsl:value-of select="@class"/>
         <xsl:if test="@inputWidth">
            <xsl:value-of select="concat(' wc_inputwidth wc_fld_inpw_', @inputWidth)"/>
         </xsl:if>
      </xsl:variable>
      <div id="{@id}" class="{normalize-space(concat('wc-field ', $additional))}">
         <xsl:if test="not(parent::ui:fieldlayout)">
            <xsl:attribute name="data-wc-nop">
               <xsl:text>true</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="@hidden">
            <xsl:attribute name="hidden">
               <xsl:text>hidden</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:variable name="isCheckRadio">
            <xsl:call-template name="fieldIsCheckRadio"/>
         </xsl:variable>
         <xsl:choose>
            <xsl:when test="number($isCheckRadio) eq 1">
               <span class="wc_fld_pl">
                  <xsl:apply-templates select="ui:label"/>
               </span>
               <xsl:apply-templates select="ui:input"/>
            </xsl:when>
            <xsl:otherwise>
               <xsl:if test="not(ui:label) or ui:label/@hidden">
                  <span class="wc_fld_pl">
                     <xsl:text> </xsl:text>
                  </span>
               </xsl:if>
               <xsl:apply-templates select="*"/>
            </xsl:otherwise>
         </xsl:choose>
      </div>
   </xsl:template>
   <xsl:template match="ui:input">
      <div class="wc-input">
         <xsl:apply-templates/>
      </div>
   </xsl:template>
   <xsl:template match="ui:fieldset">
      <xsl:variable name="additional">
         <xsl:value-of select="@class"/>
         <xsl:apply-templates select="ui:margin" mode="asclass"/>
         <xsl:if test="@frame eq 'noborder' or @frame eq 'none'">
            <xsl:text> wc_noborder</xsl:text>
         </xsl:if>
         <xsl:if test="@required">
            <xsl:text> wc_req</xsl:text>
         </xsl:if>
      </xsl:variable>
      <fieldset id="{@id}"
                class="{normalize-space(concat('wc-fieldset ', $additional))}">
         <xsl:if test="@hidden">
            <xsl:attribute name="hidden">
               <xsl:text>hidden</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="ui:fieldindicator">
            <xsl:if test="ui:fieldindicator[@id]">
               <xsl:attribute name="aria-describedby">
                  <xsl:value-of select="ui:fieldindicator/@id"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="ui:fieldindicator[@type='error']">
               <xsl:attribute name="aria-invalid">
                  <xsl:text>true</xsl:text>
               </xsl:attribute>
            </xsl:if>
         </xsl:if>
         <legend>
            <xsl:if test="@frame eq 'notext' or @frame eq 'none'">
               <xsl:attribute name="class">
                  <xsl:text>wc-off</xsl:text>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@accessKey">
               <xsl:attribute name="accesskey">
                  <xsl:value-of select="@accessKey"/>
               </xsl:attribute>
               <xsl:attribute name="aria-describedby">
                  <xsl:value-of select="concat(@id,'_wctt')"/>
               </xsl:attribute>
               <span id="{concat(@id,'_wctt')}" role="tooltip" hidden="hidden">
                  <xsl:value-of select="@accessKey"/>
               </span>
            </xsl:if>
            <xsl:apply-templates select="ui:decoratedlabel"/>
            <i aria-hidden="true" class="fa fa-asterisk"/>
         </legend>
         <xsl:apply-templates select="ui:content" mode="passthru"/>
         <xsl:apply-templates select="ui:fieldindicator"/>
      </fieldset>
   </xsl:template>
   <xsl:template match="ui:fieldindicator">
      <span class="{normalize-space(concat('wc-fieldindicator wc-fieldindicator-type-', @type, ' ', @class))}"
            data-wc-dfor="{@for}">
         <xsl:if test="@id">
            <xsl:attribute name="id">
               <xsl:value-of select="@id"/>
            </xsl:attribute>
         </xsl:if>
         <xsl:variable name="iconclass">
            <xsl:choose>
               <xsl:when test="@type='error'">
                  <xsl:text>fa-times-circle</xsl:text>
               </xsl:when>
               <xsl:when test="@type='warn'">
                  <xsl:text>fa-exclamation-triangle</xsl:text>
               </xsl:when>
               <xsl:when test="@type='info'">
                  <xsl:text>fa-info-circle</xsl:text>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:text>fa-check-circle</xsl:text>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:variable>
         <i aria-hidden="true" class="fa {$iconclass}"/>
         <xsl:apply-templates select="ui:message" mode="fieldindicator"/>
      </span>
   </xsl:template>
   <xsl:template match="ui:figure">
      <xsl:variable name="mode" select="@mode"/>
      <xsl:variable name="additional">
         <xsl:value-of select="@class"/>
         <xsl:apply-templates select="ui:margin" mode="asclass"/>
         <xsl:if test="$mode eq 'lazy' and @hidden">
            <xsl:text> wc_magic</xsl:text>
         </xsl:if>
      </xsl:variable>
      <figure id="{@id}" class="{normalize-space(concat('wc-figure ', $additional))}">
         <xsl:if test="@hidden">
            <xsl:attribute name="hidden">
               <xsl:text>hidden</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="ui:content or ui:decoratedLabel or not($mode eq 'eager')">
            <xsl:apply-templates select="ui:content"/>
            <figcaption>
               <xsl:apply-templates select="ui:decoratedlabel"/>
            </figcaption>
         </xsl:if>
      </figure>
   </xsl:template>
   <xsl:template match="ui:heading">
      <xsl:variable name="additional">
         <xsl:value-of select="@class"/>
         <xsl:apply-templates select="ui:margin" mode="asclass"/>
      </xsl:variable>
      <xsl:element name="{concat('h',@level)}">
         <xsl:attribute name="id">
            <xsl:value-of select="@id"/>
         </xsl:attribute>
         <xsl:attribute name="class">
            <xsl:value-of select="normalize-space(concat('wc-heading ', $additional))"/>
         </xsl:attribute>
         <xsl:apply-templates/>
      </xsl:element>
   </xsl:template>
   <xsl:template match="html:wc-imageedit">
      <xsl:element name="div">
         <xsl:attribute name="id">
            <xsl:value-of select="@id"/>
         </xsl:attribute>
         <xsl:attribute name="class">
            <xsl:text>wc-imageedit</xsl:text>
         </xsl:attribute>
      </xsl:element>
   </xsl:template>
   <xsl:template match="ui:label">
      <xsl:variable name="class">
         <xsl:text>wc-label</xsl:text>
         <xsl:if test="@hidden">
            <xsl:text> wc-off</xsl:text>
         </xsl:if>
         <xsl:if test="@required and not(@readonly)">
            <xsl:text> wc_req</xsl:text>
         </xsl:if>
         <xsl:if test="@class">
            <xsl:value-of select="concat(' ', @class)"/>
         </xsl:if>
      </xsl:variable>
      <xsl:choose>
         <xsl:when test="@readonly or not(@what) or @what eq 'group'">
            <span id="{@id}" class="{normalize-space($class)}">
               <xsl:if test="@hiddencomponent">
                  <xsl:attribute name="hidden">
                     <xsl:text>hidden</xsl:text>
                  </xsl:attribute>
               </xsl:if>
               <xsl:if test="@toolTip">
                  <xsl:attribute name="title">
                     <xsl:value-of select="@toolTip"/>
                  </xsl:attribute>
               </xsl:if>
               <xsl:if test="@what">
                  <xsl:choose>
                     <xsl:when test="@readonly">
                        <xsl:attribute name="data-wc-rofor">
                           <xsl:value-of select="@for"/>
                        </xsl:attribute>
                     </xsl:when>
                     <xsl:when test="@what eq 'group'">
                        <xsl:attribute name="data-wc-for">
                           <xsl:value-of select="@for"/>
                        </xsl:attribute>
                        <xsl:attribute name="aria-hidden">
                           <xsl:text>true</xsl:text>
                        </xsl:attribute>
                        <xsl:if test="@accessKey">
                           <xsl:attribute name="data-wc-accesskey">
                              <xsl:value-of select="@accessKey"/>
                           </xsl:attribute>
                           <xsl:attribute name="aria-describedby">
                              <xsl:value-of select="concat(@id, '_wctt')"/>
                           </xsl:attribute>
                           <span hidden="hidden" id="{concat(@id,'_wctt')}" role="tooltip">
                              <xsl:value-of select="@accessKey"/>
                           </span>
                        </xsl:if>
                     </xsl:when>
                  </xsl:choose>
               </xsl:if>
               <xsl:apply-templates/>
               <xsl:if test="@what eq 'group'">
                  <i aria-hidden="true" class="fa fa-asterisk"/>
                  <xsl:if test="@hint">
                     <span class="wc-label-hint">
                        <xsl:value-of select="@hint"/>
                     </span>
                  </xsl:if>
               </xsl:if>
            </span>
         </xsl:when>
         <xsl:otherwise>
            <label for="{concat(@for,'_input')}"
                   id="{@id}"
                   class="{normalize-space($class)}">
               <xsl:if test="@hiddencomponent">
                  <xsl:attribute name="hidden">
                     <xsl:text>hidden</xsl:text>
                  </xsl:attribute>
               </xsl:if>
               <xsl:if test="@toolTip">
                  <xsl:attribute name="title">
                     <xsl:value-of select="@toolTip"/>
                  </xsl:attribute>
               </xsl:if>
               <xsl:if test="@accessKey">
                  <xsl:attribute name="accesskey">
                     <xsl:value-of select="@accessKey"/>
                  </xsl:attribute>
                  <xsl:attribute name="aria-describedby">
                     <xsl:value-of select="concat(@id, '_wctt')"/>
                  </xsl:attribute>
                  <span hidden="hidden" id="{concat(@id,'_wctt')}" role="tooltip">
                     <xsl:value-of select="@accessKey"/>
                  </span>
               </xsl:if>
               <xsl:apply-templates/>
               <i aria-hidden="true" class="fa fa-asterisk"/>
               <xsl:if test="@hint">
                  <span class="wc-label-hint">
                     <xsl:value-of select="@hint"/>
                  </span>
               </xsl:if>
            </label>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xsl:template match="ui:link">
      <xsl:param name="imageAltText" select="''"/>
      <xsl:param name="ajax" select="''"/>
      <xsl:variable name="elementType">
         <xsl:choose>
            <xsl:when test="@type">
               <xsl:text>button</xsl:text>
            </xsl:when>
            <xsl:otherwise>
               <xsl:text>a</xsl:text>
            </xsl:otherwise>
         </xsl:choose>
      </xsl:variable>
      <xsl:element name="{$elementType}">
         <xsl:attribute name="id">
            <xsl:value-of select="@id"/>
         </xsl:attribute>
         <xsl:attribute name="class">
            <xsl:text>wc-link</xsl:text>
            <xsl:if test="not(@type) and @imageUrl and @imagePosition">
               <xsl:text> wc_a_ilb</xsl:text>
            </xsl:if>
            <xsl:if test="@type">
               <xsl:value-of select="concat(' wc-link-type-', @type)"/>
            </xsl:if>
            <xsl:if test="@class">
               <xsl:value-of select="concat(' ', @class)"/>
            </xsl:if>
         </xsl:attribute>
         <xsl:if test="@disabled">
            <xsl:choose>
               <xsl:when test="@type">
                  <xsl:attribute name="disabled">
                     <xsl:text>disabled</xsl:text>
                  </xsl:attribute>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:attribute name="aria-disabled">
                     <xsl:text>true</xsl:text>
                  </xsl:attribute>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:if>
         <xsl:if test="@hidden">
            <xsl:attribute name="hidden">
               <xsl:text>hidden</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="@toolTip">
            <xsl:attribute name="title">
               <xsl:value-of select="@toolTip"/>
            </xsl:attribute>
         </xsl:if>
         <xsl:choose>
            <xsl:when test="@type">
               <xsl:attribute name="type">
                  <xsl:text>button</xsl:text>
               </xsl:attribute>
               <xsl:attribute name="data-wc-url">
                  <xsl:value-of select="@url"/>
               </xsl:attribute>
               <xsl:if test="ui:windowAttributes">
                  <xsl:attribute name="data-wc-window">
                     <xsl:value-of select="ui:windowAttributes/@name"/>
                  </xsl:attribute>
                  <xsl:attribute name="aria-haspopup">
                     <xsl:text>true</xsl:text>
                  </xsl:attribute>
               </xsl:if>
            </xsl:when>
            <xsl:otherwise>
               <xsl:attribute name="href">
                  <xsl:value-of select="@url"/>
               </xsl:attribute>
               <xsl:if test="ui:windowAttributes">
                  <xsl:attribute name="target">
                     <xsl:value-of select="ui:windowAttributes/@name"/>
                  </xsl:attribute>
               </xsl:if>
               <xsl:if test="$ajax != ''">
                  <xsl:attribute name="data-wc-ajaxalias">
                     <xsl:value-of select="$ajax"/>
                  </xsl:attribute>
               </xsl:if>
               <xsl:if test="@rel or ui:windowAttributes">
                  <xsl:variable name="noopener" select="'noopener'"/>
                  <xsl:variable name="noreferrer" select="'noreferrer'"/>
                  <xsl:attribute name="rel">
                     <xsl:choose>
                        <xsl:when test="@rel">
                           <xsl:value-of select="@rel"/>
                           <xsl:if test="ui:windowAttributes">
                              <xsl:if test="not(contains(@rel, $noopener))">
                                 <xsl:value-of select="concat(' ', $noopener)"/>
                              </xsl:if>
                              <xsl:if test="not(contains(@rel, $noreferrer))">
                                 <xsl:value-of select="concat(' ', $noreferrer)"/>
                              </xsl:if>
                           </xsl:if>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="concat($noopener, ' ', $noreferrer)"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </xsl:attribute>
               </xsl:if>
            </xsl:otherwise>
         </xsl:choose>
         <xsl:if test="@accessKey">
            <xsl:attribute name="accesskey">
               <xsl:value-of select="@accessKey"/>
            </xsl:attribute>
            <xsl:attribute name="aria-describedby">
               <xsl:value-of select="concat(@id, '_wctt')"/>
            </xsl:attribute>
            <span hidden="hidden" id="{concat(@id,'_wctt')}" role="tooltip">
               <xsl:value-of select="@accessKey"/>
            </span>
         </xsl:if>
         <xsl:choose>
            <xsl:when test="@imageUrl">
               <xsl:variable name="alt">
                  <xsl:choose>
                     <xsl:when test="$imageAltText ne ''">
                        <xsl:value-of select="$imageAltText"/>
                     </xsl:when>
                     <xsl:when test="@imagePosition">
                        <xsl:value-of select="''"/>
                     </xsl:when>
                     <xsl:otherwise>
                        <xsl:value-of select="text()"/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:variable>
               <span>
                  <xsl:attribute name="class">
                     <xsl:choose>
                        <xsl:when test="@imagePosition">
                           <xsl:value-of select="concat('wc_btn_img wc_btn_img', @imagePosition)"/>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:text>wc_nti</xsl:text>
                        </xsl:otherwise>
                     </xsl:choose>
                  </xsl:attribute>
                  <xsl:if test="@imagePosition">
                     <span>
                        <xsl:apply-templates/>
                     </span>
                  </xsl:if>
                  <img alt="{$alt}" src="{@imageUrl}"/>
               </span>
            </xsl:when>
            <xsl:otherwise>
               <xsl:apply-templates/>
            </xsl:otherwise>
         </xsl:choose>
      </xsl:element>
   </xsl:template>
   <xsl:template match="ui:windowAttributes"/>
   <xsl:template match="ui:listbox[@readOnly and @single]">
      <span id="{@id}"
            class="{normalize-space(concat('wc-listbox wc-ro-input ', @class))}"
            data-wc-component="listbox">
         <xsl:if test="@hidden">
            <xsl:attribute name="hidden">
               <xsl:text>hidden</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:apply-templates mode="readOnly" select=".//ui:option"/>
      </span>
   </xsl:template>
   <xsl:template match="ui:listbox[@readOnly]">
      <ul id="{@id}"
          class="{normalize-space(concat('wc-listbox wc-ro-input wc-vgap-sm ', @class))}"
          data-wc-component="listbox">
         <xsl:if test="@hidden">
            <xsl:attribute name="hidden">
               <xsl:text>hidden</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:apply-templates mode="readOnly" select="ui:option | ui:optgroup[ui:option]">
            <xsl:with-param name="single" select="0"/>
         </xsl:apply-templates>
      </ul>
   </xsl:template>
   <xsl:template match="ui:listbox">
      <span id="{@id}"
            class="{normalize-space(concat('wc-listbox wc-input-wrapper ', @class))}">
         <xsl:if test="@disabled">
            <xsl:attribute name="aria-disabled">
               <xsl:text>true</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="@hidden">
            <xsl:attribute name="hidden">
               <xsl:text>hidden</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="@data">
            <xsl:attribute name="data-wc-list">
               <xsl:value-of select="@data"/>
            </xsl:attribute>
         </xsl:if>
         <select id="{concat(@id, '_input')}" name="{@id}">
            <xsl:if test="@toolTip">
               <xsl:attribute name="title">
                  <xsl:value-of select="@toolTip"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@required">
               <xsl:attribute name="required">
                  <xsl:text>required</xsl:text>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@disabled">
               <xsl:attribute name="disabled">
                  <xsl:text>disabled</xsl:text>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@accessibleText">
               <xsl:attribute name="aria-label">
                  <xsl:value-of select="@accessibleText"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@buttonId">
               <xsl:attribute name="data-wc-submit">
                  <xsl:value-of select="@buttonId"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="ui:fieldindicator">
               <xsl:if test="ui:fieldindicator[@id]">
                  <xsl:attribute name="aria-describedby">
                     <xsl:value-of select="ui:fieldindicator/@id"/>
                  </xsl:attribute>
               </xsl:if>
               <xsl:if test="ui:fieldindicator[@type='error']">
                  <xsl:attribute name="aria-invalid">
                     <xsl:text>true</xsl:text>
                  </xsl:attribute>
               </xsl:if>
            </xsl:if>
            <xsl:if test="@submitOnChange">
               <xsl:attribute name="class">
                  <xsl:text>wc_soc</xsl:text>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="not(@single)">
               <xsl:attribute name="multiple">
                  <xsl:text>multiple</xsl:text>
               </xsl:attribute>
               <xsl:if test="@min">
                  <xsl:attribute name="data-wc-min">
                     <xsl:value-of select="@min"/>
                  </xsl:attribute>
               </xsl:if>
               <xsl:if test="@max">
                  <xsl:attribute name="data-wc-max">
                     <xsl:value-of select="@max"/>
                  </xsl:attribute>
               </xsl:if>
            </xsl:if>
            <xsl:if test="@rows">
               <xsl:attribute name="size">
                  <xsl:value-of select="@rows"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@autocomplete">
               <xsl:attribute name="autocomplete">
                  <xsl:value-of select="@autocomplete"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:apply-templates mode="selectableList" select="ui:option | ui:optgroup"/>
         </select>
         <xsl:apply-templates select="ui:fieldindicator"/>
         <xsl:element name="input">
            <xsl:attribute name="type">
               <xsl:text>hidden</xsl:text>
            </xsl:attribute>
            <xsl:attribute name="name">
               <xsl:value-of select="concat(@id, '-h')"/>
            </xsl:attribute>
            <xsl:attribute name="value">
               <xsl:text>x</xsl:text>
            </xsl:attribute>
            <xsl:if test="@disabled">
               <xsl:attribute name="disabled">
                  <xsl:text>disabled</xsl:text>
               </xsl:attribute>
            </xsl:if>
         </xsl:element>
      </span>
   </xsl:template>
   <xsl:template match="ui:margin"/>
   <xsl:template match="ui:menu">
      <xsl:variable name="id" select="@id"/>
      <xsl:variable name="type" select="@type"/>
      <xsl:variable name="isBarFlyout">
         <xsl:choose>
            <xsl:when test="$type eq 'bar' or $type eq 'flyout'">
               <xsl:number value="1"/>
            </xsl:when>
            <xsl:otherwise>
               <xsl:number value="0"/>
            </xsl:otherwise>
         </xsl:choose>
      </xsl:variable>
      <xsl:variable name="additional">
         <xsl:value-of select="@class"/>
         <xsl:apply-templates select="ui:margin" mode="asclass"/>
         <xsl:if test="number($isBarFlyout) eq 1">
            <xsl:text> wc_menu_bar</xsl:text>
         </xsl:if>
      </xsl:variable>
      <div id="{@id}"
           class="{normalize-space(concat('wc-menu wc-menu-type-', @type, ' ', $additional))}">
         <xsl:attribute name="role">
            <xsl:choose>
               <xsl:when test="number($isBarFlyout) eq 1">
                  <xsl:text>menubar</xsl:text>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:text>menu</xsl:text>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:attribute>
         <xsl:if test="@disabled">
            <xsl:attribute name="aria-disabled">
               <xsl:text>true</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="@hidden">
            <xsl:attribute name="hidden">
               <xsl:text>hidden</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:apply-templates/>
      </div>
   </xsl:template>
   <xsl:template match="ui:separator">
      <xsl:element name="hr">
         <xsl:attribute name="role">
            <xsl:text>separator</xsl:text>
         </xsl:attribute>
         <xsl:if test="@class">
            <xsl:attribute name="class">
               <xsl:value-of select="@class"/>
            </xsl:attribute>
         </xsl:if>
      </xsl:element>
   </xsl:template>
   <xsl:template match="ui:menugroup">
      <xsl:if test="not(preceding-sibling::ui:menugroup or preceding-sibling::ui:separator)">
         <hr role="separator"/>
      </xsl:if>
      <xsl:apply-templates select="*[not(self::ui:decoratedlabel)]"/>
      <xsl:if test="following-sibling::* and not(following-sibling::ui:separator)">
         <hr role="separator"/>
      </xsl:if>
   </xsl:template>
   <xsl:template match="ui:submenu">
      <div class="wc-submenu wc-submenu-type-{@type}"
           id="{@id}"
           role="presentation">
         <xsl:if test="@hidden">
            <xsl:attribute name="hidden">
               <xsl:text>hidden</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="@disabled">
            <xsl:attribute name="aria-disabled">true</xsl:attribute>
         </xsl:if>
         <xsl:variable name="isTree">
            <xsl:choose>
               <xsl:when test="@type = 'tree'">
                  <xsl:number value="1"/>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:number value="0"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:variable>
         <button aria-controls="{@id}"
                 class="wc-nobutton wc-invite wc-submenu-o"
                 id="{concat(@id, '_o')}"
                 name="{@id}"
                 type="button">
            <xsl:attribute name="aria-pressed">
               <xsl:choose>
                  <xsl:when test="@open = 'true'">true</xsl:when>
                  <xsl:otherwise>false</xsl:otherwise>
               </xsl:choose>
            </xsl:attribute>
            <xsl:if test="number($isTree) eq 1">
               <xsl:attribute name="aria-haspopup">true</xsl:attribute>
            </xsl:if>
            <xsl:if test="@toolTip">
               <xsl:attribute name="title">
                  <xsl:value-of select="@toolTip"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@disabled">
               <xsl:attribute name="disabled">
                  <xsl:text>disabled</xsl:text>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@accessKey">
               <xsl:attribute name="accesskey">
                  <xsl:value-of select="@accessKey"/>
               </xsl:attribute>
               <xsl:attribute name="aria-describedby">
                  <xsl:value-of select="concat(@id, '_wctt')"/>
               </xsl:attribute>
               <span hidden="hidden" id="{concat(@id,'_wctt')}" role="tooltip">
                  <xsl:value-of select="@accessKey"/>
               </span>
            </xsl:if>
            <xsl:if test="number($isTree) eq 1">
               <xsl:call-template name="submenuIcon"/>
            </xsl:if>
            <xsl:apply-templates select="ui:decoratedlabel"/>
            <xsl:if test="number($isTree) eq 0">
               <xsl:call-template name="submenuIcon"/>
            </xsl:if>
         </button>
         <xsl:apply-templates mode="submenu" select="ui:content"/>
      </div>
   </xsl:template>
   <xsl:template match="ui:menuitem">
      <xsl:variable name="actionType">
         <xsl:choose>
            <xsl:when test="@url">
               <xsl:number value="1"/>
            </xsl:when>
            <xsl:when test="@submit">
               <xsl:number value="2"/>
            </xsl:when>
            <xsl:otherwise>
               <xsl:number value="0"/>
            </xsl:otherwise>
         </xsl:choose>
      </xsl:variable>
      <xsl:variable name="role">
         <xsl:choose>
            <xsl:when test="@role">
               <xsl:value-of select="@role"/>
            </xsl:when>
            <xsl:otherwise>
               <xsl:text>menuitem</xsl:text>
            </xsl:otherwise>
         </xsl:choose>
      </xsl:variable>
      <xsl:variable name="additional">
         <xsl:if test="number($actionType) gt 0">
            <xsl:if test="@cancel">
               <xsl:text> wc_btn_cancel</xsl:text>
            </xsl:if>
            <xsl:if test="@unsavedChanges">
               <xsl:text> wc_unsaved</xsl:text>
            </xsl:if>
         </xsl:if>
      </xsl:variable>
      <button role="{$role}"
              tabindex="0"
              id="{@id}"
              class="{normalize-space(concat('wc-menuitem wc-invite wc-nobutton', $additional))}">
         <xsl:attribute name="type">
            <xsl:choose>
               <xsl:when test="number($actionType) eq 2">
                  <xsl:text>submit</xsl:text>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:text>button</xsl:text>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:attribute>
         <xsl:if test="@disabled">
            <xsl:attribute name="disabled">
               <xsl:text>disabled</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="@hidden">
            <xsl:attribute name="hidden">
               <xsl:text>hidden</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="@toolTip">
            <xsl:attribute name="title">
               <xsl:value-of select="@toolTip"/>
            </xsl:attribute>
         </xsl:if>
         <xsl:choose>
            <xsl:when test="number($actionType) eq 1">
               <xsl:attribute name="data-wc-url">
                  <xsl:value-of select="@url"/>
               </xsl:attribute>
               <xsl:if test="@targetWindow">
                  <xsl:attribute name="data-wc-window">
                     <xsl:value-of select="@targetWindow"/>
                  </xsl:attribute>
                  <xsl:attribute name="aria-haspopup">
                     <xsl:text>true</xsl:text>
                  </xsl:attribute>
               </xsl:if>
            </xsl:when>
            <xsl:when test="number($actionType) eq 2">
               <xsl:attribute name="name">
                  <xsl:value-of select="@id"/>
               </xsl:attribute>
               <xsl:attribute name="value">
                  <xsl:text>x</xsl:text>
               </xsl:attribute>
               <xsl:choose>
                  <xsl:when test="@cancel">
                     <xsl:attribute name="formnovalidate">
                        <xsl:text>formnovalidate</xsl:text>
                     </xsl:attribute>
                  </xsl:when>
                  <xsl:when test="@validates">
                     <xsl:attribute name="data-wc-validate">
                        <xsl:value-of select="@validates"/>
                     </xsl:attribute>
                  </xsl:when>
               </xsl:choose>
            </xsl:when>
         </xsl:choose>
         <xsl:if test="@msg">
            <xsl:attribute name="data-wc-btnmsg">
               <xsl:value-of select="@msg"/>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="$role ne 'menuitem'">
            <xsl:attribute name="aria-checked">
               <xsl:choose>
                  <xsl:when test="@selected">
                     <xsl:text>true</xsl:text>
                  </xsl:when>
                  <xsl:otherwise>
                     <xsl:text>false</xsl:text>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="@accessKey">
            <xsl:attribute name="accesskey">
               <xsl:value-of select="@accessKey"/>
            </xsl:attribute>
            <xsl:attribute name="aria-describedby">
               <xsl:value-of select="concat(@id,'_wctt')"/>
            </xsl:attribute>
            <span id="{concat(@id,'_wctt')}" role="tooltip" hidden="hidden">
               <xsl:value-of select="@accessKey"/>
            </span>
         </xsl:if>
         <xsl:apply-templates select="ui:decoratedlabel"/>
      </button>
   </xsl:template>
   <xsl:template match="ui:messagebox">
      <section id="{@id}"
               class="{normalize-space(concat('wc-messagebox wc-messagebox-type-', @type, ' ', @class))}">
         <h1>
            <xsl:variable name="iconclass">
               <xsl:text>fa-fw </xsl:text>
               <xsl:choose>
                  <xsl:when test="@type eq 'error'">
                     <xsl:text>fa-minus-circle</xsl:text>
                  </xsl:when>
                  <xsl:when test="@type eq 'warn'">
                     <xsl:text>fa-exclamation-triangle</xsl:text>
                  </xsl:when>
                  <xsl:when test="@type eq 'info'">
                     <xsl:text>fa-info-circle</xsl:text>
                  </xsl:when>
                  <xsl:otherwise>
                     <xsl:text>fa-check-circle</xsl:text>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:variable>
            <i aria-hidden="true" class="fa {$iconclass}"/>
            <span>
               <xsl:choose>
                  <xsl:when test="@title">
                     <xsl:value-of select="@title"/>
                  </xsl:when>
                  <xsl:when test="@type eq 'error'">
                     <xsl:text>{{#i18n}}messagetitle_error{{/i18n}}</xsl:text>
                  </xsl:when>
                  <xsl:when test="@type eq 'warn'">
                     <xsl:text>{{#i18n}}messagetitle_warn{{/i18n}}</xsl:text>
                  </xsl:when>
                  <xsl:when test="@type eq 'info'">
                     <xsl:text>{{#i18n}}messagetitle_info{{/i18n}}</xsl:text>
                  </xsl:when>
                  <xsl:otherwise>
                     <xsl:text>{{#i18n}}messagetitle_success{{/i18n}}</xsl:text>
                  </xsl:otherwise>
               </xsl:choose>
            </span>
         </h1>
         <div class="wc_messages">
            <xsl:apply-templates select="ui:message"/>
         </div>
      </section>
   </xsl:template>
   <xsl:template match="ui:message">
      <div class="wc-message">
         <xsl:apply-templates/>
      </div>
   </xsl:template>
   <xsl:template match="ui:validationerrors"/>
   <xsl:template match="ui:error"/>
   <xsl:template match="ui:multidropdown[@readOnly]">
      <ul id="{@id}"
          class="{normalize-space(concat('wc-multidropdown wc-vgap-sm ', @class))}"
          data-wc-component="multidropdown">
         <xsl:if test="@hidden">
            <xsl:attribute name="hidden">
               <xsl:text>hidden</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:apply-templates mode="readOnly" select="ui:option | ui:optgroup[ui:option]">
            <xsl:with-param name="single" select="0"/>
         </xsl:apply-templates>
      </ul>
   </xsl:template>
   <xsl:template match="ui:multidropdown">
      <fieldset aria-atomic="false" aria-relevant="additions removals" id="{@id}">
         <xsl:variable name="additional">
            <xsl:value-of select="@class"/>
            <xsl:if test="@required">
               <xsl:text> wc_req</xsl:text>
            </xsl:if>
         </xsl:variable>
         <xsl:attribute name="class">
            <xsl:value-of select="normalize-space(concat('wc-multidropdown wc_mfc wc_noborder ', $additional))"/>
         </xsl:attribute>
         <xsl:if test="@hidden">
            <xsl:attribute name="hidden">
               <xsl:text>hidden</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="@toolTip">
            <xsl:attribute name="title">
               <xsl:value-of select="@toolTip"/>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="@accessibleText">
            <xsl:attribute name="aria-label">
               <xsl:value-of select="@accessibleText"/>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="ui:fieldindicator">
            <xsl:if test="ui:fieldindicator[@id]">
               <xsl:attribute name="aria-describedby">
                  <xsl:value-of select="ui:fieldindicator/@id"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="ui:fieldindicator[@type='error']">
               <xsl:attribute name="aria-invalid">
                  <xsl:text>true</xsl:text>
               </xsl:attribute>
            </xsl:if>
         </xsl:if>
         <xsl:if test="@min">
            <xsl:attribute name="data-wc-min">
               <xsl:value-of select="@min"/>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="@max">
            <xsl:attribute name="data-wc-max">
               <xsl:value-of select="@max"/>
            </xsl:attribute>
         </xsl:if>
         <ul class="wc_list_nb wc-vgap-sm">
            <xsl:choose>
               <xsl:when test="count(.//ui:option[@selected]) eq 0">
                  <xsl:apply-templates mode="multiDropDown" select="(ui:option | ui:optgroup/ui:option)[1]"> </xsl:apply-templates>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:apply-templates mode="multiDropDown" select=".//ui:option[@selected]"/>
               </xsl:otherwise>
            </xsl:choose>
         </ul>
         <xsl:apply-templates select="ui:fieldindicator"/>
      </fieldset>
   </xsl:template>
   <xsl:template match="ui:multitextfield[@readOnly]">
      <ul id="{@id}"
          class="{normalize-space(concat('wc-multitextfield wc-vgap-sm ',  @class))}"
          data-wc-component="multitextfield">
         <xsl:if test="@hidden">
            <xsl:attribute name="hidden">
               <xsl:text>hidden</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:apply-templates mode="readOnly" select="ui:value"/>
      </ul>
   </xsl:template>
   <xsl:template match="ui:multitextfield">
      <fieldset aria-atomic="false" aria-relevant="additions removals" id="{@id}">
         <xsl:variable name="additional">
            <xsl:value-of select="@class"/>
            <xsl:if test="@required">
               <xsl:text> wc_req</xsl:text>
            </xsl:if>
         </xsl:variable>
         <xsl:attribute name="class">
            <xsl:value-of select="normalize-space(concat('wc-multitextfield wc_mfc wc_noborder ', $additional))"/>
         </xsl:attribute>
         <xsl:if test="@hidden">
            <xsl:attribute name="hidden">
               <xsl:text>hidden</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="@toolTip">
            <xsl:attribute name="title">
               <xsl:value-of select="@toolTip"/>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="@accessibleText">
            <xsl:attribute name="aria-label">
               <xsl:value-of select="@accessibleText"/>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="ui:fieldindicator">
            <xsl:if test="ui:fieldindicator[@id]">
               <xsl:attribute name="aria-describedby">
                  <xsl:value-of select="ui:fieldindicator/@id"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="ui:fieldindicator[@type='error']">
               <xsl:attribute name="aria-invalid">
                  <xsl:text>true</xsl:text>
               </xsl:attribute>
            </xsl:if>
         </xsl:if>
         <xsl:if test="@min">
            <xsl:attribute name="data-wc-min">
               <xsl:value-of select="@min"/>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="@max">
            <xsl:attribute name="data-wc-max">
               <xsl:value-of select="@max"/>
            </xsl:attribute>
         </xsl:if>
         <ul class="wc_list_nb wc-vgap-sm">
            <xsl:choose>
               <xsl:when test="ui:value">
                  <xsl:apply-templates select="ui:value"/>
               </xsl:when>
               <xsl:otherwise>
                  <li>
                     <xsl:variable name="inputId" select="concat(@id, generate-id())"/>
                     <label for="{$inputId}" class="wc-off">
                        <xsl:value-of select="@title"/>
                     </label>
                     <xsl:element name="input">
                        <xsl:attribute name="type">
                           <xsl:text>text</xsl:text>
                        </xsl:attribute>
                        <xsl:attribute name="name">
                           <xsl:value-of select="@id"/>
                        </xsl:attribute>
                        <xsl:attribute name="id">
                           <xsl:value-of select="$inputId"/>
                        </xsl:attribute>
                        <xsl:if test="@size">
                           <xsl:attribute name="size">
                              <xsl:value-of select="@size"/>
                           </xsl:attribute>
                        </xsl:if>
                        <xsl:if test="@maxLength">
                           <xsl:attribute name="maxlength">
                              <xsl:value-of select="@maxLength"/>
                           </xsl:attribute>
                        </xsl:if>
                        <xsl:if test="@pattern">
                           <xsl:attribute name="pattern">
                              <xsl:value-of select="@pattern"/>
                           </xsl:attribute>
                        </xsl:if>
                        <xsl:if test="@minLength">
                           <xsl:attribute name="minlength">
                              <xsl:value-of select="@minLength"/>
                           </xsl:attribute>
                        </xsl:if>
                        <xsl:if test="@placeholder">
                           <xsl:attribute name="placeholder">
                              <xsl:value-of select="@placeholder"/>
                           </xsl:attribute>
                        </xsl:if>
                        <xsl:if test="@disabled">
                           <xsl:attribute name="disabled">
                              <xsl:text>disabled</xsl:text>
                           </xsl:attribute>
                        </xsl:if>
                     </xsl:element>
                     <button aria-controls="{@id}" class="wc_btn_icon wc-invite" type="button">
                        <xsl:attribute name="title">
                           <xsl:text>{{#i18n}}mfc_add{{/i18n}}</xsl:text>
                        </xsl:attribute>
                        <xsl:if test="@disabled">
                           <xsl:attribute name="disabled">
                              <xsl:text>disabled</xsl:text>
                           </xsl:attribute>
                        </xsl:if>
                        <i aria-hidden="true" class="fa fa-plus-square"/>
                     </button>
                  </li>
               </xsl:otherwise>
            </xsl:choose>
         </ul>
         <xsl:apply-templates select="ui:fieldindicator"/>
      </fieldset>
   </xsl:template>
   <xsl:template match="ui:value">
      <li class="wc-value">
         <xsl:variable name="fieldId">
            <xsl:value-of select="../@id"/>
         </xsl:variable>
         <xsl:variable name="inputId"
                       select="concat($fieldId, generate-id(), '-', position())"/>
         <label for="{$inputId}" class="wc-off">
            <xsl:text>{{#i18n}}mfc_value{{/i18n}}</xsl:text>
         </label>
         <xsl:element name="input">
            <xsl:attribute name="type">
               <xsl:text>text</xsl:text>
            </xsl:attribute>
            <xsl:attribute name="name">
               <xsl:value-of select="$fieldId"/>
            </xsl:attribute>
            <xsl:attribute name="id">
               <xsl:value-of select="$inputId"/>
            </xsl:attribute>
            <xsl:if test="../@size">
               <xsl:attribute name="size">
                  <xsl:value-of select="../@size"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="../@maxLength">
               <xsl:attribute name="maxlength">
                  <xsl:value-of select="../@maxLength"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="../@pattern">
               <xsl:attribute name="pattern">
                  <xsl:value-of select="../@pattern"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="../@minLength">
               <xsl:attribute name="minlength">
                  <xsl:value-of select="../@minLength"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="../@placeholder">
               <xsl:attribute name="placeholder">
                  <xsl:value-of select="../@placeholder"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="../@disabled">
               <xsl:attribute name="disabled">
                  <xsl:text>disabled</xsl:text>
               </xsl:attribute>
            </xsl:if>
            <xsl:attribute name="value">
               <xsl:value-of select="."/>
            </xsl:attribute>
         </xsl:element>
         <xsl:variable name="toolTip">
            <xsl:choose>
               <xsl:when test="position() eq 1">
                  <xsl:text>{{#i18n}}mfc_add{{/i18n}}</xsl:text>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:text>{{#i18n}}mfc_remove{{/i18n}}</xsl:text>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:variable>
         <button class="wc_btn_icon wc-invite" title="{$toolTip}" type="button">
            <xsl:attribute name="aria-controls">
               <xsl:choose>
                  <xsl:when test="position() eq 1">
                     <xsl:value-of select="$fieldId"/>
                  </xsl:when>
                  <xsl:otherwise>
                     <xsl:value-of select="$inputId"/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:attribute>
            <xsl:if test="../@disabled">
               <xsl:attribute name="disabled">
                  <xsl:text>disabled</xsl:text>
               </xsl:attribute>
            </xsl:if>
            <xsl:variable name="iconclass">
               <xsl:text>fa-</xsl:text>
               <xsl:choose>
                  <xsl:when test="position() = 1">plus</xsl:when>
                  <xsl:otherwise>minus</xsl:otherwise>
               </xsl:choose>
               <xsl:text>-square</xsl:text>
            </xsl:variable>
            <i aria-hidden="true" class="fa {$iconclass}"/>
         </button>
      </li>
   </xsl:template>
   <xsl:template match="ui:numberfield[@readOnly]">
      <span id="{@id}"
            class="{normalize-space(concat('wc-numberfield wc-ro-input ', @class))}"
            data-wc-component="numberfield"
            data-wc-value="{text()}">
         <xsl:if test="@hidden">
            <xsl:attribute name="hidden">
               <xsl:text>hidden</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:apply-templates/>
      </span>
   </xsl:template>
   <xsl:template match="ui:numberfield">
      <span id="{@id}"
            class="{normalize-space(concat('wc-numberfield wc-input-wrapper ', @class))}">
         <xsl:if test="@disabled">
            <xsl:attribute name="aria-disabled">
               <xsl:text>true</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="@hidden">
            <xsl:attribute name="hidden">
               <xsl:text>hidden</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:element name="input">
            <xsl:attribute name="id">
               <xsl:value-of select="concat(@id, '_input')"/>
            </xsl:attribute>
            <xsl:attribute name="type">
               <xsl:text>number</xsl:text>
            </xsl:attribute>
            <xsl:attribute name="name">
               <xsl:value-of select="@id"/>
            </xsl:attribute>
            <xsl:attribute name="value">
               <xsl:value-of select="text()"/>
            </xsl:attribute>
            <xsl:if test="@required">
               <xsl:attribute name="required">
                  <xsl:text>required</xsl:text>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@disabled">
               <xsl:attribute name="disabled">
                  <xsl:text>disabled</xsl:text>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@accessibleText">
               <xsl:attribute name="aria-label">
                  <xsl:value-of select="@accessibleText"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@buttonId">
               <xsl:attribute name="data-wc-submit">
                  <xsl:value-of select="@buttonId"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="ui:fieldindicator">
               <xsl:if test="ui:fieldindicator[@id]">
                  <xsl:attribute name="aria-describedby">
                     <xsl:value-of select="ui:fieldindicator/@id"/>
                  </xsl:attribute>
               </xsl:if>
               <xsl:if test="ui:fieldindicator[@type='error']">
                  <xsl:attribute name="aria-invalid">
                     <xsl:text>true</xsl:text>
                  </xsl:attribute>
               </xsl:if>
            </xsl:if>
            <xsl:if test="@submitOnChange">
               <xsl:attribute name="class">
                  <xsl:text>wc_soc</xsl:text>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@toolTip">
               <xsl:attribute name="title">
                  <xsl:value-of select="@toolTip"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@autocomplete">
               <xsl:attribute name="autocomplete">
                  <xsl:value-of select="@autocomplete"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@min">
               <xsl:attribute name="min">
                  <xsl:value-of select="@min"/>
                  <xsl:if test="contains(@step, '.') and not(contains(@min, '.'))">
                     <xsl:text>.0</xsl:text>
                  </xsl:if>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@max">
               <xsl:attribute name="max">
                  <xsl:value-of select="@max"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@step">
               <xsl:variable name="step">
                  <xsl:choose>
                     <xsl:when test="not(@min) and contains(@step, '.')">
                        <xsl:number value="round(number(@step))"/>
                     </xsl:when>
                     <xsl:otherwise>
                        <xsl:number value="number(@step)"/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:variable>
               <xsl:if test="number($step) ne 0">
                  <xsl:attribute name="step">
                     <xsl:value-of select="$step"/>
                  </xsl:attribute>
               </xsl:if>
            </xsl:if>
            <xsl:if test="@placeholder">
               <xsl:attribute name="placeholder">
                  <xsl:value-of select="@placeholder"/>
               </xsl:attribute>
            </xsl:if>
         </xsl:element>
         <xsl:apply-templates select="ui:fieldindicator"/>
      </span>
   </xsl:template>
   <xsl:template match="ui:optgroup"/>
   <xsl:template match="ui:option"/>
   <xsl:template match="ui:popup"/>
   <xsl:template match="ui:redirect"/>
   <xsl:template match="ui:section">
      <xsl:variable name="mode" select="@mode"/>
      <xsl:variable name="additional">
         <xsl:value-of select="@class"/>
         <xsl:apply-templates select="ui:margin" mode="asclass"/>
         <xsl:if test="@mode eq 'lazy' and @hidden">
            <xsl:text> wc_magic</xsl:text>
         </xsl:if>
      </xsl:variable>
      <section id="{@id}"
               class="{normalize-space(concat('wc-section ', $additional))}">
         <xsl:if test="@hidden">
            <xsl:attribute name="hidden">
               <xsl:text>hidden</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="*[not(self::ui:margin)] or not($mode eq 'eager')">
            <xsl:apply-templates select="ui:decoratedlabel" mode="section"/>
            <xsl:apply-templates select="ui:panel">
               <xsl:with-param name="type" select="''"/>
            </xsl:apply-templates>
         </xsl:if>
      </section>
   </xsl:template>
   <xsl:template match="ui:session[count(.|((//ui:session)[1])) eq 1]">
      <div id="wc_session_container"
           class="wc_session"
           role="alert"
           hidden="hiddden"
           aria-live="polite"/>
   </xsl:template>
   <xsl:template match="ui:session"/>
   <xsl:template match="ui:skiplinks">
      <nav class="wc-skiplinks" aria-hidden="true"/>
   </xsl:template>
   <xsl:template match="ui:subordinate|ui:componentGroup|ui:target|ui:onTrue|ui:onFalse|ui:and|ui:or|ui:not"/>
   <xsl:template match="ui:component">
      <xsl:text>"</xsl:text>
      <xsl:value-of select="@id"/>
      <xsl:text>"</xsl:text>
      <xsl:if test="position() ne last()">
         <xsl:text>,</xsl:text>
      </xsl:if>
   </xsl:template>
   <xsl:template match="ui:suggestions">
      <span id="{@id}" role="listbox" class="wc-suggestions">
         <xsl:if test="@min">
            <xsl:attribute name="data-wc-minchars">
               <xsl:value-of select="@min"/>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="@data">
            <xsl:attribute name="data-wc-list">
               <xsl:value-of select="@data"/>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="@ajax">
            <xsl:attribute name="data-wc-chat">
               <xsl:value-of select="1"/>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="@autocomplete">
            <xsl:attribute name="data-wc-auto">
               <xsl:value-of select="@autocomplete"/>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="not(*)">
            <xsl:attribute name="aria-busy">
               <xsl:text>true</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:apply-templates select="ui:suggestion"/>
      </span>
   </xsl:template>
   <xsl:template match="ui:suggestion">
      <xsl:variable name="value" select="@value"/>
      <span data-wc-value="{$value}"
            role="option"
            class="wc-suggestion wc-invite"
            tabIndex="0">
         <xsl:value-of select="$value"/>
      </span>
   </xsl:template>
   <xsl:template match="ui:table">
      <xsl:variable name="rowExpansion">
         <xsl:choose>
            <xsl:when test="ui:rowexpansion">
               <xsl:value-of select="1"/>
            </xsl:when>
            <xsl:otherwise>
               <xsl:value-of select="0"/>
            </xsl:otherwise>
         </xsl:choose>
      </xsl:variable>
      <xsl:variable name="rowSelection">
         <xsl:choose>
            <xsl:when test="ui:rowselection">
               <xsl:value-of select="1"/>
            </xsl:when>
            <xsl:otherwise>
               <xsl:value-of select="0"/>
            </xsl:otherwise>
         </xsl:choose>
      </xsl:variable>
      <xsl:variable name="additionalTableClass">
         <xsl:value-of select="@class"/>
         <xsl:apply-templates select="ui:margin" mode="asclass"/>
         <xsl:if test="@type">
            <xsl:value-of select="concat(' wc-table-', @type)"/>
         </xsl:if>
      </xsl:variable>
      <div id="{@id}"
           class="{normalize-space(concat('wc-table ', $additionalTableClass))}">
         <xsl:if test="@hidden">
            <xsl:attribute name="hidden">
               <xsl:text>hidden</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="ui:pagination[@mode eq 'dynamic' or @mode eq 'client'] or ui:rowexpansion[@mode eq 'lazy' or @mode eq 'dynamic'] or ui:sort[@mode eq 'dynamic']">
            <xsl:attribute name="aria-live">
               <xsl:text>polite</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="number($rowExpansion) eq 1">
            <xsl:variable name="expMode" select="ui:rowexpansion/@mode"/>
            <xsl:attribute name="data-wc-expmode">
               <xsl:choose>
                  <xsl:when test="($expMode eq 'lazy') and ui:subtr/@open">
                     <xsl:text>client</xsl:text>
                  </xsl:when>
                  <xsl:otherwise>
                     <xsl:value-of select="$expMode"/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="ui:pagination">
            <xsl:attribute name="data-wc-pagemode">
               <xsl:choose>
                  <xsl:when test="ui:pagination/@mode">
                     <xsl:value-of select="ui:pagination/@mode"/>
                  </xsl:when>
                  <xsl:otherwise>
                     <xsl:text>client</xsl:text>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:attribute>
         </xsl:if>
         <xsl:call-template name="topControls"/>
         <xsl:variable name="tableClass">
            <xsl:if test="number($rowExpansion) eq 1">
               <xsl:text>wc_tbl_expansion</xsl:text>
            </xsl:if>
            <xsl:if test="ui:thead/ui:th[@width]">
               <xsl:text> wc_table_fix</xsl:text>
            </xsl:if>
         </xsl:variable>
         <table>
            <xsl:if test="$tableClass ne ''">
               <xsl:attribute name="class">
                  <xsl:value-of select="normalize-space($tableClass)"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="number($rowExpansion) + number($rowSelection) gt 0">
               <xsl:if test="number($rowSelection) eq 1">
                  <xsl:attribute name="aria-multiselectable">
                     <xsl:choose>
                        <xsl:when test="ui:rowselection/@multiple">
                           <xsl:text>true</xsl:text>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:text>false</xsl:text>
                        </xsl:otherwise>
                     </xsl:choose>
                  </xsl:attribute>
               </xsl:if>
            </xsl:if>
            <xsl:if test="ui:pagination">
               <xsl:attribute name="data-wc-rpp">
                  <xsl:choose>
                     <xsl:when test="ui:pagination/@rowsPerPage">
                        <xsl:value-of select="ui:pagination/@rowsPerPage"/>
                     </xsl:when>
                     <xsl:otherwise>
                        <xsl:value-of select="ui:pagination/@rows"/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="ui:sort">
               <xsl:attribute name="sortable">sortable</xsl:attribute>
            </xsl:if>
            <xsl:if test="@caption or ui:tbody/ui:nodata">
               <caption>
                  <div class="wc-caption">
                     <xsl:value-of select="@caption"/>
                  </div>
                  <xsl:apply-templates select="ui:tbody/ui:nodata"/>
               </caption>
            </xsl:if>
            <colgroup>
               <xsl:if test="@separators eq 'both' or @separators eq 'vertical'">
                  <xsl:attribute name="class">
                     <xsl:text>wc_table_colsep</xsl:text>
                  </xsl:attribute>
               </xsl:if>
               <xsl:if test="number($rowSelection) eq 1">
                  <col class="wc_table_colauto"/>
               </xsl:if>
               <xsl:if test="number($rowExpansion) eq 1">
                  <col class="wc_table_colauto"/>
               </xsl:if>
               <xsl:choose>
                  <xsl:when test="ui:thead/ui:th">
                     <xsl:apply-templates mode="col" select="ui:thead/ui:th">
                        <xsl:with-param name="stripe">
                           <xsl:choose>
                              <xsl:when test="@striping eq 'cols'">
                                 <xsl:value-of select="1"/>
                              </xsl:when>
                              <xsl:otherwise>
                                 <xsl:number value="0"/>
                              </xsl:otherwise>
                           </xsl:choose>
                        </xsl:with-param>
                        <xsl:with-param name="sortCol" select="ui:sort/@col"/>
                     </xsl:apply-templates>
                  </xsl:when>
                  <xsl:otherwise>
                     <xsl:apply-templates mode="col" select="ui:tbody/ui:tr[1]/ui:th | ui:tbody/ui:tr[1]/ui:td">
                        <xsl:with-param name="stripe">
                           <xsl:choose>
                              <xsl:when test="@striping eq 'cols'">
                                 <xsl:value-of select="1"/>
                              </xsl:when>
                              <xsl:otherwise>
                                 <xsl:number value="0"/>
                              </xsl:otherwise>
                           </xsl:choose>
                        </xsl:with-param>
                        <xsl:with-param name="sortCol" select="ui:sort/@col"/>
                     </xsl:apply-templates>
                  </xsl:otherwise>
               </xsl:choose>
            </colgroup>
            <xsl:apply-templates select="ui:thead"/>
            <xsl:apply-templates select="ui:tbody"/>
            <xsl:apply-templates select="html:tfoot"/>
         </table>
         <xsl:call-template name="tableBottomControls"/>
         <xsl:element name="input">
            <xsl:attribute name="type">
               <xsl:text>hidden</xsl:text>
            </xsl:attribute>
            <xsl:attribute name="name">
               <xsl:value-of select="concat(@id, '-h')"/>
            </xsl:attribute>
            <xsl:attribute name="value">
               <xsl:text>x</xsl:text>
            </xsl:attribute>
            <xsl:if test="@disabled">
               <xsl:attribute name="disabled">
                  <xsl:text>disabled</xsl:text>
               </xsl:attribute>
            </xsl:if>
         </xsl:element>
      </div>
   </xsl:template>
   <xsl:template match="ui:thead">
      <thead>
         <tr>
            <xsl:if test="../ui:rowselection">
               <th class="wc_table_sel_wrapper" scope="col" aria-hidden="true">
                  <xsl:text> </xsl:text>
               </th>
            </xsl:if>
            <xsl:if test="../ui:rowexpansion">
               <th class="wc_table_rowexp_container" scope="col">
                  <span class="wc-off">{{#i18n}}table_rowExpansion_toggleAll{{/i18n}}</span>
               </th>
            </xsl:if>
            <xsl:apply-templates select="ui:th" mode="thead"/>
         </tr>
      </thead>
   </xsl:template>
   <xsl:template match="ui:tbody">
      <xsl:variable name="additional">
         <xsl:if test="../@type">
            <xsl:value-of select="concat('wc_tbl_', ../@type)"/>
         </xsl:if>
         <xsl:if test="../@separators eq 'both' or ../@separators eq 'horizontal'">
            <xsl:text> wc_table_rowsep</xsl:text>
         </xsl:if>
      </xsl:variable>
      <tbody id="{concat(../@id,'_tb')}"
             class="{normalize-space(concat('wc-tbody ', $additional))}">
         <xsl:apply-templates select="ui:tr">
            <xsl:with-param name="myTable" select=".."/>
         </xsl:apply-templates>
      </tbody>
   </xsl:template>
   <xsl:template match="ui:tr">
      <xsl:param name="myTable"/>
      <xsl:param name="parentIsClosed" select="0"/>
      <xsl:param name="topRowIsStriped" select="0"/>
      <xsl:variable name="tableId" select="$myTable/@id"/>
      <xsl:variable name="rowId" select="concat($tableId, '_', @rowIndex)"/>
      <xsl:variable name="tableRowSelection">
         <xsl:choose>
            <xsl:when test="$myTable/ui:rowselection">
               <xsl:number value="1"/>
            </xsl:when>
            <xsl:otherwise>
               <xsl:number value="0"/>
            </xsl:otherwise>
         </xsl:choose>
      </xsl:variable>
      <xsl:variable name="hasRowExpansion">
         <xsl:choose>
            <xsl:when test="$myTable/ui:rowexpansion">
               <xsl:number value="1"/>
            </xsl:when>
            <xsl:otherwise>
               <xsl:number value="0"/>
            </xsl:otherwise>
         </xsl:choose>
      </xsl:variable>
      <xsl:variable name="indent">
         <xsl:choose>
            <xsl:when test="number($hasRowExpansion) eq 1 and $myTable/@type eq 'hierarchic' and parent::ui:subtr">
               <xsl:value-of select="count(ancestor::ui:subtr[ancestor::ui:table[1] eq $myTable])"/>
            </xsl:when>
            <xsl:otherwise>
               <xsl:number value="0"/>
            </xsl:otherwise>
         </xsl:choose>
      </xsl:variable>
      <xsl:variable name="removeRow">
         <xsl:choose>
            <xsl:when test="number($parentIsClosed) eq 1 or @hidden or parent::ui:subtr[not(@open)] or (ancestor::ui:subtr[not(@open) and ancestor::ui:table[1]/@id eq $tableId])">
               <xsl:number value="1"/>
            </xsl:when>
            <xsl:when test="parent::ui:tbody and $myTable/ui:pagination and $myTable/ui:pagination/@mode eq 'client'">
               <xsl:call-template name="clientRowClosedHelper">
                  <xsl:with-param name="myTable" select="$myTable"/>
               </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
               <xsl:number value="0"/>
            </xsl:otherwise>
         </xsl:choose>
      </xsl:variable>
      <xsl:variable name="rowIsSelectable">
         <xsl:choose>
            <xsl:when test="number($tableRowSelection) eq 1 and not(@unselectable)">
               <xsl:number value="1"/>
            </xsl:when>
            <xsl:otherwise>
               <xsl:number value="0"/>
            </xsl:otherwise>
         </xsl:choose>
      </xsl:variable>
      <xsl:variable name="additional">
         <xsl:choose>
            <xsl:when test="parent::ui:tbody">
               <xsl:if test="$myTable/@striping eq 'rows' and position() mod 2 eq 0">
                  <xsl:text>wc_table_stripe</xsl:text>
               </xsl:if>
               <xsl:if test="$myTable/ui:pagination">
                  <xsl:text> wc_table_pag_row</xsl:text>
               </xsl:if>
            </xsl:when>
            <xsl:when test="number($topRowIsStriped) eq 1">
               <xsl:text>wc_table_stripe</xsl:text>
            </xsl:when>
         </xsl:choose>
         <xsl:if test="number($rowIsSelectable) eq 1">
            <xsl:text> wc-invite</xsl:text>
         </xsl:if>
      </xsl:variable>
      <tr class="{normalize-space(concat('wc-tr ', $additional))}"
          data-wc-rowindex="{@rowIndex}"
          id="{$rowId}">
         <xsl:if test="@disabled">
            <xsl:attribute name="disabled">
               <xsl:text>disabled</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="number($hasRowExpansion) + $rowIsSelectable ge 1">
            <xsl:attribute name="role">row</xsl:attribute>
         </xsl:if>
         <xsl:if test="number($hasRowExpansion) eq 1">
            <xsl:if test="ui:subtr">
               <xsl:attribute name="aria-expanded">
                  <xsl:choose>
                     <xsl:when test="ui:subtr/@open">
                        <xsl:text>true</xsl:text>
                     </xsl:when>
                     <xsl:otherwise>
                        <xsl:text>false</xsl:text>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:attribute>
               <xsl:attribute name="aria-controls">
                  <xsl:choose>
                     <xsl:when test="ui:subtr/ui:tr">
                        <xsl:apply-templates mode="subRowControlIdentifier" select="ui:subtr/ui:tr">
                           <xsl:with-param name="tableId" select="$tableId"/>
                        </xsl:apply-templates>
                     </xsl:when>
                     <xsl:when test="ui:subtr/ui:content">
                        <xsl:value-of select="concat($tableId, '_subc', @rowIndex)"/>
                     </xsl:when>
                     <xsl:otherwise>
                        <xsl:value-of select="concat($tableId, '_sub', @rowIndex)"/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:attribute>
               <xsl:variable name="expMode" select="$myTable/ui:rowexpansion/@mode"/>
               <xsl:if test="$expMode eq 'lazy' and ui:subtr/@open">
                  <xsl:attribute name="data-wc-expmode">
                     <xsl:text>client</xsl:text>
                  </xsl:attribute>
               </xsl:if>
            </xsl:if>
            <xsl:if test="parent::ui:subtr">
               <xsl:attribute name="aria-live">
                  <xsl:text>polite</xsl:text>
               </xsl:attribute>
            </xsl:if>
            <xsl:attribute name="aria-level">
               <xsl:value-of select="count(ancestor::ui:subtr[ancestor::ui:table[1]/@id eq $tableId]) + 1"/>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="number($rowIsSelectable) eq 1">
            <xsl:attribute name="aria-selected">
               <xsl:choose>
                  <xsl:when test="@selected">
                     <xsl:text>true</xsl:text>
                  </xsl:when>
                  <xsl:otherwise>
                     <xsl:text>false</xsl:text>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:attribute>
            <xsl:attribute name="tabindex">
               <xsl:text>0</xsl:text>
            </xsl:attribute>
            <xsl:attribute name="data-wc-name">
               <xsl:value-of select="concat($tableId, '.selected')"/>
            </xsl:attribute>
            <xsl:attribute name="data-wc-value">
               <xsl:value-of select="@rowIndex"/>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="number($removeRow) eq 1">
            <xsl:attribute name="hidden">
               <xsl:text>hidden</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="number($tableRowSelection) eq 1">
            <td class="wc_table_sel_wrapper">
               <xsl:choose>
                  <xsl:when test="(number($hasRowExpansion) + number($tableRowSelection) eq 2) and $myTable/ui:rowselection/@toggle and ui:subtr/ui:tr[not(@unselectable)]">
                     <xsl:variable name="subRowControlList">
                        <xsl:if test="not(@unselectable)">
                           <xsl:value-of select="concat($rowId, ' ')"/>
                        </xsl:if>
                        <xsl:apply-templates mode="subRowControlIdentifier"
                                             select="ui:subtr//ui:tr[not(@unselectable) and ancestor::ui:table[1]/@id eq $tableId]">
                           <xsl:with-param name="tableId" select="$tableId"/>
                        </xsl:apply-templates>
                     </xsl:variable>
                     <xsl:if test="$subRowControlList ne ''">
                        <xsl:attribute name="role">
                           <xsl:text>presentation</xsl:text>
                        </xsl:attribute>
                     </xsl:if>
                     <xsl:if test="number($rowIsSelectable) eq 1">
                        <xsl:call-template name="rowSelectionIcon">
                           <xsl:with-param name="myTable" select="$myTable"/>
                        </xsl:call-template>
                     </xsl:if>
                     <xsl:if test="$subRowControlList ne ''">
                        <xsl:variable name="subRowToggleControlId"
                                      select="concat($rowId, '_toggleController')"/>
                        <xsl:variable name="subRowToggleControlButtonId"
                                      select="concat($subRowToggleControlId, '_showbtn')"/>
                        <xsl:variable name="subRowToggleControlContentId"
                                      select="concat($subRowToggleControlId, '_content')"/>
                        <div class="wc-menu wc-menu-type-flyout wc_menu_bar"
                             id="{$subRowToggleControlId}"
                             role="menubar">
                           <div class="wc-submenu" role="presentation">
                              <button aria-controls="{$subRowToggleControlContentId}"
                                      aria-haspopup="true"
                                      class="wc-nobutton wc-invite wc-submenu-o"
                                      id="{$subRowToggleControlButtonId}"
                                      type="button">
                                 <span class="wc-decoratedlabel">
                                    <span class="wc-off wc-labelbody">{{#i18n}}table_rowSelection_toggleAll{{/i18n}}</span>
                                 </span>
                                 <i aria-hidden="true" class="fa fa-caret-down"/>
                              </button>
                              <div aria-expanded="false"
                                   aria-labelledby="{$subRowToggleControlButtonId}"
                                   class="wc_submenucontent wc_seltog"
                                   id="{$subRowToggleControlContentId}"
                                   role="menu">
                                 <xsl:variable name="allSelectableSubRows"
                                               select="count(.//ui:subtr[ancestor::ui:table[1]/@id eq $tableId]/ui:tr[not(@unselectable)])"/>
                                 <xsl:variable name="allUnselectedSubRows"
                                               select="count(.//ui:subtr[ancestor::ui:table[1]/@id eq $tableId]/ui:tr[not(@unselectable or @selected)])"/>
                                 <button aria-controls="{$subRowControlList}"
                                         class="wc-menuitem wc_seltog wc-nobutton wc-invite"
                                         data-wc-value="all"
                                         role="menuitemradio"
                                         type="button">
                                    <xsl:attribute name="aria-checked">
                                       <xsl:choose>
                                          <xsl:when test="number($allUnselectedSubRows) eq 0">
                                             <xsl:text>true</xsl:text>
                                          </xsl:when>
                                          <xsl:otherwise>
                                             <xsl:text>false</xsl:text>
                                          </xsl:otherwise>
                                       </xsl:choose>
                                    </xsl:attribute>
                                    <i aria-hidden="true" class="fa fa-check-square-o"/>
                                    <span class="wc-off">{{#i18n}}toggle_all_label{{/i18n}}</span>
                                 </button>
                                 <button aria-controls="{$subRowControlList}"
                                         class="wc-menuitem wc_seltog wc-nobutton wc-invite"
                                         data-wc-value="none"
                                         role="menuitemradio"
                                         type="button">
                                    <xsl:attribute name="aria-checked">
                                       <xsl:choose>
                                          <xsl:when test="number($allSelectableSubRows) eq number($allUnselectedSubRows)">
                                             <xsl:text>true</xsl:text>
                                          </xsl:when>
                                          <xsl:otherwise>
                                             <xsl:text>false</xsl:text>
                                          </xsl:otherwise>
                                       </xsl:choose>
                                    </xsl:attribute>
                                    <i aria-hidden="true" class="fa fa-square-o"/>
                                    <span class="wc-off">{{#i18n}}toggle_none_label{{/i18n}}</span>
                                 </button>
                              </div>
                           </div>
                        </div>
                     </xsl:if>
                  </xsl:when>
                  <xsl:otherwise>
                     <xsl:attribute name="aria-hidden">
                        <xsl:text>true</xsl:text>
                     </xsl:attribute>
                     <xsl:if test="number($rowIsSelectable) eq 1">
                        <xsl:call-template name="rowSelectionIcon">
                           <xsl:with-param name="myTable" select="$myTable"/>
                        </xsl:call-template>
                     </xsl:if>
                  </xsl:otherwise>
               </xsl:choose>
            </td>
         </xsl:if>
         <xsl:if test="$myTable/ui:rowexpansion">
            <td class="wc_table_rowexp_container">
               <xsl:if test="ui:subtr">
                  <xsl:attribute name="role">button</xsl:attribute>
                  <xsl:attribute name="aria-controls">
                     <xsl:value-of select="$rowId"/>
                  </xsl:attribute>
                  <xsl:attribute name="tabindex">0</xsl:attribute>
                  <span class="wc-off">{{#i18n}}table_rowExpansion_rowButtonDescription{{/i18n}}</span>
                  <xsl:variable name="iconclass">
                     <xsl:text>fa-fw fa-caret-</xsl:text>
                     <xsl:choose>
                        <xsl:when test="ui:subtr/@open">
                           <xsl:text>down</xsl:text>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:text>right</xsl:text>
                        </xsl:otherwise>
                     </xsl:choose>
                  </xsl:variable>
                  <i aria-hidden="true" class="fa {$iconclass}"/>
               </xsl:if>
            </td>
         </xsl:if>
         <xsl:apply-templates select="ui:th | ui:td">
            <xsl:with-param name="myTable" select="$myTable"/>
            <xsl:with-param name="indent" select="$indent"/>
         </xsl:apply-templates>
      </tr>
      <xsl:apply-templates select="ui:subtr">
         <xsl:with-param name="myTable" select="$myTable"/>
         <xsl:with-param name="parentIsClosed" select="$removeRow"/>
         <xsl:with-param name="indent" select="$indent"/>
         <xsl:with-param name="topRowIsStriped">
            <xsl:choose>
               <xsl:when test="number($topRowIsStriped) eq 1 or (parent::ui:tbody and $myTable/@striping eq 'rows' and position() mod 2 eq 0)">
                  <xsl:number value="1"/>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:number value="0"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:with-param>
      </xsl:apply-templates>
   </xsl:template>
   <xsl:template match="ui:th">
      <xsl:param name="myTable"/>
      <xsl:variable name="tableId" select="$myTable/@id"/>
      <xsl:variable name="myHeader" select="$myTable/ui:thead/ui:th[1]"/>
      <xsl:variable name="additional">
         <xsl:if test="$myHeader">
            <xsl:value-of select="concat('wc-align-', $myHeader/@align)"/>
         </xsl:if>
      </xsl:variable>
      <th id="{concat($tableId,'_trh',../@rowIndex)}"
          scope="row"
          class="{normalize-space(concat('wc-th ', $additional))}">
         <xsl:if test="$myHeader">
            <xsl:attribute name="headers">
               <xsl:value-of select="concat($tableId,'_thh','1')"/>
            </xsl:attribute>
         </xsl:if>
         <xsl:apply-templates/>
      </th>
   </xsl:template>
   <xsl:template match="ui:td">
      <xsl:param name="myTable"/>
      <xsl:variable name="tableId" select="$myTable/@id"/>
      <xsl:variable name="tbleColPos" select="position()"/>
      <xsl:variable name="colHeaderElement"
                    select="$myTable/ui:thead/ui:th[position() eq number($tbleColPos)]"/>
      <xsl:variable name="rowHeaderElement" select="../ui:th[1]"/>
      <xsl:variable name="additional">
         <xsl:if test="$colHeaderElement/@align">
            <xsl:value-of select="concat('wc-align-',$colHeaderElement/@align)"/>
         </xsl:if>
      </xsl:variable>
      <td class="{normalize-space(concat('wc-td ', $additional))}">
         <xsl:if test="$colHeaderElement or $rowHeaderElement">
            <xsl:attribute name="headers">
               <xsl:variable name="colHeader">
                  <xsl:if test="$colHeaderElement">
                     <xsl:value-of select="concat($tableId,'_thh',$tbleColPos)"/>
                  </xsl:if>
               </xsl:variable>
               <xsl:variable name="rowHeader">
                  <xsl:if test="$rowHeaderElement">
                     <xsl:value-of select="concat($tableId,'_trh',../@rowIndex)"/>
                  </xsl:if>
               </xsl:variable>
               <xsl:value-of select="normalize-space(concat($colHeader,' ',$rowHeader))"/>
            </xsl:attribute>
         </xsl:if>
         <xsl:apply-templates/>
      </td>
   </xsl:template>
   <xsl:template match="ui:subtr">
      <xsl:param name="myTable"/>
      <xsl:param name="parentIsClosed" select="0"/>
      <xsl:param name="topRowIsStriped" select="0"/>
      <xsl:param name="indent" select="0"/>
      <xsl:choose>
         <xsl:when test="*">
            <xsl:apply-templates select="*">
               <xsl:with-param name="myTable" select="$myTable"/>
               <xsl:with-param name="parentIsClosed" select="$parentIsClosed"/>
               <xsl:with-param name="indent" select="$indent"/>
               <xsl:with-param name="topRowIsStriped" select="$topRowIsStriped"/>
            </xsl:apply-templates>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="tableId" select="$myTable/@id"/>
            <tr id="{concat($tableId,'_sub',../@rowIndex)}" hidden="hidden"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xsl:template match="ui:subtr/ui:content">
      <xsl:param name="myTable"/>
      <xsl:param name="parentIsClosed" select="0"/>
      <xsl:param name="topRowIsStriped" select="0"/>
      <xsl:param name="indent" select="0"/>
      <xsl:variable name="tableId" select="$myTable/@id"/>
      <xsl:variable name="additional">
         <xsl:if test="number($topRowIsStriped) eq 1">
            <xsl:text>wc_table_stripe</xsl:text>
         </xsl:if>
         <xsl:if test="number($indent) gt 0">
            <xsl:value-of select="concat(' wc_tbl_indent_', $indent)"/>
         </xsl:if>
      </xsl:variable>
      <tr id="{concat($tableId,'_subc',../../@rowIndex)}"
          role="row"
          aria-level="{count(ancestor::ui:subtr[ancestor::ui:table[1]/@id eq $tableId]) + 1}"
          class="{normalize-space(concat('wc-tr ', $additional))}">
         <xsl:if test="number($parentIsClosed) eq 1 or ancestor::ui:subtr[not(@open)]">
            <xsl:attribute name="hidden">
               <xsl:text>hidden</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="$myTable/ui:rowselection">
            <td class="wc_table_sel_wrapper">
               <xsl:text> </xsl:text>
            </td>
         </xsl:if>
         <td class="wc_table_rowexp_container">
            <xsl:text> </xsl:text>
         </td>
         <td>
            <xsl:if test="@spanAllCols">
               <xsl:attribute name="colspan">
                  <xsl:value-of select="count(../../*) -1"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:apply-templates/>
         </td>
      </tr>
   </xsl:template>
   <xsl:template match="ui:actions">
      <div class="wc-actions">
         <xsl:apply-templates select="ui:action/html:button"/>
      </div>
   </xsl:template>
   <xsl:template match="ui:action|ui:sort"/>
   <xsl:template match="ui:nodata">
      <div class="wc-nodata">
         <xsl:value-of select="."/>
      </div>
   </xsl:template>
   <xsl:template match="ui:pagination">
      <xsl:param name="idSuffix" select="''"/>
      <xsl:variable name="tableId" select="../@id"/>
      <xsl:variable name="name">
         <xsl:value-of select="concat($tableId, '.page')"/>
      </xsl:variable>
      <xsl:variable name="id">
         <xsl:value-of select="concat($name, $idSuffix)"/>
      </xsl:variable>
      <xsl:variable name="pages">
         <xsl:choose>
            <xsl:when test="not(@rowsPerPage)">
               <xsl:number value="1"/>
            </xsl:when>
            <xsl:otherwise>
               <xsl:value-of select="ceiling(@rows div @rowsPerPage)"/>
            </xsl:otherwise>
         </xsl:choose>
      </xsl:variable>
      <xsl:if test="number(@rows) gt 0">
         <xsl:if test="number(@rows) gt number(@rowsPerPage)">
            <span class="wc_table_pag_rows"
                  data-wc-tablerpp="{@rowsPerPage}"
                  data-wc-tablerows="{@rows}"
                  data-wc-tablepage="{@currentPage}"/>
         </xsl:if>
         <label for="{$id}">
            <xsl:text>{{#i18n}}table_pagination_page{{/i18n}}</xsl:text>
            <select id="{$id}" class="wc_table_pag_select" data-wc-pages="{$pages}">
               <xsl:choose>
                  <xsl:when test="number($pages) eq 1">
                     <xsl:attribute name="disabled">
                        <xsl:text>disabled</xsl:text>
                     </xsl:attribute>
                  </xsl:when>
                  <xsl:otherwise>
                     <xsl:attribute name="aria-busy">
                        <xsl:text>true</xsl:text>
                     </xsl:attribute>
                  </xsl:otherwise>
               </xsl:choose>
               <option value="{@currentPage}" selected="selected">
                  <xsl:value-of select="@currentPage + 1"/>
               </option>
            </select>
         </label>
         <xsl:if test="not(@mode = 'client')">
            <xsl:apply-templates select="ui:rowsselect">
               <xsl:with-param name="tableId" select="$tableId"/>
               <xsl:with-param name="idSuffix" select="$idSuffix"/>
            </xsl:apply-templates>
         </xsl:if>
         <span class="wc_table_pag_btns">
            <xsl:call-template name="paginationButton">
               <xsl:with-param name="title">
                  <xsl:text>{{#i18n}}table_pagination_button_first{{/i18n}}</xsl:text>
               </xsl:with-param>
               <xsl:with-param name="idSuffix" select="concat($idSuffix,'1')"/>
               <xsl:with-param name="disabled">
                  <xsl:choose>
                     <xsl:when test="number($pages) eq 1 or number(@currentPage) eq 0">
                        <xsl:number value="1"/>
                     </xsl:when>
                     <xsl:otherwise>
                        <xsl:number value="0"/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:with-param>
               <xsl:with-param name="name" select="'f'"/>
            </xsl:call-template>
            <xsl:call-template name="paginationButton">
               <xsl:with-param name="title">
                  <xsl:text>{{#i18n}}table_pagination_button_previous{{/i18n}}</xsl:text>
               </xsl:with-param>
               <xsl:with-param name="idSuffix" select="concat($idSuffix,'2')"/>
               <xsl:with-param name="disabled">
                  <xsl:choose>
                     <xsl:when test="number($pages) eq 1 or number(@currentPage) eq 0">
                        <xsl:number value="1"/>
                     </xsl:when>
                     <xsl:otherwise>
                        <xsl:number value="0"/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:with-param>
               <xsl:with-param name="name" select="'p'"/>
            </xsl:call-template>
            <xsl:call-template name="paginationButton">
               <xsl:with-param name="title">
                  <xsl:text>{{#i18n}}table_pagination_button_next{{/i18n}}</xsl:text>
               </xsl:with-param>
               <xsl:with-param name="idSuffix" select="concat($idSuffix,'3')"/>
               <xsl:with-param name="disabled">
                  <xsl:choose>
                     <xsl:when test="number($pages) eq 1 or number(@currentPage) eq number($pages) - 1">
                        <xsl:number value="1"/>
                     </xsl:when>
                     <xsl:otherwise>
                        <xsl:number value="0"/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:with-param>
               <xsl:with-param name="name" select="'n'"/>
            </xsl:call-template>
            <xsl:call-template name="paginationButton">
               <xsl:with-param name="title">
                  <xsl:text>{{#i18n}}table_pagination_button_last{{/i18n}}</xsl:text>
               </xsl:with-param>
               <xsl:with-param name="idSuffix" select="concat($idSuffix,'4')"/>
               <xsl:with-param name="disabled">
                  <xsl:choose>
                     <xsl:when test="number($pages) eq 1 or number(@currentPage) eq number($pages) - 1">
                        <xsl:number value="1"/>
                     </xsl:when>
                     <xsl:otherwise>
                        <xsl:number value="0"/>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:with-param>
               <xsl:with-param name="name" select="'l'"/>
            </xsl:call-template>
         </span>
      </xsl:if>
   </xsl:template>
   <xsl:template match="ui:rowsselect">
      <xsl:param name="tableId"/>
      <xsl:param name="idSuffix"/>
      <xsl:variable name="rppChooserName">
         <xsl:value-of select="concat($tableId,'.rows', $idSuffix)"/>
      </xsl:variable>
      <label for="{$rppChooserName}">
         <xsl:text>{{#i18n}}table_pagination_label_rppChooser{{/i18n}}</xsl:text>
         <select id="{$rppChooserName}" class="wc_table_pag_rpp">
            <xsl:apply-templates select="ui:option" mode="rowsPerPage">
               <xsl:with-param name="rowsPerPage" select="../@rowsPerPage"/>
            </xsl:apply-templates>
         </select>
      </label>
   </xsl:template>
   <xsl:template match="ui:tabset">
      <xsl:variable name="additional">
         <xsl:value-of select="@class"/>
         <xsl:apply-templates select="ui:margin" mode="asclass"/>
         <xsl:if test="@type">
            <xsl:value-of select="concat(' wc-tabset-type-', @type)"/>
         </xsl:if>
      </xsl:variable>
      <div id="{@id}" class="{normalize-space(concat('wc-tabset ', $additional))}">
         <xsl:if test="@disabled">
            <xsl:attribute name="aria-disabled">true</xsl:attribute>
         </xsl:if>
         <xsl:if test="@hidden">
            <xsl:attribute name="hidden">
               <xsl:text>hidden</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="@groupName">
            <xsl:attribute name="data-wc-group">
               <xsl:value-of select="@groupName"/>
            </xsl:attribute>
         </xsl:if>
         <div role="tablist">
            <xsl:choose>
               <xsl:when test="@type eq 'accordion'">
                  <xsl:attribute name="aria-multiselectable">
                     <xsl:choose>
                        <xsl:when test="@single">false</xsl:when>
                        <xsl:otherwise>true</xsl:otherwise>
                     </xsl:choose>
                  </xsl:attribute>
               </xsl:when>
               <xsl:when test="@type eq 'left' or @type eq 'right'">
                  <xsl:attribute name="aria-orientation">
                     <xsl:text>vertical</xsl:text>
                  </xsl:attribute>
               </xsl:when>
            </xsl:choose>
            <xsl:apply-templates select="ui:tab">
               <xsl:with-param name="numAvailTabs" select="count(ui:tab[@open and not(@disabled)])"/>
            </xsl:apply-templates>
         </div>
         <xsl:if test="not(@type eq 'accordion')">
            <xsl:apply-templates select="ui:tab" mode="content"/>
         </xsl:if>
      </div>
   </xsl:template>
   <xsl:template match="ui:tab">
      <xsl:param name="numAvailTabs" select="0"/>
      <xsl:variable name="type" select="../@type"/>
      <xsl:variable name="isDisabled">
         <xsl:choose>
            <xsl:when test="@disabled or ../@disabled">
               <xsl:number value="1"/>
            </xsl:when>
            <xsl:otherwise>
               <xsl:number value="0"/>
            </xsl:otherwise>
         </xsl:choose>
      </xsl:variable>
      <xsl:variable name="expandSelectAttrib">
         <xsl:choose>
            <xsl:when test="$type eq 'accordion'">
               <xsl:text>aria-expanded</xsl:text>
            </xsl:when>
            <xsl:otherwise>
               <xsl:text>aria-selected</xsl:text>
            </xsl:otherwise>
         </xsl:choose>
      </xsl:variable>
      <div id="{@id}"
           role="tab"
           aria-controls="{ui:tabcontent/@id}"
           class="{normalize-space(concat('wc-tab wc-invite ', @class))}">
         <xsl:attribute name="{$expandSelectAttrib}">
            <xsl:choose>
               <xsl:when test="@open">
                  <xsl:text>true</xsl:text>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:text>false</xsl:text>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:attribute>
         <xsl:attribute name="tabindex">
            <xsl:choose>
               <xsl:when test="@disabled or (number($numAvailTabs) gt 0 and not(@open))">
                  <xsl:text>-1</xsl:text>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:text>0</xsl:text>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:attribute>
         <xsl:if test="@toolTip">
            <xsl:attribute name="title">
               <xsl:value-of select="@toolTip"/>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="number($isDisabled) eq 1">
            <xsl:attribute name="aria-disabled">
               <xsl:text>true</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="not(@open)">
            <xsl:if test="@hidden">
               <xsl:attribute name="hidden">
                  <xsl:text>hidden</xsl:text>
               </xsl:attribute>
            </xsl:if>
         </xsl:if>
         <xsl:if test="@accessKey">
            <xsl:attribute name="accesskey">
               <xsl:value-of select="@accessKey"/>
            </xsl:attribute>
            <xsl:attribute name="aria-describedby">
               <xsl:value-of select="concat(@id,'_wctt')"/>
            </xsl:attribute>
            <span id="{concat(@id,'_wctt')}" role="tooltip" hidden="hidden">
               <xsl:value-of select="@accessKey"/>
            </span>
         </xsl:if>
         <xsl:apply-templates select="ui:decoratedlabel">
            <xsl:with-param name="output" select="'div'"/>
         </xsl:apply-templates>
      </div>
      <xsl:if test="$type eq 'accordion'">
         <xsl:apply-templates select="ui:tabcontent">
            <xsl:with-param name="tabset" select="parent::ui:tabset"/>
         </xsl:apply-templates>
      </xsl:if>
   </xsl:template>
   <xsl:template match="ui:tabcontent">
      <xsl:param name="tabset"/>
      <xsl:variable name="open">
         <xsl:choose>
            <xsl:when test="../@open">
               <xsl:number value="1"/>
            </xsl:when>
            <xsl:otherwise>
               <xsl:number value="0"/>
            </xsl:otherwise>
         </xsl:choose>
      </xsl:variable>
      <xsl:variable name="mode" select="../@mode"/>
      <div id="{@id}" role="tabpanel" aria-live="polite">
         <xsl:attribute name="class">
            <xsl:text>wc-tabcontent</xsl:text>
            <xsl:choose>
               <xsl:when test="number($open) eq 1">
                  <xsl:if test="$mode eq 'dynamic'">
                     <xsl:text> wc_magic wc_dynamic</xsl:text>
                  </xsl:if>
               </xsl:when>
               <xsl:when test="($mode eq 'lazy') or ($mode eq 'eager') or ($mode eq 'dynamic')">
                  <xsl:text> wc_magic</xsl:text>
                  <xsl:if test="$mode eq 'dynamic'">
                     <xsl:text> wc_dynamic</xsl:text>
                  </xsl:if>
               </xsl:when>
            </xsl:choose>
         </xsl:attribute>
         <xsl:if test="number($open) ne 1">
            <xsl:attribute name="hidden">
               <xsl:text>hidden</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="($mode eq 'lazy') or ($mode eq 'eager') or ($mode eq 'dynamic')">
            <xsl:attribute name="data-wc-ajaxalias">
               <xsl:value-of select="../@id"/>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="../@disabled or $tabset/@disabled">
            <xsl:attribute name="aria-disabled">
               <xsl:text>true</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="$tabset/@contentHeight">
            <xsl:attribute name="style">
               <xsl:value-of select="concat('height:',$tabset/@contentHeight,';overflow-y:auto;')"/>
            </xsl:attribute>
         </xsl:if>
         <xsl:apply-templates/>
      </div>
   </xsl:template>
   <xsl:template match="ui:text">
      <xsl:variable name="class">
         <xsl:text>wc-text</xsl:text>
         <xsl:if test="@type">
            <xsl:value-of select="concat(' wc-text-type-', @type)"/>
         </xsl:if>
         <xsl:if test="@class">
            <xsl:value-of select="concat(' ', @class)"/>
         </xsl:if>
      </xsl:variable>
      <xsl:choose>
         <xsl:when test="@space eq 'paragraphs'">
            <div class="{$class}">
               <xsl:apply-templates mode="para">
                  <xsl:with-param name="type" select="@type"/>
               </xsl:apply-templates>
            </div>
         </xsl:when>
         <xsl:when test="@space">
            <pre class="{$class}">
               <xsl:apply-templates mode="pre">
                  <xsl:with-param name="type" select="@type"/>
               </xsl:apply-templates>
            </pre>
         </xsl:when>
         <xsl:otherwise>
            <xsl:variable name="elementType">
               <xsl:call-template name="WStyledTextGetElementFromType">
                  <xsl:with-param name="type" select="@type"/>
               </xsl:call-template>
            </xsl:variable>
            <xsl:element name="{$elementType}">
               <xsl:attribute name="class">
                  <xsl:value-of select="$class"/>
               </xsl:attribute>
               <xsl:apply-templates/>
            </xsl:element>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xsl:template match="ui:nl"/>
   <xsl:template match="ui:textarea[@readOnly]">
      <xsl:variable name="element">
         <xsl:choose>
            <xsl:when test="ui:rtf">div</xsl:when>
            <xsl:otherwise>pre</xsl:otherwise>
         </xsl:choose>
      </xsl:variable>
      <xsl:element name="{$element}">
         <xsl:attribute name="id">
            <xsl:value-of select="@id"/>
         </xsl:attribute>
         <xsl:attribute name="class">
            <xsl:value-of select="normalize-space(concat('wc-textarea wc-ro-input ', @class))"/>
         </xsl:attribute>
         <xsl:attribute name="data-wc-component">
            <xsl:value-of select="local-name()"/>
         </xsl:attribute>
         <xsl:if test="@hidden">
            <xsl:attribute name="hidden">
               <xsl:text>hidden</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:choose>
            <xsl:when test="ui:rtf">
               <xsl:apply-templates/>
            </xsl:when>
            <xsl:otherwise>
               <xsl:apply-templates xml:space="preserve"/>
            </xsl:otherwise>
         </xsl:choose>
      </xsl:element>
   </xsl:template>
   <xsl:template match="ui:textarea">
      <xsl:variable name="tickerId" select="concat(@id, '_tick')"/>
      <xsl:variable name="element">
         <xsl:choose>
            <xsl:when test="ui:rtf">
               <xsl:text>div</xsl:text>
            </xsl:when>
            <xsl:otherwise>
               <xsl:text>span</xsl:text>
            </xsl:otherwise>
         </xsl:choose>
      </xsl:variable>
      <xsl:element name="{$element}">
         <xsl:attribute name="id">
            <xsl:value-of select="@id"/>
         </xsl:attribute>
         <xsl:attribute name="class">
            <xsl:value-of select="normalize-space(concat('wc-textarea wc-input-wrapper ', @class))"/>
         </xsl:attribute>
         <xsl:if test="@disabled">
            <xsl:attribute name="aria-disabled">
               <xsl:text>true</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="@hidden">
            <xsl:attribute name="hidden">
               <xsl:text>hidden</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <textarea id="{concat(@id, '_input')}" name="{@id}">
            <xsl:if test="@toolTip">
               <xsl:attribute name="title">
                  <xsl:value-of select="@toolTip"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@required">
               <xsl:attribute name="required">
                  <xsl:text>required</xsl:text>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@disabled">
               <xsl:attribute name="disabled">
                  <xsl:text>disabled</xsl:text>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@accessibleText">
               <xsl:attribute name="aria-label">
                  <xsl:value-of select="@accessibleText"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@buttonId">
               <xsl:attribute name="data-wc-submit">
                  <xsl:value-of select="@buttonId"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="ui:fieldindicator">
               <xsl:if test="ui:fieldindicator[@id]">
                  <xsl:attribute name="aria-describedby">
                     <xsl:value-of select="ui:fieldindicator/@id"/>
                  </xsl:attribute>
               </xsl:if>
               <xsl:if test="ui:fieldindicator[@type='error']">
                  <xsl:attribute name="aria-invalid">
                     <xsl:text>true</xsl:text>
                  </xsl:attribute>
               </xsl:if>
            </xsl:if>
            <xsl:if test="(@required or @placeholder) and not(text())">
               <xsl:attribute name="class">
                  <xsl:text>wc-buggyie</xsl:text>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@maxLength">
               <xsl:attribute name="data-wc-maxlength">
                  <xsl:value-of select="@maxLength"/>
               </xsl:attribute>
               <xsl:attribute name="aria-owns">
                  <xsl:value-of select="$tickerId"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@minLength">
               <xsl:attribute name="data-wc-min">
                  <xsl:value-of select="@minLength"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@cols">
               <xsl:attribute name="cols">
                  <xsl:value-of select="@cols"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@rows">
               <xsl:attribute name="rows">
                  <xsl:value-of select="@rows"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@autocomplete">
               <xsl:attribute name="autocomplete">
                  <xsl:value-of select="@autocomplete"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@placeholder">
               <xsl:attribute name="placeholder">
                  <xsl:value-of select="@placeholder"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:value-of select="text()"/>
         </textarea>
         <xsl:if test="@maxLength">
            <output for="{@id}_input"
                    hidden="hidden"
                    id="{$tickerId}"
                    name="{$tickerId}"/>
         </xsl:if>
         <xsl:apply-templates select="ui:fieldindicator"/>
      </xsl:element>
   </xsl:template>
   <xsl:template match="ui:rtf"/>
   <xsl:template match="ui:togglebutton[@readOnly]">
      <span id="{@id}" data-wc-component="togglebutton">
         <xsl:variable name="additional">
            <xsl:value-of select="@class"/>
            <xsl:if test="@selected">
               <xsl:text> wc_ro_sel</xsl:text>
            </xsl:if>
         </xsl:variable>
         <xsl:attribute name="class">
            <xsl:value-of select="normalize-space(concat('wc-togglebutton ', $additional))"/>
         </xsl:attribute>
         <xsl:if test="@hidden">
            <xsl:attribute name="hidden">
               <xsl:text>hidden</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="@toolTip">
            <xsl:attribute name="title">
               <xsl:value-of select="@toolTip"/>
            </xsl:attribute>
         </xsl:if>
         <xsl:attribute name="data-wc-value">
            <xsl:choose>
               <xsl:when test="@selected">
                  <xsl:text>true</xsl:text>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:text>false</xsl:text>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:attribute>
         <xsl:if test="normalize-space(text()) ne ''">
            <span class="wc-togglebutton-text wc-off" id="{@id}-lbl">
               <xsl:value-of select="text()"/>
            </span>
         </xsl:if>
      </span>
   </xsl:template>
   <xsl:template match="ui:togglebutton">
      <span id="{@id}"
            class="{normalize-space(concat('wc-togglebutton wc-input-wrapper ', @class))}">
         <xsl:if test="@disabled">
            <xsl:attribute name="aria-disabled">
               <xsl:text>true</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="@hidden">
            <xsl:attribute name="hidden">
               <xsl:text>hidden</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <button id="{concat(@id, '_input')}"
                 name="{@id}"
                 class="wc-nobutton wc-invite"
                 role="checkbox"
                 type="button"
                 value="true">
            <xsl:if test="@toolTip">
               <xsl:attribute name="title">
                  <xsl:value-of select="@toolTip"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@required">
               <xsl:attribute name="required">
                  <xsl:text>required</xsl:text>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@disabled">
               <xsl:attribute name="disabled">
                  <xsl:text>disabled</xsl:text>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@accessibleText">
               <xsl:attribute name="aria-label">
                  <xsl:value-of select="@accessibleText"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="@buttonId">
               <xsl:attribute name="data-wc-submit">
                  <xsl:value-of select="@buttonId"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="ui:fieldindicator">
               <xsl:if test="ui:fieldindicator[@id]">
                  <xsl:attribute name="aria-describedby">
                     <xsl:value-of select="ui:fieldindicator/@id"/>
                  </xsl:attribute>
               </xsl:if>
               <xsl:if test="ui:fieldindicator[@type='error']">
                  <xsl:attribute name="aria-invalid">
                     <xsl:text>true</xsl:text>
                  </xsl:attribute>
               </xsl:if>
            </xsl:if>
            <xsl:attribute name="aria-checked">
               <xsl:choose>
                  <xsl:when test="@selected">true</xsl:when>
                  <xsl:otherwise>false</xsl:otherwise>
               </xsl:choose>
            </xsl:attribute>
            <xsl:if test="@groupName">
               <xsl:attribute name="data-wc-group">
                  <xsl:value-of select="@groupName"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="normalize-space(text()) ne ''">
               <span class="wc-togglebutton-text wc-off" id="{@id}-lbl">
                  <xsl:value-of select="text()"/>
               </span>
            </xsl:if>
         </button>
         <xsl:apply-templates select="ui:fieldindicator"/>
         <xsl:element name="input">
            <xsl:attribute name="type">
               <xsl:text>hidden</xsl:text>
            </xsl:attribute>
            <xsl:attribute name="name">
               <xsl:value-of select="concat(@id, '-h')"/>
            </xsl:attribute>
            <xsl:attribute name="value">
               <xsl:text>x</xsl:text>
            </xsl:attribute>
            <xsl:if test="@disabled">
               <xsl:attribute name="disabled">
                  <xsl:text>disabled</xsl:text>
               </xsl:attribute>
            </xsl:if>
         </xsl:element>
      </span>
   </xsl:template>
   <xsl:template match="ui:tree">
      <xsl:variable name="additional">
         <xsl:if test="@htree">
            <xsl:text> wc_htree</xsl:text>
         </xsl:if>
      </xsl:variable>
      <div role="tree"
           id="{@id}"
           class="{normalize-space(concat('wc-tree ', @class, $additional))}">
         <xsl:if test="@disabled">
            <xsl:attribute name="aria-disabled">
               <xsl:text>true</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="@hidden">
            <xsl:attribute name="hidden">
               <xsl:text>hidden</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:attribute name="aria-multiselectable">
            <xsl:choose>
               <xsl:when test="@multiple">
                  <xsl:value-of select="@multiple"/>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:text>false</xsl:text>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:attribute>
         <xsl:if test="@mode">
            <xsl:attribute name="data-wc-mode">
               <xsl:value-of select="@mode"/>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="@required">
            <xsl:attribute name="aria-required">
               <xsl:text>true</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="ui:fieldindicator">
            <xsl:if test="ui:fieldindicator[@id]">
               <xsl:attribute name="aria-describedby">
                  <xsl:value-of select="ui:fieldindicator/@id"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="ui:fieldindicator[@type='error']">
               <xsl:attribute name="aria-invalid">
                  <xsl:text>true</xsl:text>
               </xsl:attribute>
            </xsl:if>
         </xsl:if>
         <xsl:variable name="groupId" select="concat(@id, '-content')"/>
         <div role="group"
              class="wc_tree_root"
              id="{$groupId}"
              data-wc-resizedirection="h">
            <xsl:apply-templates select="ui:treeitem">
               <xsl:with-param name="disabled" select="@disabled"/>
            </xsl:apply-templates>
            <xsl:call-template name="resizerbar">
               <xsl:with-param name="groupId" select="$groupId"/>
            </xsl:call-template>
         </div>
      </div>
      <xsl:apply-templates select="ui:fieldindicator"/>
   </xsl:template>
   <xsl:template match="ui:treeitem">
      <xsl:param name="disabled" select="'false'"/>
      <xsl:variable name="element">
         <xsl:choose>
            <xsl:when test="@expandable">
               <xsl:text>div</xsl:text>
            </xsl:when>
            <xsl:otherwise>
               <xsl:text>button</xsl:text>
            </xsl:otherwise>
         </xsl:choose>
      </xsl:variable>
      <xsl:variable name="isButton">
         <xsl:choose>
            <xsl:when test="$element eq 'div'">
               <xsl:number value="0"/>
            </xsl:when>
            <xsl:otherwise>
               <xsl:number value="1"/>
            </xsl:otherwise>
         </xsl:choose>
      </xsl:variable>
      <xsl:element name="{$element}">
         <xsl:attribute name="id">
            <xsl:value-of select="@id"/>
         </xsl:attribute>
         <xsl:attribute name="class">
            <xsl:text>wc-treeitem</xsl:text>
            <xsl:if test="number($isButton) eq 1">
               <xsl:text> wc-nobutton wc-invite</xsl:text>
            </xsl:if>
         </xsl:attribute>
         <xsl:attribute name="role">
            <xsl:text>treeitem</xsl:text>
         </xsl:attribute>
         <xsl:attribute name="aria-selected">
            <xsl:choose>
               <xsl:when test="@selected">
                  <xsl:text>true</xsl:text>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:text>false</xsl:text>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:attribute>
         <xsl:if test="@disabled or $disabled eq 'true'">
            <xsl:choose>
               <xsl:when test="number($isButton) eq 1">
                  <xsl:attribute name="disabled">disabled</xsl:attribute>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:attribute name="aria-disabled">true</xsl:attribute>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:if>
         <xsl:if test="@hidden">
            <xsl:attribute name="hidden">
               <xsl:text>hidden</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:choose>
            <xsl:when test="number($isButton) eq 1">
               <xsl:attribute name="type">
                  <xsl:text>button</xsl:text>
               </xsl:attribute>
               <xsl:attribute name="tabindex">
                  <xsl:text>0</xsl:text>
               </xsl:attribute>
               <xsl:if test="@toolTip">
                  <xsl:attribute name="title">
                     <xsl:value-of select="@toolTip"/>
                  </xsl:attribute>
               </xsl:if>
               <span class="wc_leaf_vopener" aria-hidden="true">
                  <xsl:text>
</xsl:text>
               </span>
               <xsl:call-template name="treeitemContent"/>
            </xsl:when>
            <xsl:otherwise>
               <xsl:attribute name="aria-expanded">
                  <xsl:choose>
                     <xsl:when test="@open and not(@disabled)">
                        <xsl:text>true</xsl:text>
                     </xsl:when>
                     <xsl:otherwise>
                        <xsl:text>false</xsl:text>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:attribute>
               <xsl:variable name="nameButtonId">
                  <xsl:value-of select="concat(@id, '-branch-name')"/>
               </xsl:variable>
               <button class="wc-nobutton wc-invite wc_leaf_vopener"
                       aria-hidden="true"
                       type="button"
                       tabindex="-1">
                  <xsl:variable name="iconclass">
                     <xsl:choose>
                        <xsl:when test="@open and not(@disabled)">fa-caret-down</xsl:when>
                        <xsl:otherwise>fa-caret-right</xsl:otherwise>
                     </xsl:choose>
                  </xsl:variable>
                  <i aria-hidden="true" class="fa {$iconclass}"/>
                  <span class="wc-off">{{#i18n}}tree_toggle_branch{{/i18n}}</span>
               </button>
               <button type="button"
                       class="wc-nobutton wc-invite wc_leaf"
                       id="{$nameButtonId}"
                       aria-controls="{@id}"
                       tabindex="0">
                  <xsl:if test="@toolTip">
                     <xsl:attribute name="title">
                        <xsl:value-of select="@toolTip"/>
                     </xsl:attribute>
                  </xsl:if>
                  <xsl:call-template name="treeitemContent">
                     <xsl:with-param name="isButton" select="1"/>
                  </xsl:call-template>
               </button>
               <xsl:variable name="groupId" select="concat(@id, '-content')"/>
               <div role="group"
                    aria-labelledby="{$nameButtonId}"
                    id="{$groupId}"
                    data-wc-resizedirection="h">
                  <xsl:if test="not(ui:treeitem)">
                     <xsl:attribute name="aria-busy">
                        <xsl:text>true</xsl:text>
                     </xsl:attribute>
                  </xsl:if>
                  <xsl:apply-templates select="ui:treeitem">
                     <xsl:with-param name="disabled">
                        <xsl:choose>
                           <xsl:when test="@disabled or $disabled eq 'true'">
                              <xsl:text>true</xsl:text>
                           </xsl:when>
                           <xsl:otherwise>false</xsl:otherwise>
                        </xsl:choose>
                     </xsl:with-param>
                  </xsl:apply-templates>
                  <xsl:call-template name="resizerbar">
                     <xsl:with-param name="groupId" select="$groupId"/>
                  </xsl:call-template>
               </div>
            </xsl:otherwise>
         </xsl:choose>
      </xsl:element>
   </xsl:template>
   <xsl:template match="ui:version"/>
   <xsl:template match="ui:ajaxtarget" mode="pseudoAjax">
      <xsl:apply-templates/>
   </xsl:template>
   <xsl:template match="*" mode="registerIds">
      <xsl:text>"</xsl:text>
      <xsl:choose>
         <xsl:when test="self::ui:tab">
            <xsl:value-of select="ui:tabcontent/@id"/>
         </xsl:when>
         <xsl:when test="self::ui:collapsible or self::ui:submenu">
            <xsl:value-of select="ui:content/@id"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:value-of select="@id"/>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:text>"</xsl:text>
      <xsl:if test="position() ne last()">
         <xsl:text>,</xsl:text>
      </xsl:if>
   </xsl:template>
   <xsl:template match="*" mode="para">
      <p>
         <xsl:apply-templates select="."/>
         <xsl:if test="following-sibling::node()[1] eq following-sibling::text()[1]">
            <xsl:apply-templates select="following-sibling::text()[1]"/>
         </xsl:if>
      </p>
   </xsl:template>
   <xsl:template match="*" mode="pre">
      <xsl:apply-templates select="."/>
   </xsl:template>
   <xsl:template match="html:link[@rel = 'stylesheet']" mode="inHead">
      <xsl:text>s.add("</xsl:text>
      <xsl:value-of select="@href"/>
      <xsl:if test="@media">
         <xsl:text>","</xsl:text>
         <xsl:value-of select="@media"/>
      </xsl:if>
      <xsl:text>");</xsl:text>
   </xsl:template>
   <xsl:template match="html:link | html:base | html:meta" mode="inHead">
      <xsl:element name="{local-name(.)}">
         <xsl:apply-templates select="@*"/>
      </xsl:element>
   </xsl:template>
   <xsl:template match="ui:ajaxtrigger" mode="JS">
      <xsl:text>{"id":"</xsl:text>
      <xsl:value-of select="@triggerId"/>
      <xsl:text>","oneShot":</xsl:text>
      <xsl:choose>
         <xsl:when test="not(@loadOnce)">
            <xsl:text>false</xsl:text>
         </xsl:when>
         <xsl:otherwise>
            <xsl:text>true</xsl:text>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:text>,"loads":[</xsl:text>
      <xsl:apply-templates select="*"/>
      <xsl:text>]</xsl:text>
      <xsl:if test="@delay">
         <xsl:text>,"delay":</xsl:text>
         <xsl:value-of select="@delay"/>
      </xsl:if>
      <xsl:text>}</xsl:text>
      <xsl:if test="position() ne last()">
         <xsl:text>,</xsl:text>
      </xsl:if>
   </xsl:template>
   <xsl:template match="ui:ajaxtrigger" mode="JSdelay">
      <xsl:text>{"id":"</xsl:text>
      <xsl:value-of select="@triggerId"/>
      <xsl:text>","delay":</xsl:text>
      <xsl:value-of select="@delay"/>
      <xsl:text>}</xsl:text>
      <xsl:if test="position() ne last()">
         <xsl:text>,</xsl:text>
      </xsl:if>
   </xsl:template>
   <xsl:template match="ui:option" mode="checkbleGroupRO">
      <xsl:variable name="labelcontent">
         <xsl:choose>
            <xsl:when test="normalize-space(.)">
               <xsl:value-of select="."/>
            </xsl:when>
            <xsl:when test="@value">
               <xsl:value-of select="@value"/>
            </xsl:when>
         </xsl:choose>
      </xsl:variable>
      <xsl:variable name="class">
         <xsl:text>wc-option</xsl:text>
         <xsl:if test="count(../ui:option) lt 2">
            <xsl:text> wc-inline</xsl:text>
         </xsl:if>
      </xsl:variable>
      <span class="{$class}">
         <xsl:value-of select="$labelcontent"/>
      </span>
   </xsl:template>
   <xsl:template match="ui:option" mode="checkbleGroup">
      <xsl:param name="type"/>
      <xsl:variable name="labelcontent">
         <xsl:choose>
            <xsl:when test="normalize-space(.)">
               <xsl:value-of select="."/>
            </xsl:when>
            <xsl:when test="@value">
               <xsl:value-of select="@value"/>
            </xsl:when>
         </xsl:choose>
      </xsl:variable>
      <label class="wc-option">
         <xsl:element name="input">
            <xsl:attribute name="type">
               <xsl:value-of select="$type"/>
            </xsl:attribute>
            <xsl:attribute name="name">
               <xsl:value-of select="../@id"/>
            </xsl:attribute>
            <xsl:attribute name="value">
               <xsl:value-of select="@value"/>
            </xsl:attribute>
            <xsl:attribute name="id">
               <xsl:value-of select="generate-id()"/>
            </xsl:attribute>
            <xsl:if test="@selected">
               <xsl:attribute name="checked">checked</xsl:attribute>
            </xsl:if>
            <xsl:if test="../@disabled">
               <xsl:attribute name="disabled">
                  <xsl:text>disabled</xsl:text>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="../@submitOnChange">
               <xsl:attribute name="class">
                  <xsl:text>wc_soc</xsl:text>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="parent::ui:radiobuttonselect">
               <xsl:if test="../@required">
                  <xsl:attribute name="required">
                     <xsl:text>required</xsl:text>
                  </xsl:attribute>
               </xsl:if>
               <xsl:if test="@isNull">
                  <xsl:attribute name="data-wc-null">
                     <xsl:text>1</xsl:text>
                  </xsl:attribute>
               </xsl:if>
            </xsl:if>
         </xsl:element>
         <span class="wc-labeltext">
            <xsl:value-of select="$labelcontent"/>
         </span>
      </label>
   </xsl:template>
   <xsl:template match="ui:option" mode="multiselectPair">
      <option value="{@value}">
         <xsl:value-of select="normalize-space(.)"/>
      </option>
   </xsl:template>
   <xsl:template match="ui:option" mode="comboDataList">
      <xsl:variable name="value" select="."/>
      <span class="wc-invite wc-option"
            data-wc-value="{$value}"
            role="option"
            tabIndex="0">
         <xsl:value-of select="$value"/>
      </span>
   </xsl:template>
   <xsl:template match="ui:option" mode="multiDropDown">
      <xsl:variable name="mdd" select="ancestor::ui:multidropdown"/>
      <xsl:variable name="id" select="$mdd/@id"/>
      <xsl:variable name="selectId" select="concat($id, generate-id(), '-', position())"/>
      <li>
         <label for="{$selectId}" class="wc-off">
            <xsl:value-of select="@title"/>
         </label>
         <select id="{$selectId}" name="{$id}">
            <xsl:if test="$mdd/@submitOnChange">
               <xsl:attribute name="class">
                  <xsl:text>wc_soc</xsl:text>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="$mdd/@disabled">
               <xsl:attribute name="disabled">
                  <xsl:text>disabled</xsl:text>
               </xsl:attribute>
            </xsl:if>
            <xsl:if test="$mdd/@data">
               <xsl:attribute name="data-wc-list">
                  <xsl:value-of select="$mdd/@data"/>
               </xsl:attribute>
            </xsl:if>
            <xsl:apply-templates mode="mfcInList" select="$mdd/*">
               <xsl:with-param name="selectedOption" select="."/>
            </xsl:apply-templates>
         </select>
         <xsl:variable name="toolTip">
            <xsl:choose>
               <xsl:when test="position() eq 1">
                  <xsl:text>{{#i18n}}mfc_add{{/i18n}}</xsl:text>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:text>{{#i18n}}mfc_remove{{/i18n}}</xsl:text>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:variable>
         <button class="wc_btn_icon wc-invite" title="{$toolTip}" type="button">
            <xsl:attribute name="aria-controls">
               <xsl:choose>
                  <xsl:when test="position() eq 1">
                     <xsl:value-of select="$id"/>
                  </xsl:when>
                  <xsl:otherwise>
                     <xsl:value-of select="$selectId"/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:attribute>
            <xsl:if test="$mdd/@disabled">
               <xsl:attribute name="disabled">
                  <xsl:text>disabled</xsl:text>
               </xsl:attribute>
            </xsl:if>
            <xsl:variable name="iconclass">
               <xsl:text>fa-</xsl:text>
               <xsl:choose>
                  <xsl:when test="position() = 1">plus</xsl:when>
                  <xsl:otherwise>minus</xsl:otherwise>
               </xsl:choose>
               <xsl:text>-square</xsl:text>
            </xsl:variable>
            <i aria-hidden="true" class="fa {$iconclass}"/>
         </button>
      </li>
   </xsl:template>
   <xsl:template match="ui:option" mode="mfcInList">
      <xsl:param name="selectedOption"/>
      <option value="{@value}">
         <xsl:if test=". eq $selectedOption">
            <xsl:attribute name="selected">
               <xsl:text>selected</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="@isNull">
            <xsl:attribute name="data-wc-null">
               <xsl:text>1</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:value-of select="."/>
      </option>
   </xsl:template>
   <xsl:template match="ui:option" mode="selectableList">
      <xsl:variable name="value">
         <xsl:choose>
            <xsl:when test="@value">
               <xsl:value-of select="@value"/>
            </xsl:when>
            <xsl:otherwise>
               <xsl:value-of select="."/>
            </xsl:otherwise>
         </xsl:choose>
      </xsl:variable>
      <option class="wc-option" value="{$value}">
         <xsl:if test="@selected">
            <xsl:attribute name="selected">selected</xsl:attribute>
         </xsl:if>
         <xsl:if test="@isNull">
            <xsl:attribute name="data-wc-null">
               <xsl:text>1</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:value-of select="."/>
      </option>
   </xsl:template>
   <xsl:template match="ui:option" mode="readOnly">
      <xsl:param name="single" select="1"/>
      <xsl:variable name="element">
         <xsl:choose>
            <xsl:when test="number($single) eq 1">span</xsl:when>
            <xsl:otherwise>li</xsl:otherwise>
         </xsl:choose>
      </xsl:variable>
      <xsl:element name="{$element}">
         <xsl:attribute name="class">
            <xsl:text>wc-option</xsl:text>
            <xsl:if test="parent::ui:optgroup">
               <xsl:text> wc_inoptgroup</xsl:text>
            </xsl:if>
         </xsl:attribute>
         <xsl:value-of select="."/>
      </xsl:element>
   </xsl:template>
   <xsl:template match="ui:option" mode="rowsPerPage">
      <xsl:param name="rowsPerPage"/>
      <xsl:variable name="value" select="@value"/>
      <option value="{$value}">
         <xsl:if test="number($rowsPerPage) eq number($value)">
            <xsl:attribute name="selected">
               <xsl:text>selected</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:choose>
            <xsl:when test="number($value) eq 0">
               <xsl:text>{{#i18n}}table_pagination_option_allRows{{/i18n}}</xsl:text>
            </xsl:when>
            <xsl:otherwise>
               <xsl:value-of select="$value"/>
            </xsl:otherwise>
         </xsl:choose>
      </option>
   </xsl:template>
   <xsl:template match="ui:panel" mode="skiplinks">
      <a class="wc-skiplink" href="#{@id}">
         <xsl:value-of select="@title"/>
      </a>
   </xsl:template>
   <xsl:template match="ui:cell" mode="clRow">
      <xsl:param name="align"/>
      <xsl:param name="width"/>
      <xsl:param name="cols" select="0"/>
      <div>
         <xsl:attribute name="class">
            <xsl:text>wc-row</xsl:text>
            <xsl:if test="../@hgap">
               <xsl:call-template name="gapClass">
                  <xsl:with-param name="gap" select="../@hgap"/>
               </xsl:call-template>
            </xsl:if>
            <xsl:if test="contains(../../@class, 'wc-respond')">
               <xsl:text> wc-respond</xsl:text>
            </xsl:if>
         </xsl:attribute>
         <xsl:variable name="additional">
            <xsl:choose>
               <xsl:when test="not($align) or $align eq ''">
                  <xsl:text> wc-align-left</xsl:text>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:value-of select="concat(' wc-align-', $align)"/>
               </xsl:otherwise>
            </xsl:choose>
            <xsl:if test="$width and number($width) ne 0">
               <xsl:value-of select="concat(' wc_col_',$width)"/>
            </xsl:if>
         </xsl:variable>
         <div class="{normalize-space(concat('wc-cell wc-column', $additional))}">
            <xsl:apply-templates/>
         </div>
         <xsl:if test="number($cols) gt 1">
            <xsl:apply-templates select="following-sibling::ui:cell[position() lt number($cols)]"
                                 mode="clInRow"/>
         </xsl:if>
      </div>
   </xsl:template>
   <xsl:template match="ui:cell" mode="clInRow">
      <xsl:variable name="colPos" select="position() + 1"/>
      <xsl:variable name="myColumn" select="../ui:column[position() eq number($colPos)]"/>
      <xsl:variable name="align" select="$myColumn/@align"/>
      <xsl:variable name="width" select="$myColumn/@width"/>
      <xsl:variable name="additional">
         <xsl:choose>
            <xsl:when test="not($align) or $align eq ''">
               <xsl:text> wc-align-left</xsl:text>
            </xsl:when>
            <xsl:otherwise>
               <xsl:value-of select="concat(' wc-align-', $align)"/>
            </xsl:otherwise>
         </xsl:choose>
         <xsl:if test="$width and number($width) ne 0">
            <xsl:value-of select="concat(' wc_col_',$width)"/>
         </xsl:if>
      </xsl:variable>
      <div class="{normalize-space(concat('wc-cell wc-column', $additional))}">
         <xsl:apply-templates/>
      </div>
   </xsl:template>
   <xsl:template match="ui:cell" mode="fl">
      <div class="wc-cell">
         <xsl:apply-templates/>
      </div>
   </xsl:template>
   <xsl:template match="ui:cell" mode="gl">
      <xsl:param name="cols" select="1"/>
      <xsl:param name="colWidth"/>
      <xsl:choose>
         <xsl:when test="number($cols) eq 1">
            <xsl:call-template name="gridCell"/>
         </xsl:when>
         <xsl:otherwise>
            <div>
               <xsl:attribute name="class">
                  <xsl:text>wc_gl_row</xsl:text>
                  <xsl:if test="../@hgap">
                     <xsl:call-template name="gapClass">
                        <xsl:with-param name="gap" select="../@hgap"/>
                     </xsl:call-template>
                  </xsl:if>
               </xsl:attribute>
               <xsl:call-template name="gridCell">
                  <xsl:with-param name="width" select="$colWidth"/>
               </xsl:call-template>
               <xsl:if test="number($cols) gt 1">
                  <xsl:apply-templates mode="inRow"
                                       select="following-sibling::ui:cell[position() lt number($cols)]">
                     <xsl:with-param name="width" select="$colWidth"/>
                  </xsl:apply-templates>
               </xsl:if>
            </div>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xsl:template match="ui:cell" mode="inRow">
      <xsl:param name="width"/>
      <xsl:call-template name="gridCell">
         <xsl:with-param name="width" select="$width"/>
      </xsl:call-template>
   </xsl:template>
   <xsl:template match="ui:cell" mode="ll">
      <xsl:if test="node()">
         <li>
            <xsl:apply-templates/>
         </li>
      </xsl:if>
   </xsl:template>
   <xsl:template match="ui:file" mode="columns">
      <xsl:param name="rows" select="0"/>
      <ul class="wc_list_nb wc_filelist wc-column wc-vgap-small">
         <xsl:call-template name="fileInList"/>
         <xsl:apply-templates select="following-sibling::ui:file[position() lt number($rows)]"/>
      </ul>
   </xsl:template>
   <xsl:template match="ui:optgroup" mode="multiselectPair">
      <xsl:param name="applyWhich" select="'all'"/>
      <optgroup label="{@label}">
         <xsl:choose>
            <xsl:when test="$applyWhich eq 'selected'">
               <xsl:apply-templates mode="multiselectPair" select="ui:option[@selected]"/>
            </xsl:when>
            <xsl:when test="$applyWhich eq 'unselected'">
               <xsl:apply-templates mode="multiselectPair" select="ui:option[not(@selected)]"/>
            </xsl:when>
            <xsl:otherwise>
               <xsl:apply-templates mode="multiselectPair"/>
            </xsl:otherwise>
         </xsl:choose>
      </optgroup>
   </xsl:template>
   <xsl:template match="ui:optgroup" mode="comboDataList">
      <xsl:apply-templates mode="comboDataList"/>
   </xsl:template>
   <xsl:template match="ui:optgroup" mode="mfcInList">
      <xsl:param name="selectedOption"/>
      <optgroup label="{@label}">
         <xsl:apply-templates mode="mfcInList" select="ui:option">
            <xsl:with-param name="selectedOption" select="$selectedOption"/>
         </xsl:apply-templates>
      </optgroup>
   </xsl:template>
   <xsl:template match="ui:optgroup" mode="selectableList">
      <optgroup label="{@label}" class="wc-optgroup">
         <xsl:apply-templates mode="selectableList"/>
      </optgroup>
   </xsl:template>
   <xsl:template match="ui:optgroup" mode="readOnly">
      <li class="wc-optgroup">
         <xsl:value-of select="@label"/>
      </li>
      <xsl:apply-templates select="ui:option" mode="readOnly">
         <xsl:with-param name="single" select="0"/>
      </xsl:apply-templates>
   </xsl:template>
   <xsl:template match="ui:selecttoggle" mode="JS">
      <xsl:text>{"identifier":"</xsl:text>
      <xsl:value-of select="@id"/>
      <xsl:text>","groupName":"</xsl:text>
      <xsl:value-of select="@target"/>
      <xsl:text>"}</xsl:text>
      <xsl:if test="position() ne last()">
         <xsl:text>,</xsl:text>
      </xsl:if>
   </xsl:template>
   <xsl:template match="ui:rowselection" mode="JS">
      <xsl:text>{"identifier":"</xsl:text>
      <xsl:value-of select="concat(../@id,'_tb','_st')"/>
      <xsl:text>","groupName":"</xsl:text>
      <xsl:value-of select="concat(../@id,'_tb')"/>
      <xsl:text>"}</xsl:text>
      <xsl:if test="position() ne last()">
         <xsl:text>,</xsl:text>
      </xsl:if>
   </xsl:template>
   <xsl:template match="ui:application/ui:param" mode="get">
      <xsl:value-of select="concat(@name,'=',@value)"/>
      <xsl:if test="position() ne last()">
         <xsl:text>&amp;</xsl:text>
      </xsl:if>
   </xsl:template>
   <xsl:template match="ui:css" mode="inHead">
      <xsl:text>s.add("</xsl:text>
      <xsl:value-of select="@url"/>
      <xsl:text>");</xsl:text>
   </xsl:template>
   <xsl:template match="ui:js" mode="inHead">
      <script type="text/javascript" src="{@url}" async="async"/>
   </xsl:template>
   <xsl:template match="ui:content" mode="collapsible">
      <xsl:param name="class" select="''"/>
      <xsl:param name="ajaxId" select="''"/>
      <xsl:param name="labelId" select="''"/>
      <div class="{normalize-space(concat('wc-section ', $class))}">
         <xsl:if test="@id">
            <xsl:attribute name="id">
               <xsl:value-of select="@id"/>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="$ajaxId ne ''">
            <xsl:attribute name="data-wc-ajaxalias">
               <xsl:value-of select="$ajaxId"/>
            </xsl:attribute>
            <xsl:attribute name="aria-live">
               <xsl:text>polite</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="$labelId ne ''">
            <xsl:attribute name="aria-describedby">
               <xsl:value-of select="$labelId"/>
            </xsl:attribute>
         </xsl:if>
         <xsl:apply-templates/>
      </div>
   </xsl:template>
   <xsl:template match="ui:content" mode="passthru">
      <xsl:apply-templates/>
   </xsl:template>
   <xsl:template match="ui:content" mode="submenu">
      <xsl:variable name="mode" select="../@mode"/>
      <xsl:variable name="isAjaxMode">
         <xsl:choose>
            <xsl:when test="$mode eq 'dynamic' or $mode eq 'eager' or ($mode eq 'lazy' and not(../@open = 'true'))">
               <xsl:number value="1"/>
            </xsl:when>
            <xsl:otherwise>
               <xsl:number value="0"/>
            </xsl:otherwise>
         </xsl:choose>
      </xsl:variable>
      <xsl:variable name="additional">
         <xsl:if test="number($isAjaxMode) eq 1">
            <xsl:text> wc_magic</xsl:text>
            <xsl:if test="$mode eq 'dynamic'">
               <xsl:text> wc_dynamic</xsl:text>
            </xsl:if>
         </xsl:if>
      </xsl:variable>
      <div id="{@id}"
           arial-labelledby="{concat(../@id, '_o')}"
           role="menu"
           class="{normalize-space(concat('wc-content wc_submenucontent', $additional))}">
         <xsl:if test="number($isAjaxMode) eq 1">
            <xsl:attribute name="data-wc-ajaxalias">
               <xsl:value-of select="../@id"/>
            </xsl:attribute>
         </xsl:if>
         <xsl:attribute name="aria-expanded">
            <xsl:choose>
               <xsl:when test="../@open = 'true'">
                  <xsl:text>true</xsl:text>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:text>false</xsl:text>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:attribute>
         <xsl:if test="not(*)">
            <xsl:attribute name="aria-busy">
               <xsl:text>true</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:apply-templates select="*"/>
      </div>
   </xsl:template>
   <xsl:template match="ui:dialog" mode="JS">
      <xsl:text>{"id":"</xsl:text>
      <xsl:value-of select="@id"/>
      <xsl:text>"</xsl:text>
      <xsl:if test="@class">
         <xsl:text>,"className":"</xsl:text>
         <xsl:value-of select="@class"/>
         <xsl:text>"</xsl:text>
      </xsl:if>
      <xsl:if test="@width">
         <xsl:text>,"width":</xsl:text>
         <xsl:value-of select="@width"/>
      </xsl:if>
      <xsl:if test="@height">
         <xsl:text>,"height":</xsl:text>
         <xsl:value-of select="@height"/>
      </xsl:if>
      <xsl:if test="@modal">
         <xsl:text>,"modal":</xsl:text>
         <xsl:value-of select="@modal"/>
      </xsl:if>
      <xsl:if test="@title">
         <xsl:text>,"title":"</xsl:text>
         <xsl:value-of select="@title" disable-output-escaping="yes"/>
         <xsl:text>"</xsl:text>
      </xsl:if>
      <xsl:if test="@triggerid or ./html:button">
         <xsl:text>,"triggerid":"</xsl:text>
         <xsl:choose>
            <xsl:when test="html:button">
               <xsl:value-of select="html:button/@id"/>
            </xsl:when>
            <xsl:otherwise>
               <xsl:value-of select="@triggerid"/>
            </xsl:otherwise>
         </xsl:choose>
         <xsl:text>"</xsl:text>
      </xsl:if>
      <xsl:if test="@open">
         <xsl:text>,"open":true</xsl:text>
      </xsl:if>
      <xsl:text>}</xsl:text>
      <xsl:if test="position() ne last()">
         <xsl:text>,</xsl:text>
      </xsl:if>
   </xsl:template>
   <xsl:template match="ui:message" mode="fieldindicator">
      <span class="wc-message">
         <xsl:apply-templates/>
      </span>
   </xsl:template>
   <xsl:template match="html:wc-imageedit" mode="JS">
      <xsl:text>{"id":"</xsl:text>
      <xsl:value-of select="@id"/>
      <xsl:text>"</xsl:text>
      <xsl:if test="@class">
         <xsl:text>,"className":</xsl:text>
         <xsl:value-of select="@class"/>
      </xsl:if>
      <xsl:if test="@width">
         <xsl:text>,"width":</xsl:text>
         <xsl:value-of select="@width"/>
      </xsl:if>
      <xsl:if test="@height">
         <xsl:text>,"height":</xsl:text>
         <xsl:value-of select="@height"/>
      </xsl:if>
      <xsl:if test="@camera">
         <xsl:text>,"camera":</xsl:text>
         <xsl:value-of select="@camera"/>
      </xsl:if>
      <xsl:if test="@face">
         <xsl:text>,"face":</xsl:text>
         <xsl:value-of select="@face"/>
      </xsl:if>
      <xsl:if test="@overlay">
         <xsl:text>,"overlay":"</xsl:text>
         <xsl:value-of select="@overlay"/>
         <xsl:text>"</xsl:text>
      </xsl:if>
      <xsl:if test="@inline">
         <xsl:text>,"inline":</xsl:text>
         <xsl:value-of select="@inline"/>
      </xsl:if>
      <xsl:if test="@image">
         <xsl:text>,"image":"</xsl:text>
         <xsl:value-of select="@image"/>
         <xsl:text>"</xsl:text>
      </xsl:if>
      <xsl:text>}</xsl:text>
      <xsl:if test="position() ne last()">
         <xsl:text>,</xsl:text>
      </xsl:if>
   </xsl:template>
   <xsl:template match="ui:margin" mode="asclass">
      <xsl:choose>
         <xsl:when test="@all">
            <xsl:call-template name="margin">
               <xsl:with-param name="gap" select="@all"/>
               <xsl:with-param name="extension" select="'all-'"/>
            </xsl:call-template>
         </xsl:when>
         <xsl:otherwise>
            <xsl:if test="@north">
               <xsl:call-template name="margin">
                  <xsl:with-param name="gap" select="@north"/>
                  <xsl:with-param name="extension" select="'n-'"/>
               </xsl:call-template>
            </xsl:if>
            <xsl:if test="@east">
               <xsl:call-template name="margin">
                  <xsl:with-param name="gap" select="@east"/>
                  <xsl:with-param name="extension" select="'e-'"/>
               </xsl:call-template>
            </xsl:if>
            <xsl:if test="@south">
               <xsl:call-template name="margin">
                  <xsl:with-param name="gap" select="@south"/>
                  <xsl:with-param name="extension" select="'s-'"/>
               </xsl:call-template>
            </xsl:if>
            <xsl:if test="@west">
               <xsl:call-template name="margin">
                  <xsl:with-param name="gap" select="@west"/>
                  <xsl:with-param name="extension" select="'w-'"/>
               </xsl:call-template>
            </xsl:if>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xsl:template match="ui:value" mode="readOnly">
      <li>
         <xsl:value-of select="."/>
      </li>
   </xsl:template>
   <xsl:template match="ui:popup" mode="JS">
      <xsl:text>["</xsl:text>
      <xsl:value-of select="@url"/>
      <xsl:text>","</xsl:text>
      <xsl:choose>
         <xsl:when test="@targetWindow">
            <xsl:value-of select="@targetWindow"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:value-of select="generate-id(.)"/>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:text>","</xsl:text>
      <xsl:if test="@top or @left or @width or @height or @showMenuBar or @showToolbar or @showLocation or @showStatus">
         <xsl:if test="@top">
            <xsl:value-of select="concat('top=',@top,'px,')"/>
         </xsl:if>
         <xsl:if test="@left">
            <xsl:value-of select="concat('left=',@left,'px,')"/>
         </xsl:if>
         <xsl:if test="@width">
            <xsl:value-of select="concat('width=',@width,'px,')"/>
         </xsl:if>
         <xsl:if test="@height">
            <xsl:value-of select="concat('height=',@height,'px,')"/>
         </xsl:if>
         <xsl:choose>
            <xsl:when test="@showMenubar">
               <xsl:text>menubar=yes,</xsl:text>
            </xsl:when>
            <xsl:otherwise>
               <xsl:text>menubar=no,</xsl:text>
            </xsl:otherwise>
         </xsl:choose>
         <xsl:choose>
            <xsl:when test="@showToolbar">
               <xsl:text>toolbar=yes,</xsl:text>
            </xsl:when>
            <xsl:otherwise>
               <xsl:text>toolbar=no,</xsl:text>
            </xsl:otherwise>
         </xsl:choose>
         <xsl:choose>
            <xsl:when test="@showLocation">
               <xsl:text>location=yes,</xsl:text>
            </xsl:when>
            <xsl:otherwise>
               <xsl:text>location=no,</xsl:text>
            </xsl:otherwise>
         </xsl:choose>
         <xsl:choose>
            <xsl:when test="@showStatus">
               <xsl:text>status=yes,</xsl:text>
            </xsl:when>
            <xsl:otherwise>
               <xsl:text>status=no,</xsl:text>
            </xsl:otherwise>
         </xsl:choose>
         <xsl:text>resizable=yes,</xsl:text>
         <xsl:text>scrollbars=yes</xsl:text>
      </xsl:if>
      <xsl:text>"]</xsl:text>
      <xsl:if test="position() ne last()">
         <xsl:text>,</xsl:text>
      </xsl:if>
   </xsl:template>
   <xsl:template match="ui:redirect" mode="JS">
      <xsl:text>"</xsl:text>
      <xsl:value-of select="@url"/>
      <xsl:text>"</xsl:text>
   </xsl:template>
   <xsl:template match="ui:decoratedlabel" mode="section">
      <xsl:variable name="additional">
         <xsl:value-of select="@class"/>
         <xsl:if test="@type">
            <xsl:value-of select="concat(' wc-decoratedlabel-type-', @type)"/>
         </xsl:if>
      </xsl:variable>
      <header id="{@id}"
              class="{normalize-space(concat('wc-decoratedlabel ', $additional))}">
         <xsl:if test="@hidden">
            <xsl:attribute name="hidden">
               <xsl:text>hidden</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:apply-templates select="ui:labelhead">
            <xsl:with-param name="output" select="'div'"/>
         </xsl:apply-templates>
         <xsl:apply-templates select="ui:labelbody">
            <xsl:with-param name="output" select="'h1'"/>
         </xsl:apply-templates>
         <xsl:apply-templates select="ui:labeltail">
            <xsl:with-param name="output" select="'div'"/>
         </xsl:apply-templates>
      </header>
   </xsl:template>
   <xsl:template match="ui:subordinate" mode="JS">
      <xsl:text>{ id: '</xsl:text>
      <xsl:value-of select="@id"/>
      <xsl:text>', test: function (test){ return </xsl:text>
      <xsl:apply-templates select="ui:and|ui:or|ui:not|ui:condition" mode="subordinate"/>
      <xsl:text>;}, onTrue: [</xsl:text>
      <xsl:apply-templates select="ui:onTrue" mode="JS"/>
      <xsl:text>], onFalse: [</xsl:text>
      <xsl:apply-templates select="ui:onFalse" mode="JS"/>
      <xsl:text>], controllers: [</xsl:text>
      <xsl:apply-templates select="descendant::ui:condition" mode="ids"/>
      <xsl:text>]}</xsl:text>
      <xsl:if test="position() ne last()">
         <xsl:text>,</xsl:text>
      </xsl:if>
   </xsl:template>
   <xsl:template match="ui:and|ui:or|ui:condition|ui:not" mode="subordinate">
      <xsl:if test="preceding-sibling::ui:and|preceding-sibling::ui:or|preceding-sibling::ui:condition|preceding-sibling::ui:not">
         <xsl:choose>
            <xsl:when test="parent::ui:or">
               <xsl:text> || </xsl:text>
            </xsl:when>
            <xsl:otherwise>
               <xsl:text> &amp;&amp; </xsl:text>
            </xsl:otherwise>
         </xsl:choose>
      </xsl:if>
      <xsl:choose>
         <xsl:when test="self::ui:not | self::ui:and | self::ui:or">
            <xsl:if test="self::ui:not">
               <xsl:text>!</xsl:text>
            </xsl:if>
            <xsl:text>(</xsl:text>
            <xsl:apply-templates mode="subordinate"/>
            <xsl:text>)</xsl:text>
         </xsl:when>
         <xsl:when test="self::ui:condition">
            <xsl:variable name="valSlashEscaped">
               <xsl:value-of select="replace(@value, '\\', '\\\\')"/>
            </xsl:variable>
            <xsl:variable name="apo">
               <xsl:text>'</xsl:text>
            </xsl:variable>
            <xsl:variable name="escapo">
               <xsl:text>\\'</xsl:text>
            </xsl:variable>
            <xsl:variable name="valEscaped">
               <xsl:value-of select="replace($valSlashEscaped, $apo, $escapo)"/>
            </xsl:variable>
            <xsl:text>test('</xsl:text>
            <xsl:value-of select="@controller"/>
            <xsl:text>', '</xsl:text>
            <xsl:value-of select="$valEscaped"/>
            <xsl:if test="@operator">
               <xsl:text>', '</xsl:text>
               <xsl:value-of select="@operator"/>
            </xsl:if>
            <xsl:text>')</xsl:text>
         </xsl:when>
      </xsl:choose>
   </xsl:template>
   <xsl:template match="ui:componentGroup" mode="JS">
      <xsl:text>{"name":"</xsl:text>
      <xsl:value-of select="@id"/>
      <xsl:text>","identifiers":[</xsl:text>
      <xsl:apply-templates select="ui:component"/>
      <xsl:text>]}</xsl:text>
      <xsl:if test="position() ne last()">
         <xsl:text>,</xsl:text>
      </xsl:if>
   </xsl:template>
   <xsl:template match="ui:condition" mode="ids">
      <xsl:text>'</xsl:text>
      <xsl:value-of select="@controller"/>
      <xsl:text>'</xsl:text>
      <xsl:if test="position() ne last()">
         <xsl:text>,</xsl:text>
      </xsl:if>
   </xsl:template>
   <xsl:template match="ui:condition" mode="action">
      <xsl:text>{</xsl:text>
      <xsl:if test="@minSelectedRows">
         <xsl:text>"min":</xsl:text>
         <xsl:value-of select="@minSelectedRows"/>
         <xsl:text>,</xsl:text>
      </xsl:if>
      <xsl:if test="@maxSelectedRows">
         <xsl:text>"max":</xsl:text>
         <xsl:value-of select="@maxSelectedRows"/>
         <xsl:text>,</xsl:text>
      </xsl:if>
      <xsl:if test="ancestor::ui:table[1]/ui:pagination">
         <xsl:text>"otherSelected":</xsl:text>
         <xsl:choose>
            <xsl:when test="@selectedOnOther">
               <xsl:value-of select="@selectedOnOther"/>
            </xsl:when>
            <xsl:otherwise>0</xsl:otherwise>
         </xsl:choose>
         <xsl:text>,</xsl:text>
      </xsl:if>
      <xsl:text>"type":"</xsl:text>
      <xsl:value-of select="@type"/>
      <xsl:text>","message":"</xsl:text>
      <xsl:value-of select="@message"/>
      <xsl:text>"}</xsl:text>
      <xsl:if test="position() ne last()">
         <xsl:text>,</xsl:text>
      </xsl:if>
   </xsl:template>
   <xsl:template match="ui:onTrue|ui:onFalse" mode="JS">
      <xsl:text>{type:'</xsl:text>
      <xsl:value-of select="@action"/>
      <xsl:text>', targets:[</xsl:text>
      <xsl:apply-templates select="ui:target" mode="subordinate"/>
      <xsl:text>]}</xsl:text>
      <xsl:if test="position() ne last()">
         <xsl:text>,</xsl:text>
      </xsl:if>
   </xsl:template>
   <xsl:template match="ui:target" mode="subordinate">
      <xsl:text>{id:'</xsl:text>
      <xsl:value-of select="@id"/>
      <xsl:text>', groupId:'</xsl:text>
      <xsl:value-of select="@groupId"/>
      <xsl:text>'}</xsl:text>
      <xsl:if test="position() ne last()">
         <xsl:text>,</xsl:text>
      </xsl:if>
   </xsl:template>
   <xsl:template match="ui:th|ui:td" mode="col">
      <xsl:param name="stripe" select="0"/>
      <xsl:param name="sortCol" select="-1"/>
      <xsl:variable name="class">
         <xsl:if test="number($stripe) eq 1 and position() mod 2 eq 0">
            <xsl:text>wc_table_stripe</xsl:text>
         </xsl:if>
         <xsl:if test="$sortCol and number($sortCol) ge 0 and position() eq number($sortCol) + 1">
            <xsl:text> wc_table_sort_sorted</xsl:text>
         </xsl:if>
      </xsl:variable>
      <col>
         <xsl:if test="$class ne ''">
            <xsl:attribute name="class">
               <xsl:value-of select="normalize-space($class)"/>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="@width">
            <xsl:attribute name="style">
               <xsl:value-of select="concat('width:',@width,'%')"/>
            </xsl:attribute>
         </xsl:if>
      </col>
   </xsl:template>
   <xsl:template match="ui:th" mode="thead">
      <xsl:variable name="tableId" select="../../@id"/>
      <xsl:variable name="sortable">
         <xsl:choose>
            <xsl:when test="@sortable">
               <xsl:number value="1"/>
            </xsl:when>
            <xsl:otherwise>
               <xsl:number value="0"/>
            </xsl:otherwise>
         </xsl:choose>
      </xsl:variable>
      <xsl:variable name="sortControl" select="../../ui:sort"/>
      <xsl:variable name="isSorted">
         <xsl:choose>
            <xsl:when test="$sortable != 1 or not($sortControl)">
               <xsl:number value="0"/>
            </xsl:when>
            <xsl:when test="position() - 1 eq number($sortControl/@col)">
               <xsl:number value="1"/>
            </xsl:when>
            <xsl:otherwise>
               <xsl:number value="0"/>
            </xsl:otherwise>
         </xsl:choose>
      </xsl:variable>
      <xsl:variable name="sortDesc">
         <xsl:choose>
            <xsl:when test="number($sortable) ne 1 or not($sortControl)">
               <xsl:text>false</xsl:text>
            </xsl:when>
            <xsl:otherwise>
               <xsl:value-of select="$sortControl/@descending"/>
            </xsl:otherwise>
         </xsl:choose>
      </xsl:variable>
      <xsl:variable name="additional">
         <xsl:if test="@align">
            <xsl:value-of select="concat(' wc-align-', @align)"/>
         </xsl:if>
      </xsl:variable>
      <th id="{concat($tableId,'_thh', position())}"
          scope="col"
          data-wc-columnidx="{position() - 1}"
          class="{normalize-space(concat('wc-th ', $additional))}">
         <xsl:if test="number($sortable) eq 1 and $sortControl">
            <xsl:attribute name="tabindex">0</xsl:attribute>
            <xsl:if test="number($isSorted) eq 1">
               <xsl:attribute name="sorted">
                  <xsl:if test="$sortDesc eq 'true'">
                     <xsl:text>reversed </xsl:text>
                  </xsl:if>
                  <xsl:text>1</xsl:text>
               </xsl:attribute>
            </xsl:if>
            <xsl:attribute name="aria-sort">
               <xsl:choose>
                  <xsl:when test="number($isSorted) eq 0">
                     <xsl:text>none</xsl:text>
                  </xsl:when>
                  <xsl:when test="$sortDesc eq 'true'">
                     <xsl:text>descending</xsl:text>
                  </xsl:when>
                  <xsl:otherwise>
                     <xsl:text>ascending</xsl:text>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:attribute>
         </xsl:if>
         <xsl:apply-templates select="ui:decoratedlabel">
            <xsl:with-param name="output" select="'div'"/>
         </xsl:apply-templates>
         <xsl:if test="number($sortable) eq 1 and $sortControl">
            <i aria-hidden="true">
               <xsl:attribute name="class">
                  <xsl:text>fa fa-caret-</xsl:text>
                  <xsl:choose>
                     <xsl:when test="number($isSorted) eq 0">
                        <xsl:text>down</xsl:text>
                     </xsl:when>
                     <xsl:when test="$sortDesc eq 'true'">
                        <xsl:text>square-o-down</xsl:text>
                     </xsl:when>
                     <xsl:otherwise>
                        <xsl:text>square-o-up</xsl:text>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:attribute>
            </i>
         </xsl:if>
      </th>
   </xsl:template>
   <xsl:template match="ui:tr" mode="subRowControlIdentifier">
      <xsl:param name="tableId"/>
      <xsl:value-of select="concat($tableId,'_',@rowIndex)"/>
      <xsl:if test="position() ne last()">
         <xsl:value-of select="' '"/>
      </xsl:if>
   </xsl:template>
   <xsl:template match="ui:action" mode="JS">
      <xsl:text>{"trigger":"</xsl:text>
      <xsl:value-of select="html:button/@id"/>
      <xsl:text>"</xsl:text>
      <xsl:if test="ui:condition">
         <xsl:text>,"conditions":[</xsl:text>
         <xsl:apply-templates select="ui:condition" mode="action"/>
         <xsl:text>]</xsl:text>
      </xsl:if>
      <xsl:text>}</xsl:text>
      <xsl:if test="position() ne last()">
         <xsl:text>,</xsl:text>
      </xsl:if>
   </xsl:template>
   <xsl:template match="ui:tab" mode="content">
      <xsl:apply-templates select="ui:tabcontent">
         <xsl:with-param name="tabset" select="parent::ui:tabset"/>
      </xsl:apply-templates>
   </xsl:template>
   <xsl:template match="text()" mode="para">
      <xsl:param name="type" select="'plain'"/>
      <xsl:if test="not(preceding-sibling::node()) or preceding-sibling::node()[1] ne preceding-sibling::*[1]">
         <p>
            <xsl:call-template name="WStyledTextContent">
               <xsl:with-param name="type" select="$type"/>
            </xsl:call-template>
         </p>
      </xsl:if>
   </xsl:template>
   <xsl:template match="text()" mode="space">
      <xsl:param name="space" select="''"/>
      <xsl:param name="type" select="'plain'"/>
      <xsl:param name="class" select="''"/>
      <xsl:choose>
         <xsl:when test="$space eq 'paragraphs'">
            <p class="{$class}">
               <xsl:call-template name="WStyledTextContent">
                  <xsl:with-param name="type" select="$type"/>
               </xsl:call-template>
            </p>
         </xsl:when>
         <xsl:otherwise>
            <xsl:call-template name="WStyledTextContent">
               <xsl:with-param name="type" select="$type"/>
            </xsl:call-template>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xsl:template match="text()" mode="pre">
      <xsl:param name="type" select="'plain'"/>
      <xsl:call-template name="WStyledTextContent">
         <xsl:with-param name="type" select="$type"/>
      </xsl:call-template>
   </xsl:template>
   <xsl:template match="ui:nl" mode="pre">
      <xsl:text>&#xD;
</xsl:text>
   </xsl:template>
   <xsl:template name="faviconHelper">
      <xsl:param name="href" select="''"/>
      <xsl:if test="$href ne ''">
         <link rel="shortcut icon" href="{$href}"/>
      </xsl:if>
   </xsl:template>
   <xsl:template name="cssUrl">
      <xsl:param name="filename"/>
      <xsl:value-of select="$resourceRoot"/>
      <xsl:text>style/</xsl:text>
      <xsl:value-of select="$filename"/>
      <xsl:text>.css?</xsl:text>
      <xsl:value-of select="$cacheBuster"/>
   </xsl:template>
   <xsl:template name="registrationScripts">
      <xsl:variable name="componentGroups" select=".//ui:componentGroup"/>
      <xsl:variable name="dialogs" select=".//ui:dialog"/>
      <xsl:variable name="dataListCombos"
                    select=".//ui:dropdown[@data and @type and not(@readOnly)] | .//ui:suggestions[@data]"/>
      <xsl:variable name="dataListComponents"
                    select=".//ui:dropdown[@data and not(@type) and not(@readOnly)] | .//ui:listbox[@data and not(@readOnly)] | .//ui:shuffler[@data and not(@readOnly)]"/>
      <xsl:variable name="filedrops" select=".//ui:multifileupload[@ajax or @dropzone]"/>
      <xsl:variable name="multiDDData"
                    select=".//ui:multidropdown[@data and not(@readOnly)]"/>
      <xsl:variable name="popups" select=".//ui:popup"/>
      <xsl:variable name="redirects" select=".//ui:redirect"/>
      <xsl:variable name="rtfs" select=".//ui:textarea[ui:rtf]"/>
      <xsl:variable name="subordinates" select=".//ui:subordinate"/>
      <xsl:variable name="eagerness" select="//*[@mode eq 'eager']"/>
      <xsl:variable name="hasAjaxTriggers" select=".//ui:ajaxtrigger"/>
      <xsl:variable name="timeoutWarn" select=".//ui:session[1]"/>
      <xsl:variable name="editors" select=".//html:wc-imageedit"/>
      <xsl:variable name="tableActions" select=".//ui:table/ui:actions/ui:action"/>
      <xsl:variable name="libs">
         <xsl:if test=".//ui:datefield">
            <xsl:text>"wc/ui/numberField","wc/ui/calendar",</xsl:text>
         </xsl:if>
         <xsl:if test=".//ui:dropdown[not(@readOnly)]">
            <xsl:text>"wc/ui/dropdown","wc/ui/selectboxSearch",</xsl:text>
         </xsl:if>
         <xsl:if test=".//ui:error or .//ui:skiplinks or .//ui:link[substring(@url, 1, 1) eq '#']">
            <xsl:text>"wc/ui/internalLink",</xsl:text>
         </xsl:if>
         <xsl:if test=".//ui:fieldlayout">
            <xsl:text>"wc/ui/field",</xsl:text>
         </xsl:if>
         <xsl:if test=".//ui:label or .//ui:fieldset">
            <xsl:text>"wc/ui/label",</xsl:text>
            <xsl:if test=".//ui:label[@what = 'group']">
               <xsl:text>"wc/ui/internalLink",</xsl:text>
            </xsl:if>
         </xsl:if>
         <xsl:if test=".//ui:numberfield[not(@readOnly)]">
            <xsl:text>"wc/ui/numberField",</xsl:text>
         </xsl:if>
         <xsl:if test=".//ui:textarea[not(@readOnly)]">
            <xsl:text>"wc/ui/textArea",</xsl:text>
         </xsl:if>
         <xsl:if test=".//ui:togglebutton[not(@readOnly)]">
            <xsl:text>"wc/ui/checkboxAnalog",</xsl:text>
         </xsl:if>
         <xsl:if test=".//@accessKey">
            <xsl:text>"wc/ui/tooltip",</xsl:text>
         </xsl:if>
         <xsl:if test=".//@buttonId">
            <xsl:text>"wc/ui/defaultSubmit",</xsl:text>
         </xsl:if>
         <xsl:if test=".//ui:checkbox[not(@readOnly)] or .//ui:checkboxselect[not(@readOnly)]">
            <xsl:text>"wc/ui/checkBox",</xsl:text>
            <xsl:if test=".//ui:checkboxselect[not(@readOnly)]">
               <xsl:text>"wc/ui/checkBoxSelect",</xsl:text>
            </xsl:if>
         </xsl:if>
         <xsl:if test=".//ui:collapsible">
            <xsl:text>"wc/ui/collapsible",</xsl:text>
         </xsl:if>
         <xsl:if test=".//ui:collapsibletoggle">
            <xsl:text>"wc/ui/collapsibleToggle",</xsl:text>
         </xsl:if>
         <xsl:if test=".//ui:fileupload">
            <xsl:text>"wc/ui/fileUpload",</xsl:text>
         </xsl:if>
         <xsl:if test=".//ui:multifileupload">
            <xsl:text>"wc/ui/multiFileUploader",</xsl:text>
         </xsl:if>
         <xsl:if test=".//html:img[@data-wc-editor]">
            <xsl:text>"wc/ui/img",</xsl:text>
         </xsl:if>
         <xsl:if test=".//ui:listbox[not(@readOnly)]">
            <xsl:text>"wc/ui/dropdown",</xsl:text>
         </xsl:if>
         <xsl:if test=".//ui:link[@type eq 'button']">
            <xsl:text>"wc/ui/navigationButton",</xsl:text>
         </xsl:if>
         <xsl:if test=".//ui:link[@disabled]">
            <xsl:text>"wc/ui/disabledLink",</xsl:text>
         </xsl:if>
         <xsl:if test=".//ui:menu">
            <xsl:text>"wc/ui/menu",</xsl:text>
         </xsl:if>
         <xsl:if test=".//ui:multidropdown[not(@readOnly)]">
            <xsl:text>"wc/ui/multiFormComponent",</xsl:text>
         </xsl:if>
         <xsl:if test=".//ui:multiselectpair[not(@readOnly)]">
            <xsl:text>"wc/ui/multiSelectPair",</xsl:text>
         </xsl:if>
         <xsl:if test=".//ui:multitextfield[not(@readOnly)]">
            <xsl:text>"wc/ui/multiFormComponent",</xsl:text>
         </xsl:if>
         <xsl:if test=".//html:button[@class and contains(@class, 'wc-printbutton')]">
            <xsl:text>"wc/ui/printButton",</xsl:text>
         </xsl:if>
         <xsl:if test=".//ui:radiobuttonselect[not(@readOnly)] or .//ui:radiobutton[not(@readOnly)]">
            <xsl:text>"wc/ui/radioButtonSelect",</xsl:text>
         </xsl:if>
         <xsl:if test=".//ui:selecttoggle|.//ui:rowselection[@selectAll]">
            <xsl:text>"wc/ui/selectToggle",</xsl:text>
         </xsl:if>
         <xsl:if test=".//ui:shuffler[not(@readOnly)] or .//ui:multiselectpair[@shuffle and not(@readOnly)]">
            <xsl:text>"wc/ui/shuffler",</xsl:text>
         </xsl:if>
         <xsl:if test=".//ui:skiplinks">
            <xsl:text>"wc/ui/skiplinks",</xsl:text>
         </xsl:if>
         <xsl:if test=".//ui:suggestions or .//ui:dropdown[@type and not(@readOnly)]">
            <xsl:text>"wc/ui/comboBox",</xsl:text>
         </xsl:if>
         <xsl:if test=".//ui:table">
            <xsl:text>"wc/ui/table",</xsl:text>
         </xsl:if>
         <xsl:if test=".//ui:tabset">
            <xsl:text>"wc/ui/tabset",</xsl:text>
         </xsl:if>
         <xsl:if test=".//ui:tree">
            <xsl:text>"wc/ui/menu/htreesize",</xsl:text>
         </xsl:if>
         <xsl:if test=".//ui:session">
            <xsl:text>"wc/ui/timeoutWarn",</xsl:text>
         </xsl:if>
         <xsl:if test=".//*[@submitOnChange and not(@readOnly)]">
            <xsl:text>"wc/ui/onchangeSubmit",</xsl:text>
         </xsl:if>
         <xsl:if test=".//@cancel">
            <xsl:text>"wc/ui/cancelButton",</xsl:text>
         </xsl:if>
         <xsl:if test=".//@msg">
            <xsl:text>"wc/ui/confirm",</xsl:text>
         </xsl:if>
         <xsl:if test=".//@unsavedChanges">
            <xsl:text>"wc/ui/cancelUpdate",</xsl:text>
         </xsl:if>
         <xsl:if test=".//*[@mode eq 'dynamic'] or .//*[@mode eq 'lazy']">
            <xsl:text>"wc/ui/containerload",</xsl:text>
         </xsl:if>
         <xsl:text>"wc/ui/onloadFocusControl",</xsl:text>
         <xsl:if test="$isDebug = 1">
            <xsl:text>"wc/debug/common",</xsl:text>
         </xsl:if>
      </xsl:variable>
      <xsl:variable name="normalizedLibs" select="normalize-space($libs)"/>
      <xsl:variable name="rego">
         <xsl:if test="$componentGroups">
            <xsl:text>require(["wc/ui/subordinate"], function(c){c.registerGroups([</xsl:text>
            <xsl:apply-templates select="$componentGroups" mode="JS"/>
            <xsl:text>]);});</xsl:text>
         </xsl:if>
         <xsl:if test="$tableActions">
            <xsl:text>require(["wc/ui/table/action"], function(c){c.register([</xsl:text>
            <xsl:apply-templates select="$tableActions" mode="JS"/>
            <xsl:text>]);});</xsl:text>
         </xsl:if>
         <xsl:if test="$editors">
            <xsl:text>require(["wc/ui/imageEdit"], function(c){c.register([</xsl:text>
            <xsl:apply-templates select="$editors" mode="JS"/>
            <xsl:text>]);});</xsl:text>
         </xsl:if>
         <xsl:if test="$dialogs">
            <xsl:text>require(["wc/ui/dialog"], function(c){c.register([</xsl:text>
            <xsl:apply-templates select="$dialogs" mode="JS"/>
            <xsl:text>]</xsl:text>
            <xsl:text>);});</xsl:text>
         </xsl:if>
         <xsl:if test="$dataListCombos">
            <xsl:text>require(["wc/ui/comboLoader"], function(c){c.register([</xsl:text>
            <xsl:apply-templates select="$dataListCombos" mode="registerIds"/>
            <xsl:text>]);});</xsl:text>
         </xsl:if>
         <xsl:if test="$dataListComponents">
            <xsl:text>require(["wc/ui/selectLoader"], function(c){c.register([</xsl:text>
            <xsl:apply-templates select="$dataListComponents" mode="registerIds"/>
            <xsl:text>]);});</xsl:text>
         </xsl:if>
         <xsl:if test="$filedrops">
            <xsl:text>require(["wc/ui/multiFileUploader"], function(c){c.register([</xsl:text>
            <xsl:apply-templates select="$filedrops" mode="registerIds"/>
            <xsl:text>]);});</xsl:text>
         </xsl:if>
         <xsl:if test="$multiDDData">
            <xsl:text>require(["wc/ui/multiFormComponent"], function(c){c.register([</xsl:text>
            <xsl:apply-templates select="$multiDDData" mode="registerIds"/>
            <xsl:text>]);});</xsl:text>
         </xsl:if>
         <xsl:if test="$popups">
            <xsl:text>require(["wc/ui/popup"], function(c){c.register([</xsl:text>
            <xsl:apply-templates select="$popups" mode="JS"/>
            <xsl:text>])});</xsl:text>
         </xsl:if>
         <xsl:if test="$redirects">
            <xsl:text>require(["wc/ui/redirect"], function(c){c.register(</xsl:text>
            <xsl:apply-templates select="$redirects[1]" mode="JS"/>
            <xsl:text>);});</xsl:text>
         </xsl:if>
         <xsl:if test="$rtfs">
            <xsl:text>require(["wc/ui/rtf"], function(c){c.register([</xsl:text>
            <xsl:apply-templates select="$rtfs" mode="registerIds"/>
            <xsl:text>]);});</xsl:text>
         </xsl:if>
         <xsl:if test="$subordinates">
            <xsl:text>require(["wc/ui/subordinate","wc/ui/SubordinateAction"], function(c){c.register([</xsl:text>
            <xsl:apply-templates select="$subordinates" mode="JS"/>
            <xsl:text>]);});</xsl:text>
         </xsl:if>
         <xsl:if test="$timeoutWarn">
            <xsl:text>require(["wc/ui/timeoutWarn"], function(c){</xsl:text>
            <xsl:text>c.initTimer(</xsl:text>
            <xsl:value-of select="$timeoutWarn/@timeout"/>
            <xsl:if test="$timeoutWarn/@warn">
               <xsl:text>,</xsl:text>
               <xsl:value-of select="$timeoutWarn/@warn"/>
            </xsl:if>
            <xsl:text>);});</xsl:text>
         </xsl:if>
         <xsl:if test="$eagerness">
            <xsl:text>require(["wc/ui/containerload"], function(c){c.register([</xsl:text>
            <xsl:apply-templates select="$eagerness" mode="registerIds"/>
            <xsl:text>]);});</xsl:text>
         </xsl:if>
         <xsl:if test="$hasAjaxTriggers">
            <xsl:text>require(["wc/ui/ajaxRegion","wc/ui/ajax/genericSubscriber"], function(c, s){c.register([</xsl:text>
            <xsl:apply-templates select="$hasAjaxTriggers" mode="JS"/>
            <xsl:text>]);});</xsl:text>
         </xsl:if>
         <xsl:if test="//@defaultFocusId">
            <xsl:text>require(["wc/ui/onloadFocusControl"], function(c){c.register("</xsl:text>
            <xsl:value-of select="//@defaultFocusId[1]"/>
            <xsl:text>");});</xsl:text>
         </xsl:if>
         <xsl:if test="$normalizedLibs ne ''">
            <xsl:text>require([</xsl:text>
            <xsl:value-of select="substring($normalizedLibs, 1, string-length($normalizedLibs) - 1)"/>
            <xsl:text>]);</xsl:text>
         </xsl:if>
      </xsl:variable>
      <xsl:if test="$rego ne ''">
         <xsl:choose>
            <xsl:when test="self::ui:root">
               <xsl:value-of select="$rego"/>
            </xsl:when>
            <xsl:otherwise>
               <xsl:variable name="scriptId" select="concat('wcscript_', generate-id())"/>
               <script type="text/javascript" class="registrationScripts" id="{$scriptId}">
                  <xsl:text>require(["wc/compat/compat!"], function(){</xsl:text>
                  <xsl:text>require(["wc/common"], function(){</xsl:text>
                  <xsl:value-of select="$rego"/>
                  <xsl:text>require(["wc/dom/removeElement"], function(r){ r("</xsl:text>
                  <xsl:value-of select="$scriptId"/>
                  <xsl:text>", true);});</xsl:text>
                  <xsl:text>});});</xsl:text>
               </script>
            </xsl:otherwise>
         </xsl:choose>
      </xsl:if>
   </xsl:template>
   <xsl:template name="gapClass">
      <xsl:param name="gap" select="''"/>
      <xsl:param name="isVGap" select="0"/>
      <xsl:if test="$gap != ''">
         <xsl:text> wc-</xsl:text>
         <xsl:choose>
            <xsl:when test="number($isVGap) eq 1">
               <xsl:text>v</xsl:text>
            </xsl:when>
            <xsl:otherwise>
               <xsl:text>h</xsl:text>
            </xsl:otherwise>
         </xsl:choose>
         <xsl:text>gap-</xsl:text>
         <xsl:value-of select="$gap"/>
      </xsl:if>
   </xsl:template>
   <xsl:template name="gridCell">
      <xsl:param name="width" select="''"/>
      <div class="wc-cell">
         <xsl:if test="$width ne ''">
            <xsl:attribute name="style">
               <xsl:value-of select="concat('width:', $width, ';')"/>
            </xsl:attribute>
         </xsl:if>
         <xsl:apply-templates/>
      </div>
   </xsl:template>
   <xsl:template name="fileInList">
      <li data-wc-containerid="{../@id}" id="{@id}" class="wc-file">
         <xsl:choose>
            <xsl:when test="ui:link">
               <xsl:apply-templates select="ui:link">
                  <xsl:with-param name="imageAltText"
                                  select="concat('Thumbnail for uploaded file: ', @name)"/>
                  <xsl:with-param name="ajax">
                     <xsl:if test="parent::ui:multifileupload[@ajax] and ../@readOnly">
                        <xsl:value-of select="../@id"/>
                     </xsl:if>
                  </xsl:with-param>
               </xsl:apply-templates>
            </xsl:when>
            <xsl:otherwise>
               <xsl:value-of select="concat(@name, ' (', @size, ') ')"/>
               <xsl:text>{{#i18n}}file_size_{{/i18n}}</xsl:text>
            </xsl:otherwise>
         </xsl:choose>
         <xsl:if test="not(../@readOnly)">
            <button class="wc_btn_icon wc-invite"
                    title="{concat('Delete attachment: ', @name)}"
                    type="button">
               <i aria-hidden="true" class="fa fa-trash"/>
            </button>
         </xsl:if>
      </li>
   </xsl:template>
   <xsl:template name="addOldIECSS"/>
   <xsl:template name="listSortControls">
      <xsl:param name="id" select="@id"/>
      <span class="wc_sortcont">
         <xsl:if test="self::ui:multiselectpair">
            <xsl:text> </xsl:text>
         </xsl:if>
         <button aria-controls="{$id}"
                 class="wc_sorter wc_btn_icon wc-invite"
                 type="button"
                 value="top">
            <xsl:attribute name="title">
               <xsl:text>{{#i18n}}shuffle_top{{/i18n}}</xsl:text>
            </xsl:attribute>
            <xsl:if test="@disabled">
               <xsl:attribute name="disabled">
                  <xsl:text>disabled</xsl:text>
               </xsl:attribute>
            </xsl:if>
            <i aria-hidden="true" class="fa fa-fw fa-angle-double-up"/>
         </button>
         <button aria-controls="{$id}"
                 class="wc_sorter wc_btn_icon wc-invite"
                 type="button"
                 value="up">
            <xsl:attribute name="title">
               <xsl:text>{{#i18n}}shuffle_up{{/i18n}}</xsl:text>
            </xsl:attribute>
            <xsl:if test="@disabled">
               <xsl:attribute name="disabled">
                  <xsl:text>disabled</xsl:text>
               </xsl:attribute>
            </xsl:if>
            <i aria-hidden="true" class="fa fa-fw fa-angle-up"/>
         </button>
         <button aria-controls="{$id}"
                 class="wc_sorter wc_btn_icon wc-invite"
                 type="button"
                 value="down">
            <xsl:attribute name="title">
               <xsl:text>{{#i18n}}shuffle_down{{/i18n}}</xsl:text>
            </xsl:attribute>
            <xsl:if test="@disabled">
               <xsl:attribute name="disabled">
                  <xsl:text>disabled</xsl:text>
               </xsl:attribute>
            </xsl:if>
            <i aria-hidden="true" class="fa fa-fw fa-angle-down"/>
         </button>
         <button aria-controls="{$id}"
                 class="wc_sorter wc_btn_icon wc-invite"
                 type="button"
                 value="bottom">
            <xsl:attribute name="title">
               <xsl:text>{{#i18n}}shuffle_bottom{{/i18n}}</xsl:text>
            </xsl:attribute>
            <xsl:if test="@disabled">
               <xsl:attribute name="disabled">
                  <xsl:text>disabled</xsl:text>
               </xsl:attribute>
            </xsl:if>
            <i aria-hidden="true" class="fa fa-fw fa-angle-double-down"/>
         </button>
      </span>
   </xsl:template>
   <xsl:template name="selectToggle">
      <xsl:param name="id" select="@id"/>
      <xsl:param name="name" select="''"/>
      <xsl:param name="for" select="''"/>
      <xsl:param name="selected" select="''"/>
      <xsl:param name="type" select="'text'"/>
      <xsl:variable name="toggleId">
         <xsl:value-of select="$id"/>
         <xsl:if test="not(self::ui:selecttoggle)">
            <xsl:text>_st</xsl:text>
         </xsl:if>
      </xsl:variable>
      <xsl:variable name="baseClass">
         <xsl:value-of select="concat('wc-', local-name(), ' wc_seltog ', @class)"/>
         <xsl:if test="self::ui:selecttoggle">
            <xsl:if test="@type">
               <xsl:value-of select="concat(' wc-selecttoggle-type-', @type)"/>
            </xsl:if>
         </xsl:if>
      </xsl:variable>
      <xsl:choose>
         <xsl:when test="$type eq 'text'">
            <span id="{$toggleId}"
                  role="radiogroup"
                  data-wc-target="{$for}"
                  class="{normalize-space($baseClass)}">
               <xsl:if test="self::ui:selecttoggle">
                  <xsl:if test="@disabled">
                     <xsl:attribute name="aria-disabled">true</xsl:attribute>
                  </xsl:if>
               </xsl:if>
               <xsl:variable name="subClass">
                  <xsl:value-of select="concat('wc_', local-name(.), ' wc_seltog')"/>
               </xsl:variable>
               <xsl:call-template name="toggleElement">
                  <xsl:with-param name="id" select="concat($id,'-all')"/>
                  <xsl:with-param name="name" select="$name"/>
                  <xsl:with-param name="value" select="'all'"/>
                  <xsl:with-param name="class" select="$subClass"/>
                  <xsl:with-param name="text">
                     <xsl:text>{{#i18n}}toggle_all{{/i18n}}</xsl:text>
                  </xsl:with-param>
                  <xsl:with-param name="selected">
                     <xsl:choose>
                        <xsl:when test="$selected eq 'all'">
                           <xsl:number value="1"/>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:number value="0"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </xsl:with-param>
               </xsl:call-template>
               <xsl:call-template name="toggleElement">
                  <xsl:with-param name="id" select="concat($id,'-none')"/>
                  <xsl:with-param name="name" select="$name"/>
                  <xsl:with-param name="value" select="'none'"/>
                  <xsl:with-param name="class" select="$subClass"/>
                  <xsl:with-param name="text">
                     <xsl:text>{{#i18n}}toggle_none{{/i18n}}</xsl:text>
                  </xsl:with-param>
                  <xsl:with-param name="selected">
                     <xsl:choose>
                        <xsl:when test="$selected eq 'none'">
                           <xsl:number value="1"/>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:number value="0"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </xsl:with-param>
               </xsl:call-template>
            </span>
         </xsl:when>
         <xsl:otherwise>
            <button id="{$toggleId}"
                    role="checkbox"
                    type="button"
                    data-wc-target="{$for}"
                    class="{normalize-space(concat($baseClass, '  wc-nobutton wc-invite'))}">
               <xsl:attribute name="aria-checked">
                  <xsl:choose>
                     <xsl:when test="$selected eq 'all'">
                        <xsl:text>true</xsl:text>
                     </xsl:when>
                     <xsl:when test="$selected eq 'some'">
                        <xsl:text>mixed</xsl:text>
                     </xsl:when>
                     <xsl:otherwise>
                        <xsl:text>false</xsl:text>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:attribute>
               <xsl:if test="$name ne ''">
                  <xsl:attribute name="data-wc-name">
                     <xsl:value-of select="$name"/>
                  </xsl:attribute>
               </xsl:if>
               <xsl:if test="self::ui:selecttoggle">
                  <xsl:if test="@disabled">
                     <xsl:attribute name="disabled">
                        <xsl:text>disabled</xsl:text>
                     </xsl:attribute>
                  </xsl:if>
               </xsl:if>
               <xsl:variable name="iconclass">
                  <xsl:text>fa-</xsl:text>
                  <xsl:choose>
                     <xsl:when test="$selected eq 'all'">
                        <xsl:text>check-square-o</xsl:text>
                     </xsl:when>
                     <xsl:when test="$selected eq 'some'">
                        <xsl:text>square</xsl:text>
                     </xsl:when>
                     <xsl:otherwise>
                        <xsl:text>square-o</xsl:text>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:variable>
               <i aria-hidden="true" class="fa {$iconclass}"/>
            </button>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xsl:template name="toggleElement">
      <xsl:param name="id" select="@id"/>
      <xsl:param name="name" select="''"/>
      <xsl:param name="value" select="''"/>
      <xsl:param name="text" select="''"/>
      <xsl:param name="class" select="''"/>
      <xsl:param name="selected" select="0"/>
      <xsl:variable name="localClass">
         <xsl:text>wc-linkbutton</xsl:text>
         <xsl:if test="$class ne ''">
            <xsl:value-of select="concat(' ',$class)"/>
         </xsl:if>
      </xsl:variable>
      <button id="{$id}"
              role="radio"
              class="{$localClass}"
              data-wc-value="{$value}"
              type="button">
         <xsl:if test="$name ne ''">
            <xsl:attribute name="data-wc-name">
               <xsl:value-of select="$name"/>
            </xsl:attribute>
         </xsl:if>
         <xsl:attribute name="aria-checked">
            <xsl:choose>
               <xsl:when test="number($selected) eq 1">
                  <xsl:text>true</xsl:text>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:text>false</xsl:text>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:attribute>
         <xsl:choose>
            <xsl:when test="self::ui:selecttoggle">
               <xsl:if test="@disabled">
                  <xsl:attribute name="disabled">
                     <xsl:text>disabled</xsl:text>
                  </xsl:attribute>
               </xsl:if>
            </xsl:when>
            <xsl:when test="not(self::ui:rowselection)">
               <xsl:variable name="iconclass">
                  <xsl:choose>
                     <xsl:when test="$value eq 'expand'">
                        <xsl:text>fa-plus-square-o</xsl:text>
                     </xsl:when>
                     <xsl:otherwise>
                        <xsl:text>fa-minus-square-o</xsl:text>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:variable>
               <i aria-hidden="true" class="fa {$iconclass}"/>
            </xsl:when>
         </xsl:choose>
         <xsl:value-of select="$text"/>
      </button>
   </xsl:template>
   <xsl:template name="fieldIsCheckRadio">
      <xsl:variable name="labelFor" select="ui:label/@for"/>
      <xsl:variable name="localEl">
         <xsl:if test="ui:label/@for and ui:input//*[@id=$labelFor]">
            <xsl:value-of select="local-name(ui:input//*[@id=$labelFor][1])"/>
         </xsl:if>
      </xsl:variable>
      <xsl:choose>
         <xsl:when test="$localEl eq 'radiobutton' or $localEl eq 'checkbox' or $localEl eq 'selecttoggle'">
            <xsl:number value="1"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:number value="0"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xsl:template name="margin">
      <xsl:param name="gap" select="''"/>
      <xsl:param name="extension"/>
      <xsl:if test="$gap ne ''">
         <xsl:value-of select="concat(' wc-margin-', $extension, $gap)"/>
      </xsl:if>
   </xsl:template>
   <xsl:template name="submenuIcon">
      <xsl:variable name="class">
         <xsl:choose>
            <xsl:when test="@open = 'false'">fa-caret-right</xsl:when>
            <xsl:when test="@open">fa-caret-down</xsl:when>
            <xsl:when test="@nested or @type='column'">fa-caret-right</xsl:when>
            <xsl:otherwise>fa-caret-down</xsl:otherwise>
         </xsl:choose>
      </xsl:variable>
      <i aria-hidden="true" class="fa {$class}"/>
   </xsl:template>
   <xsl:template name="menuRoleIsSelectable">
      <xsl:param name="type"/>
      <xsl:param name="myAncestorMenu"/>
      <xsl:param name="myAncestorSubmenu"/>
      <xsl:choose>
         <xsl:when test="@selectable eq 'false'">
            <xsl:number value="0"/>
         </xsl:when>
         <xsl:when test="@selectable">
            <xsl:number value="1"/>
         </xsl:when>
         <xsl:when test="not($myAncestorMenu or $myAncestorSubmenu)">
            <xsl:number value="0"/>
         </xsl:when>
         <xsl:when test="$myAncestorSubmenu/@selectMode">
            <xsl:number value="1"/>
         </xsl:when>
         <xsl:when test="$myAncestorSubmenu">
            <xsl:number value="0"/>
         </xsl:when>
         <xsl:when test="$myAncestorMenu/@selectMode">
            <xsl:number value="1"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:number value="0"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xsl:template name="clientRowClosedHelper">
      <xsl:param name="myTable"/>
      <xsl:variable name="clientPaginationRows">
         <xsl:choose>
            <xsl:when test="$myTable/ui:pagination/@rowsPerPage">
               <xsl:value-of select="$myTable/ui:pagination/@rowsPerPage"/>
            </xsl:when>
            <xsl:otherwise>
               <xsl:value-of select="$myTable/ui:pagination/@rows"/>
            </xsl:otherwise>
         </xsl:choose>
      </xsl:variable>
      <xsl:variable name="tableCurrentPage" select="$myTable/ui:pagination/@currentPage"/>
      <xsl:variable name="myPosition" select="count(preceding-sibling::ui:tr) + 1"/>
      <xsl:variable name="activeStart"
                    select="($clientPaginationRows * $tableCurrentPage) + 1"/>
      <xsl:choose>
         <xsl:when test="((number($myPosition) lt $activeStart) or (number($myPosition) ge (number($activeStart) + number($clientPaginationRows))))">
            <xsl:number value="1"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:number value="0"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xsl:template name="paginationButton">
      <xsl:param name="title"/>
      <xsl:param name="idSuffix"/>
      <xsl:param name="disabled" select="0"/>
      <xsl:param name="name" select="''"/>
      <button id="{concat(../@id,'.pagination.',$idSuffix)}"
              title="{$title}"
              type="button"
              class="wc_btn_icon wc-invite">
         <xsl:if test="number($disabled) eq 1">
            <xsl:attribute name="disabled">
               <xsl:text>disabled</xsl:text>
            </xsl:attribute>
         </xsl:if>
         <xsl:variable name="iconclass">
            <xsl:text>fa-fw </xsl:text>
            <xsl:choose>
               <xsl:when test="$name eq 'f'">fa-angle-double-left</xsl:when>
               <xsl:when test="$name eq 'p'">fa-angle-left</xsl:when>
               <xsl:when test="$name eq 'n'">fa-angle-right</xsl:when>
               <xsl:otherwise>fa-angle-double-right</xsl:otherwise>
            </xsl:choose>
         </xsl:variable>
         <i aria-hidden="true" class="fa {$iconclass}"/>
      </button>
   </xsl:template>
   <xsl:template name="rowSelectionIcon">
      <xsl:param name="myTable"/>
      <xsl:variable name="iconclass">
         <xsl:text>fa-fw fa-</xsl:text>
         <xsl:choose>
            <xsl:when test="$myTable/ui:rowselection/@multiple">
               <xsl:if test="@selected">check-</xsl:if>
               <xsl:text>square-o</xsl:text>
            </xsl:when>
            <xsl:otherwise>
               <xsl:if test="@selected">dot-</xsl:if>
               <xsl:text>circle-o</xsl:text>
            </xsl:otherwise>
         </xsl:choose>
      </xsl:variable>
      <i aria-hidden="true" class="fa {$iconclass}"/>
   </xsl:template>
   <xsl:template name="topControls">
      <xsl:variable name="id" select="@id"/>
      <xsl:variable name="hasExpandAll">
         <xsl:choose>
            <xsl:when test="ui:rowexpansion/@expandAll and .//ui:subtr[ancestor::ui:table[1]/@id eq $id]">
               <xsl:number value="1"/>
            </xsl:when>
            <xsl:otherwise>
               <xsl:number value="0"/>
            </xsl:otherwise>
         </xsl:choose>
      </xsl:variable>
      <xsl:variable name="hasRowSelection">
         <xsl:choose>
            <xsl:when test="ui:rowselection[@selectAll] and ..//ui:tr[not(@unselectable) and ancestor::ui:table[1]/@id eq $id]">
               <xsl:number value="1"/>
            </xsl:when>
            <xsl:otherwise>
               <xsl:number value="0"/>
            </xsl:otherwise>
         </xsl:choose>
      </xsl:variable>
      <xsl:variable name="hasPagination">
         <xsl:choose>
            <xsl:when test="not(ui:pagination) or not(ui:pagination/@controls) or ui:pagination/@controls eq 'bottom'">
               <xsl:number value="0"/>
            </xsl:when>
            <xsl:when test="ui:pagination">
               <xsl:number value="1"/>
            </xsl:when>
            <xsl:otherwise>
               <xsl:number value="0"/>
            </xsl:otherwise>
         </xsl:choose>
      </xsl:variable>
      <xsl:if test="$hasExpandAll + $hasRowSelection + $hasPagination gt 0">
         <div class="wc_table_top_controls">
            <xsl:if test="number($hasRowSelection) eq 1">
               <div class="wc_table_sel_cont">
                  <xsl:apply-templates select="ui:rowselection"/>
               </div>
            </xsl:if>
            <xsl:if test="number($hasExpandAll) eq 1">
               <div class="wc_table_exp_cont">
                  <xsl:apply-templates select="ui:rowexpansion"/>
               </div>
            </xsl:if>
            <xsl:if test="number($hasPagination) eq 1">
               <div class="wc_table_pag_cont">
                  <xsl:apply-templates select="ui:pagination">
                     <xsl:with-param name="idSuffix" select="'top'"/>
                  </xsl:apply-templates>
               </div>
            </xsl:if>
         </div>
      </xsl:if>
   </xsl:template>
   <xsl:template name="tableBottomControls">
      <xsl:variable name="showPagination">
         <xsl:choose>
            <xsl:when test="ui:pagination and not(ui:pagination/@controls eq 'top')">
               <xsl:number value="1"/>
            </xsl:when>
            <xsl:otherwise>
               <xsl:number value="0"/>
            </xsl:otherwise>
         </xsl:choose>
      </xsl:variable>
      <xsl:if test="ui:actions or number($showPagination) eq 1">
         <div class="wc_table_bottom_controls">
            <xsl:if test="number($showPagination) eq 1">
               <div class="wc_table_pag_cont">
                  <xsl:apply-templates select="ui:pagination"/>
               </div>
            </xsl:if>
            <xsl:if test="ui:actions">
               <xsl:apply-templates select="ui:actions"/>
            </xsl:if>
         </div>
      </xsl:if>
   </xsl:template>
   <xsl:template name="WStyledTextGetElementFromType">
      <xsl:param name="type"/>
      <xsl:choose>
         <xsl:when test="$type eq 'emphasised' or $type eq 'highPriority'">
            <xsl:text>strong</xsl:text>
         </xsl:when>
         <xsl:when test="$type eq 'mediumPriority'">
            <xsl:text>em</xsl:text>
         </xsl:when>
         <xsl:when test="$type eq 'insert'">
            <xsl:text>ins</xsl:text>
         </xsl:when>
         <xsl:when test="$type eq 'delete'">
            <xsl:text>del</xsl:text>
         </xsl:when>
         <xsl:when test="self::ui:text or ($type ne '' and $type ne'plain')">
            <xsl:text>span</xsl:text>
         </xsl:when>
      </xsl:choose>
   </xsl:template>
   <xsl:template name="WStyledTextContent">
      <xsl:param name="type"/>
      <xsl:variable name="innerElem">
         <xsl:call-template name="WStyledTextGetElementFromType">
            <xsl:with-param name="type" select="$type"/>
         </xsl:call-template>
      </xsl:variable>
      <xsl:choose>
         <xsl:when test="$type eq 'plain' or not($type)">
            <xsl:value-of select="."/>
         </xsl:when>
         <xsl:when test="$innerElem ne ''">
            <xsl:element name="{$innerElem}">
               <xsl:value-of select="."/>
            </xsl:element>
         </xsl:when>
         <xsl:otherwise>
            <xsl:value-of select="."/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xsl:template name="treeitemContent">
      <xsl:param name="isButton" select="0"/>
      <span aria-hidden="true" class="wc_leaf_img">
         <xsl:choose>
            <xsl:when test="@imageUrl">
               <img src="{@imageUrl}" alt=""/>
            </xsl:when>
            <xsl:otherwise>
               <xsl:variable name="iconclass">
                  <xsl:choose>
                     <xsl:when test="$isButton = 0">fa-file-o</xsl:when>
                     <xsl:when test="@open">fa-folder-open-o</xsl:when>
                     <xsl:otherwise>fa-folder-o</xsl:otherwise>
                  </xsl:choose>
               </xsl:variable>
               <i aria-hidden="true" class="fa {$iconclass}"/>
            </xsl:otherwise>
         </xsl:choose>
      </span>
      <span class="wc_leaf_name">
         <xsl:value-of select="@label"/>
      </span>
      <span class="wc_leaf_hopener" aria-hidden="true">
         <i aria-hidden="true" class="fa fa-caret-right"/>
      </span>
   </xsl:template>
   <xsl:template name="resizerbar">
      <xsl:param name="groupId"/>
      <span class="wc_branch_resizer" aria-hidden="true">
         <button type="button"
                 class="wc-nobutton wc-invite wc_resize wc_branch_resize_handle"
                 data-wc-resize="{$groupId}">
            <span class="wc-off">{{#i18n}}tree_resize_handle{{/i18n}}</span>
         </button>
      </span>
   </xsl:template>
</xsl:stylesheet>
