/*
 * Decompiled with CFR 0.152.
 */
package com.github.boyaframework.core.persistence;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class Page<T>
implements Iterable<T> {
    protected int pageNo = 1;
    protected int pageSize = 10;
    protected String orderBy = null;
    protected String orderDir = null;
    protected boolean countTotal = true;
    protected List<T> result = null;
    protected long totalCount = -1L;
    protected String jsonResult;

    public Page() {
    }

    public Page(int pageNo, int pageSize) {
        this.pageNo = pageNo;
        this.pageSize = pageSize;
    }

    public Page(int pageNo, int pageSize, String orderBy, String orderDir) {
        this.pageNo = pageNo;
        this.pageSize = pageSize;
        this.orderBy = orderBy;
        this.orderDir = orderDir;
    }

    public int getPageNo() {
        return this.pageNo;
    }

    public void setPageNo(int pageNo) {
        this.pageNo = pageNo;
        if (pageNo < 1) {
            this.pageNo = 1;
        }
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
        if (pageSize < 1) {
            this.pageSize = 1;
        }
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public String getOrderDir() {
        return this.orderDir;
    }

    public void setOrderDir(String orderDir) {
        String[] orderDirs;
        String lowcaseOrderDir = StringUtils.lowerCase((String)orderDir);
        for (String orderDirStr : orderDirs = StringUtils.split((String)lowcaseOrderDir, (char)',')) {
            if (StringUtils.equals((CharSequence)"desc", (CharSequence)orderDirStr) || StringUtils.equals((CharSequence)"asc", (CharSequence)orderDirStr)) continue;
            throw new IllegalArgumentException("\u6392\u5e8f\u65b9\u5411" + orderDirStr + "\u4e0d\u662f\u5408\u6cd5\u503c");
        }
        this.orderDir = lowcaseOrderDir;
    }

    public String getSortStr() {
        String sortStr = "";
        List<Sort> sortList = this.getSort();
        for (int i = 0; i < sortList.size(); ++i) {
            Sort sort = sortList.get(i);
            if (i != 0) {
                sortStr = sortStr + ",";
            }
            sortStr = sortStr + sort.getProperty() + " " + sort.getDir();
        }
        return sortStr;
    }

    public List<Sort> getSort() {
        String[] orderDirs;
        ArrayList orders = Lists.newArrayList();
        if (this.orderBy == null) {
            return orders;
        }
        String[] orderBys = StringUtils.split((String)this.orderBy, (char)',');
        if (orderBys.length != (orderDirs = StringUtils.split((String)this.orderDir, (char)',')).length) {
            throw new IllegalArgumentException("\u5206\u9875\u591a\u91cd\u6392\u5e8f\u53c2\u6570\u4e2d,\u6392\u5e8f\u5b57\u6bb5\u4e0e\u6392\u5e8f\u65b9\u5411\u7684\u4e2a\u6570\u4e0d\u76f8\u7b49");
        }
        for (int i = 0; i < orderBys.length; ++i) {
            orders.add(new Sort(orderBys[i], orderDirs[i]));
        }
        return orders;
    }

    public boolean isOrderBySetted() {
        return StringUtils.isNotBlank((CharSequence)this.orderBy) && StringUtils.isNotBlank((CharSequence)this.orderDir);
    }

    public boolean isCountTotal() {
        return this.countTotal;
    }

    public void setCountTotal(boolean countTotal) {
        this.countTotal = countTotal;
    }

    public int getOffset() {
        return (this.pageNo - 1) * this.pageSize;
    }

    public List<T> getResult() {
        return this.result;
    }

    public void setResult(List<T> result) {
        if (result instanceof com.github.pagehelper.Page) {
            com.github.pagehelper.Page pageList = (com.github.pagehelper.Page)result;
            this.totalCount = pageList.getTotal();
            this.result = pageList.getResult();
        } else {
            this.result = result;
        }
    }

    public long getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(long totalCount) {
        this.totalCount = totalCount;
    }

    @Override
    public Iterator<T> iterator() {
        return this.result.iterator();
    }

    public int getTotalPages() {
        return (int)Math.ceil((double)this.totalCount / (double)this.getPageSize());
    }

    public boolean hasNextPage() {
        return this.getPageNo() + 1 <= this.getTotalPages();
    }

    public boolean isLastPage() {
        return !this.hasNextPage();
    }

    public int getNextPage() {
        if (this.hasNextPage()) {
            return this.getPageNo() + 1;
        }
        return this.getPageNo();
    }

    public boolean hasPrePage() {
        return this.getPageNo() > 1;
    }

    public boolean isFirstPage() {
        return !this.hasPrePage();
    }

    public int getPrePage() {
        if (this.hasPrePage()) {
            return this.getPageNo() - 1;
        }
        return this.getPageNo();
    }

    public List<Integer> getSlider() {
        int count = 5;
        int halfSize = count / 2;
        int totalPage = this.getTotalPages();
        int startPageNo = Math.max(this.getPageNo() - halfSize, 1);
        int endPageNo = Math.min(startPageNo + count - 1, totalPage);
        if (endPageNo - startPageNo < count) {
            startPageNo = Math.max(endPageNo - count, 1);
        }
        ArrayList result = Lists.newArrayList();
        for (int i = startPageNo; i <= endPageNo; ++i) {
            result.add(i);
        }
        return result;
    }

    public String getJsonResult() throws JsonProcessingException {
        ObjectMapper om = new ObjectMapper();
        return om.writeValueAsString(this.getResult());
    }

    public static class Sort {
        public static final String ASC = "asc";
        public static final String DESC = "desc";
        private final String property;
        private final String dir;

        public Sort(String property, String dir) {
            this.property = property;
            this.dir = dir;
        }

        public String getProperty() {
            return this.property;
        }

        public String getDir() {
            return this.dir;
        }
    }
}

