/*
 * Decompiled with CFR 0.152.
 */
package com.github.boyaframework.core.spring;

import com.github.boyaframework.core.persistence.Page;
import com.github.boyaframework.core.spring.PageConfig;
import com.github.pagehelper.PageHelper;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;

public class PageInterceptor {
    public Object doBasicProfiling(ProceedingJoinPoint pjp) throws Throwable {
        Page page = null;
        Object[] args = pjp.getArgs();
        boolean pageable = true;
        int pageSize = 10;
        for (Object arg : args) {
            if (!(arg instanceof Page)) continue;
            Method method = ((MethodSignature)pjp.getSignature()).getMethod();
            Annotation[][] ass = method.getParameterAnnotations();
            for (int i = 0; i < ass.length; ++i) {
                for (int j = 0; j < ass[i].length; ++j) {
                    Annotation a = ass[i][j];
                    if (!(a instanceof PageConfig)) continue;
                    PageConfig pageConfig = (PageConfig)a;
                    pageable = pageConfig.pageable();
                    pageSize = pageConfig.pageSize();
                }
            }
            if (!pageable) break;
            page = (Page)arg;
            page.setPageSize(pageSize);
            break;
        }
        if (page != null) {
            PageHelper.startPage((int)page.getPageNo(), (int)page.getPageSize());
            if (StringUtils.isNotBlank((CharSequence)page.getSortStr())) {
                PageHelper.orderBy((String)page.getSortStr());
            }
        }
        Object object = pjp.proceed();
        return object;
    }
}

