/*
 * Decompiled with CFR 0.152.
 */
package com.github.boyaframework.core.utils;

import com.google.common.collect.Lists;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtils {
    private static final Logger logger = LoggerFactory.getLogger(DateUtils.class);
    private static SimpleDateFormat sdf;
    public static String SHORT_PATTERN;
    public static String DEFAULT_PATTERN;
    public static final String DAY_UNIT = "d";
    public static final String HOUR_UNIT = "h";
    public static final String MINUTE_UNIT = "m";

    public static Date parse(String timeStr) {
        return DateUtils.parse(timeStr, DEFAULT_PATTERN);
    }

    public static Date parse(String timeStr, String pattern) {
        Date result = null;
        sdf = new SimpleDateFormat(pattern);
        try {
            result = sdf.parse(timeStr);
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e.getCause());
        }
        return result;
    }

    public static String getNow() {
        return DateUtils.getNow(DEFAULT_PATTERN);
    }

    public static String getNow(String pattern) {
        return DateUtils.format(new Date(), pattern);
    }

    public static String format(Date date) {
        return DateUtils.format(date, DEFAULT_PATTERN);
    }

    public static String format(Date date, String pattern) {
        sdf = new SimpleDateFormat(pattern);
        return sdf.format(date);
    }

    public static int daysBetween(Date smdate, Date bdate) throws ParseException {
        return DateUtils.daysBetween(smdate, bdate, true);
    }

    public static int daysBetween(Date smdate, Date bdate, boolean includeTody) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        smdate = sdf.parse(sdf.format(smdate));
        bdate = sdf.parse(sdf.format(bdate));
        Calendar cal = Calendar.getInstance();
        cal.setTime(smdate);
        long time1 = cal.getTimeInMillis();
        cal.setTime(bdate);
        long time2 = cal.getTimeInMillis();
        long between_days = (time2 - time1) / 86400000L;
        if (includeTody) {
            ++between_days;
        }
        return Integer.parseInt(String.valueOf(between_days));
    }

    public static Date addDays(Date date, Integer day) {
        return DateUtils.addTime(date, day, DAY_UNIT);
    }

    public static Date addTime(Date startTime, Integer time, String unit) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startTime);
        Integer type = 12;
        switch (unit) {
            case "d": {
                type = 5;
                break;
            }
            case "h": {
                type = 10;
                break;
            }
            case "m": {
                type = 12;
            }
        }
        calendar.add(type, time);
        return calendar.getTime();
    }

    public static Date toDay(Date time) {
        String p = "yyyy-MM-dd";
        String str = DateUtils.format(time, p);
        return DateUtils.parse(str, p);
    }

    public static Map<String, Date> getCurrentYearScope() {
        HashMap<String, Date> data = new HashMap<String, Date>();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        Integer year = calendar.get(1);
        String start = year + "-1-1 00:00:00";
        String end = year + "-12-31 23:59:59";
        data.put("startTime", DateUtils.parse(start));
        data.put("endTime", DateUtils.parse(end));
        return data;
    }

    public static Map<String, Date> getCurrentQuarterScope() {
        HashMap<String, Date> data = new HashMap<String, Date>();
        data.put("startTime", DateUtils.getCurrentQuarterStartTime());
        data.put("endTime", DateUtils.getCurrentQuarterEndTime());
        return data;
    }

    public static Map<String, Date> getCurrentMonthScope() {
        HashMap<String, Date> data = new HashMap<String, Date>();
        data.put("startTime", DateUtils.getCurrentMonthStartTime());
        data.put("endTime", DateUtils.getCurrentMonthEndTime());
        return data;
    }

    public static Map<String, Date> getCurrentWeekScope() {
        HashMap<String, Date> data = new HashMap<String, Date>();
        data.put("startTime", DateUtils.getTimesWeekmorning());
        data.put("endTime", DateUtils.getTimesWeeknight());
        return data;
    }

    public static Date getTimesWeekmorning() {
        Calendar cal = Calendar.getInstance();
        cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
        cal.set(7, 2);
        return cal.getTime();
    }

    public static Date getTimesWeeknight() {
        SimpleDateFormat sdf = new SimpleDateFormat(SHORT_PATTERN);
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtils.getTimesWeekmorning());
        cal.add(7, 7);
        return DateUtils.parse(sdf.format(cal.getTime()) + " 23:59:59");
    }

    public static Date getCurrentQuarterStartTime() {
        Date now = null;
        try {
            now = DateUtils.getQuarterStartTime(DateUtils.getCurrentQuarterNumber());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return now;
    }

    public static Date getCurrentQuarterEndTime() {
        Date now = null;
        try {
            now = DateUtils.getQuarterEndTime(DateUtils.getCurrentQuarterNumber());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return now;
    }

    public static int getCurrentQuarterNumber() {
        Calendar c = Calendar.getInstance();
        int currentMonth = c.get(2) + 1;
        int currentQuarter = 0;
        try {
            if (currentMonth >= 1 && currentMonth <= 3) {
                currentQuarter = 1;
            } else if (currentMonth >= 4 && currentMonth <= 6) {
                currentQuarter = 2;
            } else if (currentMonth >= 7 && currentMonth <= 9) {
                currentQuarter = 3;
            } else if (currentMonth >= 10 && currentMonth <= 12) {
                currentQuarter = 4;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return currentQuarter;
    }

    public static Date getQuarterStartTime(int quarter) {
        SimpleDateFormat sdf = new SimpleDateFormat(SHORT_PATTERN);
        Calendar c = Calendar.getInstance();
        Date now = null;
        try {
            switch (quarter) {
                case 1: {
                    c.set(2, 0);
                    break;
                }
                case 2: {
                    c.set(2, 3);
                    break;
                }
                case 3: {
                    c.set(2, 6);
                    break;
                }
                case 4: {
                    c.set(2, 9);
                    break;
                }
                default: {
                    c.set(2, 0);
                }
            }
            c.set(5, 1);
            now = DateUtils.parse(sdf.format(c.getTime()) + " 00:00:00");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return now;
    }

    public static Date getQuarterEndTime(int quarter) {
        SimpleDateFormat sdf = new SimpleDateFormat(SHORT_PATTERN);
        Calendar c = Calendar.getInstance();
        Date now = null;
        try {
            switch (quarter) {
                case 1: {
                    c.set(2, 2);
                    c.set(5, 31);
                    break;
                }
                case 2: {
                    c.set(2, 5);
                    c.set(5, 30);
                    break;
                }
                case 3: {
                    c.set(2, 8);
                    c.set(5, 30);
                    break;
                }
                case 4: {
                    c.set(2, 11);
                    c.set(5, 31);
                    break;
                }
                default: {
                    c.set(2, 2);
                    c.set(5, 31);
                }
            }
            now = DateUtils.parse(sdf.format(c.getTime()) + " 23:59:59");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return now;
    }

    public static Date getCurrentMonthStartTime() {
        SimpleDateFormat sdf = new SimpleDateFormat(SHORT_PATTERN);
        Calendar c = Calendar.getInstance();
        Date now = null;
        try {
            c.set(5, 1);
            now = DateUtils.parse(sdf.format(c.getTime()) + " 00:00:00");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return now;
    }

    public static Date getCurrentMonthEndTime() {
        Calendar c = Calendar.getInstance();
        Date now = null;
        try {
            now = DateUtils.getMonthEndTime(c.get(2) + 1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return now;
    }

    public static Date getPreviousMonthStartTime() {
        SimpleDateFormat sdf = new SimpleDateFormat(SHORT_PATTERN);
        Calendar c = Calendar.getInstance();
        Date now = null;
        try {
            c.add(2, -1);
            c.set(5, 1);
            now = DateUtils.parse(sdf.format(c.getTime()) + " 00:00:00");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return now;
    }

    public static Date getPreviousMonthEndTime() {
        Calendar c = Calendar.getInstance();
        Date now = null;
        try {
            now = DateUtils.getMonthEndTime(c.get(2));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return now;
    }

    public static Date getMonthStartTime(int month) {
        Calendar c = Calendar.getInstance();
        Date now = null;
        try {
            c.set(2, month - 1);
            c.set(5, 1);
            now = DateUtils.parse(DateUtils.format(c.getTime(), SHORT_PATTERN) + " 00:00:00");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return now;
    }

    public static Date getMonthEndTime(int month) {
        Calendar c = Calendar.getInstance();
        Date now = null;
        try {
            c.set(2, month - 1);
            c.set(5, 1);
            c.add(2, 1);
            c.add(5, -1);
            now = DateUtils.parse(DateUtils.format(c.getTime(), SHORT_PATTERN) + " 23:59:59");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return now;
    }

    public static Date getCurrentDayStartTime() {
        return DateUtils.getDayBeginTimeByDate(new Date());
    }

    public static Date getCurrentDayEndTime() {
        return DateUtils.getDayEndTimeByDate(new Date());
    }

    public static Date getDayBeginTimeByDate(Date date) {
        if (date == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        Date now = null;
        try {
            now = DateUtils.parse(DateUtils.format(c.getTime(), SHORT_PATTERN) + " 00:00:00");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return now;
    }

    public static Date getDayEndTimeByDate(Date date) {
        if (date == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        Date now = null;
        try {
            now = DateUtils.parse(DateUtils.format(c.getTime(), SHORT_PATTERN) + " 23:59:59");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return now;
    }

    public static int getDayNumber(Date date, Date date2, boolean hasSTA, boolean hasSUN) {
        int num = 0;
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtils.getBefore(date, date2));
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(DateUtils.getAfter(date, date2));
        while (cal.compareTo(cal2) <= 0) {
            switch (cal.get(7)) {
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    ++num;
                    break;
                }
                case 7: {
                    if (!hasSTA) break;
                    ++num;
                    break;
                }
                case 1: {
                    if (!hasSUN) break;
                    ++num;
                    break;
                }
            }
            cal.add(5, 1);
        }
        return num;
    }

    public static List<Date> getDayList(Date date, Date date2, boolean hasSTA, boolean hasSUN) {
        ArrayList dateList = Lists.newArrayList();
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtils.getBefore(date, date2));
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(DateUtils.getAfter(date, date2));
        while (cal.compareTo(cal2) <= 0) {
            switch (cal.get(7)) {
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    dateList.add(cal.getTime());
                    break;
                }
                case 7: {
                    if (!hasSTA) break;
                    dateList.add(cal.getTime());
                    break;
                }
                case 1: {
                    if (!hasSUN) break;
                    dateList.add(cal.getTime());
                    break;
                }
            }
            cal.add(5, 1);
        }
        return dateList;
    }

    public static Date getBefore(Date date, Date date2) {
        if (date.before(date2)) {
            return date;
        }
        return date2;
    }

    public static Date getAfter(Date date, Date date2) {
        if (date.after(date2)) {
            return date;
        }
        return date2;
    }

    public static int getDayOfWeek(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(7);
    }

    public static String getDayOfWeekName(Date date, String language) {
        String name = "";
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        switch (cal.get(7)) {
            case 2: {
                name = language.equals("zh") ? "\u661f\u671f\u4e00" : "MON";
                break;
            }
            case 3: {
                name = language.equals("zh") ? "\u661f\u671f\u4e8c" : "TUE";
                break;
            }
            case 4: {
                name = language.equals("zh") ? "\u661f\u671f\u4e09" : "WED";
                break;
            }
            case 5: {
                name = language.equals("zh") ? "\u661f\u671f\u56db" : "THU";
                break;
            }
            case 6: {
                name = language.equals("zh") ? "\u661f\u671f\u4e94" : "FRI";
                break;
            }
            case 7: {
                name = language.equals("zh") ? "\u661f\u671f\u516d" : "STA";
                break;
            }
            case 1: {
                name = language.equals("zh") ? "\u661f\u671f\u65e5" : "SUN";
                break;
            }
        }
        return name;
    }

    public static void main(String[] args) throws ParseException {
        System.out.println(DateUtils.daysBetween(DateUtils.parse("2016-02-13", "yyyy-MM-dd"), DateUtils.parse("2016-02-23", "yyyy-MM-dd")));
    }

    static {
        SHORT_PATTERN = "yyyy-MM-dd";
        DEFAULT_PATTERN = "yyyy-MM-dd HH:mm:ss";
    }
}

