/*
 * Decompiled with CFR 0.152.
 */
package bvanseg.kotlincommons.lang.command.argument;

import bvanseg.kotlincommons.grouping.collection.ListUtilsKt;
import bvanseg.kotlincommons.io.logging.LoggerExtensionsKt;
import bvanseg.kotlincommons.lang.command.CommandDispatcher;
import bvanseg.kotlincommons.lang.command.argument.CommandArgument;
import bvanseg.kotlincommons.lang.command.argument.CommandArguments$WhenMappings;
import bvanseg.kotlincommons.lang.command.argument.CommandFlag;
import bvanseg.kotlincommons.lang.command.context.CommandContext;
import bvanseg.kotlincommons.lang.command.dsl.DSLCommand;
import bvanseg.kotlincommons.lang.command.dsl.node.DSLCommandArgument;
import bvanseg.kotlincommons.lang.command.dsl.node.DSLCommandLiteral;
import bvanseg.kotlincommons.lang.command.dsl.node.DSLCommandNode;
import bvanseg.kotlincommons.lang.command.exception.IllegalTokenTypeException;
import bvanseg.kotlincommons.lang.command.exception.MissingArgumentException;
import bvanseg.kotlincommons.lang.command.exception.MissingTransformerException;
import bvanseg.kotlincommons.lang.command.token.Token;
import bvanseg.kotlincommons.lang.command.token.buffer.ArgumentTokenBuffer;
import bvanseg.kotlincommons.lang.command.token.buffer.FlagTokenBuffer;
import bvanseg.kotlincommons.lang.command.transformer.Transformer;
import bvanseg.kotlincommons.lang.string.ToStringBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.full.KClasses;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 '2\u00020\u0001:\u0001'B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0015J\u0006\u0010\u0017\u001a\u00020\u0015J\u0006\u0010\u0018\u001a\u00020\u0015J\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u000bJ\u0006\u0010\u001a\u001a\u00020\u0013J\u0014\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eJ\u0010\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\u001fH\u0002J\b\u0010%\u001a\u00020&H\u0016R\u0018\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lbvanseg/kotlincommons/lang/command/argument/CommandArguments;", "", "dispatcher", "Lbvanseg/kotlincommons/lang/command/CommandDispatcher;", "command", "Lbvanseg/kotlincommons/lang/command/dsl/DSLCommand;", "context", "Lbvanseg/kotlincommons/lang/command/context/CommandContext;", "(Lbvanseg/kotlincommons/lang/command/CommandDispatcher;Lbvanseg/kotlincommons/lang/command/dsl/DSLCommand;Lbvanseg/kotlincommons/lang/command/context/CommandContext;)V", "arguments", "Ljava/util/LinkedList;", "Lbvanseg/kotlincommons/lang/command/argument/CommandArgument;", "current", "Lbvanseg/kotlincommons/lang/command/dsl/node/DSLCommandNode;", "getCurrent", "()Lbvanseg/kotlincommons/lang/command/dsl/node/DSLCommandNode;", "setCurrent", "(Lbvanseg/kotlincommons/lang/command/dsl/node/DSLCommandNode;)V", "flags", "Lbvanseg/kotlincommons/lang/command/argument/CommandFlag;", "hasArgument", "", "hasFlag", "hasNoArguments", "hasNoFlags", "nextArgument", "nextFlag", "parse", "", "tokens", "", "Lbvanseg/kotlincommons/lang/command/token/Token;", "parseArgument", "tokenBuffer", "Lbvanseg/kotlincommons/lang/command/token/buffer/ArgumentTokenBuffer;", "parseFlag", "token", "toString", "", "Companion", "kotlincommons"})
public final class CommandArguments {
    private final LinkedList<CommandArgument<?>> arguments;
    private final LinkedList<CommandFlag> flags;
    @NotNull
    private DSLCommandNode current;
    private final CommandDispatcher dispatcher;
    private final DSLCommand command;
    private final CommandContext context;
    private static final Logger logger;
    @NotNull
    public static final Companion Companion;

    public final boolean hasArgument() {
        Collection collection = this.arguments;
        boolean bl = false;
        return !collection.isEmpty();
    }

    public final boolean hasNoArguments() {
        return this.arguments.isEmpty();
    }

    @NotNull
    public final CommandArgument<?> nextArgument() {
        CommandArgument<?> commandArgument = this.arguments.removeFirst();
        Intrinsics.checkNotNullExpressionValue(commandArgument, (String)"arguments.removeFirst()");
        return commandArgument;
    }

    public final boolean hasFlag() {
        Collection collection = this.flags;
        boolean bl = false;
        return !collection.isEmpty();
    }

    public final boolean hasNoFlags() {
        return this.flags.isEmpty();
    }

    @NotNull
    public final CommandFlag nextFlag() {
        CommandFlag commandFlag = this.flags.removeFirst();
        Intrinsics.checkNotNullExpressionValue((Object)commandFlag, (String)"flags.removeFirst()");
        return commandFlag;
    }

    @NotNull
    public final DSLCommandNode getCurrent() {
        return this.current;
    }

    public final void setCurrent(@NotNull DSLCommandNode dSLCommandNode) {
        Intrinsics.checkNotNullParameter((Object)dSLCommandNode, (String)"<set-?>");
        this.current = dSLCommandNode;
    }

    public final void parse(@NotNull List<Token> tokens) {
        Intrinsics.checkNotNullParameter(tokens, (String)"tokens");
        Logger $this$debug$iv = logger;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebugEnabled()) {
            Logger logger = $this$debug$iv;
            boolean bl = false;
            String string = "Preparing to parse tokenized parameters to typed arguments: " + tokens;
            logger.debug(string.toString());
        }
        ArgumentTokenBuffer argumentTokenBuffer = new ArgumentTokenBuffer(tokens);
        FlagTokenBuffer flagTokenBuffer = new FlagTokenBuffer(tokens);
        while (argumentTokenBuffer.isNotEmpty()) {
            this.parseArgument(argumentTokenBuffer);
        }
        while (flagTokenBuffer.isNotEmpty()) {
            this.parseFlag(flagTokenBuffer.next());
        }
        logger.debug("Finished parsing tokenized parameters, resetting current command tree level to root.");
        this.current = this.command;
    }

    /*
     * WARNING - void declaration
     */
    private final void parseArgument(ArgumentTokenBuffer tokenBuffer) {
        DSLCommandNode dSLCommandNode;
        Object object;
        Logger $this$trace$iv;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        DSLCommandArgument it;
        void $this$filterTo$iv$iv;
        Object object2;
        Object object3;
        Logger $this$debug$iv = logger;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebugEnabled()) {
            object3 = $this$debug$iv;
            boolean bl = false;
            object2 = "Preparing to parse token '" + tokenBuffer.peek() + "' from token buffer as an argument!";
            object3.debug(object2.toString());
        }
        List<DSLCommandArgument<?>> currentArguments = this.current.getArguments();
        Iterable $this$filter$iv = currentArguments;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (DSLCommandArgument)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual(it.getType(), (Object)Reflection.getOrCreateKotlinClass(String.class)) ^ true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (DSLCommandArgument)item$iv$iv;
            object3 = destination$iv$iv;
            boolean bl3 = false;
            if ((Transformer)this.dispatcher.getTransformers().get(it.getType()) == null) {
                throw (Throwable)new MissingTransformerException("Failed to find registered transformer for type '" + it.getType() + "'.");
            }
            object3.add(object2);
        }
        List transformersForArguments = (List)destination$iv$iv;
        KClass acceptedType = null;
        boolean foundTransformer = false;
        for (Transformer transformer : transformersForArguments) {
            if (!transformer.matches(tokenBuffer, this.context)) continue;
            Object transformedArgument = transformer.parse(tokenBuffer, this.context);
            CommandArgument commandArgument = new CommandArgument(transformedArgument, transformer.getType());
            this.arguments.add(commandArgument);
            acceptedType = transformer.getType();
            foundTransformer = true;
            break;
        }
        Object object4 = this;
        if (!foundTransformer) {
            DSLCommandNode dSLCommandNode2;
            Object v2;
            DSLCommandNode it2;
            Object object5;
            boolean bl;
            Object object6;
            boolean bl22;
            Iterable $i$f$trace22;
            Token token;
            block19: {
                Object object7;
                $this$trace$iv = logger;
                boolean $i$f$trace22 = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    object2 = $this$trace$iv;
                    object3 = object4;
                    boolean bl22 = false;
                    String string = "Failed to find a transformer in " + transformersForArguments + " for token " + tokenBuffer.peek() + ", falling back to String type...";
                    object7 = object3;
                    object2.trace(string.toString());
                }
                acceptedType = Reflection.getOrCreateKotlinClass(String.class);
                token = tokenBuffer.next();
                this.arguments.add(new CommandArgument<String>(token.getValue(), Reflection.getOrCreateKotlinClass(String.class)));
                $i$f$trace22 = this.current.getLiterals();
                object3 = object7;
                bl22 = false;
                object6 = $i$f$trace22;
                bl = false;
                object5 = object6.iterator();
                while (object5.hasNext()) {
                    Object bl3 = object5.next();
                    it2 = (DSLCommandLiteral)bl3;
                    boolean bl4 = false;
                    if (!Intrinsics.areEqual((Object)((DSLCommandLiteral)it2).getLiteralValue(), (Object)token.getValue())) continue;
                    v2 = bl3;
                    break block19;
                }
                v2 = null;
            }
            object2 = v2;
            object = object3;
            DSLCommandLiteral dSLCommandLiteral = (DSLCommandLiteral)object2;
            if (dSLCommandLiteral != null) {
                dSLCommandNode2 = dSLCommandLiteral;
            } else {
                Object v6;
                block20: {
                    $i$f$trace22 = this.current.getArguments();
                    object3 = object;
                    bl22 = false;
                    object6 = $i$f$trace22;
                    bl = false;
                    object5 = object6.iterator();
                    while (object5.hasNext()) {
                        Object bl3 = object5.next();
                        it2 = (DSLCommandArgument)bl3;
                        boolean bl5 = false;
                        if (!Intrinsics.areEqual(((DSLCommandArgument)it2).getType(), acceptedType)) continue;
                        v6 = bl3;
                        break block20;
                    }
                    v6 = null;
                }
                object2 = v6;
                object = object3;
                dSLCommandNode2 = dSLCommandNode = (DSLCommandNode)object2;
            }
            if (dSLCommandNode2 == null) {
                throw (Throwable)new MissingArgumentException("Could not find suitable argument or literal for token value '" + token.getValue() + "'!");
            }
        } else {
            Object object8;
            block21: {
                $this$trace$iv = logger;
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    object2 = $this$trace$iv;
                    object3 = object4;
                    boolean bl = false;
                    StringBuilder stringBuilder = new StringBuilder().append("Successfully found matching transformer of type '");
                    KClass kClass = acceptedType;
                    if (kClass == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"acceptedType");
                    }
                    String string = stringBuilder.append(kClass).append("' in ").append(transformersForArguments).append('!').toString();
                    object4 = object3;
                    object2.trace(string.toString());
                }
                iterable = this.current.getArguments();
                object3 = object4;
                boolean bl = false;
                Iterable iterable2 = iterable;
                boolean bl6 = false;
                for (Object object5 : iterable2) {
                    DSLCommandArgument it3 = (DSLCommandArgument)object5;
                    boolean bl7 = false;
                    KClass kClass = it3.getType();
                    KClass kClass2 = acceptedType;
                    if (kClass2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"acceptedType");
                    }
                    if (!(Intrinsics.areEqual(kClass, kClass2) || KClasses.isSubclassOf(acceptedType, it3.getType()))) continue;
                    object8 = object5;
                    break block21;
                }
                object8 = null;
            }
            object2 = object8;
            object = object3;
            DSLCommandArgument dSLCommandArgument = (DSLCommandArgument)object2;
            if (dSLCommandArgument == null) {
                StringBuilder stringBuilder = new StringBuilder().append("Could not find suitable argument for type '");
                KClass kClass = acceptedType;
                if (kClass == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"acceptedType");
                }
                throw (Throwable)new MissingArgumentException(stringBuilder.append(kClass).append("'!").toString());
            }
            dSLCommandNode = dSLCommandArgument;
        }
        ((CommandArguments)object).current = dSLCommandNode;
    }

    private final void parseFlag(Token token) {
        Logger $this$debug$iv = logger;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebugEnabled()) {
            Logger logger = $this$debug$iv;
            boolean bl = false;
            String string = "Preparing to parse token '" + token + "' from token buffer as a flag!";
            logger.debug(string.toString());
        }
        switch (CommandArguments$WhenMappings.$EnumSwitchMapping$0[token.getTokenType().ordinal()]) {
            case 1: {
                CharSequence $this$forEach$iv = StringsKt.substringAfter$default((String)token.getValue(), (String)"-", null, (int)2, null);
                boolean $i$f$forEach = false;
                CharSequence charSequence = $this$forEach$iv;
                for (int i = 0; i < charSequence.length(); ++i) {
                    char element$iv;
                    char it = element$iv = charSequence.charAt(i);
                    boolean bl = false;
                    this.flags.add(new CommandFlag(String.valueOf(it)));
                }
                break;
            }
            case 2: {
                this.flags.add(new CommandFlag(StringsKt.substringAfter$default((String)token.getValue(), (String)"--", null, (int)2, null)));
                break;
            }
            default: {
                throw (Throwable)new IllegalTokenTypeException("Expected token type to be a flag type but was actually '" + (Object)((Object)token.getTokenType()) + '\'');
            }
        }
    }

    @NotNull
    public String toString() {
        return ToStringBuilder.Companion.builder(Reflection.getOrCreateKotlinClass(this.getClass())).append("arguments", this.arguments).append("flags", this.flags).toString();
    }

    public CommandArguments(@NotNull CommandDispatcher dispatcher, @NotNull DSLCommand command, @NotNull CommandContext context) {
        Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.dispatcher = dispatcher;
        this.command = command;
        this.context = context;
        this.arguments = ListUtilsKt.linkedListOf();
        this.flags = ListUtilsKt.linkedListOf();
        this.current = this.command;
    }

    static {
        Companion = new Companion(null);
        logger = LoggerExtensionsKt.getLogger(Companion);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lbvanseg/kotlincommons/lang/command/argument/CommandArguments$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlincommons"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

