/*
 * Decompiled with CFR 0.152.
 */
package bvanseg.kotlincommons.lang.command.transformer;

import bvanseg.kotlincommons.lang.command.context.CommandContext;
import bvanseg.kotlincommons.lang.command.exception.TransformerParseException;
import bvanseg.kotlincommons.lang.command.token.Token;
import bvanseg.kotlincommons.lang.command.token.buffer.ArgumentTokenBuffer;
import bvanseg.kotlincommons.lang.command.token.buffer.PeekingTokenBuffer;
import bvanseg.kotlincommons.lang.command.transformer.Transformer;
import bvanseg.kotlincommons.math.NumberExtensionsKt;
import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u001a*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001\u001aB9\b\u0016\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00028\u00000\n\u00a2\u0006\u0002\u0010\fB9\b\u0016\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\r\u0012\u0006\u0010\b\u001a\u00020\r\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00028\u00000\n\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001d\u0010\u0017\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00a2\u0006\u0002\u0010\u0019R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00028\u00000\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lbvanseg/kotlincommons/lang/command/transformer/NumberTransformer;", "T", "", "Lbvanseg/kotlincommons/lang/command/transformer/Transformer;", "type", "Lkotlin/reflect/KClass;", "min", "", "max", "stringToNum", "Lkotlin/Function1;", "", "(Lkotlin/reflect/KClass;Ljava/lang/Number;Ljava/lang/Number;Lkotlin/jvm/functions/Function1;)V", "Ljava/math/BigInteger;", "(Lkotlin/reflect/KClass;Ljava/math/BigInteger;Ljava/math/BigInteger;Lkotlin/jvm/functions/Function1;)V", "range", "Lkotlin/ranges/ClosedRange;", "matches", "", "buffer", "Lbvanseg/kotlincommons/lang/command/token/buffer/PeekingTokenBuffer;", "context", "Lbvanseg/kotlincommons/lang/command/context/CommandContext;", "parse", "Lbvanseg/kotlincommons/lang/command/token/buffer/ArgumentTokenBuffer;", "(Lbvanseg/kotlincommons/lang/command/token/buffer/ArgumentTokenBuffer;Lbvanseg/kotlincommons/lang/command/context/CommandContext;)Ljava/lang/Object;", "Companion", "kotlincommons"})
public abstract class NumberTransformer<T>
extends Transformer<T> {
    private final ClosedRange<BigInteger> range;
    private final Function1<String, T> stringToNum;
    @NotNull
    private static final Regex REGEX;
    @NotNull
    public static final Companion Companion;

    @Override
    public boolean matches(@NotNull PeekingTokenBuffer buffer, @NotNull CommandContext context) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = buffer.peek();
        if (object != null && (object = ((Token)object).getValue()) != null) {
            CharSequence charSequence = (CharSequence)object;
            Regex regex = REGEX;
            boolean bl2 = false;
            bl = regex.matches(charSequence);
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public T parse(@NotNull ArgumentTokenBuffer buffer, @NotNull CommandContext context) {
        String text;
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string = text = buffer.next().getValue();
        boolean bl = false;
        BigInteger bigInt = new BigInteger(string);
        if (!this.range.contains((Comparable)bigInt)) {
            throw (Throwable)new TransformerParseException("Value '" + bigInt + "' does not fall within the range of (" + NumberExtensionsKt.format((Number)((Object)this.range.getStart())) + " to " + NumberExtensionsKt.format((Number)((Object)this.range.getEndInclusive())) + ')');
        }
        return (T)this.stringToNum.invoke((Object)text);
    }

    public NumberTransformer(@NotNull KClass<T> type, @NotNull Number min, @NotNull Number max, @NotNull Function1<? super String, ? extends T> stringToNum) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)min, (String)"min");
        Intrinsics.checkNotNullParameter((Object)max, (String)"max");
        Intrinsics.checkNotNullParameter(stringToNum, (String)"stringToNum");
        long l = min.longValue();
        boolean bl = false;
        BigInteger bigInteger = BigInteger.valueOf(l);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"BigInteger.valueOf(this)");
        l = max.longValue();
        bl = false;
        BigInteger bigInteger2 = BigInteger.valueOf(l);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"BigInteger.valueOf(this)");
        this(type, bigInteger, bigInteger2, stringToNum);
    }

    public NumberTransformer(@NotNull KClass<T> type, @NotNull BigInteger min, @NotNull BigInteger max, @NotNull Function1<? super String, ? extends T> stringToNum) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)min, (String)"min");
        Intrinsics.checkNotNullParameter((Object)max, (String)"max");
        Intrinsics.checkNotNullParameter(stringToNum, (String)"stringToNum");
        super(type);
        this.range = RangesKt.rangeTo((Comparable)min, (Comparable)max);
        this.stringToNum = stringToNum;
    }

    static {
        Companion = new Companion(null);
        REGEX = new Regex("^[+-]?\\d+$");
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lbvanseg/kotlincommons/lang/command/transformer/NumberTransformer$Companion;", "", "()V", "REGEX", "Lkotlin/text/Regex;", "getREGEX", "()Lkotlin/text/Regex;", "kotlincommons"})
    public static final class Companion {
        @NotNull
        public final Regex getREGEX() {
            return REGEX;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

