/*
 * Decompiled with CFR 0.152.
 */
package bvanseg.kotlincommons.lang.command;

import bvanseg.kotlincommons.io.logging.LoggerExtensionsKt;
import bvanseg.kotlincommons.lang.command.CommandDispatchResult;
import bvanseg.kotlincommons.lang.command.CommandDispatcher;
import bvanseg.kotlincommons.lang.command.argument.CommandArguments;
import bvanseg.kotlincommons.lang.command.context.CommandContext;
import bvanseg.kotlincommons.lang.command.dsl.DSLCommand;
import bvanseg.kotlincommons.lang.command.event.CommandFireEvent;
import bvanseg.kotlincommons.lang.command.token.TokenParser;
import bvanseg.kotlincommons.lang.command.transformer.Transformer;
import bvanseg.kotlincommons.lang.command.transformer.impl.ArgumentTokenBufferTransformer;
import bvanseg.kotlincommons.lang.command.transformer.impl.BigDecimalTransformer;
import bvanseg.kotlincommons.lang.command.transformer.impl.BigIntegerTransformer;
import bvanseg.kotlincommons.lang.command.transformer.impl.ColorTransformer;
import bvanseg.kotlincommons.lang.command.transformer.impl.StringBuilderTransformer;
import bvanseg.kotlincommons.lang.command.transformer.impl.TokenTransformer;
import bvanseg.kotlincommons.lang.command.transformer.impl.URLTransformer;
import bvanseg.kotlincommons.lang.command.transformer.impl.UUIDTransformer;
import bvanseg.kotlincommons.lang.command.transformer.impl.primitive.BooleanTransformer;
import bvanseg.kotlincommons.lang.command.transformer.impl.primitive.ByteTransformer;
import bvanseg.kotlincommons.lang.command.transformer.impl.primitive.CharTransformer;
import bvanseg.kotlincommons.lang.command.transformer.impl.primitive.DoubleTransformer;
import bvanseg.kotlincommons.lang.command.transformer.impl.primitive.FloatTransformer;
import bvanseg.kotlincommons.lang.command.transformer.impl.primitive.IntTransformer;
import bvanseg.kotlincommons.lang.command.transformer.impl.primitive.LongTransformer;
import bvanseg.kotlincommons.lang.command.transformer.impl.primitive.ShortTransformer;
import bvanseg.kotlincommons.lang.command.transformer.impl.primitive.UByteTransformer;
import bvanseg.kotlincommons.lang.command.transformer.impl.primitive.UIntTransformer;
import bvanseg.kotlincommons.lang.command.transformer.impl.primitive.ULongTransformer;
import bvanseg.kotlincommons.lang.command.transformer.impl.primitive.UShortTransformer;
import bvanseg.kotlincommons.lang.command.transformer.impl.time.ChronoUnitTransformer;
import bvanseg.kotlincommons.lang.command.transformer.impl.time.DayOfWeekTransformer;
import bvanseg.kotlincommons.lang.command.transformer.impl.time.InstantTransformer;
import bvanseg.kotlincommons.lang.command.transformer.impl.time.KhronoTransformer;
import bvanseg.kotlincommons.lang.command.transformer.impl.time.KhronoUnitTransformer;
import bvanseg.kotlincommons.lang.command.transformer.impl.time.LocalDateTimeTransformer;
import bvanseg.kotlincommons.lang.command.transformer.impl.time.LocalDateTransformer;
import bvanseg.kotlincommons.lang.command.transformer.impl.time.LocalTimeTransformer;
import bvanseg.kotlincommons.lang.command.transformer.impl.time.MonthTransformer;
import bvanseg.kotlincommons.lang.command.transformer.impl.time.OffsetDateTimeTransformer;
import bvanseg.kotlincommons.lang.command.transformer.impl.time.TimeUnitTransformer;
import bvanseg.kotlincommons.util.event.EventBus;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u0000 &2\u00020\u0001:\u0001&B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0018\u001a\u00020\u00032\b\b\u0002\u0010\u0019\u001a\u00020\u001aJ\"\u0010\u0017\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00032\b\b\u0002\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001c\u001a\u00020\u0003J\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000b0\u001eJ\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u000bJ\"\u0010\"\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00142\n\u0010#\u001a\u0006\u0012\u0002\b\u00030\u00142\b\b\u0002\u0010$\u001a\u00020\u0005J.\u0010\"\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00142\n\u0010%\u001a\u0006\u0012\u0002\b\u00030\u00132\n\u0010#\u001a\u0006\u0012\u0002\b\u00030\u00142\b\b\u0002\u0010$\u001a\u00020\u0005R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R%\u0010\u0012\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0013\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006'"}, d2={"Lbvanseg/kotlincommons/lang/command/CommandDispatcher;", "", "prefix", "", "capsInsensitive", "", "(Ljava/lang/String;Z)V", "getCapsInsensitive", "()Z", "commands", "Ljava/util/concurrent/ConcurrentMap;", "Lbvanseg/kotlincommons/lang/command/dsl/DSLCommand;", "eventBus", "Lbvanseg/kotlincommons/util/event/EventBus;", "getEventBus", "()Lbvanseg/kotlincommons/util/event/EventBus;", "getPrefix", "()Ljava/lang/String;", "transformers", "Lkotlin/reflect/KClass;", "Lbvanseg/kotlincommons/lang/command/transformer/Transformer;", "getTransformers", "()Ljava/util/concurrent/ConcurrentMap;", "execute", "input", "commandContext", "Lbvanseg/kotlincommons/lang/command/context/CommandContext;", "getCommandByName", "name", "getCommands", "", "registerCommand", "", "command", "registerTransformer", "transformer", "overwrite", "type", "Companion", "kotlincommons"})
public final class CommandDispatcher {
    private final ConcurrentMap<String, DSLCommand> commands;
    @NotNull
    private final EventBus eventBus;
    @NotNull
    private final ConcurrentMap<KClass<?>, Transformer<?>> transformers;
    @NotNull
    private final String prefix;
    private final boolean capsInsensitive;
    @NotNull
    private static final Logger logger;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final EventBus getEventBus() {
        return this.eventBus;
    }

    @NotNull
    public final ConcurrentMap<KClass<?>, Transformer<?>> getTransformers() {
        return this.transformers;
    }

    @Nullable
    public final Object execute(@NotNull String input, @NotNull CommandContext commandContext) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)commandContext, (String)"commandContext");
        return this.execute(this.prefix, input, commandContext);
    }

    public static /* synthetic */ Object execute$default(CommandDispatcher commandDispatcher, String string, CommandContext commandContext, int n, Object object) {
        if ((n & 2) != 0) {
            commandContext = new CommandContext(commandDispatcher);
        }
        return commandDispatcher.execute(string, commandContext);
    }

    @Nullable
    public final Object execute(@NotNull String prefix, @NotNull String input, @NotNull CommandContext commandContext) {
        DSLCommand command;
        String commandReference;
        String string;
        boolean bl;
        Logger logger;
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)commandContext, (String)"commandContext");
        Logger $this$trace$iv = CommandDispatcher.logger;
        boolean $i$f$trace22 = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            bl = false;
            string = "Executing command with input '" + input + "'...";
            logger.trace(string.toString());
        }
        if (StringsKt.isBlank((CharSequence)input)) {
            return CommandDispatchResult.INVALID_INPUT;
        }
        if (!StringsKt.startsWith$default((String)input, (String)prefix, (boolean)false, (int)2, null)) {
            return CommandDispatchResult.INVALID_INPUT;
        }
        String $i$f$trace22 = input;
        bl = false;
        String trimmedInput = ((Object)StringsKt.trim((CharSequence)$i$f$trace22)).toString();
        List parts = StringsKt.split$default((CharSequence)trimmedInput, (String[])new String[]{" "}, (boolean)false, (int)2, (int)2, null);
        String string2 = commandReference = (String)parts.get(0);
        int n = prefix.length();
        int n2 = commandReference.length();
        boolean bl2 = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String commandName = string4;
        if (this.capsInsensitive) {
            string2 = commandName;
            n = 0;
            String string5 = string2;
            if (string5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string6 = string5.toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).toLowerCase()");
            commandName = string6;
        }
        if ((command = (DSLCommand)this.commands.get(commandName)) == null) {
            Logger $this$debug$iv = CommandDispatcher.logger;
            boolean $i$f$debug = false;
            if ($this$debug$iv.isDebugEnabled()) {
                logger = $this$debug$iv;
                boolean bl3 = false;
                string = "Attempted to execute input for command '" + commandName + "' but no such command exists.";
                logger.debug(string.toString());
            }
            return CommandDispatchResult.UNKNOWN_COMMAND;
        }
        boolean hasArguments = parts.size() > 1;
        commandContext.setRawInput(input);
        commandContext.setSplitRawInput(parts);
        if (hasArguments) {
            String arguments = (String)parts.get(1);
            TokenParser tokenParser = new TokenParser(arguments);
            commandContext.setTokenizedArguments(tokenParser.getAllTokens());
        } else {
            commandContext.setTokenizedArguments(CollectionsKt.emptyList());
        }
        CommandArguments commandArguments = new CommandArguments(this, command, commandContext);
        commandArguments.parse(commandContext.getTokenizedArguments());
        CommandFireEvent.PRE event = new CommandFireEvent.PRE(command, commandContext, this);
        this.eventBus.fire(event);
        if (event.isCancelled()) {
            return CommandDispatchResult.COMMAND_FIRING_CANCELLED;
        }
        Object result = command.run(commandArguments, commandContext);
        this.eventBus.fire(new CommandFireEvent.POST(command, commandContext, this));
        return result;
    }

    public static /* synthetic */ Object execute$default(CommandDispatcher commandDispatcher, String string, String string2, CommandContext commandContext, int n, Object object) {
        if ((n & 4) != 0) {
            commandContext = new CommandContext(commandDispatcher);
        }
        return commandDispatcher.execute(string, string2, commandContext);
    }

    @NotNull
    public final Map<String, DSLCommand> getCommands() {
        return this.commands;
    }

    @Nullable
    public final DSLCommand getCommandByName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return (DSLCommand)this.commands.get(name);
    }

    public final void registerCommand(@NotNull DSLCommand command) {
        String string;
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        if (this.capsInsensitive) {
            String string2 = command.getName();
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.toLowerCase();
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
        } else {
            string = command.getName();
        }
        String name = string;
        this.commands.compute(name, new BiFunction<String, DSLCommand, DSLCommand>(name, command){
            final /* synthetic */ String $name;
            final /* synthetic */ DSLCommand $command;

            @Nullable
            public final DSLCommand apply(String $noName_0, @Nullable DSLCommand cmd) {
                if (cmd != null) {
                    Logger $this$warn$iv = CommandDispatcher.Companion.getLogger();
                    boolean $i$f$warn = false;
                    if ($this$warn$iv.isWarnEnabled()) {
                        Logger logger = $this$warn$iv;
                        boolean bl = false;
                        String string = "Attempting to register a command under name '" + this.$name + "' but a command under that name already exists!";
                        logger.warn(string.toString());
                    }
                }
                return this.$command;
            }
            {
                this.$name = string;
                this.$command = dSLCommand;
            }
        });
        Iterable $this$forEach$iv = command.getAliases();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String string5;
            String it = (String)element$iv;
            boolean bl = false;
            if (this.capsInsensitive) {
                String string6 = it;
                boolean bl2 = false;
                String string7 = string6;
                if (string7 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string8 = string7.toLowerCase();
                string5 = string8;
                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"(this as java.lang.String).toLowerCase()");
            } else {
                string5 = it;
            }
            String alias = string5;
            this.commands.compute(alias, new BiFunction<String, DSLCommand, DSLCommand>(alias, this, name, command){
                final /* synthetic */ String $alias;
                final /* synthetic */ CommandDispatcher this$0;
                final /* synthetic */ String $name$inlined;
                final /* synthetic */ DSLCommand $command$inlined;
                {
                    this.$alias = string;
                    this.this$0 = commandDispatcher;
                    this.$name$inlined = string2;
                    this.$command$inlined = dSLCommand;
                }

                @Nullable
                public final DSLCommand apply(String $noName_0, @Nullable DSLCommand aliasedCommand) {
                    if (aliasedCommand != null) {
                        Logger $this$warn$iv = CommandDispatcher.Companion.getLogger();
                        boolean $i$f$warn = false;
                        if ($this$warn$iv.isWarnEnabled()) {
                            Logger logger = $this$warn$iv;
                            boolean bl = false;
                            String string = "Attempting to register a command with name '" + this.$name$inlined + "' under alias '" + this.$alias + "' but a command under that alias already exists!";
                            logger.warn(string.toString());
                        }
                    }
                    return this.$command$inlined;
                }
            });
        }
        Logger $this$info$iv = logger;
        boolean $i$f$info = false;
        if ($this$info$iv.isInfoEnabled()) {
            Logger logger = $this$info$iv;
            boolean bl = false;
            String string9 = "Registered command with name '" + command.getName() + "' and aliases " + CollectionsKt.joinToString$default((Iterable)command.getAliases(), null, null, null, (int)0, null, (Function1)registerCommand.3.1.INSTANCE, (int)31, null) + '.';
            logger.info(string9.toString());
        }
    }

    @Nullable
    public final Transformer<?> registerTransformer(@NotNull Transformer<?> transformer, boolean overwrite) {
        Intrinsics.checkNotNullParameter(transformer, (String)"transformer");
        return this.registerTransformer(transformer.getType(), transformer, overwrite);
    }

    public static /* synthetic */ Transformer registerTransformer$default(CommandDispatcher commandDispatcher, Transformer transformer, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return commandDispatcher.registerTransformer(transformer, bl);
    }

    @Nullable
    public final Transformer<?> registerTransformer(@NotNull KClass<?> type, @NotNull Transformer<?> transformer, boolean overwrite) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter(transformer, (String)"transformer");
        return this.transformers.compute(type, new BiFunction<KClass<?>, Transformer<?>, Transformer<?>>(overwrite, type, transformer){
            final /* synthetic */ boolean $overwrite;
            final /* synthetic */ KClass $type;
            final /* synthetic */ Transformer $transformer;

            @Nullable
            public final Transformer<?> apply(KClass<?> $noName_0, @Nullable Transformer<?> value) {
                if (value != null && !this.$overwrite) {
                    Logger $this$warn$iv = CommandDispatcher.Companion.getLogger();
                    boolean $i$f$warn = false;
                    if ($this$warn$iv.isWarnEnabled()) {
                        Logger logger = $this$warn$iv;
                        boolean bl = false;
                        String string = "Attempted to register a transformer for type '" + this.$type + "' but it already exists! Set 'overwrite' to 'true' during registration to overwrite the existing transformer.";
                        logger.warn(string.toString());
                    }
                    return value;
                }
                Logger $this$info$iv = CommandDispatcher.Companion.getLogger();
                boolean $i$f$info = false;
                if ($this$info$iv.isInfoEnabled()) {
                    Logger logger = $this$info$iv;
                    boolean bl = false;
                    String string = "Registered transformer for type '" + this.$type + "'.";
                    logger.info(string.toString());
                }
                return this.$transformer;
            }
            {
                this.$overwrite = bl;
                this.$type = kClass;
                this.$transformer = transformer;
            }
        });
    }

    public static /* synthetic */ Transformer registerTransformer$default(CommandDispatcher commandDispatcher, KClass kClass, Transformer transformer, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return commandDispatcher.registerTransformer(kClass, transformer, bl);
    }

    @NotNull
    public final String getPrefix() {
        return this.prefix;
    }

    public final boolean getCapsInsensitive() {
        return this.capsInsensitive;
    }

    public CommandDispatcher(@NotNull String prefix, boolean capsInsensitive) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        this.prefix = prefix;
        this.capsInsensitive = capsInsensitive;
        this.commands = new ConcurrentHashMap();
        this.eventBus = new EventBus();
        this.transformers = new ConcurrentHashMap();
        CommandDispatcher.registerTransformer$default(this, CharTransformer.INSTANCE, false, 2, null);
        CommandDispatcher.registerTransformer$default(this, BooleanTransformer.INSTANCE, false, 2, null);
        CommandDispatcher.registerTransformer$default(this, ByteTransformer.INSTANCE, false, 2, null);
        CommandDispatcher.registerTransformer$default(this, ShortTransformer.INSTANCE, false, 2, null);
        CommandDispatcher.registerTransformer$default(this, IntTransformer.INSTANCE, false, 2, null);
        CommandDispatcher.registerTransformer$default(this, LongTransformer.INSTANCE, false, 2, null);
        CommandDispatcher.registerTransformer$default(this, FloatTransformer.INSTANCE, false, 2, null);
        CommandDispatcher.registerTransformer$default(this, DoubleTransformer.INSTANCE, false, 2, null);
        CommandDispatcher.registerTransformer$default(this, UByteTransformer.INSTANCE, false, 2, null);
        CommandDispatcher.registerTransformer$default(this, UShortTransformer.INSTANCE, false, 2, null);
        CommandDispatcher.registerTransformer$default(this, UIntTransformer.INSTANCE, false, 2, null);
        CommandDispatcher.registerTransformer$default(this, ULongTransformer.INSTANCE, false, 2, null);
        CommandDispatcher.registerTransformer$default(this, ArgumentTokenBufferTransformer.INSTANCE, false, 2, null);
        CommandDispatcher.registerTransformer$default(this, BigDecimalTransformer.INSTANCE, false, 2, null);
        CommandDispatcher.registerTransformer$default(this, BigIntegerTransformer.INSTANCE, false, 2, null);
        CommandDispatcher.registerTransformer$default(this, ColorTransformer.INSTANCE, false, 2, null);
        CommandDispatcher.registerTransformer$default(this, InstantTransformer.INSTANCE, false, 2, null);
        CommandDispatcher.registerTransformer$default(this, KhronoTransformer.INSTANCE, false, 2, null);
        CommandDispatcher.registerTransformer$default(this, LocalDateTimeTransformer.INSTANCE, false, 2, null);
        CommandDispatcher.registerTransformer$default(this, LocalDateTransformer.INSTANCE, false, 2, null);
        CommandDispatcher.registerTransformer$default(this, LocalTimeTransformer.INSTANCE, false, 2, null);
        CommandDispatcher.registerTransformer$default(this, Reflection.getOrCreateKotlinClass(Number.class), DoubleTransformer.INSTANCE, false, 4, null);
        CommandDispatcher.registerTransformer$default(this, OffsetDateTimeTransformer.INSTANCE, false, 2, null);
        CommandDispatcher.registerTransformer$default(this, StringBuilderTransformer.INSTANCE, false, 2, null);
        CommandDispatcher.registerTransformer$default(this, TokenTransformer.INSTANCE, false, 2, null);
        CommandDispatcher.registerTransformer$default(this, URLTransformer.INSTANCE, false, 2, null);
        CommandDispatcher.registerTransformer$default(this, UUIDTransformer.INSTANCE, false, 2, null);
        CommandDispatcher.registerTransformer$default(this, ChronoUnitTransformer.INSTANCE, false, 2, null);
        CommandDispatcher.registerTransformer$default(this, DayOfWeekTransformer.INSTANCE, false, 2, null);
        CommandDispatcher.registerTransformer$default(this, KhronoUnitTransformer.INSTANCE, false, 2, null);
        CommandDispatcher.registerTransformer$default(this, MonthTransformer.INSTANCE, false, 2, null);
        CommandDispatcher.registerTransformer$default(this, TimeUnitTransformer.INSTANCE, false, 2, null);
    }

    public /* synthetic */ CommandDispatcher(String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        this(string, bl);
    }

    static {
        Companion = new Companion(null);
        logger = LoggerExtensionsKt.getLogger(Companion);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lbvanseg/kotlincommons/lang/command/CommandDispatcher$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "kotlincommons"})
    public static final class Companion {
        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

