/*
 * Decompiled with CFR 0.152.
 */
package bvanseg.kotlincommons.lang.command.transformer;

import bvanseg.kotlincommons.lang.command.context.CommandContext;
import bvanseg.kotlincommons.lang.command.exception.TransformerParseException;
import bvanseg.kotlincommons.lang.command.token.Token;
import bvanseg.kotlincommons.lang.command.token.buffer.ArgumentTokenBuffer;
import bvanseg.kotlincommons.lang.command.token.buffer.PeekingTokenBuffer;
import bvanseg.kotlincommons.lang.command.transformer.Transformer;
import java.math.BigDecimal;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u0018*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001\u0018B7\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00028\u00000\n\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001d\u0010\u0015\u001a\u00028\u00002\u0006\u0010\u0011\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a2\u0006\u0002\u0010\u0017R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00028\u00000\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lbvanseg/kotlincommons/lang/command/transformer/DecimalTransformer;", "T", "", "Lbvanseg/kotlincommons/lang/command/transformer/Transformer;", "type", "Lkotlin/reflect/KClass;", "min", "Ljava/math/BigDecimal;", "max", "stringToNum", "Lkotlin/Function1;", "", "(Lkotlin/reflect/KClass;Ljava/math/BigDecimal;Ljava/math/BigDecimal;Lkotlin/jvm/functions/Function1;)V", "range", "Lkotlin/ranges/ClosedRange;", "matches", "", "buffer", "Lbvanseg/kotlincommons/lang/command/token/buffer/PeekingTokenBuffer;", "context", "Lbvanseg/kotlincommons/lang/command/context/CommandContext;", "parse", "Lbvanseg/kotlincommons/lang/command/token/buffer/ArgumentTokenBuffer;", "(Lbvanseg/kotlincommons/lang/command/token/buffer/ArgumentTokenBuffer;Lbvanseg/kotlincommons/lang/command/context/CommandContext;)Ljava/lang/Number;", "Companion", "kotlincommons"})
public abstract class DecimalTransformer<T extends Number>
extends Transformer<T> {
    private final ClosedRange<BigDecimal> range;
    private final Function1<String, T> stringToNum;
    @NotNull
    private static final Regex REGEX;
    @NotNull
    public static final Companion Companion;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean matches(@NotNull PeekingTokenBuffer buffer, @NotNull CommandContext context) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Token token = buffer.peek();
        Object object = token;
        if (token == null) return false;
        String string = ((Token)object).getValue();
        object = string;
        if (string == null) return false;
        Object object2 = object;
        boolean bl = false;
        boolean bl2 = false;
        Object it = object2;
        boolean bl3 = false;
        if (StringsKt.equals((String)it, (String)"pi", (boolean)true)) return true;
        if (StringsKt.equals((String)it, (String)"e", (boolean)true)) return true;
        CharSequence charSequence = (CharSequence)it;
        Regex regex = REGEX;
        boolean bl4 = false;
        if (!regex.matches(charSequence)) return false;
        return true;
    }

    @Override
    @NotNull
    public T parse(@NotNull ArgumentTokenBuffer buffer, @NotNull CommandContext context) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String text = buffer.next().getValue();
        if (StringsKt.equals((String)text, (String)"pi", (boolean)true)) {
            text = String.valueOf(Math.PI);
        } else if (StringsKt.equals((String)text, (String)"e", (boolean)true)) {
            text = String.valueOf(Math.E);
        }
        BigDecimal bigDeci = new BigDecimal(text);
        if (!this.range.contains((Comparable)bigDeci)) {
            throw (Throwable)new TransformerParseException("Value '" + bigDeci + "' does not fall within the range of (" + (BigDecimal)this.range.getStart() + " to " + (BigDecimal)this.range.getEndInclusive() + ')');
        }
        return (T)((Number)this.stringToNum.invoke((Object)text));
    }

    public DecimalTransformer(@NotNull KClass<T> type, @NotNull BigDecimal min, @NotNull BigDecimal max, @NotNull Function1<? super String, ? extends T> stringToNum) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)min, (String)"min");
        Intrinsics.checkNotNullParameter((Object)max, (String)"max");
        Intrinsics.checkNotNullParameter(stringToNum, (String)"stringToNum");
        super(type);
        this.stringToNum = stringToNum;
        this.range = RangesKt.rangeTo((Comparable)min, (Comparable)max);
    }

    static {
        Companion = new Companion(null);
        REGEX = new Regex("^[+-]?([0-9]*[.])?[0-9]+$");
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lbvanseg/kotlincommons/lang/command/transformer/DecimalTransformer$Companion;", "", "()V", "REGEX", "Lkotlin/text/Regex;", "getREGEX", "()Lkotlin/text/Regex;", "kotlincommons"})
    public static final class Companion {
        @NotNull
        public final Regex getREGEX() {
            return REGEX;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

