/*
 * Decompiled with CFR 0.152.
 */
package bvanseg.kotlincommons.time.api;

import bvanseg.kotlincommons.lang.check.Check;
import bvanseg.kotlincommons.lang.check.Checks;
import bvanseg.kotlincommons.time.api.KhronoUnit;
import bvanseg.kotlincommons.time.api.MutableKhrono;
import bvanseg.kotlincommons.util.HashCodeBuilder;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.math.MathKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0016\u0018\u0000 >2\u00020\u0001:\u0001>B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0086\u0002J\u000e\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0005J\t\u0010\u0011\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0006\u0010\u0014\u001a\u00020\u0013J\b\u0010\u0015\u001a\u00020\fH\u0016J\t\u0010\u0016\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005H\u0086\u0004J\u0006\u0010\u0018\u001a\u00020\u0000J\u0011\u0010\u0019\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010\u0019\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eH\u0096\u0002J\u0006\u0010\u001a\u001a\u00020\u0000J\u0011\u0010\u001b\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010\u001b\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eH\u0096\u0002J\u0011\u0010\u001c\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0000H\u0096\u0002J\u0006\u0010\u001d\u001a\u00020\fJ\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020!J\b\u0010\"\u001a\u00020\u0000H\u0016J\b\u0010#\u001a\u00020\u0000H\u0016J\b\u0010$\u001a\u00020\u0000H\u0016J\u0006\u0010%\u001a\u00020\u0003J\u0006\u0010&\u001a\u00020'J\u0006\u0010(\u001a\u00020)J\b\u0010*\u001a\u00020\u0000H\u0016J\b\u0010+\u001a\u00020\u0000H\u0016J\b\u0010,\u001a\u00020\u0000H\u0016J\u0006\u0010-\u001a\u00020\fJ\u0006\u0010.\u001a\u00020\u001fJ\b\u0010/\u001a\u00020\u0000H\u0016J\b\u00100\u001a\u00020\u0000H\u0016J\b\u00101\u001a\u00020\u0000H\u0016J\b\u00102\u001a\u00020\u0000H\u0016J\u0006\u00103\u001a\u000204J\b\u00105\u001a\u00020\u0000H\u0016J\b\u00106\u001a\u00020\u0000H\u0016J\b\u00107\u001a\u00020\u0000H\u0016J\u0006\u00108\u001a\u000209J\b\u0010:\u001a\u00020;H\u0016J\b\u0010<\u001a\u00020\u0000H\u0016J\b\u0010=\u001a\u00020\u0000H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006?"}, d2={"Lbvanseg/kotlincommons/time/api/Khrono;", "", "value", "", "unit", "Lbvanseg/kotlincommons/time/api/KhronoUnit;", "(DLbvanseg/kotlincommons/time/api/KhronoUnit;)V", "getUnit", "()Lbvanseg/kotlincommons/time/api/KhronoUnit;", "getValue", "()D", "compareTo", "", "other", "", "convertTo", "otherUnit", "dec", "equals", "", "hasValue", "hashCode", "inc", "into", "lastInterval", "minus", "nextInterval", "plus", "rangeTo", "roundToInt", "roundToLong", "", "toByte", "", "toCenturies", "toDays", "toDecades", "toDouble", "toDuration", "Ljava/time/Duration;", "toFloat", "", "toForever", "toHalfDays", "toHours", "toInt", "toLong", "toMicros", "toMillenniums", "toMillis", "toMinutes", "toMutable", "Lbvanseg/kotlincommons/time/api/MutableKhrono;", "toNanos", "toNever", "toSeconds", "toShort", "", "toString", "", "toWeeks", "toYears", "Companion", "kotlincommons"})
public class Khrono {
    private final double value;
    @NotNull
    private final KhronoUnit unit;
    @NotNull
    private static final Khrono NEVER;
    @NotNull
    private static final Khrono FOREVER;
    @NotNull
    private static final Khrono EMPTY;
    @NotNull
    private static final Regex KHRONO_REGEX;
    @NotNull
    public static final Companion Companion;

    public boolean equals(@Nullable Object other) {
        double convertedValue;
        if (!(other instanceof Khrono)) {
            return false;
        }
        boolean bl = this.getUnit() == ((Khrono)other).getUnit() ? this.getValue() == ((Khrono)other).getValue() : (convertedValue = this.convertTo(((Khrono)other).getUnit())) == ((Khrono)other).getValue();
        return bl;
    }

    public int hashCode() {
        return HashCodeBuilder.Companion.builder(Reflection.getOrCreateKotlinClass(this.getClass())).append(this.getValue()).append((Object)this.getUnit()).hashCode();
    }

    @NotNull
    public String toString() {
        return this.getValue() + this.getUnit().getCode();
    }

    @NotNull
    public Khrono toNever() {
        return new Khrono(Double.MIN_VALUE, KhronoUnit.NEVER);
    }

    @NotNull
    public Khrono toNanos() {
        return new Khrono(this.getUnit().convertTo(this.getValue(), KhronoUnit.NANOSECOND), KhronoUnit.NANOSECOND);
    }

    @NotNull
    public Khrono toMicros() {
        return new Khrono(this.getUnit().convertTo(this.getValue(), KhronoUnit.MICROSECOND), KhronoUnit.MICROSECOND);
    }

    @NotNull
    public Khrono toMillis() {
        return new Khrono(this.getUnit().convertTo(this.getValue(), KhronoUnit.MILLISECOND), KhronoUnit.MILLISECOND);
    }

    @NotNull
    public Khrono toSeconds() {
        return new Khrono(this.getUnit().convertTo(this.getValue(), KhronoUnit.SECOND), KhronoUnit.SECOND);
    }

    @NotNull
    public Khrono toMinutes() {
        return new Khrono(this.getUnit().convertTo(this.getValue(), KhronoUnit.MINUTE), KhronoUnit.MINUTE);
    }

    @NotNull
    public Khrono toHours() {
        return new Khrono(this.getUnit().convertTo(this.getValue(), KhronoUnit.HOUR), KhronoUnit.HOUR);
    }

    @NotNull
    public Khrono toHalfDays() {
        return new Khrono(this.getUnit().convertTo(this.getValue(), KhronoUnit.HALF_DAY), KhronoUnit.HALF_DAY);
    }

    @NotNull
    public Khrono toDays() {
        return new Khrono(this.getUnit().convertTo(this.getValue(), KhronoUnit.DAY), KhronoUnit.DAY);
    }

    @NotNull
    public Khrono toWeeks() {
        return new Khrono(this.getUnit().convertTo(this.getValue(), KhronoUnit.WEEK), KhronoUnit.WEEK);
    }

    @NotNull
    public Khrono toYears() {
        return new Khrono(this.getUnit().convertTo(this.getValue(), KhronoUnit.YEAR), KhronoUnit.YEAR);
    }

    @NotNull
    public Khrono toDecades() {
        return new Khrono(this.getUnit().convertTo(this.getValue(), KhronoUnit.DECADE), KhronoUnit.DECADE);
    }

    @NotNull
    public Khrono toCenturies() {
        return new Khrono(this.getUnit().convertTo(this.getValue(), KhronoUnit.CENTURY), KhronoUnit.CENTURY);
    }

    @NotNull
    public Khrono toMillenniums() {
        return new Khrono(this.getUnit().convertTo(this.getValue(), KhronoUnit.MILLENNIUM), KhronoUnit.MILLENNIUM);
    }

    @NotNull
    public Khrono toForever() {
        return new Khrono(Double.MAX_VALUE, KhronoUnit.FOREVER);
    }

    public final byte toByte() {
        return (byte)this.getValue();
    }

    public final short toShort() {
        return (short)this.getValue();
    }

    public final int toInt() {
        return (int)this.getValue();
    }

    public final int roundToInt() {
        return MathKt.roundToInt((double)this.getValue());
    }

    public final long toLong() {
        return (long)this.getValue();
    }

    public final long roundToLong() {
        return MathKt.roundToLong((double)this.getValue());
    }

    public final float toFloat() {
        return (float)this.getValue();
    }

    public final double toDouble() {
        return this.getValue();
    }

    @NotNull
    public final Duration toDuration() {
        Duration duration = Duration.of((long)this.convertTo(KhronoUnit.NANOSECOND), ChronoUnit.NANOS);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"Duration.of(this.convert\u2026Long(), ChronoUnit.NANOS)");
        return duration;
    }

    public final double convertTo(@NotNull KhronoUnit otherUnit) {
        Intrinsics.checkNotNullParameter((Object)((Object)otherUnit), (String)"otherUnit");
        return this.getUnit().convertTo(this.getValue(), otherUnit);
    }

    @NotNull
    public final MutableKhrono toMutable() {
        return new MutableKhrono(this.getValue(), this.getUnit());
    }

    @NotNull
    public final Khrono lastInterval() {
        long thisAsMillis = this.toMillis().toLong();
        long snapshotMillis = System.currentTimeMillis() % thisAsMillis;
        return new Khrono(snapshotMillis, KhronoUnit.MILLISECOND);
    }

    @NotNull
    public final Khrono nextInterval() {
        long thisAsMillis = this.toMillis().toLong();
        long snapshotMillis = System.currentTimeMillis() % thisAsMillis;
        return new Khrono(thisAsMillis - snapshotMillis, KhronoUnit.MILLISECOND);
    }

    public final boolean hasValue() {
        return this.getValue() > 0.0 && this.getUnit() != KhronoUnit.NEVER && this.getUnit() != KhronoUnit.FOREVER;
    }

    @NotNull
    public final Khrono into(@NotNull KhronoUnit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        double newValue = this.getUnit().convertTo(this.getValue(), unit);
        return new Khrono(newValue, unit);
    }

    @NotNull
    public Khrono inc() {
        return new Khrono(this.getValue() + 1.0, this.getUnit());
    }

    @NotNull
    public Khrono plus(@NotNull Number other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new Khrono(this.getValue() + other.doubleValue(), this.getUnit());
    }

    @NotNull
    public Khrono plus(@NotNull Khrono other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new Khrono(this.getValue() + other.convertTo(this.getUnit()), this.getUnit());
    }

    @NotNull
    public Khrono dec() {
        return new Khrono(this.getValue() - 1.0, this.getUnit());
    }

    @NotNull
    public Khrono minus(@NotNull Number other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new Khrono(this.getValue() - other.doubleValue(), this.getUnit());
    }

    @NotNull
    public Khrono minus(@NotNull Khrono other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new Khrono(this.getValue() - other.convertTo(this.getUnit()), this.getUnit());
    }

    public final int compareTo(@NotNull Number other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        double otherValue = other.doubleValue();
        return this.getValue() == otherValue ? 0 : (this.getValue() > otherValue ? 1 : (this.getValue() < otherValue ? -1 : -1));
    }

    public final int compareTo(@NotNull Khrono other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        double equalUnitValue = this.convertTo(other.getUnit());
        return equalUnitValue == other.getValue() ? 0 : (equalUnitValue > other.getValue() ? 1 : (equalUnitValue < other.getValue() ? -1 : -1));
    }

    @NotNull
    public Khrono rangeTo(@NotNull Khrono other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return other.minus(this);
    }

    public double getValue() {
        return this.value;
    }

    @NotNull
    public KhronoUnit getUnit() {
        return this.unit;
    }

    public Khrono(double value, @NotNull KhronoUnit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        this.value = value;
        this.unit = unit;
        Check.Companion.all(this.getValue(), "value", Checks.INSTANCE.isFinite(), Checks.INSTANCE.isWholeNumber());
    }

    static {
        Companion = new Companion(null);
        NEVER = new Khrono(Double.MIN_VALUE, KhronoUnit.NEVER);
        FOREVER = new Khrono(Double.MAX_VALUE, KhronoUnit.FOREVER);
        EMPTY = new Khrono(0.0, KhronoUnit.MILLISECOND);
        KHRONO_REGEX = new Regex("^([0-9]+)(\\.[0-9]+)?([a-zA-Z]+)$");
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J'\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0013\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0014J\u0006\u0010\u0015\u001a\u00020\u0004J\u000e\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0018R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006\u00a8\u0006\u0019"}, d2={"Lbvanseg/kotlincommons/time/api/Khrono$Companion;", "", "()V", "EMPTY", "Lbvanseg/kotlincommons/time/api/Khrono;", "getEMPTY", "()Lbvanseg/kotlincommons/time/api/Khrono;", "FOREVER", "getFOREVER", "KHRONO_REGEX", "Lkotlin/text/Regex;", "getKHRONO_REGEX", "()Lkotlin/text/Regex;", "NEVER", "getNEVER", "combineAll", "unit", "Lbvanseg/kotlincommons/time/api/KhronoUnit;", "times", "", "(Lbvanseg/kotlincommons/time/api/KhronoUnit;[Lbvanseg/kotlincommons/time/api/Khrono;)Lbvanseg/kotlincommons/time/api/Khrono;", "now", "parse", "input", "", "kotlincommons"})
    public static final class Companion {
        @NotNull
        public final Khrono getNEVER() {
            return NEVER;
        }

        @NotNull
        public final Khrono getFOREVER() {
            return FOREVER;
        }

        @NotNull
        public final Khrono getEMPTY() {
            return EMPTY;
        }

        @NotNull
        public final Regex getKHRONO_REGEX() {
            return KHRONO_REGEX;
        }

        @NotNull
        public final Khrono now() {
            return new Khrono(System.currentTimeMillis(), KhronoUnit.MILLISECOND);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Khrono combineAll(@NotNull KhronoUnit unit, Khrono ... times) {
            double d;
            Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
            Intrinsics.checkNotNullParameter((Object)times, (String)"times");
            Khrono[] $this$sumByDouble$iv = times;
            boolean $i$f$sumByDouble = false;
            double sum$iv = 0.0;
            Khrono[] khronoArray = $this$sumByDouble$iv;
            int n = khronoArray.length;
            for (int i = 0; i < n; ++i) {
                void it;
                Khrono element$iv;
                Khrono khrono = element$iv = khronoArray[i];
                d = sum$iv;
                boolean bl = false;
                double d2 = it.convertTo(unit);
                sum$iv = d + d2;
            }
            d = sum$iv;
            KhronoUnit khronoUnit = unit;
            double d3 = d;
            return new Khrono(d3, khronoUnit);
        }

        @NotNull
        public final Khrono parse(@NotNull String input) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            MatchResult matchResult = this.getKHRONO_REGEX().matchEntire((CharSequence)input);
            Intrinsics.checkNotNull((Object)matchResult);
            List groups = matchResult.getGroupValues();
            int lastIndex = groups.size() - 1;
            KhronoUnit unit = KhronoUnit.Companion.fromCode((String)groups.get(lastIndex));
            String string = (String)groups.get(lastIndex - 2) + (String)groups.get(lastIndex - 1);
            boolean bl = false;
            double number = Double.parseDouble(string);
            return new Khrono(number, unit);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

