/*
 * Decompiled with CFR 0.152.
 */
package bvanseg.kotlincommons.time.api;

import bvanseg.kotlincommons.time.api.JavaKhronoInteropKt;
import bvanseg.kotlincommons.time.api.Khrono;
import bvanseg.kotlincommons.time.api.KhronoPropertiesKt;
import bvanseg.kotlincommons.time.api.KhronoTime;
import bvanseg.kotlincommons.time.api.KhronoUnit;
import bvanseg.kotlincommons.time.api.MutableKhrono;
import java.time.Duration;
import java.time.LocalTime;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\"\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 ;2\u00020\u0001:\u0001;BA\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ\u0006\u00106\u001a\u000207J\b\u00108\u001a\u000207H\u0002J\b\u00109\u001a\u000207H\u0002J\b\u0010:\u001a\u000207H\u0002R\u001e\u0010\u000b\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001e\u0010\u000e\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u001e\u0010\u0010\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u001e\u0010\u0012\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\rR\u001e\u0010\u0014\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\rR\u001e\u0010\u0016\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\rR\u001e\u0010\u0018\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\rR\u001e\u0010\u001a\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\rR\u001e\u0010\u001c\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\rR\u001e\u0010\u001e\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\rR\u001e\u0010 \u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\rR\u001e\u0010\"\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\rR\u001e\u0010$\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\rR\u001e\u0010'\u001a\u00020&2\u0006\u0010\n\u001a\u00020&@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u001e\u0010*\u001a\u00020&2\u0006\u0010\n\u001a\u00020&@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010)R\u001e\u0010,\u001a\u00020&2\u0006\u0010\n\u001a\u00020&@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010)R\u001e\u0010.\u001a\u00020&2\u0006\u0010\n\u001a\u00020&@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010)R\u000e\u00100\u001a\u000201X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u00102\u001a\u00020&2\u0006\u0010\n\u001a\u00020&@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010)R\u001e\u00104\u001a\u00020&2\u0006\u0010\n\u001a\u00020&@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010)\u00a8\u0006<"}, d2={"Lbvanseg/kotlincommons/time/api/MutableKhronoTime;", "Lbvanseg/kotlincommons/time/api/KhronoTime;", "hr", "", "min", "sec", "millis", "micro", "nano", "(DDDDDD)V", "<set-?>", "asCenturies", "getAsCenturies", "()D", "asDays", "getAsDays", "asDecades", "getAsDecades", "asHalfDays", "getAsHalfDays", "asHours", "getAsHours", "asMicros", "getAsMicros", "asMillenniums", "getAsMillenniums", "asMillis", "getAsMillis", "asMinutes", "getAsMinutes", "asNanos", "getAsNanos", "asSeconds", "getAsSeconds", "asWeeks", "getAsWeeks", "asYears", "getAsYears", "Lbvanseg/kotlincommons/time/api/MutableKhrono;", "hour", "getHour", "()Lbvanseg/kotlincommons/time/api/MutableKhrono;", "microsecond", "getMicrosecond", "millisecond", "getMillisecond", "minute", "getMinute", "nanoObject", "Lbvanseg/kotlincommons/time/api/Khrono;", "nanosecond", "getNanosecond", "second", "getSecond", "clear", "", "clearCallbacks", "handleOverflow", "updateCalculations", "Companion", "kotlincommons"})
public final class MutableKhronoTime
extends KhronoTime {
    @NotNull
    private MutableKhrono nanosecond;
    @NotNull
    private MutableKhrono microsecond;
    @NotNull
    private MutableKhrono millisecond;
    @NotNull
    private MutableKhrono second;
    @NotNull
    private MutableKhrono minute;
    @NotNull
    private MutableKhrono hour;
    private double asNanos;
    private Khrono nanoObject;
    private double asMicros;
    private double asMillis;
    private double asSeconds;
    private double asMinutes;
    private double asHours;
    private double asHalfDays;
    private double asDays;
    private double asWeeks;
    private double asYears;
    private double asDecades;
    private double asCenturies;
    private double asMillenniums;
    @NotNull
    private static final KhronoTime midnight;
    @NotNull
    private static final KhronoTime afternoon;
    @NotNull
    public static final Companion Companion;

    @Override
    @NotNull
    public MutableKhrono getNanosecond() {
        return this.nanosecond;
    }

    @Override
    @NotNull
    public MutableKhrono getMicrosecond() {
        return this.microsecond;
    }

    @Override
    @NotNull
    public MutableKhrono getMillisecond() {
        return this.millisecond;
    }

    @Override
    @NotNull
    public MutableKhrono getSecond() {
        return this.second;
    }

    @Override
    @NotNull
    public MutableKhrono getMinute() {
        return this.minute;
    }

    @Override
    @NotNull
    public MutableKhrono getHour() {
        return this.hour;
    }

    @Override
    public double getAsNanos() {
        return this.asNanos;
    }

    @Override
    public double getAsMicros() {
        return this.asMicros;
    }

    @Override
    public double getAsMillis() {
        return this.asMillis;
    }

    @Override
    public double getAsSeconds() {
        return this.asSeconds;
    }

    @Override
    public double getAsMinutes() {
        return this.asMinutes;
    }

    @Override
    public double getAsHours() {
        return this.asHours;
    }

    @Override
    public double getAsHalfDays() {
        return this.asHalfDays;
    }

    @Override
    public double getAsDays() {
        return this.asDays;
    }

    @Override
    public double getAsWeeks() {
        return this.asWeeks;
    }

    @Override
    public double getAsYears() {
        return this.asYears;
    }

    @Override
    public double getAsDecades() {
        return this.asDecades;
    }

    @Override
    public double getAsCenturies() {
        return this.asCenturies;
    }

    @Override
    public double getAsMillenniums() {
        return this.asMillenniums;
    }

    private final void updateCalculations() {
        this.asNanos = Khrono.Companion.combineAll(KhronoUnit.NANOSECOND, this.getHour(), this.getMinute(), this.getSecond(), this.getMillisecond(), this.getMicrosecond(), this.getNanosecond()).getValue();
        this.nanoObject = KhronoPropertiesKt.getNanoseconds(this.getAsNanos());
        this.asMicros = this.nanoObject.toMicros().toDouble();
        this.asMillis = this.nanoObject.toMillis().toDouble();
        this.asSeconds = this.nanoObject.toSeconds().toDouble();
        this.asMinutes = this.nanoObject.toMinutes().toDouble();
        this.asHours = this.nanoObject.toHours().toDouble();
        this.asHalfDays = this.nanoObject.toHalfDays().toDouble();
        this.asDays = this.nanoObject.toDays().toDouble();
        this.asWeeks = this.nanoObject.toWeeks().toDouble();
        this.asYears = this.nanoObject.toYears().toDouble();
        this.asDecades = this.nanoObject.toDecades().toDouble();
        this.asCenturies = this.nanoObject.toCenturies().toDouble();
        this.asMillenniums = this.nanoObject.toMillenniums().toDouble();
    }

    private final void clearCallbacks() {
        this.getNanosecond().setOnChange((Function0<Unit>)((Function0)null));
        this.getMicrosecond().setOnChange((Function0<Unit>)((Function0)null));
        this.getMillisecond().setOnChange((Function0<Unit>)((Function0)null));
        this.getSecond().setOnChange((Function0<Unit>)((Function0)null));
        this.getMinute().setOnChange((Function0<Unit>)((Function0)null));
        this.getHour().setOnChange((Function0<Unit>)((Function0)null));
    }

    private final void handleOverflow() {
        Function0<Unit> nanoCallback = this.getNanosecond().getOnChange();
        Function0<Unit> microCallback = this.getMicrosecond().getOnChange();
        Function0<Unit> millisCallback = this.getMillisecond().getOnChange();
        Function0<Unit> secondCallback = this.getSecond().getOnChange();
        Function0<Unit> minuteCallback = this.getMinute().getOnChange();
        Function0<Unit> hourCallback = this.getHour().getOnChange();
        this.clearCallbacks();
        double nanoLeftover = this.getNanosecond().getValue() % KhronoUnit.NANOSECOND.getMax();
        double nanoOverflow = this.getNanosecond().getValue() - nanoLeftover;
        double microFromNano = nanoOverflow / KhronoUnit.NANOSECOND.getMax();
        this.getNanosecond().setValue(nanoLeftover);
        double microTotal = this.getMicrosecond().getValue() + microFromNano;
        double microLeftover = microTotal % KhronoUnit.MICROSECOND.getMax();
        double microOverflow = microTotal - microLeftover;
        double millisFromMicro = microOverflow / KhronoUnit.MICROSECOND.getMax();
        this.getMicrosecond().setValue(microLeftover);
        double millisTotal = this.getMillisecond().getValue() + millisFromMicro;
        double millisLeftover = millisTotal % KhronoUnit.MILLISECOND.getMax();
        double millisOverflow = millisTotal - millisLeftover;
        double secFromMillis = millisOverflow / KhronoUnit.MILLISECOND.getMax();
        this.getMillisecond().setValue(millisLeftover);
        double secTotal = this.getSecond().getValue() + secFromMillis;
        double secLeftover = secTotal % KhronoUnit.SECOND.getMax();
        double secOverflow = secTotal - secLeftover;
        double minFromSec = secOverflow / KhronoUnit.SECOND.getMax();
        this.getSecond().setValue(secLeftover);
        double minTotal = this.getMinute().getValue() + minFromSec;
        double minLeftover = minTotal % KhronoUnit.MINUTE.getMax();
        double minOverflow = minTotal - minLeftover;
        double hourFromMin = minOverflow / KhronoUnit.MINUTE.getMax();
        this.getMinute().setValue(minLeftover);
        double hourTotal = this.getHour().getValue() + hourFromMin;
        double hourLeftover = hourTotal % KhronoUnit.HOUR.getMax();
        this.getHour().setValue(hourLeftover);
        this.getNanosecond().setOnChange(nanoCallback);
        this.getMicrosecond().setOnChange(microCallback);
        this.getMillisecond().setOnChange(millisCallback);
        this.getSecond().setOnChange(secondCallback);
        this.getMinute().setOnChange(minuteCallback);
        this.getHour().setOnChange(hourCallback);
    }

    public final void clear() {
        this.getNanosecond().setValue(0.0);
        this.getMicrosecond().setValue(0.0);
        this.getMillisecond().setValue(0.0);
        this.getSecond().setValue(0.0);
        this.getMinute().setValue(0.0);
        this.getHour().setValue(0.0);
    }

    public MutableKhronoTime(double hr, double min, double sec, double millis, double micro, double nano) {
        super(hr, min, sec, millis, micro, nano);
        this.nanosecond = MutableKhrono.Companion.getEMPTY();
        this.microsecond = MutableKhrono.Companion.getEMPTY();
        this.millisecond = MutableKhrono.Companion.getEMPTY();
        this.second = MutableKhrono.Companion.getEMPTY();
        this.minute = MutableKhrono.Companion.getEMPTY();
        this.hour = MutableKhrono.Companion.getEMPTY();
        double nanoLeftover = nano % KhronoUnit.NANOSECOND.getMax();
        double nanoOverflow = nano - nanoLeftover;
        double microFromNano = nanoOverflow / KhronoUnit.NANOSECOND.getMax();
        this.nanosecond = new MutableKhrono(nanoLeftover, KhronoUnit.NANOSECOND);
        this.getNanosecond().setOnChange((Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                this.updateCalculations();
                this.handleOverflow();
            }
        }));
        double microTotal = micro + microFromNano;
        double microLeftover = microTotal % KhronoUnit.MICROSECOND.getMax();
        double microOverflow = microTotal - microLeftover;
        double millisFromMicro = microOverflow / KhronoUnit.MICROSECOND.getMax();
        this.microsecond = new MutableKhrono(microLeftover, KhronoUnit.MICROSECOND);
        this.getMicrosecond().setOnChange((Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                this.updateCalculations();
                this.handleOverflow();
            }
        }));
        double millisTotal = millis + millisFromMicro;
        double millisLeftover = millisTotal % KhronoUnit.MILLISECOND.getMax();
        double millisOverflow = millisTotal - millisLeftover;
        double secFromMillis = millisOverflow / KhronoUnit.MILLISECOND.getMax();
        this.millisecond = new MutableKhrono(millisLeftover, KhronoUnit.MILLISECOND);
        this.getMillisecond().setOnChange((Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                this.updateCalculations();
                this.handleOverflow();
            }
        }));
        double secTotal = sec + secFromMillis;
        double secLeftover = secTotal % KhronoUnit.SECOND.getMax();
        double secOverflow = secTotal - secLeftover;
        double minFromSec = secOverflow / KhronoUnit.SECOND.getMax();
        this.second = new MutableKhrono(secLeftover, KhronoUnit.SECOND);
        this.getSecond().setOnChange((Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                this.updateCalculations();
                this.handleOverflow();
            }
        }));
        double minTotal = min + minFromSec;
        double minLeftover = minTotal % KhronoUnit.MINUTE.getMax();
        double minOverflow = minTotal - minLeftover;
        double hourFromMin = minOverflow / KhronoUnit.MINUTE.getMax();
        this.minute = new MutableKhrono(minLeftover, KhronoUnit.MINUTE);
        this.getMinute().setOnChange((Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                this.updateCalculations();
                this.handleOverflow();
            }
        }));
        double hourTotal = hr + hourFromMin;
        double hourLeftover = hourTotal % KhronoUnit.HOUR.getMax();
        this.hour = new MutableKhrono(hourLeftover, KhronoUnit.HOUR);
        this.getHour().setOnChange((Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                this.updateCalculations();
                this.handleOverflow();
            }
        }));
        this.asNanos = Khrono.Companion.combineAll(KhronoUnit.NANOSECOND, this.getHour(), this.getMinute(), this.getSecond(), this.getMillisecond(), this.getMicrosecond(), this.getNanosecond()).getValue();
        this.nanoObject = new Khrono(this.getAsNanos(), KhronoUnit.NANOSECOND);
        this.asMicros = this.nanoObject.toMicros().toDouble();
        this.asMillis = this.nanoObject.toMillis().toDouble();
        this.asSeconds = this.nanoObject.toSeconds().toDouble();
        this.asMinutes = this.nanoObject.toMinutes().toDouble();
        this.asHours = this.nanoObject.toHours().toDouble();
        this.asHalfDays = this.nanoObject.toHalfDays().toDouble();
        this.asDays = this.nanoObject.toDays().toDouble();
        this.asWeeks = this.nanoObject.toWeeks().toDouble();
        this.asYears = this.nanoObject.toYears().toDouble();
        this.asDecades = this.nanoObject.toDecades().toDouble();
        this.asCenturies = this.nanoObject.toCenturies().toDouble();
        this.asMillenniums = this.nanoObject.toMillenniums().toDouble();
    }

    public /* synthetic */ MutableKhronoTime(double d, double d2, double d3, double d4, double d5, double d6, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            d = 0.0;
        }
        if ((n & 2) != 0) {
            d2 = 0.0;
        }
        if ((n & 4) != 0) {
            d3 = 0.0;
        }
        if ((n & 8) != 0) {
            d4 = 0.0;
        }
        if ((n & 0x10) != 0) {
            d5 = 0.0;
        }
        if ((n & 0x20) != 0) {
            d6 = 0.0;
        }
        this(d, d2, d3, d4, d5, d6);
    }

    public MutableKhronoTime() {
        this(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 63, null);
    }

    static {
        Companion = new Companion(null);
        midnight = new KhronoTime(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 62, null);
        afternoon = new KhronoTime(12.0, 0.0, 0.0, 0.0, 0.0, 0.0, 62, null);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lbvanseg/kotlincommons/time/api/MutableKhronoTime$Companion;", "", "()V", "afternoon", "Lbvanseg/kotlincommons/time/api/KhronoTime;", "getAfternoon", "()Lbvanseg/kotlincommons/time/api/KhronoTime;", "midnight", "getMidnight", "now", "Lbvanseg/kotlincommons/time/api/MutableKhronoTime;", "parseISO8601", "iso8601Format", "", "kotlincommons"})
    public static final class Companion {
        @NotNull
        public final MutableKhronoTime parseISO8601(@NotNull String iso8601Format) {
            Intrinsics.checkNotNullParameter((Object)iso8601Format, (String)"iso8601Format");
            Duration duration = Duration.parse(iso8601Format);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"Duration.parse(iso8601Format)");
            return JavaKhronoInteropKt.toMutableKhronoTime(duration);
        }

        @NotNull
        public final MutableKhronoTime now() {
            LocalTime localTime = LocalTime.now();
            Intrinsics.checkNotNullExpressionValue((Object)localTime, (String)"LocalTime.now()");
            return JavaKhronoInteropKt.toMutableKhronoTime(localTime);
        }

        @NotNull
        public final KhronoTime getMidnight() {
            return midnight;
        }

        @NotNull
        public final KhronoTime getAfternoon() {
            return afternoon;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

