/*
 * Decompiled with CFR 0.152.
 */
package bvanseg.kotlincommons.net.ratelimit;

import bvanseg.kotlincommons.any.CommonExtensionsKt;
import bvanseg.kotlincommons.net.ratelimit.RateLimiter;
import bvanseg.kotlincommons.net.ratelimit.TokenBucket;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u0016\u001a\u00020\u0010J'\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00028\u00002\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\u0002\u0010\u001aJ\u0006\u0010\u001b\u001a\u00020\u0010J\u001f\u0010\u001b\u001a\u0002H\u001c\"\u0004\b\u0001\u0010\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001c0\u001e\u00a2\u0006\u0002\u0010\u001fJ-\u0010\u001b\u001a\u0002H\u001c\"\u0004\b\u0001\u0010\u001c2\u0006\u0010\u0018\u001a\u00028\u00002\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\u001c0\u000f\u00a2\u0006\u0002\u0010 R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR,\u0010\f\u001a \u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00100\u000f0\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006!"}, d2={"Lbvanseg/kotlincommons/net/ratelimit/RateLimiter;", "T", "", "tokenBucket", "Lbvanseg/kotlincommons/net/ratelimit/TokenBucket;", "(Lbvanseg/kotlincommons/net/ratelimit/TokenBucket;)V", "blockingCount", "Ljava/util/concurrent/atomic/AtomicLong;", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "queue", "Ljava/util/concurrent/ConcurrentLinkedDeque;", "Lkotlin/Pair;", "Lkotlin/Function1;", "", "service", "Ljava/util/concurrent/ScheduledExecutorService;", "kotlin.jvm.PlatformType", "getTokenBucket", "()Lbvanseg/kotlincommons/net/ratelimit/TokenBucket;", "shutdown", "submit", "unit", "ratelimitCallback", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)V", "submitBlocking", "R", "callback", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "kotlincommons"})
public final class RateLimiter<T> {
    @NotNull
    private final Logger logger;
    private final AtomicLong blockingCount;
    private final ConcurrentLinkedDeque<Pair<T, Function1<T, Unit>>> queue;
    private final ScheduledExecutorService service;
    @NotNull
    private final TokenBucket tokenBucket;

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    public final void submit(T unit, @NotNull Function1<? super T, Unit> ratelimitCallback) {
        Intrinsics.checkParameterIsNotNull(ratelimitCallback, (String)"ratelimitCallback");
        this.logger.trace("Received asynchronous submission.");
        if (this.queue.isEmpty()) {
            boolean result = this.tokenBucket.tryConsume();
            if (result) {
                this.logger.trace("Immediately executing asynchronous submission: TokenBucket (" + this.tokenBucket.getCurrentTokenCount().get() + '/' + this.tokenBucket.getTokenLimit() + ").");
                ratelimitCallback.invoke(unit);
            } else {
                this.queue.addLast(TuplesKt.to(unit, ratelimitCallback));
            }
        } else if ((long)this.queue.size() < this.tokenBucket.getMaxSize()) {
            this.queue.addLast(TuplesKt.to(unit, ratelimitCallback));
        }
    }

    public final <R> R submitBlocking(T unit, @NotNull Function1<? super T, ? extends R> callback) {
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        this.blockingCount.incrementAndGet();
        this.logger.trace("Received blocking submission.");
        while (!this.tokenBucket.tryConsume()) {
            Thread.onSpinWait();
        }
        this.logger.trace("Executing blocking submission...");
        Object result = callback.invoke(unit);
        this.blockingCount.decrementAndGet();
        return (R)result;
    }

    public final <R> R submitBlocking(@NotNull Function0<? extends R> callback) {
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        this.blockingCount.incrementAndGet();
        this.logger.trace("Received blocking submission.");
        while (!this.tokenBucket.tryConsume()) {
            Thread.onSpinWait();
        }
        this.logger.trace("Executing blocking submission...");
        Object result = callback.invoke();
        this.blockingCount.decrementAndGet();
        return (R)result;
    }

    public final void submitBlocking() {
        this.blockingCount.incrementAndGet();
        this.logger.trace("Received blocking submission.");
        while (!this.tokenBucket.tryConsume()) {
            Thread.onSpinWait();
        }
        this.logger.trace("Executing blocking submission...");
        this.blockingCount.decrementAndGet();
    }

    public final void shutdown() {
        this.logger.trace("Shutting down RateLimiter...");
        this.service.shutdown();
    }

    @NotNull
    public final TokenBucket getTokenBucket() {
        return this.tokenBucket;
    }

    public RateLimiter(@NotNull TokenBucket tokenBucket) {
        Intrinsics.checkParameterIsNotNull((Object)tokenBucket, (String)"tokenBucket");
        this.tokenBucket = tokenBucket;
        this.logger = CommonExtensionsKt.getLogger(this);
        this.blockingCount = new AtomicLong(0L);
        this.queue = new ConcurrentLinkedDeque();
        this.service = Executors.newSingleThreadScheduledExecutor(service.1.INSTANCE);
        this.service.scheduleAtFixedRate(new Runnable(){

            @Override
            public final void run() {
                this.getTokenBucket().refill();
                while (this.getTokenBucket().isNotEmpty()) {
                    Pair pair;
                    while (blockingCount.get() > 0L) {
                        Thread.onSpinWait();
                    }
                    Pair next = (Pair)queue.pollFirst();
                    if (next == null) break;
                    boolean bl = false;
                    boolean bl2 = false;
                    Pair it = pair;
                    boolean bl3 = false;
                    boolean result = this.getTokenBucket().tryConsume();
                    if (result) {
                        ((Function1)it.getSecond()).invoke(it.getFirst());
                        this.getLogger().trace("Executing queued submission: TokenBucket (" + this.getTokenBucket().getCurrentTokenCount().get() + '/' + this.getTokenBucket().getTokenLimit() + ").");
                        continue;
                    }
                    queue.addFirst(TuplesKt.to((Object)it.getFirst(), (Object)it.getSecond()));
                }
            }
        }, this.tokenBucket.getRefillTime(), this.tokenBucket.getRefillTime(), TimeUnit.MILLISECONDS);
    }
}

