/*
 * Decompiled with CFR 0.152.
 */
package bvanseg.kotlincommons.net.ratelimit;

import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c2\u0003J;\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\u0006\u0010!\u001a\u00020\u001dJ\u0006\u0010\"\u001a\u00020\u001dJ\u0006\u0010#\u001a\u00020\u001dJ\u0006\u0010$\u001a\u00020\u001dJ\u0006\u0010%\u001a\u00020&J\t\u0010'\u001a\u00020(H\u00d6\u0001J\u0006\u0010)\u001a\u00020\u001dR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013\u00a8\u0006*"}, d2={"Lbvanseg/kotlincommons/net/ratelimit/TokenBucket;", "", "tokenLimit", "", "maxSize", "refillTime", "initUpdate", "initTokenCount", "(JJJJJ)V", "currentTokenCount", "Ljava/util/concurrent/atomic/AtomicLong;", "getCurrentTokenCount", "()Ljava/util/concurrent/atomic/AtomicLong;", "setCurrentTokenCount", "(Ljava/util/concurrent/atomic/AtomicLong;)V", "lastUpdate", "getLastUpdate", "setLastUpdate", "getMaxSize", "()J", "getRefillTime", "getTokenLimit", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "isEmpty", "isFull", "isNotEmpty", "isNotFull", "refill", "", "toString", "", "tryConsume", "kotlincommons"})
public final class TokenBucket {
    @NotNull
    private AtomicLong lastUpdate;
    @NotNull
    private AtomicLong currentTokenCount;
    private final long tokenLimit;
    private final long maxSize;
    private final long refillTime;
    private final long initUpdate;
    private final long initTokenCount;

    @NotNull
    public final AtomicLong getLastUpdate() {
        return this.lastUpdate;
    }

    public final void setLastUpdate(@NotNull AtomicLong atomicLong) {
        Intrinsics.checkParameterIsNotNull((Object)atomicLong, (String)"<set-?>");
        this.lastUpdate = atomicLong;
    }

    @NotNull
    public final AtomicLong getCurrentTokenCount() {
        return this.currentTokenCount;
    }

    public final void setCurrentTokenCount(@NotNull AtomicLong atomicLong) {
        Intrinsics.checkParameterIsNotNull((Object)atomicLong, (String)"<set-?>");
        this.currentTokenCount = atomicLong;
    }

    public final void refill() {
        this.currentTokenCount.set(this.tokenLimit);
        this.lastUpdate.set(System.currentTimeMillis());
    }

    public final boolean isFull() {
        return this.currentTokenCount.get() == this.tokenLimit;
    }

    public final boolean isNotFull() {
        return this.currentTokenCount.get() != this.tokenLimit;
    }

    public final boolean isEmpty() {
        return this.currentTokenCount.get() == 0L;
    }

    public final boolean isNotEmpty() {
        return this.currentTokenCount.get() > 0L;
    }

    public final boolean tryConsume() {
        return this.currentTokenCount.getAndDecrement() > 0L;
    }

    public final long getTokenLimit() {
        return this.tokenLimit;
    }

    public final long getMaxSize() {
        return this.maxSize;
    }

    public final long getRefillTime() {
        return this.refillTime;
    }

    public TokenBucket(long tokenLimit, long maxSize, long refillTime, long initUpdate, long initTokenCount) {
        this.tokenLimit = tokenLimit;
        this.maxSize = maxSize;
        this.refillTime = refillTime;
        this.initUpdate = initUpdate;
        this.initTokenCount = initTokenCount;
        this.lastUpdate = new AtomicLong(this.initUpdate);
        this.currentTokenCount = new AtomicLong(this.initTokenCount);
    }

    public /* synthetic */ TokenBucket(long l, long l2, long l3, long l4, long l5, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            l5 = l;
        }
        this(l, l2, l3, l4, l5);
    }

    public final long component1() {
        return this.tokenLimit;
    }

    public final long component2() {
        return this.maxSize;
    }

    public final long component3() {
        return this.refillTime;
    }

    private final long component4() {
        return this.initUpdate;
    }

    private final long component5() {
        return this.initTokenCount;
    }

    @NotNull
    public final TokenBucket copy(long tokenLimit, long maxSize, long refillTime, long initUpdate, long initTokenCount) {
        return new TokenBucket(tokenLimit, maxSize, refillTime, initUpdate, initTokenCount);
    }

    public static /* synthetic */ TokenBucket copy$default(TokenBucket tokenBucket, long l, long l2, long l3, long l4, long l5, int n, Object object) {
        if ((n & 1) != 0) {
            l = tokenBucket.tokenLimit;
        }
        if ((n & 2) != 0) {
            l2 = tokenBucket.maxSize;
        }
        if ((n & 4) != 0) {
            l3 = tokenBucket.refillTime;
        }
        if ((n & 8) != 0) {
            l4 = tokenBucket.initUpdate;
        }
        if ((n & 0x10) != 0) {
            l5 = tokenBucket.initTokenCount;
        }
        return tokenBucket.copy(l, l2, l3, l4, l5);
    }

    @NotNull
    public String toString() {
        return "TokenBucket(tokenLimit=" + this.tokenLimit + ", maxSize=" + this.maxSize + ", refillTime=" + this.refillTime + ", initUpdate=" + this.initUpdate + ", initTokenCount=" + this.initTokenCount + ")";
    }

    public int hashCode() {
        return (((Long.hashCode(this.tokenLimit) * 31 + Long.hashCode(this.maxSize)) * 31 + Long.hashCode(this.refillTime)) * 31 + Long.hashCode(this.initUpdate)) * 31 + Long.hashCode(this.initTokenCount);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof TokenBucket)) break block3;
                TokenBucket tokenBucket = (TokenBucket)object;
                if (this.tokenLimit != tokenBucket.tokenLimit || this.maxSize != tokenBucket.maxSize || this.refillTime != tokenBucket.refillTime || this.initUpdate != tokenBucket.initUpdate || this.initTokenCount != tokenBucket.initTokenCount) break block3;
            }
            return true;
        }
        return false;
    }
}

