/*
 * Decompiled with CFR 0.152.
 */
package bvanseg.kotlincommons.time;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\u00062\b\b\u0002\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u000fJ\u0006\u0010\u0011\u001a\u00020\u000fJ\u0006\u0010\u0012\u001a\u00020\u000fJ\u0006\u0010\u0013\u001a\u00020\u000fR \u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lbvanseg/kotlincommons/time/Stopwatch;", "", "()V", "intervals", "", "Lkotlin/Pair;", "", "startTime", "status", "Lbvanseg/kotlincommons/time/Stopwatch$Status;", "stopTime", "getElapsedTime", "unit", "Ljava/util/concurrent/TimeUnit;", "newInteval", "", "pause", "resume", "start", "stop", "Status", "kotlincommons"})
public final class Stopwatch {
    private long startTime;
    private long stopTime;
    private Status status = Status.PAUSED;
    private final List<Pair<Long, Long>> intervals;

    public final void start() {
        if (this.status == Status.STOPPED) {
            throw (Throwable)new RuntimeException("Can't start a Stopwatch that has already been stopped!");
        }
        if (this.status == Status.RUNNING) {
            throw (Throwable)new RuntimeException("Can't start a Stopwatch that is already running!");
        }
        this.startTime = System.nanoTime();
        this.status = Status.RUNNING;
    }

    public final void pause() {
        if (this.status == Status.STOPPED) {
            throw (Throwable)new RuntimeException("Can't pause a Stopwatch that has already been stopped!");
        }
        if (this.status == Status.PAUSED) {
            throw (Throwable)new RuntimeException("Can't pause a Stopwatch that has already been paused!");
        }
        this.stopTime = System.nanoTime();
        this.status = Status.PAUSED;
    }

    public final void resume() {
        if (this.status != Status.PAUSED) {
            throw (Throwable)new RuntimeException("Can't resume a Stopwatch that isn't paused!");
        }
        this.startTime += System.nanoTime() - this.stopTime;
        this.status = Status.RUNNING;
    }

    public final void newInteval() {
        if (this.status == Status.STOPPED) {
            throw (Throwable)new RuntimeException("Can't create a new interval of a Stopwatch that has already been stopped!");
        }
        if (this.status == Status.PAUSED) {
            throw (Throwable)new RuntimeException("Can't create a new interval of a Stopwatch that is paused!");
        }
        this.stopTime = System.nanoTime();
        this.intervals.add((Pair<Long, Long>)TuplesKt.to((Object)this.startTime, (Object)this.stopTime));
        this.startTime = System.nanoTime();
    }

    public final void stop() {
        if (this.status == Status.STOPPED) {
            throw (Throwable)new RuntimeException("Can't stop a Stopwatch that has already been stopped!");
        }
        this.stopTime = System.nanoTime();
        this.status = Status.STOPPED;
        this.intervals.add((Pair<Long, Long>)TuplesKt.to((Object)this.startTime, (Object)this.stopTime));
    }

    /*
     * WARNING - void declaration
     */
    public final long getElapsedTime(@NotNull TimeUnit unit) {
        long l;
        Intrinsics.checkParameterIsNotNull((Object)((Object)unit), (String)"unit");
        if (this.status != Status.STOPPED) {
            throw (Throwable)new RuntimeException("Can't get time from Stopwatch when it has not been stopped!");
        }
        if (unit != TimeUnit.NANOSECONDS) {
            long l2;
            void $this$sumByLong$iv;
            Iterable iterable = this.intervals;
            TimeUnit timeUnit = unit;
            boolean $i$f$sumByLong = false;
            long sum$iv = 0L;
            for (Object element$iv : $this$sumByLong$iv) {
                void it;
                Pair pair2 = (Pair)element$iv;
                l2 = sum$iv;
                boolean bl = false;
                long l3 = ((Number)it.getSecond()).longValue() - ((Number)it.getFirst()).longValue();
                sum$iv = l2 + l3;
            }
            l2 = sum$iv;
            l = timeUnit.convert(l2, TimeUnit.NANOSECONDS);
        } else {
            Iterable $this$sumByLong$iv = this.intervals;
            boolean $i$f$sumByLong = false;
            long sum$iv = 0L;
            for (Object element$iv : $this$sumByLong$iv) {
                Pair it = (Pair)element$iv;
                long l4 = sum$iv;
                boolean bl = false;
                long l5 = ((Number)it.getSecond()).longValue() - ((Number)it.getFirst()).longValue();
                sum$iv = l4 + l5;
            }
            l = sum$iv;
        }
        return l;
    }

    public static /* synthetic */ long getElapsedTime$default(Stopwatch stopwatch, TimeUnit timeUnit, int n, Object object) {
        if ((n & 1) != 0) {
            timeUnit = TimeUnit.NANOSECONDS;
        }
        return stopwatch.getElapsedTime(timeUnit);
    }

    public Stopwatch() {
        List list;
        Stopwatch stopwatch = this;
        boolean bl = false;
        stopwatch.intervals = list = (List)new ArrayList();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lbvanseg/kotlincommons/time/Stopwatch$Status;", "", "(Ljava/lang/String;I)V", "RUNNING", "STOPPED", "PAUSED", "kotlincommons"})
    private static final class Status
    extends Enum<Status> {
        public static final /* enum */ Status RUNNING;
        public static final /* enum */ Status STOPPED;
        public static final /* enum */ Status PAUSED;
        private static final /* synthetic */ Status[] $VALUES;

        static {
            Status[] statusArray = new Status[3];
            Status[] statusArray2 = statusArray;
            statusArray[0] = RUNNING = new Status();
            statusArray[1] = STOPPED = new Status();
            statusArray[2] = PAUSED = new Status();
            $VALUES = statusArray;
        }

        public static Status[] values() {
            return (Status[])$VALUES.clone();
        }

        public static Status valueOf(String string2) {
            return Enum.valueOf(Status.class, string2);
        }
    }
}

