/*
 * Decompiled with CFR 0.152.
 */
package bvanseg.kotlincommons.ratelimit;

import bvanseg.kotlincommons.any.CommonExtensionsKt;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 22\u00020\u0001:\u00012BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00c2\u0003J\u0015\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\n0\tH\u00c2\u0003JQ\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0001J\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010#\u001a\u00020$H\u00d6\u0001J\u0006\u0010%\u001a\u00020!J\u0006\u0010&\u001a\u00020\u0003J\u0006\u0010'\u001a\u00020!J\u0006\u0010(\u001a\u00020!J\u0006\u0010)\u001a\u00020\nJ\t\u0010*\u001a\u00020+H\u00d6\u0001J4\u0010,\u001a\u0010\u0012\u0004\u0012\u00020!\u0012\u0006\u0012\u0004\u0018\u0001H.0-\"\u0004\b\u0000\u0010.2\b\b\u0002\u0010/\u001a\u00020\u00032\u000e\u00100\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H.01R\u001a\u0010\f\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000eR\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000eR\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u000e\u00a8\u00063"}, d2={"Lbvanseg/kotlincommons/ratelimit/TokenBucket;", "", "tokenLimit", "", "maxSize", "refillTime", "initUpdate", "initTokenCount", "refreshStrategy", "Lkotlin/Function1;", "", "(JJJJJLkotlin/jvm/functions/Function1;)V", "currentTokenCount", "getCurrentTokenCount", "()J", "setCurrentTokenCount", "(J)V", "<set-?>", "lastUpdate", "getLastUpdate", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "getMaxSize", "getRefillTime", "getTokenLimit", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "", "isEmpty", "isFull", "isNotEmpty", "isNotFull", "refill", "toString", "", "tryConsume", "Lkotlin/Pair;", "R", "amount", "callback", "Lkotlin/Function0;", "Companion", "kotlincommons"})
public final class TokenBucket {
    private volatile long lastUpdate;
    private final ReentrantLock lock;
    private volatile long currentTokenCount;
    private final long tokenLimit;
    private final long maxSize;
    private final long refillTime;
    private final long initUpdate;
    private final long initTokenCount;
    private final Function1<TokenBucket, Unit> refreshStrategy;
    private static final Logger logger;
    public static final Companion Companion;

    public final long getLastUpdate() {
        return this.lastUpdate;
    }

    public final long getCurrentTokenCount() {
        return this.currentTokenCount;
    }

    public final void setCurrentTokenCount(long l) {
        this.currentTokenCount = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void refill() {
        if (this.currentTokenCount < this.tokenLimit) {
            try {
                this.lock.lock();
                logger.debug("Refreshing tokens: TokenBucket (" + this.currentTokenCount + '/' + this.tokenLimit + ").");
                this.refreshStrategy.invoke((Object)this);
                logger.debug("Finished refreshing tokens: TokenBucket (" + this.currentTokenCount + '/' + this.tokenLimit + ").");
                this.lastUpdate = System.currentTimeMillis();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public final long isFull() {
        return this.currentTokenCount;
    }

    public final boolean isNotFull() {
        return this.currentTokenCount != this.tokenLimit;
    }

    public final boolean isEmpty() {
        return this.currentTokenCount == 0L;
    }

    public final boolean isNotEmpty() {
        return this.currentTokenCount > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final <R> Pair<Boolean, R> tryConsume(long amount, @NotNull Function0<? extends R> callback) {
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        if (amount < 0L) {
            throw (Throwable)new IllegalArgumentException("Consume amount may not be negative!");
        }
        try {
            this.lock.lock();
            if (this.currentTokenCount >= amount) {
                this.currentTokenCount -= amount;
                Pair pair2 = TuplesKt.to((Object)true, (Object)callback.invoke());
                return pair2;
            }
            Pair pair3 = TuplesKt.to((Object)false, null);
            return pair3;
        }
        finally {
            this.lock.unlock();
        }
    }

    public static /* synthetic */ Pair tryConsume$default(TokenBucket tokenBucket, long l, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            l = 1L;
        }
        return tokenBucket.tryConsume(l, function0);
    }

    public final long getTokenLimit() {
        return this.tokenLimit;
    }

    public final long getMaxSize() {
        return this.maxSize;
    }

    public final long getRefillTime() {
        return this.refillTime;
    }

    public TokenBucket(long tokenLimit, long maxSize, long refillTime, long initUpdate, long initTokenCount, @NotNull Function1<? super TokenBucket, Unit> refreshStrategy) {
        Intrinsics.checkParameterIsNotNull(refreshStrategy, (String)"refreshStrategy");
        this.tokenLimit = tokenLimit;
        this.maxSize = maxSize;
        this.refillTime = refillTime;
        this.initUpdate = initUpdate;
        this.initTokenCount = initTokenCount;
        this.refreshStrategy = refreshStrategy;
        this.lastUpdate = this.initUpdate;
        this.lock = new ReentrantLock(true);
        this.currentTokenCount = this.initTokenCount;
    }

    public /* synthetic */ TokenBucket(final long l, long l2, long l3, long l4, long l5, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            l5 = l;
        }
        if ((n & 0x20) != 0) {
            function1 = (Function1)new Function1<TokenBucket, Unit>(){

                public final void invoke(@NotNull TokenBucket it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    it.setCurrentTokenCount(l);
                }
            };
        }
        this(l, l2, l3, l4, l5, (Function1<? super TokenBucket, Unit>)function1);
    }

    static {
        Companion = new Companion(null);
        logger = CommonExtensionsKt.getLogger(Companion);
    }

    public final long component1() {
        return this.tokenLimit;
    }

    public final long component2() {
        return this.maxSize;
    }

    public final long component3() {
        return this.refillTime;
    }

    private final long component4() {
        return this.initUpdate;
    }

    private final long component5() {
        return this.initTokenCount;
    }

    private final Function1<TokenBucket, Unit> component6() {
        return this.refreshStrategy;
    }

    @NotNull
    public final TokenBucket copy(long tokenLimit, long maxSize, long refillTime, long initUpdate, long initTokenCount, @NotNull Function1<? super TokenBucket, Unit> refreshStrategy) {
        Intrinsics.checkParameterIsNotNull(refreshStrategy, (String)"refreshStrategy");
        return new TokenBucket(tokenLimit, maxSize, refillTime, initUpdate, initTokenCount, refreshStrategy);
    }

    public static /* synthetic */ TokenBucket copy$default(TokenBucket tokenBucket, long l, long l2, long l3, long l4, long l5, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            l = tokenBucket.tokenLimit;
        }
        if ((n & 2) != 0) {
            l2 = tokenBucket.maxSize;
        }
        if ((n & 4) != 0) {
            l3 = tokenBucket.refillTime;
        }
        if ((n & 8) != 0) {
            l4 = tokenBucket.initUpdate;
        }
        if ((n & 0x10) != 0) {
            l5 = tokenBucket.initTokenCount;
        }
        if ((n & 0x20) != 0) {
            function1 = tokenBucket.refreshStrategy;
        }
        return tokenBucket.copy(l, l2, l3, l4, l5, function1);
    }

    @NotNull
    public String toString() {
        return "TokenBucket(tokenLimit=" + this.tokenLimit + ", maxSize=" + this.maxSize + ", refillTime=" + this.refillTime + ", initUpdate=" + this.initUpdate + ", initTokenCount=" + this.initTokenCount + ", refreshStrategy=" + this.refreshStrategy + ")";
    }

    public int hashCode() {
        Function1<TokenBucket, Unit> function1 = this.refreshStrategy;
        return ((((Long.hashCode(this.tokenLimit) * 31 + Long.hashCode(this.maxSize)) * 31 + Long.hashCode(this.refillTime)) * 31 + Long.hashCode(this.initUpdate)) * 31 + Long.hashCode(this.initTokenCount)) * 31 + (function1 != null ? function1.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof TokenBucket)) break block3;
                TokenBucket tokenBucket = (TokenBucket)object;
                if (this.tokenLimit != tokenBucket.tokenLimit || this.maxSize != tokenBucket.maxSize || this.refillTime != tokenBucket.refillTime || this.initUpdate != tokenBucket.initUpdate || this.initTokenCount != tokenBucket.initTokenCount || !Intrinsics.areEqual(this.refreshStrategy, tokenBucket.refreshStrategy)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lbvanseg/kotlincommons/ratelimit/TokenBucket$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlincommons"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

