/*
 * Decompiled with CFR 0.152.
 */
package bvanseg.kotlincommons.time.api;

import bvanseg.kotlincommons.time.api.CenturyTransformer;
import bvanseg.kotlincommons.time.api.DayTransformer;
import bvanseg.kotlincommons.time.api.DecadeTransformer;
import bvanseg.kotlincommons.time.api.HourTransformer;
import bvanseg.kotlincommons.time.api.KTimeUnit$WhenMappings;
import bvanseg.kotlincommons.time.api.MicrosecondTransformer;
import bvanseg.kotlincommons.time.api.MillenniumTransformer;
import bvanseg.kotlincommons.time.api.MillisecondTransformer;
import bvanseg.kotlincommons.time.api.MinuteTransformer;
import bvanseg.kotlincommons.time.api.NanosecondTransformer;
import bvanseg.kotlincommons.time.api.SecondTransformer;
import bvanseg.kotlincommons.time.api.WeekTransformer;
import bvanseg.kotlincommons.time.api.YearTransformer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0011\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0000J\b\u0010\u000b\u001a\u0004\u0018\u00010\u0000J\b\u0010\f\u001a\u0004\u0018\u00010\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018\u00a8\u0006\u0019"}, d2={"Lbvanseg/kotlincommons/time/api/KTimeUnit;", "", "max", "", "(Ljava/lang/String;IJ)V", "getMax", "()J", "convertTo", "", "value", "unit", "getSubUnit", "getSuperUnit", "NANOSECOND", "MICROSECOND", "MILLISECOND", "SECOND", "MINUTE", "HOUR", "DAY", "WEEK", "YEAR", "DECADE", "CENTURY", "MILLENNIUM", "kotlincommons"})
public final class KTimeUnit
extends Enum<KTimeUnit> {
    public static final /* enum */ KTimeUnit NANOSECOND;
    public static final /* enum */ KTimeUnit MICROSECOND;
    public static final /* enum */ KTimeUnit MILLISECOND;
    public static final /* enum */ KTimeUnit SECOND;
    public static final /* enum */ KTimeUnit MINUTE;
    public static final /* enum */ KTimeUnit HOUR;
    public static final /* enum */ KTimeUnit DAY;
    public static final /* enum */ KTimeUnit WEEK;
    public static final /* enum */ KTimeUnit YEAR;
    public static final /* enum */ KTimeUnit DECADE;
    public static final /* enum */ KTimeUnit CENTURY;
    public static final /* enum */ KTimeUnit MILLENNIUM;
    private static final /* synthetic */ KTimeUnit[] $VALUES;
    private final long max;

    static {
        KTimeUnit[] kTimeUnitArray = new KTimeUnit[12];
        KTimeUnit[] kTimeUnitArray2 = kTimeUnitArray;
        kTimeUnitArray[0] = NANOSECOND = new KTimeUnit(1000L);
        kTimeUnitArray[1] = MICROSECOND = new KTimeUnit(1000L);
        kTimeUnitArray[2] = MILLISECOND = new KTimeUnit(1000L);
        kTimeUnitArray[3] = SECOND = new KTimeUnit(60L);
        kTimeUnitArray[4] = MINUTE = new KTimeUnit(60L);
        kTimeUnitArray[5] = HOUR = new KTimeUnit(24L);
        kTimeUnitArray[6] = DAY = new KTimeUnit("DAY", 6, 0L, 1, null);
        kTimeUnitArray[7] = WEEK = new KTimeUnit("WEEK", 7, 0L, 1, null);
        kTimeUnitArray[8] = YEAR = new KTimeUnit("YEAR", 8, 0L, 1, null);
        kTimeUnitArray[9] = DECADE = new KTimeUnit("DECADE", 9, 0L, 1, null);
        kTimeUnitArray[10] = CENTURY = new KTimeUnit("CENTURY", 10, 0L, 1, null);
        kTimeUnitArray[11] = MILLENNIUM = new KTimeUnit("MILLENNIUM", 11, 0L, 1, null);
        $VALUES = kTimeUnitArray;
    }

    public final double convertTo(double value, @NotNull KTimeUnit unit) {
        double d;
        Intrinsics.checkParameterIsNotNull((Object)((Object)unit), (String)"unit");
        if (value == 0.0) {
            return 0.0;
        }
        double d2 = value;
        boolean bl = false;
        if (Double.isNaN(d2)) {
            throw (Throwable)new IllegalArgumentException("Expected a valid time value but got " + value + " instead.");
        }
        d2 = value;
        bl = false;
        if (Double.isInfinite(d2)) {
            throw (Throwable)new IllegalArgumentException("Expected a finite value but got " + value + " instead.");
        }
        if (value < 0.0) {
            throw (Throwable)new IllegalArgumentException("Time value can not be negative: " + value + '.');
        }
        switch (KTimeUnit$WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
            case 1: {
                d = NanosecondTransformer.INSTANCE.transform(value, unit);
                break;
            }
            case 2: {
                d = MicrosecondTransformer.INSTANCE.transform(value, unit);
                break;
            }
            case 3: {
                d = MillisecondTransformer.INSTANCE.transform(value, unit);
                break;
            }
            case 4: {
                d = SecondTransformer.INSTANCE.transform(value, unit);
                break;
            }
            case 5: {
                d = MinuteTransformer.INSTANCE.transform(value, unit);
                break;
            }
            case 6: {
                d = HourTransformer.INSTANCE.transform(value, unit);
                break;
            }
            case 7: {
                d = DayTransformer.INSTANCE.transform(value, unit);
                break;
            }
            case 8: {
                d = WeekTransformer.INSTANCE.transform(value, unit);
                break;
            }
            case 9: {
                d = YearTransformer.INSTANCE.transform(value, unit);
                break;
            }
            case 10: {
                d = DecadeTransformer.INSTANCE.transform(value, unit);
                break;
            }
            case 11: {
                d = CenturyTransformer.INSTANCE.transform(value, unit);
                break;
            }
            case 12: {
                d = MillenniumTransformer.INSTANCE.transform(value, unit);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return d;
    }

    @Nullable
    public final KTimeUnit getSubUnit() {
        return (KTimeUnit)((Object)ArraysKt.getOrNull((Object[])KTimeUnit.values(), (int)(this.ordinal() - 1)));
    }

    @Nullable
    public final KTimeUnit getSuperUnit() {
        return (KTimeUnit)((Object)ArraysKt.getOrNull((Object[])KTimeUnit.values(), (int)(this.ordinal() + 1)));
    }

    public final long getMax() {
        return this.max;
    }

    private KTimeUnit(long max) {
        this.max = max;
    }

    /* synthetic */ KTimeUnit(String string2, int n, long l, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            l = 1L;
        }
        this(l);
    }

    public static KTimeUnit[] values() {
        return (KTimeUnit[])$VALUES.clone();
    }

    public static KTimeUnit valueOf(String string2) {
        return Enum.valueOf(KTimeUnit.class, string2);
    }
}

