/*
 * Decompiled with CFR 0.152.
 */
package bvanseg.kotlincommons.cache;

import bvanseg.kotlincommons.cache.CacheEntry;
import bvanseg.kotlincommons.cache.CacheKey;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000e\u001a\u00020\u000fJ1\u0010\u0010\u001a\u00028\u00012\u0006\u0010\u0011\u001a\u00028\u00002\b\b\u0002\u0010\u0012\u001a\u00020\u00052\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0014\u00a2\u0006\u0002\u0010\u0015J#\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u00172\u0006\u0010\u0018\u001a\u00028\u00002\u0006\u0010\u0012\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010\u0019J\u0015\u0010\u001a\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0011\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001bJ\u0015\u0010\u001c\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0011\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001bJ\u001b\u0010\u001d\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\t2\u0006\u0010\u0011\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001eJ%\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00028\u00012\b\b\u0002\u0010\u0012\u001a\u00020\u0005\u00a2\u0006\u0002\u0010 J#\u0010!\u001a\u00020\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u00172\u0006\u0010\u0018\u001a\u00028\u0001H\u0002\u00a2\u0006\u0002\u0010\"J\u0006\u0010#\u001a\u00020$J\u0006\u0010%\u001a\u00020$J\u001b\u0010&\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\t2\u0006\u0010\u0011\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001eJ\b\u0010'\u001a\u00020(H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006)"}, d2={"Lbvanseg/kotlincommons/cache/Cache;", "K", "V", "", "defaultTimeToLiveMS", "", "(J)V", "map", "Ljava/util/concurrent/ConcurrentHashMap;", "Lbvanseg/kotlincommons/cache/CacheEntry;", "size", "", "getSize", "()I", "clear", "", "computeIfAbsent", "key", "timeToLiveMS", "callback", "Lkotlin/Function1;", "(Ljava/lang/Object;JLkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "createKey", "Lbvanseg/kotlincommons/cache/CacheKey;", "value", "(Ljava/lang/Object;J)Lbvanseg/kotlincommons/cache/CacheKey;", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", "getAndInvalidate", "getEntry", "(Ljava/lang/Object;)Lbvanseg/kotlincommons/cache/CacheEntry;", "give", "(Ljava/lang/Object;Ljava/lang/Object;J)V", "insert", "(Lbvanseg/kotlincommons/cache/CacheKey;Ljava/lang/Object;)V", "isEmpty", "", "isNotEmpty", "remove", "toString", "", "kotlincommons"})
public final class Cache<K, V> {
    private final ConcurrentHashMap<K, CacheEntry<V>> map;
    private final long defaultTimeToLiveMS;

    private final int getSize() {
        return this.map.size();
    }

    public final boolean isEmpty() {
        return this.map.isEmpty();
    }

    public final boolean isNotEmpty() {
        Map map = this.map;
        boolean bl = false;
        return !map.isEmpty();
    }

    public final void give(K key, V value, long timeToLiveMS) {
        this.insert(this.createKey(key, timeToLiveMS), value);
    }

    public static /* synthetic */ void give$default(Cache cache, Object object, Object object2, long l, int n, Object object3) {
        if ((n & 4) != 0) {
            l = cache.defaultTimeToLiveMS;
        }
        cache.give(object, object2, l);
    }

    @Nullable
    public final CacheEntry<V> getEntry(K key) {
        return this.map.get(key);
    }

    @Nullable
    public final V get(K key) {
        CacheEntry<V> cacheEntry = this.map.compute(key, new BiFunction<K, CacheEntry<V>, CacheEntry<V>>(this){
            final /* synthetic */ Cache this$0;

            @Nullable
            public final CacheEntry<V> apply(K k, @Nullable CacheEntry<V> entry) {
                CacheEntry<V> cacheEntry;
                long currentTimeMS = System.currentTimeMillis();
                CacheEntry<V> cacheEntry2 = entry;
                if (cacheEntry2 != null) {
                    CacheEntry<V> cacheEntry3 = cacheEntry2;
                    boolean bl = false;
                    boolean bl2 = false;
                    CacheEntry<V> $this$run = cacheEntry3;
                    boolean bl3 = false;
                    if (currentTimeMS >= $this$run.getExpiration()) {
                        Cache.access$getMap$p(this.this$0).remove(k);
                        cacheEntry = null;
                    } else {
                        cacheEntry = entry;
                    }
                } else {
                    cacheEntry = null;
                }
                return cacheEntry;
            }
            {
                this.this$0 = cache;
            }
        });
        return (V)(cacheEntry != null ? cacheEntry.getValue() : null);
    }

    @Nullable
    public final V getAndInvalidate(K key) {
        CacheEntry<V> cacheEntry = this.map.remove(key);
        return (V)(cacheEntry != null ? cacheEntry.getValue() : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void insert(CacheKey<K> key, V value) {
        ConcurrentHashMap<K, CacheEntry<V>> concurrentHashMap = this.map;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (concurrentHashMap) {
            boolean bl3 = false;
            ((Map)this.map).put(key.getValue(), new CacheEntry<V>(value, key.getTimeToLiveMS() + System.currentTimeMillis()));
            Unit unit = Unit.INSTANCE;
        }
    }

    private final CacheKey<K> createKey(K value, long timeToLiveMS) {
        return new CacheKey<K>(value, timeToLiveMS);
    }

    public final void clear() {
        this.map.clear();
    }

    @Nullable
    public final CacheEntry<V> remove(K key) {
        return this.map.remove(key);
    }

    public final V computeIfAbsent(K key, long timeToLiveMS, @NotNull Function1<? super K, ? extends V> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        CacheEntry<V> cacheEntry = this.map.compute(key, new BiFunction<K, CacheEntry<V>, CacheEntry<V>>(callback, timeToLiveMS){
            final /* synthetic */ Function1 $callback;
            final /* synthetic */ long $timeToLiveMS;

            @Nullable
            public final CacheEntry<V> apply(K k, @Nullable CacheEntry<V> entry) {
                long currentTimeMS = System.currentTimeMillis();
                return entry != null && currentTimeMS < entry.getExpiration() ? entry : new CacheEntry<V>((Object)this.$callback.invoke(k), currentTimeMS + this.$timeToLiveMS);
            }
            {
                this.$callback = function1;
                this.$timeToLiveMS = l;
            }
        });
        Intrinsics.checkNotNull(cacheEntry);
        return cacheEntry.getValue();
    }

    public static /* synthetic */ Object computeIfAbsent$default(Cache cache, Object object, long l, Function1 function1, int n, Object object2) {
        if ((n & 2) != 0) {
            l = cache.defaultTimeToLiveMS;
        }
        return cache.computeIfAbsent(object, l, function1);
    }

    @NotNull
    public String toString() {
        String string2 = this.map.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"map.toString()");
        return string2;
    }

    public Cache(long defaultTimeToLiveMS) {
        this.defaultTimeToLiveMS = defaultTimeToLiveMS;
        this.map = new ConcurrentHashMap();
    }

    public static final /* synthetic */ ConcurrentHashMap access$getMap$p(Cache $this) {
        return $this.map;
    }
}

