/*
 * Decompiled with CFR 0.152.
 */
package bvanseg.kotlincommons.event.bus;

import bvanseg.kotlincommons.any.CommonExtensionsKt;
import bvanseg.kotlincommons.event.annotation.SubscribeEvent;
import bvanseg.kotlincommons.event.event.InternalEvent;
import bvanseg.kotlincommons.kclass.KClassExtensionsKt;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KAnnotatedElement;
import kotlin.reflect.KCallable;
import kotlin.reflect.KClass;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.full.KCallables;
import kotlin.reflect.full.KClasses;
import kotlin.reflect.jvm.KCallablesJvm;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0001J\u000e\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0001J\u001a\u0010\u0010\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010\u0011\u001a\u00020\u0001J\u0016\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0001J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u0001R>\u0010\u0003\u001a2\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004j\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R>\u0010\t\u001a2\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004j\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lbvanseg/kotlincommons/event/bus/EventBus;", "", "()V", "events", "Ljava/util/HashMap;", "Ljava/lang/Class;", "", "Lbvanseg/kotlincommons/event/event/InternalEvent;", "Lkotlin/collections/HashMap;", "listenerEvents", "listeners", "addListener", "", "listener", "fire", "e", "fireForListener", "event", "removeListener", "", "Companion", "kotlincommons"})
public final class EventBus {
    private final List<Object> listeners;
    private final HashMap<Class<?>, List<InternalEvent>> listenerEvents;
    private final HashMap<Class<?>, List<InternalEvent>> events;
    @NotNull
    private static final EventBus DEFAULT;
    private static final Logger logger;
    @NotNull
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    public final void addListener(@NotNull Object listener) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Iterable $this$filter$iv = KClasses.getMemberFunctions((KClass)Reflection.getOrCreateKotlinClass(listener.getClass()));
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Object v0;
            block12: {
                KFunction it = (KFunction)element$iv$iv;
                boolean bl = false;
                KAnnotatedElement $this$findAnnotation$iv = (KAnnotatedElement)it;
                boolean $i$f$findAnnotation = false;
                Iterable $this$firstOrNull$iv$iv = $this$findAnnotation$iv.getAnnotations();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv$iv2 : $this$firstOrNull$iv$iv) {
                    Annotation it$iv = (Annotation)element$iv$iv2;
                    boolean bl2 = false;
                    if (!(it$iv instanceof SubscribeEvent)) continue;
                    v0 = element$iv$iv2;
                    break block12;
                }
                v0 = null;
            }
            if (!((Annotation)v0 != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KFunction function = (KFunction)element$iv;
            boolean bl = false;
            if (!KCallablesJvm.isAccessible((KCallable)((KCallable)function))) {
                Method method = ReflectJvmMapping.getJavaMethod((KFunction)function);
                if (method != null) {
                    method.trySetAccessible();
                }
            }
            InternalEvent event = new InternalEvent(function, listener);
            if ((KParameter)CollectionsKt.firstOrNull((List)KCallables.getValueParameters((KCallable)((KCallable)function))) != null) {
                KParameter kParameter;
                boolean bl3 = false;
                boolean bl4 = false;
                KParameter param = kParameter;
                boolean bl5 = false;
                Class clazz = JvmClassMappingKt.getJavaClass(KClassExtensionsKt.getKClass(param.getType()));
                if (this.events.get(clazz) == null) {
                    boolean bl6 = false;
                    ((Map)this.events).put(clazz, (List)new ArrayList());
                }
                if (this.events.get(clazz) != null) {
                    List<InternalEvent> list;
                    boolean bl7 = false;
                    boolean bl8 = false;
                    List<InternalEvent> it = list;
                    boolean bl9 = false;
                    if (it.add(event)) {
                        logger.debug("Successfully added event " + event + " with parameter type " + clazz + " for listener " + listener);
                    }
                } else {
                    logger.warn("Failed to add event " + event + " for listener " + listener + '!');
                }
            } else {
                throw (Throwable)new RuntimeException("Failed to add event listener. Subscribed event function must have a single parameter!");
            }
            if (this.listenerEvents.get(listener.getClass()) == null) {
                boolean bl10 = false;
                ((Map)this.listenerEvents).put(listener.getClass(), (List)new ArrayList());
            }
            List<InternalEvent> list = this.listenerEvents.get(listener.getClass());
            Intrinsics.checkNotNull(list);
            list.add(event);
        }
        this.listeners.add(listener);
        logger.debug("Successfully added listener " + listener);
    }

    public final boolean removeListener(@NotNull Object listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        return this.listeners.remove(listener);
    }

    public final void fire(@NotNull Object e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        List<InternalEvent> list = this.events.get(e.getClass());
        if (list != null) {
            List<InternalEvent> list2 = list;
            boolean bl = false;
            boolean bl2 = false;
            List<InternalEvent> list3 = list2;
            boolean bl3 = false;
            List<InternalEvent> list4 = list3;
            Intrinsics.checkNotNullExpressionValue(list4, (String)"list");
            Iterable $this$forEach$iv = list4;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv = iterator.next();
                InternalEvent it = (InternalEvent)element$iv;
                boolean bl4 = false;
                logger.debug("Firing event " + it + " with object " + e);
                it.invoke(e);
            }
            for (KClass c : KClasses.getSuperclasses((KClass)Reflection.getOrCreateKotlinClass(e.getClass()))) {
                if (this.events.get(JvmClassMappingKt.getJavaClass((KClass)c)) != null) {
                    boolean bl5 = false;
                    boolean bl6 = false;
                    Object it = iterator;
                    boolean bl7 = false;
                    Object object = it;
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it");
                    Iterable $this$forEach$iv2 = (Iterable)object;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv : $this$forEach$iv2) {
                        InternalEvent it2 = (InternalEvent)element$iv;
                        boolean bl8 = false;
                        it2.invoke(e);
                    }
                }
            }
        }
    }

    public final void fireForListener(@NotNull Object listener, @NotNull Object event) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.fireForListener(listener.getClass(), event);
    }

    public final void fireForListener(@NotNull Class<?> listener, @NotNull Object event) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        List<InternalEvent> list = this.listenerEvents.get(listener);
        if (list != null) {
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                InternalEvent it = (InternalEvent)element$iv;
                boolean bl = false;
                if ((KParameter)CollectionsKt.firstOrNull((List)KCallables.getValueParameters((KCallable)((KCallable)it.getFunction()))) != null) {
                    KParameter kParameter;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    KParameter param = kParameter;
                    boolean bl4 = false;
                    Class clazz = JvmClassMappingKt.getJavaClass(KClassExtensionsKt.getKClass(param.getType()));
                    if (Intrinsics.areEqual(event.getClass(), (Object)clazz)) {
                        it.invoke(event);
                    }
                    for (KClass c : KClasses.getSuperclasses((KClass)Reflection.getOrCreateKotlinClass(event.getClass()))) {
                        if (!Intrinsics.areEqual((Object)clazz, (Object)JvmClassMappingKt.getJavaClass((KClass)c))) continue;
                        it.invoke(event);
                    }
                }
            }
        }
    }

    public EventBus() {
        boolean bl = false;
        this.listeners = new ArrayList();
        bl = false;
        this.listenerEvents = new HashMap();
        bl = false;
        this.events = new HashMap();
    }

    static {
        Companion = new Companion(null);
        DEFAULT = new EventBus();
        logger = CommonExtensionsKt.getLogger(Companion);
    }

    @NotNull
    public static final EventBus getDEFAULT() {
        Companion companion = Companion;
        return DEFAULT;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lbvanseg/kotlincommons/event/bus/EventBus$Companion;", "", "()V", "DEFAULT", "Lbvanseg/kotlincommons/event/bus/EventBus;", "getDEFAULT$annotations", "getDEFAULT", "()Lbvanseg/kotlincommons/event/bus/EventBus;", "logger", "Lorg/slf4j/Logger;", "kotlincommons"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void getDEFAULT$annotations() {
        }

        @NotNull
        public final EventBus getDEFAULT() {
            return DEFAULT;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

