/*
 * Decompiled with CFR 0.152.
 */
package bvanseg.kotlincommons.ratelimit;

import bvanseg.kotlincommons.any.CommonExtensionsKt;
import bvanseg.kotlincommons.ratelimit.RateLimiter;
import bvanseg.kotlincommons.ratelimit.TokenBucket;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u000f\u0018\u0000 \u001c*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u001cBW\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012>\b\u0002\u0010\u0007\u001a8\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0000\u0012\u0004\u0012\u00020\t\u0012\u001c\u0012\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u000b0\n\u0012\u0004\u0012\u00020\u000e0\b\u00a2\u0006\u0002\u0010\u000fJ\u0006\u0010\u0014\u001a\u00020\u000eJ\u001e\u0010\u0015\u001a\u00020\u000e2\b\b\u0002\u0010\u0016\u001a\u00020\f2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ\u0010\u0010\u0018\u001a\u00020\u000e2\b\b\u0002\u0010\u0016\u001a\u00020\fJ)\u0010\u0018\u001a\u0002H\u0019\"\u0004\b\u0001\u0010\u00192\b\b\u0002\u0010\u0016\u001a\u00020\f2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00190\r\u00a2\u0006\u0002\u0010\u001bR\u000e\u0010\u0010\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0011\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001d"}, d2={"Lbvanseg/kotlincommons/ratelimit/RateLimiter;", "T", "", "tokenBucket", "Lbvanseg/kotlincommons/ratelimit/TokenBucket;", "service", "Ljava/util/concurrent/ScheduledExecutorService;", "cycleStrategy", "Lkotlin/Function3;", "Ljava/util/concurrent/atomic/AtomicLong;", "Ljava/util/concurrent/ConcurrentLinkedDeque;", "Lkotlin/Pair;", "", "Lkotlin/Function0;", "", "(Lbvanseg/kotlincommons/ratelimit/TokenBucket;Ljava/util/concurrent/ScheduledExecutorService;Lkotlin/jvm/functions/Function3;)V", "blockingCount", "queue", "getTokenBucket", "()Lbvanseg/kotlincommons/ratelimit/TokenBucket;", "shutdown", "submit", "consume", "ratelimitCallback", "submitBlocking", "R", "callback", "(JLkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "Companion", "kotlincommons"})
public final class RateLimiter<T> {
    private final AtomicLong blockingCount;
    private final ConcurrentLinkedDeque<Pair<Long, Function0<Unit>>> queue;
    @NotNull
    private final TokenBucket tokenBucket;
    private final ScheduledExecutorService service;
    @NotNull
    private static final Logger logger;
    @NotNull
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void submit(long consume, @NotNull Function0<Unit> ratelimitCallback) {
        Intrinsics.checkNotNullParameter(ratelimitCallback, (String)"ratelimitCallback");
        logger.trace("Received asynchronous submission.");
        if (this.queue.isEmpty()) {
            TokenBucket tokenBucket = this.tokenBucket;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (tokenBucket) {
                boolean bl3 = false;
                Pair<Boolean, Unit> pair2 = this.tokenBucket.tryConsume(consume, ratelimitCallback);
                if (!((Boolean)pair2.getFirst()).booleanValue()) {
                    this.queue.addLast((Pair<Long, Function0<Unit>>)TuplesKt.to((Object)consume, ratelimitCallback));
                }
                Unit unit = Unit.INSTANCE;
            }
        } else if ((long)this.queue.size() < this.tokenBucket.getMaxSize()) {
            this.queue.addLast((Pair<Long, Function0<Unit>>)TuplesKt.to((Object)consume, ratelimitCallback));
        }
    }

    public static /* synthetic */ void submit$default(RateLimiter rateLimiter, long l, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            l = 1L;
        }
        rateLimiter.submit(l, (Function0<Unit>)function0);
    }

    public final <R> R submitBlocking(long consume, @NotNull Function0<? extends R> callback) {
        Pair<Boolean, ? extends R> pair2;
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        logger.trace("Executing blocking submission...");
        do {
            this.blockingCount.incrementAndGet();
            pair2 = this.tokenBucket.tryConsume(consume, callback);
            this.blockingCount.decrementAndGet();
        } while (!((Boolean)pair2.getFirst()).booleanValue());
        logger.trace("Finished executing submission: TokenBucket " + '(' + this.tokenBucket.getCurrentTokenCount() + '/' + this.tokenBucket.getTokenLimit() + ").");
        Object object = pair2.getSecond();
        Intrinsics.checkNotNull((Object)object);
        return (R)object;
    }

    public static /* synthetic */ Object submitBlocking$default(RateLimiter rateLimiter, long l, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            l = 1L;
        }
        return rateLimiter.submitBlocking(l, function0);
    }

    public final void submitBlocking(long consume) {
        Pair pair2;
        logger.trace("Entering blocking submission...");
        do {
            this.blockingCount.incrementAndGet();
            pair2 = this.tokenBucket.tryConsume(consume, submitBlocking.pair.1.INSTANCE);
            this.blockingCount.decrementAndGet();
        } while (!((Boolean)pair2.getFirst()).booleanValue());
        logger.trace("Finished executing submission: TokenBucket " + '(' + this.tokenBucket.getCurrentTokenCount() + '/' + this.tokenBucket.getTokenLimit() + ").");
    }

    public static /* synthetic */ void submitBlocking$default(RateLimiter rateLimiter, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = 1L;
        }
        rateLimiter.submitBlocking(l);
    }

    public final void shutdown() {
        logger.trace("Shutting down RateLimiter...");
        this.service.shutdown();
    }

    @NotNull
    public final TokenBucket getTokenBucket() {
        return this.tokenBucket;
    }

    public RateLimiter(@NotNull TokenBucket tokenBucket, @NotNull ScheduledExecutorService service, @NotNull Function3<? super RateLimiter<T>, ? super AtomicLong, ? super ConcurrentLinkedDeque<Pair<Long, Function0<Unit>>>, Unit> cycleStrategy) {
        Intrinsics.checkNotNullParameter((Object)tokenBucket, (String)"tokenBucket");
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter(cycleStrategy, (String)"cycleStrategy");
        this.tokenBucket = tokenBucket;
        this.service = service;
        this.blockingCount = new AtomicLong(0L);
        this.queue = new ConcurrentLinkedDeque();
        cycleStrategy.invoke((Object)this, (Object)this.blockingCount, this.queue);
    }

    public /* synthetic */ RateLimiter(final TokenBucket tokenBucket, final ScheduledExecutorService scheduledExecutorService, Function3 function3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            ScheduledExecutorService scheduledExecutorService2 = Executors.newSingleThreadScheduledExecutor(1.INSTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService2, (String)"Executors.newSingleThrea\u2026true\n        thread\n    }");
            scheduledExecutorService = scheduledExecutorService2;
        }
        if ((n & 4) != 0) {
            function3 = new Function3<RateLimiter<T>, AtomicLong, ConcurrentLinkedDeque<Pair<? extends Long, ? extends Function0<? extends Unit>>>, Unit>(){

                public final void invoke(@NotNull RateLimiter<T> ratelimiter, final @NotNull AtomicLong bc, final @NotNull ConcurrentLinkedDeque<Pair<Long, Function0<Unit>>> q) {
                    Intrinsics.checkNotNullParameter(ratelimiter, (String)"ratelimiter");
                    Intrinsics.checkNotNullParameter((Object)bc, (String)"bc");
                    Intrinsics.checkNotNullParameter(q, (String)"q");
                    scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

                        @Override
                        public final void run() {
                            tokenBucket.refill();
                            while (tokenBucket.isNotEmpty()) {
                                Pair pair2;
                                while (bc.get() > 0L) {
                                    Thread.onSpinWait();
                                }
                                Pair next = (Pair)q.pollFirst();
                                if (next == null) break;
                                boolean bl = false;
                                boolean bl2 = false;
                                Pair it = pair2;
                                boolean bl3 = false;
                                Pair pair3 = tokenBucket.tryConsume(((Number)it.getFirst()).longValue(), (Function0)it.getSecond());
                                if (((Boolean)pair3.getFirst()).booleanValue()) {
                                    Companion.getLogger().trace("Executed queued submission: TokenBucket (" + tokenBucket.getCurrentTokenCount() + '/' + tokenBucket.getTokenLimit() + ").");
                                    continue;
                                }
                                q.addFirst(TuplesKt.to((Object)it.getFirst(), (Object)it.getSecond()));
                            }
                        }
                    }, tokenBucket.getRefillTime(), tokenBucket.getRefillTime(), TimeUnit.MILLISECONDS);
                }
            };
        }
        this(tokenBucket, scheduledExecutorService, function3);
    }

    static {
        Companion = new Companion(null);
        logger = CommonExtensionsKt.getLogger(Companion);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lbvanseg/kotlincommons/ratelimit/RateLimiter$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "kotlincommons"})
    public static final class Companion {
        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

