/*
 * Decompiled with CFR 0.152.
 */
package bvanseg.kotlincommons.time;

import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a$\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u001e\u0010\n\u001a\u00020\u0004*\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\t2\b\b\u0002\u0010\b\u001a\u00020\t\u001a\n\u0010\r\u001a\u00020\u0004*\u00020\u000e\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"fileSafeFormat", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "timePairToString", "", "pair", "Lkotlin/Pair;", "", "shorthand", "", "format", "Ljava/time/Duration;", "millis", "toFileSafeString", "Ljava/time/LocalDateTime;", "kotlincommons"})
public final class TimeExtensionsKt {
    private static final DateTimeFormatter fileSafeFormat = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral('_').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral('-').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral('-').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalStart().appendLiteral('-').appendValue(ChronoField.MILLI_OF_SECOND, 3).toFormatter();

    @NotNull
    public static final String toFileSafeString(@NotNull LocalDateTime $this$toFileSafeString) {
        Intrinsics.checkNotNullParameter((Object)$this$toFileSafeString, (String)"$this$toFileSafeString");
        String string2 = $this$toFileSafeString.format(fileSafeFormat);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this.format(fileSafeFormat)");
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String format(@NotNull Duration $this$format, boolean millis, boolean shorthand) {
        int size;
        Intrinsics.checkNotNullParameter((Object)$this$format, (String)"$this$format");
        long milliseconds = millis ? $this$format.toMillis() % (long)1000 : 0L;
        long seconds = $this$format.getSeconds() % (long)60;
        long minutes = $this$format.getSeconds() % (long)3600 / (long)60;
        long hours = $this$format.getSeconds() / (long)3600;
        ArrayList<Pair> list = new ArrayList<Pair>();
        if (hours > 0L) {
            list.add(TuplesKt.to((Object)hours, (Object)(shorthand ? "h" : "hour")));
        }
        if (minutes > 0L) {
            list.add(TuplesKt.to((Object)minutes, (Object)(shorthand ? "m" : "minute")));
        }
        if (seconds > 0L) {
            list.add(TuplesKt.to((Object)seconds, (Object)(shorthand ? "s" : "second")));
        }
        if (milliseconds > 0L) {
            list.add(TuplesKt.to((Object)milliseconds, (Object)(shorthand ? "ms" : "millisecond")));
        }
        if ((size = list.size()) == 0) {
            return shorthand ? "0 " + (millis ? "m" : "") + 's' : "0 " + (millis ? "milli" : "") + "seconds";
        }
        if (size == 1) {
            Object e = list.get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"list[0]");
            return TimeExtensionsKt.timePairToString((Pair<Long, String>)((Pair)e), shorthand);
        }
        StringBuilder sb = new StringBuilder();
        Iterable $this$forEachIndexed$iv = list;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void timePair;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Pair pair2 = (Pair)item$iv;
            int index = n;
            boolean bl2 = false;
            sb.append(TimeExtensionsKt.timePairToString((Pair<Long, String>)timePair, shorthand));
            switch (size - index) {
                case 1: {
                    break;
                }
                case 2: {
                    sb.append(shorthand ? ", " : " and ");
                    break;
                }
                default: {
                    sb.append(", ");
                }
            }
        }
        String string2 = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sb.toString()");
        return string2;
    }

    public static /* synthetic */ String format$default(Duration duration, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        return TimeExtensionsKt.format(duration, bl, bl2);
    }

    private static final String timePairToString(Pair<Long, String> pair2, boolean shorthand) {
        return ((Number)pair2.getFirst()).longValue() + (shorthand ? "" : " ") + (String)pair2.getSecond() + (((Number)pair2.getFirst()).longValue() != 1L && !shorthand ? "s" : "");
    }
}

