/*
 * Decompiled with CFR 0.152.
 */
package bvanseg.kotlincommons;

import java.lang.management.ManagementFactory;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u0006\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\nR\u0011\u0010\u000f\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\nR\u0011\u0010\u0011\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\nR\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\nR\u0011\u0010\u0019\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\nR\u0011\u0010\u001b\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0006R\u0011\u0010\u001d\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0006\u00a8\u0006\u001f"}, d2={"Lbvanseg/kotlincommons/SystemInfo;", "", "()V", "freeMemory", "", "getFreeMemory", "()J", "javaVendor", "", "getJavaVendor", "()Ljava/lang/String;", "maxMemory", "getMaxMemory", "osArchitecture", "getOsArchitecture", "osName", "getOsName", "osVersion", "getOsVersion", "processCpuLoad", "", "getProcessCpuLoad", "()D", "runtimeJavaVersion", "getRuntimeJavaVersion", "systemJavaVersion", "getSystemJavaVersion", "totalMemory", "getTotalMemory", "usedMemory", "getUsedMemory", "kotlincommons"})
public final class SystemInfo {
    @NotNull
    public static final SystemInfo INSTANCE;

    public final long getMaxMemory() {
        return Runtime.getRuntime().maxMemory();
    }

    public final long getUsedMemory() {
        return this.getTotalMemory() - this.getFreeMemory();
    }

    public final long getTotalMemory() {
        return Runtime.getRuntime().totalMemory();
    }

    public final long getFreeMemory() {
        return Runtime.getRuntime().freeMemory();
    }

    public final double getProcessCpuLoad() {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName name = ObjectName.getInstance("java.lang:type=OperatingSystem");
            AttributeList list = mbs.getAttributes(name, new String[]{"ProcessCpuLoad"});
            if (list.isEmpty()) {
                return Double.NaN;
            }
            Object e = list.get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type javax.management.Attribute");
            }
            Attribute att = (Attribute)e;
            Object object = att.getValue();
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
            }
            double value = (Double)object;
            return value == -1.0 ? Double.NaN : (double)((int)(value * (double)1000)) / 10.0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    @NotNull
    public final String getRuntimeJavaVersion() {
        String string2 = Runtime.version().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"Runtime.version().toString()");
        return string2;
    }

    @NotNull
    public final String getSystemJavaVersion() {
        String string2 = System.getProperty("java.version");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"System.getProperty(\"java.version\")");
        return string2;
    }

    @NotNull
    public final String getJavaVendor() {
        String string2 = System.getProperty("java.vendor");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"System.getProperty(\"java.vendor\")");
        return string2;
    }

    @NotNull
    public final String getOsName() {
        String string2 = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"System.getProperty(\"os.name\")");
        return string2;
    }

    @NotNull
    public final String getOsArchitecture() {
        String string2 = System.getProperty("os.arch");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"System.getProperty(\"os.arch\")");
        return string2;
    }

    @NotNull
    public final String getOsVersion() {
        String string2 = System.getProperty("os.version");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"System.getProperty(\"os.version\")");
        return string2;
    }

    private SystemInfo() {
    }

    static {
        SystemInfo systemInfo;
        INSTANCE = systemInfo = new SystemInfo();
    }
}

