/*
 * Decompiled with CFR 0.152.
 */
package bvanseg.kotlincommons.math;

import bvanseg.kotlincommons.graphic.Color;
import bvanseg.kotlincommons.util.project.Experimental;
import java.text.NumberFormat;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\u0015\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0005\u001a\f\u0010\u0006\u001a\u00020\u0007*\u00020\bH\u0007\u001a?\u0010\t\u001a\u0002H\n\"\u0014\b\u0000\u0010\n\u0018\u0001*\u00020\u0005*\b\u0012\u0004\u0012\u0002H\n0\u000b*\u0002H\n2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u0002H\n\u0012\u0004\u0012\u00020\u000e0\rH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000f\u001a?\u0010\u0010\u001a\u0002H\n\"\u0014\b\u0000\u0010\n\u0018\u0001*\u00020\u0005*\b\u0012\u0004\u0012\u0002H\n0\u000b*\u0002H\n2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u0002H\n\u0012\u0004\u0012\u00020\u000e0\rH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000f\u001a\n\u0010\u0011\u001a\u00020\u0012*\u00020\u0005\u001a\n\u0010\u0013\u001a\u00020\u0012*\u00020\u0005\u001a\n\u0010\u0014\u001a\u00020\u0012*\u00020\u0005\u001a\n\u0010\u0015\u001a\u00020\u0012*\u00020\u0005\u001a\f\u0010\u0016\u001a\u00020\b*\u00020\u0005H\u0007\u001a\u001e\u0010\u0017\u001a\u0002H\n\"\n\b\u0000\u0010\n\u0018\u0001*\u00020\u0005*\u00020\u0005H\u0086\b\u00a2\u0006\u0002\u0010\u0018\u001a\n\u0010\u0019\u001a\u00020\u001a*\u00020\u0005\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001b"}, d2={"numberFormat", "Ljava/text/NumberFormat;", "kotlin.jvm.PlatformType", "format", "", "", "getDigits", "", "", "ifNegative", "T", "", "block", "Lkotlin/Function1;", "", "(Ljava/lang/Number;Lkotlin/jvm/functions/Function1;)Ljava/lang/Number;", "ifPositive", "isEven", "", "isNegative", "isOdd", "isPositive", "numDigits", "to", "(Ljava/lang/Number;)Ljava/lang/Number;", "toColor", "Lbvanseg/kotlincommons/graphic/Color;", "kotlincommons"})
public final class NumberExtensionsKt {
    private static final NumberFormat numberFormat = NumberFormat.getNumberInstance();

    @NotNull
    public static final String format(@NotNull Number $this$format) {
        Intrinsics.checkNotNullParameter((Object)$this$format, (String)"$this$format");
        String string2 = numberFormat.format($this$format);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"numberFormat.format(this)");
        return string2;
    }

    public static final boolean isEven(@NotNull Number $this$isEven) {
        Intrinsics.checkNotNullParameter((Object)$this$isEven, (String)"$this$isEven");
        return $this$isEven.doubleValue() % (double)2 == 0.0;
    }

    @NotNull
    public static final Color toColor(@NotNull Number $this$toColor) {
        Intrinsics.checkNotNullParameter((Object)$this$toColor, (String)"$this$toColor");
        return new Color($this$toColor.intValue(), 0, 2, null);
    }

    public static final boolean isOdd(@NotNull Number $this$isOdd) {
        Intrinsics.checkNotNullParameter((Object)$this$isOdd, (String)"$this$isOdd");
        return !NumberExtensionsKt.isEven($this$isOdd);
    }

    public static final boolean isPositive(@NotNull Number $this$isPositive) {
        Intrinsics.checkNotNullParameter((Object)$this$isPositive, (String)"$this$isPositive");
        return $this$isPositive.doubleValue() > 0.0;
    }

    public static final boolean isNegative(@NotNull Number $this$isNegative) {
        Intrinsics.checkNotNullParameter((Object)$this$isNegative, (String)"$this$isNegative");
        return !NumberExtensionsKt.isPositive($this$isNegative);
    }

    @Experimental
    public static final int numDigits(@NotNull Number $this$numDigits) {
        Intrinsics.checkNotNullParameter((Object)$this$numDigits, (String)"$this$numDigits");
        double d = $this$numDigits.doubleValue();
        boolean bl = false;
        return (int)(Math.log10(d) + 1.0);
    }

    @Experimental
    @NotNull
    public static final int[] getDigits(int $this$getDigits) {
        if ($this$getDigits == 0) {
            return new int[0];
        }
        int[] array = new int[NumberExtensionsKt.numDigits($this$getDigits)];
        int i = 0;
        for (int number = $this$getDigits; number > 0; number /= 10) {
            array[i++] = number % 10;
        }
        ArraysKt.reverse((int[])array);
        return array;
    }

    public static final /* synthetic */ <T extends Number> T to(Number $this$to) {
        Number number;
        int $i$f$to = 0;
        Intrinsics.checkNotNullParameter((Object)$this$to, (String)"$this$to");
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        KClass kClass = Reflection.getOrCreateKotlinClass(Number.class);
        if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
            Byte by = $this$to.byteValue();
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            number = by;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE))) {
            Short s = $this$to.shortValue();
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            number = s;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            Integer n = $this$to.intValue();
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            number = n;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            Long l = $this$to.longValue();
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            number = l;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
            Float f = Float.valueOf($this$to.floatValue());
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            number = f;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
            Double d = $this$to.doubleValue();
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            number = d;
        } else {
            StringBuilder stringBuilder = new StringBuilder().append("The destination type ");
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            throw (Throwable)new RuntimeException(stringBuilder.append(Reflection.getOrCreateKotlinClass(Number.class)).append(" is not a primitive!").toString());
        }
        return (T)number;
    }

    public static final /* synthetic */ <T extends Number> T ifPositive(T $this$ifPositive, Function1<? super T, Unit> block) {
        Number number;
        int $i$f$ifPositive = 0;
        Intrinsics.checkNotNullParameter($this$ifPositive, (String)"$this$ifPositive");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Comparable comparable = (Comparable)((Object)$this$ifPositive);
        int $this$to$iv = 0;
        boolean $i$f$to = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        KClass kClass = Reflection.getOrCreateKotlinClass(Number.class);
        if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
            Byte by = (byte)$this$to$iv;
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            number = by;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE))) {
            Short s = (short)$this$to$iv;
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            number = s;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            Integer n = $this$to$iv;
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            number = n;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            Long l = $this$to$iv;
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            number = l;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
            Float f = Float.valueOf($this$to$iv);
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            number = f;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
            Double d = $this$to$iv;
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            number = d;
        } else {
            StringBuilder stringBuilder = new StringBuilder().append("The destination type ");
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            throw (Throwable)new RuntimeException(stringBuilder.append(Reflection.getOrCreateKotlinClass(Number.class)).append(" is not a primitive!").toString());
        }
        if (comparable.compareTo(number) > 0) {
            block.invoke($this$ifPositive);
        }
        return $this$ifPositive;
    }

    public static final /* synthetic */ <T extends Number> T ifNegative(T $this$ifNegative, Function1<? super T, Unit> block) {
        Number number;
        int $i$f$ifNegative = 0;
        Intrinsics.checkNotNullParameter($this$ifNegative, (String)"$this$ifNegative");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Comparable comparable = (Comparable)((Object)$this$ifNegative);
        int $this$to$iv = 0;
        boolean $i$f$to = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        KClass kClass = Reflection.getOrCreateKotlinClass(Number.class);
        if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
            Byte by = (byte)$this$to$iv;
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            number = by;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE))) {
            Short s = (short)$this$to$iv;
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            number = s;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            Integer n = $this$to$iv;
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            number = n;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            Long l = $this$to$iv;
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            number = l;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
            Float f = Float.valueOf($this$to$iv);
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            number = f;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
            Double d = $this$to$iv;
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            number = d;
        } else {
            StringBuilder stringBuilder = new StringBuilder().append("The destination type ");
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            throw (Throwable)new RuntimeException(stringBuilder.append(Reflection.getOrCreateKotlinClass(Number.class)).append(" is not a primitive!").toString());
        }
        if (comparable.compareTo(number) < 0) {
            block.invoke($this$ifNegative);
        }
        return $this$ifNegative;
    }
}

