/*
 * Decompiled with CFR 0.152.
 */
package bvanseg.kotlincommons.time.api;

import bvanseg.kotlincommons.lang.string.ToStringBuilder;
import bvanseg.kotlincommons.time.api.KTimeUnit;
import bvanseg.kotlincommons.util.HashCodeBuilder;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 )2\u00020\u0001:\u0001)B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0005J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0006\u0010\u0016\u001a\u00020\u0003J\u0006\u0010\u0017\u001a\u00020\u0003J\u0006\u0010\u0018\u001a\u00020\u0003J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u0003J\u0006\u0010\u001c\u001a\u00020\u0003J\u0006\u0010\u001d\u001a\u00020\u0003J\u0006\u0010\u001e\u001a\u00020\u0003J\u0006\u0010\u001f\u001a\u00020\u0003J\u0006\u0010 \u001a\u00020\u0003J\u0006\u0010!\u001a\u00020\u0003J\u0006\u0010\"\u001a\u00020\u0003J\u0006\u0010#\u001a\u00020\u0003J\u0006\u0010$\u001a\u00020\u0003J\b\u0010%\u001a\u00020&H\u0016J\u0006\u0010'\u001a\u00020\u0003J\u0006\u0010(\u001a\u00020\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006*"}, d2={"Lbvanseg/kotlincommons/time/api/KTime;", "", "value", "", "unit", "Lbvanseg/kotlincommons/time/api/KTimeUnit;", "(DLbvanseg/kotlincommons/time/api/KTimeUnit;)V", "getUnit", "()Lbvanseg/kotlincommons/time/api/KTimeUnit;", "setUnit", "(Lbvanseg/kotlincommons/time/api/KTimeUnit;)V", "getValue", "()D", "setValue", "(D)V", "convertTo", "otherUnit", "equals", "", "other", "hashCode", "", "toCenturies", "toDays", "toDecades", "toDuration", "Ljava/time/Duration;", "toForever", "toHalfDays", "toHours", "toMicros", "toMillenniums", "toMillis", "toMinutes", "toNanos", "toNever", "toSeconds", "toString", "", "toWeeks", "toYears", "Companion", "kotlincommons"})
public final class KTime {
    private double value;
    @NotNull
    private KTimeUnit unit;
    @NotNull
    private static final KTime NEVER;
    @NotNull
    private static final KTime FOREVER;
    @NotNull
    public static final Companion Companion;

    public boolean equals(@Nullable Object other) {
        double convertedValue;
        if (!(other instanceof KTime)) {
            return false;
        }
        boolean bl = this.unit == ((KTime)other).unit ? this.unit == ((KTime)other).unit : (convertedValue = this.convertTo(((KTime)other).unit)) == ((KTime)other).value;
        return bl;
    }

    public int hashCode() {
        return HashCodeBuilder.Companion.builder(Reflection.getOrCreateKotlinClass(this.getClass())).append(this.value).append((Object)this.unit).hashCode();
    }

    @NotNull
    public String toString() {
        return ToStringBuilder.Companion.builder(Reflection.getOrCreateKotlinClass(this.getClass())).append("value", this.value).append("unit", this.unit).toString();
    }

    public final double toNever() {
        return Double.MIN_VALUE;
    }

    public final double toNanos() {
        return this.unit.convertTo(this.value, KTimeUnit.NANOSECOND);
    }

    public final double toMicros() {
        return this.unit.convertTo(this.value, KTimeUnit.MICROSECOND);
    }

    public final double toMillis() {
        return this.unit.convertTo(this.value, KTimeUnit.MILLISECOND);
    }

    public final double toSeconds() {
        return this.unit.convertTo(this.value, KTimeUnit.SECOND);
    }

    public final double toMinutes() {
        return this.unit.convertTo(this.value, KTimeUnit.MINUTE);
    }

    public final double toHours() {
        return this.unit.convertTo(this.value, KTimeUnit.HOUR);
    }

    public final double toHalfDays() {
        return this.unit.convertTo(this.value, KTimeUnit.HALF_DAY);
    }

    public final double toDays() {
        return this.unit.convertTo(this.value, KTimeUnit.DAY);
    }

    public final double toWeeks() {
        return this.unit.convertTo(this.value, KTimeUnit.WEEK);
    }

    public final double toYears() {
        return this.unit.convertTo(this.value, KTimeUnit.YEAR);
    }

    public final double toDecades() {
        return this.unit.convertTo(this.value, KTimeUnit.DECADE);
    }

    public final double toCenturies() {
        return this.unit.convertTo(this.value, KTimeUnit.CENTURY);
    }

    public final double toMillenniums() {
        return this.unit.convertTo(this.value, KTimeUnit.MILLENNIUM);
    }

    public final double toForever() {
        return Double.MAX_VALUE;
    }

    @NotNull
    public final Duration toDuration() {
        Duration duration = Duration.of((long)this.convertTo(KTimeUnit.NANOSECOND), ChronoUnit.NANOS);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"Duration.of(this.convert\u2026Long(), ChronoUnit.NANOS)");
        return duration;
    }

    public final double convertTo(@NotNull KTimeUnit otherUnit) {
        Intrinsics.checkNotNullParameter((Object)((Object)otherUnit), (String)"otherUnit");
        return this.unit.convertTo(this.value, otherUnit);
    }

    public final double getValue() {
        return this.value;
    }

    public final void setValue(double d) {
        this.value = d;
    }

    @NotNull
    public final KTimeUnit getUnit() {
        return this.unit;
    }

    public final void setUnit(@NotNull KTimeUnit kTimeUnit) {
        Intrinsics.checkNotNullParameter((Object)((Object)kTimeUnit), (String)"<set-?>");
        this.unit = kTimeUnit;
    }

    public KTime(double value, @NotNull KTimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        this.value = value;
        this.unit = unit;
        double d = this.value;
        boolean bl = false;
        if (Double.isNaN(d)) {
            throw (Throwable)new IllegalStateException("Expected a valid time value but got " + this.value + " instead.");
        }
        d = this.value;
        bl = false;
        if (Double.isInfinite(d)) {
            throw (Throwable)new IllegalStateException("Expected a finite value but got " + this.value + " instead.");
        }
    }

    static {
        Companion = new Companion(null);
        NEVER = new KTime(Double.MIN_VALUE, KTimeUnit.NEVER);
        FOREVER = new KTime(Double.MAX_VALUE, KTimeUnit.FOREVER);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\u0004R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\n"}, d2={"Lbvanseg/kotlincommons/time/api/KTime$Companion;", "", "()V", "FOREVER", "Lbvanseg/kotlincommons/time/api/KTime;", "getFOREVER", "()Lbvanseg/kotlincommons/time/api/KTime;", "NEVER", "getNEVER", "now", "kotlincommons"})
    public static final class Companion {
        @NotNull
        public final KTime getNEVER() {
            return NEVER;
        }

        @NotNull
        public final KTime getFOREVER() {
            return FOREVER;
        }

        @NotNull
        public final KTime now() {
            return new KTime(System.currentTimeMillis(), KTimeUnit.MILLISECOND);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

